"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalRuleTemplate = void 0;
const core_1 = require("@aws-cdk/core");
const directories_1 = require("./directories");
class ApprovalRuleTemplate extends core_1.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const { approvalRuleTemplateName, approvalRuleTemplateDescription, template } = props;
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::ApprovalRuleTemplate', {
            codeDirectory: directories_1.approvalRuleTemplateDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: [
                        'codecommit:CreateApprovalRuleTemplate',
                        'codecommit:DeleteApprovalRuleTemplate',
                        'codecommit:GetApprovalRuleTemplate',
                        'codecommit:UpdateApprovalRuleTemplateContent',
                        'codecommit:UpdateApprovalRuleTemplateDescription',
                        'codecommit:UpdateApprovalRuleTemplateName',
                    ],
                    Resource: '*',
                },
            ],
        });
        const resource = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::ApprovalRuleTemplate',
            properties: {
                ApprovalRuleTemplateName: approvalRuleTemplateName,
                ApprovalRuleTemplateDescription: approvalRuleTemplateDescription,
                Template: {
                    DestinationReferences: (_a = template.branches) === null || _a === void 0 ? void 0 : _a.map((branch) => `refs/heads/${branch}`),
                    Approvers: {
                        NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
                        ApprovalPoolMembers: template.approvers.approvalPoolMembers,
                    },
                },
            },
        });
        this.approvalRuleTemplateName = resource.getAttString('ApprovalRuleTemplateName');
    }
}
exports.ApprovalRuleTemplate = ApprovalRuleTemplate;
//# sourceMappingURL=data:application/json;base64,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