import * as cdk from '@aws-cdk/core';
import { IBucket } from './bucket';
import { Construct } from '@aws-cdk/core';
/**
 * Implemented by constructs that can be used as bucket notification destinations.
 *
 * @stability stable
 */
export interface IBucketNotificationDestination {
    /**
     * Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @param bucket The bucket object to bind to.
     * @stability stable
     */
    bind(scope: Construct, bucket: IBucket): BucketNotificationDestinationConfig;
}
/**
 * Represents the properties of a notification destination.
 *
 * @stability stable
 */
export interface BucketNotificationDestinationConfig {
    /**
     * The notification type.
     *
     * @stability stable
     */
    readonly type: BucketNotificationDestinationType;
    /**
     * The ARN of the destination (i.e. Lambda, SNS, SQS).
     *
     * @stability stable
     */
    readonly arn: string;
    /**
     * Any additional dependencies that should be resolved before the bucket notification can be configured (for example, the SNS Topic Policy resource).
     *
     * @stability stable
     */
    readonly dependencies?: cdk.IDependable[];
}
/**
 * Supported types of notification destinations.
 *
 * @stability stable
 */
export declare enum BucketNotificationDestinationType {
    /**
     * @stability stable
     */
    LAMBDA = 0,
    /**
     * @stability stable
     */
    QUEUE = 1,
    /**
     * @stability stable
     */
    TOPIC = 2
}
