#*=+--+=#=+--         SwiftCore Flight Management Software        --+=#=+--+=#*#
#               Copyright (C) 2020 Black Swift Technologies LLC.               #
#                             All Rights Reserved.                             #
#                                                                              #
#    NOTICE:  All information contained herein is, and remains the property    #
#    of Black Swift Technologies.                                              #
#                                                                              #
#    The intellectual and technical concepts contained herein are              #
#    proprietary to Black Swift Technologies LLC and may be covered by U.S.    #
#    and foreign patents, patents in process, and are protected by trade       #
#    secret or copyright law.                                                  #
#                                                                              #
#    Dissemination of this information or reproduction of this material is     #
#    strictly forbidden unless prior written permission is obtained from       #
#    Black Swift Technologies LLC.                                             #
#                                                                              #
#*=+--+=#=+--                 --+=#=+--+=#=+--                    --+=#=+--+=#*#

from enum import Enum
import struct

from .comm_packets import *

#                      THIS FILE IS AUTOGENERATED BY                           #
#                                 msg-gen.py                                   #
#                                DO NOT EDIT                                   #

#---------[ Actuators ]---------#

CAN_NUM_ACTUATORS = 16

#---------[ Comms ]---------#

class CAN_PacketTypes (Enum):
	# SENSORS

	CAN_PKT_PRESSURE=16
	CAN_PKT_AIR_DATA=17
	CAN_PKT_MHP=18
	CAN_PKT_MHP_RAW=19
	CAN_PKT_MHP_PRODUCTS=20
	CAN_PKT_WIND=21
	CAN_PKT_IMU=32
	CAN_PKT_ACCEL=33
	CAN_PKT_GYRO=34
	CAN_PKT_MAG=35
	CAN_PKT_ORIENTATION=36
	CAN_PKT_GNSS=48
	CAN_PKT_GNSS_UTC=49
	CAN_PKT_GNSS_LLA=50
	CAN_PKT_GNSS_VEL=51
	CAN_PKT_GNSS_HEALTH=52
	CAN_PKT_GNSS_UTC_W=53
	CAN_PKT_GNSS_RTCM=54
	CAN_PKT_GNSS_HEALTH_2=55
	CAN_PKT_GNSS_SVIN=56
	CAN_PKT_AGL=96
	CAN_PKT_PROXIMITY=112
	CAN_PKT_ADSB=144
	CAN_PKT_CALIBRATE=160
	CAN_PKT_BOARD_ORIENTATION=161
	CAN_PKT_GNSS_ORIENTATION=162

	# STATE


	# CONTROL

	CAN_PKT_DEPLOYMENT_TUBE_CMD=129

	# ACTUATORS

	CAN_PKT_ACTUATOR=2047

	# INPUT

	CAN_PKT_RECEIVER=1

	# SYSTEM

	CAN_PKT_SUPPLY=64
	CAN_PKT_POWER_ON=65
	CAN_PKT_REMOTE_ID=66
	CAN_PKT_ARM_RID=67
	CAN_PKT_SERIAL_ID=68

	# TELEMETRY

	CAN_PKT_DEPLOYMENT_TUBE=128
	CAN_PKT_GCS_LOCATION=176

	# HWIL


	# FLIGHT PLAN


	# VEHICLE CONFIGURATION


	# MISSION


	# PAYLOAD

	CAN_PKT_NDVI=80
	CAN_PKT_NDVI_DOWN=81
	CAN_PKT_NDVI_UP=82
	CAN_PKT_TRIGGER=83

	# ERRORS

#---------[ Control ]---------#

class CAN_DeploymentTubeState (Enum):
	DEPLOY_TUBE_INIT=0
	DEPLOY_TUBE_READY=1
	DEPLOY_TUBE_ARMED=2
	DEPLOY_TUBE_FLAP_OPEN=3
	DEPLOY_TUBE_PARA_DEPLOYED=4
	DEPLOY_TUBE_JETTISONED=5
	DEPLOY_TUBE_AC_RELASED=6
	DEPLOY_TUBE_SHUTDOWN=7
	DEPLOY_TUBE_ERROR=8

class CAN_DeploymentTubeCommand:
	SIZE = 8

	def __init__ (self, startByte = 0, id = 255, value = 0.0,
	chk = 0):
		self.startByte = startByte
		self.id = id
		self.value = value
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_DeploymentTubeCommand]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.id = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.value = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.id))
		buf.extend(struct.pack('<f', self.value))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ PAYLOAD ]---------#

class CAN_NDVI:
	SIZE = 20

	def __init__ (self, startByte = 0, id = 0, red = 0.0, near_ir = 0.0,
	ir_ambient = 0.0, ir_object = 0.0, chk = 0):
		self.startByte = startByte
		self.id = id
		self.red = red
		self.near_ir = near_ir
		self.ir_ambient = ir_ambient
		self.ir_object = ir_object
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_NDVI]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.id = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.red = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.near_ir = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.ir_ambient = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.ir_object = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.id))
		buf.extend(struct.pack('<f', self.red))
		buf.extend(struct.pack('<f', self.near_ir))
		buf.extend(struct.pack('<f', self.ir_ambient))
		buf.extend(struct.pack('<f', self.ir_object))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ SENSORS ]---------#

class CAN_ADSB:
	SIZE = 59

	def __init__ (self, startByte = 0, timestamp = 0.0, icao_address = 0,
	latitude = 0.0, longitude = 0.0, altitude_type = 0, altitude = 0.0,
	heading = 0.0, horizontal_velocity = 0.0, vertical_velocity = 0.0,
	callsign = [None] * 9, emitter_type = 0, tslc = 0, flags = 0, squawk = 0,
	chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.icao_address = icao_address
		self.latitude = latitude
		self.longitude = longitude
		self.altitude_type = altitude_type
		self.altitude = altitude
		self.heading = heading
		self.horizontal_velocity = horizontal_velocity
		self.vertical_velocity = vertical_velocity

		if (len(callsign) != 9):
			raise ValueError('array callsign expecting length '+str(9)+' got '+str(len(callsign)))

		self.callsign = list(callsign)

		self.emitter_type = emitter_type
		self.tslc = tslc
		self.flags = flags
		self.squawk = squawk
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_ADSB]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.icao_address = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.latitude = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.longitude = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.altitude_type = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.altitude = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.heading = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.horizontal_velocity = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.vertical_velocity = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.callsign = [];

		for i in range(0,9):
			self.callsign.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.emitter_type = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.tslc = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.flags = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.squawk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<I', self.icao_address))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<B', self.altitude_type))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.heading))
		buf.extend(struct.pack('<f', self.horizontal_velocity))
		buf.extend(struct.pack('<f', self.vertical_velocity))

		for val in self.callsign:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<B', self.emitter_type))
		buf.extend(struct.pack('<B', self.tslc))
		buf.extend(struct.pack('<H', self.flags))
		buf.extend(struct.pack('<H', self.squawk))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_AGL:
	SIZE = 15

	def __init__ (self, startByte = 0, timestamp = 0.0, distance = 0.0,
	velocity = 0.0, chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.distance = distance
		self.velocity = velocity
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_AGL]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.distance = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.velocity = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<f', self.distance))
		buf.extend(struct.pack('<f', self.velocity))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Accelerometer:
	SIZE = 19

	def __init__ (self, startByte = 0, ax = 0.0, ay = 0.0, az = 0.0,
	temp = 0.0, chk = 0):
		self.startByte = startByte
		self.ax = ax
		self.ay = ay
		self.az = az
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Accelerometer]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.ax = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.ay = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.az = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.temp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.ax))
		buf.extend(struct.pack('<f', self.ay))
		buf.extend(struct.pack('<f', self.az))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_AirData:
	SIZE = 19

	def __init__ (self, startByte = 0, static_pressure = 0.0,
	dynamic_pressure = 0.0, air_temperature = 0.0, humidity = 0.0, chk = 0):
		self.startByte = startByte
		self.static_pressure = static_pressure
		self.dynamic_pressure = dynamic_pressure
		self.air_temperature = air_temperature
		self.humidity = humidity
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_AirData]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.static_pressure = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.dynamic_pressure = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.air_temperature = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.humidity = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.static_pressure))
		buf.extend(struct.pack('<f', self.dynamic_pressure))
		buf.extend(struct.pack('<f', self.air_temperature))
		buf.extend(struct.pack('<f', self.humidity))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS:
	SIZE = 57

	def __init__ (self, startByte = 0, week = 0, hours = 0, minutes = 0,
	seconds = 0.0, latitude = 0.0, longitude = 0.0, altitude = 0.0,
	heading = 0.0, speed = 0.0, pdop = 0.0, satellites = 0, fix_type = 0,
	vx = 0.0, vy = 0.0, vz = 0.0, chk = 0):
		self.startByte = startByte
		self.week = week
		self.hours = hours
		self.minutes = minutes
		self.seconds = seconds
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.heading = heading
		self.speed = speed
		self.pdop = pdop
		self.satellites = satellites
		self.fix_type = fix_type
		self.vx = vx
		self.vy = vy
		self.vz = vz
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.week = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.hours = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.minutes = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.seconds = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.latitude = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.longitude = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.altitude = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.heading = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.speed = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.pdop = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.satellites = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.fix_type = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.vx = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.vy = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.vz = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<H', self.week))
		buf.extend(struct.pack('<B', self.hours))
		buf.extend(struct.pack('<B', self.minutes))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.heading))
		buf.extend(struct.pack('<f', self.speed))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<B', self.fix_type))
		buf.extend(struct.pack('<f', self.vx))
		buf.extend(struct.pack('<f', self.vy))
		buf.extend(struct.pack('<f', self.vz))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_HEALTH:
	SIZE = 8

	def __init__ (self, startByte = 0, pdop = 0.0, satellites = 0, chk = 0):
		self.startByte = startByte
		self.pdop = pdop
		self.satellites = satellites
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_HEALTH]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.pdop = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.satellites = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_HEALTH_2:
	SIZE = 11

	def __init__ (self, startByte = 0, pdop = 0.0, satellites = 0,
	fix_type = 0, buffer = [None] * 2, chk = 0):
		self.startByte = startByte
		self.pdop = pdop
		self.satellites = satellites
		self.fix_type = fix_type

		if (len(buffer) != 2):
			raise ValueError('array buffer expecting length '+str(2)+' got '+str(len(buffer)))

		self.buffer = list(buffer)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_HEALTH_2]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.pdop = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.satellites = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.fix_type = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.buffer = [];

		for i in range(0,2):
			self.buffer.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<B', self.fix_type))

		for val in self.buffer:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_VEL:
	SIZE = 23

	def __init__ (self, startByte = 0, heading = 0.0, speed = 0.0, vx = 0.0,
	vy = 0.0, vz = 0.0, chk = 0):
		self.startByte = startByte
		self.heading = heading
		self.speed = speed
		self.vx = vx
		self.vy = vy
		self.vz = vz
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_VEL]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.heading = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.speed = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.vx = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.vy = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.vz = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.heading))
		buf.extend(struct.pack('<f', self.speed))
		buf.extend(struct.pack('<f', self.vx))
		buf.extend(struct.pack('<f', self.vy))
		buf.extend(struct.pack('<f', self.vz))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Gyroscope:
	SIZE = 19

	def __init__ (self, startByte = 0, gx = 0.0, gy = 0.0, gz = 0.0,
	temp = 0.0, chk = 0):
		self.startByte = startByte
		self.gx = gx
		self.gy = gy
		self.gz = gz
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Gyroscope]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.gx = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.gy = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.gz = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.temp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.gx))
		buf.extend(struct.pack('<f', self.gy))
		buf.extend(struct.pack('<f', self.gz))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_IMU:
	SIZE = 43

	def __init__ (self, startByte = 0, ax = 0.0, ay = 0.0, az = 0.0, gx = 0.0,
	gy = 0.0, gz = 0.0, mx = 0.0, my = 0.0, mz = 0.0, temp = 0.0, chk = 0):
		self.startByte = startByte
		self.ax = ax
		self.ay = ay
		self.az = az
		self.gx = gx
		self.gy = gy
		self.gz = gz
		self.mx = mx
		self.my = my
		self.mz = mz
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_IMU]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.ax = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.ay = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.az = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.gx = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.gy = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.gz = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.mx = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.my = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.mz = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.temp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.ax))
		buf.extend(struct.pack('<f', self.ay))
		buf.extend(struct.pack('<f', self.az))
		buf.extend(struct.pack('<f', self.gx))
		buf.extend(struct.pack('<f', self.gy))
		buf.extend(struct.pack('<f', self.gz))
		buf.extend(struct.pack('<f', self.mx))
		buf.extend(struct.pack('<f', self.my))
		buf.extend(struct.pack('<f', self.mz))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_MHP:
	SIZE = 57

	def __init__ (self, startByte = 0, system_time = 0, static_pressure = 0,
	dynamic_pressure = [None] * 5, air_temperature = 0, humidity = 0,
	gyroscope = [None] * 3, accelerometer = [None] * 3,
	magnetometer = [None] * 3, alpha = 0, beta = 0, chk = 0):
		self.startByte = startByte
		self.system_time = system_time
		self.static_pressure = static_pressure

		if (len(dynamic_pressure) != 5):
			raise ValueError('array dynamic_pressure expecting length '+str(5)+' got '+str(len(dynamic_pressure)))

		self.dynamic_pressure = list(dynamic_pressure)

		self.air_temperature = air_temperature
		self.humidity = humidity

		if (len(gyroscope) != 3):
			raise ValueError('array gyroscope expecting length '+str(3)+' got '+str(len(gyroscope)))

		self.gyroscope = list(gyroscope)

		if (len(accelerometer) != 3):
			raise ValueError('array accelerometer expecting length '+str(3)+' got '+str(len(accelerometer)))

		self.accelerometer = list(accelerometer)

		if (len(magnetometer) != 3):
			raise ValueError('array magnetometer expecting length '+str(3)+' got '+str(len(magnetometer)))

		self.magnetometer = list(magnetometer)

		self.alpha = alpha
		self.beta = beta
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_MHP]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.system_time = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.static_pressure = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.dynamic_pressure = [];

		for i in range(0,5):
			self.dynamic_pressure.append(struct.unpack_from('<i',buf,offset)[0])
			offset = offset+struct.calcsize('<i')

		self.air_temperature = struct.unpack_from('<h',buf,offset)[0]
		offset = offset + struct.calcsize('<h')

		self.humidity = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.gyroscope = [];

		for i in range(0,3):
			self.gyroscope.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

		self.accelerometer = [];

		for i in range(0,3):
			self.accelerometer.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

		self.magnetometer = [];

		for i in range(0,3):
			self.magnetometer.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

		self.alpha = struct.unpack_from('<h',buf,offset)[0]
		offset = offset + struct.calcsize('<h')

		self.beta = struct.unpack_from('<h',buf,offset)[0]
		offset = offset + struct.calcsize('<h')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<I', self.system_time))
		buf.extend(struct.pack('<I', self.static_pressure))

		for val in self.dynamic_pressure:
		    buf.extend(struct.pack('<i', val))

		buf.extend(struct.pack('<h', self.air_temperature))
		buf.extend(struct.pack('<H', self.humidity))

		for val in self.gyroscope:
		    buf.extend(struct.pack('<h', val))

		for val in self.accelerometer:
		    buf.extend(struct.pack('<h', val))

		for val in self.magnetometer:
		    buf.extend(struct.pack('<h', val))

		buf.extend(struct.pack('<h', self.alpha))
		buf.extend(struct.pack('<h', self.beta))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_MHP_Products:
	SIZE = 19

	def __init__ (self, startByte = 0, alpha = 0.0, beta = 0.0, ias = 0.0,
	tas = 0.0, chk = 0):
		self.startByte = startByte
		self.alpha = alpha
		self.beta = beta
		self.ias = ias
		self.tas = tas
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_MHP_Products]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.alpha = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.beta = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.ias = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.tas = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.alpha))
		buf.extend(struct.pack('<f', self.beta))
		buf.extend(struct.pack('<f', self.ias))
		buf.extend(struct.pack('<f', self.tas))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_MHP_Raw:
	SIZE = 23

	def __init__ (self, startByte = 0, differential_pressure = [None] * 5,
	chk = 0):
		self.startByte = startByte

		if (len(differential_pressure) != 5):
			raise ValueError('array differential_pressure expecting length '+str(5)+' got '+str(len(differential_pressure)))

		self.differential_pressure = list(differential_pressure)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_MHP_Raw]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.differential_pressure = [];

		for i in range(0,5):
			self.differential_pressure.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.differential_pressure:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Magnetometer:
	SIZE = 15

	def __init__ (self, startByte = 0, mx = 0.0, my = 0.0, mz = 0.0,
	chk = 0):
		self.startByte = startByte
		self.mx = mx
		self.my = my
		self.mz = mz
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Magnetometer]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.mx = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.my = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.mz = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.mx))
		buf.extend(struct.pack('<f', self.my))
		buf.extend(struct.pack('<f', self.mz))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Orientation:
	SIZE = 19

	def __init__ (self, startByte = 0, q = [None] * 4, chk = 0):
		self.startByte = startByte

		if (len(q) != 4):
			raise ValueError('array q expecting length '+str(4)+' got '+str(len(q)))

		self.q = list(q)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Orientation]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.q = [];

		for i in range(0,4):
			self.q.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.q:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Pressure:
	SIZE = 15

	def __init__ (self, startByte = 0, pressureSta = 0.0, pressureDyn = 0.0,
	temp = 0.0, chk = 0):
		self.startByte = startByte
		self.pressureSta = pressureSta
		self.pressureDyn = pressureDyn
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Pressure]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.pressureSta = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.pressureDyn = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.temp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.pressureSta))
		buf.extend(struct.pack('<f', self.pressureDyn))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Proximity:
	SIZE = 15

	def __init__ (self, startByte = 0, timestamp = 0.0, distance = 0.0,
	velocity = 0.0, chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.distance = distance
		self.velocity = velocity
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Proximity]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.distance = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.velocity = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<f', self.distance))
		buf.extend(struct.pack('<f', self.velocity))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Trigger:
	SIZE = 10

	def __init__ (self, startByte = 0, timestamp = 0.0, id = 0, channel = 0,
	chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.id = id
		self.channel = channel
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Trigger]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.id = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.channel = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<H', self.id))
		buf.extend(struct.pack('<B', self.channel))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Wind:
	SIZE = 15

	def __init__ (self, startByte = 0, u = 0.0, v = 0.0, w = 0.0, chk = 0):
		self.startByte = startByte
		self.u = u
		self.v = v
		self.w = w
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Wind]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.u = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.v = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.w = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.u))
		buf.extend(struct.pack('<f', self.v))
		buf.extend(struct.pack('<f', self.w))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ SYSTEM ]---------#

class CAN_Supply:
	SIZE = 19

	def __init__ (self, startByte = 0, voltage = 0.0, current = 0.0,
	coulomb_count = 0.0, temperature = 0.0, chk = 0):
		self.startByte = startByte
		self.voltage = voltage
		self.current = current
		self.coulomb_count = coulomb_count
		self.temperature = temperature
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Supply]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.voltage = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.current = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.coulomb_count = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.temperature = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.voltage))
		buf.extend(struct.pack('<f', self.current))
		buf.extend(struct.pack('<f', self.coulomb_count))
		buf.extend(struct.pack('<f', self.temperature))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ Sensors ]---------#

class CAN_CalibrationState (Enum):
	CAN_CAL_UNKNOWN=0
	CAN_REQUESTED=1
	CAN_SENT=2
	CAN_CALIBRATED=3

class CAN_SensorType (Enum):
	CAN_ACCELEROMETER=0
	CAN_GYROSCOPE=1
	CAN_MAGNETOMETER=2
	CAN_DYNAMIC_PRESSURE=3
	CAN_STATIC_PRESSURE=4
	CAN_TEMPERATURE=5
	CAN_HUMIDITY=6
	CAN_AGL=7
	CAN_GPS=8
	CAN_SENSOR_PAYLOAD_1=9
	CAN_SENSOR_PAYLOAD_2=10
	CAN_SENSOR_PAYLOAD_3=11
	CAN_SENSOR_PAYLOAD_4=12
	CAN_SENSOR_PAYLOAD_5=13
	CAN_UNKNOWN_SENSOR=14

class CAN_AxisMapping:
	SIZE = 6

	def __init__ (self, startByte = 0, axis = [None] * 3, chk = 0):
		self.startByte = startByte

		if (len(axis) != 3):
			raise ValueError('array axis expecting length '+str(3)+' got '+str(len(axis)))

		self.axis = list(axis)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_AxisMapping]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.axis = [];

		for i in range(0,3):
			self.axis.append(struct.unpack_from('<b',buf,offset)[0])
			offset = offset+struct.calcsize('<b')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.axis:
		    buf.extend(struct.pack('<b', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_CalibrateSensor:
	SIZE = 5

	def __init__ (self, startByte = 0,
	sensor = CAN_SensorType.CAN_UNKNOWN_SENSOR,
	state = CAN_CalibrationState.CAN_CAL_UNKNOWN, chk = 0):
		self.startByte = startByte

		self.sensor = CAN_SensorType(sensor)

		self.state = CAN_CalibrationState(state)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_CalibrateSensor]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.sensor = CAN_SensorType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.state = CAN_CalibrationState(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		buf.put(CAN_SensorType.encode(self.sensor));

		buf.put(CAN_CalibrationState.encode(self.state));

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ Status ]---------#

class CAN_DeploymentTubeCommandID (Enum):
	CMD_HEARTBEAT=0
	CMD_SET_STATE=1

class CAN_DeploymentTubeDoorStatus (Enum):
	CLOSED=0
	OPEN=1

class CAN_DeploymentTubeErrors (Enum):
	DEPLOY_TUBE_ERROR_NO_ERROR=0
	DEPLOY_TUBE_ERROR_LOW_BATT=1
	DEPLOY_TUBE_ERROR_HIGH_VOLTAGE=2
	DEPLOY_TUBE_ERROR_NO_BATT=4
	DEPLOY_TUBE_ERROR_HIGH_CURRENT=8
	DEPLOY_TUBE_ERROR_HIGH_TEMP=16
	DEPLOY_TUBE_ERROR_CHUTE_FLAP_OPEN=32
	DEPLOY_TUBE_ERROR_CHUTE_FLAP_CLOSED=64
	DEPLOY_TUBE_ERROR_NO_UA_COMMS=128

#---------[ System ]---------#

class CAN_PowerOn:
	SIZE = 9

	def __init__ (self, startByte = 0, comms_rev = 0, serial_num = 0, chk = 0):
		self.startByte = startByte
		self.comms_rev = comms_rev
		self.serial_num = serial_num
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_PowerOn]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.comms_rev = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.serial_num = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<H', self.comms_rev))
		buf.extend(struct.pack('<I', self.serial_num))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_LLA:
	SIZE = 23

	def __init__ (self, startByte = 0, latitude = 0.0, longitude = 0.0,
	altitude = 0.0, chk = 0):
		self.startByte = startByte
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_LLA]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.latitude = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.longitude = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.altitude = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_RTCM:
	SIZE = 68

	def __init__ (self, startByte = 0, size = 0, payload = [None] * 64,
	chk = 0):
		self.startByte = startByte
		self.size = size

		if (len(payload) != 64):
			raise ValueError('array payload expecting length '+str(64)+' got '+str(len(payload)))

		self.payload = list(payload)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_RTCM]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.size = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.payload = [];

		for i in range(0,64):
			self.payload.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.size))

		for val in self.payload:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_SVIN:
	SIZE = 20

	def __init__ (self, startByte = 0, time_elapsed = 0, time_minimum = 0,
	accuracy = 0.0, accuracy_minimum = 0.0, flags = 0, chk = 0):
		self.startByte = startByte
		self.time_elapsed = time_elapsed
		self.time_minimum = time_minimum
		self.accuracy = accuracy
		self.accuracy_minimum = accuracy_minimum
		self.flags = flags
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_SVIN]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.time_elapsed = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.time_minimum = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.accuracy = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.accuracy_minimum = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.flags = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<I', self.time_elapsed))
		buf.extend(struct.pack('<I', self.time_minimum))
		buf.extend(struct.pack('<f', self.accuracy))
		buf.extend(struct.pack('<f', self.accuracy_minimum))
		buf.extend(struct.pack('<B', self.flags))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_UTC:
	SIZE = 9

	def __init__ (self, startByte = 0, hours = 0, minutes = 0, seconds = 0.0,
	chk = 0):
		self.startByte = startByte
		self.hours = hours
		self.minutes = minutes
		self.seconds = seconds
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_UTC]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.hours = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.minutes = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.seconds = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.hours))
		buf.extend(struct.pack('<B', self.minutes))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_UTC_W:
	SIZE = 11

	def __init__ (self, startByte = 0, week = 0, hours = 0, minutes = 0,
	seconds = 0.0, chk = 0):
		self.startByte = startByte
		self.week = week
		self.hours = hours
		self.minutes = minutes
		self.seconds = seconds
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_UTC_W]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.week = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.hours = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.minutes = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.seconds = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<H', self.week))
		buf.extend(struct.pack('<B', self.hours))
		buf.extend(struct.pack('<B', self.minutes))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ ACTUATORS ]---------#

class CAN_Actuator:
	SIZE = 35

	def __init__ (self, startByte = 0, usec = [None] * 16, chk = 0):
		self.startByte = startByte

		if (len(usec) != 16):
			raise ValueError('array usec expecting length '+str(16)+' got '+str(len(usec)))

		self.usec = list(usec)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Actuator]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.usec = [];

		for i in range(0,16):
			self.usec.append(struct.unpack_from('<H',buf,offset)[0])
			offset = offset+struct.calcsize('<H')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.usec:
		    buf.extend(struct.pack('<H', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ INPUT ]---------#

class CAN_Receiver:
	SIZE = 35

	def __init__ (self, startByte = 0, usec = [None] * 16, chk = 0):
		self.startByte = startByte

		if (len(usec) != 16):
			raise ValueError('array usec expecting length '+str(16)+' got '+str(len(usec)))

		self.usec = list(usec)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Receiver]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.usec = [];

		for i in range(0,16):
			self.usec.append(struct.unpack_from('<H',buf,offset)[0])
			offset = offset+struct.calcsize('<H')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.usec:
		    buf.extend(struct.pack('<H', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ Telemetry ]---------#

class CAN_ArmRemoteID:
	SIZE = 4

	def __init__ (self, startByte = 0, armed = 0, chk = 0):
		self.startByte = startByte
		self.armed = armed
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_ArmRemoteID]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.armed = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.armed))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_DeploymentTube:
	SIZE = 7

	def __init__ (self, startByte = 0,
	state = CAN_DeploymentTubeState(0),
	parachute_door = CAN_DeploymentTubeDoorStatus(0), batt_voltage = 0,
	error = CAN_DeploymentTubeErrors(0), chk = 0):
		self.startByte = startByte

		self.state = CAN_DeploymentTubeState(state)

		self.parachute_door = CAN_DeploymentTubeDoorStatus(parachute_door)

		self.batt_voltage = batt_voltage

		self.error = CAN_DeploymentTubeErrors(error)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_DeploymentTube]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.state = CAN_DeploymentTubeState(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.parachute_door = CAN_DeploymentTubeDoorStatus(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.batt_voltage = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.error = CAN_DeploymentTubeErrors(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		buf.put(CAN_DeploymentTubeState.encode(self.state));

		buf.put(CAN_DeploymentTubeDoorStatus.encode(self.parachute_door));

		buf.extend(struct.pack('<B', self.batt_voltage))

		buf.put(CAN_DeploymentTubeErrors.encode(self.error));

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GCSLocation:
	SIZE = 23

	def __init__ (self, startByte = 0, lat = 0.0, lon = 0.0, altitude = 0.0,
	chk = 0):
		self.startByte = startByte
		self.lat = lat
		self.lon = lon
		self.altitude = altitude
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GCSLocation]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.lat = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.lon = struct.unpack_from('<d',buf,offset)[0]
		offset = offset + struct.calcsize('<d')

		self.altitude = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<d', self.lat))
		buf.extend(struct.pack('<d', self.lon))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_OperatorID:
	SIZE = 23

	def __init__ (self, startByte = 0, operator_id = [None] * 20, chk = 0):
		self.startByte = startByte

		if (len(operator_id) != 20):
			raise ValueError('array operator_id expecting length '+str(20)+' got '+str(len(operator_id)))

		self.operator_id = list(operator_id)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_OperatorID]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.operator_id = [];

		for i in range(0,20):
			self.operator_id.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.operator_id:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_RemoteID:
	SIZE = 7

	def __init__ (self, startByte = 0, aircraft_type = 0, base_mode = 0,
	state = 0, autopilot_type = 0, chk = 0):
		self.startByte = startByte
		self.aircraft_type = aircraft_type
		self.base_mode = base_mode
		self.state = state
		self.autopilot_type = autopilot_type
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_RemoteID]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.aircraft_type = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.base_mode = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.state = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.autopilot_type = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.aircraft_type))
		buf.extend(struct.pack('<B', self.base_mode))
		buf.extend(struct.pack('<B', self.state))
		buf.extend(struct.pack('<B', self.autopilot_type))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_SerialNumber:
	SIZE = 23

	def __init__ (self, startByte = 0, serial_number = [None] * 20,
	chk = 0):
		self.startByte = startByte

		if (len(serial_number) != 20):
			raise ValueError('array serial_number expecting length '+str(20)+' got '+str(len(serial_number)))

		self.serial_number = list(serial_number)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_SerialNumber]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.serial_number = [];

		for i in range(0,20):
			self.serial_number.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def set_system_time(self, sys_time):
		self.system_time = sys_time

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.serial_number:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)
