/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./build/commands.js":
/*!***************************!*\
  !*** ./build/commands.js ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COMMAND_IDS: () => (/* binding */ COMMAND_IDS),
/* harmony export */   setupCommands: () => (/* binding */ setupCommands)
/* harmony export */ });
/* harmony import */ var _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/documentsearch */ "./node_modules/@jupyterlab/documentsearch/lib/searchmodel.js");
/* harmony import */ var _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/documentsearch */ "./node_modules/@jupyterlab/documentsearch/lib/searchview.js");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/notebook */ "./node_modules/@jupyterlab/notebook/lib/searchprovider.js");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/notebook */ "./node_modules/@jupyterlab/notebook/lib/actions.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */





/**
 * The map of command ids used by the notebook.
 */
const COMMAND_IDS = {
    invoke: 'completer:invoke',
    select: 'completer:select',
    invokeNotebook: 'completer:invoke-notebook',
    selectNotebook: 'completer:select-notebook',
    startSearch: 'documentsearch:start-search',
    findNext: 'documentsearch:find-next',
    findPrevious: 'documentsearch:find-previous',
    save: 'notebook:save',
    interrupt: 'notebook:interrupt-kernel',
    restart: 'notebook:restart-kernel',
    switchKernel: 'notebook:switch-kernel',
    runAndAdvance: 'notebook-cells:run-and-advance',
    run: 'notebook:run-cell',
    deleteCell: 'notebook-cells:delete',
    selectAbove: 'notebook-cells:select-above',
    selectBelow: 'notebook-cells:select-below',
    extendAbove: 'notebook-cells:extend-above',
    extendTop: 'notebook-cells:extend-top',
    extendBelow: 'notebook-cells:extend-below',
    extendBottom: 'notebook-cells:extend-bottom',
    editMode: 'notebook:edit-mode',
    merge: 'notebook-cells:merge',
    split: 'notebook-cells:split',
    commandMode: 'notebook:command-mode',
    undo: 'notebook-cells:undo',
    redo: 'notebook-cells:redo',
    insert: 'notebook-cells:insert',
    cut: 'notebook-cells:cut',
    copy: 'notebook-cells:copy',
    paste: 'notebook-cells:paste',
    restartAndRun: 'notebook:restart-and-run'
};
const setupCommands = (commands, palette, nbWidget, handler, sessionContextDialogs) => {
    // Add commands.
    commands.addCommand(COMMAND_IDS.invoke, {
        label: 'Completer: Invoke',
        execute: () => handler.invoke()
    });
    commands.addCommand(COMMAND_IDS.select, {
        label: 'Completer: Select',
        execute: () => handler.completer.selectActive()
    });
    commands.addCommand(COMMAND_IDS.invokeNotebook, {
        label: 'Invoke Notebook',
        execute: () => {
            var _a;
            if (((_a = nbWidget.content.activeCell) === null || _a === void 0 ? void 0 : _a.model.type) === 'code') {
                return commands.execute(COMMAND_IDS.invoke);
            }
        }
    });
    commands.addCommand(COMMAND_IDS.selectNotebook, {
        label: 'Select Notebook',
        execute: () => {
            var _a;
            if (((_a = nbWidget.content.activeCell) === null || _a === void 0 ? void 0 : _a.model.type) === 'code') {
                return commands.execute(COMMAND_IDS.select);
            }
        }
    });
    commands.addCommand(COMMAND_IDS.save, {
        label: args => (args.toolbar ? '' : 'Save'),
        caption: 'Save',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.saveIcon : undefined),
        execute: () => nbWidget.context.save()
    });
    let searchInstance;
    commands.addCommand(COMMAND_IDS.startSearch, {
        label: 'Find…',
        execute: () => {
            if (!searchInstance) {
                const provider = new _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_3__.NotebookSearchProvider(nbWidget, _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator);
                const searchModel = new _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_4__.SearchDocumentModel(provider, 500);
                searchInstance = new _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_5__.SearchDocumentView(searchModel);
                /**
                 * Activate the target widget when the search panel is closing
                 */
                searchInstance.closed.connect(() => {
                    if (!nbWidget.isDisposed) {
                        nbWidget.activate();
                    }
                });
                searchInstance.disposed.connect(() => {
                    if (!nbWidget.isDisposed) {
                        nbWidget.activate();
                    }
                    // find next and previous are now disabled
                    commands.notifyCommandChanged(COMMAND_IDS.startSearch);
                });
                /**
                 * Dispose resources when the widget is disposed.
                 */
                nbWidget.disposed.connect(() => {
                    searchInstance === null || searchInstance === void 0 ? void 0 : searchInstance.dispose();
                    searchModel.dispose();
                    provider.dispose();
                });
            }
            if (!searchInstance.isAttached) {
                _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget.attach(searchInstance, nbWidget.node);
                searchInstance.node.style.top = `${nbWidget.toolbar.node.getBoundingClientRect().height +
                    nbWidget.contentHeader.node.getBoundingClientRect().height}px`;
                if (searchInstance.model.searchExpression) {
                    searchInstance.model.refresh();
                }
            }
            searchInstance.focusSearchInput();
        }
    });
    commands.addCommand(COMMAND_IDS.findNext, {
        label: 'Find Next',
        isEnabled: () => !!searchInstance,
        execute: async () => {
            if (!searchInstance) {
                return;
            }
            await searchInstance.model.highlightNext();
        }
    });
    commands.addCommand(COMMAND_IDS.findPrevious, {
        label: 'Find Previous',
        isEnabled: () => !!searchInstance,
        execute: async () => {
            if (!searchInstance) {
                return;
            }
            await searchInstance.model.highlightPrevious();
        }
    });
    commands.addCommand(COMMAND_IDS.interrupt, {
        label: args => (args.toolbar ? '' : 'Interrupt'),
        caption: 'Interrupt the kernel',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.stopIcon : undefined),
        execute: async () => { var _a, _b; return (_b = (_a = nbWidget.context.sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.interrupt(); }
    });
    commands.addCommand(COMMAND_IDS.restart, {
        label: args => (args.toolbar ? '' : 'Restart Kernel'),
        caption: 'Restart the kernel',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.refreshIcon : undefined),
        execute: () => sessionContextDialogs.restart(nbWidget.context.sessionContext)
    });
    commands.addCommand(COMMAND_IDS.switchKernel, {
        label: 'Switch Kernel',
        execute: () => sessionContextDialogs.selectKernel(nbWidget.context.sessionContext)
    });
    commands.addCommand(COMMAND_IDS.runAndAdvance, {
        label: args => (args.toolbar ? '' : 'Run and Advance'),
        caption: 'Run the selected cells and advance.',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.runIcon : undefined),
        execute: () => {
            return _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.runAndAdvance(nbWidget.content, nbWidget.context.sessionContext, sessionContextDialogs);
        }
    });
    commands.addCommand(COMMAND_IDS.run, {
        label: 'Run',
        execute: () => {
            return _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.run(nbWidget.content, nbWidget.context.sessionContext, sessionContextDialogs);
        }
    });
    commands.addCommand(COMMAND_IDS.editMode, {
        label: 'Edit Mode',
        execute: () => {
            nbWidget.content.mode = 'edit';
        }
    });
    commands.addCommand(COMMAND_IDS.commandMode, {
        label: 'Command Mode',
        execute: () => {
            nbWidget.content.mode = 'command';
        }
    });
    commands.addCommand(COMMAND_IDS.selectBelow, {
        label: 'Select Below',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.selectBelow(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.selectAbove, {
        label: 'Select Above',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.selectAbove(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.extendAbove, {
        label: 'Extend Above',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.extendSelectionAbove(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.extendTop, {
        label: 'Extend to Top',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.extendSelectionAbove(nbWidget.content, true)
    });
    commands.addCommand(COMMAND_IDS.extendBelow, {
        label: 'Extend Below',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.extendSelectionBelow(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.extendBottom, {
        label: 'Extend to Bottom',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.extendSelectionBelow(nbWidget.content, true)
    });
    commands.addCommand(COMMAND_IDS.merge, {
        label: 'Merge Cells',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.mergeCells(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.split, {
        label: 'Split Cell',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.splitCell(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.undo, {
        label: 'Undo',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.undo(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.redo, {
        label: 'Redo',
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.redo(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.insert, {
        label: args => (args.toolbar ? '' : 'Insert a cell below'),
        caption: 'Insert a cell below',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.addIcon : undefined),
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.insertBelow(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.deleteCell, {
        label: args => (args.toolbar ? '' : 'Delete the selected cells'),
        caption: 'Delete the selected cells',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.deleteIcon : undefined),
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.deleteCells(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.cut, {
        label: args => (args.toolbar ? '' : 'Cut the selected cells'),
        caption: 'Cut the selected cells',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.cutIcon : undefined),
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.cut(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.copy, {
        label: args => (args.toolbar ? '' : 'Copy the selected cells'),
        caption: 'Copy the selected cells',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.copyIcon : undefined),
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.copy(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.paste, {
        label: args => (args.toolbar ? '' : 'Paste cells from the clipboard'),
        caption: 'Paste cells from the clipboard',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.pasteIcon : undefined),
        execute: () => _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.paste(nbWidget.content)
    });
    commands.addCommand(COMMAND_IDS.restartAndRun, {
        label: args => args.toolbar ? '' : 'Restart the kernel, then re-run the whole notebook',
        caption: 'Restart the kernl, then re-run the whole notebook',
        icon: args => (args.toolbar ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.fastForwardIcon : undefined),
        execute: () => {
            void sessionContextDialogs
                .restart(nbWidget.sessionContext)
                .then(restarted => {
                if (restarted) {
                    void _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_6__.NotebookActions.runAll(nbWidget.content, nbWidget.sessionContext, sessionContextDialogs);
                }
                return restarted;
            });
        }
    });
    let category = 'Notebook Operations';
    [
        COMMAND_IDS.interrupt,
        COMMAND_IDS.restart,
        COMMAND_IDS.editMode,
        COMMAND_IDS.commandMode,
        COMMAND_IDS.switchKernel,
        COMMAND_IDS.startSearch,
        COMMAND_IDS.findNext,
        COMMAND_IDS.findPrevious
    ].forEach(command => palette.addItem({ command, category }));
    category = 'Notebook Cell Operations';
    [
        COMMAND_IDS.runAndAdvance,
        COMMAND_IDS.run,
        COMMAND_IDS.split,
        COMMAND_IDS.merge,
        COMMAND_IDS.selectAbove,
        COMMAND_IDS.selectBelow,
        COMMAND_IDS.extendAbove,
        COMMAND_IDS.extendBelow,
        COMMAND_IDS.undo,
        COMMAND_IDS.redo
    ].forEach(command => palette.addItem({ command, category }));
    const bindings = [
        {
            selector: '.jp-Notebook.jp-mod-editMode .jp-mod-completer-enabled',
            keys: ['Tab'],
            command: COMMAND_IDS.invokeNotebook
        },
        {
            selector: `.jp-mod-completer-active`,
            keys: ['Enter'],
            command: COMMAND_IDS.selectNotebook
        },
        {
            selector: '.jp-Notebook',
            keys: ['Ctrl Enter'],
            command: COMMAND_IDS.run
        },
        {
            selector: '.jp-Notebook',
            keys: ['Shift Enter'],
            command: COMMAND_IDS.runAndAdvance
        },
        {
            selector: '.jp-Notebook',
            keys: ['Accel S'],
            command: COMMAND_IDS.save
        },
        {
            selector: '.jp-Notebook',
            keys: ['Accel F'],
            command: COMMAND_IDS.startSearch
        },
        {
            selector: '.jp-Notebook',
            keys: ['Accel G'],
            command: COMMAND_IDS.findNext
        },
        {
            selector: '.jp-Notebook',
            keys: ['Accel Shift G'],
            command: COMMAND_IDS.findPrevious
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['I', 'I'],
            command: COMMAND_IDS.interrupt
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['0', '0'],
            command: COMMAND_IDS.restart
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['Enter'],
            command: COMMAND_IDS.editMode
        },
        {
            selector: '.jp-Notebook.jp-mod-editMode',
            keys: ['Escape'],
            command: COMMAND_IDS.commandMode
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['Shift M'],
            command: COMMAND_IDS.merge
        },
        {
            selector: '.jp-Notebook.jp-mod-editMode',
            keys: ['Ctrl Shift -'],
            command: COMMAND_IDS.split
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['J'],
            command: COMMAND_IDS.selectBelow
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['ArrowDown'],
            command: COMMAND_IDS.selectBelow
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['K'],
            command: COMMAND_IDS.selectAbove
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['ArrowUp'],
            command: COMMAND_IDS.selectAbove
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['Shift K'],
            command: COMMAND_IDS.extendAbove
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['Shift J'],
            command: COMMAND_IDS.extendBelow
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['Z'],
            command: COMMAND_IDS.undo
        },
        {
            selector: '.jp-Notebook.jp-mod-commandMode:focus',
            keys: ['Y'],
            command: COMMAND_IDS.redo
        }
    ];
    bindings.map(binding => commands.addKeyBinding(binding));
};
/**
 * Set up keyboard shortcuts & commands for notebook
 */
// import { CommandRegistry } from '@lumino/commands';
// import { SessionContextDialogs } from '@jupyterlab/apputils';
// import { CompletionHandler } from '@jupyterlab/completer';
// import { NotebookActions, NotebookPanel } from '@jupyterlab/notebook';
// import {
//   NotebookSearchProvider,
//   SearchInstance
// } from '@jupyterlab/documentsearch';
//  import { CommandPalette } from '@lumino/widgets';
// /**
//  * The map of command ids used by the notebook.
//  */
// const cmdIds = {
//   invoke: 'completer:invoke',
//   select: 'completer:select',
//   invokeNotebook: 'completer:invoke-notebook',
//   selectNotebook: 'completer:select-notebook',
//   startSearch: 'documentsearch:start-search',
//   findNext: 'documentsearch:find-next',
//   findPrevious: 'documentsearch:find-previous',
//   save: 'notebook:save',
//   interrupt: 'notebook:interrupt-kernel',
//   restart: 'notebook:restart-kernel',
//   switchKernel: 'notebook:switch-kernel',
//   runAndAdvance: 'notebook-cells:run-and-advance',
//   run: 'notebook:run-cell',
//   deleteCell: 'notebook-cells:delete',
//   selectAbove: 'notebook-cells:select-above',
//   selectBelow: 'notebook-cells:select-below',
//   extendAbove: 'notebook-cells:extend-above',
//   extendTop: 'notebook-cells:extend-top',
//   extendBelow: 'notebook-cells:extend-below',
//   extendBottom: 'notebook-cells:extend-bottom',
//   editMode: 'notebook:edit-mode',
//   merge: 'notebook-cells:merge',
//   split: 'notebook-cells:split',
//   commandMode: 'notebook:command-mode',
//   undo: 'notebook-cells:undo',
//   redo: 'notebook-cells:redo'
// };
// export const SetupCommands = (
//   commands: CommandRegistry,
//   // palette: CommandPalette,
//   nbWidget: NotebookPanel,
//   handler: CompletionHandler
// ) => {
//   // Add commands.
//   commands.addCommand(cmdIds.invoke, {
//     label: 'Completer: Invoke',
//     execute: () => handler.invoke()
//   });
//   commands.addCommand(cmdIds.select, {
//     label: 'Completer: Select',
//     execute: () => handler.completer.selectActive()
//   });
//   commands.addCommand(cmdIds.invokeNotebook, {
//     label: 'Invoke Notebook',
//     execute: () => {
//       if (nbWidget.content.activeCell?.model.type === 'code') {
//         return commands.execute(cmdIds.invoke);
//       }
//     }
//   });
//   commands.addCommand(cmdIds.selectNotebook, {
//     label: 'Select Notebook',
//     execute: () => {
//       if (nbWidget.content.activeCell?.model.type === 'code') {
//         return commands.execute(cmdIds.select);
//       }
//     }
//   });
//   commands.addCommand(cmdIds.save, {
//     label: 'Save',
//     execute: () => nbWidget.context.save()
//   });
//   let searchInstance: SearchInstance | undefined;
//   commands.addCommand(cmdIds.startSearch, {
//     label: 'Find…',
//     execute: () => {
//       if (searchInstance) {
//         searchInstance.focusInput();
//         return;
//       }
//       const provider = new NotebookSearchProvider();
//       searchInstance = new SearchInstance(nbWidget, provider);
//       searchInstance.disposed.connect(() => {
//         searchInstance = undefined;
//         // find next and previous are now not enabled
//         commands.notifyCommandChanged();
//       });
//       // find next and previous are now enabled
//       commands.notifyCommandChanged();
//       searchInstance.focusInput();
//     }
//   });
//   commands.addCommand(cmdIds.findNext, {
//     label: 'Find Next',
//     isEnabled: () => !!searchInstance,
//     execute: async () => {
//       if (!searchInstance) {
//         return;
//       }
//       await searchInstance.provider.highlightNext();
//       searchInstance.updateIndices();
//     }
//   });
//   commands.addCommand(cmdIds.findPrevious, {
//     label: 'Find Previous',
//     isEnabled: () => !!searchInstance,
//     execute: async () => {
//       if (!searchInstance) {
//         return;
//       }
//       await searchInstance.provider.highlightPrevious();
//       searchInstance.updateIndices();
//     }
//   });
//   commands.addCommand(cmdIds.interrupt, {
//     label: 'Interrupt',
//     execute: async () =>
//       nbWidget.context.sessionContext.session?.kernel?.interrupt()
//   });
//   commands.addCommand(cmdIds.restart, {
//     label: 'Restart Kernel',
//     execute: () =>
//       sessionContextDialogs.restart(nbWidget.context.sessionContext)
//   });
//   commands.addCommand(cmdIds.switchKernel, {
//     label: 'Switch Kernel',
//     execute: () =>
//       sessionContextDialogs.selectKernel(nbWidget.context.sessionContext)
//   });
//   commands.addCommand(cmdIds.runAndAdvance, {
//     label: 'Run and Advance',
//     execute: () => {
//       return NotebookActions.runAndAdvance(
//         nbWidget.content,
//         nbWidget.context.sessionContext
//       );
//     }
//   });
//   commands.addCommand(cmdIds.run, {
//     label: 'Run',
//     execute: () => {
//       return NotebookActions.run(
//         nbWidget.content,
//         nbWidget.context.sessionContext
//       );
//     }
//   });
//   commands.addCommand(cmdIds.editMode, {
//     label: 'Edit Mode',
//     execute: () => {
//       nbWidget.content.mode = 'edit';
//     }
//   });
//   commands.addCommand(cmdIds.commandMode, {
//     label: 'Command Mode',
//     execute: () => {
//       nbWidget.content.mode = 'command';
//     }
//   });
//   commands.addCommand(cmdIds.selectBelow, {
//     label: 'Select Below',
//     execute: () => NotebookActions.selectBelow(nbWidget.content)
//   });
//   commands.addCommand(cmdIds.selectAbove, {
//     label: 'Select Above',
//     execute: () => NotebookActions.selectAbove(nbWidget.content)
//   });
//   commands.addCommand(cmdIds.extendAbove, {
//     label: 'Extend Above',
//     execute: () => NotebookActions.extendSelectionAbove(nbWidget.content)
//   });
//   commands.addCommand(cmdIds.extendTop, {
//     label: 'Extend to Top',
//     execute: () => NotebookActions.extendSelectionAbove(nbWidget.content, true)
//   });
//   commands.addCommand(cmdIds.extendBelow, {
//     label: 'Extend Below',
//     execute: () => NotebookActions.extendSelectionBelow(nbWidget.content)
//   });
//   commands.addCommand(cmdIds.extendBottom, {
//     label: 'Extend to Bottom',
//     execute: () => NotebookActions.extendSelectionBelow(nbWidget.content, true)
//   });
//   commands.addCommand(cmdIds.merge, {
//     label: 'Merge Cells',
//     execute: () => NotebookActions.mergeCells(nbWidget.content)
//   });
//   commands.addCommand(cmdIds.split, {
//     label: 'Split Cell',
//     execute: () => NotebookActions.splitCell(nbWidget.content)
//   });
//   commands.addCommand(cmdIds.undo, {
//     label: 'Undo',
//     execute: () => NotebookActions.undo(nbWidget.content)
//   });
//   commands.addCommand(cmdIds.redo, {
//     label: 'Redo',
//     execute: () => NotebookActions.redo(nbWidget.content)
//   });
//   // let category = 'Notebook Operations';
//   // [
//   //   cmdIds.interrupt,
//   //   cmdIds.restart,
//   //   cmdIds.editMode,
//   //   cmdIds.commandMode,
//   //   cmdIds.switchKernel,
//   //   cmdIds.startSearch,
//   //   cmdIds.findNext,
//   //   cmdIds.findPrevious
//   // ].forEach(command => palette.addItem({ command, category }));
//   // category = 'Notebook Cell Operations';
//   // [
//   //   cmdIds.runAndAdvance,
//   //   cmdIds.run,
//   //   cmdIds.split,
//   //   cmdIds.merge,
//   //   cmdIds.selectAbove,
//   //   cmdIds.selectBelow,
//   //   cmdIds.extendAbove,
//   //   cmdIds.extendBelow,
//   //   cmdIds.undo,
//   //   cmdIds.redo
//   // ].forEach(command => palette.addItem({ command, category }));
//   const bindings = [
//     {
//       selector: '.jp-Notebook.jp-mod-editMode .jp-mod-completer-enabled',
//       keys: ['Tab'],
//       command: cmdIds.invokeNotebook
//     },
//     {
//       selector: `.jp-mod-completer-active`,
//       keys: ['Enter'],
//       command: cmdIds.selectNotebook
//     },
//     {
//       selector: '.jp-Notebook',
//       keys: ['Ctrl Enter'],
//       command: cmdIds.run
//     },
//     {
//       selector: '.jp-Notebook',
//       keys: ['Shift Enter'],
//       command: cmdIds.runAndAdvance
//     },
//     {
//       selector: '.jp-Notebook',
//       keys: ['Accel S'],
//       command: cmdIds.save
//     },
//     {
//       selector: '.jp-Notebook',
//       keys: ['Accel F'],
//       command: cmdIds.startSearch
//     },
//     {
//       selector: '.jp-Notebook',
//       keys: ['Accel G'],
//       command: cmdIds.findNext
//     },
//     {
//       selector: '.jp-Notebook',
//       keys: ['Accel Shift G'],
//       command: cmdIds.findPrevious
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['I', 'I'],
//       command: cmdIds.interrupt
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['0', '0'],
//       command: cmdIds.restart
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['Enter'],
//       command: cmdIds.editMode
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-editMode',
//       keys: ['Escape'],
//       command: cmdIds.commandMode
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['Shift M'],
//       command: cmdIds.merge
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-editMode',
//       keys: ['Ctrl Shift -'],
//       command: cmdIds.split
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['J'],
//       command: cmdIds.selectBelow
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['ArrowDown'],
//       command: cmdIds.selectBelow
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['K'],
//       command: cmdIds.selectAbove
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['ArrowUp'],
//       command: cmdIds.selectAbove }, {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['Shift K'],
//       command: cmdIds.extendAbove
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['Shift J'],
//       command: cmdIds.extendBelow
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['Z'],
//       command: cmdIds.undo
//     },
//     {
//       selector: '.jp-Notebook.jp-mod-commandMode:focus',
//       keys: ['Y'],
//       command: cmdIds.redo
//     }
//   ];
//   bindings.map(binding => commands.addKeyBinding(binding));
// };
//# sourceMappingURL=commands.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/clipboard.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/clipboard.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Clipboard: () => (/* binding */ Clipboard)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The clipboard interface.
 */
var Clipboard;
(function (Clipboard) {
    /**
     * Get the application clipboard instance.
     */
    function getInstance() {
        return Private.instance;
    }
    Clipboard.getInstance = getInstance;
    /**
     * Set the application clipboard instance.
     */
    function setInstance(value) {
        Private.instance = value;
    }
    Clipboard.setInstance = setInstance;
    /**
     * Copy text to the system clipboard.
     *
     * #### Notes
     * This can only be called in response to a user input event.
     */
    function copyToSystem(clipboardData) {
        const node = document.body;
        const handler = (event) => {
            const data = event.clipboardData || window.clipboardData;
            if (typeof clipboardData === 'string') {
                data.setData('text', clipboardData);
            }
            else {
                clipboardData.types().map((mimeType) => {
                    data.setData(mimeType, clipboardData.getData(mimeType));
                });
            }
            event.preventDefault();
            node.removeEventListener('copy', handler);
        };
        node.addEventListener('copy', handler);
        generateEvent(node);
    }
    Clipboard.copyToSystem = copyToSystem;
    /**
     * Generate a clipboard event on a node.
     *
     * @param node - The element on which to generate the event.
     *
     * @param type - The type of event to generate.
     *   `'paste'` events cannot be programmatically generated.
     *
     * #### Notes
     * This can only be called in response to a user input event.
     */
    function generateEvent(node, type = 'copy') {
        // http://stackoverflow.com/a/5210367
        // Identify selected text.
        let sel = window.getSelection();
        // Save the current selection.
        const savedRanges = [];
        for (let i = 0, len = (sel === null || sel === void 0 ? void 0 : sel.rangeCount) || 0; i < len; ++i) {
            savedRanges[i] = sel.getRangeAt(i).cloneRange();
        }
        // Select the node content.
        const range = document.createRange();
        range.selectNodeContents(node);
        if (sel) {
            sel.removeAllRanges();
            sel.addRange(range);
        }
        // Execute the command.
        document.execCommand(type);
        // Restore the previous selection.
        sel = window.getSelection();
        if (sel) {
            sel.removeAllRanges();
            for (let i = 0, len = savedRanges.length; i < len; ++i) {
                sel.addRange(savedRanges[i]);
            }
        }
    }
    Clipboard.generateEvent = generateEvent;
})(Clipboard || (Clipboard = {}));
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * The application clipboard instance.
     */
    Private.instance = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.MimeData();
})(Private || (Private = {}));
//# sourceMappingURL=clipboard.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/commandlinker.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/commandlinker.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CommandLinker: () => (/* binding */ CommandLinker)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The command data attribute added to nodes that are connected.
 */
const COMMAND_ATTR = 'commandlinker-command';
/**
 * The args data attribute added to nodes that are connected.
 */
const ARGS_ATTR = 'commandlinker-args';
/**
 * A static class that provides helper methods to generate clickable nodes that
 * execute registered commands with pre-populated arguments.
 */
class CommandLinker {
    /**
     * Instantiate a new command linker.
     */
    constructor(options) {
        this._isDisposed = false;
        this._commands = options.commands;
        document.body.addEventListener('click', this);
    }
    /**
     * Test whether the linker is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the linker.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        document.body.removeEventListener('click', this);
    }
    /**
     * Connect a command/argument pair to a given node so that when it is clicked,
     * the command will execute.
     *
     * @param node - The node being connected.
     *
     * @param command - The command ID to execute upon click.
     *
     * @param args - The arguments with which to invoke the command.
     *
     * @returns The same node that was passed in, after it has been connected.
     *
     * #### Notes
     * Only `click` events will execute the command on a connected node. So, there
     * are two considerations that are relevant:
     * 1. If a node is connected, the default click action will be prevented.
     * 2. The `HTMLElement` passed in should be clickable.
     */
    connectNode(node, command, args) {
        node.setAttribute(`data-${COMMAND_ATTR}`, command);
        if (args !== void 0) {
            node.setAttribute(`data-${ARGS_ATTR}`, JSON.stringify(args));
        }
        return node;
    }
    /**
     * Disconnect a node that has been connected to execute a command on click.
     *
     * @param node - The node being disconnected.
     *
     * @returns The same node that was passed in, after it has been disconnected.
     *
     * #### Notes
     * This method is safe to call multiple times and is safe to call on nodes
     * that were never connected.
     *
     * This method can be called on rendered virtual DOM nodes that were populated
     * using the `populateVNodeDataset` method in order to disconnect them from
     * executing their command/argument pair.
     */
    disconnectNode(node) {
        node.removeAttribute(`data-${COMMAND_ATTR}`);
        node.removeAttribute(`data-${ARGS_ATTR}`);
        return node;
    }
    /**
     * Handle the DOM events for the command linker helper class.
     *
     * @param event - The DOM event sent to the class.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the panel's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'click':
                this._evtClick(event);
                break;
            default:
                return;
        }
    }
    /**
     * Populate the `dataset` attribute within the collection of attributes used
     * to instantiate a virtual DOM node with the values necessary for its
     * rendered DOM node to respond to clicks by executing a command/argument
     * pair.
     *
     * @param command - The command ID to execute upon click.
     *
     * @param args - The arguments with which to invoke the command.
     *
     * @returns A `dataset` collection for use within virtual node attributes.
     *
     * #### Notes
     * The return value can be used on its own as the value for the `dataset`
     * attribute of a virtual element, or it can be added to an existing `dataset`
     * as in the example below.
     *
     * #### Example
     * ```typescript
     * let command = 'some:command-id';
     * let args = { alpha: 'beta' };
     * let anchor = h.a({
     *   className: 'some-class',
     *   dataset: {
     *     foo: '1',
     *     bar: '2',
     *     ../...linker.populateVNodeDataset(command, args)
     *   }
     * }, 'some text');
     * ```
     */
    populateVNodeDataset(command, args) {
        let dataset;
        if (args !== void 0) {
            dataset = { [ARGS_ATTR]: JSON.stringify(args), [COMMAND_ATTR]: command };
        }
        else {
            dataset = { [COMMAND_ATTR]: command };
        }
        return dataset;
    }
    /**
     * The global click handler that deploys commands/argument pairs that are
     * attached to the node being clicked.
     */
    _evtClick(event) {
        let target = event.target;
        while (target && target.parentElement) {
            if (target.hasAttribute(`data-${COMMAND_ATTR}`)) {
                event.preventDefault();
                const command = target.getAttribute(`data-${COMMAND_ATTR}`);
                if (!command) {
                    return;
                }
                const argsValue = target.getAttribute(`data-${ARGS_ATTR}`);
                let args = _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.emptyObject;
                if (argsValue) {
                    args = JSON.parse(argsValue);
                }
                void this._commands.execute(command, args);
                return;
            }
            target = target.parentElement;
        }
    }
}
//# sourceMappingURL=commandlinker.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/commandpalette.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/commandpalette.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ModalCommandPalette: () => (/* binding */ ModalCommandPalette)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/


/**
 * Class name identifying the input group with search icon.
 */
const SEARCH_ICON_GROUP_CLASS = 'jp-SearchIconGroup';
/**
 * Wrap the command palette in a modal to make it more usable.
 */
class ModalCommandPalette extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Panel {
    constructor(options) {
        super();
        this.addClass('jp-ModalCommandPalette');
        this.id = 'modal-command-palette';
        this.palette = options.commandPalette;
        this._commandPalette.commands.commandExecuted.connect(() => {
            if (this.isAttached && this.isVisible) {
                this.hideAndReset();
            }
        });
        // required to properly receive blur and focus events;
        // selection of items with mouse may not work without this.
        this.node.tabIndex = 0;
    }
    get palette() {
        return this._commandPalette;
    }
    set palette(value) {
        this._commandPalette = value;
        if (!this.searchIconGroup) {
            this._commandPalette.inputNode.insertAdjacentElement('afterend', this.createSearchIconGroup());
        }
        this.addWidget(value);
        this.hideAndReset();
    }
    attach() {
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget.attach(this, document.body);
    }
    detach() {
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget.detach(this);
    }
    /**
     * Hide the modal command palette and reset its search.
     */
    hideAndReset() {
        this.hide();
        this._commandPalette.inputNode.value = '';
        this._commandPalette.refresh();
    }
    /**
     * Handle incoming events.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'blur': {
                // if the focus shifted outside of this DOM element, hide and reset.
                if (
                // focus went away from child element
                this.node.contains(event.target) &&
                    // and it did NOT go to another child element but someplace else
                    !this.node.contains(event.relatedTarget)) {
                    event.stopPropagation();
                    this.hideAndReset();
                }
                break;
            }
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                break;
        }
    }
    /**
     * Find the element with search icon group.
     */
    get searchIconGroup() {
        return this._commandPalette.node.getElementsByClassName(SEARCH_ICON_GROUP_CLASS)[0];
    }
    /**
     * Create element with search icon group.
     */
    createSearchIconGroup() {
        const inputGroup = document.createElement('div');
        inputGroup.classList.add(SEARCH_ICON_GROUP_CLASS);
        _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.searchIcon.render(inputGroup);
        return inputGroup;
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        this.node.addEventListener('keydown', this, true);
        this.node.addEventListener('contextmenu', this, true);
    }
    /**
     *  A message handler invoked on an `'after-detach'` message.
     */
    onAfterDetach(msg) {
        this.node.removeEventListener('keydown', this, true);
        this.node.removeEventListener('contextmenu', this, true);
    }
    onBeforeHide(msg) {
        document.removeEventListener('blur', this, true);
    }
    onAfterShow(msg) {
        document.addEventListener('blur', this, true);
    }
    /**
     * A message handler invoked on an `'activate-request'` message.
     */
    onActivateRequest(msg) {
        if (this.isAttached) {
            this.show();
            this._commandPalette.activate();
        }
    }
    /**
     * Handle the `'keydown'` event for the widget.
     */
    _evtKeydown(event) {
        // Check for escape key
        switch (event.keyCode) {
            case 27: // Escape.
                event.stopPropagation();
                event.preventDefault();
                this.hideAndReset();
                break;
            default:
                break;
        }
    }
}
//# sourceMappingURL=commandpalette.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/dialog.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/dialog.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Dialog: () => (/* binding */ Dialog),
/* harmony export */   showDialog: () => (/* binding */ showDialog),
/* harmony export */   showErrorMessage: () => (/* binding */ showErrorMessage)
/* harmony export */ });
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/vdom.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/button.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/labicon.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/styling.js");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/messaging */ "./node_modules/@lumino/messaging/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _widgettracker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./widgettracker */ "./node_modules/@jupyterlab/apputils/lib/widgettracker.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * Create and show a dialog.
 *
 * @param options - The dialog setup options.
 *
 * @returns A promise that resolves with whether the dialog was accepted.
 */
function showDialog(options = {}) {
    const dialog = new Dialog(options);
    return dialog.launch();
}
/**
 * Show an error message dialog.
 *
 * @param title - The title of the dialog box.
 *
 * @param error - the error to show in the dialog body (either a string
 *   or an object with a string `message` property).
 */
function showErrorMessage(title, error, buttons) {
    const trans = Dialog.translator.load('jupyterlab');
    buttons = buttons !== null && buttons !== void 0 ? buttons : [Dialog.okButton({ label: trans.__('Dismiss') })];
    console.warn('Showing error:', error);
    // Cache promises to prevent multiple copies of identical dialogs showing
    // to the user.
    const body = typeof error === 'string' ? error : error.message;
    const key = title + '----' + body;
    const promise = Private.errorMessagePromiseCache.get(key);
    if (promise) {
        return promise;
    }
    else {
        const dialogPromise = showDialog({
            title: title,
            body: body,
            buttons: buttons
        }).then(() => {
            Private.errorMessagePromiseCache.delete(key);
        }, error => {
            // TODO: Use .finally() above when supported
            Private.errorMessagePromiseCache.delete(key);
            throw error;
        });
        Private.errorMessagePromiseCache.set(key, dialogPromise);
        return dialogPromise;
    }
}
/**
 * A modal dialog widget.
 */
class Dialog extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget {
    /**
     * Create a dialog panel instance.
     *
     * @param options - The dialog setup options.
     */
    constructor(options = {}) {
        const dialogNode = document.createElement('dialog');
        dialogNode.ariaModal = 'true';
        super({ node: dialogNode });
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
        this._focusNodeSelector = '';
        this.addClass('jp-Dialog');
        const normalized = Private.handleOptions(options);
        const renderer = normalized.renderer;
        this._host = normalized.host;
        this._defaultButton = normalized.defaultButton;
        this._buttons = normalized.buttons;
        this._hasClose = normalized.hasClose;
        this._buttonNodes = this._buttons.map(b => renderer.createButtonNode(b));
        this._checkboxNode = null;
        this._lastMouseDownInDialog = false;
        if (normalized.checkbox) {
            const { label = '', caption = '', checked = false, className = '' } = normalized.checkbox;
            this._checkboxNode = renderer.createCheckboxNode({
                label,
                caption: caption !== null && caption !== void 0 ? caption : label,
                checked,
                className
            });
        }
        const layout = (this.layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.PanelLayout());
        const content = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Panel();
        content.addClass('jp-Dialog-content');
        if (typeof options.body === 'string') {
            content.addClass('jp-Dialog-content-small');
            dialogNode.ariaLabel = [normalized.title, options.body].join(' ');
        }
        layout.addWidget(content);
        this._body = normalized.body;
        const header = renderer.createHeader(normalized.title, () => this.reject(), options);
        const body = renderer.createBody(normalized.body);
        const footer = renderer.createFooter(this._buttonNodes, this._checkboxNode);
        content.addWidget(header);
        content.addWidget(body);
        content.addWidget(footer);
        this._bodyWidget = body;
        this._primary = this._buttonNodes[this._defaultButton];
        this._focusNodeSelector = options.focusNodeSelector;
        // Add new dialogs to the tracker.
        void Dialog.tracker.add(this);
    }
    /**
     * A promise that resolves when the Dialog first rendering is done.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Dispose of the resources used by the dialog.
     */
    dispose() {
        const promise = this._promise;
        if (promise) {
            this._promise = null;
            promise.reject(void 0);
            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.ArrayExt.removeFirstOf(Private.launchQueue, promise.promise);
        }
        super.dispose();
    }
    /**
     * Launch the dialog as a modal window.
     *
     * @returns a promise that resolves with the result of the dialog.
     */
    launch() {
        // Return the existing dialog if already open.
        if (this._promise) {
            return this._promise.promise;
        }
        const promise = (this._promise = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate());
        const promises = Promise.all(Private.launchQueue);
        Private.launchQueue.push(this._promise.promise);
        return promises.then(() => {
            // Do not show Dialog if it was disposed of before it was at the front of the launch queue
            if (!this._promise) {
                return Promise.resolve({
                    button: Dialog.cancelButton(),
                    isChecked: null,
                    value: null
                });
            }
            _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget.attach(this, this._host);
            return promise.promise;
        });
    }
    /**
     * Resolve the current dialog.
     *
     * @param index - An optional index to the button to resolve.
     *
     * #### Notes
     * Will default to the defaultIndex.
     * Will resolve the current `show()` with the button value.
     * Will be a no-op if the dialog is not shown.
     */
    resolve(index) {
        if (!this._promise) {
            return;
        }
        if (index === undefined) {
            index = this._defaultButton;
        }
        this._resolve(this._buttons[index]);
    }
    /**
     * Reject the current dialog with a default reject value.
     *
     * #### Notes
     * Will be a no-op if the dialog is not shown.
     */
    reject() {
        if (!this._promise) {
            return;
        }
        this._resolve(Dialog.cancelButton());
    }
    /**
     * Handle the DOM events for the directory listing.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the panel's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'mousedown':
                this._evtMouseDown(event);
                break;
            case 'click':
                this._evtClick(event);
                break;
            case 'focus':
                this._evtFocus(event);
                break;
            case 'contextmenu':
                event.preventDefault();
                event.stopPropagation();
                break;
            default:
                break;
        }
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        const node = this.node;
        node.addEventListener('keydown', this, true);
        node.addEventListener('contextmenu', this, true);
        node.addEventListener('click', this, true);
        document.addEventListener('mousedown', this, true);
        document.addEventListener('focus', this, true);
        this._first = Private.findFirstFocusable(this.node);
        this._original = document.activeElement;
        const setFocus = () => {
            var _a;
            if (this._focusNodeSelector) {
                const body = this.node.querySelector('.jp-Dialog-body');
                const el = body === null || body === void 0 ? void 0 : body.querySelector(this._focusNodeSelector);
                if (el) {
                    this._primary = el;
                }
            }
            (_a = this._primary) === null || _a === void 0 ? void 0 : _a.focus();
            this._ready.resolve();
        };
        if (this._bodyWidget instanceof _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.ReactWidget &&
            this._bodyWidget.renderPromise !== undefined) {
            this._bodyWidget
                .renderPromise.then(() => {
                setFocus();
            })
                .catch(() => {
                console.error("Error while loading Dialog's body");
            });
        }
        else {
            setFocus();
        }
    }
    /**
     *  A message handler invoked on an `'after-detach'` message.
     */
    onAfterDetach(msg) {
        const node = this.node;
        node.removeEventListener('keydown', this, true);
        node.removeEventListener('contextmenu', this, true);
        node.removeEventListener('click', this, true);
        document.removeEventListener('focus', this, true);
        document.removeEventListener('mousedown', this, true);
        this._original.focus();
    }
    /**
     * A message handler invoked on a `'close-request'` message.
     */
    onCloseRequest(msg) {
        if (this._promise) {
            this.reject();
        }
        super.onCloseRequest(msg);
    }
    /**
     * Handle the `'click'` event for a dialog button.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtClick(event) {
        const content = this.node.getElementsByClassName('jp-Dialog-content')[0];
        if (!content.contains(event.target)) {
            event.stopPropagation();
            event.preventDefault();
            if (this._hasClose && !this._lastMouseDownInDialog) {
                this.reject();
            }
            return;
        }
        for (const buttonNode of this._buttonNodes) {
            if (buttonNode.contains(event.target)) {
                const index = this._buttonNodes.indexOf(buttonNode);
                this.resolve(index);
            }
        }
    }
    /**
     * Handle the `'keydown'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtKeydown(event) {
        // Check for escape key
        switch (event.keyCode) {
            case 27: // Escape.
                event.stopPropagation();
                event.preventDefault();
                if (this._hasClose) {
                    this.reject();
                }
                break;
            case 37: {
                // Left arrow
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    let idx = this._buttonNodes.indexOf(activeEl) - 1;
                    // Handle a left arrows on the first button
                    if (idx < 0) {
                        idx = this._buttonNodes.length - 1;
                    }
                    const node = this._buttonNodes[idx];
                    event.stopPropagation();
                    event.preventDefault();
                    node.focus();
                }
                break;
            }
            case 39: {
                // Right arrow
                const activeEl = document.activeElement;
                if (activeEl instanceof HTMLButtonElement) {
                    let idx = this._buttonNodes.indexOf(activeEl) + 1;
                    // Handle a right arrows on the last button
                    if (idx == this._buttons.length) {
                        idx = 0;
                    }
                    const node = this._buttonNodes[idx];
                    event.stopPropagation();
                    event.preventDefault();
                    node.focus();
                }
                break;
            }
            case 9: {
                // Tab.
                // Handle a tab on the last button.
                const node = this._buttonNodes[this._buttons.length - 1];
                if (document.activeElement === node && !event.shiftKey) {
                    event.stopPropagation();
                    event.preventDefault();
                    this._first.focus();
                }
                break;
            }
            case 13: {
                // Enter.
                event.stopPropagation();
                event.preventDefault();
                const activeEl = document.activeElement;
                let index;
                if (activeEl instanceof HTMLButtonElement) {
                    index = this._buttonNodes.indexOf(activeEl);
                }
                this.resolve(index);
                break;
            }
            default:
                break;
        }
    }
    /**
     * Handle the `'focus'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtFocus(event) {
        var _a;
        const target = event.target;
        if (!this.node.contains(target)) {
            event.stopPropagation();
            (_a = this._buttonNodes[this._defaultButton]) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }
    /**
     * Handle the `'mousedown'` event for the widget.
     *
     * @param event - The DOM event sent to the widget
     */
    _evtMouseDown(event) {
        const content = this.node.getElementsByClassName('jp-Dialog-content')[0];
        const target = event.target;
        this._lastMouseDownInDialog = content.contains(target);
    }
    /**
     * Resolve a button item.
     */
    _resolve(button) {
        var _a, _b, _c;
        // Prevent loopback.
        const promise = this._promise;
        if (!promise) {
            this.dispose();
            return;
        }
        this._promise = null;
        _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.ArrayExt.removeFirstOf(Private.launchQueue, promise.promise);
        const body = this._body;
        let value = null;
        if (button.accept &&
            body instanceof _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget &&
            typeof body.getValue === 'function') {
            value = body.getValue();
        }
        this.dispose();
        promise.resolve({
            button,
            isChecked: (_c = (_b = (_a = this._checkboxNode) === null || _a === void 0 ? void 0 : _a.querySelector('input')) === null || _b === void 0 ? void 0 : _b.checked) !== null && _c !== void 0 ? _c : null,
            value
        });
    }
}
/**
 * The namespace for Dialog class statics.
 */
(function (Dialog) {
    /**
     * Translator object.
     */
    Dialog.translator = _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
    /**
     * Create a button item.
     */
    function createButton(value) {
        value.accept = value.accept !== false;
        const trans = Dialog.translator.load('jupyterlab');
        const defaultLabel = value.accept ? trans.__('Ok') : trans.__('Cancel');
        return {
            ariaLabel: value.ariaLabel || value.label || defaultLabel,
            label: value.label || defaultLabel,
            iconClass: value.iconClass || '',
            iconLabel: value.iconLabel || '',
            caption: value.caption || '',
            className: value.className || '',
            accept: value.accept,
            actions: value.actions || [],
            displayType: value.displayType || 'default'
        };
    }
    Dialog.createButton = createButton;
    /**
     * Create a reject button.
     */
    function cancelButton(options = {}) {
        options.accept = false;
        return createButton(options);
    }
    Dialog.cancelButton = cancelButton;
    /**
     * Create an accept button.
     */
    function okButton(options = {}) {
        options.accept = true;
        return createButton(options);
    }
    Dialog.okButton = okButton;
    /**
     * Create a warn button.
     */
    function warnButton(options = {}) {
        options.displayType = 'warn';
        return createButton(options);
    }
    Dialog.warnButton = warnButton;
    /**
     * Disposes all dialog instances.
     *
     * #### Notes
     * This function should only be used in tests or cases where application state
     * may be discarded.
     */
    function flush() {
        Dialog.tracker.forEach(dialog => {
            dialog.dispose();
        });
    }
    Dialog.flush = flush;
    /**
     * The default implementation of a dialog renderer.
     */
    class Renderer {
        /**
         * Create the header of the dialog.
         *
         * @param title - The title of the dialog.
         *
         * @returns A widget for the dialog header.
         */
        createHeader(title, reject = () => {
            /* empty */
        }, options = {}) {
            let header;
            const handleMouseDown = (event) => {
                // Fire action only when left button is pressed.
                if (event.button === 0) {
                    event.preventDefault();
                    reject();
                }
            };
            const handleKeyDown = (event) => {
                const { key } = event;
                if (key === 'Enter' || key === ' ') {
                    reject();
                }
            };
            if (typeof title === 'string') {
                const trans = Dialog.translator.load('jupyterlab');
                header = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.ReactWidget.create(react__WEBPACK_IMPORTED_MODULE_5__.createElement(react__WEBPACK_IMPORTED_MODULE_5__.Fragment, null,
                    title,
                    options.hasClose && (react__WEBPACK_IMPORTED_MODULE_5__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__.Button, { className: "jp-Dialog-close-button", onMouseDown: handleMouseDown, onKeyDown: handleKeyDown, title: trans.__('Cancel'), minimal: true },
                        react__WEBPACK_IMPORTED_MODULE_5__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_8__.LabIcon.resolveReact, { icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_9__.closeIcon, iconClass: "jp-Icon", className: "jp-ToolbarButtonComponent-icon", tag: "span" })))));
            }
            else {
                header = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.ReactWidget.create(title);
            }
            header.addClass('jp-Dialog-header');
            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_10__.Styling.styleNode(header.node);
            return header;
        }
        /**
         * Create the body of the dialog.
         *
         * @param value - The input value for the body.
         *
         * @returns A widget for the body.
         */
        createBody(value) {
            const styleReactWidget = (widget) => {
                if (widget.renderPromise !== undefined) {
                    widget.renderPromise
                        .then(() => {
                        _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_10__.Styling.styleNode(widget.node);
                    })
                        .catch(() => {
                        console.error("Error while loading Dialog's body");
                    });
                }
                else {
                    _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_10__.Styling.styleNode(widget.node);
                }
            };
            let body;
            if (typeof value === 'string') {
                body = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget({ node: document.createElement('span') });
                body.node.textContent = value;
            }
            else if (value instanceof _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget) {
                body = value;
                if (body instanceof _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.ReactWidget) {
                    styleReactWidget(body);
                }
                else {
                    _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_10__.Styling.styleNode(body.node);
                }
            }
            else {
                body = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.ReactWidget.create(value);
                // Immediately update the body even though it has not yet attached in
                // order to trigger a render of the DOM nodes from the React element.
                _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__.MessageLoop.sendMessage(body, _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget.Msg.UpdateRequest);
                styleReactWidget(body);
            }
            body.addClass('jp-Dialog-body');
            return body;
        }
        /**
         * Create the footer of the dialog.
         *
         * @param buttons - The buttons nodes to add to the footer.
         * @param checkbox - The checkbox node to add to the footer.
         *
         * @returns A widget for the footer.
         */
        createFooter(buttons, checkbox) {
            const footer = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget();
            footer.addClass('jp-Dialog-footer');
            if (checkbox) {
                footer.node.appendChild(checkbox);
                footer.node.insertAdjacentHTML('beforeend', '<div class="jp-Dialog-spacer"></div>');
            }
            for (const button of buttons) {
                footer.node.appendChild(button);
            }
            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_10__.Styling.styleNode(footer.node);
            return footer;
        }
        /**
         * Create a button node for the dialog.
         *
         * @param button - The button data.
         *
         * @returns A node for the button.
         */
        createButtonNode(button) {
            const e = document.createElement('button');
            e.className = this.createItemClass(button);
            e.appendChild(this.renderIcon(button));
            e.appendChild(this.renderLabel(button));
            return e;
        }
        /**
         * Create a checkbox node for the dialog.
         *
         * @param checkbox - The checkbox data.
         *
         * @returns A node for the checkbox.
         */
        createCheckboxNode(checkbox) {
            const e = document.createElement('label');
            e.className = 'jp-Dialog-checkbox';
            if (checkbox.className) {
                e.classList.add(checkbox.className);
            }
            e.title = checkbox.caption;
            e.textContent = checkbox.label;
            const input = document.createElement('input');
            input.type = 'checkbox';
            input.checked = !!checkbox.checked;
            e.insertAdjacentElement('afterbegin', input);
            return e;
        }
        /**
         * Create the class name for the button.
         *
         * @param data - The data to use for the class name.
         *
         * @returns The full class name for the button.
         */
        createItemClass(data) {
            // Setup the initial class name.
            let name = 'jp-Dialog-button';
            // Add the other state classes.
            if (data.accept) {
                name += ' jp-mod-accept';
            }
            else {
                name += ' jp-mod-reject';
            }
            if (data.displayType === 'warn') {
                name += ' jp-mod-warn';
            }
            // Add the extra class.
            const extra = data.className;
            if (extra) {
                name += ` ${extra}`;
            }
            // Return the complete class name.
            return name;
        }
        /**
         * Render an icon element for a dialog item.
         *
         * @param data - The data to use for rendering the icon.
         *
         * @returns An HTML element representing the icon.
         */
        renderIcon(data) {
            const e = document.createElement('div');
            e.className = this.createIconClass(data);
            e.appendChild(document.createTextNode(data.iconLabel));
            return e;
        }
        /**
         * Create the class name for the button icon.
         *
         * @param data - The data to use for the class name.
         *
         * @returns The full class name for the item icon.
         */
        createIconClass(data) {
            const name = 'jp-Dialog-buttonIcon';
            const extra = data.iconClass;
            return extra ? `${name} ${extra}` : name;
        }
        /**
         * Render the label element for a button.
         *
         * @param data - The data to use for rendering the label.
         *
         * @returns An HTML element representing the item label.
         */
        renderLabel(data) {
            const e = document.createElement('div');
            e.className = 'jp-Dialog-buttonLabel';
            e.title = data.caption;
            e.ariaLabel = data.ariaLabel;
            e.appendChild(document.createTextNode(data.label));
            return e;
        }
    }
    Dialog.Renderer = Renderer;
    /**
     * The default renderer instance.
     */
    Dialog.defaultRenderer = new Renderer();
    /**
     * The dialog widget tracker.
     */
    Dialog.tracker = new _widgettracker__WEBPACK_IMPORTED_MODULE_11__.WidgetTracker({
        namespace: '@jupyterlab/apputils:Dialog'
    });
})(Dialog || (Dialog = {}));
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * The queue for launching dialogs.
     */
    Private.launchQueue = [];
    Private.errorMessagePromiseCache = new Map();
    /**
     * Handle the input options for a dialog.
     *
     * @param options - The input options.
     *
     * @returns A new options object with defaults applied.
     */
    function handleOptions(options = {}) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j;
        const buttons = (_a = options.buttons) !== null && _a !== void 0 ? _a : [
            Dialog.cancelButton(),
            Dialog.okButton()
        ];
        return {
            title: (_b = options.title) !== null && _b !== void 0 ? _b : '',
            body: (_c = options.body) !== null && _c !== void 0 ? _c : '',
            host: (_d = options.host) !== null && _d !== void 0 ? _d : document.body,
            checkbox: (_e = options.checkbox) !== null && _e !== void 0 ? _e : null,
            buttons,
            defaultButton: (_f = options.defaultButton) !== null && _f !== void 0 ? _f : buttons.length - 1,
            renderer: (_g = options.renderer) !== null && _g !== void 0 ? _g : Dialog.defaultRenderer,
            focusNodeSelector: (_h = options.focusNodeSelector) !== null && _h !== void 0 ? _h : '',
            hasClose: (_j = options.hasClose) !== null && _j !== void 0 ? _j : true
        };
    }
    Private.handleOptions = handleOptions;
    /**
     *  Find the first focusable item in the dialog.
     */
    function findFirstFocusable(node) {
        const candidateSelectors = [
            'input',
            'select',
            'a[href]',
            'textarea',
            'button',
            '[tabindex]'
        ].join(',');
        return node.querySelectorAll(candidateSelectors)[0];
    }
    Private.findFirstFocusable = findFirstFocusable;
})(Private || (Private = {}));
//# sourceMappingURL=dialog.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/domutils.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/domutils.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DOMUtils: () => (/* binding */ DOMUtils)
/* harmony export */ });
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/domutils */ "./node_modules/@lumino/domutils/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * The namespace for DOM utilities.
 */
var DOMUtils;
(function (DOMUtils) {
    /**
     * Get the index of the node at a client position, or `-1`.
     */
    function hitTestNodes(nodes, x, y) {
        return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.findFirstIndex(nodes, node => {
            return _lumino_domutils__WEBPACK_IMPORTED_MODULE_2__.ElementExt.hitTest(node, x, y);
        });
    }
    DOMUtils.hitTestNodes = hitTestNodes;
    /**
     * Find the first element matching a class name.
     */
    function findElement(parent, className) {
        return parent.querySelector(`.${className}`);
    }
    DOMUtils.findElement = findElement;
    /**
     * Find the first element matching a class name.
     */
    function findElements(parent, className) {
        return parent.getElementsByClassName(className);
    }
    DOMUtils.findElements = findElements;
    /**
     * Create a DOM id with prefix "id-" to solve bug for UUIDs beginning with numbers.
     */
    function createDomID() {
        return `id-${_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.UUID.uuid4()}`;
    }
    DOMUtils.createDomID = createDomID;
})(DOMUtils || (DOMUtils = {}));
//# sourceMappingURL=domutils.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/index.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Clipboard: () => (/* reexport safe */ _clipboard__WEBPACK_IMPORTED_MODULE_7__.Clipboard),
/* harmony export */   Collapse: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__.Collapser),
/* harmony export */   CommandLinker: () => (/* reexport safe */ _commandlinker__WEBPACK_IMPORTED_MODULE_8__.CommandLinker),
/* harmony export */   CommandToolbarButton: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.CommandToolbarButton),
/* harmony export */   CommandToolbarButtonComponent: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.CommandToolbarButtonComponent),
/* harmony export */   DOMUtils: () => (/* reexport safe */ _domutils__WEBPACK_IMPORTED_MODULE_11__.DOMUtils),
/* harmony export */   Dialog: () => (/* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_10__.Dialog),
/* harmony export */   HoverBox: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.HoverBox),
/* harmony export */   ICommandPalette: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.ICommandPalette),
/* harmony export */   IFrame: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.IFrame),
/* harmony export */   IKernelStatusModel: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.IKernelStatusModel),
/* harmony export */   ISanitizer: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.ISanitizer),
/* harmony export */   ISessionContextDialogs: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.ISessionContextDialogs),
/* harmony export */   ISplashScreen: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.ISplashScreen),
/* harmony export */   IThemeManager: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.IThemeManager),
/* harmony export */   IToolbarWidgetRegistry: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.IToolbarWidgetRegistry),
/* harmony export */   IWindowResolver: () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_23__.IWindowResolver),
/* harmony export */   InputDialog: () => (/* reexport safe */ _inputdialog__WEBPACK_IMPORTED_MODULE_12__.InputDialog),
/* harmony export */   KernelStatus: () => (/* reexport safe */ _kernelstatuses__WEBPACK_IMPORTED_MODULE_13__.KernelStatus),
/* harmony export */   MainAreaWidget: () => (/* reexport safe */ _mainareawidget__WEBPACK_IMPORTED_MODULE_14__.MainAreaWidget),
/* harmony export */   MenuFactory: () => (/* reexport safe */ _menufactory__WEBPACK_IMPORTED_MODULE_15__.MenuFactory),
/* harmony export */   ModalCommandPalette: () => (/* reexport safe */ _commandpalette__WEBPACK_IMPORTED_MODULE_9__.ModalCommandPalette),
/* harmony export */   Notification: () => (/* reexport safe */ _notification__WEBPACK_IMPORTED_MODULE_16__.Notification),
/* harmony export */   NotificationManager: () => (/* reexport safe */ _notification__WEBPACK_IMPORTED_MODULE_16__.NotificationManager),
/* harmony export */   Printing: () => (/* reexport safe */ _printing__WEBPACK_IMPORTED_MODULE_17__.Printing),
/* harmony export */   ReactWidget: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.ReactWidget),
/* harmony export */   RunningSessions: () => (/* reexport safe */ _runningSessions__WEBPACK_IMPORTED_MODULE_18__.RunningSessions),
/* harmony export */   Sanitizer: () => (/* reexport safe */ _sanitizer__WEBPACK_IMPORTED_MODULE_19__.Sanitizer),
/* harmony export */   SemanticCommand: () => (/* reexport safe */ _semanticCommand__WEBPACK_IMPORTED_MODULE_20__.SemanticCommand),
/* harmony export */   SessionContext: () => (/* reexport safe */ _sessioncontext__WEBPACK_IMPORTED_MODULE_21__.SessionContext),
/* harmony export */   SessionContextDialogs: () => (/* reexport safe */ _sessioncontext__WEBPACK_IMPORTED_MODULE_21__.SessionContextDialogs),
/* harmony export */   Spinner: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__.Spinner),
/* harmony export */   Styling: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.Styling),
/* harmony export */   ThemeManager: () => (/* reexport safe */ _thememanager__WEBPACK_IMPORTED_MODULE_22__.ThemeManager),
/* harmony export */   Toolbar: () => (/* binding */ Toolbar),
/* harmony export */   ToolbarButton: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton),
/* harmony export */   ToolbarButtonComponent: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.ToolbarButtonComponent),
/* harmony export */   ToolbarWidgetRegistry: () => (/* reexport safe */ _toolbar__WEBPACK_IMPORTED_MODULE_24__.ToolbarWidgetRegistry),
/* harmony export */   UseSignal: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.UseSignal),
/* harmony export */   VDomModel: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.VDomModel),
/* harmony export */   VDomRenderer: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.VDomRenderer),
/* harmony export */   WidgetTracker: () => (/* reexport safe */ _widgettracker__WEBPACK_IMPORTED_MODULE_26__.WidgetTracker),
/* harmony export */   WindowResolver: () => (/* reexport safe */ _windowresolver__WEBPACK_IMPORTED_MODULE_27__.WindowResolver),
/* harmony export */   addCommandToolbarButtonClass: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.addCommandToolbarButtonClass),
/* harmony export */   addToolbarButtonClass: () => (/* reexport safe */ _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.addToolbarButtonClass),
/* harmony export */   createDefaultFactory: () => (/* reexport safe */ _toolbar__WEBPACK_IMPORTED_MODULE_24__.createDefaultFactory),
/* harmony export */   createToolbarFactory: () => (/* reexport safe */ _toolbar__WEBPACK_IMPORTED_MODULE_25__.createToolbarFactory),
/* harmony export */   setToolbar: () => (/* reexport safe */ _toolbar__WEBPACK_IMPORTED_MODULE_25__.setToolbar),
/* harmony export */   showDialog: () => (/* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_10__.showDialog),
/* harmony export */   showErrorMessage: () => (/* reexport safe */ _dialog__WEBPACK_IMPORTED_MODULE_10__.showErrorMessage),
/* harmony export */   translateKernelStatuses: () => (/* reexport safe */ _kernelstatuses__WEBPACK_IMPORTED_MODULE_13__.translateKernelStatuses)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/toolbar.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./toolbar */ "./node_modules/@jupyterlab/apputils/lib/toolbar/widget.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/collapser.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/iframe.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/hoverbox.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/vdom.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/spinner.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/styling.js");
/* harmony import */ var _clipboard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./clipboard */ "./node_modules/@jupyterlab/apputils/lib/clipboard.js");
/* harmony import */ var _commandlinker__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./commandlinker */ "./node_modules/@jupyterlab/apputils/lib/commandlinker.js");
/* harmony import */ var _commandpalette__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./commandpalette */ "./node_modules/@jupyterlab/apputils/lib/commandpalette.js");
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./dialog */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
/* harmony import */ var _domutils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./domutils */ "./node_modules/@jupyterlab/apputils/lib/domutils.js");
/* harmony import */ var _inputdialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./inputdialog */ "./node_modules/@jupyterlab/apputils/lib/inputdialog.js");
/* harmony import */ var _kernelstatuses__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./kernelstatuses */ "./node_modules/@jupyterlab/apputils/lib/kernelstatuses.js");
/* harmony import */ var _mainareawidget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./mainareawidget */ "./node_modules/@jupyterlab/apputils/lib/mainareawidget.js");
/* harmony import */ var _menufactory__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./menufactory */ "./node_modules/@jupyterlab/apputils/lib/menufactory.js");
/* harmony import */ var _notification__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./notification */ "./node_modules/@jupyterlab/apputils/lib/notification.js");
/* harmony import */ var _printing__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./printing */ "./node_modules/@jupyterlab/apputils/lib/printing.js");
/* harmony import */ var _runningSessions__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./runningSessions */ "./node_modules/@jupyterlab/apputils/lib/runningSessions.js");
/* harmony import */ var _sanitizer__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./sanitizer */ "./node_modules/@jupyterlab/apputils/lib/sanitizer.js");
/* harmony import */ var _semanticCommand__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./semanticCommand */ "./node_modules/@jupyterlab/apputils/lib/semanticCommand.js");
/* harmony import */ var _sessioncontext__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./sessioncontext */ "./node_modules/@jupyterlab/apputils/lib/sessioncontext.js");
/* harmony import */ var _thememanager__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./thememanager */ "./node_modules/@jupyterlab/apputils/lib/thememanager.js");
/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./tokens */ "./node_modules/@jupyterlab/apputils/lib/tokens.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./toolbar */ "./node_modules/@jupyterlab/apputils/lib/toolbar/registry.js");
/* harmony import */ var _toolbar__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./toolbar */ "./node_modules/@jupyterlab/apputils/lib/toolbar/factory.js");
/* harmony import */ var _widgettracker__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./widgettracker */ "./node_modules/@jupyterlab/apputils/lib/widgettracker.js");
/* harmony import */ var _windowresolver__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./windowresolver */ "./node_modules/@jupyterlab/apputils/lib/windowresolver.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module apputils
 */


/**
 * @deprecated since v4
 * These widgets are now in @jupyterlab/ui-components
 */





















// Merge Toolbar namespace to preserve API
/**
 * @deprecated since v4
 * This class is in @jupyterlab/ui-components
 */
class Toolbar extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.Toolbar {
}
(function (Toolbar) {
    Toolbar.createInterruptButton = _toolbar__WEBPACK_IMPORTED_MODULE_28__.Toolbar.createInterruptButton;
    Toolbar.createKernelNameItem = _toolbar__WEBPACK_IMPORTED_MODULE_28__.Toolbar.createKernelNameItem;
    Toolbar.createKernelStatusItem = _toolbar__WEBPACK_IMPORTED_MODULE_28__.Toolbar.createKernelStatusItem;
    Toolbar.createRestartButton = _toolbar__WEBPACK_IMPORTED_MODULE_28__.Toolbar.createRestartButton;
    /**
     * @deprecated since v4
     * This helper function is in @jupyterlab/ui-components
     */
    Toolbar.createSpacerItem = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_0__.Toolbar.createSpacerItem;
})(Toolbar || (Toolbar = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/inputdialog.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/inputdialog.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InputDialog: () => (/* binding */ InputDialog)
/* harmony export */ });
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dialog */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


const INPUT_DIALOG_CLASS = 'jp-Input-Dialog';
const INPUT_BOOLEAN_DIALOG_CLASS = 'jp-Input-Boolean-Dialog';
/**
 * Namespace for input dialogs
 */
var InputDialog;
(function (InputDialog) {
    /**
     * Create and show a input dialog for a boolean.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getBoolean(options) {
        return (0,_dialog__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
            ...options,
            body: new InputBooleanDialog(options),
            buttons: [
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: options.cancelLabel }),
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getBoolean = getBoolean;
    /**
     * Create and show a input dialog for a number.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getNumber(options) {
        return (0,_dialog__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
            ...options,
            body: new InputNumberDialog(options),
            buttons: [
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: options.cancelLabel }),
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getNumber = getNumber;
    /**
     * Create and show a input dialog for a choice.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getItem(options) {
        return (0,_dialog__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
            ...options,
            body: new InputItemsDialog(options),
            buttons: [
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: options.cancelLabel }),
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: options.editable ? 'input' : 'select'
        });
    }
    InputDialog.getItem = getItem;
    /**
     * Create and show a input dialog for a choice.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getMultipleItems(options) {
        return (0,_dialog__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
            ...options,
            body: new InputMultipleItemsDialog(options),
            buttons: [
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: options.cancelLabel }),
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: options.okLabel })
            ]
        });
    }
    InputDialog.getMultipleItems = getMultipleItems;
    /**
     * Create and show a input dialog for a text.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getText(options) {
        return (0,_dialog__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
            ...options,
            body: new InputTextDialog(options),
            buttons: [
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: options.cancelLabel }),
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getText = getText;
    /**
     * Create and show a input dialog for a password.
     *
     * @param options - The dialog setup options.
     *
     * @returns A promise that resolves with whether the dialog was accepted
     */
    function getPassword(options) {
        return (0,_dialog__WEBPACK_IMPORTED_MODULE_1__.showDialog)({
            ...options,
            body: new InputPasswordDialog(options),
            buttons: [
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.cancelButton({ label: options.cancelLabel }),
                _dialog__WEBPACK_IMPORTED_MODULE_1__.Dialog.okButton({ label: options.okLabel })
            ],
            focusNodeSelector: 'input'
        });
    }
    InputDialog.getPassword = getPassword;
})(InputDialog || (InputDialog = {}));
/**
 * Base widget for input dialog body
 */
class InputDialogBase extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    /**
     * InputDialog constructor
     *
     * @param label Input field label
     */
    constructor(label) {
        super();
        this.addClass(INPUT_DIALOG_CLASS);
        this._input = document.createElement('input');
        this._input.classList.add('jp-mod-styled');
        this._input.id = 'jp-dialog-input-id';
        if (label !== undefined) {
            const labelElement = document.createElement('label');
            labelElement.textContent = label;
            labelElement.htmlFor = this._input.id;
            // Initialize the node
            this.node.appendChild(labelElement);
        }
        this.node.appendChild(this._input);
    }
}
/**
 * Widget body for input boolean dialog
 */
class InputBooleanDialog extends InputDialogBase {
    /**
     * InputBooleanDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options.label);
        this.addClass(INPUT_BOOLEAN_DIALOG_CLASS);
        this._input.type = 'checkbox';
        this._input.checked = options.value ? true : false;
    }
    /**
     * Get the text specified by the user
     */
    getValue() {
        return this._input.checked;
    }
}
/**
 * Widget body for input number dialog
 */
class InputNumberDialog extends InputDialogBase {
    /**
     * InputNumberDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options.label);
        this._input.type = 'number';
        this._input.value = options.value ? options.value.toString() : '0';
    }
    /**
     * Get the number specified by the user.
     */
    getValue() {
        if (this._input.value) {
            return Number(this._input.value);
        }
        else {
            return Number.NaN;
        }
    }
}
/**
 * Widget body for input text dialog
 */
class InputTextDialog extends InputDialogBase {
    /**
     * InputTextDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        var _a;
        super(options.label);
        this._input.type = 'text';
        this._input.value = options.text ? options.text : '';
        if (options.placeholder) {
            this._input.placeholder = options.placeholder;
        }
        this._initialSelectionRange = Math.min(this._input.value.length, Math.max(0, (_a = options.selectionRange) !== null && _a !== void 0 ? _a : this._input.value.length));
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        if (this._initialSelectionRange > 0 && this._input.value) {
            this._input.setSelectionRange(0, this._initialSelectionRange);
        }
    }
    /**
     * Get the text specified by the user
     */
    getValue() {
        return this._input.value;
    }
}
/**
 * Widget body for input password dialog
 */
class InputPasswordDialog extends InputDialogBase {
    /**
     * InputPasswordDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options.label);
        this._input.type = 'password';
        this._input.value = options.text ? options.text : '';
        if (options.placeholder) {
            this._input.placeholder = options.placeholder;
        }
    }
    /**
     *  A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        if (this._input.value) {
            this._input.select();
        }
    }
    /**
     * Get the text specified by the user
     */
    getValue() {
        return this._input.value;
    }
}
/**
 * Widget body for input list dialog
 */
class InputItemsDialog extends InputDialogBase {
    /**
     * InputItemsDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options.label);
        this._editable = options.editable || false;
        let current = options.current || 0;
        let defaultIndex;
        if (typeof current === 'number') {
            defaultIndex = Math.max(0, Math.min(current, options.items.length - 1));
            current = '';
        }
        this._list = document.createElement('select');
        options.items.forEach((item, index) => {
            const option = document.createElement('option');
            if (index === defaultIndex) {
                option.selected = true;
                current = item;
            }
            option.value = item;
            option.textContent = item;
            this._list.appendChild(option);
        });
        if (options.editable) {
            /* Use of list and datalist */
            const data = document.createElement('datalist');
            data.id = 'input-dialog-items';
            data.appendChild(this._list);
            this._input.type = 'list';
            this._input.value = current;
            this._input.setAttribute('list', data.id);
            if (options.placeholder) {
                this._input.placeholder = options.placeholder;
            }
            this.node.appendChild(data);
        }
        else {
            /* Use select directly */
            this._input.remove();
            this.node.appendChild(this._list);
        }
    }
    /**
     * Get the user choice
     */
    getValue() {
        if (this._editable) {
            return this._input.value;
        }
        else {
            return this._list.value;
        }
    }
}
/**
 * Widget body for input list dialog
 */
class InputMultipleItemsDialog extends InputDialogBase {
    /**
     * InputMultipleItemsDialog constructor
     *
     * @param options Constructor options
     */
    constructor(options) {
        super(options.label);
        let defaults = options.defaults || [];
        this._list = document.createElement('select');
        this._list.setAttribute('multiple', '');
        options.items.forEach(item => {
            const option = document.createElement('option');
            option.value = item;
            option.textContent = item;
            this._list.appendChild(option);
        });
        // use the select
        this._input.remove();
        this.node.appendChild(this._list);
        // select the current ones
        const htmlOptions = this._list.options;
        for (let i = 0; i < htmlOptions.length; i++) {
            const option = htmlOptions[i];
            if (defaults.includes(option.value)) {
                option.selected = true;
            }
            else {
                option.selected = false;
            }
        }
    }
    /**
     * Get the user choices
     */
    getValue() {
        let result = [];
        for (let opt of this._list.options) {
            if (opt.selected && !opt.classList.contains('hidden')) {
                result.push(opt.value || opt.text);
            }
        }
        return result;
    }
}
//# sourceMappingURL=inputdialog.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/kernelstatuses.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/kernelstatuses.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KernelStatus: () => (/* binding */ KernelStatus),
/* harmony export */   translateKernelStatuses: () => (/* binding */ translateKernelStatuses)
/* harmony export */ });
/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/statusbar */ "./node_modules/@jupyterlab/statusbar/lib/index.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/vdom.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * Helper function to translate kernel statuses mapping by using
 * input translator.
 *
 * @param translator - Language translator.
 * @return The translated kernel status mapping.
 */
function translateKernelStatuses(translator) {
    translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;
    const trans = translator.load('jupyterlab');
    const translated = {
        unknown: trans.__('Unknown'),
        starting: trans.__('Starting'),
        idle: trans.__('Idle'),
        busy: trans.__('Busy'),
        terminating: trans.__('Terminating'),
        restarting: trans.__('Restarting'),
        autorestarting: trans.__('Autorestarting'),
        dead: trans.__('Dead'),
        connected: trans.__('Connected'),
        connecting: trans.__('Connecting'),
        disconnected: trans.__('Disconnected'),
        initializing: trans.__('Initializing'),
        '': ''
    };
    return translated;
}
/**
 * A pure functional component for rendering kernel status.
 */
function KernelStatusComponent(props) {
    const translator = props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;
    const trans = translator.load('jupyterlab');
    let statusText = '';
    if (props.status) {
        statusText = ` | ${props.status}`;
    }
    return (react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_0__.TextItem, { onClick: props.handleClick, source: `${props.kernelName}${statusText}`, title: trans.__('Change kernel for %1', props.activityName) }));
}
/**
 * A VDomRenderer widget for displaying the status of a kernel.
 */
class KernelStatus extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.VDomRenderer {
    /**
     * Construct the kernel status widget.
     */
    constructor(opts, translator) {
        super(new KernelStatus.Model(translator));
        this.translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;
        this._handleClick = opts.onClick;
        this.addClass('jp-mod-highlighted');
    }
    /**
     * Render the kernel status item.
     */
    render() {
        if (this.model === null) {
            return null;
        }
        else {
            return (react__WEBPACK_IMPORTED_MODULE_3___default().createElement(KernelStatusComponent, { status: this.model.status, kernelName: this.model.kernelName, activityName: this.model.activityName, handleClick: this._handleClick, translator: this.translator }));
        }
    }
}
/**
 * A namespace for KernelStatus statics.
 */
(function (KernelStatus) {
    /**
     * A VDomModel for the kernel status indicator.
     */
    class Model extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.VDomModel {
        constructor(translator) {
            super();
            this._activityName = '';
            this._kernelName = '';
            this._kernelStatus = '';
            this._sessionContext = null;
            translator = translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;
            this._trans = translator.load('jupyterlab');
            this._statusNames = translateKernelStatuses(translator);
        }
        /**
         * The name of the kernel.
         */
        get kernelName() {
            return this._kernelName;
        }
        /**
         * The current status of the kernel.
         */
        get status() {
            return this._kernelStatus
                ? this._statusNames[this._kernelStatus]
                : undefined;
        }
        /**
         * A display name for the activity.
         */
        get activityName() {
            return this._activityName;
        }
        set activityName(val) {
            const oldVal = this._activityName;
            if (oldVal === val) {
                return;
            }
            this._activityName = val;
            this.stateChanged.emit();
        }
        /**
         * The current client session associated with the kernel status indicator.
         */
        get sessionContext() {
            return this._sessionContext;
        }
        set sessionContext(sessionContext) {
            var _a, _b, _c, _d;
            (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.statusChanged.disconnect(this._onKernelStatusChanged, this);
            (_b = this._sessionContext) === null || _b === void 0 ? void 0 : _b.connectionStatusChanged.disconnect(this._onKernelStatusChanged, this);
            (_c = this._sessionContext) === null || _c === void 0 ? void 0 : _c.kernelChanged.disconnect(this._onKernelChanged, this);
            const oldState = this._getAllState();
            this._sessionContext = sessionContext;
            this._kernelStatus = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayStatus;
            this._kernelName =
                (_d = sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayName) !== null && _d !== void 0 ? _d : this._trans.__('No Kernel');
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.statusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.connectionStatusChanged.connect(this._onKernelStatusChanged, this);
            sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelChanged.connect(this._onKernelChanged, this);
            this._triggerChange(oldState, this._getAllState());
        }
        /**
         * React to changes to the kernel status.
         */
        _onKernelStatusChanged() {
            var _a;
            this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
            this.stateChanged.emit(void 0);
        }
        /**
         * React to changes in the kernel.
         */
        _onKernelChanged(_sessionContext, change) {
            var _a;
            const oldState = this._getAllState();
            // sync setting of status and display name
            this._kernelStatus = (_a = this._sessionContext) === null || _a === void 0 ? void 0 : _a.kernelDisplayStatus;
            this._kernelName = _sessionContext.kernelDisplayName;
            this._triggerChange(oldState, this._getAllState());
        }
        _getAllState() {
            return [this._kernelName, this._kernelStatus, this._activityName];
        }
        _triggerChange(oldState, newState) {
            if (_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.JSONExt.deepEqual(oldState, newState)) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    KernelStatus.Model = Model;
})(KernelStatus || (KernelStatus = {}));
//# sourceMappingURL=kernelstatuses.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/mainareawidget.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/mainareawidget.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MainAreaWidget: () => (/* binding */ MainAreaWidget)
/* harmony export */ });
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/spinner.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/toolbar.js");
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/messaging */ "./node_modules/@lumino/messaging/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var _domutils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./domutils */ "./node_modules/@jupyterlab/apputils/lib/domutils.js");
/* harmony import */ var _printing__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./printing */ "./node_modules/@jupyterlab/apputils/lib/printing.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * A flag to indicate that event handlers are caught in the capture phase.
 */
const USE_CAPTURE = true;
/**
 * A widget meant to be contained in the JupyterLab main area.
 *
 * #### Notes
 * Mirrors all of the `title` attributes of the content.
 * This widget is `closable` by default.
 * This widget is automatically disposed when closed.
 * This widget ensures its own focus when activated.
 */
class MainAreaWidget extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {
    /**
     * Construct a new main area widget.
     *
     * @param options - The options for initializing the widget.
     */
    constructor(options) {
        super(options);
        this._changeGuard = false;
        this._spinner = new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.Spinner();
        this._isRevealed = false;
        this._evtMouseDown = () => {
            if (!this.node.contains(document.activeElement)) {
                this._focusContent();
            }
        };
        this.addClass('jp-MainAreaWidget');
        // Set contain=strict to avoid many forced layout rendering while adding cells.
        // Don't forget to remove the CSS class when your remove the spinner to allow
        // the content to be rendered.
        // @see https://github.com/jupyterlab/jupyterlab/issues/9381
        this.addClass('jp-MainAreaWidget-ContainStrict');
        this.id = _domutils__WEBPACK_IMPORTED_MODULE_4__.DOMUtils.createDomID();
        const trans = (options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');
        const content = (this._content = options.content);
        content.node.setAttribute('role', 'region');
        content.node.setAttribute('aria-label', trans.__('notebook content'));
        const toolbar = (this._toolbar = options.toolbar || new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_5__.ReactiveToolbar());
        toolbar.node.setAttribute('role', 'navigation');
        toolbar.node.setAttribute('aria-label', trans.__('notebook actions'));
        const contentHeader = (this._contentHeader =
            options.contentHeader ||
                new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.BoxPanel({
                    direction: 'top-to-bottom',
                    spacing: 0
                }));
        const layout = (this.layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.BoxLayout({ spacing: 0 }));
        layout.direction = 'top-to-bottom';
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.BoxLayout.setStretch(toolbar, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.BoxLayout.setStretch(contentHeader, 0);
        _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.BoxLayout.setStretch(content, 1);
        layout.addWidget(toolbar);
        layout.addWidget(contentHeader);
        layout.addWidget(content);
        if (!content.id) {
            content.id = _domutils__WEBPACK_IMPORTED_MODULE_4__.DOMUtils.createDomID();
        }
        content.node.tabIndex = -1;
        this._updateTitle();
        content.title.changed.connect(this._updateTitle, this);
        this.title.closable = true;
        this.title.changed.connect(this._updateContentTitle, this);
        if (options.reveal) {
            this.node.appendChild(this._spinner.node);
            this._revealed = options.reveal
                .then(() => {
                if (content.isDisposed) {
                    this.dispose();
                    return;
                }
                content.disposed.connect(() => this.dispose());
                const active = document.activeElement === this._spinner.node;
                this._disposeSpinner();
                this._isRevealed = true;
                if (active) {
                    this._focusContent();
                }
            })
                .catch(e => {
                // Show a revealed promise error.
                const error = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget();
                error.addClass('jp-MainAreaWidget-error');
                // Show the error to the user.
                const pre = document.createElement('pre');
                pre.textContent = String(e);
                error.node.appendChild(pre);
                _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.BoxLayout.setStretch(error, 1);
                this._disposeSpinner();
                content.dispose();
                this._content = null;
                toolbar.dispose();
                this._toolbar = null;
                layout.addWidget(error);
                this._isRevealed = true;
                throw error;
            });
        }
        else {
            // Handle no reveal promise.
            this._spinner.dispose();
            this.removeClass('jp-MainAreaWidget-ContainStrict');
            content.disposed.connect(() => this.dispose());
            this._isRevealed = true;
            this._revealed = Promise.resolve(undefined);
        }
    }
    /**
     * Print method. Deferred to content.
     */
    [_printing__WEBPACK_IMPORTED_MODULE_6__.Printing.symbol]() {
        if (!this._content) {
            return null;
        }
        return _printing__WEBPACK_IMPORTED_MODULE_6__.Printing.getPrintFunction(this._content);
    }
    /**
     * The content hosted by the widget.
     */
    get content() {
        return this._content;
    }
    /**
     * The toolbar hosted by the widget.
     */
    get toolbar() {
        return this._toolbar;
    }
    /**
     * A panel for widgets that sit between the toolbar and the content.
     * Imagine a formatting toolbar, notification headers, etc.
     */
    get contentHeader() {
        return this._contentHeader;
    }
    /**
     * Whether the content widget or an error is revealed.
     */
    get isRevealed() {
        return this._isRevealed;
    }
    /**
     * A promise that resolves when the widget is revealed.
     */
    get revealed() {
        return this._revealed;
    }
    /**
     * Handle `'activate-request'` messages.
     */
    onActivateRequest(msg) {
        if (this._isRevealed) {
            this._focusContent();
        }
        else {
            this._spinner.node.focus();
        }
    }
    /**
     * Handle `after-attach` messages for the widget.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        // Focus content in capture phase to ensure relevant commands operate on the
        // current main area widget.
        // Add the event listener directly instead of using `handleEvent` in order
        // to save sub-classes from needing to reason about calling it as well.
        this.node.addEventListener('mousedown', this._evtMouseDown, USE_CAPTURE);
    }
    /**
     * Handle `before-detach` messages for the widget.
     */
    onBeforeDetach(msg) {
        this.node.removeEventListener('mousedown', this._evtMouseDown, USE_CAPTURE);
        super.onBeforeDetach(msg);
    }
    /**
     * Handle `'close-request'` messages.
     */
    onCloseRequest(msg) {
        this.dispose();
    }
    /**
     * Handle `'update-request'` messages by forwarding them to the content.
     */
    onUpdateRequest(msg) {
        if (this._content) {
            _lumino_messaging__WEBPACK_IMPORTED_MODULE_1__.MessageLoop.sendMessage(this._content, msg);
        }
    }
    _disposeSpinner() {
        this.node.removeChild(this._spinner.node);
        this._spinner.dispose();
        this.removeClass('jp-MainAreaWidget-ContainStrict');
    }
    /**
     * Update the title based on the attributes of the child widget.
     */
    _updateTitle() {
        if (this._changeGuard || !this.content) {
            return;
        }
        this._changeGuard = true;
        const content = this.content;
        this.title.label = content.title.label;
        this.title.mnemonic = content.title.mnemonic;
        this.title.icon = content.title.icon;
        this.title.iconClass = content.title.iconClass;
        this.title.iconLabel = content.title.iconLabel;
        this.title.caption = content.title.caption;
        this.title.className = content.title.className;
        this.title.dataset = content.title.dataset;
        this._changeGuard = false;
    }
    /**
     * Update the content title based on attributes of the main widget.
     */
    _updateContentTitle() {
        if (this._changeGuard || !this.content) {
            return;
        }
        this._changeGuard = true;
        const content = this.content;
        content.title.label = this.title.label;
        content.title.mnemonic = this.title.mnemonic;
        content.title.icon = this.title.icon;
        content.title.iconClass = this.title.iconClass;
        content.title.iconLabel = this.title.iconLabel;
        content.title.caption = this.title.caption;
        content.title.className = this.title.className;
        content.title.dataset = this.title.dataset;
        this._changeGuard = false;
    }
    /**
     * Give focus to the content.
     */
    _focusContent() {
        if (!this.content) {
            return;
        }
        // Focus the content node if we aren't already focused on it or a
        // descendent.
        if (!this.content.node.contains(document.activeElement)) {
            this.content.node.focus();
        }
        // Activate the content asynchronously (which may change the focus).
        this.content.activate();
    }
}
//# sourceMappingURL=mainareawidget.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/menufactory.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/menufactory.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   MenuFactory: () => (/* binding */ MenuFactory)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/labicon.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * Helper functions to build a menu from the settings
 */
var MenuFactory;
(function (MenuFactory) {
    /**
     * Create menus from their description
     *
     * @param data Menubar description
     * @param menuFactory Factory for empty menu
     */
    function createMenus(data, menuFactory) {
        return data
            .filter(item => !item.disabled)
            .sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); })
            .map(menuItem => {
            return dataToMenu(menuItem, menuFactory);
        });
    }
    MenuFactory.createMenus = createMenus;
    /**
     * Convert a menu description in a JupyterLabMenu object
     *
     * @param item Menu description
     * @param menuFactory Empty menu factory
     * @returns The menu widget
     */
    function dataToMenu(item, menuFactory) {
        var _a, _b;
        const menu = menuFactory(item);
        menu.id = item.id;
        // Set the label in case the menu factory did not.
        if (!menu.title.label) {
            menu.title.label = (_a = item.label) !== null && _a !== void 0 ? _a : _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Text.titleCase(menu.id.trim());
        }
        if (item.icon) {
            menu.title.icon = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.LabIcon.resolve({ icon: item.icon });
        }
        if (item.mnemonic !== undefined) {
            menu.title.mnemonic = item.mnemonic;
        }
        (_b = item.items) === null || _b === void 0 ? void 0 : _b.filter(item => !item.disabled).sort((a, b) => { var _a, _b; return ((_a = a.rank) !== null && _a !== void 0 ? _a : Infinity) - ((_b = b.rank) !== null && _b !== void 0 ? _b : Infinity); }).map(item => {
            addItem(item, menu, menuFactory);
        });
        return menu;
    }
    /**
     * Convert an item description in a context menu item object
     *
     * @param item Context menu item
     * @param menu Context menu to populate
     * @param menuFactory Empty menu factory
     */
    function addContextItem(item, menu, menuFactory) {
        const { submenu, ...newItem } = item;
        // Commands may not have been registered yet; so we don't force it to exist
        menu.addItem({
            ...newItem,
            submenu: submenu ? dataToMenu(submenu, menuFactory) : null
        });
    }
    MenuFactory.addContextItem = addContextItem;
    /**
     * Convert an item description in a menu item object
     *
     * @param item Menu item
     * @param menu Menu to populate
     * @param menuFactory Empty menu factory
     */
    function addItem(item, menu, menuFactory) {
        const { submenu, ...newItem } = item;
        // Commands may not have been registered yet; so we don't force it to exist
        menu.addItem({
            ...newItem,
            submenu: submenu ? dataToMenu(submenu, menuFactory) : null
        });
    }
    /**
     * Update an existing list of menu and returns
     * the new elements.
     *
     * #### Note
     * New elements are added to the current menu list.
     *
     * @param menus Current menus
     * @param data New description to take into account
     * @param menuFactory Empty menu factory
     * @returns Newly created menus
     */
    function updateMenus(menus, data, menuFactory) {
        const newMenus = [];
        data.forEach(item => {
            const menu = menus.find(menu => menu.id === item.id);
            if (menu) {
                mergeMenus(item, menu, menuFactory);
            }
            else {
                if (!item.disabled) {
                    newMenus.push(dataToMenu(item, menuFactory));
                }
            }
        });
        menus.push(...newMenus);
        return newMenus;
    }
    MenuFactory.updateMenus = updateMenus;
    function mergeMenus(item, menu, menuFactory) {
        var _a;
        if (item.disabled) {
            menu.dispose();
        }
        else {
            (_a = item.items) === null || _a === void 0 ? void 0 : _a.forEach(entry => {
                var _a, _b;
                const existingItem = menu === null || menu === void 0 ? void 0 : menu.items.find((i, idx) => {
                    var _a, _b, _c;
                    return i.type === entry.type &&
                        i.command === ((_a = entry.command) !== null && _a !== void 0 ? _a : '') &&
                        ((_b = i.submenu) === null || _b === void 0 ? void 0 : _b.id) === ((_c = entry.submenu) === null || _c === void 0 ? void 0 : _c.id);
                });
                if (existingItem && entry.type !== 'separator') {
                    if (entry.disabled) {
                        menu.removeItem(existingItem);
                    }
                    else {
                        switch ((_a = entry.type) !== null && _a !== void 0 ? _a : 'command') {
                            case 'command':
                                if (entry.command) {
                                    if (!_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.deepEqual(existingItem.args, (_b = entry.args) !== null && _b !== void 0 ? _b : {})) {
                                        addItem(entry, menu, menuFactory);
                                    }
                                }
                                break;
                            case 'submenu':
                                if (entry.submenu) {
                                    mergeMenus(entry.submenu, existingItem.submenu, menuFactory);
                                }
                        }
                    }
                }
                else {
                    addItem(entry, menu, menuFactory);
                }
            });
        }
    }
})(MenuFactory || (MenuFactory = {}));
//# sourceMappingURL=menufactory.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/notification.js":
/*!***************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/notification.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Notification: () => (/* binding */ Notification),
/* harmony export */   NotificationManager: () => (/* binding */ NotificationManager)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Notification manager
 */
class NotificationManager {
    constructor() {
        this._isDisposed = false;
        this._queue = [];
        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
    }
    /**
     * Signal emitted whenever a notification changes.
     */
    get changed() {
        return this._changed;
    }
    /**
     * Total number of notifications.
     */
    get count() {
        return this._queue.length;
    }
    /**
     * Whether the manager is disposed or not.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * The list of notifications.
     */
    get notifications() {
        return this._queue.slice();
    }
    /**
     * Dismiss one notification (specified by its id) or all if no id provided.
     *
     * @param id Notification id
     */
    dismiss(id) {
        if (typeof id === 'undefined') {
            const q = this._queue.slice();
            this._queue.length = 0;
            for (const notification of q) {
                this._changed.emit({
                    type: 'removed',
                    notification
                });
            }
        }
        else {
            const notificationIndex = this._queue.findIndex(n => n.id === id);
            if (notificationIndex > -1) {
                const notification = this._queue.splice(notificationIndex, 1)[0];
                this._changed.emit({
                    type: 'removed',
                    notification
                });
            }
        }
    }
    /**
     * Dispose the manager.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);
    }
    /**
     * Test whether a notification exists or not.
     *
     * @param id Notification id
     * @returns Notification status
     */
    has(id) {
        return this._queue.findIndex(n => n.id === id) > -1;
    }
    /**
     * Add a new notification.
     *
     * This will trigger the `changed` signal with an `added` event.
     *
     * @param message Notification message
     * @param type Notification type
     * @param options Notification option
     * @returns Notification unique id
     */
    notify(message, type, options) {
        const now = Date.now();
        const { progress, ...othersOptions } = options;
        const notification = Object.freeze({
            id: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.UUID.uuid4(),
            createdAt: now,
            modifiedAt: now,
            message,
            type,
            options: {
                // By default notification will be silent
                autoClose: 0,
                progress: typeof progress === 'number'
                    ? Math.min(Math.max(0, progress), 1)
                    : progress,
                ...othersOptions
            }
        });
        this._queue.unshift(notification);
        this._changed.emit({
            type: 'added',
            notification
        });
        return notification.id;
    }
    /**
     * Update an existing notification.
     *
     * If the notification does not exists this won't do anything.
     *
     * Once updated the notification will be moved at the begin
     * of the notification stack.
     *
     * @param args Update options
     * @returns Whether the update was successful or not.
     */
    update(args) {
        const { id, message, actions, autoClose, data, progress, type } = args;
        const newProgress = typeof progress === 'number'
            ? Math.min(Math.max(0, progress), 1)
            : progress;
        const notificationIndex = this._queue.findIndex(n => n.id === id);
        if (notificationIndex > -1) {
            const oldNotification = this._queue[notificationIndex];
            // We need to create a new object as notification are frozen; i.e. cannot be edited
            const notification = Object.freeze({
                ...oldNotification,
                message: message !== null && message !== void 0 ? message : oldNotification.message,
                type: type !== null && type !== void 0 ? type : oldNotification.type,
                options: {
                    actions: actions !== null && actions !== void 0 ? actions : oldNotification.options.actions,
                    autoClose: autoClose !== null && autoClose !== void 0 ? autoClose : oldNotification.options.autoClose,
                    data: data !== null && data !== void 0 ? data : oldNotification.options.data,
                    progress: newProgress !== null && newProgress !== void 0 ? newProgress : oldNotification.options.progress
                },
                modifiedAt: Date.now()
            });
            this._queue.splice(notificationIndex, 1);
            this._queue.unshift(notification);
            this._changed.emit({
                type: 'updated',
                notification
            });
            return true;
        }
        return false;
    }
}
/**
 * Notification namespace
 */
var Notification;
(function (Notification) {
    /**
     * The global notification manager.
     */
    Notification.manager = new NotificationManager();
    /**
     * Dismiss one notification (specified by its id) or all if no id provided
     *
     * @param id notification id
     */
    function dismiss(id) {
        Notification.manager.dismiss(id);
    }
    Notification.dismiss = dismiss;
    /**
     * Helper function to emit a notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param type Notification type
     * @param options Options for the error notification
     * @returns Notification unique id
     */
    function emit(message, type = 'default', options = {}) {
        return Notification.manager.notify(message, type, options);
    }
    Notification.emit = emit;
    /**
     * Helper function to emit an error notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the error notification
     * @returns Notification unique id
     */
    function error(message, options = {}) {
        return Notification.manager.notify(message, 'error', options);
    }
    Notification.error = error;
    /**
     * Helper function to emit an info notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the info notification
     * @returns Notification unique id
     */
    function info(message, options = {}) {
        return Notification.manager.notify(message, 'info', options);
    }
    Notification.info = info;
    /**
     * Helper function to show an in-progress notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param promise Promise to wait for
     * @param options Options for the in-progress notification
     * @returns Notification unique id
     */
    function promise(promise, options) {
        var _a;
        const { pending, error, success } = options;
        const id = Notification.manager.notify(pending.message, 'in-progress', (_a = pending.options) !== null && _a !== void 0 ? _a : {});
        promise
            .then(result => {
            var _a, _b, _c;
            Notification.manager.update({
                id,
                message: success.message(result, (_a = success.options) === null || _a === void 0 ? void 0 : _a.data),
                type: 'success',
                ...success.options,
                data: (_c = (_b = success.options) === null || _b === void 0 ? void 0 : _b.data) !== null && _c !== void 0 ? _c : result
            });
        })
            .catch(reason => {
            var _a, _b, _c;
            Notification.manager.update({
                id,
                message: error.message(reason, (_a = error.options) === null || _a === void 0 ? void 0 : _a.data),
                type: 'error',
                ...error.options,
                data: (_c = (_b = error.options) === null || _b === void 0 ? void 0 : _b.data) !== null && _c !== void 0 ? _c : reason
            });
        });
        return id;
    }
    Notification.promise = promise;
    /**
     * Helper function to emit a success notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the success notification
     * @returns Notification unique id
     */
    function success(message, options = {}) {
        return Notification.manager.notify(message, 'success', options);
    }
    Notification.success = success;
    /**
     * Helper function to update a notification.
     *
     * If the notification does not exists, nothing will happen.
     *
     * Once updated the notification will be moved at the begin
     * of the notification stack.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param args Update options
     * @returns Whether the update was successful or not.
     */
    function update(args) {
        return Notification.manager.update(args);
    }
    Notification.update = update;
    /**
     * Helper function to emit a warning notification.
     *
     * #### Notes
     * The message will be truncated if longer than 140 characters.
     *
     * @param message Notification message
     * @param options Options for the warning notification
     * @returns Notification unique id
     */
    function warning(message, options = {}) {
        return Notification.manager.notify(message, 'warning', options);
    }
    Notification.warning = warning;
})(Notification || (Notification = {}));
//# sourceMappingURL=notification.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/printing.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/printing.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Printing: () => (/* binding */ Printing)
/* harmony export */ });
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/services */ "./node_modules/@jupyterlab/services/lib/index.js");
/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * Any object is "printable" if it implements the `IPrintable` interface.
 *
 * To do this it, it must have a method called `Printing.symbol` which returns either a function
 * to print the object or null if it cannot be printed.
 *
 * One way of printing is to use the `printWidget` function, which creates a hidden iframe
 * and copies the DOM nodes from your widget to that iframe and printing just that iframe.
 *
 * Another way to print is to use the `printURL` function, which takes a URL and prints that page.
 */
var Printing;
(function (Printing) {
    /**
     * Symbol to use for a method that returns a function to print an object.
     */
    Printing.symbol = Symbol('printable');
    /**
     * Returns whether an object implements a print method.
     */
    function isPrintable(a) {
        if (typeof a !== 'object' || !a) {
            return false;
        }
        return Printing.symbol in a;
    }
    Printing.isPrintable = isPrintable;
    /**
     * Returns the print function for an object, or null if it does not provide a handler.
     */
    function getPrintFunction(val) {
        if (isPrintable(val)) {
            return val[Printing.symbol]();
        }
        return null;
    }
    Printing.getPrintFunction = getPrintFunction;
    /**
     * Prints a widget by copying it's DOM node
     * to a hidden iframe and printing that iframe.
     */
    function printWidget(widget) {
        return printContent(widget.node);
    }
    Printing.printWidget = printWidget;
    /**
     * Prints a URL by loading it into an iframe.
     *
     * @param url URL to load into an iframe.
     */
    async function printURL(url) {
        const settings = _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeSettings();
        const text = await (await _jupyterlab_services__WEBPACK_IMPORTED_MODULE_0__.ServerConnection.makeRequest(url, {}, settings)).text();
        return printContent(text);
    }
    Printing.printURL = printURL;
    /**
     * Prints a URL or an element in an iframe and then removes the iframe after printing.
     */
    async function printContent(textOrEl) {
        const isText = typeof textOrEl === 'string';
        const iframe = createIFrame();
        const parent = window.document.body;
        parent.appendChild(iframe);
        if (isText) {
            iframe.srcdoc = textOrEl;
            await resolveWhenLoaded(iframe);
        }
        else {
            iframe.src = 'about:blank';
            await resolveWhenLoaded(iframe);
            setIFrameNode(iframe, textOrEl);
        }
        const printed = resolveAfterEvent();
        launchPrint(iframe.contentWindow);
        // Once the print dialog has been dismissed, we regain event handling,
        // and it should be safe to discard the hidden iframe.
        await printed;
        parent.removeChild(iframe);
    }
    /**
     * Creates a new hidden iframe and appends it to the document
     *
     * Modified from
     * https://github.com/joseluisq/printd/blob/eb7948d602583c055ab6dee3ee294b6a421da4b6/src/index.ts#L24
     */
    function createIFrame() {
        const el = window.document.createElement('iframe');
        // We need both allow-modals and allow-same-origin to be able to
        // call print in the iframe.
        // We intentionally do not allow scripts:
        // https://github.com/jupyterlab/jupyterlab/pull/5850#pullrequestreview-230899790
        el.setAttribute('sandbox', 'allow-modals allow-same-origin');
        const css = 'visibility:hidden;width:0;height:0;position:absolute;z-index:-9999;bottom:0;';
        el.setAttribute('style', css);
        el.setAttribute('width', '0');
        el.setAttribute('height', '0');
        return el;
    }
    /**
     * Copies a node from the base document to the iframe.
     */
    function setIFrameNode(iframe, node) {
        iframe.contentDocument.body.appendChild(node.cloneNode(true));
        iframe.contentDocument.close();
    }
    /**
     * Promise that resolves when all resources are loaded in the window.
     */
    function resolveWhenLoaded(iframe) {
        return new Promise(resolve => {
            iframe.onload = () => resolve();
        });
    }
    /**
     * A promise that resolves after the next mousedown, mousemove, or
     * keydown event. We use this as a proxy for determining when the
     * main window has regained control after the print dialog is removed.
     *
     * We can't use the usual window.onafterprint handler because we
     * disallow Javascript execution in the print iframe.
     */
    function resolveAfterEvent() {
        return new Promise(resolve => {
            const onEvent = () => {
                document.removeEventListener('mousemove', onEvent, true);
                document.removeEventListener('mousedown', onEvent, true);
                document.removeEventListener('keydown', onEvent, true);
                resolve();
            };
            document.addEventListener('mousemove', onEvent, true);
            document.addEventListener('mousedown', onEvent, true);
            document.addEventListener('keydown', onEvent, true);
        });
    }
    /**
     * Prints a content window.
     */
    function launchPrint(contentWindow) {
        const result = contentWindow.document.execCommand('print', false);
        // execCommand won't work in firefox so we call the `print` method instead if it fails
        // https://github.com/joseluisq/printd/blob/eb7948d602583c055ab6dee3ee294b6a421da4b6/src/index.ts#L148
        if (!result) {
            contentWindow.print();
        }
    }
})(Printing || (Printing = {}));
//# sourceMappingURL=printing.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/runningSessions.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/runningSessions.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RunningSessions: () => (/* binding */ RunningSessions)
/* harmony export */ });
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/vdom.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/statusbar */ "./node_modules/@jupyterlab/statusbar/lib/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * Half spacing between subitems in a status item.
 */
const HALF_SPACING = 4;
/**
 * A pure functional component for rendering kernel and terminal sessions.
 *
 * @param props: the props for the component.
 *
 * @returns a tsx component for the running sessions.
 */
function RunningSessionsComponent(props) {
    return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_2__.GroupItem, { spacing: HALF_SPACING, onClick: props.handleClick },
        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_2__.GroupItem, { spacing: HALF_SPACING },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_2__.TextItem, { source: props.terminals }),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.terminalIcon.react, { left: '1px', top: '3px', stylesheet: 'statusBar' })),
        react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_2__.GroupItem, { spacing: HALF_SPACING },
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_2__.TextItem, { source: props.sessions }),
            react__WEBPACK_IMPORTED_MODULE_1___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.kernelIcon.react, { top: '2px', stylesheet: 'statusBar' }))));
}
/**
 * A VDomRenderer for a RunningSessions status item.
 */
class RunningSessions extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.VDomRenderer {
    /**
     * Create a new RunningSessions widget.
     */
    constructor(opts) {
        super(new RunningSessions.Model());
        this._serviceManager = opts.serviceManager;
        this._handleClick = opts.onClick;
        this.translator = opts.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this._serviceManager.sessions.runningChanged.connect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.connect(this._onTerminalsRunningChanged, this);
        this.addClass('jp-mod-highlighted');
    }
    /**
     * Render the running sessions widget.
     */
    render() {
        if (!this.model) {
            return null;
        }
        // TODO-TRANS: Should probably be handled differently.
        // This is more localizable friendly: "Terminals: %1 | Kernels: %2"
        this.title.caption = this._trans.__('%1 Terminals, %2 Kernel sessions', this.model.terminals, this.model.sessions);
        return (react__WEBPACK_IMPORTED_MODULE_1___default().createElement(RunningSessionsComponent, { sessions: this.model.sessions, terminals: this.model.terminals, handleClick: this._handleClick }));
    }
    /**
     * Dispose of the status item.
     */
    dispose() {
        super.dispose();
        this._serviceManager.sessions.runningChanged.disconnect(this._onSessionsRunningChanged, this);
        this._serviceManager.terminals.runningChanged.disconnect(this._onTerminalsRunningChanged, this);
    }
    /**
     * Set the number of kernel sessions when the list changes.
     */
    _onSessionsRunningChanged(manager, sessions) {
        this.model.sessions = sessions.length;
    }
    /**
     * Set the number of terminal sessions when the list changes.
     */
    _onTerminalsRunningChanged(manager, terminals) {
        this.model.terminals = terminals.length;
    }
}
/**
 * A namespace for RunningSessions statics.
 */
(function (RunningSessions) {
    /**
     * A VDomModel for the RunningSessions status item.
     */
    class Model extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.VDomModel {
        constructor() {
            super(...arguments);
            this._terminals = 0;
            this._sessions = 0;
        }
        /**
         * The number of active kernel sessions.
         */
        get sessions() {
            return this._sessions;
        }
        set sessions(sessions) {
            const oldSessions = this._sessions;
            this._sessions = sessions;
            if (oldSessions !== this._sessions) {
                this.stateChanged.emit(void 0);
            }
        }
        /**
         * The number of active terminal sessions.
         */
        get terminals() {
            return this._terminals;
        }
        set terminals(terminals) {
            const oldTerminals = this._terminals;
            this._terminals = terminals;
            if (oldTerminals !== this._terminals) {
                this.stateChanged.emit(void 0);
            }
        }
    }
    RunningSessions.Model = Model;
})(RunningSessions || (RunningSessions = {}));
//# sourceMappingURL=runningSessions.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/sanitizer.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/sanitizer.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Sanitizer: () => (/* binding */ Sanitizer)
/* harmony export */ });
/* harmony import */ var sanitize_html__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! sanitize-html */ "./node_modules/sanitize-html/index.js");
/* harmony import */ var sanitize_html__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(sanitize_html__WEBPACK_IMPORTED_MODULE_0__);
/* eslint-disable camelcase */
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * Helper class that contains regular expressions for inline CSS style validation.
 *
 * Which properties (and values) to allow is largely based on the Google Caja project:
 *   https://github.com/google/caja
 *
 * The regular expressions are largly based on the syntax definition found at
 * https://developer.mozilla.org/en-US/docs/Web/CSS.
 */
class CssProp {
    static reg(r) {
        return new RegExp('^' + r + '$', 'i');
    }
}
/*
 * Numeric base expressions used to help build more complex regular expressions
 */
CssProp.N = {
    integer: `[+-]?[0-9]+`,
    integer_pos: `[+]?[0-9]+`,
    integer_zero_ff: `([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])`,
    number: `[+-]?([0-9]*[.])?[0-9]+(e-?[0-9]*)?`,
    number_pos: `[+]?([0-9]*[.])?[0-9]+(e-?[0-9]*)?`,
    number_zero_hundred: `[+]?(([0-9]|[1-9][0-9])([.][0-9]+)?|100)`,
    number_zero_one: `[+]?(1([.][0]+)?|0?([.][0-9]+)?)`
};
/*
 * Base expressions of common CSS syntax elements
 */
CssProp.B = {
    angle: `(${CssProp.N.number}(deg|rad|grad|turn)|0)`,
    frequency: `${CssProp.N.number}(Hz|kHz)`,
    ident: String.raw `-?([_a-z]|[\xA0-\xFF]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])([_a-z0-9-]|[\xA0-\xFF]|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*`,
    len_or_perc: `(0|${CssProp.N.number}(px|em|rem|ex|in|cm|mm|pt|pc|%))`,
    length: `(${CssProp.N.number}(px|em|rem|ex|in|cm|mm|pt|pc)|0)`,
    length_pos: `(${CssProp.N.number_pos}(px|em|rem|ex|in|cm|mm|pt|pc)|0)`,
    percentage: `${CssProp.N.number}%`,
    percentage_pos: `${CssProp.N.number_pos}%`,
    percentage_zero_hundred: `${CssProp.N.number_zero_hundred}%`,
    string: String.raw `(\"([^\n\r\f\\"]|\\\n|\r\n|\r|\f|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*\")|(\'([^\n\r\f\\']|\\\n|\r\n|\r|\f|\\[0-9a-f]{1,6}(\r\n|[ \t\r\n\f])?|\\[^\r\n\f0-9a-f])*\')`,
    time: `${CssProp.N.number}(s|ms)`,
    url: `url\\(.*?\\)`,
    z_index: `[+-]?[0-9]{1,7}`
};
/*
 * Atomic (i.e. not dependant on other regular expressions) sub RegEx segments
 */
CssProp.A = {
    absolute_size: `xx-small|x-small|small|medium|large|x-large|xx-large`,
    attachment: `scroll|fixed|local`,
    bg_origin: `border-box|padding-box|content-box`,
    border_style: `none|hidden|dotted|dashed|solid|double|groove|ridge|inset|outset`,
    box: `border-box|padding-box|content-box`,
    display_inside: `auto|block|table|flex|grid`,
    display_outside: `block-level|inline-level|none|table-row-group|table-header-group|table-footer-group|table-row|table-cell|table-column-group|table-column|table-caption`,
    ending_shape: `circle|ellipse`,
    generic_family: `serif|sans-serif|cursive|fantasy|monospace`,
    generic_voice: `male|female|child`,
    relative_size: `smaller|larger`,
    repeat_style: `repeat-x|repeat-y|((?:repeat|space|round|no-repeat)(?:\\s*(?:repeat|space|round|no-repeat))?)`,
    side_or_corner: `(left|right)?\\s*(top|bottom)?`,
    single_animation_direction: `normal|reverse|alternate|alternate-reverse`,
    single_animation_fill_mode: `none|forwards|backwards|both`,
    single_animation_play_state: `running|paused`
};
/*
 * Color definition sub expressions
 */
CssProp._COLOR = {
    hex: `\\#(0x)?[0-9a-f]+`,
    name: `aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|transparent|violet|wheat|white|whitesmoke|yellow|yellowgreen`,
    rgb: String.raw `rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)`,
    rgba: String.raw `rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(${CssProp.N.integer_zero_ff}|${CssProp.N.number_zero_one}|${CssProp.B.percentage_zero_hundred})\s*\)`
};
/*
 * Compound (i.e. dependant on other (sub) regular expressions) sub RegEx segments
 */
CssProp._C = {
    alpha: `${CssProp.N.integer_zero_ff}|${CssProp.N.number_zero_one}|${CssProp.B.percentage_zero_hundred}`,
    alphavalue: CssProp.N.number_zero_one,
    bg_position: `((${CssProp.B.len_or_perc}|left|center|right|top|bottom)\\s*){1,4}`,
    bg_size: `(${CssProp.B.length_pos}|${CssProp.B.percentage}|auto){1,2}|cover|contain`,
    border_width: `thin|medium|thick|${CssProp.B.length}`,
    bottom: `${CssProp.B.length}|auto`,
    color: `${CssProp._COLOR.hex}|${CssProp._COLOR.rgb}|${CssProp._COLOR.rgba}|${CssProp._COLOR.name}`,
    color_stop_length: `(${CssProp.B.len_or_perc}\\s*){1,2}`,
    linear_color_hint: `${CssProp.B.len_or_perc}`,
    family_name: `${CssProp.B.string}|(${CssProp.B.ident}\\s*)+`,
    image_decl: CssProp.B.url,
    left: `${CssProp.B.length}|auto`,
    loose_quotable_words: `(${CssProp.B.ident})+`,
    margin_width: `${CssProp.B.len_or_perc}|auto`,
    padding_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    page_url: CssProp.B.url,
    position: `((${CssProp.B.len_or_perc}|left|center|right|top|bottom)\\s*){1,4}`,
    right: `${CssProp.B.length}|auto`,
    shadow: '',
    size: `closest-side|farthest-side|closest-corner|farthest-corner|${CssProp.B.length}|(${CssProp.B.len_or_perc})\\s+(${CssProp.B.len_or_perc})`,
    top: `${CssProp.B.length}|auto`
};
CssProp._C1 = {
    image_list: `image\\(\\s*(${CssProp.B.url})*\\s*(${CssProp.B.url}|${CssProp._C.color})\\s*\\)`,
    linear_color_stop: `(${CssProp._C.color})(\\s*${CssProp._C.color_stop_length})?`,
    shadow: `((${CssProp._C.color})\\s+((${CssProp.B.length})\\s*){2,4}(\s+inset)?)|((inset\\s+)?((${CssProp.B.length})\\s*){2,4}\\s*(${CssProp._C.color})?)`
};
CssProp._C2 = {
    color_stop_list: `((${CssProp._C1.linear_color_stop})(\\s*(${CssProp._C.linear_color_hint}))?\\s*,\\s*)+(${CssProp._C1.linear_color_stop})`,
    shape: `rect\\(\\s*(${CssProp._C.top})\\s*,\\s*(${CssProp._C.right})\\s*,\\s*(${CssProp._C.bottom})\\s*,\\s*(${CssProp._C.left})\\s*\\)`
};
CssProp._C3 = {
    linear_gradient: `linear-gradient\\((((${CssProp.B.angle})|to\\s+(${CssProp.A.side_or_corner}))\\s*,\\s*)?\\s*(${CssProp._C2.color_stop_list})\\s*\\)`,
    radial_gradient: `radial-gradient\\(((((${CssProp.A.ending_shape})|(${CssProp._C.size}))\\s*)*\\s*(at\\s+${CssProp._C.position})?\\s*,\\s*)?\\s*(${CssProp._C2.color_stop_list})\\s*\\)`
};
CssProp._C4 = {
    image: `${CssProp.B.url}|${CssProp._C3.linear_gradient}|${CssProp._C3.radial_gradient}|${CssProp._C1.image_list}`,
    bg_image: `(${CssProp.B.url}|${CssProp._C3.linear_gradient}|${CssProp._C3.radial_gradient}|${CssProp._C1.image_list})|none`
};
CssProp.C = {
    ...CssProp._C,
    ...CssProp._C1,
    ...CssProp._C2,
    ...CssProp._C3,
    ...CssProp._C4
};
/*
 * Property value regular expressions not dependant on other sub expressions
 */
CssProp.AP = {
    border_collapse: `collapse|separate`,
    box: `normal|none|contents`,
    box_sizing: `content-box|padding-box|border-box`,
    caption_side: `top|bottom`,
    clear: `none|left|right|both`,
    direction: `ltr|rtl`,
    empty_cells: `show|hide`,
    float: `left|right|none`,
    font_stretch: `normal|wider|narrower|ultra-condensed|extra-condensed|condensed|semi-condensed|semi-expanded|expanded|extra-expanded|ultra-expanded`,
    font_style: `normal|italic|oblique`,
    font_variant: `normal|small-caps`,
    font_weight: `normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900`,
    list_style_position: `inside|outside`,
    list_style_type: `disc|circle|square|decimal|decimal-leading-zero|lower-roman|upper-roman|lower-greek|lower-latin|upper-latin|armenian|georgian|lower-alpha|upper-alpha|none`,
    overflow: `visible|hidden|scroll|auto`,
    overflow_wrap: `normal|break-word`,
    overflow_x: `visible|hidden|scroll|auto|no-display|no-content`,
    page_break_after: `auto|always|avoid|left|right`,
    page_break_before: `auto|always|avoid|left|right`,
    page_break_inside: `avoid|auto`,
    position: `static|relative|absolute`,
    resize: `none|both|horizontal|vertical`,
    speak: `normal|none|spell-out`,
    speak_header: `once|always`,
    speak_numeral: `digits|continuous`,
    speak_punctuation: `code|none`,
    table_layout: `auto|fixed`,
    text_align: `left|right|center|justify`,
    text_decoration: `none|((underline|overline|line-through|blink)\\s*)+`,
    text_transform: `capitalize|uppercase|lowercase|none`,
    text_wrap: `normal|unrestricted|none|suppress`,
    unicode_bidi: `normal|embed|bidi-override`,
    visibility: `visible|hidden|collapse`,
    white_space: `normal|pre|nowrap|pre-wrap|pre-line`,
    word_break: `normal|keep-all|break-all`
};
/*
 * Compound propertiy value regular expressions (i.e. dependant on other sub expressions)
 */
CssProp._CP = {
    background_attachment: `${CssProp.A.attachment}(,\\s*${CssProp.A.attachment})*`,
    background_color: CssProp.C.color,
    background_origin: `${CssProp.A.box}(,\\s*${CssProp.A.box})*`,
    background_repeat: `${CssProp.A.repeat_style}(,\\s*${CssProp.A.repeat_style})*`,
    border: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    border_radius: `((${CssProp.B.len_or_perc})\\s*){1,4}(\\/\\s*((${CssProp.B.len_or_perc})\\s*){1,4})?`,
    border_spacing: `${CssProp.B.length}\\s*(${CssProp.B.length})?`,
    border_top_color: CssProp.C.color,
    border_top_style: CssProp.A.border_style,
    border_width: `((${CssProp.C.border_width})\\s*){1,4}`,
    color: CssProp.C.color,
    cursor: `(${CssProp.B.url}(\\s*,\\s*)?)*(auto|crosshair|default|pointer|move|e-resize|ne-resize|nw-resize|n-resize|se-resize|sw-resize|s-resize|w-resize|text|wait|help|progress|all-scroll|col-resize|hand|no-drop|not-allowed|row-resize|vertical-text)`,
    display: `inline|block|list-item|run-in|inline-list-item|inline-block|table|inline-table|table-cell|table-caption|flex|inline-flex|grid|inline-grid|${CssProp.A.display_inside}|${CssProp.A.display_outside}|inherit|inline-box|inline-stack`,
    display_outside: CssProp.A.display_outside,
    elevation: `${CssProp.B.angle}|below|level|above|higher|lower`,
    font_family: `(${CssProp.C.family_name}|${CssProp.A.generic_family})(,\\s*(${CssProp.C.family_name}|${CssProp.A.generic_family}))*`,
    height: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    letter_spacing: `normal|${CssProp.B.length}`,
    list_style_image: `${CssProp.C.image}|none`,
    margin_right: CssProp.C.margin_width,
    max_height: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|none|auto`,
    min_height: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`,
    opacity: CssProp.C.alphavalue,
    outline_color: `${CssProp.C.color}|invert`,
    outline_width: CssProp.C.border_width,
    padding: `((${CssProp.C.padding_width})\\s*){1,4}`,
    padding_top: CssProp.C.padding_width,
    pitch_range: CssProp.N.number,
    right: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    stress: CssProp.N.number,
    text_indent: `${CssProp.B.length}|${CssProp.B.percentage}`,
    text_shadow: `none|${CssProp.C.shadow}(,\\s*(${CssProp.C.shadow}))*`,
    volume: `${CssProp.N.number_pos}|${CssProp.B.percentage_pos}|silent|x-soft|soft|medium|loud|x-loud`,
    word_wrap: CssProp.AP.overflow_wrap,
    zoom: `normal|${CssProp.N.number_pos}|${CssProp.B.percentage_pos}`,
    backface_visibility: CssProp.AP.visibility,
    background_clip: `${CssProp.A.box}(,\\s*(${CssProp.A.box}))*`,
    background_position: `${CssProp.C.bg_position}(,\\s*(${CssProp.C.bg_position}))*`,
    border_bottom_color: CssProp.C.color,
    border_bottom_style: CssProp.A.border_style,
    border_color: `((${CssProp.C.color})\\s*){1,4}`,
    border_left_color: CssProp.C.color,
    border_right_color: CssProp.C.color,
    border_style: `((${CssProp.A.border_style})\\s*){1,4}`,
    border_top_left_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_top_width: CssProp.C.border_width,
    box_shadow: `none|${CssProp.C.shadow}(,\\s*(${CssProp.C.shadow}))*`,
    clip: `${CssProp.C.shape}|auto`,
    display_inside: CssProp.A.display_inside,
    font_size: `${CssProp.A.absolute_size}|${CssProp.A.relative_size}|${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    line_height: `normal|${CssProp.N.number_pos}|${CssProp.B.length_pos}|${CssProp.B.percentage_pos}`,
    margin_left: CssProp.C.margin_width,
    max_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|none|auto`,
    outline_style: CssProp.A.border_style,
    padding_bottom: CssProp.C.padding_width,
    padding_right: CssProp.C.padding_width,
    perspective: `none|${CssProp.B.length}`,
    richness: CssProp.N.number,
    text_overflow: `((clip|ellipsis|${CssProp.B.string})\\s*){1,2}`,
    top: `${CssProp.B.length}|${CssProp.B.percentage}|auto`,
    width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`,
    z_index: `auto|${CssProp.B.z_index}`,
    // Simplified background
    background: `(((${CssProp.C.bg_position}\\s*(\\/\\s*${CssProp.C.bg_size})?)|(${CssProp.A.repeat_style})|(${CssProp.A.attachment})|(${CssProp.A.bg_origin})|(${CssProp.C.bg_image})|(${CssProp.C.color}))\\s*)+`,
    background_size: `${CssProp.C.bg_size}(,\\s*${CssProp.C.bg_size})*`,
    border_bottom_left_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_bottom_width: CssProp.C.border_width,
    border_left_style: CssProp.A.border_style,
    border_right_style: CssProp.A.border_style,
    border_top: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    bottom: `${CssProp.B.len_or_perc}|auto`,
    list_style: `((${CssProp.AP.list_style_type}|${CssProp.AP.list_style_position}|${CssProp.C.image}|none})\\s*){1,3}`,
    margin_top: CssProp.C.margin_width,
    outline: `((${CssProp.C.color}|invert|${CssProp.A.border_style}|${CssProp.C.border_width})\\s*){1,3}`,
    overflow_y: CssProp.AP.overflow_x,
    pitch: `${CssProp.B.frequency}|x-low|low|medium|high|x-high`,
    vertical_align: `baseline|sub|super|top|text-top|middle|bottom|text-bottom|${CssProp.B.len_or_perc}`,
    word_spacing: `normal|${CssProp.B.length}`,
    background_image: `${CssProp.C.bg_image}(,\\s*${CssProp.C.bg_image})*`,
    border_bottom_right_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    border_left_width: CssProp.C.border_width,
    border_right_width: CssProp.C.border_width,
    left: `${CssProp.B.len_or_perc}|auto`,
    margin_bottom: CssProp.C.margin_width,
    pause_after: `${CssProp.B.time}|${CssProp.B.percentage}`,
    speech_rate: `${CssProp.N.number}|x-slow|slow|medium|fast|x-fast|faster|slower`,
    transition_duration: `${CssProp.B.time}(,\\s*${CssProp.B.time})*`,
    border_bottom: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    border_right: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    margin: `((${CssProp.C.margin_width})\\s*){1,4}`,
    padding_left: CssProp.C.padding_width,
    border_left: `((${CssProp.C.border_width}|${CssProp.A.border_style}|${CssProp.C.color})\\s*){1,3}`,
    quotes: `(${CssProp.B.string}\\s*${CssProp.B.string})+|none`,
    border_top_right_radius: `(${CssProp.B.length}|${CssProp.B.percentage})(\\s*(${CssProp.B.length}|${CssProp.B.percentage}))?`,
    min_width: `${CssProp.B.length_pos}|${CssProp.B.percentage_pos}|auto`
};
CssProp._CP1 = {
    font: `(((((${CssProp.AP.font_style}|${CssProp.AP.font_variant}|${CssProp.AP.font_weight})\\s*){1,3})?\\s*(${CssProp._CP.font_size})\\s*(\\/\\s*(${CssProp._CP.line_height}))?\\s+(${CssProp._CP.font_family}))|caption|icon|menu|message-box|small-caption|status-bar)`
};
CssProp.CP = { ...CssProp._CP, ...CssProp._CP1 };
// CSS Property value validation regular expressions for use with sanitize-html
CssProp.BORDER_COLLAPSE = CssProp.reg(CssProp.AP.border_collapse);
CssProp.BOX = CssProp.reg(CssProp.AP.box);
CssProp.BOX_SIZING = CssProp.reg(CssProp.AP.box_sizing);
CssProp.CAPTION_SIDE = CssProp.reg(CssProp.AP.caption_side);
CssProp.CLEAR = CssProp.reg(CssProp.AP.clear);
CssProp.DIRECTION = CssProp.reg(CssProp.AP.direction);
CssProp.EMPTY_CELLS = CssProp.reg(CssProp.AP.empty_cells);
CssProp.FLOAT = CssProp.reg(CssProp.AP.float);
CssProp.FONT_STRETCH = CssProp.reg(CssProp.AP.font_stretch);
CssProp.FONT_STYLE = CssProp.reg(CssProp.AP.font_style);
CssProp.FONT_VARIANT = CssProp.reg(CssProp.AP.font_variant);
CssProp.FONT_WEIGHT = CssProp.reg(CssProp.AP.font_weight);
CssProp.LIST_STYLE_POSITION = CssProp.reg(CssProp.AP.list_style_position);
CssProp.LIST_STYLE_TYPE = CssProp.reg(CssProp.AP.list_style_type);
CssProp.OVERFLOW = CssProp.reg(CssProp.AP.overflow);
CssProp.OVERFLOW_WRAP = CssProp.reg(CssProp.AP.overflow_wrap);
CssProp.OVERFLOW_X = CssProp.reg(CssProp.AP.overflow_x);
CssProp.PAGE_BREAK_AFTER = CssProp.reg(CssProp.AP.page_break_after);
CssProp.PAGE_BREAK_BEFORE = CssProp.reg(CssProp.AP.page_break_before);
CssProp.PAGE_BREAK_INSIDE = CssProp.reg(CssProp.AP.page_break_inside);
CssProp.POSITION = CssProp.reg(CssProp.AP.position);
CssProp.RESIZE = CssProp.reg(CssProp.AP.resize);
CssProp.SPEAK = CssProp.reg(CssProp.AP.speak);
CssProp.SPEAK_HEADER = CssProp.reg(CssProp.AP.speak_header);
CssProp.SPEAK_NUMERAL = CssProp.reg(CssProp.AP.speak_numeral);
CssProp.SPEAK_PUNCTUATION = CssProp.reg(CssProp.AP.speak_punctuation);
CssProp.TABLE_LAYOUT = CssProp.reg(CssProp.AP.table_layout);
CssProp.TEXT_ALIGN = CssProp.reg(CssProp.AP.text_align);
CssProp.TEXT_DECORATION = CssProp.reg(CssProp.AP.text_decoration);
CssProp.TEXT_TRANSFORM = CssProp.reg(CssProp.AP.text_transform);
CssProp.TEXT_WRAP = CssProp.reg(CssProp.AP.text_wrap);
CssProp.UNICODE_BIDI = CssProp.reg(CssProp.AP.unicode_bidi);
CssProp.VISIBILITY = CssProp.reg(CssProp.AP.visibility);
CssProp.WHITE_SPACE = CssProp.reg(CssProp.AP.white_space);
CssProp.WORD_BREAK = CssProp.reg(CssProp.AP.word_break);
CssProp.BACKGROUND_ATTACHMENT = CssProp.reg(CssProp.CP.background_attachment);
CssProp.BACKGROUND_COLOR = CssProp.reg(CssProp.CP.background_color);
CssProp.BACKGROUND_ORIGIN = CssProp.reg(CssProp.CP.background_origin);
CssProp.BACKGROUND_REPEAT = CssProp.reg(CssProp.CP.background_repeat);
CssProp.BORDER = CssProp.reg(CssProp.CP.border);
CssProp.BORDER_RADIUS = CssProp.reg(CssProp.CP.border_radius);
CssProp.BORDER_SPACING = CssProp.reg(CssProp.CP.border_spacing);
CssProp.BORDER_TOP_COLOR = CssProp.reg(CssProp.CP.border_top_color);
CssProp.BORDER_TOP_STYLE = CssProp.reg(CssProp.CP.border_top_style);
CssProp.BORDER_WIDTH = CssProp.reg(CssProp.CP.border_width);
CssProp.COLOR = CssProp.reg(CssProp.CP.color);
CssProp.CURSOR = CssProp.reg(CssProp.CP.cursor);
CssProp.DISPLAY = CssProp.reg(CssProp.CP.display);
CssProp.DISPLAY_OUTSIDE = CssProp.reg(CssProp.CP.display_outside);
CssProp.ELEVATION = CssProp.reg(CssProp.CP.elevation);
CssProp.FONT_FAMILY = CssProp.reg(CssProp.CP.font_family);
CssProp.HEIGHT = CssProp.reg(CssProp.CP.height);
CssProp.LETTER_SPACING = CssProp.reg(CssProp.CP.letter_spacing);
CssProp.LIST_STYLE_IMAGE = CssProp.reg(CssProp.CP.list_style_image);
CssProp.MARGIN_RIGHT = CssProp.reg(CssProp.CP.margin_right);
CssProp.MAX_HEIGHT = CssProp.reg(CssProp.CP.max_height);
CssProp.MIN_HEIGHT = CssProp.reg(CssProp.CP.min_height);
CssProp.OPACITY = CssProp.reg(CssProp.CP.opacity);
CssProp.OUTLINE_COLOR = CssProp.reg(CssProp.CP.outline_color);
CssProp.OUTLINE_WIDTH = CssProp.reg(CssProp.CP.outline_width);
CssProp.PADDING = CssProp.reg(CssProp.CP.padding);
CssProp.PADDING_TOP = CssProp.reg(CssProp.CP.padding_top);
CssProp.PITCH_RANGE = CssProp.reg(CssProp.CP.pitch_range);
CssProp.RIGHT = CssProp.reg(CssProp.CP.right);
CssProp.STRESS = CssProp.reg(CssProp.CP.stress);
CssProp.TEXT_INDENT = CssProp.reg(CssProp.CP.text_indent);
CssProp.TEXT_SHADOW = CssProp.reg(CssProp.CP.text_shadow);
CssProp.VOLUME = CssProp.reg(CssProp.CP.volume);
CssProp.WORD_WRAP = CssProp.reg(CssProp.CP.word_wrap);
CssProp.ZOOM = CssProp.reg(CssProp.CP.zoom);
CssProp.BACKFACE_VISIBILITY = CssProp.reg(CssProp.CP.backface_visibility);
CssProp.BACKGROUND_CLIP = CssProp.reg(CssProp.CP.background_clip);
CssProp.BACKGROUND_POSITION = CssProp.reg(CssProp.CP.background_position);
CssProp.BORDER_BOTTOM_COLOR = CssProp.reg(CssProp.CP.border_bottom_color);
CssProp.BORDER_BOTTOM_STYLE = CssProp.reg(CssProp.CP.border_bottom_style);
CssProp.BORDER_COLOR = CssProp.reg(CssProp.CP.border_color);
CssProp.BORDER_LEFT_COLOR = CssProp.reg(CssProp.CP.border_left_color);
CssProp.BORDER_RIGHT_COLOR = CssProp.reg(CssProp.CP.border_right_color);
CssProp.BORDER_STYLE = CssProp.reg(CssProp.CP.border_style);
CssProp.BORDER_TOP_LEFT_RADIUS = CssProp.reg(CssProp.CP.border_top_left_radius);
CssProp.BORDER_TOP_WIDTH = CssProp.reg(CssProp.CP.border_top_width);
CssProp.BOX_SHADOW = CssProp.reg(CssProp.CP.box_shadow);
CssProp.CLIP = CssProp.reg(CssProp.CP.clip);
CssProp.DISPLAY_INSIDE = CssProp.reg(CssProp.CP.display_inside);
CssProp.FONT_SIZE = CssProp.reg(CssProp.CP.font_size);
CssProp.LINE_HEIGHT = CssProp.reg(CssProp.CP.line_height);
CssProp.MARGIN_LEFT = CssProp.reg(CssProp.CP.margin_left);
CssProp.MAX_WIDTH = CssProp.reg(CssProp.CP.max_width);
CssProp.OUTLINE_STYLE = CssProp.reg(CssProp.CP.outline_style);
CssProp.PADDING_BOTTOM = CssProp.reg(CssProp.CP.padding_bottom);
CssProp.PADDING_RIGHT = CssProp.reg(CssProp.CP.padding_right);
CssProp.PERSPECTIVE = CssProp.reg(CssProp.CP.perspective);
CssProp.RICHNESS = CssProp.reg(CssProp.CP.richness);
CssProp.TEXT_OVERFLOW = CssProp.reg(CssProp.CP.text_overflow);
CssProp.TOP = CssProp.reg(CssProp.CP.top);
CssProp.WIDTH = CssProp.reg(CssProp.CP.width);
CssProp.Z_INDEX = CssProp.reg(CssProp.CP.z_index);
CssProp.BACKGROUND = CssProp.reg(CssProp.CP.background);
CssProp.BACKGROUND_SIZE = CssProp.reg(CssProp.CP.background_size);
CssProp.BORDER_BOTTOM_LEFT_RADIUS = CssProp.reg(CssProp.CP.border_bottom_left_radius);
CssProp.BORDER_BOTTOM_WIDTH = CssProp.reg(CssProp.CP.border_bottom_width);
CssProp.BORDER_LEFT_STYLE = CssProp.reg(CssProp.CP.border_left_style);
CssProp.BORDER_RIGHT_STYLE = CssProp.reg(CssProp.CP.border_right_style);
CssProp.BORDER_TOP = CssProp.reg(CssProp.CP.border_top);
CssProp.BOTTOM = CssProp.reg(CssProp.CP.bottom);
CssProp.LIST_STYLE = CssProp.reg(CssProp.CP.list_style);
CssProp.MARGIN_TOP = CssProp.reg(CssProp.CP.margin_top);
CssProp.OUTLINE = CssProp.reg(CssProp.CP.outline);
CssProp.OVERFLOW_Y = CssProp.reg(CssProp.CP.overflow_y);
CssProp.PITCH = CssProp.reg(CssProp.CP.pitch);
CssProp.VERTICAL_ALIGN = CssProp.reg(CssProp.CP.vertical_align);
CssProp.WORD_SPACING = CssProp.reg(CssProp.CP.word_spacing);
CssProp.BACKGROUND_IMAGE = CssProp.reg(CssProp.CP.background_image);
CssProp.BORDER_BOTTOM_RIGHT_RADIUS = CssProp.reg(CssProp.CP.border_bottom_right_radius);
CssProp.BORDER_LEFT_WIDTH = CssProp.reg(CssProp.CP.border_left_width);
CssProp.BORDER_RIGHT_WIDTH = CssProp.reg(CssProp.CP.border_right_width);
CssProp.LEFT = CssProp.reg(CssProp.CP.left);
CssProp.MARGIN_BOTTOM = CssProp.reg(CssProp.CP.margin_bottom);
CssProp.PAUSE_AFTER = CssProp.reg(CssProp.CP.pause_after);
CssProp.SPEECH_RATE = CssProp.reg(CssProp.CP.speech_rate);
CssProp.TRANSITION_DURATION = CssProp.reg(CssProp.CP.transition_duration);
CssProp.BORDER_BOTTOM = CssProp.reg(CssProp.CP.border_bottom);
CssProp.BORDER_RIGHT = CssProp.reg(CssProp.CP.border_right);
CssProp.MARGIN = CssProp.reg(CssProp.CP.margin);
CssProp.PADDING_LEFT = CssProp.reg(CssProp.CP.padding_left);
CssProp.BORDER_LEFT = CssProp.reg(CssProp.CP.border_left);
CssProp.FONT = CssProp.reg(CssProp.CP.font);
CssProp.QUOTES = CssProp.reg(CssProp.CP.quotes);
CssProp.BORDER_TOP_RIGHT_RADIUS = CssProp.reg(CssProp.CP.border_top_right_radius);
CssProp.MIN_WIDTH = CssProp.reg(CssProp.CP.min_width);
/**
 * A class to sanitize HTML strings.
 */
class Sanitizer {
    constructor() {
        this._autolink = true;
        this._options = {
            // HTML tags that are allowed to be used. Tags were extracted from Google Caja
            allowedTags: [
                'a',
                'abbr',
                'acronym',
                'address',
                'area',
                'article',
                'aside',
                'audio',
                'b',
                'bdi',
                'bdo',
                'big',
                'blockquote',
                'br',
                'button',
                'canvas',
                'caption',
                'center',
                'cite',
                'code',
                'col',
                'colgroup',
                'colspan',
                'command',
                'data',
                'datalist',
                'dd',
                'del',
                'details',
                'dfn',
                'dir',
                'div',
                'dl',
                'dt',
                'em',
                'fieldset',
                'figcaption',
                'figure',
                'font',
                'footer',
                'form',
                'h1',
                'h2',
                'h3',
                'h4',
                'h5',
                'h6',
                'header',
                'hgroup',
                'hr',
                'i',
                // 'iframe' is allowed by Google Caja, but disallowed by default by sanitize-html
                // , 'iframe'
                'img',
                'input',
                'ins',
                'kbd',
                'label',
                'legend',
                'li',
                'map',
                'mark',
                'menu',
                'meter',
                'nav',
                'nobr',
                'ol',
                'optgroup',
                'option',
                'output',
                'p',
                'pre',
                'progress',
                'q',
                'rowspan',
                's',
                'samp',
                'section',
                'select',
                'small',
                'source',
                'span',
                'strike',
                'strong',
                'sub',
                'summary',
                'sup',
                'table',
                'tbody',
                'td',
                'textarea',
                'tfoot',
                'th',
                'thead',
                'time',
                'tr',
                'track',
                'tt',
                'u',
                'ul',
                'var',
                'video',
                'wbr'
            ],
            // Attributes that HTML tags are allowed to have, extracted from Google Caja.
            // See https://github.com/jupyterlab/jupyterlab/issues/1812#issuecomment-285848435
            allowedAttributes: {
                '*': [
                    'class',
                    'dir',
                    'draggable',
                    'hidden',
                    'id',
                    'inert',
                    'itemprop',
                    'itemref',
                    'itemscope',
                    'lang',
                    'spellcheck',
                    'style',
                    'title',
                    'translate'
                ],
                // 'rel' and 'target' were *not* allowed by Google Caja
                a: [
                    'accesskey',
                    'coords',
                    'href',
                    'hreflang',
                    'name',
                    'rel',
                    'shape',
                    'tabindex',
                    'target',
                    'type'
                ],
                area: [
                    'accesskey',
                    'alt',
                    'coords',
                    'href',
                    'nohref',
                    'shape',
                    'tabindex'
                ],
                // 'autoplay' was *not* allowed by Google Caja
                audio: [
                    'autoplay',
                    'controls',
                    'loop',
                    'mediagroup',
                    'muted',
                    'preload',
                    'src'
                ],
                bdo: ['dir'],
                blockquote: ['cite'],
                br: ['clear'],
                button: [
                    'accesskey',
                    'data-commandlinker-args',
                    'data-commandlinker-command',
                    'disabled',
                    'name',
                    'tabindex',
                    'type',
                    'value'
                ],
                canvas: ['height', 'width'],
                caption: ['align'],
                col: ['align', 'char', 'charoff', 'span', 'valign', 'width'],
                colgroup: ['align', 'char', 'charoff', 'span', 'valign', 'width'],
                command: [
                    'checked',
                    'command',
                    'disabled',
                    'icon',
                    'label',
                    'radiogroup',
                    'type'
                ],
                data: ['value'],
                del: ['cite', 'datetime'],
                details: ['open'],
                dir: ['compact'],
                div: ['align'],
                dl: ['compact'],
                fieldset: ['disabled'],
                font: ['color', 'face', 'size'],
                form: [
                    'accept',
                    'autocomplete',
                    'enctype',
                    'method',
                    'name',
                    'novalidate'
                ],
                h1: ['align'],
                h2: ['align'],
                h3: ['align'],
                h4: ['align'],
                h5: ['align'],
                h6: ['align'],
                hr: ['align', 'noshade', 'size', 'width'],
                iframe: [
                    'align',
                    'frameborder',
                    'height',
                    'marginheight',
                    'marginwidth',
                    'width'
                ],
                img: [
                    'align',
                    'alt',
                    'border',
                    'height',
                    'hspace',
                    'ismap',
                    'name',
                    'src',
                    'usemap',
                    'vspace',
                    'width'
                ],
                input: [
                    'accept',
                    'accesskey',
                    'align',
                    'alt',
                    'autocomplete',
                    'checked',
                    'disabled',
                    'inputmode',
                    'ismap',
                    'list',
                    'max',
                    'maxlength',
                    'min',
                    'multiple',
                    'name',
                    'placeholder',
                    'readonly',
                    'required',
                    'size',
                    'src',
                    'step',
                    'tabindex',
                    'type',
                    'usemap',
                    'value'
                ],
                ins: ['cite', 'datetime'],
                label: ['accesskey', 'for'],
                legend: ['accesskey', 'align'],
                li: ['type', 'value'],
                map: ['name'],
                menu: ['compact', 'label', 'type'],
                meter: ['high', 'low', 'max', 'min', 'value'],
                ol: ['compact', 'reversed', 'start', 'type'],
                optgroup: ['disabled', 'label'],
                option: ['disabled', 'label', 'selected', 'value'],
                output: ['for', 'name'],
                p: ['align'],
                pre: ['width'],
                progress: ['max', 'min', 'value'],
                q: ['cite'],
                select: [
                    'autocomplete',
                    'disabled',
                    'multiple',
                    'name',
                    'required',
                    'size',
                    'tabindex'
                ],
                source: ['type'],
                table: [
                    'align',
                    'bgcolor',
                    'border',
                    'cellpadding',
                    'cellspacing',
                    'frame',
                    'rules',
                    'summary',
                    'width'
                ],
                tbody: ['align', 'char', 'charoff', 'valign'],
                td: [
                    'abbr',
                    'align',
                    'axis',
                    'bgcolor',
                    'char',
                    'charoff',
                    'colspan',
                    'headers',
                    'height',
                    'nowrap',
                    'rowspan',
                    'scope',
                    'valign',
                    'width'
                ],
                textarea: [
                    'accesskey',
                    'autocomplete',
                    'cols',
                    'disabled',
                    'inputmode',
                    'name',
                    'placeholder',
                    'readonly',
                    'required',
                    'rows',
                    'tabindex',
                    'wrap'
                ],
                tfoot: ['align', 'char', 'charoff', 'valign'],
                th: [
                    'abbr',
                    'align',
                    'axis',
                    'bgcolor',
                    'char',
                    'charoff',
                    'colspan',
                    'headers',
                    'height',
                    'nowrap',
                    'rowspan',
                    'scope',
                    'valign',
                    'width'
                ],
                thead: ['align', 'char', 'charoff', 'valign'],
                tr: ['align', 'bgcolor', 'char', 'charoff', 'valign'],
                track: ['default', 'kind', 'label', 'srclang'],
                ul: ['compact', 'type'],
                video: [
                    'autoplay',
                    'controls',
                    'height',
                    'loop',
                    'mediagroup',
                    'muted',
                    'poster',
                    'preload',
                    'src',
                    'width'
                ]
            },
            // Inline CSS styles that HTML tags may have (and their allowed values)
            allowedStyles: {
                // To simplify the data, all styles are allowed on all tags that allow the style attribute
                '*': {
                    'backface-visibility': [CssProp.BACKFACE_VISIBILITY],
                    background: [CssProp.BACKGROUND],
                    'background-attachment': [CssProp.BACKGROUND_ATTACHMENT],
                    'background-clip': [CssProp.BACKGROUND_CLIP],
                    'background-color': [CssProp.BACKGROUND_COLOR],
                    'background-image': [CssProp.BACKGROUND_IMAGE],
                    'background-origin': [CssProp.BACKGROUND_ORIGIN],
                    'background-position': [CssProp.BACKGROUND_POSITION],
                    'background-repeat': [CssProp.BACKGROUND_REPEAT],
                    'background-size': [CssProp.BACKGROUND_SIZE],
                    border: [CssProp.BORDER],
                    'border-bottom': [CssProp.BORDER_BOTTOM],
                    'border-bottom-color': [CssProp.BORDER_BOTTOM_COLOR],
                    'border-bottom-left-radius': [CssProp.BORDER_BOTTOM_LEFT_RADIUS],
                    'border-bottom-right-radius': [CssProp.BORDER_BOTTOM_RIGHT_RADIUS],
                    'border-bottom-style': [CssProp.BORDER_BOTTOM_STYLE],
                    'border-bottom-width': [CssProp.BORDER_BOTTOM_WIDTH],
                    'border-collapse': [CssProp.BORDER_COLLAPSE],
                    'border-color': [CssProp.BORDER_COLOR],
                    'border-left': [CssProp.BORDER_LEFT],
                    'border-left-color': [CssProp.BORDER_LEFT_COLOR],
                    'border-left-style': [CssProp.BORDER_LEFT_STYLE],
                    'border-left-width': [CssProp.BORDER_LEFT_WIDTH],
                    'border-radius': [CssProp.BORDER_RADIUS],
                    'border-right': [CssProp.BORDER_RIGHT],
                    'border-right-color': [CssProp.BORDER_RIGHT_COLOR],
                    'border-right-style': [CssProp.BORDER_RIGHT_STYLE],
                    'border-right-width': [CssProp.BORDER_RIGHT_WIDTH],
                    'border-spacing': [CssProp.BORDER_SPACING],
                    'border-style': [CssProp.BORDER_STYLE],
                    'border-top': [CssProp.BORDER_TOP],
                    'border-top-color': [CssProp.BORDER_TOP_COLOR],
                    'border-top-left-radius': [CssProp.BORDER_TOP_LEFT_RADIUS],
                    'border-top-right-radius': [CssProp.BORDER_TOP_RIGHT_RADIUS],
                    'border-top-style': [CssProp.BORDER_TOP_STYLE],
                    'border-top-width': [CssProp.BORDER_TOP_WIDTH],
                    'border-width': [CssProp.BORDER_WIDTH],
                    bottom: [CssProp.BOTTOM],
                    box: [CssProp.BOX],
                    'box-shadow': [CssProp.BOX_SHADOW],
                    'box-sizing': [CssProp.BOX_SIZING],
                    'caption-side': [CssProp.CAPTION_SIDE],
                    clear: [CssProp.CLEAR],
                    clip: [CssProp.CLIP],
                    color: [CssProp.COLOR],
                    cursor: [CssProp.CURSOR],
                    direction: [CssProp.DIRECTION],
                    display: [CssProp.DISPLAY],
                    'display-inside': [CssProp.DISPLAY_INSIDE],
                    'display-outside': [CssProp.DISPLAY_OUTSIDE],
                    elevation: [CssProp.ELEVATION],
                    'empty-cells': [CssProp.EMPTY_CELLS],
                    float: [CssProp.FLOAT],
                    font: [CssProp.FONT],
                    'font-family': [CssProp.FONT_FAMILY],
                    'font-size': [CssProp.FONT_SIZE],
                    'font-stretch': [CssProp.FONT_STRETCH],
                    'font-style': [CssProp.FONT_STYLE],
                    'font-variant': [CssProp.FONT_VARIANT],
                    'font-weight': [CssProp.FONT_WEIGHT],
                    height: [CssProp.HEIGHT],
                    left: [CssProp.LEFT],
                    'letter-spacing': [CssProp.LETTER_SPACING],
                    'line-height': [CssProp.LINE_HEIGHT],
                    'list-style': [CssProp.LIST_STYLE],
                    'list-style-image': [CssProp.LIST_STYLE_IMAGE],
                    'list-style-position': [CssProp.LIST_STYLE_POSITION],
                    'list-style-type': [CssProp.LIST_STYLE_TYPE],
                    margin: [CssProp.MARGIN],
                    'margin-bottom': [CssProp.MARGIN_BOTTOM],
                    'margin-left': [CssProp.MARGIN_LEFT],
                    'margin-right': [CssProp.MARGIN_RIGHT],
                    'margin-top': [CssProp.MARGIN_TOP],
                    'max-height': [CssProp.MAX_HEIGHT],
                    'max-width': [CssProp.MAX_WIDTH],
                    'min-height': [CssProp.MIN_HEIGHT],
                    'min-width': [CssProp.MIN_WIDTH],
                    opacity: [CssProp.OPACITY],
                    outline: [CssProp.OUTLINE],
                    'outline-color': [CssProp.OUTLINE_COLOR],
                    'outline-style': [CssProp.OUTLINE_STYLE],
                    'outline-width': [CssProp.OUTLINE_WIDTH],
                    overflow: [CssProp.OVERFLOW],
                    'overflow-wrap': [CssProp.OVERFLOW_WRAP],
                    'overflow-x': [CssProp.OVERFLOW_X],
                    'overflow-y': [CssProp.OVERFLOW_Y],
                    padding: [CssProp.PADDING],
                    'padding-bottom': [CssProp.PADDING_BOTTOM],
                    'padding-left': [CssProp.PADDING_LEFT],
                    'padding-right': [CssProp.PADDING_RIGHT],
                    'padding-top': [CssProp.PADDING_TOP],
                    'page-break-after': [CssProp.PAGE_BREAK_AFTER],
                    'page-break-before': [CssProp.PAGE_BREAK_BEFORE],
                    'page-break-inside': [CssProp.PAGE_BREAK_INSIDE],
                    'pause-after': [CssProp.PAUSE_AFTER],
                    perspective: [CssProp.PERSPECTIVE],
                    pitch: [CssProp.PITCH],
                    'pitch-range': [CssProp.PITCH_RANGE],
                    position: [CssProp.POSITION],
                    quotes: [CssProp.QUOTES],
                    resize: [CssProp.RESIZE],
                    richness: [CssProp.RICHNESS],
                    right: [CssProp.RIGHT],
                    speak: [CssProp.SPEAK],
                    'speak-header': [CssProp.SPEAK_HEADER],
                    'speak-numeral': [CssProp.SPEAK_NUMERAL],
                    'speak-punctuation': [CssProp.SPEAK_PUNCTUATION],
                    'speech-rate': [CssProp.SPEECH_RATE],
                    stress: [CssProp.STRESS],
                    'table-layout': [CssProp.TABLE_LAYOUT],
                    'text-align': [CssProp.TEXT_ALIGN],
                    'text-decoration': [CssProp.TEXT_DECORATION],
                    'text-indent': [CssProp.TEXT_INDENT],
                    'text-overflow': [CssProp.TEXT_OVERFLOW],
                    'text-shadow': [CssProp.TEXT_SHADOW],
                    'text-transform': [CssProp.TEXT_TRANSFORM],
                    'text-wrap': [CssProp.TEXT_WRAP],
                    top: [CssProp.TOP],
                    'unicode-bidi': [CssProp.UNICODE_BIDI],
                    'vertical-align': [CssProp.VERTICAL_ALIGN],
                    visibility: [CssProp.VISIBILITY],
                    volume: [CssProp.VOLUME],
                    'white-space': [CssProp.WHITE_SPACE],
                    width: [CssProp.WIDTH],
                    'word-break': [CssProp.WORD_BREAK],
                    'word-spacing': [CssProp.WORD_SPACING],
                    'word-wrap': [CssProp.WORD_WRAP],
                    'z-index': [CssProp.Z_INDEX],
                    zoom: [CssProp.ZOOM]
                }
            },
            transformTags: {
                // Set the "rel" attribute for <a> tags to "nofollow".
                a: sanitize_html__WEBPACK_IMPORTED_MODULE_0___default().simpleTransform('a', { rel: 'nofollow' }),
                // Set the "disabled" attribute for <input> tags.
                input: sanitize_html__WEBPACK_IMPORTED_MODULE_0___default().simpleTransform('input', { disabled: 'disabled' })
            },
            allowedSchemes: [...(sanitize_html__WEBPACK_IMPORTED_MODULE_0___default().defaults).allowedSchemes],
            allowedSchemesByTag: {
                // Allow 'attachment:' img src (used for markdown cell attachments).
                img: sanitize_html__WEBPACK_IMPORTED_MODULE_0___default().defaults.allowedSchemes.concat(['attachment'])
            },
            // Override of the default option, so we can skip 'src' attribute validation.
            // 'src' Attributes are validated to be URIs, which does not allow for embedded (image) data.
            // Since embedded data is no longer deemed to be a threat, validation can be skipped.
            // See https://github.com/jupyterlab/jupyterlab/issues/5183
            allowedSchemesAppliedToAttributes: ['href', 'cite']
        };
    }
    /**
     * Sanitize an HTML string.
     *
     * @param dirty - The dirty text.
     *
     * @param options - The optional sanitization options.
     *
     * @returns The sanitized string.
     */
    sanitize(dirty, options) {
        return sanitize_html__WEBPACK_IMPORTED_MODULE_0___default()(dirty, { ...this._options, ...(options || {}) });
    }
    /**
     * @returns Whether to replace URLs by HTML anchors.
     */
    getAutolink() {
        return this._autolink;
    }
    /**
     * Set the allowed schemes
     *
     * @param scheme Allowed schemes
     */
    setAllowedSchemes(scheme) {
        // Force copy of `scheme`
        this._options.allowedSchemes = [...scheme];
    }
    /**
     * Set the URL replacement boolean.
     *
     * @param autolink URL replacement boolean.
     */
    setAutolink(autolink) {
        this._autolink = autolink;
    }
}
//# sourceMappingURL=sanitizer.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/semanticCommand.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/semanticCommand.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SemanticCommand: () => (/* binding */ SemanticCommand)
/* harmony export */ });
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
/**
 * Semantic group of commands
 */
class SemanticCommand {
    constructor() {
        this._commands = new Array();
    }
    /**
     * Add a command to the semantic group
     *
     * @param command Command to add
     */
    add(command) {
        if (this._commands.map(c => c.id).includes(command.id)) {
            throw Error(`Command ${command.id} is already defined.`);
        }
        this._commands.push({
            isEnabled: () => true,
            rank: SemanticCommand.DEFAULT_RANK,
            ...command
        });
    }
    /**
     * Get the command id of the enabled command from this group
     * for the given widget.
     *
     * @param widget Widget
     * @returns Command id
     */
    getActiveCommandId(widget) {
        var _a;
        const commands = this._commands
            .filter(c => c.isEnabled(widget))
            .sort((a, b) => {
            const rankDelta = a.rank - b.rank;
            return rankDelta || (a.id < b.id ? -1 : 1);
        });
        const command = (_a = commands[0]) !== null && _a !== void 0 ? _a : { id: null };
        return command.id;
    }
}
/**
 * Default rank for semantic command
 */
SemanticCommand.DEFAULT_RANK = 500;

//# sourceMappingURL=semanticCommand.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/sessioncontext.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/sessioncontext.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SessionContext: () => (/* binding */ SessionContext),
/* harmony export */   SessionContextDialogs: () => (/* binding */ SessionContextDialogs)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./dialog */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The default implementation for a session context object.
 */
class SessionContext {
    /**
     * Construct a new session context.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        this._path = '';
        this._name = '';
        this._type = '';
        this._prevKernelName = '';
        this._isDisposed = false;
        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._session = null;
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
        this._initializing = false;
        this._initStarted = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
        this._initPromise = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.PromiseDelegate();
        this._isReady = false;
        this._isTerminating = false;
        this._isRestarting = false;
        this._kernelChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._preferenceChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._sessionChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._statusChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._connectionStatusChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._pendingInput = false;
        this._iopubMessage = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._unhandledMessage = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._propertyChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._dialog = null;
        this._busyDisposable = null;
        this._pendingKernelName = '';
        this._pendingSessionRequest = '';
        this.sessionManager = options.sessionManager;
        this.specsManager = options.specsManager;
        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this._path = (_a = options.path) !== null && _a !== void 0 ? _a : _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.UUID.uuid4();
        this._type = (_b = options.type) !== null && _b !== void 0 ? _b : '';
        this._name = (_c = options.name) !== null && _c !== void 0 ? _c : '';
        this._setBusy = options.setBusy;
        this._kernelPreference = (_d = options.kernelPreference) !== null && _d !== void 0 ? _d : {};
    }
    /**
     * The current session connection.
     */
    get session() {
        var _a;
        return (_a = this._session) !== null && _a !== void 0 ? _a : null;
    }
    /**
     * The session path.
     *
     * #### Notes
     * Typically `.session.path` should be used. This attribute is useful if
     * there is no current session.
     */
    get path() {
        return this._path;
    }
    /**
     * The session type.
     *
     * #### Notes
     * Typically `.session.type` should be used. This attribute is useful if
     * there is no current session.
     */
    get type() {
        return this._type;
    }
    /**
     * The session name.
     *
     * #### Notes
     * Typically `.session.name` should be used. This attribute is useful if
     * there is no current session.
     */
    get name() {
        return this._name;
    }
    /**
     * A signal emitted when the kernel connection changes, proxied from the session connection.
     */
    get kernelChanged() {
        return this._kernelChanged;
    }
    /**
     * A signal emitted when the session connection changes.
     */
    get sessionChanged() {
        return this._sessionChanged;
    }
    /**
     * A signal emitted when the kernel status changes, proxied from the kernel.
     */
    get statusChanged() {
        return this._statusChanged;
    }
    /**
     * A flag indicating if the session has ending input, proxied from the kernel.
     */
    get pendingInput() {
        return this._pendingInput;
    }
    /**
     * A signal emitted when the kernel status changes, proxied from the kernel.
     */
    get connectionStatusChanged() {
        return this._connectionStatusChanged;
    }
    /**
     * A signal emitted for iopub kernel messages, proxied from the kernel.
     */
    get iopubMessage() {
        return this._iopubMessage;
    }
    /**
     * A signal emitted for an unhandled kernel message, proxied from the kernel.
     */
    get unhandledMessage() {
        return this._unhandledMessage;
    }
    /**
     * A signal emitted when a session property changes, proxied from the current session.
     */
    get propertyChanged() {
        return this._propertyChanged;
    }
    /**
     * The kernel preference of this client session.
     *
     * This is used when selecting a new kernel, and should reflect the sort of
     * kernel the activity prefers.
     */
    get kernelPreference() {
        return this._kernelPreference;
    }
    set kernelPreference(value) {
        if (!_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.JSONExt.deepEqual(value, this._kernelPreference)) {
            const oldValue = this._kernelPreference;
            this._kernelPreference = value;
            this._preferenceChanged.emit({
                name: 'kernelPreference',
                oldValue,
                newValue: _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.JSONExt.deepCopy(value)
            });
        }
    }
    /**
     * Signal emitted if the kernel preference changes.
     */
    get kernelPreferenceChanged() {
        return this._preferenceChanged;
    }
    /**
     * Whether the context is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that is fulfilled when the context is ready.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Whether the context is terminating.
     */
    get isTerminating() {
        return this._isTerminating;
    }
    /**
     * Whether the context is restarting.
     */
    get isRestarting() {
        return this._isRestarting;
    }
    /**
     * Whether the kernel is "No Kernel" or not.
     *
     * #### Notes
     * As the displayed name is translated, this can be used directly.
     */
    get hasNoKernel() {
        return this.kernelDisplayName === this.noKernelName;
    }
    /**
     * The display name of the current kernel, or a sensible alternative.
     *
     * #### Notes
     * This is a convenience function to have a consistent sensible name for the
     * kernel.
     */
    get kernelDisplayName() {
        var _a, _b, _c, _d, _e, _f, _g;
        const kernel = (_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (this._pendingKernelName === this.noKernelName) {
            return this.noKernelName;
        }
        if (this._pendingKernelName) {
            return ((_d = (_c = (_b = this.specsManager.specs) === null || _b === void 0 ? void 0 : _b.kernelspecs[this._pendingKernelName]) === null || _c === void 0 ? void 0 : _c.display_name) !== null && _d !== void 0 ? _d : this._pendingKernelName);
        }
        if (!kernel) {
            return this.noKernelName;
        }
        return ((_g = (_f = (_e = this.specsManager.specs) === null || _e === void 0 ? void 0 : _e.kernelspecs[kernel.name]) === null || _f === void 0 ? void 0 : _f.display_name) !== null && _g !== void 0 ? _g : kernel.name);
    }
    /**
     * A sensible status to display
     *
     * #### Notes
     * This combines the status and connection status into a single status for
     * the user.
     */
    get kernelDisplayStatus() {
        var _a, _b;
        const kernel = (_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (this._isTerminating) {
            return 'terminating';
        }
        if (this._isRestarting) {
            return 'restarting';
        }
        if (this._pendingKernelName === this.noKernelName) {
            return 'unknown';
        }
        if (!kernel && this._pendingKernelName) {
            return 'initializing';
        }
        if (!kernel &&
            !this.isReady &&
            this.kernelPreference.canStart !== false &&
            this.kernelPreference.shouldStart !== false) {
            return 'initializing';
        }
        return ((_b = ((kernel === null || kernel === void 0 ? void 0 : kernel.connectionStatus) === 'connected'
            ? kernel === null || kernel === void 0 ? void 0 : kernel.status
            : kernel === null || kernel === void 0 ? void 0 : kernel.connectionStatus)) !== null && _b !== void 0 ? _b : 'unknown');
    }
    /**
     * The name of the previously started kernel.
     */
    get prevKernelName() {
        return this._prevKernelName;
    }
    /**
     * Test whether the context is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * A signal emitted when the poll is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Get the constant displayed name for "No Kernel"
     */
    get noKernelName() {
        return this._trans.__('No Kernel');
    }
    /**
     * Dispose of the resources held by the context.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        if (this._session) {
            if (this.kernelPreference.shutdownOnDispose) {
                // Fire and forget the session shutdown request
                this.sessionManager.shutdown(this._session.id).catch(reason => {
                    console.error(`Kernel not shut down ${reason}`);
                });
            }
            // Dispose the session connection
            this._session.dispose();
            this._session = null;
        }
        if (this._dialog) {
            this._dialog.dispose();
        }
        if (this._busyDisposable) {
            this._busyDisposable.dispose();
            this._busyDisposable = null;
        }
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal.clearData(this);
    }
    /**
     * Starts new Kernel.
     *
     * @returns Whether to ask the user to pick a kernel.
     */
    async startKernel() {
        const preference = this.kernelPreference;
        if (!preference.autoStartDefault && preference.shouldStart === false) {
            return true;
        }
        let options;
        if (preference.id) {
            options = { id: preference.id };
        }
        else {
            const name = Private.getDefaultKernel({
                specs: this.specsManager.specs,
                sessions: this.sessionManager.running(),
                preference
            });
            if (name) {
                options = { name };
            }
        }
        if (options) {
            try {
                await this._changeKernel(options);
                return false;
            }
            catch (err) {
                /* no-op */
            }
        }
        // Always fall back to selecting a kernel
        return true;
    }
    /**
     * Restart the current Kernel.
     *
     * @returns A promise that resolves when the kernel is restarted.
     */
    async restartKernel() {
        var _a, _b, _c, _d, _e, _f;
        const kernel = ((_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel) || null;
        if (this._isRestarting) {
            return;
        }
        this._isRestarting = true;
        this._isReady = false;
        this._statusChanged.emit('restarting');
        try {
            await ((_c = (_b = this.session) === null || _b === void 0 ? void 0 : _b.kernel) === null || _c === void 0 ? void 0 : _c.restart());
            this._isReady = true;
        }
        catch (e) {
            console.error(e);
        }
        this._isRestarting = false;
        this._statusChanged.emit(((_e = (_d = this.session) === null || _d === void 0 ? void 0 : _d.kernel) === null || _e === void 0 ? void 0 : _e.status) || 'unknown');
        this._kernelChanged.emit({
            name: 'kernel',
            oldValue: kernel,
            newValue: ((_f = this.session) === null || _f === void 0 ? void 0 : _f.kernel) || null
        });
    }
    /**
     * Change the current kernel associated with the session.
     */
    async changeKernel(options = {}) {
        if (this.isDisposed) {
            throw new Error('Disposed');
        }
        // Wait for the initialization method to try
        // and start its kernel first to ensure consistent
        // ordering.
        await this._initStarted.promise;
        return this._changeKernel(options);
    }
    /**
     * Kill the kernel and shutdown the session.
     *
     * @returns A promise that resolves when the session is shut down.
     */
    async shutdown() {
        if (this.isDisposed || !this._initializing) {
            return;
        }
        await this._initStarted.promise;
        this._pendingSessionRequest = '';
        this._pendingKernelName = this.noKernelName;
        return this._shutdownSession();
    }
    /**
     * Initialize the session context
     *
     * @returns A promise that resolves with whether to ask the user to select a kernel.
     *
     * #### Notes
     * If a server session exists on the current path, we will connect to it.
     * If preferences include disabling `canStart` or `shouldStart`, no
     * server session will be started.
     * If a kernel id is given, we attempt to start a session with that id.
     * If a default kernel is available, we connect to it.
     * Otherwise we ask the user to select a kernel.
     */
    async initialize() {
        if (this._initializing) {
            return this._initPromise.promise;
        }
        this._initializing = true;
        const needsSelection = await this._initialize();
        if (!needsSelection) {
            this._isReady = true;
            this._ready.resolve(undefined);
        }
        if (!this._pendingSessionRequest) {
            this._initStarted.resolve(void 0);
        }
        this._initPromise.resolve(needsSelection);
        return needsSelection;
    }
    /**
     * Inner initialize function that doesn't handle promises.
     * This makes it easier to consolidate promise handling logic.
     */
    async _initialize() {
        const manager = this.sessionManager;
        await manager.ready;
        await manager.refreshRunning();
        const model = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.find)(manager.running(), item => {
            return item.path === this._path;
        });
        if (model) {
            try {
                const session = manager.connectTo({ model });
                this._handleNewSession(session);
            }
            catch (err) {
                void this._handleSessionError(err);
                return Promise.reject(err);
            }
        }
        return await this._startIfNecessary();
    }
    /**
     * Shut down the current session.
     */
    async _shutdownSession() {
        var _a;
        const session = this._session;
        // Capture starting values in case an error is raised.
        const isTerminating = this._isTerminating;
        const isReady = this._isReady;
        this._isTerminating = true;
        this._isReady = false;
        this._statusChanged.emit('terminating');
        try {
            await (session === null || session === void 0 ? void 0 : session.shutdown());
            this._isTerminating = false;
            session === null || session === void 0 ? void 0 : session.dispose();
            this._session = null;
            const kernel = (session === null || session === void 0 ? void 0 : session.kernel) || null;
            this._statusChanged.emit('unknown');
            this._kernelChanged.emit({
                name: 'kernel',
                oldValue: kernel,
                newValue: null
            });
            this._sessionChanged.emit({
                name: 'session',
                oldValue: session,
                newValue: null
            });
        }
        catch (err) {
            this._isTerminating = isTerminating;
            this._isReady = isReady;
            const status = (_a = session === null || session === void 0 ? void 0 : session.kernel) === null || _a === void 0 ? void 0 : _a.status;
            if (status === undefined) {
                this._statusChanged.emit('unknown');
            }
            else {
                this._statusChanged.emit(status);
            }
            throw err;
        }
        return;
    }
    /**
     * Start the session if necessary.
     *
     * @returns Whether to ask the user to pick a kernel.
     */
    async _startIfNecessary() {
        var _a;
        const preference = this.kernelPreference;
        if (this.isDisposed ||
            ((_a = this.session) === null || _a === void 0 ? void 0 : _a.kernel) ||
            preference.shouldStart === false ||
            preference.canStart === false) {
            // Not necessary to start a kernel
            return false;
        }
        return this.startKernel();
    }
    /**
     * Change the kernel.
     */
    async _changeKernel(model = {}) {
        if (model.name) {
            this._pendingKernelName = model.name;
        }
        if (!this._session) {
            this._kernelChanged.emit({
                name: 'kernel',
                oldValue: null,
                newValue: null
            });
        }
        // Guarantee that the initialized kernel
        // will be started first.
        if (!this._pendingSessionRequest) {
            this._initStarted.resolve(void 0);
        }
        // If we already have a session, just change the kernel.
        if (this._session && !this._isTerminating) {
            try {
                await this._session.changeKernel(model);
                return this._session.kernel;
            }
            catch (err) {
                void this._handleSessionError(err);
                throw err;
            }
        }
        // Use a UUID for the path to overcome a race condition on the server
        // where it will re-use a session for a given path but only after
        // the kernel finishes starting.
        // We later switch to the real path below.
        // Use the correct directory so the kernel will be started in that directory.
        const dirName = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.PathExt.dirname(this._path);
        const requestId = (this._pendingSessionRequest = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.PathExt.join(dirName, _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.UUID.uuid4()));
        try {
            this._statusChanged.emit('starting');
            const session = await this.sessionManager.startNew({
                path: requestId,
                type: this._type,
                name: this._name,
                kernel: model
            });
            // Handle a preempt.
            if (this._pendingSessionRequest !== session.path) {
                await session.shutdown();
                session.dispose();
                return null;
            }
            // Change to the real path.
            await session.setPath(this._path);
            // Update the name in case it has changed since we launched the session.
            await session.setName(this._name);
            if (this._session && !this._isTerminating) {
                await this._shutdownSession();
            }
            return this._handleNewSession(session);
        }
        catch (err) {
            void this._handleSessionError(err);
            throw err;
        }
    }
    /**
     * Handle a new session object.
     */
    _handleNewSession(session) {
        var _a, _b, _c;
        if (this.isDisposed) {
            throw Error('Disposed');
        }
        if (!this._isReady) {
            this._isReady = true;
            this._ready.resolve(undefined);
        }
        if (this._session) {
            this._session.dispose();
        }
        this._session = session;
        this._pendingKernelName = '';
        if (session) {
            this._prevKernelName = (_b = (_a = session.kernel) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : '';
            session.disposed.connect(this._onSessionDisposed, this);
            session.propertyChanged.connect(this._onPropertyChanged, this);
            session.kernelChanged.connect(this._onKernelChanged, this);
            session.statusChanged.connect(this._onStatusChanged, this);
            session.connectionStatusChanged.connect(this._onConnectionStatusChanged, this);
            session.pendingInput.connect(this._onPendingInput, this);
            session.iopubMessage.connect(this._onIopubMessage, this);
            session.unhandledMessage.connect(this._onUnhandledMessage, this);
            if (session.path !== this._path) {
                this._onPropertyChanged(session, 'path');
            }
            if (session.name !== this._name) {
                this._onPropertyChanged(session, 'name');
            }
            if (session.type !== this._type) {
                this._onPropertyChanged(session, 'type');
            }
        }
        // Any existing session/kernel connection was disposed above when the session was
        // disposed, so the oldValue should be null.
        this._sessionChanged.emit({
            name: 'session',
            oldValue: null,
            newValue: session
        });
        this._kernelChanged.emit({
            oldValue: null,
            newValue: (session === null || session === void 0 ? void 0 : session.kernel) || null,
            name: 'kernel'
        });
        this._statusChanged.emit(((_c = session === null || session === void 0 ? void 0 : session.kernel) === null || _c === void 0 ? void 0 : _c.status) || 'unknown');
        return (session === null || session === void 0 ? void 0 : session.kernel) || null;
    }
    /**
     * Handle an error in session startup.
     */
    async _handleSessionError(err) {
        this._handleNewSession(null);
        let traceback = '';
        let message = '';
        try {
            traceback = err.traceback;
            message = err.message;
        }
        catch (err) {
            // no-op
        }
        await this._displayKernelError(message, traceback);
    }
    /**
     * Display kernel error
     */
    async _displayKernelError(message, traceback) {
        const body = (react__WEBPACK_IMPORTED_MODULE_5__.createElement("div", null,
            message && react__WEBPACK_IMPORTED_MODULE_5__.createElement("pre", null, message),
            traceback && (react__WEBPACK_IMPORTED_MODULE_5__.createElement("details", { className: "jp-mod-wide" },
                react__WEBPACK_IMPORTED_MODULE_5__.createElement("pre", null, traceback)))));
        const dialog = (this._dialog = new _dialog__WEBPACK_IMPORTED_MODULE_7__.Dialog({
            title: this._trans.__('Error Starting Kernel'),
            body,
            buttons: [_dialog__WEBPACK_IMPORTED_MODULE_7__.Dialog.okButton()]
        }));
        await dialog.launch();
        this._dialog = null;
    }
    /**
     * Handle a session termination.
     */
    _onSessionDisposed() {
        if (this._session) {
            const oldValue = this._session;
            this._session = null;
            const newValue = this._session;
            this._sessionChanged.emit({ name: 'session', oldValue, newValue });
        }
    }
    /**
     * Handle a change to a session property.
     */
    _onPropertyChanged(sender, property) {
        switch (property) {
            case 'path':
                this._path = sender.path;
                break;
            case 'name':
                this._name = sender.name;
                break;
            case 'type':
                this._type = sender.type;
                break;
            default:
                throw new Error(`unrecognized property ${property}`);
        }
        this._propertyChanged.emit(property);
    }
    /**
     * Handle a change to the kernel.
     */
    _onKernelChanged(sender, args) {
        this._kernelChanged.emit(args);
    }
    /**
     * Handle a change to the session status.
     */
    _onStatusChanged(sender, status) {
        var _a;
        if (status === 'dead') {
            const model = (_a = sender.kernel) === null || _a === void 0 ? void 0 : _a.model;
            if (model === null || model === void 0 ? void 0 : model.reason) {
                const traceback = model.traceback || '';
                void this._displayKernelError(model.reason, traceback);
            }
        }
        // Set that this kernel is busy, if we haven't already
        // If we have already, and now we aren't busy, dispose
        // of the busy disposable.
        if (this._setBusy) {
            if (status === 'busy') {
                if (!this._busyDisposable) {
                    this._busyDisposable = this._setBusy();
                }
            }
            else {
                if (this._busyDisposable) {
                    this._busyDisposable.dispose();
                    this._busyDisposable = null;
                }
            }
        }
        // Proxy the signal
        this._statusChanged.emit(status);
    }
    /**
     * Handle a change to the session status.
     */
    _onConnectionStatusChanged(sender, status) {
        // Proxy the signal
        this._connectionStatusChanged.emit(status);
    }
    /**
     * Handle a change to the pending input.
     */
    _onPendingInput(sender, value) {
        // Set the signal value
        this._pendingInput = value;
    }
    /**
     * Handle an iopub message.
     */
    _onIopubMessage(sender, message) {
        if (message.header.msg_type === 'shutdown_reply') {
            this.session.kernel.removeInputGuard();
        }
        this._iopubMessage.emit(message);
    }
    /**
     * Handle an unhandled message.
     */
    _onUnhandledMessage(sender, message) {
        this._unhandledMessage.emit(message);
    }
}
/**
 * A namespace for `SessionContext` statics.
 */
(function (SessionContext) {
    /**
     * Get the default kernel name given select options.
     */
    function getDefaultKernel(options) {
        const { preference } = options;
        const { shouldStart } = preference;
        if (shouldStart === false) {
            return null;
        }
        return Private.getDefaultKernel(options);
    }
    SessionContext.getDefaultKernel = getDefaultKernel;
})(SessionContext || (SessionContext = {}));
/**
 * The default implementation of the client session dialog provider.
 */
class SessionContextDialogs {
    constructor(options = {}) {
        var _a;
        this._translator = (_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
    }
    /**
     * Select a kernel for the session.
     */
    async selectKernel(sessionContext) {
        if (sessionContext.isDisposed) {
            return Promise.resolve();
        }
        const trans = this._translator.load('jupyterlab');
        // If there is no existing kernel, offer the option
        // to keep no kernel.
        let label = trans.__('Cancel');
        if (sessionContext.hasNoKernel) {
            label = sessionContext.kernelDisplayName;
        }
        const buttons = [
            _dialog__WEBPACK_IMPORTED_MODULE_7__.Dialog.cancelButton({
                label
            }),
            _dialog__WEBPACK_IMPORTED_MODULE_7__.Dialog.okButton({
                label: trans.__('Select'),
                ariaLabel: trans.__('Select Kernel')
            })
        ];
        const autoStartDefault = sessionContext.kernelPreference.autoStartDefault;
        const hasCheckbox = typeof autoStartDefault === 'boolean';
        const dialog = new _dialog__WEBPACK_IMPORTED_MODULE_7__.Dialog({
            title: trans.__('Select Kernel'),
            body: new Private.KernelSelector(sessionContext, this._translator),
            buttons,
            checkbox: hasCheckbox
                ? {
                    label: trans.__('Always start the preferred kernel'),
                    caption: trans.__('Remember my choice and always start the preferred kernel'),
                    checked: autoStartDefault
                }
                : null
        });
        const result = await dialog.launch();
        if (sessionContext.isDisposed || !result.button.accept) {
            return;
        }
        if (hasCheckbox && result.isChecked !== null) {
            sessionContext.kernelPreference = {
                ...sessionContext.kernelPreference,
                autoStartDefault: result.isChecked
            };
        }
        const model = result.value;
        if (model === null && !sessionContext.hasNoKernel) {
            return sessionContext.shutdown();
        }
        if (model) {
            await sessionContext.changeKernel(model);
        }
    }
    /**
     * Restart the session.
     *
     * @returns A promise that resolves with whether the kernel has restarted.
     *
     * #### Notes
     * If there is a running kernel, present a dialog.
     * If there is no kernel, we start a kernel with the last run
     * kernel name and resolves with `true`.
     */
    async restart(sessionContext) {
        var _a;
        const trans = this._translator.load('jupyterlab');
        await sessionContext.initialize();
        if (sessionContext.isDisposed) {
            throw new Error('session already disposed');
        }
        const kernel = (_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (!kernel && sessionContext.prevKernelName) {
            await sessionContext.changeKernel({
                name: sessionContext.prevKernelName
            });
            return true;
        }
        // Bail if there is no previous kernel to start.
        if (!kernel) {
            throw new Error('No kernel to restart');
        }
        const restartBtn = _dialog__WEBPACK_IMPORTED_MODULE_7__.Dialog.warnButton({
            label: trans.__('Restart'),
            ariaLabel: trans.__('Confirm Kernel Restart')
        });
        const result = await (0,_dialog__WEBPACK_IMPORTED_MODULE_7__.showDialog)({
            title: trans.__('Restart Kernel?'),
            body: trans.__('Do you want to restart the kernel of %1? All variables will be lost.', sessionContext.name),
            buttons: [
                _dialog__WEBPACK_IMPORTED_MODULE_7__.Dialog.cancelButton({ ariaLabel: trans.__('Cancel Kernel Restart') }),
                restartBtn
            ]
        });
        if (kernel.isDisposed) {
            return false;
        }
        if (result.button.accept) {
            await sessionContext.restartKernel();
            return true;
        }
        return false;
    }
}
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * A widget that provides a kernel selection.
     */
    class KernelSelector extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__.Widget {
        /**
         * Create a new kernel selector widget.
         */
        constructor(sessionContext, translator) {
            super({ node: createSelectorNode(sessionContext, translator) });
        }
        /**
         * Get the value of the kernel selector widget.
         */
        getValue() {
            const selector = this.node.querySelector('select');
            return JSON.parse(selector.value);
        }
    }
    Private.KernelSelector = KernelSelector;
    /**
     * Create a node for a kernel selector widget.
     */
    function createSelectorNode(sessionContext, translator) {
        // Create the dialog body.
        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        const body = document.createElement('div');
        const text = document.createElement('label');
        text.textContent = `${trans.__('Select kernel for:')} "${sessionContext.name}"`;
        body.appendChild(text);
        const options = getKernelSearch(sessionContext);
        const selector = document.createElement('select');
        populateKernelSelect(selector, options, translator, !sessionContext.hasNoKernel ? sessionContext.kernelDisplayName : null);
        body.appendChild(selector);
        return body;
    }
    /**
     * Get the default kernel name given select options.
     */
    function getDefaultKernel(options) {
        var _a;
        const { specs, preference } = options;
        const { name, language, canStart, autoStartDefault } = preference;
        if (!specs || canStart === false) {
            return null;
        }
        const defaultName = autoStartDefault ? specs.default : null;
        if (!name && !language) {
            return defaultName;
        }
        // Look for an exact match of a spec name.
        for (const specName in specs.kernelspecs) {
            if (specName === name) {
                return name;
            }
        }
        // Bail if there is no language.
        if (!language) {
            return defaultName;
        }
        // Check for a single kernel matching the language.
        const matches = [];
        for (const specName in specs.kernelspecs) {
            const kernelLanguage = (_a = specs.kernelspecs[specName]) === null || _a === void 0 ? void 0 : _a.language;
            if (language === kernelLanguage) {
                matches.push(specName);
            }
        }
        if (matches.length === 1) {
            const specName = matches[0];
            console.warn('No exact match found for ' +
                specName +
                ', using kernel ' +
                specName +
                ' that matches ' +
                'language=' +
                language);
            return specName;
        }
        // No matches found.
        return defaultName;
    }
    Private.getDefaultKernel = getDefaultKernel;
    /**
     * Populate a kernel select node for the session.
     */
    function populateKernelSelect(node, options, translator, currentKernelDisplayName = null) {
        var _a;
        while (node.firstChild) {
            node.removeChild(node.firstChild);
        }
        const { preference, sessions, specs } = options;
        const { name, id, language, canStart, shouldStart } = preference;
        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        if (!specs || canStart === false) {
            node.appendChild(optionForNone(translator));
            node.value = 'null';
            node.disabled = true;
            return;
        }
        node.disabled = false;
        // Create mappings of display names and languages for kernel name.
        const displayNames = Object.create(null);
        const languages = Object.create(null);
        for (const name in specs.kernelspecs) {
            const spec = specs.kernelspecs[name];
            displayNames[name] = spec.display_name;
            languages[name] = spec.language;
        }
        // Handle a kernel by name.
        const names = [];
        if (name && name in specs.kernelspecs) {
            names.push(name);
        }
        // Then look by language if we have a selected and existing kernel.
        if (name && names.length > 0 && language) {
            for (const specName in specs.kernelspecs) {
                if (name !== specName && languages[specName] === language) {
                    names.push(specName);
                }
            }
        }
        // Use the default kernel if no kernels were found.
        if (!names.length) {
            names.push(specs.default);
        }
        // Handle a preferred kernels in order of display name.
        const preferred = document.createElement('optgroup');
        preferred.label = trans.__('Start Preferred Kernel');
        names.sort((a, b) => displayNames[a].localeCompare(displayNames[b]));
        for (const name of names) {
            preferred.appendChild(optionForName(name, displayNames[name]));
        }
        if (preferred.firstChild) {
            node.appendChild(preferred);
        }
        // Add an option for no kernel
        node.appendChild(optionForNone(translator));
        const other = document.createElement('optgroup');
        other.label = trans.__('Start Other Kernel');
        // Add the rest of the kernel names in alphabetical order.
        const otherNames = [];
        for (const specName in specs.kernelspecs) {
            if (names.indexOf(specName) !== -1) {
                continue;
            }
            otherNames.push(specName);
        }
        otherNames.sort((a, b) => displayNames[a].localeCompare(displayNames[b]));
        for (const otherName of otherNames) {
            other.appendChild(optionForName(otherName, displayNames[otherName]));
        }
        // Add a separator option if there were any other names.
        if (otherNames.length) {
            node.appendChild(other);
        }
        // Handle the default value.
        if (shouldStart === false) {
            node.value = 'null';
        }
        else {
            let selectedIndex = 0;
            if (currentKernelDisplayName) {
                // Select current kernel by default.
                selectedIndex = [...node.options].findIndex(option => option.text === currentKernelDisplayName);
                selectedIndex = Math.max(selectedIndex, 0);
            }
            node.selectedIndex = selectedIndex;
        }
        // Bail if there are no sessions.
        if (!sessions) {
            return;
        }
        // Add the sessions using the preferred language first.
        const matchingSessions = [];
        const otherSessions = [];
        for (const session of sessions) {
            if (language &&
                session.kernel &&
                languages[session.kernel.name] === language &&
                session.kernel.id !== id) {
                matchingSessions.push(session);
            }
            else if (((_a = session.kernel) === null || _a === void 0 ? void 0 : _a.id) !== id) {
                otherSessions.push(session);
            }
        }
        const matching = document.createElement('optgroup');
        matching.label = trans.__('Use Kernel from Preferred Session');
        node.appendChild(matching);
        if (matchingSessions.length) {
            matchingSessions.sort((a, b) => {
                return a.path.localeCompare(b.path);
            });
            for (const session of matchingSessions) {
                const name = session.kernel ? displayNames[session.kernel.name] : '';
                matching.appendChild(optionForSession(session, name, translator));
            }
        }
        const otherSessionsNode = document.createElement('optgroup');
        otherSessionsNode.label = trans.__('Use Kernel from Other Session');
        node.appendChild(otherSessionsNode);
        if (otherSessions.length) {
            otherSessions.sort((a, b) => {
                return a.path.localeCompare(b.path);
            });
            for (const session of otherSessions) {
                const name = session.kernel
                    ? displayNames[session.kernel.name] || session.kernel.name
                    : '';
                otherSessionsNode.appendChild(optionForSession(session, name, translator));
            }
        }
    }
    Private.populateKernelSelect = populateKernelSelect;
    /**
     * Get the kernel search options given a session context and session manager.
     */
    function getKernelSearch(sessionContext) {
        return {
            specs: sessionContext.specsManager.specs,
            sessions: sessionContext.sessionManager.running(),
            preference: sessionContext.kernelPreference
        };
    }
    /**
     * Create an option element for a kernel name.
     */
    function optionForName(name, displayName) {
        const option = document.createElement('option');
        option.text = displayName;
        option.value = JSON.stringify({ name });
        return option;
    }
    /**
     * Create an option for no kernel.
     */
    function optionForNone(translator) {
        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        const group = document.createElement('optgroup');
        group.label = trans.__('Use No Kernel');
        const option = document.createElement('option');
        option.text = trans.__('No Kernel');
        option.value = 'null';
        group.appendChild(option);
        return group;
    }
    /**
     * Create an option element for a session.
     */
    function optionForSession(session, displayName, translator) {
        var _a, _b;
        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        const option = document.createElement('option');
        const sessionName = session.name || _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.PathExt.basename(session.path);
        option.text = sessionName;
        option.value = JSON.stringify({ id: (_a = session.kernel) === null || _a === void 0 ? void 0 : _a.id });
        option.title =
            `${trans.__('Path:')} ${session.path}\n` +
                `${trans.__('Name:')} ${sessionName}\n` +
                `${trans.__('Kernel Name:')} ${displayName}\n` +
                `${trans.__('Kernel Id:')} ${(_b = session.kernel) === null || _b === void 0 ? void 0 : _b.id}`;
        return option;
    }
})(Private || (Private = {}));
//# sourceMappingURL=sessioncontext.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/thememanager.js":
/*!***************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/thememanager.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThemeManager: () => (/* binding */ ThemeManager)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/disposable */ "./node_modules/@lumino/disposable/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dialog */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.





/**
 * The number of milliseconds between theme loading attempts.
 */
const REQUEST_INTERVAL = 75;
/**
 * The number of times to attempt to load a theme before giving up.
 */
const REQUEST_THRESHOLD = 20;
/**
 * A class that provides theme management.
 */
class ThemeManager {
    /**
     * Construct a new theme manager.
     */
    constructor(options) {
        this._current = null;
        this._links = [];
        this._overrides = {};
        this._overrideProps = {};
        this._outstanding = null;
        this._pending = 0;
        this._requests = {};
        this._themes = {};
        this._themeChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);
        const { host, key, splash, url } = options;
        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        const registry = options.settings;
        this._base = url;
        this._host = host;
        this._splash = splash || null;
        void registry.load(key).then(settings => {
            this._settings = settings;
            // set up css overrides once we have a pointer to the settings schema
            this._initOverrideProps();
            this._settings.changed.connect(this._loadSettings, this);
            this._loadSettings();
        });
    }
    /**
     * Get the name of the current theme.
     */
    get theme() {
        return this._current;
    }
    /**
     * The names of the registered themes.
     */
    get themes() {
        return Object.keys(this._themes);
    }
    /**
     * A signal fired when the application theme changes.
     */
    get themeChanged() {
        return this._themeChanged;
    }
    /**
     * Get the value of a CSS variable from its key.
     *
     * @param key - A Jupyterlab CSS variable, without the leading '--jp-'.
     *
     * @returns value - The current value of the Jupyterlab CSS variable
     */
    getCSS(key) {
        var _a;
        return ((_a = this._overrides[key]) !== null && _a !== void 0 ? _a : getComputedStyle(document.documentElement).getPropertyValue(`--jp-${key}`));
    }
    /**
     * Load a theme CSS file by path.
     *
     * @param path - The path of the file to load.
     */
    loadCSS(path) {
        const base = this._base;
        const href = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.URLExt.isLocal(path) ? _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.URLExt.join(base, path) : path;
        const links = this._links;
        return new Promise((resolve, reject) => {
            const link = document.createElement('link');
            link.setAttribute('rel', 'stylesheet');
            link.setAttribute('type', 'text/css');
            link.setAttribute('href', href);
            link.addEventListener('load', () => {
                resolve(undefined);
            });
            link.addEventListener('error', () => {
                reject(`Stylesheet failed to load: ${href}`);
            });
            document.body.appendChild(link);
            links.push(link);
            // add any css overrides to document
            this.loadCSSOverrides();
        });
    }
    /**
     * Loads all current CSS overrides from settings. If an override has been
     * removed or is invalid, this function unloads it instead.
     */
    loadCSSOverrides() {
        var _a;
        const newOverrides = (_a = this._settings.user['overrides']) !== null && _a !== void 0 ? _a : {};
        // iterate over the union of current and new CSS override keys
        Object.keys({ ...this._overrides, ...newOverrides }).forEach(key => {
            const val = newOverrides[key];
            if (val && this.validateCSS(key, val)) {
                // validation succeeded, set the override
                document.documentElement.style.setProperty(`--jp-${key}`, val);
            }
            else {
                // if key is not present or validation failed, the override will be removed
                delete newOverrides[key];
                document.documentElement.style.removeProperty(`--jp-${key}`);
            }
        });
        // replace the current overrides with the new ones
        this._overrides = newOverrides;
    }
    /**
     * Validate a CSS value w.r.t. a key
     *
     * @param key - A Jupyterlab CSS variable, without the leading '--jp-'.
     *
     * @param val - A candidate CSS value
     */
    validateCSS(key, val) {
        // determine the css property corresponding to the key
        const prop = this._overrideProps[key];
        if (!prop) {
            console.warn('CSS validation failed: could not find property corresponding to key.\n' +
                `key: '${key}', val: '${val}'`);
            return false;
        }
        // use built-in validation once we have the corresponding property
        if (CSS.supports(prop, val)) {
            return true;
        }
        else {
            console.warn('CSS validation failed: invalid value.\n' +
                `key: '${key}', val: '${val}', prop: '${prop}'`);
            return false;
        }
    }
    /**
     * Register a theme with the theme manager.
     *
     * @param theme - The theme to register.
     *
     * @returns A disposable that can be used to unregister the theme.
     */
    register(theme) {
        const { name } = theme;
        const themes = this._themes;
        if (themes[name]) {
            throw new Error(`Theme already registered for ${name}`);
        }
        themes[name] = theme;
        return new _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__.DisposableDelegate(() => {
            delete themes[name];
        });
    }
    /**
     * Add a CSS override to the settings.
     */
    setCSSOverride(key, value) {
        return this._settings.set('overrides', {
            ...this._overrides,
            [key]: value
        });
    }
    /**
     * Set the current theme.
     */
    setTheme(name) {
        return this._settings.set('theme', name);
    }
    /**
     * Test whether a given theme is light.
     */
    isLight(name) {
        return this._themes[name].isLight;
    }
    /**
     * Increase a font size w.r.t. its current setting or its value in the
     * current theme.
     *
     * @param key - A Jupyterlab font size CSS variable, without the leading '--jp-'.
     */
    incrFontSize(key) {
        return this._incrFontSize(key, true);
    }
    /**
     * Decrease a font size w.r.t. its current setting or its value in the
     * current theme.
     *
     * @param key - A Jupyterlab font size CSS variable, without the leading '--jp-'.
     */
    decrFontSize(key) {
        return this._incrFontSize(key, false);
    }
    /**
     * Test whether a given theme styles scrollbars,
     * and if the user has scrollbar styling enabled.
     */
    themeScrollbars(name) {
        return (!!this._settings.composite['theme-scrollbars'] &&
            !!this._themes[name].themeScrollbars);
    }
    /**
     * Test if the user has scrollbar styling enabled.
     */
    isToggledThemeScrollbars() {
        return !!this._settings.composite['theme-scrollbars'];
    }
    /**
     * Toggle the `theme-scrollbars` setting.
     */
    toggleThemeScrollbars() {
        return this._settings.set('theme-scrollbars', !this._settings.composite['theme-scrollbars']);
    }
    /**
     * Get the display name of the theme.
     */
    getDisplayName(name) {
        var _a, _b;
        return (_b = (_a = this._themes[name]) === null || _a === void 0 ? void 0 : _a.displayName) !== null && _b !== void 0 ? _b : name;
    }
    /**
     * Change a font size by a positive or negative increment.
     */
    _incrFontSize(key, add = true) {
        var _a;
        // get the numeric and unit parts of the current font size
        const parts = ((_a = this.getCSS(key)) !== null && _a !== void 0 ? _a : '13px').split(/([a-zA-Z]+)/);
        // determine the increment
        const incr = (add ? 1 : -1) * (parts[1] === 'em' ? 0.1 : 1);
        // increment the font size and set it as an override
        return this.setCSSOverride(key, `${Number(parts[0]) + incr}${parts[1]}`);
    }
    /**
     * Initialize the key -> property dict for the overrides
     */
    _initOverrideProps() {
        const definitions = this._settings.schema.definitions;
        const overidesSchema = definitions.cssOverrides.properties;
        Object.keys(overidesSchema).forEach(key => {
            // override validation is against the CSS property in the description
            // field. Example: for key ui-font-family, .description is font-family
            let description;
            switch (key) {
                case 'code-font-size':
                case 'content-font-size1':
                case 'ui-font-size1':
                    description = 'font-size';
                    break;
                default:
                    description = overidesSchema[key].description;
                    break;
            }
            this._overrideProps[key] = description;
        });
    }
    /**
     * Handle the current settings.
     */
    _loadSettings() {
        const outstanding = this._outstanding;
        const pending = this._pending;
        const requests = this._requests;
        // If another request is pending, cancel it.
        if (pending) {
            window.clearTimeout(pending);
            this._pending = 0;
        }
        const settings = this._settings;
        const themes = this._themes;
        const theme = settings.composite['theme'];
        // If another promise is outstanding, wait until it finishes before
        // attempting to load the settings. Because outstanding promises cannot
        // be aborted, the order in which they occur must be enforced.
        if (outstanding) {
            outstanding
                .then(() => {
                this._loadSettings();
            })
                .catch(() => {
                this._loadSettings();
            });
            this._outstanding = null;
            return;
        }
        // Increment the request counter.
        requests[theme] = requests[theme] ? requests[theme] + 1 : 1;
        // If the theme exists, load it right away.
        if (themes[theme]) {
            this._outstanding = this._loadTheme(theme);
            delete requests[theme];
            return;
        }
        // If the request has taken too long, give up.
        if (requests[theme] > REQUEST_THRESHOLD) {
            const fallback = settings.default('theme');
            // Stop tracking the requests for this theme.
            delete requests[theme];
            if (!themes[fallback]) {
                this._onError(this._trans.__('Neither theme %1 nor default %2 loaded.', theme, fallback));
                return;
            }
            console.warn(`Could not load theme ${theme}, using default ${fallback}.`);
            this._outstanding = this._loadTheme(fallback);
            return;
        }
        // If the theme does not yet exist, attempt to wait for it.
        this._pending = window.setTimeout(() => {
            this._loadSettings();
        }, REQUEST_INTERVAL);
    }
    /**
     * Load the theme.
     *
     * #### Notes
     * This method assumes that the `theme` exists.
     */
    _loadTheme(theme) {
        var _a;
        const current = this._current;
        const links = this._links;
        const themes = this._themes;
        const splash = this._splash
            ? this._splash.show(themes[theme].isLight)
            : new _lumino_disposable__WEBPACK_IMPORTED_MODULE_1__.DisposableDelegate(() => undefined);
        // Unload any CSS files that have been loaded.
        links.forEach(link => {
            if (link.parentElement) {
                link.parentElement.removeChild(link);
            }
        });
        links.length = 0;
        const themeProps = (_a = this._settings.schema.properties) === null || _a === void 0 ? void 0 : _a.theme;
        if (themeProps) {
            themeProps.enum = Object.keys(themes).map(value => { var _a; return (_a = themes[value].displayName) !== null && _a !== void 0 ? _a : value; });
        }
        // Unload the previously loaded theme.
        const old = current ? themes[current].unload() : Promise.resolve();
        return Promise.all([old, themes[theme].load()])
            .then(() => {
            this._current = theme;
            this._themeChanged.emit({
                name: 'theme',
                oldValue: current,
                newValue: theme
            });
            // Need to force a redraw of the app here to avoid a Chrome rendering
            // bug that can leave the scrollbars in an invalid state
            this._host.hide();
            // If we hide/show the widget too quickly, no redraw will happen.
            // requestAnimationFrame delays until after the next frame render.
            requestAnimationFrame(() => {
                this._host.show();
                Private.fitAll(this._host);
                splash.dispose();
            });
        })
            .catch(reason => {
            this._onError(reason);
            splash.dispose();
        });
    }
    /**
     * Handle a theme error.
     */
    _onError(reason) {
        void (0,_dialog__WEBPACK_IMPORTED_MODULE_4__.showDialog)({
            title: this._trans.__('Error Loading Theme'),
            body: String(reason),
            buttons: [_dialog__WEBPACK_IMPORTED_MODULE_4__.Dialog.okButton({ label: this._trans.__('OK') })]
        });
    }
}
/**
 * A namespace for module private data.
 */
var Private;
(function (Private) {
    /**
     * Fit a widget and all of its children, recursively.
     */
    function fitAll(widget) {
        for (const child of widget.children()) {
            fitAll(child);
        }
        widget.fit();
    }
    Private.fitAll = fitAll;
})(Private || (Private = {}));
//# sourceMappingURL=thememanager.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/tokens.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/tokens.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ICommandPalette: () => (/* binding */ ICommandPalette),
/* harmony export */   IKernelStatusModel: () => (/* binding */ IKernelStatusModel),
/* harmony export */   ISanitizer: () => (/* binding */ ISanitizer),
/* harmony export */   ISessionContextDialogs: () => (/* binding */ ISessionContextDialogs),
/* harmony export */   ISplashScreen: () => (/* binding */ ISplashScreen),
/* harmony export */   IThemeManager: () => (/* binding */ IThemeManager),
/* harmony export */   IToolbarWidgetRegistry: () => (/* binding */ IToolbarWidgetRegistry),
/* harmony export */   IWindowResolver: () => (/* binding */ IWindowResolver)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The command palette token.
 */
const ICommandPalette = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:ICommandPalette', `A service for the application command palette
  in the left panel. Use this to add commands to the palette.`);
/**
 * The kernel status indicator model.
 */
const IKernelStatusModel = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:IKernelStatusModel', 'A service to register kernel session provider to the kernel status indicator.');
/**
 * The session context dialogs token.
 */
const ISessionContextDialogs = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:ISessionContextDialogs', 'A service for handling the session dialogs.');
/**
 * The theme manager token.
 */
const IThemeManager = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:IThemeManager', 'A service for the theme manager for the application. This is used primarily in theme extensions to register new themes.');
/**
 * The sanitizer token.
 */
const ISanitizer = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:ISanitizer', 'A service for sanitizing HTML strings.');
/**
 * The main menu token.
 */
const ISplashScreen = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:ISplashScreen', `A service for the splash screen for the application.
  Use this if you want to show the splash screen for your own purposes.`);
/**
 * The default window resolver token.
 */
const IWindowResolver = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:IWindowResolver', `A service for a window resolver for the
  application. JupyterLab workspaces are given a name, which are determined using
  the window resolver. Require this if you want to use the name of the current workspace.`);
/**
 * The toolbar registry token.
 */
const IToolbarWidgetRegistry = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/apputils:IToolbarWidgetRegistry', `A registry for toolbar widgets. Require this
  if you want to build the toolbar dynamically from a data definition (stored in settings for example).`);
//# sourceMappingURL=tokens.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/toolbar/factory.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/toolbar/factory.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createToolbarFactory: () => (/* binding */ createToolbarFactory),
/* harmony export */   setToolbar: () => (/* binding */ setToolbar)
/* harmony export */ });
/* harmony import */ var _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/observables */ "./node_modules/@jupyterlab/observables/lib/observablelist.js");
/* harmony import */ var _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/settingregistry */ "./node_modules/@jupyterlab/settingregistry/lib/settingregistry.js");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dialog */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */





/**
 * Default toolbar item rank
 *
 * #### Notes
 * This will place item just before the white spacer item in the notebook toolbar.
 */
const DEFAULT_TOOLBAR_ITEM_RANK = 50;
const TOOLBAR_KEY = 'jupyter.lab.toolbars';
/**
 * Display warning when the toolbar definition have been modified.
 *
 * @param trans Translation bundle
 */
async function displayInformation(trans) {
    const result = await (0,_dialog__WEBPACK_IMPORTED_MODULE_2__.showDialog)({
        title: trans.__('Information'),
        body: trans.__('Toolbar customization has changed. You will need to reload JupyterLab to see the changes.'),
        buttons: [
            _dialog__WEBPACK_IMPORTED_MODULE_2__.Dialog.cancelButton(),
            _dialog__WEBPACK_IMPORTED_MODULE_2__.Dialog.okButton({ label: trans.__('Reload') })
        ]
    });
    if (result.button.accept) {
        location.reload();
    }
}
/**
 * Set the toolbar definition by accumulating all settings definition.
 *
 * The list will be populated only with the enabled items.
 *
 * @param toolbarItems Observable list to populate
 * @param registry Application settings registry
 * @param factoryName Widget factory name that needs a toolbar
 * @param pluginId Settings plugin id
 * @param translator Translator object
 * @param propertyId Property holding the toolbar definition in the settings; default 'toolbar'
 * @returns List of toolbar items
 */
async function setToolbarItems(toolbarItems, registry, factoryName, pluginId, translator, propertyId = 'toolbar') {
    var _a;
    const trans = translator.load('jupyterlab');
    let canonical = null;
    let loaded = {};
    let listenPlugin = true;
    try {
        /**
         * Populate the plugin's schema defaults.
         *
         * We keep track of disabled entries in case the plugin is loaded
         * after the toolbar initialization.
         */
        function populate(schema) {
            var _a, _b;
            loaded = {};
            const pluginDefaults = Object.keys(registry.plugins)
                // Filter out the current plugin (will be listed when reloading)
                // because we control its addition after the mapping step
                .filter(plugin => plugin !== pluginId)
                .map(plugin => {
                var _a, _b;
                const items = (_b = ((_a = registry.plugins[plugin].schema[TOOLBAR_KEY]) !== null && _a !== void 0 ? _a : {})[factoryName]) !== null && _b !== void 0 ? _b : [];
                loaded[plugin] = items;
                return items;
            })
                .concat([(_b = ((_a = schema[TOOLBAR_KEY]) !== null && _a !== void 0 ? _a : {})[factoryName]) !== null && _b !== void 0 ? _b : []])
                .reduceRight((acc, val) => _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_3__.SettingRegistry.reconcileToolbarItems(acc, val, true), []);
            // Apply default value as last step to take into account overrides.json
            // The standard toolbars default is [] as the plugin must use
            // `jupyter.lab.toolbars.<factory>` to define its default value.
            schema.properties[propertyId].default =
                _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_3__.SettingRegistry.reconcileToolbarItems(pluginDefaults, schema.properties[propertyId].default, true).sort((a, b) => {
                    var _a, _b;
                    return ((_a = a.rank) !== null && _a !== void 0 ? _a : DEFAULT_TOOLBAR_ITEM_RANK) -
                        ((_b = b.rank) !== null && _b !== void 0 ? _b : DEFAULT_TOOLBAR_ITEM_RANK);
                });
        }
        // Transform the plugin object to return different schema than the default.
        registry.transform(pluginId, {
            compose: plugin => {
                var _a, _b, _c, _d, _e;
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                const defaults = (_c = ((_b = ((_a = canonical.properties) !== null && _a !== void 0 ? _a : {})[propertyId]) !== null && _b !== void 0 ? _b : {}).default) !== null && _c !== void 0 ? _c : [];
                // Initialize the settings
                const user = plugin.data.user;
                const composite = plugin.data.composite;
                // Overrides the value with using the aggregated default for the toolbar property
                user[propertyId] =
                    (_d = plugin.data.user[propertyId]) !== null && _d !== void 0 ? _d : [];
                composite[propertyId] = ((_e = _jupyterlab_settingregistry__WEBPACK_IMPORTED_MODULE_3__.SettingRegistry.reconcileToolbarItems(defaults, user[propertyId], false)) !== null && _e !== void 0 ? _e : []).sort((a, b) => {
                    var _a, _b;
                    return ((_a = a.rank) !== null && _a !== void 0 ? _a : DEFAULT_TOOLBAR_ITEM_RANK) -
                        ((_b = b.rank) !== null && _b !== void 0 ? _b : DEFAULT_TOOLBAR_ITEM_RANK);
                });
                plugin.data = { composite, user };
                return plugin;
            },
            fetch: plugin => {
                // Only override the canonical schema the first time.
                if (!canonical) {
                    canonical = _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepCopy(plugin.schema);
                    populate(canonical);
                }
                return {
                    data: plugin.data,
                    id: plugin.id,
                    raw: plugin.raw,
                    schema: canonical,
                    version: plugin.version
                };
            }
        });
    }
    catch (error) {
        if (error.name === 'TransformError') {
            // Assume the existing transformer is the toolbar builder transformer
            // from another factory set up.
            listenPlugin = false;
        }
        else {
            throw error;
        }
    }
    // Repopulate the canonical variable after the setting registry has
    // preloaded all initial plugins.
    const settings = await registry.load(pluginId);
    // React to customization by the user
    settings.changed.connect(() => {
        var _a;
        const newItems = (_a = settings.composite[propertyId]) !== null && _a !== void 0 ? _a : [];
        transferSettings(newItems);
    });
    const transferSettings = (newItems) => {
        // This is not optimal but safer because a toolbar item with the same
        // name cannot be inserted (it will be a no-op). But that could happen
        // if the settings are changing the items order.
        toolbarItems.clear();
        toolbarItems.pushAll(newItems.filter(item => !item.disabled));
    };
    // Initialize the toolbar
    transferSettings((_a = settings.composite[propertyId]) !== null && _a !== void 0 ? _a : []);
    // React to plugin changes if no other transformer exists, otherwise bail.
    if (!listenPlugin) {
        return;
    }
    registry.pluginChanged.connect(async (sender, plugin) => {
        var _a, _b, _c;
        // Since the plugin storing the toolbar definition is transformed above,
        // if it has changed, it means that a request to reload was triggered.
        // Hence the toolbar definitions from the other plugins have been
        // automatically reset during the transform step.
        if (plugin === pluginId) {
            return;
        }
        // If a plugin changed its toolbar items
        const oldItems = (_a = loaded[plugin]) !== null && _a !== void 0 ? _a : [];
        const newItems = (_c = ((_b = registry.plugins[plugin].schema[TOOLBAR_KEY]) !== null && _b !== void 0 ? _b : {})[factoryName]) !== null && _c !== void 0 ? _c : [];
        if (!_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(oldItems, newItems)) {
            if (loaded[plugin]) {
                // The plugin has changed, request the user to reload the UI
                await displayInformation(trans);
            }
            else {
                if (newItems.length > 0) {
                    // Empty the default values to avoid toolbar settings collisions.
                    canonical = null;
                    const schema = registry.plugins[pluginId].schema;
                    schema.properties.toolbar.default = [];
                    // Run again the transformations.
                    await registry.load(pluginId, true);
                }
            }
        }
    });
}
/**
 * Create the toolbar factory for a given container widget based
 * on a data description stored in settings
 *
 * @param toolbarRegistry Toolbar widgets registry
 * @param settingsRegistry Settings registry
 * @param factoryName Toolbar container factory name
 * @param pluginId Settings plugin id
 * @param translator Translator
 * @param propertyId Toolbar definition key in the settings plugin
 * @returns List of toolbar widgets factory
 */
function createToolbarFactory(toolbarRegistry, settingsRegistry, factoryName, pluginId, translator, propertyId = 'toolbar') {
    const items = new _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_4__.ObservableList({
        itemCmp: (a, b) => _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(a, b)
    });
    // Get toolbar definition from the settings
    setToolbarItems(items, settingsRegistry, factoryName, pluginId, translator, propertyId).catch(reason => {
        console.error(`Failed to load toolbar items for factory ${factoryName} from ${pluginId}`, reason);
    });
    return (widget) => {
        const updateToolbar = (list, change) => {
            switch (change.type) {
                case 'move':
                    toolbar.move(change.oldIndex, change.newIndex);
                    break;
                case 'add':
                    change.newValues.forEach(item => toolbar.push({
                        name: item.name,
                        widget: toolbarRegistry.createWidget(factoryName, widget, item)
                    }));
                    break;
                case 'remove':
                    change.oldValues.forEach(() => toolbar.remove(change.oldIndex));
                    break;
                case 'set':
                    change.newValues.forEach(item => toolbar.set(change.newIndex, {
                        name: item.name,
                        widget: toolbarRegistry.createWidget(factoryName, widget, item)
                    }));
                    break;
            }
        };
        const updateWidget = (registry, itemName) => {
            const itemIndex = Array.from(items).findIndex(item => item.name === itemName);
            if (itemIndex >= 0) {
                toolbar.set(itemIndex, {
                    name: itemName,
                    widget: toolbarRegistry.createWidget(factoryName, widget, items.get(itemIndex))
                });
            }
        };
        const toolbar = new _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_4__.ObservableList({
            values: Array.from(items).map(item => {
                return {
                    name: item.name,
                    widget: toolbarRegistry.createWidget(factoryName, widget, item)
                };
            })
        });
        // Re-render the widget if a new factory has been added.
        toolbarRegistry.factoryAdded.connect(updateWidget);
        items.changed.connect(updateToolbar);
        widget.disposed.connect(() => {
            items.changed.disconnect(updateToolbar);
            toolbarRegistry.factoryAdded.disconnect(updateWidget);
        });
        return toolbar;
    };
}
/**
 * Set the toolbar items of a widget from a factory
 *
 * @param widget Widget with the toolbar to set
 * @param factory Toolbar items factory
 * @param toolbar Separated toolbar if widget is a raw widget
 */
function setToolbar(widget, factory, toolbar) {
    var _a;
    // @ts-expect-error Widget has no toolbar
    if (!widget.toolbar && !toolbar) {
        console.log(`Widget ${widget.id} has no 'toolbar' and no explicit toolbar was provided.`);
        return;
    }
    // @ts-expect-error Widget has no toolbar
    const toolbar_ = (_a = widget.toolbar) !== null && _a !== void 0 ? _a : toolbar;
    const items = factory(widget);
    if (Array.isArray(items)) {
        items.forEach(({ name, widget: item }) => {
            toolbar_.addItem(name, item);
        });
    }
    else {
        const updateToolbar = (list, changes) => {
            switch (changes.type) {
                case 'add':
                    changes.newValues.forEach((item, index) => {
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
                case 'move':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    changes.newValues.forEach((item, index) => {
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
                case 'remove':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    break;
                case 'set':
                    changes.oldValues.forEach(item => {
                        item.widget.parent = null;
                    });
                    changes.newValues.forEach((item, index) => {
                        const existingIndex = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.findIndex)(toolbar_.names(), name => item.name === name);
                        if (existingIndex >= 0) {
                            Array.from(toolbar_.children())[existingIndex].parent = null;
                        }
                        toolbar_.insertItem(changes.newIndex + index, item.name, item.widget);
                    });
                    break;
            }
        };
        updateToolbar(items, {
            newIndex: 0,
            newValues: Array.from(items),
            oldIndex: 0,
            oldValues: [],
            type: 'add'
        });
        items.changed.connect(updateToolbar);
        widget.disposed.connect(() => {
            items.changed.disconnect(updateToolbar);
        });
    }
}
//# sourceMappingURL=factory.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/toolbar/registry.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/toolbar/registry.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ToolbarWidgetRegistry: () => (/* binding */ ToolbarWidgetRegistry),
/* harmony export */   createDefaultFactory: () => (/* binding */ createDefaultFactory)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/labicon.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/toolbar.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



/**
 * Concrete implementation of IToolbarWidgetRegistry interface
 */
class ToolbarWidgetRegistry {
    constructor(options) {
        this._widgets = new Map();
        this._factoryAdded = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._defaultFactory = options.defaultFactory;
    }
    /**
     * Default toolbar item factory
     */
    get defaultFactory() {
        return this._defaultFactory;
    }
    set defaultFactory(factory) {
        this._defaultFactory = factory;
    }
    /**
     * A signal emitted when a factory widget has been added.
     */
    get factoryAdded() {
        return this._factoryAdded;
    }
    /**
     * Create a toolbar item widget
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param widget The newly widget containing the toolbar
     * @param toolbarItem The toolbar item definition
     * @returns The widget to be inserted in the toolbar.
     */
    createWidget(widgetFactory, widget, toolbarItem) {
        var _a;
        const factory = (_a = this._widgets.get(widgetFactory)) === null || _a === void 0 ? void 0 : _a.get(toolbarItem.name);
        return factory
            ? factory(widget)
            : this._defaultFactory(widgetFactory, widget, toolbarItem);
    }
    /**
     * Add a new toolbar item factory
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param toolbarItemName The unique toolbar item
     * @param factory The factory function that receives the widget containing the toolbar and returns the toolbar widget.
     * @returns The previously defined factory
     */
    addFactory(widgetFactory, toolbarItemName, factory) {
        let namespace = this._widgets.get(widgetFactory);
        const oldFactory = namespace === null || namespace === void 0 ? void 0 : namespace.get(toolbarItemName);
        if (!namespace) {
            namespace = new Map();
            this._widgets.set(widgetFactory, namespace);
        }
        namespace.set(toolbarItemName, factory);
        this._factoryAdded.emit(toolbarItemName);
        return oldFactory;
    }
    /**
     * Register a new toolbar item factory
     *
     * @param widgetFactory The widget factory name that creates the toolbar
     * @param toolbarItemName The unique toolbar item
     * @param factory The factory function that receives the widget containing the toolbar and returns the toolbar widget.
     * @returns The previously defined factory
     *
     * @deprecated since v4 use `addFactory` instead
     */
    registerFactory(widgetFactory, toolbarItemName, factory) {
        return this.addFactory(widgetFactory, toolbarItemName, factory);
    }
}
/**
 * Create the default toolbar item widget factory
 *
 * @param commands Application commands registry
 * @returns Default factory
 */
function createDefaultFactory(commands) {
    return (widgetFactory, widget, toolbarItem) => {
        var _a;
        switch ((_a = toolbarItem.type) !== null && _a !== void 0 ? _a : 'command') {
            case 'command': {
                const { command: tId, args: tArgs, label: tLabel, caption: tCaption, icon: tIcon } = toolbarItem;
                const id = tId !== null && tId !== void 0 ? tId : '';
                const args = { toolbar: true, ...tArgs };
                const icon = tIcon ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.LabIcon.resolve({ icon: tIcon }) : undefined;
                // If there is an icon, undefined label will results in no label
                // otherwise the label will be set using the setting or the command label
                const label = (icon !== null && icon !== void 0 ? icon : commands.icon(id, args)) ? tLabel !== null && tLabel !== void 0 ? tLabel : '' : tLabel;
                return new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.CommandToolbarButton({
                    commands,
                    id,
                    args,
                    icon,
                    label,
                    caption: tCaption
                });
            }
            case 'spacer':
                return _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.Toolbar.createSpacerItem();
            default:
                return new _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget();
        }
    };
}
//# sourceMappingURL=registry.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/toolbar/widget.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/toolbar/widget.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Toolbar: () => (/* binding */ Toolbar)
/* harmony export */ });
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/toolbar.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/vdom.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/labicon.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _sessioncontext__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../sessioncontext */ "./node_modules/@jupyterlab/apputils/lib/sessioncontext.js");
/* harmony import */ var _kernelstatuses__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../kernelstatuses */ "./node_modules/@jupyterlab/apputils/lib/kernelstatuses.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * The class name added to toolbar kernel name text.
 */
const TOOLBAR_KERNEL_NAME_CLASS = 'jp-Toolbar-kernelName';
/**
 * The class name added to toolbar kernel status icon.
 */
const TOOLBAR_KERNEL_STATUS_CLASS = 'jp-Toolbar-kernelStatus';
/**
 * The namespace for Toolbar class statics.
 */
var Toolbar;
(function (Toolbar) {
    /**
     * Create an interrupt toolbar item.
     *
     * @deprecated since version v3.2
     * This is dead code now.
     */
    function createInterruptButton(sessionContext, translator) {
        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        return new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.ToolbarButton({
            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.stopIcon,
            onClick: () => {
                var _a, _b;
                void ((_b = (_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel) === null || _b === void 0 ? void 0 : _b.interrupt());
            },
            tooltip: trans.__('Interrupt the kernel')
        });
    }
    Toolbar.createInterruptButton = createInterruptButton;
    /**
     * Create a restart toolbar item.
     *
     * @deprecated since v3.2
     * This is dead code now.
     */
    function createRestartButton(sessionContext, dialogs, translator) {
        translator = translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        return new _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.ToolbarButton({
            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.refreshIcon,
            onClick: () => {
                void (dialogs !== null && dialogs !== void 0 ? dialogs : new _sessioncontext__WEBPACK_IMPORTED_MODULE_5__.SessionContextDialogs({ translator })).restart(sessionContext);
            },
            tooltip: trans.__('Restart the kernel')
        });
    }
    Toolbar.createRestartButton = createRestartButton;
    /**
     * Create a kernel name indicator item.
     *
     * #### Notes
     * It will display the `'display_name`' of the session context. It can
     * handle a change in context or kernel.
     */
    function createKernelNameItem(sessionContext, dialogs, translator) {
        const el = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.ReactWidget.create(react__WEBPACK_IMPORTED_MODULE_2__.createElement(Private.KernelNameComponent, { sessionContext: sessionContext, dialogs: dialogs !== null && dialogs !== void 0 ? dialogs : new _sessioncontext__WEBPACK_IMPORTED_MODULE_5__.SessionContextDialogs({ translator }), translator: translator }));
        el.addClass('jp-KernelName');
        return el;
    }
    Toolbar.createKernelNameItem = createKernelNameItem;
    /**
     * Create a kernel status indicator item.
     *
     * @deprecated since v3.5
     * The kernel status indicator is now replaced by the execution status indicator.
     *
     * #### Notes
     * It will show a busy status if the kernel status is busy.
     * It will show the current status in the node title.
     * It can handle a change to the context or the kernel.
     */
    function createKernelStatusItem(sessionContext, translator) {
        return new Private.KernelStatus(sessionContext, translator);
    }
    Toolbar.createKernelStatusItem = createKernelStatusItem;
})(Toolbar || (Toolbar = {}));
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * React component for a kernel name button.
     *
     * This wraps the ToolbarButtonComponent and watches the kernel
     * session for changes.
     */
    function KernelNameComponent(props) {
        const translator = props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        const callback = () => {
            void props.dialogs.selectKernel(props.sessionContext);
        };
        return (react__WEBPACK_IMPORTED_MODULE_2__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_6__.UseSignal, { signal: props.sessionContext.kernelChanged, initialSender: props.sessionContext }, sessionContext => (react__WEBPACK_IMPORTED_MODULE_2__.createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_3__.ToolbarButtonComponent, { className: TOOLBAR_KERNEL_NAME_CLASS, onClick: callback, tooltip: trans.__('Switch kernel'), label: sessionContext === null || sessionContext === void 0 ? void 0 : sessionContext.kernelDisplayName }))));
    }
    Private.KernelNameComponent = KernelNameComponent;
    /**
     * A toolbar item that displays kernel status.
     */
    class KernelStatus extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget {
        /**
         * Construct a new kernel status widget.
         */
        constructor(sessionContext, translator) {
            super();
            this.translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
            this._trans = this.translator.load('jupyterlab');
            this.addClass(TOOLBAR_KERNEL_STATUS_CLASS);
            this._statusNames = (0,_kernelstatuses__WEBPACK_IMPORTED_MODULE_7__.translateKernelStatuses)(this.translator);
            this._onStatusChanged(sessionContext);
            sessionContext.statusChanged.connect(this._onStatusChanged, this);
            sessionContext.connectionStatusChanged.connect(this._onStatusChanged, this);
        }
        /**
         * Handle a status on a kernel.
         */
        _onStatusChanged(sessionContext) {
            if (this.isDisposed) {
                return;
            }
            const status = sessionContext.kernelDisplayStatus;
            const circleIconProps = {
                container: this.node,
                title: this._trans.__('Kernel %1', this._statusNames[status] || status),
                stylesheet: 'toolbarButton',
                alignSelf: 'normal',
                height: '24px'
            };
            // set the icon
            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_8__.LabIcon.remove(this.node);
            if (status === 'busy' ||
                status === 'starting' ||
                status === 'terminating' ||
                status === 'restarting' ||
                status === 'initializing') {
                _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.circleIcon.element(circleIconProps);
            }
            else if (status === 'connecting' ||
                status === 'disconnected' ||
                status === 'unknown') {
                _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.offlineBoltIcon.element(circleIconProps);
            }
            else {
                _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.circleEmptyIcon.element(circleIconProps);
            }
        }
    }
    Private.KernelStatus = KernelStatus;
})(Private || (Private = {}));
//# sourceMappingURL=widget.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/widgettracker.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/widgettracker.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WidgetTracker: () => (/* binding */ WidgetTracker)
/* harmony export */ });
/* harmony import */ var _jupyterlab_statedb__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/statedb */ "./node_modules/@jupyterlab/statedb/lib/index.js");
/* harmony import */ var _jupyterlab_statedb__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_statedb__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * A class that keeps track of widget instances on an Application shell.
 *
 * @typeparam T - The type of widget being tracked. Defaults to `Widget`.
 *
 * #### Notes
 * The API surface area of this concrete implementation is substantially larger
 * than the widget tracker interface it implements. The interface is intended
 * for export by JupyterLab plugins that create widgets and have clients who may
 * wish to keep track of newly created widgets. This class, however, can be used
 * internally by plugins to restore state as well.
 */
class WidgetTracker {
    /**
     * Create a new widget tracker.
     *
     * @param options - The instantiation options for a widget tracker.
     */
    constructor(options) {
        this._currentChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._deferred = null;
        this._isDisposed = false;
        this._widgetAdded = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._widgetUpdated = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        const focus = (this._focusTracker = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.FocusTracker());
        const pool = (this._pool = new _jupyterlab_statedb__WEBPACK_IMPORTED_MODULE_2__.RestorablePool(options));
        this.namespace = options.namespace;
        focus.currentChanged.connect((_, current) => {
            if (current.newValue !== this.currentWidget) {
                pool.current = current.newValue;
            }
        }, this);
        pool.added.connect((_, widget) => {
            this._widgetAdded.emit(widget);
        }, this);
        pool.currentChanged.connect((_, widget) => {
            // If the pool's current reference is `null` but the focus tracker has a
            // current widget, update the pool to match the focus tracker.
            if (widget === null && focus.currentWidget) {
                pool.current = focus.currentWidget;
                return;
            }
            this.onCurrentChanged(widget);
            this._currentChanged.emit(widget);
        }, this);
        pool.updated.connect((_, widget) => {
            this._widgetUpdated.emit(widget);
        }, this);
    }
    /**
     * A signal emitted when the current widget changes.
     */
    get currentChanged() {
        return this._currentChanged;
    }
    /**
     * The current widget is the most recently focused or added widget.
     *
     * #### Notes
     * It is the most recently focused widget, or the most recently added
     * widget if no widget has taken focus.
     */
    get currentWidget() {
        return this._pool.current || null;
    }
    /**
     * A promise resolved when the tracker has been restored.
     */
    get restored() {
        if (this._deferred) {
            return Promise.resolve();
        }
        else {
            return this._pool.restored;
        }
    }
    /**
     * The number of widgets held by the tracker.
     */
    get size() {
        return this._pool.size;
    }
    /**
     * A signal emitted when a widget is added.
     *
     * #### Notes
     * This signal will only fire when a widget is added to the tracker. It will
     * not fire if a widget is injected into the tracker.
     */
    get widgetAdded() {
        return this._widgetAdded;
    }
    /**
     * A signal emitted when a widget is updated.
     */
    get widgetUpdated() {
        return this._widgetUpdated;
    }
    /**
     * Add a new widget to the tracker.
     *
     * @param widget - The widget being added.
     *
     * #### Notes
     * The widget passed into the tracker is added synchronously; its existence in
     * the tracker can be checked with the `has()` method. The promise this method
     * returns resolves after the widget has been added and saved to an underlying
     * restoration connector, if one is available.
     *
     * The newly added widget becomes the current widget unless the focus tracker
     * already had a focused widget.
     */
    async add(widget) {
        this._focusTracker.add(widget);
        await this._pool.add(widget);
        if (!this._focusTracker.activeWidget) {
            this._pool.current = widget;
        }
    }
    /**
     * Test whether the tracker is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the tracker.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._pool.dispose();
        this._focusTracker.dispose();
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
    }
    /**
     * Find the first widget in the tracker that satisfies a filter function.
     *
     * @param - fn The filter function to call on each widget.
     *
     * #### Notes
     * If no widget is found, the value returned is `undefined`.
     */
    find(fn) {
        return this._pool.find(fn);
    }
    /**
     * Iterate through each widget in the tracker.
     *
     * @param fn - The function to call on each widget.
     */
    forEach(fn) {
        return this._pool.forEach(fn);
    }
    /**
     * Filter the widgets in the tracker based on a predicate.
     *
     * @param fn - The function by which to filter.
     */
    filter(fn) {
        return this._pool.filter(fn);
    }
    /**
     * Inject a foreign widget into the widget tracker.
     *
     * @param widget - The widget to inject into the tracker.
     *
     * #### Notes
     * Injected widgets will not have their state saved by the tracker.
     *
     * The primary use case for widget injection is for a plugin that offers a
     * sub-class of an extant plugin to have its instances share the same commands
     * as the parent plugin (since most relevant commands will use the
     * `currentWidget` of the parent plugin's widget tracker). In this situation,
     * the sub-class plugin may well have its own widget tracker for layout and
     * state restoration in addition to injecting its widgets into the parent
     * plugin's widget tracker.
     */
    inject(widget) {
        return this._pool.inject(widget);
    }
    /**
     * Check if this tracker has the specified widget.
     *
     * @param widget - The widget whose existence is being checked.
     */
    has(widget) {
        return this._pool.has(widget);
    }
    /**
     * Restore the widgets in this tracker's namespace.
     *
     * @param options - The configuration options that describe restoration.
     *
     * @returns A promise that resolves when restoration has completed.
     *
     * #### Notes
     * This function should not typically be invoked by client code.
     * Its primary use case is to be invoked by a restorer.
     */
    async restore(options) {
        const deferred = this._deferred;
        if (deferred) {
            this._deferred = null;
            return this._pool.restore(deferred);
        }
        if (options) {
            return this._pool.restore(options);
        }
        console.warn('No options provided to restore the tracker.');
    }
    /**
     * Save the restore options for this tracker, but do not restore yet.
     *
     * @param options - The configuration options that describe restoration.
     *
     * ### Notes
     * This function is useful when starting the shell in 'single-document' mode,
     * to avoid restoring all useless widgets. It should not ordinarily be called
     * by client code.
     */
    defer(options) {
        this._deferred = options;
    }
    /**
     * Save the restore data for a given widget.
     *
     * @param widget - The widget being saved.
     */
    async save(widget) {
        return this._pool.save(widget);
    }
    /**
     * Handle the current change event.
     *
     * #### Notes
     * The default implementation is a no-op.
     */
    onCurrentChanged(value) {
        /* no-op */
    }
}
//# sourceMappingURL=widgettracker.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/lib/windowresolver.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/lib/windowresolver.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WindowResolver: () => (/* binding */ WindowResolver)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A concrete implementation of a window name resolver.
 */
class WindowResolver {
    /**
     * The resolved window name.
     *
     * #### Notes
     * If the `resolve` promise has not resolved, the behavior is undefined.
     */
    get name() {
        return this._name;
    }
    /**
     * Resolve a window name to use as a handle among shared resources.
     *
     * @param candidate - The potential window name being resolved.
     *
     * #### Notes
     * Typically, the name candidate should be a JupyterLab workspace name or
     * an empty string if there is no workspace.
     *
     * If the returned promise rejects, a window name cannot be resolved without
     * user intervention, which typically means navigation to a new URL.
     */
    resolve(candidate) {
        return Private.resolve(candidate).then(name => {
            this._name = name;
        });
    }
}
/*
 * A namespace for private module data.
 */
var Private;
(function (Private) {
    /**
     * The internal prefix for private local storage keys.
     */
    const PREFIX = '@jupyterlab/statedb:StateDB';
    /**
     * The local storage beacon key.
     */
    const BEACON = `${PREFIX}:beacon`;
    /**
     * The timeout (in ms) to wait for beacon responders.
     *
     * #### Notes
     * This value is a whole number between 200 and 500 in order to prevent
     * perfect timeout collisions between multiple simultaneously opening windows
     * that have the same URL. This is an edge case because multiple windows
     * should not ordinarily share the same URL, but it can be contrived.
     */
    const TIMEOUT = Math.floor(200 + Math.random() * 300);
    /**
     * The local storage window key.
     */
    const WINDOW = `${PREFIX}:window`;
    /**
     * Current beacon request
     *
     * #### Notes
     * We keep track of the current request so that we can ignore our own beacon
     * requests. This is to work around a bug in Safari, where Safari sometimes
     * triggers local storage events for changes made by the current tab. See
     * https://github.com/jupyterlab/jupyterlab/issues/6921#issuecomment-540817283
     * for more details.
     */
    let currentBeaconRequest = null;
    /**
     * A potential preferred default window name.
     */
    let candidate = null;
    /**
     * The window name promise.
     */
    const delegate = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.PromiseDelegate();
    /**
     * The known window names.
     */
    const known = {};
    /**
     * The window name.
     */
    let name = null;
    /**
     * Whether the name resolution has completed.
     */
    let resolved = false;
    /**
     * Start the storage event handler.
     */
    function initialize() {
        // Listen to all storage events for beacons and window names.
        window.addEventListener('storage', (event) => {
            const { key, newValue } = event;
            // All the keys we care about have values.
            if (newValue === null) {
                return;
            }
            // If the beacon was fired, respond with a ping.
            if (key === BEACON &&
                newValue !== currentBeaconRequest &&
                candidate !== null) {
                ping(resolved ? name : candidate);
                return;
            }
            // If the window name is resolved, bail.
            if (resolved || key !== WINDOW) {
                return;
            }
            const reported = newValue.replace(/\-\d+$/, '');
            // Store the reported window name.
            known[reported] = null;
            // If a reported window name and candidate collide, reject the candidate.
            if (!candidate || candidate in known) {
                reject();
            }
        });
    }
    /**
     * Ping peers with payload.
     */
    function ping(payload) {
        if (payload === null) {
            return;
        }
        const { localStorage } = window;
        localStorage.setItem(WINDOW, `${payload}-${new Date().getTime()}`);
    }
    /**
     * Reject the candidate.
     */
    function reject() {
        resolved = true;
        currentBeaconRequest = null;
        delegate.reject(`Window name candidate "${candidate}" already exists`);
    }
    /**
     * Returns a promise that resolves with the window name used for restoration.
     */
    function resolve(potential) {
        if (resolved) {
            return delegate.promise;
        }
        // Set the local candidate.
        candidate = potential;
        if (candidate in known) {
            reject();
            return delegate.promise;
        }
        const { localStorage, setTimeout } = window;
        // Wait until other windows have reported before claiming the candidate.
        setTimeout(() => {
            if (resolved) {
                return;
            }
            // If the window name has not already been resolved, check one last time
            // to confirm it is not a duplicate before resolving.
            if (!candidate || candidate in known) {
                return reject();
            }
            resolved = true;
            currentBeaconRequest = null;
            delegate.resolve((name = candidate));
            ping(name);
        }, TIMEOUT);
        // Fire the beacon to collect other windows' names.
        currentBeaconRequest = `${Math.random()}-${new Date().getTime()}`;
        localStorage.setItem(BEACON, currentBeaconRequest);
        return delegate.promise;
    }
    Private.resolve = resolve;
    // Initialize the storage listener at runtime.
    (() => {
        initialize();
    })();
})(Private || (Private = {}));
//# sourceMappingURL=windowresolver.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@jupyterlab/apputils/node_modules/@lumino/coreutils/dist/index.js ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
     true ? factory(exports) :
    0;
})(this, (function (exports) { 'use strict';

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for JSON-specific functions.
     */
    exports.JSONExt = void 0;
    (function (JSONExt) {
        /**
         * A shared frozen empty JSONObject
         */
        JSONExt.emptyObject = Object.freeze({});
        /**
         * A shared frozen empty JSONArray
         */
        JSONExt.emptyArray = Object.freeze([]);
        /**
         * Test whether a JSON value is a primitive.
         *
         * @param value - The JSON value of interest.
         *
         * @returns `true` if the value is a primitive,`false` otherwise.
         */
        function isPrimitive(value) {
            return (value === null ||
                typeof value === 'boolean' ||
                typeof value === 'number' ||
                typeof value === 'string');
        }
        JSONExt.isPrimitive = isPrimitive;
        function isArray(value) {
            return Array.isArray(value);
        }
        JSONExt.isArray = isArray;
        function isObject(value) {
            return !isPrimitive(value) && !isArray(value);
        }
        JSONExt.isObject = isObject;
        /**
         * Compare two JSON values for deep equality.
         *
         * @param first - The first JSON value of interest.
         *
         * @param second - The second JSON value of interest.
         *
         * @returns `true` if the values are equivalent, `false` otherwise.
         */
        function deepEqual(first, second) {
            // Check referential and primitive equality first.
            if (first === second) {
                return true;
            }
            // If one is a primitive, the `===` check ruled out the other.
            if (isPrimitive(first) || isPrimitive(second)) {
                return false;
            }
            // Test whether they are arrays.
            let a1 = isArray(first);
            let a2 = isArray(second);
            // Bail if the types are different.
            if (a1 !== a2) {
                return false;
            }
            // If they are both arrays, compare them.
            if (a1 && a2) {
                return deepArrayEqual(first, second);
            }
            // At this point, they must both be objects.
            return deepObjectEqual(first, second);
        }
        JSONExt.deepEqual = deepEqual;
        /**
         * Create a deep copy of a JSON value.
         *
         * @param value - The JSON value to copy.
         *
         * @returns A deep copy of the given JSON value.
         */
        function deepCopy(value) {
            // Do nothing for primitive values.
            if (isPrimitive(value)) {
                return value;
            }
            // Deep copy an array.
            if (isArray(value)) {
                return deepArrayCopy(value);
            }
            // Deep copy an object.
            return deepObjectCopy(value);
        }
        JSONExt.deepCopy = deepCopy;
        /**
         * Compare two JSON arrays for deep equality.
         */
        function deepArrayEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Test the arrays for equal length.
            if (first.length !== second.length) {
                return false;
            }
            // Compare the values for equality.
            for (let i = 0, n = first.length; i < n; ++i) {
                if (!deepEqual(first[i], second[i])) {
                    return false;
                }
            }
            // At this point, the arrays are equal.
            return true;
        }
        /**
         * Compare two JSON objects for deep equality.
         */
        function deepObjectEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Check for the first object's keys in the second object.
            for (let key in first) {
                if (first[key] !== undefined && !(key in second)) {
                    return false;
                }
            }
            // Check for the second object's keys in the first object.
            for (let key in second) {
                if (second[key] !== undefined && !(key in first)) {
                    return false;
                }
            }
            // Compare the values for equality.
            for (let key in first) {
                // Get the values.
                let firstValue = first[key];
                let secondValue = second[key];
                // If both are undefined, ignore the key.
                if (firstValue === undefined && secondValue === undefined) {
                    continue;
                }
                // If only one value is undefined, the objects are not equal.
                if (firstValue === undefined || secondValue === undefined) {
                    return false;
                }
                // Compare the values.
                if (!deepEqual(firstValue, secondValue)) {
                    return false;
                }
            }
            // At this point, the objects are equal.
            return true;
        }
        /**
         * Create a deep copy of a JSON array.
         */
        function deepArrayCopy(value) {
            let result = new Array(value.length);
            for (let i = 0, n = value.length; i < n; ++i) {
                result[i] = deepCopy(value[i]);
            }
            return result;
        }
        /**
         * Create a deep copy of a JSON object.
         */
        function deepObjectCopy(value) {
            let result = {};
            for (let key in value) {
                // Ignore undefined values.
                let subvalue = value[key];
                if (subvalue === undefined) {
                    continue;
                }
                result[key] = deepCopy(subvalue);
            }
            return result;
        }
    })(exports.JSONExt || (exports.JSONExt = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * An object which stores MIME data for general application use.
     *
     * #### Notes
     * This class does not attempt to enforce "correctness" of MIME types
     * and their associated data. Since this class is designed to transfer
     * arbitrary data and objects within the same application, it assumes
     * that the user provides correct and accurate data.
     */
    class MimeData {
        constructor() {
            this._types = [];
            this._values = [];
        }
        /**
         * Get an array of the MIME types contained within the dataset.
         *
         * @returns A new array of the MIME types, in order of insertion.
         */
        types() {
            return this._types.slice();
        }
        /**
         * Test whether the dataset has an entry for the given type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns `true` if the dataset contains a value for the given
         *   MIME type, `false` otherwise.
         */
        hasData(mime) {
            return this._types.indexOf(mime) !== -1;
        }
        /**
         * Get the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns The value for the given MIME type, or `undefined` if
         *   the dataset does not contain a value for the type.
         */
        getData(mime) {
            let i = this._types.indexOf(mime);
            return i !== -1 ? this._values[i] : undefined;
        }
        /**
         * Set the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @param data - The data value for the given MIME type.
         *
         * #### Notes
         * This will overwrite any previous entry for the MIME type.
         */
        setData(mime, data) {
            this.clearData(mime);
            this._types.push(mime);
            this._values.push(data);
        }
        /**
         * Remove the data entry for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * #### Notes
         * This is a no-op if there is no entry for the given MIME type.
         */
        clearData(mime) {
            let i = this._types.indexOf(mime);
            if (i !== -1) {
                this._types.splice(i, 1);
                this._values.splice(i, 1);
            }
        }
        /**
         * Remove all data entries from the dataset.
         */
        clear() {
            this._types.length = 0;
            this._values.length = 0;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A class which wraps a promise into a delegate object.
     *
     * #### Notes
     * This class is useful when the logic to resolve or reject a promise
     * cannot be defined at the point where the promise is created.
     */
    class PromiseDelegate {
        /**
         * Construct a new promise delegate.
         */
        constructor() {
            this.promise = new Promise((resolve, reject) => {
                this._resolve = resolve;
                this._reject = reject;
            });
        }
        /**
         * Resolve the wrapped promise with the given value.
         *
         * @param value - The value to use for resolving the promise.
         */
        resolve(value) {
            let resolve = this._resolve;
            resolve(value);
        }
        /**
         * Reject the wrapped promise with the given value.
         *
         * @reason - The reason for rejecting the promise.
         */
        reject(reason) {
            let reject = this._reject;
            reject(reason);
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A runtime object which captures compile-time type information.
     *
     * #### Notes
     * A token captures the compile-time type of an interface or class in
     * an object which can be used at runtime in a type-safe fashion.
     */
    class Token {
        /**
         * Construct a new token.
         *
         * @param name - A human readable name for the token.
         * @param description - Token purpose description for documentation.
         */
        constructor(name, description) {
            this.name = name;
            this.description = description !== null && description !== void 0 ? description : '';
            this._tokenStructuralPropertyT = null;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    // Fallback
    function fallbackRandomValues(buffer) {
        let value = 0;
        for (let i = 0, n = buffer.length; i < n; ++i) {
            if (i % 4 === 0) {
                value = (Math.random() * 0xffffffff) >>> 0;
            }
            buffer[i] = value & 0xff;
            value >>>= 8;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for random number related functionality.
     */
    exports.Random = void 0;
    (function (Random) {
        /**
         * A function which generates random bytes.
         *
         * @param buffer - The `Uint8Array` to fill with random bytes.
         *
         * #### Notes
         * A cryptographically strong random number generator will be used if
         * available. Otherwise, `Math.random` will be used as a fallback for
         * randomness.
         *
         * The following RNGs are supported, listed in order of precedence:
         *   - `window.crypto.getRandomValues`
         *   - `window.msCrypto.getRandomValues`
         *   - `require('crypto').randomFillSync
         *   - `require('crypto').randomBytes
         *   - `Math.random`
         */
        Random.getRandomValues = (() => {
            // Look up the crypto module if available.
            const crypto = (typeof window !== 'undefined' && (window.crypto || window.msCrypto)) ||
                null;
            // Modern browsers and IE 11
            if (crypto && typeof crypto.getRandomValues === 'function') {
                return function getRandomValues(buffer) {
                    return crypto.getRandomValues(buffer);
                };
            }
            // Fallback
            return fallbackRandomValues;
        })();
    })(exports.Random || (exports.Random = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A function which creates a function that generates UUID v4 identifiers.
     *
     * @returns A new function that creates a UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    function uuid4Factory(getRandomValues) {
        // Create a 16 byte array to hold the random values.
        const bytes = new Uint8Array(16);
        // Create a look up table from bytes to hex strings.
        const lut = new Array(256);
        // Pad the single character hex digits with a leading zero.
        for (let i = 0; i < 16; ++i) {
            lut[i] = '0' + i.toString(16);
        }
        // Populate the rest of the hex digits.
        for (let i = 16; i < 256; ++i) {
            lut[i] = i.toString(16);
        }
        // Return a function which generates the UUID.
        return function uuid4() {
            // Get a new batch of random values.
            getRandomValues(bytes);
            // Set the UUID version number to 4.
            bytes[6] = 0x40 | (bytes[6] & 0x0f);
            // Set the clock sequence bit to the RFC spec.
            bytes[8] = 0x80 | (bytes[8] & 0x3f);
            // Assemble the UUID string.
            return (lut[bytes[0]] +
                lut[bytes[1]] +
                lut[bytes[2]] +
                lut[bytes[3]] +
                '-' +
                lut[bytes[4]] +
                lut[bytes[5]] +
                '-' +
                lut[bytes[6]] +
                lut[bytes[7]] +
                '-' +
                lut[bytes[8]] +
                lut[bytes[9]] +
                '-' +
                lut[bytes[10]] +
                lut[bytes[11]] +
                lut[bytes[12]] +
                lut[bytes[13]] +
                lut[bytes[14]] +
                lut[bytes[15]]);
        };
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for UUID related functionality.
     */
    exports.UUID = void 0;
    (function (UUID) {
        /**
         * A function which generates UUID v4 identifiers.
         *
         * @returns A new UUID v4 string.
         *
         * #### Notes
         * This implementation complies with RFC 4122.
         *
         * This uses `Random.getRandomValues()` for random bytes, which in
         * turn will use the underlying `crypto` module of the platform if
         * it is available. The fallback for randomness is `Math.random`.
         */
        UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
    })(exports.UUID || (exports.UUID = {}));

    exports.MimeData = MimeData;
    exports.PromiseDelegate = PromiseDelegate;
    exports.Token = Token;

}));
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@jupyterlab/attachments/lib/model.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/attachments/lib/model.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AttachmentsModel: () => (/* binding */ AttachmentsModel),
/* harmony export */   AttachmentsResolver: () => (/* binding */ AttachmentsResolver)
/* harmony export */ });
/* harmony import */ var _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/observables */ "./node_modules/@jupyterlab/observables/lib/observablemap.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/rendermime */ "./node_modules/@jupyterlab/rendermime/lib/attachmentmodel.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/rendermime */ "./node_modules/@jupyterlab/rendermime/lib/factories.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * The default implementation of the IAttachmentsModel.
 */
class AttachmentsModel {
    /**
     * Construct a new observable outputs instance.
     */
    constructor(options) {
        var _a;
        this._map = new _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_1__.ObservableMap();
        this._isDisposed = false;
        this._stateChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._changed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._serialized = null;
        this._changeGuard = false;
        this.contentFactory =
            (_a = options.contentFactory) !== null && _a !== void 0 ? _a : AttachmentsModel.defaultContentFactory;
        if (options.values) {
            for (const key of Object.keys(options.values)) {
                if (options.values[key] !== undefined) {
                    this.set(key, options.values[key]);
                }
            }
        }
        this._map.changed.connect(this._onMapChanged, this);
    }
    /**
     * A signal emitted when the model state changes.
     */
    get stateChanged() {
        return this._stateChanged;
    }
    /**
     * A signal emitted when the model changes.
     */
    get changed() {
        return this._changed;
    }
    /**
     * The keys of the attachments in the model.
     */
    get keys() {
        return this._map.keys();
    }
    /**
     * Get the length of the items in the model.
     */
    get length() {
        return this._map.keys().length;
    }
    /**
     * Test whether the model is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._map.dispose();
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
    }
    /**
     * Whether the specified key is set.
     */
    has(key) {
        return this._map.has(key);
    }
    /**
     * Get an item at the specified key.
     */
    get(key) {
        return this._map.get(key);
    }
    /**
     * Set the value at the specified key.
     */
    set(key, value) {
        // Normalize stream data.
        const item = this._createItem({ value });
        this._map.set(key, item);
    }
    /**
     * Remove the attachment whose name is the specified key
     */
    remove(key) {
        this._map.delete(key);
    }
    /**
     * Clear all of the attachments.
     */
    clear() {
        this._map.values().forEach((item) => {
            item.dispose();
        });
        this._map.clear();
    }
    /**
     * Deserialize the model from JSON.
     *
     * #### Notes
     * This will clear any existing data.
     */
    fromJSON(values) {
        this.clear();
        Object.keys(values).forEach(key => {
            if (values[key] !== undefined) {
                this.set(key, values[key]);
            }
        });
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        const ret = {};
        for (const key of this._map.keys()) {
            ret[key] = this._map.get(key).toJSON();
        }
        return ret;
    }
    /**
     * Create an attachment item and hook up its signals.
     */
    _createItem(options) {
        const factory = this.contentFactory;
        const item = factory.createAttachmentModel(options);
        item.changed.connect(this._onGenericChange, this);
        return item;
    }
    /**
     * Handle a change to the list.
     */
    _onMapChanged(sender, args) {
        if (this._serialized && !this._changeGuard) {
            this._changeGuard = true;
            this._serialized.set(this.toJSON());
            this._changeGuard = false;
        }
        this._changed.emit(args);
        this._stateChanged.emit(void 0);
    }
    /**
     * Handle a change to an item.
     */
    _onGenericChange() {
        this._stateChanged.emit(void 0);
    }
}
/**
 * The namespace for AttachmentsModel class statics.
 */
(function (AttachmentsModel) {
    /**
     * The default implementation of a `IAttachmentsModel.IContentFactory`.
     */
    class ContentFactory {
        /**
         * Create an attachment model.
         */
        createAttachmentModel(options) {
            return new _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_2__.AttachmentModel(options);
        }
    }
    AttachmentsModel.ContentFactory = ContentFactory;
    /**
     * The default attachment model factory.
     */
    AttachmentsModel.defaultContentFactory = new ContentFactory();
})(AttachmentsModel || (AttachmentsModel = {}));
/**
 * A resolver for cell attachments 'attachment:filename'.
 *
 * Will resolve to a data: url.
 */
class AttachmentsResolver {
    /**
     * Create an attachments resolver object.
     */
    constructor(options) {
        this._parent = options.parent || null;
        this._model = options.model;
    }
    /**
     * Resolve a relative url to a correct server path.
     */
    async resolveUrl(url) {
        if (this._parent && !url.startsWith('attachment:')) {
            return this._parent.resolveUrl(url);
        }
        return url;
    }
    /**
     * Get the download url of a given absolute server path.
     *
     * #### Notes
     * The returned URL may include a query parameter.
     */
    async getDownloadUrl(path) {
        if (this._parent && !path.startsWith('attachment:')) {
            return this._parent.getDownloadUrl(path);
        }
        // Return a data URL with the data of the url
        const key = path.slice('attachment:'.length);
        const attachment = this._model.get(key);
        if (attachment === undefined) {
            // Resolve with unprocessed path, to show as broken image
            return path;
        }
        const { data } = attachment;
        const mimeType = Object.keys(data)[0];
        // Only support known safe types:
        if (mimeType === undefined ||
            _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_3__.imageRendererFactory.mimeTypes.indexOf(mimeType) === -1) {
            throw new Error(`Cannot render unknown image mime type "${mimeType}".`);
        }
        const dataUrl = `data:${mimeType};base64,${data[mimeType]}`;
        return dataUrl;
    }
    /**
     * Whether the URL should be handled by the resolver
     * or not.
     */
    isLocal(url) {
        var _a, _b, _c;
        if (this._parent && !url.startsWith('attachment:')) {
            return (_c = (_b = (_a = this._parent).isLocal) === null || _b === void 0 ? void 0 : _b.call(_a, url)) !== null && _c !== void 0 ? _c : true;
        }
        return true;
    }
}
//# sourceMappingURL=model.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/collapser.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/collapser.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Collapser: () => (/* binding */ Collapser),
/* harmony export */   InputCollapser: () => (/* binding */ InputCollapser),
/* harmony export */   OutputCollapser: () => (/* binding */ OutputCollapser)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/components/vdom.js");
/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/domutils */ "./node_modules/@lumino/domutils/dist/index.es6.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "./node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * The CSS class added to all collapsers.
 */
const COLLAPSER_CLASS = 'jp-Collapser';
/**
 * The CSS class added to the collapser child.
 */
const COLLAPSER_CHILD_CLASS = 'jp-Collapser-child';
/**
 * The CSS class added to input collapsers.
 */
const INPUT_COLLAPSER = 'jp-InputCollapser';
/**
 * The CSS class added to output collapsers.
 */
const OUTPUT_COLLAPSER = 'jp-OutputCollapser';
/**
 * Abstract collapser base class.
 *
 * ### Notes
 * A collapser is a visible div to the left of a cell's
 * input/output that a user can click on to collapse the
 * input/output.
 */
class Collapser extends _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.ReactWidget {
    /**
     * Construct a new collapser.
     */
    constructor() {
        super();
        this.addClass(COLLAPSER_CLASS);
    }
    /**
     * Is the input/output of the parent collapsed.
     */
    get collapsed() {
        return false;
    }
    /**
     * Render the collapser with the virtual DOM.
     */
    render() {
        const childClass = COLLAPSER_CHILD_CLASS;
        return react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { className: childClass, onClick: e => this.handleClick(e) });
    }
}
/**
 * A collapser subclass to collapse a cell's input area.
 */
class InputCollapser extends Collapser {
    /**
     * Construct a new input collapser.
     */
    constructor() {
        super();
        this.addClass(INPUT_COLLAPSER);
    }
    /**
     * Is the cell's input collapsed?
     */
    get collapsed() {
        var _a;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            return cell.inputHidden;
        }
        else {
            return false;
        }
    }
    /**
     * Handle a click event for the user to collapse the cell's input.
     */
    handleClick(e) {
        var _a;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            cell.inputHidden = !cell.inputHidden;
        }
        /* We need this until we watch the cell state */
        this.update();
    }
}
/**
 * A collapser subclass to collapse a cell's output area.
 */
class OutputCollapser extends Collapser {
    /**
     * Construct a new output collapser.
     */
    constructor() {
        super();
        this.addClass(OUTPUT_COLLAPSER);
    }
    /**
     * Is the cell's output collapsed?
     */
    get collapsed() {
        var _a;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            return cell.outputHidden;
        }
        else {
            return false;
        }
    }
    /**
     * Handle a click event for the user to collapse the cell's output.
     */
    handleClick(e) {
        var _a, _b;
        const cell = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent;
        if (cell) {
            cell.outputHidden = !cell.outputHidden;
            /* Scroll cell into view after output collapse */
            if (cell.outputHidden) {
                let area = (_b = cell.parent) === null || _b === void 0 ? void 0 : _b.node;
                if (area) {
                    _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.ElementExt.scrollIntoViewIfNeeded(area, cell.node);
                }
            }
        }
        /* We need this until we watch the cell state */
        this.update();
    }
}
//# sourceMappingURL=collapser.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/headerfooter.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/headerfooter.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CellFooter: () => (/* binding */ CellFooter),
/* harmony export */   CellHeader: () => (/* binding */ CellHeader)
/* harmony export */ });
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/

/**
 * The CSS class added to the cell header.
 */
const CELL_HEADER_CLASS = 'jp-CellHeader';
/**
 * The CSS class added to the cell footer.
 */
const CELL_FOOTER_CLASS = 'jp-CellFooter';
/**
 * Default implementation of a cell header.
 */
class CellHeader extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    /**
     * Construct a new cell header.
     */
    constructor() {
        super();
        this.addClass(CELL_HEADER_CLASS);
    }
}
/**
 * Default implementation of a cell footer.
 */
class CellFooter extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    /**
     * Construct a new cell footer.
     */
    constructor() {
        super();
        this.addClass(CELL_FOOTER_CLASS);
    }
}
//# sourceMappingURL=headerfooter.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/inputarea.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/inputarea.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InputArea: () => (/* binding */ InputArea),
/* harmony export */   InputPrompt: () => (/* binding */ InputPrompt)
/* harmony export */ });
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/codeeditor */ "./node_modules/@jupyterlab/codeeditor/lib/widget.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * The class name added to input area widgets.
 */
const INPUT_AREA_CLASS = 'jp-InputArea';
/**
 * The class name added to the prompt area of cell.
 */
const INPUT_AREA_PROMPT_CLASS = 'jp-InputArea-prompt';
/**
 * The class name added to OutputPrompt.
 */
const INPUT_PROMPT_CLASS = 'jp-InputPrompt';
/**
 * The class name added to the editor area of the cell.
 */
const INPUT_AREA_EDITOR_CLASS = 'jp-InputArea-editor';
/** ****************************************************************************
 * InputArea
 ******************************************************************************/
/**
 * An input area widget, which hosts a prompt and an editor widget.
 */
class InputArea extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    /**
     * Construct an input area widget.
     */
    constructor(options) {
        super();
        this.addClass(INPUT_AREA_CLASS);
        const { contentFactory, editorOptions, model } = options;
        this.model = model;
        this.contentFactory = contentFactory;
        // Prompt
        const prompt = (this._prompt = contentFactory.createInputPrompt());
        prompt.addClass(INPUT_AREA_PROMPT_CLASS);
        // Editor
        const editor = (this._editor = new _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_1__.CodeEditorWrapper({
            factory: contentFactory.editorFactory,
            model,
            editorOptions
        }));
        editor.addClass(INPUT_AREA_EDITOR_CLASS);
        const layout = (this.layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.PanelLayout());
        layout.addWidget(prompt);
        layout.addWidget(editor);
    }
    /**
     * Get the CodeEditorWrapper used by the cell.
     */
    get editorWidget() {
        return this._editor;
    }
    /**
     * Get the CodeEditor used by the cell.
     */
    get editor() {
        return this._editor.editor;
    }
    /**
     * Get the prompt node used by the cell.
     */
    get promptNode() {
        return this._prompt.node;
    }
    /**
     * Get the rendered input area widget, if any.
     */
    get renderedInput() {
        return this._rendered;
    }
    /**
     * Render an input instead of the text editor.
     */
    renderInput(widget) {
        const layout = this.layout;
        if (this._rendered) {
            this._rendered.parent = null;
        }
        this._editor.hide();
        this._rendered = widget;
        layout.addWidget(widget);
    }
    /**
     * Show the text editor.
     */
    showEditor() {
        if (this._rendered) {
            this._rendered.parent = null;
        }
        this._editor.show();
    }
    /**
     * Set the prompt of the input area.
     */
    setPrompt(value) {
        this._prompt.executionCount = value;
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        // Do nothing if already disposed.
        if (this.isDisposed) {
            return;
        }
        this._prompt = null;
        this._editor = null;
        this._rendered = null;
        super.dispose();
    }
}
/**
 * A namespace for `InputArea` statics.
 */
(function (InputArea) {
    /**
     * Default implementation of `IContentFactory`.
     *
     * This defaults to using an `editorFactory` based on CodeMirror.
     */
    class ContentFactory {
        /**
         * Construct a `ContentFactory`.
         */
        constructor(options) {
            this._editor = options.editorFactory;
        }
        /**
         * Return the `CodeEditor.Factory` being used.
         */
        get editorFactory() {
            return this._editor;
        }
        /**
         * Create an input prompt.
         */
        createInputPrompt() {
            return new InputPrompt();
        }
    }
    InputArea.ContentFactory = ContentFactory;
})(InputArea || (InputArea = {}));
/**
 * The default input prompt implementation.
 */
class InputPrompt extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    /*
     * Create an output prompt widget.
     */
    constructor() {
        super();
        this._executionCount = null;
        this.addClass(INPUT_PROMPT_CLASS);
    }
    /**
     * The execution count for the prompt.
     */
    get executionCount() {
        return this._executionCount;
    }
    set executionCount(value) {
        this._executionCount = value;
        if (value === null) {
            this.node.textContent = ' ';
        }
        else {
            this.node.textContent = `[${value || ' '}]:`;
        }
    }
}
//# sourceMappingURL=inputarea.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/model.js":
/*!*****************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/model.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AttachmentsCellModel: () => (/* binding */ AttachmentsCellModel),
/* harmony export */   CellModel: () => (/* binding */ CellModel),
/* harmony export */   CodeCellModel: () => (/* binding */ CodeCellModel),
/* harmony export */   MarkdownCellModel: () => (/* binding */ MarkdownCellModel),
/* harmony export */   RawCellModel: () => (/* binding */ RawCellModel),
/* harmony export */   isCodeCellModel: () => (/* binding */ isCodeCellModel),
/* harmony export */   isMarkdownCellModel: () => (/* binding */ isMarkdownCellModel),
/* harmony export */   isRawCellModel: () => (/* binding */ isRawCellModel)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _jupyterlab_attachments__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/attachments */ "./node_modules/@jupyterlab/attachments/lib/model.js");
/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/codeeditor */ "./node_modules/@jupyterlab/codeeditor/lib/editor.js");
/* harmony import */ var _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/outputarea */ "./node_modules/@jupyterlab/outputarea/lib/model.js");
/* harmony import */ var _jupyter_ydoc__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyter/ydoc */ "./node_modules/@jupyter/ydoc/lib/index.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/





const globalModelDBMutex = (0,_jupyter_ydoc__WEBPACK_IMPORTED_MODULE_1__.createMutex)();
function isCodeCellModel(model) {
    return model.type === 'code';
}
function isMarkdownCellModel(model) {
    return model.type === 'markdown';
}
function isRawCellModel(model) {
    return model.type === 'raw';
}
/**
 * An implementation of the cell model.
 */
class CellModel extends _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_2__.CodeEditor.Model {
    constructor(options = {}) {
        const { cell_type, sharedModel, ...others } = options;
        super({
            sharedModel: sharedModel !== null && sharedModel !== void 0 ? sharedModel : (0,_jupyter_ydoc__WEBPACK_IMPORTED_MODULE_1__.createStandaloneCell)({
                cell_type: cell_type !== null && cell_type !== void 0 ? cell_type : 'raw',
                id: options.id
            }),
            ...others
        });
        /**
         * A signal emitted when the state of the model changes.
         */
        this.contentChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        /**
         * A signal emitted when a model state changes.
         */
        this.stateChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._metadataChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
        this._trusted = false;
        this.standaloneModel = typeof options.sharedModel === 'undefined';
        this.trusted = !!this.getMetadata('trusted') || !!options.trusted;
        this.sharedModel.changed.connect(this.onGenericChange, this);
        this.sharedModel.metadataChanged.connect(this._onMetadataChanged, this);
    }
    /**
     * Signal emitted when cell metadata changes.
     */
    get metadataChanged() {
        return this._metadataChanged;
    }
    /**
     * The id for the cell.
     */
    get id() {
        return this.sharedModel.getId();
    }
    /**
     * The metadata associated with the cell.
     */
    get metadata() {
        return this.sharedModel.metadata;
    }
    /**
     * The trusted state of the model.
     */
    get trusted() {
        return this._trusted;
    }
    set trusted(newValue) {
        const oldValue = this.trusted;
        if (oldValue !== newValue) {
            this._trusted = newValue;
            this.onTrustedChanged(this, { newValue, oldValue });
        }
    }
    /**
     * Dispose of the resources held by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.sharedModel.changed.disconnect(this.onGenericChange, this);
        this.sharedModel.metadataChanged.disconnect(this._onMetadataChanged, this);
        super.dispose();
    }
    /**
     * Handle a change to the trusted state.
     *
     * The default implementation is a no-op.
     */
    onTrustedChanged(trusted, args) {
        /* no-op */
    }
    /**
     * Delete a metadata
     *
     * @param key Metadata key
     */
    deleteMetadata(key) {
        return this.sharedModel.deleteMetadata(key);
    }
    /**
     * Get a metadata
     *
     * ### Notes
     * This returns a copy of the key value.
     *
     * @param key Metadata key
     */
    getMetadata(key) {
        return this.sharedModel.getMetadata(key);
    }
    /**
     * Set a metadata
     *
     * @param key Metadata key
     * @param value Metadata value
     */
    setMetadata(key, value) {
        if (typeof value === 'undefined') {
            this.sharedModel.deleteMetadata(key);
        }
        else {
            this.sharedModel.setMetadata(key, value);
        }
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return this.sharedModel.toJSON();
    }
    /**
     * Handle a change to the observable value.
     */
    onGenericChange() {
        this.contentChanged.emit(void 0);
    }
    _onMetadataChanged(sender, change) {
        this._metadataChanged.emit(change);
    }
}
/**
 * A base implementation for cell models with attachments.
 */
class AttachmentsCellModel extends CellModel {
    /**
     * Construct a new cell with optional attachments.
     */
    constructor(options) {
        var _a;
        super(options);
        const factory = (_a = options.contentFactory) !== null && _a !== void 0 ? _a : AttachmentsCellModel.defaultContentFactory;
        const values = this.sharedModel.getAttachments();
        this._attachments = factory.createAttachmentsModel({ values });
        this._attachments.stateChanged.connect(this.onGenericChange, this);
        this._attachments.changed.connect(this._onAttachmentsChange, this);
        this.sharedModel.changed.connect(this._onSharedModelChanged, this);
    }
    /**
     * Get the attachments of the model.
     */
    get attachments() {
        return this._attachments;
    }
    /**
     * Dispose of the resources held by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._attachments.stateChanged.disconnect(this.onGenericChange, this);
        this._attachments.changed.disconnect(this._onAttachmentsChange, this);
        this._attachments.dispose();
        this.sharedModel.changed.disconnect(this._onSharedModelChanged, this);
        super.dispose();
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
    /**
     * Handle a change to the cell outputs modelDB and reflect it in the shared model.
     */
    _onAttachmentsChange(sender, event) {
        const cell = this.sharedModel;
        globalModelDBMutex(() => cell.setAttachments(sender.toJSON()));
    }
    /**
     * Handle a change to the code cell value.
     */
    _onSharedModelChanged(slot, change) {
        if (change.attachmentsChange) {
            const cell = this.sharedModel;
            globalModelDBMutex(() => { var _a; return this._attachments.fromJSON((_a = cell.getAttachments()) !== null && _a !== void 0 ? _a : {}); });
        }
    }
}
/**
 * The namespace for `AttachmentsCellModel` statics.
 */
(function (AttachmentsCellModel) {
    /**
     * The default implementation of an `IContentFactory`.
     */
    class ContentFactory {
        /**
         * Create an attachments model.
         */
        createAttachmentsModel(options) {
            return new _jupyterlab_attachments__WEBPACK_IMPORTED_MODULE_3__.AttachmentsModel(options);
        }
    }
    AttachmentsCellModel.ContentFactory = ContentFactory;
    /**
     * The shared `ContentFactory` instance.
     */
    AttachmentsCellModel.defaultContentFactory = new ContentFactory();
})(AttachmentsCellModel || (AttachmentsCellModel = {}));
/**
 * An implementation of a raw cell model.
 */
class RawCellModel extends AttachmentsCellModel {
    /**
     * Construct a raw cell model from optional shared model.
     */
    constructor(options = {}) {
        super({
            cell_type: 'raw',
            ...options
        });
    }
    /**
     * The type of the cell.
     */
    get type() {
        return 'raw';
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
}
/**
 * An implementation of a markdown cell model.
 */
class MarkdownCellModel extends AttachmentsCellModel {
    /**
     * Construct a markdown cell model from optional shared model.
     */
    constructor(options = {}) {
        super({
            cell_type: 'markdown',
            ...options
        });
        // Use the Github-flavored markdown mode.
        this.mimeType = 'text/x-ipythongfm';
    }
    /**
     * The type of the cell.
     */
    get type() {
        return 'markdown';
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
}
/**
 * An implementation of a code cell Model.
 */
class CodeCellModel extends CellModel {
    /**
     * Construct a new code cell with optional original cell content.
     */
    constructor(options = {}) {
        var _a;
        super({
            cell_type: 'code',
            ...options
        });
        this._executedCode = '';
        this._isDirty = false;
        const factory = (_a = options === null || options === void 0 ? void 0 : options.contentFactory) !== null && _a !== void 0 ? _a : CodeCellModel.defaultContentFactory;
        const trusted = this.trusted;
        const outputs = this.sharedModel.getOutputs();
        this._outputs = factory.createOutputArea({ trusted, values: outputs });
        this.sharedModel.changed.connect(this._onSharedModelChanged, this);
        this._outputs.changed.connect(this.onGenericChange, this);
        this._outputs.changed.connect(this.onOutputsChange, this);
    }
    /**
     * The type of the cell.
     */
    get type() {
        return 'code';
    }
    /**
     * The execution count of the cell.
     */
    get executionCount() {
        return this.sharedModel.execution_count || null;
    }
    set executionCount(newValue) {
        this.sharedModel.execution_count = newValue || null;
    }
    /**
     * Whether the cell is dirty or not.
     *
     * A cell is dirty if it is output is not empty and does not
     * result of the input code execution.
     */
    get isDirty() {
        // Test could be done dynamically with this._executedCode
        // but for performance reason, the diff status is stored in a boolean.
        return this._isDirty;
    }
    /**
     * The cell outputs.
     */
    get outputs() {
        return this._outputs;
    }
    clearExecution() {
        this.outputs.clear();
        this.executionCount = null;
        this._setDirty(false);
        this.sharedModel.deleteMetadata('execution');
        // We trust this cell as it no longer has any outputs.
        this.trusted = true;
    }
    /**
     * Dispose of the resources held by the model.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.sharedModel.changed.disconnect(this._onSharedModelChanged, this);
        this._outputs.changed.disconnect(this.onGenericChange, this);
        this._outputs.changed.disconnect(this.onOutputsChange, this);
        this._outputs.dispose();
        this._outputs = null;
        super.dispose();
    }
    /**
     * Handle a change to the trusted state.
     */
    onTrustedChanged(trusted, args) {
        const newTrusted = args.newValue;
        if (this._outputs) {
            this._outputs.trusted = newTrusted;
        }
        if (newTrusted) {
            const codeCell = this.sharedModel;
            const metadata = codeCell.getMetadata();
            metadata.trusted = true;
            codeCell.setMetadata(metadata);
        }
        this.stateChanged.emit({
            name: 'trusted',
            oldValue: args.oldValue,
            newValue: newTrusted
        });
    }
    /**
     * Serialize the model to JSON.
     */
    toJSON() {
        return super.toJSON();
    }
    /**
     * Handle a change to the cell outputs modelDB and reflect it in the shared model.
     */
    onOutputsChange(sender, event) {
        const codeCell = this.sharedModel;
        globalModelDBMutex(() => {
            switch (event.type) {
                case 'add': {
                    const outputs = event.newValues.map(output => output.toJSON());
                    codeCell.updateOutputs(event.newIndex, event.newIndex, outputs);
                    break;
                }
                case 'set': {
                    const newValues = event.newValues.map(output => output.toJSON());
                    codeCell.updateOutputs(event.oldIndex, event.oldIndex + newValues.length, newValues);
                    break;
                }
                case 'remove':
                    codeCell.updateOutputs(event.oldIndex, event.oldValues.length);
                    break;
                default:
                    throw new Error(`Invalid event type: ${event.type}`);
            }
        });
    }
    /**
     * Handle a change to the code cell value.
     */
    _onSharedModelChanged(slot, change) {
        if (change.outputsChange) {
            globalModelDBMutex(() => {
                this.outputs.clear();
                slot.getOutputs().forEach(output => this._outputs.add(output));
            });
        }
        if (change.executionCountChange) {
            if (change.executionCountChange.newValue &&
                (this.isDirty || !change.executionCountChange.oldValue)) {
                this._setDirty(false);
            }
            this.stateChanged.emit({
                name: 'executionCount',
                oldValue: change.executionCountChange.oldValue,
                newValue: change.executionCountChange.newValue
            });
        }
        if (change.sourceChange && this.executionCount !== null) {
            this._setDirty(this._executedCode !== this.sharedModel.getSource().trim());
        }
    }
    /**
     * Set whether the cell is dirty or not.
     */
    _setDirty(v) {
        if (!v) {
            this._executedCode = this.sharedModel.getSource().trim();
        }
        if (v !== this._isDirty) {
            this._isDirty = v;
            this.stateChanged.emit({
                name: 'isDirty',
                oldValue: !v,
                newValue: v
            });
        }
    }
}
/**
 * The namespace for `CodeCellModel` statics.
 */
(function (CodeCellModel) {
    /**
     * The default implementation of an `IContentFactory`.
     */
    class ContentFactory {
        /**
         * Create an output area.
         */
        createOutputArea(options) {
            return new _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_4__.OutputAreaModel(options);
        }
    }
    CodeCellModel.ContentFactory = ContentFactory;
    /**
     * The shared `ContentFactory` instance.
     */
    CodeCellModel.defaultContentFactory = new ContentFactory();
})(CodeCellModel || (CodeCellModel = {}));
//# sourceMappingURL=model.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/placeholder.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/placeholder.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   InputPlaceholder: () => (/* binding */ InputPlaceholder),
/* harmony export */   OutputPlaceholder: () => (/* binding */ OutputPlaceholder),
/* harmony export */   Placeholder: () => (/* binding */ Placeholder)
/* harmony export */ });
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



/**
 * The CSS class added to placeholders.
 */
const PLACEHOLDER_CLASS = 'jp-Placeholder';
/**
 * The CSS classes added to input placeholder prompts.
 */
const INPUT_PROMPT_CLASS = 'jp-Placeholder-prompt jp-InputPrompt';
/**
 * The CSS classes added to output placeholder prompts.
 */
const OUTPUT_PROMPT_CLASS = 'jp-Placeholder-prompt jp-OutputPrompt';
/**
 * The CSS class added to placeholder content.
 */
const CONTENT_CLASS = 'jp-Placeholder-content';
/**
 * The CSS class added to input placeholders.
 */
const INPUT_PLACEHOLDER_CLASS = 'jp-InputPlaceholder';
/**
 * The CSS class added to output placeholders.
 */
const OUTPUT_PLACEHOLDER_CLASS = 'jp-OutputPlaceholder';
/**
 * An base class for placeholders
 *
 * ### Notes
 * A placeholder is the element that is shown when input/output
 * is hidden.
 */
class Placeholder extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    /**
     * Construct a new placeholder.
     */
    constructor(options) {
        var _a, _b, _c;
        const node = document.createElement('div');
        super({ node });
        const trans = ((_a = options.translator) !== null && _a !== void 0 ? _a : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator).load('jupyterlab');
        const innerNode = document.createElement('div');
        innerNode.className = (_b = options.promptClass) !== null && _b !== void 0 ? _b : '';
        node.insertAdjacentHTML('afterbegin', innerNode.outerHTML);
        this._cell = document.createElement('div');
        this._cell.classList.add(CONTENT_CLASS);
        this._cell.title = trans.__('Click to expand');
        const container = this._cell.appendChild(document.createElement('div'));
        container.classList.add('jp-Placeholder-contentContainer');
        this._textContent = container.appendChild(document.createElement('span'));
        this._textContent.className = 'jp-PlaceholderText';
        this._textContent.innerText = (_c = options.text) !== null && _c !== void 0 ? _c : '';
        node.appendChild(this._cell);
        _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.ellipsesIcon.element({
            container: container.appendChild(document.createElement('span')),
            className: 'jp-MoreHorizIcon',
            elementPosition: 'center',
            height: 'auto',
            width: '32px'
        });
        this.addClass(PLACEHOLDER_CLASS);
        this._callback = options.callback;
    }
    /**
     * The text displayed in the placeholder.
     */
    set text(t) {
        this._textContent.innerText = t;
    }
    get text() {
        return this._textContent.innerText;
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.node.addEventListener('click', this._callback);
    }
    onBeforeDetach(msg) {
        this.node.removeEventListener('click', this._callback);
        super.onBeforeDetach(msg);
    }
}
/**
 * The input placeholder class.
 */
class InputPlaceholder extends Placeholder {
    /**
     * Construct a new input placeholder.
     */
    constructor(options) {
        super({ ...options, promptClass: INPUT_PROMPT_CLASS });
        this.addClass(INPUT_PLACEHOLDER_CLASS);
    }
}
/**
 * The output placeholder class.
 */
class OutputPlaceholder extends Placeholder {
    /**
     * Construct a new output placeholder.
     */
    constructor(options) {
        super({ ...options, promptClass: OUTPUT_PROMPT_CLASS });
        this.addClass(OUTPUT_PLACEHOLDER_CLASS);
    }
}
//# sourceMappingURL=placeholder.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/resizeHandle.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/resizeHandle.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeHandle: () => (/* binding */ ResizeHandle)
/* harmony export */ });
/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */



const RESIZE_HANDLE_CLASS = 'jp-CellResizeHandle';
const CELL_RESIZED_CLASS = 'jp-mod-resizedCell';
/**
 * A handle that allows to change input/output proportions in side-by-side mode.
 */
class ResizeHandle extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget {
    constructor(targetNode) {
        super();
        this.targetNode = targetNode;
        this._isActive = false;
        this._isDragging = false;
        /**
         * A public signal used to indicate the size of the cell and output has changed.
         */
        this.sizeChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);
        this.addClass(RESIZE_HANDLE_CLASS);
        this._resizer = new _lumino_polling__WEBPACK_IMPORTED_MODULE_0__.Throttler(event => this._resize(event), 50);
    }
    /**
     * Dispose the resizer handle.
     */
    dispose() {
        this._resizer.dispose();
        super.dispose();
    }
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     */
    handleEvent(event) {
        var _a, _b;
        switch (event.type) {
            case 'dblclick':
                (_a = this.targetNode.parentNode) === null || _a === void 0 ? void 0 : _a.childNodes.forEach(node => {
                    node.classList.remove(CELL_RESIZED_CLASS);
                });
                document.documentElement.style.setProperty('--jp-side-by-side-output-size', `1fr`);
                this._isActive = false;
                break;
            case 'mousedown':
                this._isDragging = true;
                if (!this._isActive) {
                    (_b = this.targetNode.parentNode) === null || _b === void 0 ? void 0 : _b.childNodes.forEach(node => {
                        node.classList.add(CELL_RESIZED_CLASS);
                    });
                    this._isActive = true;
                }
                window.addEventListener('mousemove', this);
                window.addEventListener('mouseup', this);
                break;
            case 'mousemove': {
                if (this._isActive && this._isDragging) {
                    void this._resizer.invoke(event);
                }
                break;
            }
            case 'mouseup':
                this._isDragging = false;
                window.removeEventListener('mousemove', this);
                window.removeEventListener('mouseup', this);
                break;
            default:
                break;
        }
    }
    /**
     * Handle `after-attach` messages.
     */
    onAfterAttach(msg) {
        this.node.addEventListener('dblclick', this);
        this.node.addEventListener('mousedown', this);
        super.onAfterAttach(msg);
    }
    /**
     * Handle `before-detach` messages.
     */
    onBeforeDetach(msg) {
        this.node.removeEventListener('dblclick', this);
        this.node.removeEventListener('mousedown', this);
        super.onBeforeDetach(msg);
    }
    _resize(event) {
        // Gate the output size ratio between {0.05, 50} as sensible defaults.
        const { width, x } = this.targetNode.getBoundingClientRect();
        const position = event.clientX - x;
        const ratio = width / position - 1;
        if (0 < ratio) {
            const normalized = Math.max(Math.min(Math.abs(ratio), 50), 0.05);
            document.documentElement.style.setProperty('--jp-side-by-side-output-size', `${normalized}fr`);
            this.sizeChanged.emit(normalized);
        }
    }
}
//# sourceMappingURL=resizeHandle.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/searchprovider.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/searchprovider.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CellSearchProvider: () => (/* binding */ CellSearchProvider),
/* harmony export */   SELECTED_HIGHLIGHT_CLASS: () => (/* binding */ SELECTED_HIGHLIGHT_CLASS),
/* harmony export */   createCellSearchProvider: () => (/* binding */ createCellSearchProvider)
/* harmony export */ });
/* harmony import */ var _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/codemirror */ "./node_modules/@jupyterlab/codemirror/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/documentsearch */ "./node_modules/@jupyterlab/documentsearch/lib/providers/genericsearchprovider.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * Class applied on highlighted search matches
 */
const SELECTED_HIGHLIGHT_CLASS = 'jp-mod-selected';
/**
 * Search provider for cells.
 */
class CellSearchProvider extends _jupyterlab_codemirror__WEBPACK_IMPORTED_MODULE_0__.EditorSearchProvider {
    constructor(cell) {
        super();
        this.cell = cell;
        if (!this.cell.inViewport && !this.cell.editor) {
            void (0,_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.signalToPromise)(cell.inViewportChanged).then(([, inViewport]) => {
                if (inViewport) {
                    this.cmHandler.setEditor(this.editor);
                }
            });
        }
    }
    /**
     * Text editor
     */
    get editor() {
        return this.cell.editor;
    }
    /**
     * Editor content model
     */
    get model() {
        return this.cell.model;
    }
}
/**
 * Code cell search provider
 */
class CodeCellSearchProvider extends CellSearchProvider {
    /**
     * Constructor
     *
     * @param cell Cell widget
     */
    constructor(cell) {
        super(cell);
        this.currentProviderIndex = -1;
        this.outputsProvider = [];
        const outputs = this.cell.outputArea;
        this._onOutputsChanged(outputs, outputs.widgets.length).catch(reason => {
            console.error(`Failed to initialize search on cell outputs.`, reason);
        });
        outputs.outputLengthChanged.connect(this._onOutputsChanged, this);
        outputs.disposed.connect(() => {
            outputs.outputLengthChanged.disconnect(this._onOutputsChanged);
        }, this);
    }
    /**
     * Number of matches in the cell.
     */
    get matchesCount() {
        if (!this.isActive) {
            return 0;
        }
        return (super.matchesCount +
            this.outputsProvider.reduce((sum, provider) => { var _a; return sum + ((_a = provider.matchesCount) !== null && _a !== void 0 ? _a : 0); }, 0));
    }
    /**
     * Clear currently highlighted match.
     */
    async clearHighlight() {
        await super.clearHighlight();
        await Promise.all(this.outputsProvider.map(provider => provider.clearHighlight()));
    }
    /**
     * Dispose the search provider
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        super.dispose();
        this.outputsProvider.map(provider => {
            provider.dispose();
        });
        this.outputsProvider.length = 0;
    }
    /**
     * Highlight the next match.
     *
     * @returns The next match if there is one.
     */
    async highlightNext(loop, options) {
        if (this.matchesCount === 0 || !this.isActive) {
            this.currentIndex = null;
        }
        else {
            if (this.currentProviderIndex === -1) {
                const match = await super.highlightNext(true, options);
                if (match) {
                    this.currentIndex = this.cmHandler.currentIndex;
                    return match;
                }
                else {
                    this.currentProviderIndex = 0;
                }
            }
            while (this.currentProviderIndex < this.outputsProvider.length) {
                const provider = this.outputsProvider[this.currentProviderIndex];
                const match = await provider.highlightNext(false);
                if (match) {
                    this.currentIndex =
                        super.matchesCount +
                            this.outputsProvider
                                .slice(0, this.currentProviderIndex)
                                .reduce((sum, provider) => { var _a; return (sum += (_a = provider.matchesCount) !== null && _a !== void 0 ? _a : 0); }, 0) +
                            provider.currentMatchIndex;
                    return match;
                }
                else {
                    this.currentProviderIndex += 1;
                }
            }
            this.currentProviderIndex = -1;
            this.currentIndex = null;
            return undefined;
        }
    }
    /**
     * Highlight the previous match.
     *
     * @returns The previous match if there is one.
     */
    async highlightPrevious() {
        if (this.matchesCount === 0 || !this.isActive) {
            this.currentIndex = null;
        }
        else {
            if (this.currentIndex === null) {
                this.currentProviderIndex = this.outputsProvider.length - 1;
            }
            while (this.currentProviderIndex >= 0) {
                const provider = this.outputsProvider[this.currentProviderIndex];
                const match = await provider.highlightPrevious(false);
                if (match) {
                    this.currentIndex =
                        super.matchesCount +
                            this.outputsProvider
                                .slice(0, this.currentProviderIndex)
                                .reduce((sum, provider) => { var _a; return (sum += (_a = provider.matchesCount) !== null && _a !== void 0 ? _a : 0); }, 0) +
                            provider.currentMatchIndex;
                    return match;
                }
                else {
                    this.currentProviderIndex -= 1;
                }
            }
            const match = await super.highlightPrevious();
            if (match) {
                this.currentIndex = this.cmHandler.currentIndex;
                return match;
            }
            else {
                this.currentIndex = null;
                return undefined;
            }
        }
    }
    /**
     * Initialize the search using the provided options. Should update the UI to highlight
     * all matches and "select" the first match.
     *
     * @param query A RegExp to be use to perform the search
     * @param filters Filter parameters to pass to provider
     */
    async startQuery(query, filters) {
        await super.startQuery(query, filters);
        // Search outputs
        if ((filters === null || filters === void 0 ? void 0 : filters.output) !== false && this.isActive) {
            await Promise.all(this.outputsProvider.map(provider => provider.startQuery(query)));
        }
    }
    async endQuery() {
        var _a;
        await super.endQuery();
        if (((_a = this.filters) === null || _a === void 0 ? void 0 : _a.output) !== false && this.isActive) {
            await Promise.all(this.outputsProvider.map(provider => provider.endQuery()));
        }
    }
    async _onOutputsChanged(outputArea, changes) {
        var _a;
        this.outputsProvider.forEach(provider => {
            provider.dispose();
        });
        this.outputsProvider.length = 0;
        this.currentProviderIndex = -1;
        this.outputsProvider = this.cell.outputArea.widgets.map(output => new _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_2__.GenericSearchProvider(output));
        if (this.isActive && this.query && ((_a = this.filters) === null || _a === void 0 ? void 0 : _a.output) !== false) {
            await Promise.all([
                this.outputsProvider.map(provider => {
                    void provider.startQuery(this.query);
                })
            ]);
        }
        this._stateChanged.emit();
    }
}
/**
 * Markdown cell search provider
 */
class MarkdownCellSearchProvider extends CellSearchProvider {
    /**
     * Constructor
     *
     * @param cell Cell widget
     */
    constructor(cell) {
        super(cell);
        this._unrenderedByHighlight = false;
        this.renderedProvider = new _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_2__.GenericSearchProvider(cell.renderer);
    }
    /**
     * Clear currently highlighted match
     */
    async clearHighlight() {
        await super.clearHighlight();
        await this.renderedProvider.clearHighlight();
    }
    /**
     * Dispose the search provider
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        super.dispose();
        this.renderedProvider.dispose();
    }
    /**
     * Stop the search and clean any UI elements.
     */
    async endQuery() {
        await super.endQuery();
        await this.renderedProvider.endQuery();
    }
    /**
     * Highlight the next match.
     *
     * @returns The next match if there is one.
     */
    async highlightNext() {
        let match = undefined;
        if (!this.isActive) {
            return match;
        }
        const cell = this.cell;
        if (cell.rendered && this.matchesCount > 0) {
            // Unrender the cell
            this._unrenderedByHighlight = true;
            const waitForRendered = (0,_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.signalToPromise)(cell.renderedChanged);
            cell.rendered = false;
            await waitForRendered;
        }
        match = await super.highlightNext();
        return match;
    }
    /**
     * Highlight the previous match.
     *
     * @returns The previous match if there is one.
     */
    async highlightPrevious() {
        let match = undefined;
        const cell = this.cell;
        if (cell.rendered && this.matchesCount > 0) {
            // Unrender the cell if there are matches within the cell
            this._unrenderedByHighlight = true;
            const waitForRendered = (0,_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.signalToPromise)(cell.renderedChanged);
            cell.rendered = false;
            await waitForRendered;
        }
        match = await super.highlightPrevious();
        return match;
    }
    /**
     * Initialize the search using the provided options. Should update the UI
     * to highlight all matches and "select" the first match.
     *
     * @param query A RegExp to be use to perform the search
     * @param filters Filter parameters to pass to provider
     */
    async startQuery(query, filters) {
        await super.startQuery(query, filters);
        const cell = this.cell;
        if (cell.rendered) {
            this.onRenderedChanged(cell, cell.rendered);
        }
        cell.renderedChanged.connect(this.onRenderedChanged, this);
    }
    /**
     * Replace all matches in the cell source with the provided text
     *
     * @param newText The replacement text.
     * @returns Whether a replace occurred.
     */
    async replaceAllMatches(newText) {
        const result = await super.replaceAllMatches(newText);
        // if the cell is rendered force update
        if (this.cell.rendered) {
            this.cell.update();
        }
        return result;
    }
    /**
     * Callback on rendered state change
     *
     * @param cell Cell that emitted the change
     * @param rendered New rendered value
     */
    onRenderedChanged(cell, rendered) {
        var _a;
        if (!this._unrenderedByHighlight) {
            this.currentIndex = null;
        }
        this._unrenderedByHighlight = false;
        if (this.isActive) {
            if (rendered) {
                void this.renderedProvider.startQuery(this.query);
            }
            else {
                // Force cursor position to ensure reverse search is working as expected
                (_a = cell.editor) === null || _a === void 0 ? void 0 : _a.setCursorPosition({ column: 0, line: 0 });
                void this.renderedProvider.endQuery();
            }
        }
    }
}
/**
 * Factory to create a cell search provider
 *
 * @param cell Cell widget
 * @returns Cell search provider
 */
function createCellSearchProvider(cell) {
    if (cell.isPlaceholder()) {
        return new CellSearchProvider(cell);
    }
    switch (cell.model.type) {
        case 'code':
            return new CodeCellSearchProvider(cell);
        case 'markdown':
            return new MarkdownCellSearchProvider(cell);
        default:
            return new CellSearchProvider(cell);
    }
}
//# sourceMappingURL=searchprovider.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/lib/widget.js":
/*!******************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/lib/widget.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AttachmentsCell: () => (/* binding */ AttachmentsCell),
/* harmony export */   Cell: () => (/* binding */ Cell),
/* harmony export */   CodeCell: () => (/* binding */ CodeCell),
/* harmony export */   CodeCellLayout: () => (/* binding */ CodeCellLayout),
/* harmony export */   MarkdownCell: () => (/* binding */ MarkdownCell),
/* harmony export */   RawCell: () => (/* binding */ RawCell)
/* harmony export */ });
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var _jupyterlab_attachments__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @jupyterlab/attachments */ "./node_modules/@jupyterlab/attachments/lib/model.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @jupyterlab/outputarea */ "./node_modules/@jupyterlab/outputarea/lib/widget.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @jupyterlab/rendermime */ "./node_modules/@jupyterlab/rendermime/lib/factories.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @jupyterlab/rendermime */ "./node_modules/@jupyterlab/rendermime/lib/mimemodel.js");
/* harmony import */ var _jupyterlab_toc__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @jupyterlab/toc */ "./node_modules/@jupyterlab/toc/lib/utils/markdown.js");
/* harmony import */ var _jupyterlab_toc__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @jupyterlab/toc */ "./node_modules/@jupyterlab/toc/lib/utils/common.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/cells/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/messaging */ "./node_modules/@lumino/messaging/dist/index.es6.js");
/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/polling */ "./node_modules/@lumino/polling/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
/* harmony import */ var _collapser__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./collapser */ "./node_modules/@jupyterlab/cells/lib/collapser.js");
/* harmony import */ var _headerfooter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./headerfooter */ "./node_modules/@jupyterlab/cells/lib/headerfooter.js");
/* harmony import */ var _inputarea__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./inputarea */ "./node_modules/@jupyterlab/cells/lib/inputarea.js");
/* harmony import */ var _placeholder__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./placeholder */ "./node_modules/@jupyterlab/cells/lib/placeholder.js");
/* harmony import */ var _resizeHandle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./resizeHandle */ "./node_modules/@jupyterlab/cells/lib/resizeHandle.js");
/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/



















/**
 * The CSS class added to cell widgets.
 */
const CELL_CLASS = 'jp-Cell';
/**
 * The CSS class added to the cell header.
 */
const CELL_HEADER_CLASS = 'jp-Cell-header';
/**
 * The CSS class added to the cell footer.
 */
const CELL_FOOTER_CLASS = 'jp-Cell-footer';
/**
 * The CSS class added to the cell input wrapper.
 */
const CELL_INPUT_WRAPPER_CLASS = 'jp-Cell-inputWrapper';
/**
 * The CSS class added to the cell output wrapper.
 */
const CELL_OUTPUT_WRAPPER_CLASS = 'jp-Cell-outputWrapper';
/**
 * The CSS class added to the cell input area.
 */
const CELL_INPUT_AREA_CLASS = 'jp-Cell-inputArea';
/**
 * The CSS class added to the cell output area.
 */
const CELL_OUTPUT_AREA_CLASS = 'jp-Cell-outputArea';
/**
 * The CSS class added to the cell input collapser.
 */
const CELL_INPUT_COLLAPSER_CLASS = 'jp-Cell-inputCollapser';
/**
 * The CSS class added to the cell output collapser.
 */
const CELL_OUTPUT_COLLAPSER_CLASS = 'jp-Cell-outputCollapser';
/**
 * The class name added to the cell when dirty.
 */
const DIRTY_CLASS = 'jp-mod-dirty';
/**
 * The class name added to code cells.
 */
const CODE_CELL_CLASS = 'jp-CodeCell';
/**
 * The class name added to markdown cells.
 */
const MARKDOWN_CELL_CLASS = 'jp-MarkdownCell';
/**
 * The class name added to rendered markdown output widgets.
 */
const MARKDOWN_OUTPUT_CLASS = 'jp-MarkdownOutput';
const MARKDOWN_HEADING_COLLAPSED = 'jp-MarkdownHeadingCollapsed';
const HEADING_COLLAPSER_CLASS = 'jp-collapseHeadingButton';
const SHOW_HIDDEN_CELLS_CLASS = 'jp-showHiddenCellsButton';
/**
 * The class name added to raw cells.
 */
const RAW_CELL_CLASS = 'jp-RawCell';
/**
 * The class name added to a rendered input area.
 */
const RENDERED_CLASS = 'jp-mod-rendered';
const NO_OUTPUTS_CLASS = 'jp-mod-noOutputs';
/**
 * The text applied to an empty markdown cell.
 */
const DEFAULT_MARKDOWN_TEXT = 'Type Markdown and LaTeX: $ α^2 $';
/**
 * The timeout to wait for change activity to have ceased before rendering.
 */
const RENDER_TIMEOUT = 1000;
/**
 * The mime type for a rich contents drag object.
 */
const CONTENTS_MIME_RICH = 'application/x-jupyter-icontentsrich';
/** ****************************************************************************
 * Cell
 ******************************************************************************/
/**
 * A base cell widget.
 */
class Cell extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.Widget {
    /**
     * Construct a new base cell widget.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        super();
        this.prompt = '';
        this._displayChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__.Signal(this);
        this._editorConfig = {};
        this._inputHidden = false;
        this._inViewportChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__.Signal(this);
        this._readOnly = false;
        this._ready = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
        this._resizeDebouncer = new _lumino_polling__WEBPACK_IMPORTED_MODULE_4__.Debouncer(() => {
            this._displayChanged.emit();
        }, 0);
        this._syncCollapse = false;
        this._syncEditable = false;
        this.addClass(CELL_CLASS);
        const model = (this._model = options.model);
        this.contentFactory = options.contentFactory;
        this.layout = (_a = options.layout) !== null && _a !== void 0 ? _a : new _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.PanelLayout();
        // Set up translator for aria labels
        this.translator = (_b = options.translator) !== null && _b !== void 0 ? _b : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        this._editorConfig = (_c = options.editorConfig) !== null && _c !== void 0 ? _c : {};
        this._placeholder = true;
        this._inViewport = false;
        this.placeholder = (_d = options.placeholder) !== null && _d !== void 0 ? _d : true;
        model.metadataChanged.connect(this.onMetadataChanged, this);
    }
    /**
     * Initialize view state from model.
     *
     * #### Notes
     * Should be called after construction. For convenience, returns this, so it
     * can be chained in the construction, like `new Foo().initializeState();`
     */
    initializeState() {
        this.loadCollapseState();
        this.loadEditableState();
        return this;
    }
    /**
     * Signal to indicate that widget has changed visibly (in size, in type, etc)
     */
    get displayChanged() {
        return this._displayChanged;
    }
    /**
     * Whether the cell is in viewport or not.
     */
    get inViewport() {
        return this._inViewport;
    }
    set inViewport(v) {
        if (this._inViewport !== v) {
            this._inViewport = v;
            this._inViewportChanged.emit(this._inViewport);
        }
    }
    /**
     * Will emit true just after the node is attached to the DOM
     * Will emit false just before the node is detached of the DOM
     */
    get inViewportChanged() {
        return this._inViewportChanged;
    }
    /**
     * Whether the cell is a placeholder not yet fully rendered or not.
     */
    get placeholder() {
        return this._placeholder;
    }
    set placeholder(v) {
        if (this._placeholder !== v && v === false) {
            this.initializeDOM();
            this._placeholder = v;
            this._ready.resolve();
        }
    }
    /**
     * Get the prompt node used by the cell.
     */
    get promptNode() {
        if (this.placeholder) {
            return null;
        }
        if (!this._inputHidden) {
            return this._input.promptNode;
        }
        else {
            return this._inputPlaceholder.node
                .firstElementChild;
        }
    }
    /**
     * Get the CodeEditorWrapper used by the cell.
     */
    get editorWidget() {
        var _a, _b;
        return (_b = (_a = this._input) === null || _a === void 0 ? void 0 : _a.editorWidget) !== null && _b !== void 0 ? _b : null;
    }
    /**
     * Get the CodeEditor used by the cell.
     */
    get editor() {
        var _a, _b;
        return (_b = (_a = this._input) === null || _a === void 0 ? void 0 : _a.editor) !== null && _b !== void 0 ? _b : null;
    }
    /**
     * Editor configuration
     */
    get editorConfig() {
        return this._editorConfig;
    }
    /**
     * Cell headings
     */
    get headings() {
        return new Array();
    }
    /**
     * Get the model used by the cell.
     */
    get model() {
        return this._model;
    }
    /**
     * Get the input area for the cell.
     */
    get inputArea() {
        return this._input;
    }
    /**
     * The read only state of the cell.
     */
    get readOnly() {
        return this._readOnly;
    }
    set readOnly(value) {
        if (value === this._readOnly) {
            return;
        }
        this._readOnly = value;
        if (this.syncEditable) {
            this.saveEditableState();
        }
        this.update();
    }
    /**
     * Whether the cell is a placeholder that defer rendering
     *
     * #### Notes
     * You can wait for the promise `Cell.ready` to wait for the
     * cell to be rendered.
     */
    isPlaceholder() {
        return this.placeholder;
    }
    /**
     * Save view editable state to model
     */
    saveEditableState() {
        const { sharedModel } = this.model;
        const current = sharedModel.getMetadata('editable');
        if ((this.readOnly && current === false) ||
            (!this.readOnly && current === undefined)) {
            return;
        }
        if (this.readOnly) {
            sharedModel.setMetadata('editable', false);
        }
        else {
            sharedModel.deleteMetadata('editable');
        }
    }
    /**
     * Load view editable state from model.
     */
    loadEditableState() {
        this.readOnly =
            this.model.sharedModel.getMetadata('editable') ===
                false;
    }
    /**
     * A promise that resolves when the widget renders for the first time.
     */
    get ready() {
        return this._ready.promise;
    }
    /**
     * Set the prompt for the widget.
     */
    setPrompt(value) {
        var _a;
        this.prompt = value;
        (_a = this._input) === null || _a === void 0 ? void 0 : _a.setPrompt(value);
    }
    /**
     * The view state of input being hidden.
     */
    get inputHidden() {
        return this._inputHidden;
    }
    set inputHidden(value) {
        var _a;
        if (this._inputHidden === value) {
            return;
        }
        if (!this.placeholder) {
            const layout = this._inputWrapper.layout;
            if (value) {
                this._input.parent = null;
                if (this._inputPlaceholder) {
                    this._inputPlaceholder.text = (_a = this.model.sharedModel
                        .getSource()
                        .split('\n')) === null || _a === void 0 ? void 0 : _a[0];
                }
                layout.addWidget(this._inputPlaceholder);
            }
            else {
                this._inputPlaceholder.parent = null;
                layout.addWidget(this._input);
            }
        }
        this._inputHidden = value;
        if (this.syncCollapse) {
            this.saveCollapseState();
        }
        this.handleInputHidden(value);
    }
    /**
     * Save view collapse state to model
     */
    saveCollapseState() {
        const jupyter = { ...this.model.getMetadata('jupyter') };
        if ((this.inputHidden && jupyter.source_hidden === true) ||
            (!this.inputHidden && jupyter.source_hidden === undefined)) {
            return;
        }
        if (this.inputHidden) {
            jupyter.source_hidden = true;
        }
        else {
            delete jupyter.source_hidden;
        }
        if (Object.keys(jupyter).length === 0) {
            this.model.deleteMetadata('jupyter');
        }
        else {
            this.model.setMetadata('jupyter', jupyter);
        }
    }
    /**
     * Revert view collapse state from model.
     */
    loadCollapseState() {
        var _a;
        const jupyter = (_a = this.model.getMetadata('jupyter')) !== null && _a !== void 0 ? _a : {};
        this.inputHidden = !!jupyter.source_hidden;
    }
    /**
     * Handle the input being hidden.
     *
     * #### Notes
     * This is called by the `inputHidden` setter so that subclasses
     * can perform actions upon the input being hidden without accessing
     * private state.
     */
    handleInputHidden(value) {
        return;
    }
    /**
     * Whether to sync the collapse state to the cell model.
     */
    get syncCollapse() {
        return this._syncCollapse;
    }
    set syncCollapse(value) {
        if (this._syncCollapse === value) {
            return;
        }
        this._syncCollapse = value;
        if (value) {
            this.loadCollapseState();
        }
    }
    /**
     * Whether to sync the editable state to the cell model.
     */
    get syncEditable() {
        return this._syncEditable;
    }
    set syncEditable(value) {
        if (this._syncEditable === value) {
            return;
        }
        this._syncEditable = value;
        if (value) {
            this.loadEditableState();
        }
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            placeholder: false,
            translator: this.translator
        });
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        // Do nothing if already disposed.
        if (this.isDisposed) {
            return;
        }
        this._resizeDebouncer.dispose();
        this._input = null;
        this._model = null;
        this._inputWrapper = null;
        this._inputPlaceholder = null;
        super.dispose();
    }
    /**
     * Update the editor configuration with the partial provided dictionary.
     *
     * @param v Partial editor configuration
     */
    updateEditorConfig(v) {
        this._editorConfig = { ...this._editorConfig, ...v };
        if (this.editor) {
            this.editor.setOptions(this._editorConfig);
        }
    }
    /**
     * Create children widgets.
     */
    initializeDOM() {
        if (!this.placeholder) {
            return;
        }
        const contentFactory = this.contentFactory;
        const model = this._model;
        // Header
        const header = contentFactory.createCellHeader();
        header.addClass(CELL_HEADER_CLASS);
        this.layout.addWidget(header);
        // Input
        const inputWrapper = (this._inputWrapper = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.Panel());
        inputWrapper.addClass(CELL_INPUT_WRAPPER_CLASS);
        const inputCollapser = new _collapser__WEBPACK_IMPORTED_MODULE_7__.InputCollapser();
        inputCollapser.addClass(CELL_INPUT_COLLAPSER_CLASS);
        const input = (this._input = new _inputarea__WEBPACK_IMPORTED_MODULE_8__.InputArea({
            model,
            contentFactory,
            editorOptions: this.getEditorOptions()
        }));
        input.addClass(CELL_INPUT_AREA_CLASS);
        inputWrapper.addWidget(inputCollapser);
        inputWrapper.addWidget(input);
        this.layout.addWidget(inputWrapper);
        this._inputPlaceholder = new _placeholder__WEBPACK_IMPORTED_MODULE_9__.InputPlaceholder({
            callback: () => {
                this.inputHidden = !this.inputHidden;
            },
            text: input.model.sharedModel.getSource().split('\n')[0],
            translator: this.translator
        });
        input.model.contentChanged.connect((sender, args) => {
            var _a;
            if (this._inputPlaceholder && this.inputHidden) {
                this._inputPlaceholder.text = (_a = sender.sharedModel
                    .getSource()
                    .split('\n')) === null || _a === void 0 ? void 0 : _a[0];
            }
        });
        if (this.inputHidden) {
            input.parent = null;
            inputWrapper.layout.addWidget(this._inputPlaceholder);
        }
        // Footer
        const footer = this.contentFactory.createCellFooter();
        footer.addClass(CELL_FOOTER_CLASS);
        this.layout.addWidget(footer);
    }
    /**
     * Get the editor options at initialization.
     *
     * @returns Editor options
     */
    getEditorOptions() {
        return { config: this.editorConfig };
    }
    /**
     * Handle `before-attach` messages.
     */
    onBeforeAttach(msg) {
        if (this.placeholder) {
            this.placeholder = false;
        }
    }
    /**
     * Handle `after-attach` messages.
     */
    onAfterAttach(msg) {
        this.update();
    }
    /**
     * Handle `'activate-request'` messages.
     */
    onActivateRequest(msg) {
        var _a;
        (_a = this.editor) === null || _a === void 0 ? void 0 : _a.focus();
    }
    /**
     * Handle `resize` messages.
     */
    onResize(msg) {
        void this._resizeDebouncer.invoke();
    }
    /**
     * Handle `update-request` messages.
     */
    onUpdateRequest(msg) {
        var _a, _b;
        if (!this._model) {
            return;
        }
        // Handle read only state.
        if (((_a = this.editor) === null || _a === void 0 ? void 0 : _a.getOption('readOnly')) !== this._readOnly) {
            (_b = this.editor) === null || _b === void 0 ? void 0 : _b.setOption('readOnly', this._readOnly);
        }
    }
    onContentChanged() {
        var _a;
        if (this.inputHidden && this._inputPlaceholder) {
            this._inputPlaceholder.text = (_a = this.model.sharedModel
                .getSource()
                .split('\n')) === null || _a === void 0 ? void 0 : _a[0];
        }
    }
    /**
     * Handle changes in the metadata.
     */
    onMetadataChanged(model, args) {
        switch (args.key) {
            case 'jupyter':
                if (this.syncCollapse) {
                    this.loadCollapseState();
                }
                break;
            case 'editable':
                if (this.syncEditable) {
                    this.loadEditableState();
                }
                break;
            default:
                break;
        }
    }
}
/**
 * The namespace for the `Cell` class statics.
 */
(function (Cell) {
    /**
     * Type of headings
     */
    let HeadingType;
    (function (HeadingType) {
        /**
         * Heading from HTML output
         */
        HeadingType[HeadingType["HTML"] = 0] = "HTML";
        /**
         * Heading from Markdown cell or Markdown output
         */
        HeadingType[HeadingType["Markdown"] = 1] = "Markdown";
    })(HeadingType = Cell.HeadingType || (Cell.HeadingType = {}));
    /**
     * The default implementation of an `IContentFactory`.
     *
     * This includes a CodeMirror editor factory to make it easy to use out of the box.
     */
    class ContentFactory {
        /**
         * Create a content factory for a cell.
         */
        constructor(options) {
            this._editorFactory = options.editorFactory;
        }
        /**
         * The readonly editor factory that create code editors
         */
        get editorFactory() {
            return this._editorFactory;
        }
        /**
         * Create a new cell header for the parent widget.
         */
        createCellHeader() {
            return new _headerfooter__WEBPACK_IMPORTED_MODULE_10__.CellHeader();
        }
        /**
         * Create a new cell footer for the parent widget.
         */
        createCellFooter() {
            return new _headerfooter__WEBPACK_IMPORTED_MODULE_10__.CellFooter();
        }
        /**
         * Create an input prompt.
         */
        createInputPrompt() {
            return new _inputarea__WEBPACK_IMPORTED_MODULE_8__.InputPrompt();
        }
        /**
         * Create the output prompt for the widget.
         */
        createOutputPrompt() {
            return new _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_11__.OutputPrompt();
        }
        /**
         * Create an stdin widget.
         */
        createStdin(options) {
            return new _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_11__.Stdin(options);
        }
    }
    Cell.ContentFactory = ContentFactory;
})(Cell || (Cell = {}));
/** ****************************************************************************
 * CodeCell
 ******************************************************************************/
/**
 * Code cell layout
 *
 * It will not detached the output area when the cell is detached.
 */
class CodeCellLayout extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.PanelLayout {
    /**
     * A message handler invoked on a `'before-attach'` message.
     *
     * #### Notes
     * The default implementation of this method forwards the message
     * to all widgets. It assumes all widget nodes are attached to the
     * parent widget node.
     *
     * This may be reimplemented by subclasses as needed.
     */
    onBeforeAttach(msg) {
        let beforeOutputArea = true;
        const outputAreaWrapper = this.parent.node.firstElementChild;
        for (const widget of this) {
            if (outputAreaWrapper) {
                if (widget.node === outputAreaWrapper) {
                    beforeOutputArea = false;
                }
                else {
                    _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__.MessageLoop.sendMessage(widget, msg);
                    if (beforeOutputArea) {
                        this.parent.node.insertBefore(widget.node, outputAreaWrapper);
                    }
                    else {
                        this.parent.node.appendChild(widget.node);
                    }
                    // Force setting isVisible to true as it requires the parent widget to be
                    // visible. But that flag will be set only during the `onAfterAttach` call.
                    if (!this.parent.isHidden) {
                        widget.setFlag(_lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.Widget.Flag.IsVisible);
                    }
                    // Not called in NotebookWindowedLayout to avoid outputArea
                    // widgets unwanted update or reset.
                    _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__.MessageLoop.sendMessage(widget, _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.Widget.Msg.AfterAttach);
                }
            }
        }
    }
    /**
     * A message handler invoked on an `'after-detach'` message.
     *
     * #### Notes
     * The default implementation of this method forwards the message
     * to all widgets. It assumes all widget nodes are attached to the
     * parent widget node.
     *
     * This may be reimplemented by subclasses as needed.
     */
    onAfterDetach(msg) {
        for (const widget of this) {
            // TODO we could improve this further by removing outputs based
            // on their mime type (for example plain/text or markdown could safely be detached)
            // If the cell is out of the view port, its children are already detached -> skip detaching
            if (!widget.hasClass(CELL_OUTPUT_WRAPPER_CLASS) &&
                widget.node.isConnected) {
                // Not called in NotebookWindowedLayout for windowed notebook
                _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__.MessageLoop.sendMessage(widget, _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.Widget.Msg.BeforeDetach);
                this.parent.node.removeChild(widget.node);
                _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__.MessageLoop.sendMessage(widget, msg);
            }
        }
    }
}
/**
 * A widget for a code cell.
 */
class CodeCell extends Cell {
    /**
     * Construct a code cell widget.
     */
    constructor(options) {
        var _a;
        super({ layout: new CodeCellLayout(), ...options, placeholder: true });
        this._headingsCache = null;
        this._outputHidden = false;
        this._outputWrapper = null;
        this._outputPlaceholder = null;
        this._syncScrolled = false;
        this.addClass(CODE_CELL_CLASS);
        const trans = this.translator.load('jupyterlab');
        // Only save options not handled by parent constructor.
        const rendermime = (this._rendermime = options.rendermime);
        const contentFactory = this.contentFactory;
        const model = this.model;
        this.maxNumberOutputs = options.maxNumberOutputs;
        // Note that modifying the below label warrants one to also modify
        // the same in this._outputLengthHandler. Ideally, this label must
        // have been a constant and used in both places but it is not done
        // so because of limitations in the translation manager.
        const ariaLabel = model.outputs.length === 0
            ? trans.__('Code Cell Content')
            : trans.__('Code Cell Content with Output');
        this.node.setAttribute('aria-label', ariaLabel);
        const output = (this._output = new _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_11__.OutputArea({
            model: this.model.outputs,
            rendermime,
            contentFactory: contentFactory,
            maxNumberOutputs: this.maxNumberOutputs,
            translator: this.translator,
            promptOverlay: true,
            inputHistoryScope: options.inputHistoryScope
        }));
        output.addClass(CELL_OUTPUT_AREA_CLASS);
        output.toggleScrolling.connect(() => {
            this.outputsScrolled = !this.outputsScrolled;
        });
        // Defer setting placeholder as OutputArea must be instantiated before initializing the DOM
        this.placeholder = (_a = options.placeholder) !== null && _a !== void 0 ? _a : true;
        model.outputs.changed.connect(this.onOutputChanged, this);
        model.outputs.stateChanged.connect(this.onOutputChanged, this);
        model.stateChanged.connect(this.onStateChanged, this);
    }
    /**
     * Create children widgets.
     */
    initializeDOM() {
        if (!this.placeholder) {
            return;
        }
        super.initializeDOM();
        this.setPrompt(this.prompt);
        // Insert the output before the cell footer.
        const outputWrapper = (this._outputWrapper = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_6__.Panel());
        outputWrapper.addClass(CELL_OUTPUT_WRAPPER_CLASS);
        const outputCollapser = new _collapser__WEBPACK_IMPORTED_MODULE_7__.OutputCollapser();
        outputCollapser.addClass(CELL_OUTPUT_COLLAPSER_CLASS);
        outputWrapper.addWidget(outputCollapser);
        // Set a CSS if there are no outputs, and connect a signal for future
        // changes to the number of outputs. This is for conditional styling
        // if there are no outputs.
        if (this.model.outputs.length === 0) {
            this.addClass(NO_OUTPUTS_CLASS);
        }
        this._output.outputLengthChanged.connect(this._outputLengthHandler, this);
        outputWrapper.addWidget(this._output);
        const layout = this.layout;
        const resizeHandle = new _resizeHandle__WEBPACK_IMPORTED_MODULE_12__.ResizeHandle(this.node);
        resizeHandle.sizeChanged.connect(this._sizeChangedHandler, this);
        layout.insertWidget(layout.widgets.length - 1, resizeHandle);
        layout.insertWidget(layout.widgets.length - 1, outputWrapper);
        if (this.model.isDirty) {
            this.addClass(DIRTY_CLASS);
        }
        this._outputPlaceholder = new _placeholder__WEBPACK_IMPORTED_MODULE_9__.OutputPlaceholder({
            callback: () => {
                this.outputHidden = !this.outputHidden;
            },
            text: this.getOutputPlaceholderText(),
            translator: this.translator
        });
        const layoutWrapper = outputWrapper.layout;
        if (this.outputHidden) {
            layoutWrapper.removeWidget(this._output);
            layoutWrapper.addWidget(this._outputPlaceholder);
            if (this.inputHidden && !outputWrapper.isHidden) {
                this._outputWrapper.hide();
            }
        }
        const trans = this.translator.load('jupyterlab');
        const ariaLabel = this.model.outputs.length === 0
            ? trans.__('Code Cell Content')
            : trans.__('Code Cell Content with Output');
        this.node.setAttribute('aria-label', ariaLabel);
    }
    getOutputPlaceholderText() {
        var _a;
        const firstOutput = this.model.outputs.get(0);
        const outputData = firstOutput === null || firstOutput === void 0 ? void 0 : firstOutput.data;
        if (!outputData) {
            return undefined;
        }
        const supportedOutputTypes = [
            'text/html',
            'image/svg+xml',
            'application/pdf',
            'text/markdown',
            'text/plain',
            'application/vnd.jupyter.stderr',
            'application/vnd.jupyter.stdout',
            'text'
        ];
        const preferredOutput = supportedOutputTypes.find(mt => {
            const data = firstOutput.data[mt];
            return (Array.isArray(data) ? typeof data[0] : typeof data) === 'string';
        });
        const dataToDisplay = firstOutput.data[preferredOutput !== null && preferredOutput !== void 0 ? preferredOutput : ''];
        if (dataToDisplay !== undefined) {
            return (_a = (Array.isArray(dataToDisplay)
                ? dataToDisplay
                : dataToDisplay === null || dataToDisplay === void 0 ? void 0 : dataToDisplay.split('\n'))) === null || _a === void 0 ? void 0 : _a.find(part => part !== '');
        }
        return undefined;
    }
    /**
     * Initialize view state from model.
     *
     * #### Notes
     * Should be called after construction. For convenience, returns this, so it
     * can be chained in the construction, like `new Foo().initializeState();`
     */
    initializeState() {
        super.initializeState();
        this.loadScrolledState();
        this.setPrompt(`${this.model.executionCount || ''}`);
        return this;
    }
    get headings() {
        if (!this._headingsCache) {
            const headings = [];
            // Iterate over the code cell outputs to check for Markdown or HTML from which we can generate ToC headings...
            const outputs = this.model.outputs;
            for (let j = 0; j < outputs.length; j++) {
                const m = outputs.get(j);
                let htmlType = null;
                let mdType = null;
                Object.keys(m.data).forEach(t => {
                    if (!mdType && _jupyterlab_toc__WEBPACK_IMPORTED_MODULE_13__.isMarkdown(t)) {
                        mdType = t;
                    }
                    else if (!htmlType && _jupyterlab_toc__WEBPACK_IMPORTED_MODULE_14__.isHTML(t)) {
                        htmlType = t;
                    }
                });
                // Parse HTML output
                if (htmlType) {
                    headings.push(..._jupyterlab_toc__WEBPACK_IMPORTED_MODULE_14__.getHTMLHeadings(this._rendermime.sanitizer.sanitize(m.data[htmlType])).map(heading => {
                        return {
                            ...heading,
                            outputIndex: j,
                            type: Cell.HeadingType.HTML
                        };
                    }));
                }
                else if (mdType) {
                    headings.push(..._jupyterlab_toc__WEBPACK_IMPORTED_MODULE_13__.getHeadings(m.data[mdType]).map(heading => {
                        return {
                            ...heading,
                            outputIndex: j,
                            type: Cell.HeadingType.Markdown
                        };
                    }));
                }
            }
            this._headingsCache = headings;
        }
        return [...this._headingsCache];
    }
    /**
     * Get the output area for the cell.
     */
    get outputArea() {
        return this._output;
    }
    /**
     * The view state of output being collapsed.
     */
    get outputHidden() {
        return this._outputHidden;
    }
    set outputHidden(value) {
        var _a;
        if (this._outputHidden === value) {
            return;
        }
        if (!this.placeholder) {
            const layout = this._outputWrapper.layout;
            if (value) {
                layout.removeWidget(this._output);
                layout.addWidget(this._outputPlaceholder);
                if (this.inputHidden && !this._outputWrapper.isHidden) {
                    this._outputWrapper.hide();
                }
                if (this._outputPlaceholder) {
                    this._outputPlaceholder.text = (_a = this.getOutputPlaceholderText()) !== null && _a !== void 0 ? _a : '';
                }
            }
            else {
                if (this._outputWrapper.isHidden) {
                    this._outputWrapper.show();
                }
                layout.removeWidget(this._outputPlaceholder);
                layout.addWidget(this._output);
            }
        }
        this._outputHidden = value;
        if (this.syncCollapse) {
            this.saveCollapseState();
        }
    }
    /**
     * Save view collapse state to model
     */
    saveCollapseState() {
        // Because collapse state for a code cell involves two different pieces of
        // metadata (the `collapsed` and `jupyter` metadata keys), we block reacting
        // to changes in metadata until we have fully committed our changes.
        // Otherwise setting one key can trigger a write to the other key to
        // maintain the synced consistency.
        this.model.sharedModel.transact(() => {
            super.saveCollapseState();
            const collapsed = this.model.getMetadata('collapsed');
            if ((this.outputHidden && collapsed === true) ||
                (!this.outputHidden && collapsed === undefined)) {
                return;
            }
            // Do not set jupyter.outputs_hidden since it is redundant. See
            // and https://github.com/jupyter/nbformat/issues/137
            if (this.outputHidden) {
                this.model.setMetadata('collapsed', true);
            }
            else {
                this.model.deleteMetadata('collapsed');
            }
        }, false);
    }
    /**
     * Revert view collapse state from model.
     *
     * We consider the `collapsed` metadata key as the source of truth for outputs
     * being hidden.
     */
    loadCollapseState() {
        super.loadCollapseState();
        this.outputHidden = !!this.model.getMetadata('collapsed');
    }
    /**
     * Whether the output is in a scrolled state?
     */
    get outputsScrolled() {
        return this._outputsScrolled;
    }
    set outputsScrolled(value) {
        this.toggleClass('jp-mod-outputsScrolled', value);
        this._outputsScrolled = value;
        if (this.syncScrolled) {
            this.saveScrolledState();
        }
    }
    /**
     * Save view collapse state to model
     */
    saveScrolledState() {
        const current = this.model.getMetadata('scrolled');
        if ((this.outputsScrolled && current === true) ||
            (!this.outputsScrolled && current === undefined)) {
            return;
        }
        if (this.outputsScrolled) {
            this.model.setMetadata('scrolled', true);
        }
        else {
            this.model.deleteMetadata('scrolled');
        }
    }
    /**
     * Revert view collapse state from model.
     */
    loadScrolledState() {
        // We don't have the notion of 'auto' scrolled, so we make it false.
        if (this.model.getMetadata('scrolled') === 'auto') {
            this.outputsScrolled = false;
        }
        else {
            this.outputsScrolled = !!this.model.getMetadata('scrolled');
        }
    }
    /**
     * Whether to sync the scrolled state to the cell model.
     */
    get syncScrolled() {
        return this._syncScrolled;
    }
    set syncScrolled(value) {
        if (this._syncScrolled === value) {
            return;
        }
        this._syncScrolled = value;
        if (value) {
            this.loadScrolledState();
        }
    }
    /**
     * Handle the input being hidden.
     *
     * #### Notes
     * This method is called by the case cell implementation and is
     * subclasses here so the code cell can watch to see when input
     * is hidden without accessing private state.
     */
    handleInputHidden(value) {
        if (this.placeholder) {
            return;
        }
        if (!value && this._outputWrapper.isHidden) {
            this._outputWrapper.show();
        }
        else if (value && !this._outputWrapper.isHidden && this._outputHidden) {
            this._outputWrapper.hide();
        }
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            rendermime: this._rendermime,
            placeholder: false,
            translator: this.translator
        });
    }
    /**
     * Clone the OutputArea alone, returning a simplified output area, using the same model.
     */
    cloneOutputArea() {
        return new _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_11__.SimplifiedOutputArea({
            model: this.model.outputs,
            contentFactory: this.contentFactory,
            rendermime: this._rendermime
        });
    }
    /**
     * Dispose of the resources used by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._output.outputLengthChanged.disconnect(this._outputLengthHandler, this);
        this._rendermime = null;
        this._output = null;
        this._outputWrapper = null;
        this._outputPlaceholder = null;
        super.dispose();
    }
    /**
     * Handle changes in the model.
     */
    onStateChanged(model, args) {
        switch (args.name) {
            case 'executionCount':
                this.setPrompt(`${model.executionCount || ''}`);
                break;
            case 'isDirty':
                if (model.isDirty) {
                    this.addClass(DIRTY_CLASS);
                }
                else {
                    this.removeClass(DIRTY_CLASS);
                }
                break;
            default:
                break;
        }
    }
    /**
     * Callback on output changes
     */
    onOutputChanged() {
        var _a;
        this._headingsCache = null;
        if (this._outputPlaceholder && this.outputHidden) {
            this._outputPlaceholder.text = (_a = this.getOutputPlaceholderText()) !== null && _a !== void 0 ? _a : '';
        }
    }
    /**
     * Handle changes in the metadata.
     */
    onMetadataChanged(model, args) {
        switch (args.key) {
            case 'scrolled':
                if (this.syncScrolled) {
                    this.loadScrolledState();
                }
                break;
            case 'collapsed':
                if (this.syncCollapse) {
                    this.loadCollapseState();
                }
                break;
            default:
                break;
        }
        super.onMetadataChanged(model, args);
    }
    /**
     * Handle changes in the number of outputs in the output area.
     */
    _outputLengthHandler(sender, args) {
        const force = args === 0 ? true : false;
        this.toggleClass(NO_OUTPUTS_CLASS, force);
        const trans = this.translator.load('jupyterlab');
        const ariaLabel = force
            ? trans.__('Code Cell Content')
            : trans.__('Code Cell Content with Output');
        this.node.setAttribute('aria-label', ariaLabel);
    }
    /**
     * Handle changes in input/output proportions in side-by-side mode.
     */
    _sizeChangedHandler(sender) {
        this._displayChanged.emit();
    }
}
/**
 * The namespace for the `CodeCell` class statics.
 */
(function (CodeCell) {
    /**
     * Execute a cell given a client session.
     */
    async function execute(cell, sessionContext, metadata) {
        var _a;
        const model = cell.model;
        const code = model.sharedModel.getSource();
        if (!code.trim() || !((_a = sessionContext.session) === null || _a === void 0 ? void 0 : _a.kernel)) {
            model.sharedModel.transact(() => {
                model.clearExecution();
            }, false);
            return;
        }
        const cellId = { cellId: model.sharedModel.getId() };
        metadata = {
            ...model.metadata,
            ...metadata,
            ...cellId
        };
        const { recordTiming } = metadata;
        model.sharedModel.transact(() => {
            model.clearExecution();
            cell.outputHidden = false;
        }, false);
        cell.setPrompt('*');
        model.trusted = true;
        let future;
        try {
            const msgPromise = _jupyterlab_outputarea__WEBPACK_IMPORTED_MODULE_11__.OutputArea.execute(code, cell.outputArea, sessionContext, metadata);
            // cell.outputArea.future assigned synchronously in `execute`
            if (recordTiming) {
                const recordTimingHook = (msg) => {
                    let label;
                    switch (msg.header.msg_type) {
                        case 'status':
                            label = `status.${msg.content.execution_state}`;
                            break;
                        case 'execute_input':
                            label = 'execute_input';
                            break;
                        default:
                            return true;
                    }
                    // If the data is missing, estimate it to now
                    // Date was added in 5.1: https://jupyter-client.readthedocs.io/en/stable/messaging.html#message-header
                    const value = msg.header.date || new Date().toISOString();
                    const timingInfo = Object.assign({}, model.getMetadata('execution'));
                    timingInfo[`iopub.${label}`] = value;
                    model.setMetadata('execution', timingInfo);
                    return true;
                };
                cell.outputArea.future.registerMessageHook(recordTimingHook);
            }
            else {
                model.deleteMetadata('execution');
            }
            // Save this execution's future so we can compare in the catch below.
            future = cell.outputArea.future;
            const msg = (await msgPromise);
            model.executionCount = msg.content.execution_count;
            if (recordTiming) {
                const timingInfo = Object.assign({}, model.getMetadata('execution'));
                const started = msg.metadata.started;
                // Started is not in the API, but metadata IPyKernel sends
                if (started) {
                    timingInfo['shell.execute_reply.started'] = started;
                }
                // Per above, the 5.0 spec does not assume date, so we estimate is required
                const finished = msg.header.date;
                timingInfo['shell.execute_reply'] =
                    finished || new Date().toISOString();
                model.setMetadata('execution', timingInfo);
            }
            return msg;
        }
        catch (e) {
            // If we started executing, and the cell is still indicating this
            // execution, clear the prompt.
            if (future && !cell.isDisposed && cell.outputArea.future === future) {
                cell.setPrompt('');
            }
            throw e;
        }
    }
    CodeCell.execute = execute;
})(CodeCell || (CodeCell = {}));
/**
 * `AttachmentsCell` - A base class for a cell widget that allows
 *  attachments to be drag/drop'd or pasted onto it
 */
class AttachmentsCell extends Cell {
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the notebook panel's node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'lm-dragover':
                this._evtDragOver(event);
                break;
            case 'lm-drop':
                this._evtDrop(event);
                break;
            default:
                break;
        }
    }
    /**
     * Get the editor options at initialization.
     *
     * @returns Editor options
     */
    getEditorOptions() {
        var _a, _b;
        const base = (_a = super.getEditorOptions()) !== null && _a !== void 0 ? _a : {};
        base.extensions = [
            ...((_b = base.extensions) !== null && _b !== void 0 ? _b : []),
            _codemirror_view__WEBPACK_IMPORTED_MODULE_15__.EditorView.domEventHandlers({
                dragenter: (event) => {
                    event.preventDefault();
                },
                dragover: (event) => {
                    event.preventDefault();
                },
                drop: (event) => {
                    this._evtNativeDrop(event);
                },
                paste: (event) => {
                    this._evtPaste(event);
                }
            })
        ];
        return base;
    }
    /**
     * Handle `after-attach` messages for the widget.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        const node = this.node;
        node.addEventListener('lm-dragover', this);
        node.addEventListener('lm-drop', this);
    }
    /**
     * A message handler invoked on a `'before-detach'`
     * message
     */
    onBeforeDetach(msg) {
        const node = this.node;
        node.removeEventListener('lm-dragover', this);
        node.removeEventListener('lm-drop', this);
        super.onBeforeDetach(msg);
    }
    _evtDragOver(event) {
        const supportedMimeType = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.some)(_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_16__.imageRendererFactory.mimeTypes, mimeType => {
            if (!event.mimeData.hasData(CONTENTS_MIME_RICH)) {
                return false;
            }
            const data = event.mimeData.getData(CONTENTS_MIME_RICH);
            return data.model.mimetype === mimeType;
        });
        if (!supportedMimeType) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        event.dropAction = event.proposedAction;
    }
    /**
     * Handle the `paste` event for the widget
     */
    _evtPaste(event) {
        if (event.clipboardData) {
            const items = event.clipboardData.items;
            for (let i = 0; i < items.length; i++) {
                if (items[i].type === 'text/plain') {
                    // Skip if this text is the path to a file
                    if (i < items.length - 1 && items[i + 1].kind === 'file') {
                        continue;
                    }
                    items[i].getAsString(text => {
                        var _a, _b;
                        (_b = (_a = this.editor).replaceSelection) === null || _b === void 0 ? void 0 : _b.call(_a, text);
                    });
                }
                this._attachFiles(event.clipboardData.items);
            }
        }
        event.preventDefault();
    }
    /**
     * Handle the `drop` event for the widget
     */
    _evtNativeDrop(event) {
        if (event.dataTransfer) {
            this._attachFiles(event.dataTransfer.items);
        }
        event.preventDefault();
    }
    /**
     * Handle the `'lm-drop'` event for the widget.
     */
    _evtDrop(event) {
        const supportedMimeTypes = event.mimeData.types().filter(mimeType => {
            if (mimeType === CONTENTS_MIME_RICH) {
                const data = event.mimeData.getData(CONTENTS_MIME_RICH);
                return (_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_16__.imageRendererFactory.mimeTypes.indexOf(data.model.mimetype) !== -1);
            }
            return _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_16__.imageRendererFactory.mimeTypes.indexOf(mimeType) !== -1;
        });
        if (supportedMimeTypes.length === 0) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        if (event.proposedAction === 'none') {
            event.dropAction = 'none';
            return;
        }
        event.dropAction = 'copy';
        for (const mimeType of supportedMimeTypes) {
            if (mimeType === CONTENTS_MIME_RICH) {
                const { model, withContent } = event.mimeData.getData(CONTENTS_MIME_RICH);
                if (model.type === 'file') {
                    const URI = this._generateURI(model.name);
                    this.updateCellSourceWithAttachment(model.name, URI);
                    void withContent().then(fullModel => {
                        this.model.attachments.set(URI, {
                            [fullModel.mimetype]: fullModel.content
                        });
                    });
                }
            }
            else {
                // Pure mimetype, no useful name to infer
                const URI = this._generateURI();
                this.model.attachments.set(URI, {
                    [mimeType]: event.mimeData.getData(mimeType)
                });
                this.updateCellSourceWithAttachment(URI, URI);
            }
        }
    }
    /**
     * Attaches all DataTransferItems (obtained from
     * clipboard or native drop events) to the cell
     */
    _attachFiles(items) {
        for (let i = 0; i < items.length; i++) {
            const item = items[i];
            if (item.kind === 'file') {
                const blob = item.getAsFile();
                if (blob) {
                    this._attachFile(blob);
                }
            }
        }
    }
    /**
     * Takes in a file object and adds it to
     * the cell attachments
     */
    _attachFile(blob) {
        const reader = new FileReader();
        reader.onload = evt => {
            const { href, protocol } = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_17__.URLExt.parse(reader.result);
            if (protocol !== 'data:') {
                return;
            }
            const dataURIRegex = /([\w+\/\+]+)?(?:;(charset=[\w\d-]*|base64))?,(.*)/;
            const matches = dataURIRegex.exec(href);
            if (!matches || matches.length !== 4) {
                return;
            }
            const mimeType = matches[1];
            const encodedData = matches[3];
            const bundle = { [mimeType]: encodedData };
            const URI = this._generateURI(blob.name);
            if (mimeType.startsWith('image/')) {
                this.model.attachments.set(URI, bundle);
                this.updateCellSourceWithAttachment(blob.name, URI);
            }
        };
        reader.onerror = evt => {
            console.error(`Failed to attach ${blob.name}` + evt);
        };
        reader.readAsDataURL(blob);
    }
    /**
     * Generates a unique URI for a file
     * while preserving the file extension.
     */
    _generateURI(name = '') {
        const lastIndex = name.lastIndexOf('.');
        return lastIndex !== -1
            ? _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.UUID.uuid4().concat(name.substring(lastIndex))
            : _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.UUID.uuid4();
    }
}
/** ****************************************************************************
 * MarkdownCell
 ******************************************************************************/
/**
 * A widget for a Markdown cell.
 *
 * #### Notes
 * Things get complicated if we want the rendered text to update
 * any time the text changes, the text editor model changes,
 * or the input area model changes.  We don't support automatically
 * updating the rendered text in all of these cases.
 */
class MarkdownCell extends AttachmentsCell {
    /**
     * Construct a Markdown cell widget.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        super({ ...options, placeholder: true });
        this._headingsCache = null;
        this._headingCollapsedChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__.Signal(this);
        this._prevText = '';
        this._rendered = true;
        this._renderedChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__.Signal(this);
        this._showEditorForReadOnlyMarkdown = true;
        this.addClass(MARKDOWN_CELL_CLASS);
        this.model.contentChanged.connect(this.onContentChanged, this);
        const trans = this.translator.load('jupyterlab');
        this.node.setAttribute('aria-label', trans.__('Markdown Cell Content'));
        // Ensure we can resolve attachments:
        this._rendermime = options.rendermime.clone({
            resolver: new _jupyterlab_attachments__WEBPACK_IMPORTED_MODULE_18__.AttachmentsResolver({
                parent: (_a = options.rendermime.resolver) !== null && _a !== void 0 ? _a : undefined,
                model: this.model.attachments
            })
        });
        this._renderer = this._rendermime.createRenderer('text/markdown');
        this._renderer.addClass(MARKDOWN_OUTPUT_CLASS);
        // Check if heading cell is set to be collapsed
        this._headingCollapsed = ((_b = this.model.getMetadata(MARKDOWN_HEADING_COLLAPSED)) !== null && _b !== void 0 ? _b : false);
        this._showEditorForReadOnlyMarkdown =
            (_c = options.showEditorForReadOnlyMarkdown) !== null && _c !== void 0 ? _c : MarkdownCell.defaultShowEditorForReadOnlyMarkdown;
        // Defer setting placeholder as the renderer must be instantiated before initializing the DOM
        this.placeholder = (_d = options.placeholder) !== null && _d !== void 0 ? _d : true;
        this._monitor = new _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_17__.ActivityMonitor({
            signal: this.model.contentChanged,
            timeout: RENDER_TIMEOUT
        });
        // Throttle the rendering rate of the widget.
        this.ready
            .then(() => {
            if (this.isDisposed) {
                // Bail early
                return;
            }
            this._monitor.activityStopped.connect(() => {
                if (this._rendered) {
                    this.update();
                }
            }, this);
        })
            .catch(reason => {
            console.error('Failed to be ready', reason);
        });
    }
    /**
     * Text that represents the highest heading (i.e. lowest level) if cell is a heading.
     * Returns empty string if not a heading.
     */
    get headingInfo() {
        // Use table of content algorithm for consistency
        const headings = this.headings;
        if (headings.length > 0) {
            // Return the highest level
            const { text, level } = headings.reduce((prev, curr) => (prev.level <= curr.level ? prev : curr), headings[0]);
            return { text, level };
        }
        else {
            return { text: '', level: -1 };
        }
    }
    get headings() {
        if (!this._headingsCache) {
            // Use table of content algorithm for consistency
            const headings = _jupyterlab_toc__WEBPACK_IMPORTED_MODULE_13__.getHeadings(this.model.sharedModel.getSource());
            this._headingsCache = headings.map(h => {
                return { ...h, type: Cell.HeadingType.Markdown };
            });
        }
        return [...this._headingsCache];
    }
    /**
     * Whether the heading is collapsed or not.
     */
    get headingCollapsed() {
        return this._headingCollapsed;
    }
    set headingCollapsed(value) {
        var _a;
        if (this._headingCollapsed !== value) {
            this._headingCollapsed = value;
            if (value) {
                this.model.setMetadata(MARKDOWN_HEADING_COLLAPSED, value);
            }
            else if (this.model.getMetadata(MARKDOWN_HEADING_COLLAPSED) !== 'undefined') {
                this.model.deleteMetadata(MARKDOWN_HEADING_COLLAPSED);
            }
            const collapseButton = (_a = this.inputArea) === null || _a === void 0 ? void 0 : _a.promptNode.getElementsByClassName(HEADING_COLLAPSER_CLASS)[0];
            if (collapseButton) {
                if (value) {
                    collapseButton.classList.add('jp-mod-collapsed');
                }
                else {
                    collapseButton.classList.remove('jp-mod-collapsed');
                }
            }
            this.renderCollapseButtons(this._renderer);
            this._headingCollapsedChanged.emit(this._headingCollapsed);
        }
    }
    /**
     * Number of collapsed sub cells.
     */
    get numberChildNodes() {
        return this._numberChildNodes;
    }
    set numberChildNodes(value) {
        this._numberChildNodes = value;
        this.renderCollapseButtons(this._renderer);
    }
    /**
     * Signal emitted when the cell collapsed state changes.
     */
    get headingCollapsedChanged() {
        return this._headingCollapsedChanged;
    }
    /**
     * Whether the cell is rendered.
     */
    get rendered() {
        return this._rendered;
    }
    set rendered(value) {
        // Show cell as rendered when cell is not editable
        if (this.readOnly && this._showEditorForReadOnlyMarkdown === false) {
            value = true;
        }
        if (value === this._rendered) {
            return;
        }
        this._rendered = value;
        this._handleRendered()
            .then(() => {
            // If the rendered state changed, raise an event.
            this._displayChanged.emit();
            this._renderedChanged.emit(this._rendered);
        })
            .catch(reason => {
            console.error('Failed to render', reason);
        });
    }
    /**
     * Signal emitted when the markdown cell rendered state changes
     */
    get renderedChanged() {
        return this._renderedChanged;
    }
    /*
     * Whether the Markdown editor is visible in read-only mode.
     */
    get showEditorForReadOnly() {
        return this._showEditorForReadOnlyMarkdown;
    }
    set showEditorForReadOnly(value) {
        this._showEditorForReadOnlyMarkdown = value;
        if (value === false) {
            this.rendered = true;
        }
    }
    /**
     * Renderer
     */
    get renderer() {
        return this._renderer;
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._monitor.dispose();
        super.dispose();
    }
    /**
     * Create children widgets.
     */
    initializeDOM() {
        if (!this.placeholder) {
            return;
        }
        super.initializeDOM();
        this.renderCollapseButtons(this._renderer);
        this._handleRendered().catch(reason => {
            console.error('Failed to render', reason);
        });
    }
    maybeCreateCollapseButton() {
        var _a;
        const { level } = this.headingInfo;
        if (level > 0 &&
            ((_a = this.inputArea) === null || _a === void 0 ? void 0 : _a.promptNode.getElementsByClassName(HEADING_COLLAPSER_CLASS).length) == 0) {
            let collapseButton = this.inputArea.promptNode.appendChild(document.createElement('button'));
            collapseButton.className = `jp-Button ${HEADING_COLLAPSER_CLASS}`;
            collapseButton.setAttribute('data-heading-level', level.toString());
            if (this._headingCollapsed) {
                collapseButton.classList.add('jp-mod-collapsed');
            }
            else {
                collapseButton.classList.remove('jp-mod-collapsed');
            }
            collapseButton.onclick = (event) => {
                this.headingCollapsed = !this.headingCollapsed;
            };
        }
    }
    /**
     * Create, update or remove the hidden cells button.
     * Note that the actual visibility is controlled in Static Notebook by toggling jp-mod-showHiddenCellsButton class.
     */
    maybeCreateOrUpdateExpandButton() {
        const showHiddenCellsButtonList = this.node.getElementsByClassName(SHOW_HIDDEN_CELLS_CLASS);
        let trans = this.translator.load('jupyterlab');
        let buttonText = trans._n('%1 cell hidden', '%1 cells hidden', this._numberChildNodes);
        let needToCreateButton = this.headingCollapsed &&
            this._numberChildNodes > 0 &&
            showHiddenCellsButtonList.length == 0;
        if (needToCreateButton) {
            const newShowHiddenCellsButton = document.createElement('button');
            newShowHiddenCellsButton.className = `jp-mod-minimal jp-Button ${SHOW_HIDDEN_CELLS_CLASS}`;
            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_19__.addIcon.render(newShowHiddenCellsButton);
            const buttonTextElement = document.createElement('div');
            buttonTextElement.textContent = buttonText;
            newShowHiddenCellsButton.appendChild(buttonTextElement);
            newShowHiddenCellsButton.onclick = () => {
                this.headingCollapsed = false;
            };
            this.node.appendChild(newShowHiddenCellsButton);
        }
        let needToUpdateButtonText = this.headingCollapsed &&
            this._numberChildNodes > 0 &&
            showHiddenCellsButtonList.length == 1;
        if (needToUpdateButtonText) {
            showHiddenCellsButtonList[0].childNodes[1].textContent = buttonText;
        }
        let needToRemoveButton = !(this.headingCollapsed && this._numberChildNodes > 0);
        if (needToRemoveButton) {
            for (const button of showHiddenCellsButtonList) {
                this.node.removeChild(button);
            }
        }
    }
    /**
     * Callback on content changed
     */
    onContentChanged() {
        super.onContentChanged();
        this._headingsCache = null;
    }
    /**
     * Render the collapse button for heading cells,
     * and for collapsed heading cells render the "expand hidden cells"
     * button.
     */
    renderCollapseButtons(widget) {
        this.node.classList.toggle(MARKDOWN_HEADING_COLLAPSED, this._headingCollapsed);
        this.maybeCreateCollapseButton();
        this.maybeCreateOrUpdateExpandButton();
    }
    /**
     * Render an input instead of the text editor.
     */
    renderInput(widget) {
        this.addClass(RENDERED_CLASS);
        if (!this.placeholder && !this.isDisposed) {
            this.renderCollapseButtons(widget);
            this.inputArea.renderInput(widget);
        }
    }
    /**
     * Show the text editor instead of rendered input.
     */
    showEditor() {
        this.removeClass(RENDERED_CLASS);
        if (!this.placeholder && !this.isDisposed) {
            this.inputArea.showEditor();
            // if this is going to be a heading, place the cursor accordingly
            let numHashAtStart = (this.model.sharedModel
                .getSource()
                .match(/^#+/g) || [''])[0].length;
            if (numHashAtStart > 0) {
                this.inputArea.editor.setCursorPosition({
                    column: numHashAtStart + 1,
                    line: 0
                }, { scroll: false });
            }
        }
    }
    /*
     * Handle `update-request` messages.
     */
    onUpdateRequest(msg) {
        // Make sure we are properly rendered.
        this._handleRendered().catch(reason => {
            console.error('Failed to render', reason);
        });
        super.onUpdateRequest(msg);
    }
    /**
     * Modify the cell source to include a reference to the attachment.
     */
    updateCellSourceWithAttachment(attachmentName, URI) {
        var _a, _b;
        const textToBeAppended = `![${attachmentName}](attachment:${URI !== null && URI !== void 0 ? URI : attachmentName})`;
        // TODO this should be done on the model...
        (_b = (_a = this.editor) === null || _a === void 0 ? void 0 : _a.replaceSelection) === null || _b === void 0 ? void 0 : _b.call(_a, textToBeAppended);
    }
    /**
     * Handle the rendered state.
     */
    async _handleRendered() {
        if (!this._rendered) {
            this.showEditor();
        }
        else {
            // TODO: It would be nice for the cell to provide a way for
            // its consumers to hook into when the rendering is done.
            await this._updateRenderedInput();
            if (this._rendered) {
                // The rendered flag may be updated in the mean time
                this.renderInput(this._renderer);
            }
        }
    }
    /**
     * Update the rendered input.
     */
    _updateRenderedInput() {
        if (this.placeholder) {
            return Promise.resolve();
        }
        const model = this.model;
        const text = (model && model.sharedModel.getSource()) || DEFAULT_MARKDOWN_TEXT;
        // Do not re-render if the text has not changed.
        if (text !== this._prevText) {
            const mimeModel = new _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_20__.MimeModel({ data: { 'text/markdown': text } });
            this._prevText = text;
            return this._renderer.renderModel(mimeModel);
        }
        return Promise.resolve();
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            rendermime: this._rendermime,
            placeholder: false,
            translator: this.translator
        });
    }
}
/**
 * The namespace for the `CodeCell` class statics.
 */
(function (MarkdownCell) {
    /**
     * Default value for showEditorForReadOnlyMarkdown.
     */
    MarkdownCell.defaultShowEditorForReadOnlyMarkdown = true;
})(MarkdownCell || (MarkdownCell = {}));
/** ****************************************************************************
 * RawCell
 ******************************************************************************/
/**
 * A widget for a raw cell.
 */
class RawCell extends Cell {
    /**
     * Construct a raw cell widget.
     */
    constructor(options) {
        super(options);
        this.addClass(RAW_CELL_CLASS);
        const trans = this.translator.load('jupyterlab');
        this.node.setAttribute('aria-label', trans.__('Raw Cell Content'));
    }
    /**
     * Clone the cell, using the same model.
     */
    clone() {
        const constructor = this.constructor;
        return new constructor({
            model: this.model,
            contentFactory: this.contentFactory,
            placeholder: false,
            translator: this.translator
        });
    }
}
//# sourceMappingURL=widget.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/cells/node_modules/@lumino/coreutils/dist/index.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@jupyterlab/cells/node_modules/@lumino/coreutils/dist/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
     true ? factory(exports) :
    0;
})(this, (function (exports) { 'use strict';

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for JSON-specific functions.
     */
    exports.JSONExt = void 0;
    (function (JSONExt) {
        /**
         * A shared frozen empty JSONObject
         */
        JSONExt.emptyObject = Object.freeze({});
        /**
         * A shared frozen empty JSONArray
         */
        JSONExt.emptyArray = Object.freeze([]);
        /**
         * Test whether a JSON value is a primitive.
         *
         * @param value - The JSON value of interest.
         *
         * @returns `true` if the value is a primitive,`false` otherwise.
         */
        function isPrimitive(value) {
            return (value === null ||
                typeof value === 'boolean' ||
                typeof value === 'number' ||
                typeof value === 'string');
        }
        JSONExt.isPrimitive = isPrimitive;
        function isArray(value) {
            return Array.isArray(value);
        }
        JSONExt.isArray = isArray;
        function isObject(value) {
            return !isPrimitive(value) && !isArray(value);
        }
        JSONExt.isObject = isObject;
        /**
         * Compare two JSON values for deep equality.
         *
         * @param first - The first JSON value of interest.
         *
         * @param second - The second JSON value of interest.
         *
         * @returns `true` if the values are equivalent, `false` otherwise.
         */
        function deepEqual(first, second) {
            // Check referential and primitive equality first.
            if (first === second) {
                return true;
            }
            // If one is a primitive, the `===` check ruled out the other.
            if (isPrimitive(first) || isPrimitive(second)) {
                return false;
            }
            // Test whether they are arrays.
            let a1 = isArray(first);
            let a2 = isArray(second);
            // Bail if the types are different.
            if (a1 !== a2) {
                return false;
            }
            // If they are both arrays, compare them.
            if (a1 && a2) {
                return deepArrayEqual(first, second);
            }
            // At this point, they must both be objects.
            return deepObjectEqual(first, second);
        }
        JSONExt.deepEqual = deepEqual;
        /**
         * Create a deep copy of a JSON value.
         *
         * @param value - The JSON value to copy.
         *
         * @returns A deep copy of the given JSON value.
         */
        function deepCopy(value) {
            // Do nothing for primitive values.
            if (isPrimitive(value)) {
                return value;
            }
            // Deep copy an array.
            if (isArray(value)) {
                return deepArrayCopy(value);
            }
            // Deep copy an object.
            return deepObjectCopy(value);
        }
        JSONExt.deepCopy = deepCopy;
        /**
         * Compare two JSON arrays for deep equality.
         */
        function deepArrayEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Test the arrays for equal length.
            if (first.length !== second.length) {
                return false;
            }
            // Compare the values for equality.
            for (let i = 0, n = first.length; i < n; ++i) {
                if (!deepEqual(first[i], second[i])) {
                    return false;
                }
            }
            // At this point, the arrays are equal.
            return true;
        }
        /**
         * Compare two JSON objects for deep equality.
         */
        function deepObjectEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Check for the first object's keys in the second object.
            for (let key in first) {
                if (first[key] !== undefined && !(key in second)) {
                    return false;
                }
            }
            // Check for the second object's keys in the first object.
            for (let key in second) {
                if (second[key] !== undefined && !(key in first)) {
                    return false;
                }
            }
            // Compare the values for equality.
            for (let key in first) {
                // Get the values.
                let firstValue = first[key];
                let secondValue = second[key];
                // If both are undefined, ignore the key.
                if (firstValue === undefined && secondValue === undefined) {
                    continue;
                }
                // If only one value is undefined, the objects are not equal.
                if (firstValue === undefined || secondValue === undefined) {
                    return false;
                }
                // Compare the values.
                if (!deepEqual(firstValue, secondValue)) {
                    return false;
                }
            }
            // At this point, the objects are equal.
            return true;
        }
        /**
         * Create a deep copy of a JSON array.
         */
        function deepArrayCopy(value) {
            let result = new Array(value.length);
            for (let i = 0, n = value.length; i < n; ++i) {
                result[i] = deepCopy(value[i]);
            }
            return result;
        }
        /**
         * Create a deep copy of a JSON object.
         */
        function deepObjectCopy(value) {
            let result = {};
            for (let key in value) {
                // Ignore undefined values.
                let subvalue = value[key];
                if (subvalue === undefined) {
                    continue;
                }
                result[key] = deepCopy(subvalue);
            }
            return result;
        }
    })(exports.JSONExt || (exports.JSONExt = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * An object which stores MIME data for general application use.
     *
     * #### Notes
     * This class does not attempt to enforce "correctness" of MIME types
     * and their associated data. Since this class is designed to transfer
     * arbitrary data and objects within the same application, it assumes
     * that the user provides correct and accurate data.
     */
    class MimeData {
        constructor() {
            this._types = [];
            this._values = [];
        }
        /**
         * Get an array of the MIME types contained within the dataset.
         *
         * @returns A new array of the MIME types, in order of insertion.
         */
        types() {
            return this._types.slice();
        }
        /**
         * Test whether the dataset has an entry for the given type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns `true` if the dataset contains a value for the given
         *   MIME type, `false` otherwise.
         */
        hasData(mime) {
            return this._types.indexOf(mime) !== -1;
        }
        /**
         * Get the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns The value for the given MIME type, or `undefined` if
         *   the dataset does not contain a value for the type.
         */
        getData(mime) {
            let i = this._types.indexOf(mime);
            return i !== -1 ? this._values[i] : undefined;
        }
        /**
         * Set the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @param data - The data value for the given MIME type.
         *
         * #### Notes
         * This will overwrite any previous entry for the MIME type.
         */
        setData(mime, data) {
            this.clearData(mime);
            this._types.push(mime);
            this._values.push(data);
        }
        /**
         * Remove the data entry for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * #### Notes
         * This is a no-op if there is no entry for the given MIME type.
         */
        clearData(mime) {
            let i = this._types.indexOf(mime);
            if (i !== -1) {
                this._types.splice(i, 1);
                this._values.splice(i, 1);
            }
        }
        /**
         * Remove all data entries from the dataset.
         */
        clear() {
            this._types.length = 0;
            this._values.length = 0;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A class which wraps a promise into a delegate object.
     *
     * #### Notes
     * This class is useful when the logic to resolve or reject a promise
     * cannot be defined at the point where the promise is created.
     */
    class PromiseDelegate {
        /**
         * Construct a new promise delegate.
         */
        constructor() {
            this.promise = new Promise((resolve, reject) => {
                this._resolve = resolve;
                this._reject = reject;
            });
        }
        /**
         * Resolve the wrapped promise with the given value.
         *
         * @param value - The value to use for resolving the promise.
         */
        resolve(value) {
            let resolve = this._resolve;
            resolve(value);
        }
        /**
         * Reject the wrapped promise with the given value.
         *
         * @reason - The reason for rejecting the promise.
         */
        reject(reason) {
            let reject = this._reject;
            reject(reason);
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A runtime object which captures compile-time type information.
     *
     * #### Notes
     * A token captures the compile-time type of an interface or class in
     * an object which can be used at runtime in a type-safe fashion.
     */
    class Token {
        /**
         * Construct a new token.
         *
         * @param name - A human readable name for the token.
         * @param description - Token purpose description for documentation.
         */
        constructor(name, description) {
            this.name = name;
            this.description = description !== null && description !== void 0 ? description : '';
            this._tokenStructuralPropertyT = null;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    // Fallback
    function fallbackRandomValues(buffer) {
        let value = 0;
        for (let i = 0, n = buffer.length; i < n; ++i) {
            if (i % 4 === 0) {
                value = (Math.random() * 0xffffffff) >>> 0;
            }
            buffer[i] = value & 0xff;
            value >>>= 8;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for random number related functionality.
     */
    exports.Random = void 0;
    (function (Random) {
        /**
         * A function which generates random bytes.
         *
         * @param buffer - The `Uint8Array` to fill with random bytes.
         *
         * #### Notes
         * A cryptographically strong random number generator will be used if
         * available. Otherwise, `Math.random` will be used as a fallback for
         * randomness.
         *
         * The following RNGs are supported, listed in order of precedence:
         *   - `window.crypto.getRandomValues`
         *   - `window.msCrypto.getRandomValues`
         *   - `require('crypto').randomFillSync
         *   - `require('crypto').randomBytes
         *   - `Math.random`
         */
        Random.getRandomValues = (() => {
            // Look up the crypto module if available.
            const crypto = (typeof window !== 'undefined' && (window.crypto || window.msCrypto)) ||
                null;
            // Modern browsers and IE 11
            if (crypto && typeof crypto.getRandomValues === 'function') {
                return function getRandomValues(buffer) {
                    return crypto.getRandomValues(buffer);
                };
            }
            // Fallback
            return fallbackRandomValues;
        })();
    })(exports.Random || (exports.Random = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A function which creates a function that generates UUID v4 identifiers.
     *
     * @returns A new function that creates a UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    function uuid4Factory(getRandomValues) {
        // Create a 16 byte array to hold the random values.
        const bytes = new Uint8Array(16);
        // Create a look up table from bytes to hex strings.
        const lut = new Array(256);
        // Pad the single character hex digits with a leading zero.
        for (let i = 0; i < 16; ++i) {
            lut[i] = '0' + i.toString(16);
        }
        // Populate the rest of the hex digits.
        for (let i = 16; i < 256; ++i) {
            lut[i] = i.toString(16);
        }
        // Return a function which generates the UUID.
        return function uuid4() {
            // Get a new batch of random values.
            getRandomValues(bytes);
            // Set the UUID version number to 4.
            bytes[6] = 0x40 | (bytes[6] & 0x0f);
            // Set the clock sequence bit to the RFC spec.
            bytes[8] = 0x80 | (bytes[8] & 0x3f);
            // Assemble the UUID string.
            return (lut[bytes[0]] +
                lut[bytes[1]] +
                lut[bytes[2]] +
                lut[bytes[3]] +
                '-' +
                lut[bytes[4]] +
                lut[bytes[5]] +
                '-' +
                lut[bytes[6]] +
                lut[bytes[7]] +
                '-' +
                lut[bytes[8]] +
                lut[bytes[9]] +
                '-' +
                lut[bytes[10]] +
                lut[bytes[11]] +
                lut[bytes[12]] +
                lut[bytes[13]] +
                lut[bytes[14]] +
                lut[bytes[15]]);
        };
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for UUID related functionality.
     */
    exports.UUID = void 0;
    (function (UUID) {
        /**
         * A function which generates UUID v4 identifiers.
         *
         * @returns A new UUID v4 string.
         *
         * #### Notes
         * This implementation complies with RFC 4122.
         *
         * This uses `Random.getRandomValues()` for random bytes, which in
         * turn will use the underlying `crypto` module of the platform if
         * it is available. The fallback for randomness is `Math.random`.
         */
        UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
    })(exports.UUID || (exports.UUID = {}));

    exports.MimeData = MimeData;
    exports.PromiseDelegate = PromiseDelegate;
    exports.Token = Token;

}));
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@jupyterlab/codeeditor/lib/editor.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/codeeditor/lib/editor.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeEditor: () => (/* binding */ CodeEditor)
/* harmony export */ });
/* harmony import */ var _jupyter_ydoc__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyter/ydoc */ "./node_modules/@jupyter/ydoc/lib/index.js");
/* harmony import */ var _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/observables */ "./node_modules/@jupyterlab/observables/lib/observablemap.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * A namespace for code editors.
 *
 * #### Notes
 * - A code editor is a set of common assumptions which hold for all concrete editors.
 * - Changes in implementations of the code editor should only be caused by changes in concrete editors.
 * - Common JLab services which are based on the code editor should belong to `IEditorServices`.
 */
var CodeEditor;
(function (CodeEditor) {
    /**
     * The default implementation of the editor model.
     */
    class Model {
        /**
         * Construct a new Model.
         */
        constructor(options = {}) {
            var _a, _b;
            /**
             * Whether the model should disposed the shared model on disposal or not.
             */
            this.standaloneModel = false;
            this._isDisposed = false;
            this._selections = new _jupyterlab_observables__WEBPACK_IMPORTED_MODULE_2__.ObservableMap();
            this._mimeType = 'text/plain';
            this._mimeTypeChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
            // Track if we need to dispose the model or not.
            this.standaloneModel = typeof options.sharedModel === 'undefined';
            this.sharedModel = (_a = options.sharedModel) !== null && _a !== void 0 ? _a : new _jupyter_ydoc__WEBPACK_IMPORTED_MODULE_0__.YFile();
            this._mimeType = (_b = options.mimeType) !== null && _b !== void 0 ? _b : 'text/plain';
        }
        /**
         * A signal emitted when a mimetype changes.
         */
        get mimeTypeChanged() {
            return this._mimeTypeChanged;
        }
        /**
         * Get the selections for the model.
         */
        get selections() {
            return this._selections;
        }
        /**
         * A mime type of the model.
         */
        get mimeType() {
            return this._mimeType;
        }
        set mimeType(newValue) {
            const oldValue = this.mimeType;
            if (oldValue === newValue) {
                return;
            }
            this._mimeType = newValue;
            this._mimeTypeChanged.emit({
                name: 'mimeType',
                oldValue: oldValue,
                newValue: newValue
            });
        }
        /**
         * Whether the model is disposed.
         */
        get isDisposed() {
            return this._isDisposed;
        }
        /**
         * Dispose of the resources used by the model.
         */
        dispose() {
            if (this._isDisposed) {
                return;
            }
            this._isDisposed = true;
            this._selections.dispose();
            if (this.standaloneModel) {
                this.sharedModel.dispose();
            }
            _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);
        }
    }
    CodeEditor.Model = Model;
})(CodeEditor || (CodeEditor = {}));
//# sourceMappingURL=editor.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codeeditor/lib/mimetype.js":
/*!*************************************************************!*\
  !*** ./node_modules/@jupyterlab/codeeditor/lib/mimetype.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IEditorMimeTypeService: () => (/* binding */ IEditorMimeTypeService)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * A namespace for `IEditorMimeTypeService`.
 */
var IEditorMimeTypeService;
(function (IEditorMimeTypeService) {
    /**
     * The default mime type.
     */
    IEditorMimeTypeService.defaultMimeType = 'text/plain';
})(IEditorMimeTypeService || (IEditorMimeTypeService = {}));
//# sourceMappingURL=mimetype.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codeeditor/lib/widget.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/codeeditor/lib/widget.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeEditorWrapper: () => (/* binding */ CodeEditorWrapper)
/* harmony export */ });
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The class name added to an editor widget that has a primary selection.
 */
const HAS_SELECTION_CLASS = 'jp-mod-has-primary-selection';
/**
 * The class name added to an editor widget that has a cursor/selection
 * within the whitespace at the beginning of a line
 */
const HAS_IN_LEADING_WHITESPACE_CLASS = 'jp-mod-in-leading-whitespace';
/**
 * A class used to indicate a drop target.
 */
const DROP_TARGET_CLASS = 'jp-mod-dropTarget';
/**
 * RegExp to test for leading whitespace
 */
const leadingWhitespaceRe = /^\s+$/;
/**
 * A widget which hosts a code editor.
 */
class CodeEditorWrapper extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_0__.Widget {
    /**
     * Construct a new code editor widget.
     */
    constructor(options) {
        super();
        const { factory, model, editorOptions } = options;
        const editor = (this.editor = factory({
            host: this.node,
            model,
            ...editorOptions
        }));
        editor.model.selections.changed.connect(this._onSelectionsChanged, this);
    }
    /**
     * Get the model used by the widget.
     */
    get model() {
        return this.editor.model;
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this.editor.dispose();
        super.dispose();
    }
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the notebook panel's node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'lm-dragenter':
                this._evtDragEnter(event);
                break;
            case 'lm-dragleave':
                this._evtDragLeave(event);
                break;
            case 'lm-dragover':
                this._evtDragOver(event);
                break;
            case 'lm-drop':
                this._evtDrop(event);
                break;
            default:
                break;
        }
    }
    /**
     * Handle `'activate-request'` messages.
     */
    onActivateRequest(msg) {
        this.editor.focus();
    }
    /**
     * A message handler invoked on an `'after-attach'` message.
     */
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        const node = this.node;
        node.addEventListener('lm-dragenter', this);
        node.addEventListener('lm-dragleave', this);
        node.addEventListener('lm-dragover', this);
        node.addEventListener('lm-drop', this);
    }
    /**
     * Handle `before-detach` messages for the widget.
     */
    onBeforeDetach(msg) {
        const node = this.node;
        node.removeEventListener('lm-dragenter', this);
        node.removeEventListener('lm-dragleave', this);
        node.removeEventListener('lm-dragover', this);
        node.removeEventListener('lm-drop', this);
    }
    /**
     * Handle a change in model selections.
     */
    _onSelectionsChanged() {
        const { start, end } = this.editor.getSelection();
        if (start.column !== end.column || start.line !== end.line) {
            // a selection was made
            this.addClass(HAS_SELECTION_CLASS);
            this.removeClass(HAS_IN_LEADING_WHITESPACE_CLASS);
        }
        else {
            // the cursor was placed
            this.removeClass(HAS_SELECTION_CLASS);
            if (this.editor
                .getLine(end.line)
                .slice(0, end.column)
                .match(leadingWhitespaceRe)) {
                this.addClass(HAS_IN_LEADING_WHITESPACE_CLASS);
            }
            else {
                this.removeClass(HAS_IN_LEADING_WHITESPACE_CLASS);
            }
        }
    }
    /**
     * Handle the `'lm-dragenter'` event for the widget.
     */
    _evtDragEnter(event) {
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        this.addClass('jp-mod-dropTarget');
    }
    /**
     * Handle the `'lm-dragleave'` event for the widget.
     */
    _evtDragLeave(event) {
        this.removeClass(DROP_TARGET_CLASS);
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
    }
    /**
     * Handle the `'lm-dragover'` event for the widget.
     */
    _evtDragOver(event) {
        this.removeClass(DROP_TARGET_CLASS);
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        event.dropAction = 'copy';
        this.addClass(DROP_TARGET_CLASS);
    }
    /**
     * Handle the `'lm-drop'` event for the widget.
     */
    _evtDrop(event) {
        if (this.editor.getOption('readOnly') === true) {
            return;
        }
        const data = Private.findTextData(event.mimeData);
        if (data === undefined) {
            return;
        }
        const coordinate = {
            top: event.y,
            bottom: event.y,
            left: event.x,
            right: event.x,
            x: event.x,
            y: event.y,
            width: 0,
            height: 0
        };
        const position = this.editor.getPositionForCoordinate(coordinate);
        if (position === null) {
            return;
        }
        this.removeClass(DROP_TARGET_CLASS);
        event.preventDefault();
        event.stopPropagation();
        if (event.proposedAction === 'none') {
            event.dropAction = 'none';
            return;
        }
        const offset = this.editor.getOffsetAt(position);
        this.model.sharedModel.updateSource(offset, offset, data);
    }
}
/**
 * A namespace for private functionality.
 */
var Private;
(function (Private) {
    /**
     * Given a MimeData instance, extract the first text data, if any.
     */
    function findTextData(mime) {
        const types = mime.types();
        const textType = types.find(t => t.indexOf('text') === 0);
        if (textType === undefined) {
            return undefined;
        }
        return mime.getData(textType);
    }
    Private.findTextData = findTextData;
})(Private || (Private = {}));
//# sourceMappingURL=widget.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/commands.js":
/*!*************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/commands.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StateCommands: () => (/* binding */ StateCommands)
/* harmony export */ });
/* harmony import */ var _codemirror_commands__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @codemirror/commands */ "./node_modules/@codemirror/commands/dist/index.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/**
 * CodeMirror commands namespace
 */
var StateCommands;
(function (StateCommands) {
    /**
     * Indent or insert a tab as appropriate.
     */
    function indentMoreOrInsertTab(target) {
        const arg = { state: target.state, dispatch: target.dispatch };
        const from = target.state.selection.main.from;
        const to = target.state.selection.main.to;
        if (from != to) {
            return (0,_codemirror_commands__WEBPACK_IMPORTED_MODULE_0__.indentMore)(arg);
        }
        const line = target.state.doc.lineAt(from);
        const before = target.state.doc.slice(line.from, from).toString();
        if (/^\s*$/.test(before)) {
            return (0,_codemirror_commands__WEBPACK_IMPORTED_MODULE_0__.indentMore)(arg);
        }
        else {
            return (0,_codemirror_commands__WEBPACK_IMPORTED_MODULE_0__.insertTab)(arg);
        }
    }
    StateCommands.indentMoreOrInsertTab = indentMoreOrInsertTab;
})(StateCommands || (StateCommands = {}));
//# sourceMappingURL=commands.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/editor.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/editor.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeMirrorEditor: () => (/* binding */ CodeMirrorEditor)
/* harmony export */ });
/* harmony import */ var _codemirror_commands__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @codemirror/commands */ "./node_modules/@codemirror/commands/dist/index.js");
/* harmony import */ var _codemirror_language__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @codemirror/language */ "./node_modules/@codemirror/language/dist/index.js");
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @codemirror/state */ "./node_modules/@codemirror/state/dist/index.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/codemirror/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _extension__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./extension */ "./node_modules/@jupyterlab/codemirror/lib/extension.js");
/* harmony import */ var _language__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./language */ "./node_modules/@jupyterlab/codemirror/lib/language.js");
/* eslint-disable @typescript-eslint/ban-types */
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The class name added to CodeMirrorWidget instances.
 */
const EDITOR_CLASS = 'jp-CodeMirrorEditor';
/**
 * The key code for the up arrow key.
 */
const UP_ARROW = 38;
/**
 * The key code for the down arrow key.
 */
const DOWN_ARROW = 40;
/**
 * CodeMirror editor.
 */
class CodeMirrorEditor {
    /**
     * Construct a CodeMirror editor.
     */
    constructor(options) {
        var _a, _b, _c, _d, _e, _f;
        /**
         * A signal emitted when either the top or bottom edge is requested.
         */
        this.edgeRequested = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._isDisposed = false;
        this._language = new _codemirror_state__WEBPACK_IMPORTED_MODULE_4__.Compartment();
        this._uuid = '';
        this._languages = (_a = options.languages) !== null && _a !== void 0 ? _a : new _language__WEBPACK_IMPORTED_MODULE_3__.EditorLanguageRegistry();
        this._configurator =
            (_d = (_b = options.extensionsRegistry) === null || _b === void 0 ? void 0 : _b.createNew({
                ...options,
                inline: (_c = options.inline) !== null && _c !== void 0 ? _c : false
            })) !== null && _d !== void 0 ? _d : new _extension__WEBPACK_IMPORTED_MODULE_2__.ExtensionsHandler();
        const host = (this.host = options.host);
        host.classList.add(EDITOR_CLASS);
        host.classList.add('jp-Editor');
        host.addEventListener('focus', this, true);
        host.addEventListener('blur', this, true);
        host.addEventListener('scroll', this, true);
        this._uuid = (_e = options.uuid) !== null && _e !== void 0 ? _e : _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.UUID.uuid4();
        const model = (this._model = options.model);
        // Default keydown handler - it will have low priority
        const onKeyDown = _codemirror_view__WEBPACK_IMPORTED_MODULE_5__.EditorView.domEventHandlers({
            keydown: (event, view) => {
                return this.onKeydown(event);
            }
        });
        const updateListener = _codemirror_view__WEBPACK_IMPORTED_MODULE_5__.EditorView.updateListener.of((update) => {
            this._onDocChanged(update);
        });
        this._editor = Private.createEditor(host, this._configurator, [
            // We need to set the order to high, otherwise the keybinding for ArrowUp/ArrowDown
            // will process the event shunting our edge detection code.
            _codemirror_state__WEBPACK_IMPORTED_MODULE_4__.Prec.high(onKeyDown),
            updateListener,
            // Initialize with empty extension
            this._language.of([]),
            ...((_f = options.extensions) !== null && _f !== void 0 ? _f : [])
        ], model.sharedModel.source);
        this._onMimeTypeChanged();
        this._onCursorActivity();
        this._configurator.configChanged.connect(this.onConfigChanged, this);
        model.mimeTypeChanged.connect(this._onMimeTypeChanged, this);
    }
    /**
     * The uuid of this editor;
     */
    get uuid() {
        return this._uuid;
    }
    set uuid(value) {
        this._uuid = value;
    }
    /**
     * Get the codemirror editor wrapped by the editor.
     */
    get editor() {
        return this._editor;
    }
    /**
     * Get the codemirror doc wrapped by the widget.
     */
    get doc() {
        return this._editor.state.doc;
    }
    /**
     * Get the number of lines in the editor.
     */
    get lineCount() {
        return this.doc.lines;
    }
    /**
     * Returns a model for this editor.
     */
    get model() {
        return this._model;
    }
    /**
     * The height of a line in the editor in pixels.
     */
    get lineHeight() {
        return this._editor.defaultLineHeight;
    }
    /**
     * The widget of a character in the editor in pixels.
     */
    get charWidth() {
        return this._editor.defaultCharacterWidth;
    }
    /**
     * Tests whether the editor is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the widget.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this.host.removeEventListener('focus', this, true);
        this.host.removeEventListener('blur', this, true);
        this.host.removeEventListener('scroll', this, true);
        this._configurator.dispose();
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);
        this.editor.destroy();
    }
    /**
     * Get a config option for the editor.
     */
    getOption(option) {
        return this._configurator.getOption(option);
    }
    /**
     * Whether the option exists or not.
     */
    hasOption(option) {
        return this._configurator.hasOption(option);
    }
    /**
     * Set a config option for the editor.
     */
    setOption(option, value) {
        this._configurator.setOption(option, value);
    }
    /**
     * Set config options for the editor.
     *
     * This method is preferred when setting several options. The
     * options are set within an operation, which only performs
     * the costly update at the end, and not after every option
     * is set.
     */
    setOptions(options) {
        this._configurator.setOptions(options);
    }
    /**
     * Inject an extension into the editor
     *
     * @alpha
     * @experimental
     * @param ext CodeMirror 6 extension
     */
    injectExtension(ext) {
        this._configurator.injectExtension(this._editor, ext);
    }
    /**
     * Returns the content for the given line number.
     */
    getLine(line) {
        // TODO: CM6 remove +1 when CM6 first line number has propagated
        line = line + 1;
        return line <= this.doc.lines ? this.doc.line(line).text : undefined;
    }
    /**
     * Find an offset for the given position.
     */
    getOffsetAt(position) {
        // TODO: CM6 remove +1 when CM6 first line number has propagated
        return this.doc.line(position.line + 1).from + position.column;
    }
    /**
     * Find a position for the given offset.
     */
    getPositionAt(offset) {
        // TODO: CM6 remove -1 when CM6 first line number has propagated
        const line = this.doc.lineAt(offset);
        return { line: line.number - 1, column: offset - line.from };
    }
    /**
     * Undo one edit (if any undo events are stored).
     */
    undo() {
        this.model.sharedModel.undo();
    }
    /**
     * Redo one undone edit.
     */
    redo() {
        this.model.sharedModel.redo();
    }
    /**
     * Clear the undo history.
     */
    clearHistory() {
        this.model.sharedModel.clearUndoHistory();
    }
    /**
     * Brings browser focus to this editor text.
     */
    focus() {
        this._editor.focus();
    }
    /**
     * Test whether the editor has keyboard focus.
     */
    hasFocus() {
        return this._editor.hasFocus;
    }
    /**
     * Explicitly blur the editor.
     */
    blur() {
        this._editor.contentDOM.blur();
    }
    get state() {
        return this._editor.state;
    }
    firstLine() {
        // TODO: return 1 when CM6 first line number has propagated
        return 0;
    }
    lastLine() {
        return this.doc.lines - 1;
    }
    cursorCoords(where, mode) {
        const selection = this.state.selection.main;
        const pos = where ? selection.from : selection.to;
        const rect = this.editor.coordsAtPos(pos);
        return rect;
    }
    getRange(from, to, separator) {
        const fromOffset = this.getOffsetAt(this._toPosition(from));
        const toOffset = this.getOffsetAt(this._toPosition(to));
        return this.state.sliceDoc(fromOffset, toOffset);
    }
    /**
     * Reveal the given position in the editor.
     */
    revealPosition(position) {
        const offset = this.getOffsetAt(position);
        this._editor.dispatch({
            effects: _codemirror_view__WEBPACK_IMPORTED_MODULE_5__.EditorView.scrollIntoView(offset)
        });
    }
    /**
     * Reveal the given selection in the editor.
     */
    revealSelection(selection) {
        const start = this.getOffsetAt(selection.start);
        const end = this.getOffsetAt(selection.end);
        this._editor.dispatch({
            effects: _codemirror_view__WEBPACK_IMPORTED_MODULE_5__.EditorView.scrollIntoView(_codemirror_state__WEBPACK_IMPORTED_MODULE_4__.EditorSelection.range(start, end))
        });
    }
    /**
     * Get the window coordinates given a cursor position.
     */
    getCoordinateForPosition(position) {
        const offset = this.getOffsetAt(position);
        const rect = this.editor.coordsAtPos(offset);
        return rect;
    }
    /**
     * Get the cursor position given window coordinates.
     *
     * @param coordinate - The desired coordinate.
     *
     * @returns The position of the coordinates, or null if not
     *   contained in the editor.
     */
    getPositionForCoordinate(coordinate) {
        const offset = this.editor.posAtCoords({
            x: coordinate.left,
            y: coordinate.top
        });
        return this.getPositionAt(offset) || null;
    }
    /**
     * Returns the primary position of the cursor, never `null`.
     */
    getCursorPosition() {
        const offset = this.state.selection.main.head;
        return this.getPositionAt(offset);
    }
    /**
     * Set the primary position of the cursor.
     *
     * #### Notes
     * This will remove any secondary cursors.
     *
     * @deprecated options bias and origin are not used
     */
    setCursorPosition(position, options = {}) {
        const offset = this.getOffsetAt(position);
        this.editor.dispatch({
            selection: { anchor: offset },
            scrollIntoView: options.scroll === false ? false : true
        });
        // If the editor does not have focus, this cursor change
        // will get screened out in _onCursorsChanged(). Make an
        // exception for this method.
        if (!this.editor.hasFocus) {
            this.model.selections.set(this.uuid, this.getSelections());
        }
    }
    /**
     * Returns the primary selection, never `null`.
     */
    getSelection() {
        return this.getSelections()[0];
    }
    /**
     * Set the primary selection. This will remove any secondary cursors.
     */
    setSelection(selection) {
        this.setSelections([selection]);
    }
    /**
     * Gets the selections for all the cursors, never `null` or empty.
     */
    getSelections() {
        const selections = this.state.selection.ranges; //= [{anchor: number, head: number}]
        if (selections.length > 0) {
            const sel = selections.map(r => ({
                anchor: this._toCodeMirrorPosition(this.getPositionAt(r.from)),
                head: this._toCodeMirrorPosition(this.getPositionAt(r.to))
            }));
            return sel.map(selection => this._toSelection(selection));
        }
        const cursor = this._toCodeMirrorPosition(this.getPositionAt(this.state.selection.main.head));
        const selection = this._toSelection({ anchor: cursor, head: cursor });
        return [selection];
    }
    /**
     * Sets the selections for all the cursors, should not be empty.
     * Cursors will be removed or added, as necessary.
     * Passing an empty array resets a cursor position to the start of a document.
     */
    setSelections(selections) {
        const sel = selections.length
            ? selections.map(r => _codemirror_state__WEBPACK_IMPORTED_MODULE_4__.EditorSelection.range(this.getOffsetAt(r.start), this.getOffsetAt(r.end)))
            : [_codemirror_state__WEBPACK_IMPORTED_MODULE_4__.EditorSelection.range(0, 0)];
        this.editor.dispatch({ selection: _codemirror_state__WEBPACK_IMPORTED_MODULE_4__.EditorSelection.create(sel) });
    }
    /**
     * Replaces the current selection with the given text.
     *
     * Behaviour for multiple selections is undefined.
     *
     * @param text The text to be inserted.
     */
    replaceSelection(text) {
        const firstSelection = this.getSelections()[0];
        this.model.sharedModel.updateSource(this.getOffsetAt(firstSelection.start), this.getOffsetAt(firstSelection.end), text);
        const newPosition = this.getPositionAt(this.getOffsetAt(firstSelection.start) + text.length);
        this.setSelection({ start: newPosition, end: newPosition });
    }
    /**
     * Get a list of tokens for the current editor text content.
     */
    getTokens() {
        const tokens = [];
        const tree = (0,_codemirror_language__WEBPACK_IMPORTED_MODULE_6__.ensureSyntaxTree)(this.state, this.doc.length);
        if (tree) {
            tree.iterate({
                enter: (ref) => {
                    if (ref.node.firstChild === null) {
                        tokens.push({
                            value: this.state.sliceDoc(ref.from, ref.to),
                            offset: ref.from,
                            type: ref.name
                        });
                    }
                    return true;
                }
            });
        }
        return tokens;
    }
    /**
     * Get the token at a given editor position.
     */
    getTokenAt(offset) {
        const tree = (0,_codemirror_language__WEBPACK_IMPORTED_MODULE_6__.ensureSyntaxTree)(this.state, offset);
        let token = null;
        if (tree) {
            tree.iterate({
                enter: (ref) => {
                    // If a token has already been discovered, stop iterating.
                    if (token) {
                        return false;
                    }
                    // If it is not a leaf, keep iterating.
                    if (ref.node.firstChild) {
                        return true;
                    }
                    // If the relevant leaf token has been found, stop iterating.
                    if (offset >= ref.from && offset <= ref.to) {
                        token = {
                            value: this.state.sliceDoc(ref.from, ref.to),
                            offset: ref.from,
                            type: ref.name
                        };
                        return false;
                    }
                    return true;
                }
            });
        }
        return token || { offset, value: '' };
    }
    /**
     * Get the token a the cursor position.
     */
    getTokenAtCursor() {
        return this.getTokenAt(this.state.selection.main.head);
    }
    /**
     * Insert a new indented line at the current cursor position.
     */
    newIndentedLine() {
        (0,_codemirror_commands__WEBPACK_IMPORTED_MODULE_7__.insertNewlineAndIndent)({
            state: this.state,
            dispatch: this.editor.dispatch
        });
    }
    /**
     * Execute a codemirror command on the editor.
     *
     * @param command - The name of the command to execute.
     */
    execCommand(command) {
        command(this.editor);
    }
    onConfigChanged(configurator, changes) {
        configurator.reconfigureExtensions(this._editor, changes);
    }
    /**
     * Handle keydown events from the editor.
     */
    onKeydown(event) {
        const position = this.state.selection.main.head;
        if (position === 0 && event.keyCode === UP_ARROW) {
            if (!event.shiftKey) {
                this.edgeRequested.emit('top');
            }
            return false;
        }
        const line = this.doc.lineAt(position).number;
        if (line === 1 && event.keyCode === UP_ARROW) {
            if (!event.shiftKey) {
                this.edgeRequested.emit('topLine');
            }
            return false;
        }
        const length = this.doc.length;
        if (position === length && event.keyCode === DOWN_ARROW) {
            if (!event.shiftKey) {
                this.edgeRequested.emit('bottom');
            }
            return false;
        }
        return false;
    }
    /**
     * Handles a mime type change.
     */
    _onMimeTypeChanged() {
        // TODO: should we provide a hook for when the mode is done being set?
        this._languages
            .getLanguage(this._model.mimeType)
            .then(language => {
            var _a;
            this._editor.dispatch({
                effects: this._language.reconfigure((_a = language === null || language === void 0 ? void 0 : language.support) !== null && _a !== void 0 ? _a : [])
            });
        })
            .catch(reason => {
            console.log(`Failed to load language for '${this._model.mimeType}'.`, reason);
            this._editor.dispatch({
                effects: this._language.reconfigure([])
            });
        });
    }
    /**
     * Handles a cursor activity event.
     */
    _onCursorActivity() {
        // Only add selections if the editor has focus. This avoids unwanted
        // triggering of cursor activity due to collaborator actions.
        if (this._editor.hasFocus) {
            const selections = this.getSelections();
            this.model.selections.set(this.uuid, selections);
        }
    }
    /**
     * Converts a code mirror selection to an editor selection.
     */
    _toSelection(selection) {
        return {
            uuid: this.uuid,
            start: this._toPosition(selection.anchor),
            end: this._toPosition(selection.head)
        };
    }
    /**
     * Convert a code mirror position to an editor position.
     */
    _toPosition(position) {
        return {
            line: position.line,
            column: position.ch
        };
    }
    /**
     * Convert an editor position to a code mirror position.
     */
    _toCodeMirrorPosition(position) {
        return {
            line: position.line,
            ch: position.column
        };
    }
    /**
     * Handles document changes.
     */
    _onDocChanged(update) {
        if (update.transactions.length && update.transactions[0].selection) {
            this._onCursorActivity();
        }
    }
    /**
     * Handle the DOM events for the editor.
     *
     * @param event - The DOM event sent to the editor.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the editor's DOM node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        switch (event.type) {
            case 'focus':
                this._evtFocus(event);
                break;
            case 'blur':
                this._evtBlur(event);
                break;
            default:
                break;
        }
    }
    /**
     * Handle `focus` events for the editor.
     */
    _evtFocus(event) {
        this.host.classList.add('jp-mod-focused');
        // Update the selections on editor gaining focus because
        // the onCursorActivity function filters usual cursor events
        // based on the editor's focus.
        this._onCursorActivity();
    }
    /**
     * Handle `blur` events for the editor.
     */
    _evtBlur(event) {
        this.host.classList.remove('jp-mod-focused');
    }
}
/**
 * The namespace for module private data.
 */
var Private;
(function (Private) {
    function createEditor(host, editorConfig, additionalExtensions, doc) {
        const extensions = editorConfig.getInitialExtensions();
        extensions.push(...additionalExtensions);
        const view = new _codemirror_view__WEBPACK_IMPORTED_MODULE_5__.EditorView({
            state: _codemirror_state__WEBPACK_IMPORTED_MODULE_4__.EditorState.create({
                doc,
                extensions
            }),
            parent: host
        });
        return view;
    }
    Private.createEditor = createEditor;
})(Private || (Private = {}));
//# sourceMappingURL=editor.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/extension.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/extension.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EditorExtensionRegistry: () => (/* binding */ EditorExtensionRegistry),
/* harmony export */   ExtensionsHandler: () => (/* binding */ ExtensionsHandler)
/* harmony export */ });
/* harmony import */ var _codemirror_autocomplete__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @codemirror/autocomplete */ "./node_modules/@codemirror/autocomplete/dist/index.js");
/* harmony import */ var _codemirror_commands__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @codemirror/commands */ "./node_modules/@codemirror/commands/dist/index.js");
/* harmony import */ var _codemirror_language__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @codemirror/language */ "./node_modules/@codemirror/language/dist/index.js");
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @codemirror/state */ "./node_modules/@codemirror/state/dist/index.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/codemirror/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./commands */ "./node_modules/@jupyterlab/codemirror/lib/commands.js");
/* harmony import */ var _extensions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./extensions */ "./node_modules/@jupyterlab/codemirror/lib/extensions/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.










/**
 * The class name added to read only editor widgets.
 */
const READ_ONLY_CLASS = 'jp-mod-readOnly';
/**
 * Editor configuration handler
 *
 * It stores the editor configuration and the editor extensions.
 * It also allows to inject new extensions into an editor.
 */
class ExtensionsHandler {
    constructor({ baseConfiguration, config, defaultExtensions } = {}) {
        this._configChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);
        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);
        this._isDisposed = false;
        this._immutables = new Set();
        this._baseConfig = baseConfiguration !== null && baseConfiguration !== void 0 ? baseConfiguration : {};
        this._config = config !== null && config !== void 0 ? config : {};
        this._configurableBuilderMap = new Map(defaultExtensions);
        const configurables = Object.keys(this._config).concat(Object.keys(this._baseConfig));
        this._immutables = new Set([...this._configurableBuilderMap.keys()].filter(key => !configurables.includes(key)));
    }
    /**
     * Signal triggered when the editor configuration changes.
     * It provides the mapping of the new configuration (only those that changed).
     *
     * It should result in a call to `IExtensionsHandler.reconfigureExtensions`.
     */
    get configChanged() {
        return this._configChanged;
    }
    /**
     * A signal emitted when the object is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Tests whether the object is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the object.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this._disposed.emit();
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal.clearData(this);
    }
    /**
     * Get a config option for the editor.
     */
    getOption(option) {
        var _a;
        return (_a = this._config[option]) !== null && _a !== void 0 ? _a : this._baseConfig[option];
    }
    /**
     * Whether the option exists or not.
     */
    hasOption(option) {
        return (Object.keys(this._config).includes(option) ||
            Object.keys(this._baseConfig).includes(option));
    }
    /**
     * Set a config option for the editor.
     *
     * You will need to reconfigure the editor extensions by listening
     * to `IExtensionsHandler.configChanged`.
     */
    setOption(option, value) {
        // Don't bother setting the option if it is already the same.
        if (this._config[option] !== value) {
            this._config[option] = value;
            this._configChanged.emit({ [option]: value });
        }
    }
    /**
     * Set a base config option for the editor.
     *
     * You will need to reconfigure the editor extensions by listening
     * to `IExtensionsHandler.configChanged`.
     */
    setBaseOptions(options) {
        const changed = this._getChangedOptions(options, this._baseConfig);
        if (changed.length > 0) {
            this._baseConfig = options;
            const customizedKeys = Object.keys(this._config);
            const notOverridden = changed.filter(k => !customizedKeys.includes(k));
            if (notOverridden.length > 0) {
                this._configChanged.emit(notOverridden.reduce((agg, key) => {
                    agg[key] = this._baseConfig[key];
                    return agg;
                }, {}));
            }
        }
    }
    /**
     * Set config options for the editor.
     *
     * You will need to reconfigure the editor extensions by listening
     * to `EditorHandler.configChanged`.
     *
     * This method is preferred when setting several options. The
     * options are set within an operation, which only performs
     * the costly update at the end, and not after every option
     * is set.
     */
    setOptions(options) {
        const changed = this._getChangedOptions(options, this._config);
        if (changed.length > 0) {
            this._config = { ...options };
            this._configChanged.emit(changed.reduce((agg, key) => {
                var _a;
                agg[key] = (_a = this._config[key]) !== null && _a !== void 0 ? _a : this._baseConfig[key];
                return agg;
            }, {}));
        }
    }
    /**
     * Reconfigures the extension mapped with key with the provided value.
     *
     * @param view Editor view
     * @param key Parameter unique key
     * @param value Parameter value to be applied
     */
    reconfigureExtension(view, key, value) {
        const effect = this.getEffect(view.state, key, value);
        if (effect) {
            view.dispatch({
                effects: [effect]
            });
        }
    }
    /**
     * Reconfigures all the extensions mapped with the options from the
     * provided partial configuration.
     *
     * @param view Editor view
     * @param configuration Editor configuration
     */
    reconfigureExtensions(view, configuration) {
        const effects = Object.keys(configuration)
            .filter(key => this.has(key))
            .map(key => this.getEffect(view.state, key, configuration[key]));
        view.dispatch({
            effects: effects.filter(effect => effect !== null)
        });
    }
    /**
     * Appends extensions to the top-level configuration of the
     * editor.
     *
     * Injected extension cannot be removed.
     *
     * ### Notes
     * You should prefer registering a IEditorExtensionFactory instead
     * of this feature.
     *
     * @alpha
     * @param view Editor view
     * @param extension Editor extension to inject
     */
    injectExtension(view, extension) {
        view.dispatch({
            effects: _codemirror_state__WEBPACK_IMPORTED_MODULE_5__.StateEffect.appendConfig.of(extension)
        });
    }
    /**
     * Returns the list of initial extensions of an editor
     * based on the configuration.
     *
     * @returns The initial editor extensions
     */
    getInitialExtensions() {
        const configuration = { ...this._baseConfig, ...this._config };
        const extensions = [...this._immutables]
            .map(key => { var _a; return (_a = this.get(key)) === null || _a === void 0 ? void 0 : _a.instance(undefined); })
            .filter(ext => ext);
        for (const k of Object.keys(configuration)) {
            const builder = this.get(k);
            if (builder) {
                const value = configuration[k];
                extensions.push(builder.instance(value));
            }
        }
        return extensions;
    }
    /**
     * Get a extension builder
     * @param key Extension unique identifier
     * @returns The extension builder
     */
    get(key) {
        return this._configurableBuilderMap.get(key);
    }
    /**
     * Whether the editor has an extension for the identifier.
     *
     * @param key Extension unique identifier
     * @returns Extension existence
     */
    has(key) {
        return this._configurableBuilderMap.has(key);
    }
    getEffect(state, key, value) {
        var _a;
        const builder = this.get(key);
        return (_a = builder === null || builder === void 0 ? void 0 : builder.reconfigure(value)) !== null && _a !== void 0 ? _a : null;
    }
    _getChangedOptions(newConfig, oldConfig) {
        const changed = new Array();
        const newKeys = new Array();
        for (const [key, value] of Object.entries(newConfig)) {
            newKeys.push(key);
            if (oldConfig[key] !== value) {
                changed.push(key);
            }
        }
        // Add removed old keys
        changed.push(...Object.keys(oldConfig).filter(k => !newKeys.includes(k)));
        return changed;
    }
}
/**
 * CodeMirror extensions registry
 */
class EditorExtensionRegistry {
    constructor() {
        this.configurationBuilder = new Map();
        this.configurationSchema = {};
        this.defaultOptions = {};
        this.handlers = new Set();
        this.immutableExtensions = new Set();
        this._baseConfiguration = {};
    }
    /**
     * Base editor configuration
     *
     * This is the default configuration optionally modified by the user;
     * e.g. through user settings.
     */
    get baseConfiguration() {
        return { ...this.defaultOptions, ...this._baseConfiguration };
    }
    set baseConfiguration(v) {
        if (!_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(v, this._baseConfiguration)) {
            this._baseConfiguration = v;
            for (const handler of this.handlers) {
                handler.setBaseOptions(this.baseConfiguration);
            }
        }
    }
    /**
     * Default editor configuration
     *
     * This is the default configuration as defined when extensions
     * are registered.
     */
    get defaultConfiguration() {
        // Only options with schema should be JSON serializable
        // So we cannot use `JSONExt.deepCopy` on the default options.
        return Object.freeze({ ...this.defaultOptions });
    }
    /**
     * Editor configuration JSON schema
     */
    get settingsSchema() {
        return Object.freeze(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepCopy(this.configurationSchema));
    }
    /**
     * Add a default editor extension
     *
     * @template T Extension parameter type
     * @param factory Extension factory
     */
    addExtension(factory) {
        var _a;
        if (this.configurationBuilder.has(factory.name)) {
            throw new Error(`Extension named ${factory.name} is already registered.`);
        }
        this.configurationBuilder.set(factory.name, factory);
        if (typeof factory.default != 'undefined') {
            this.defaultOptions[factory.name] = factory.default;
        }
        if (factory.schema) {
            this.configurationSchema[factory.name] = {
                default: (_a = factory.default) !== null && _a !== void 0 ? _a : null,
                ...factory.schema
            };
            this.defaultOptions[factory.name] =
                this.configurationSchema[factory.name].default;
        }
    }
    /**
     * Create a new extensions handler for an editor
     *
     * @param options Extensions options and initial editor configuration
     */
    createNew(options) {
        const configuration = new Array();
        for (const [key, builder] of this.configurationBuilder.entries()) {
            const extension = builder.factory(options);
            if (extension) {
                configuration.push([key, extension]);
            }
        }
        const handler = new ExtensionsHandler({
            baseConfiguration: this.baseConfiguration,
            config: options.config,
            defaultExtensions: configuration
        });
        this.handlers.add(handler);
        handler.disposed.connect(() => {
            this.handlers.delete(handler);
        });
        return handler;
    }
}
/**
 * Editor extension registry namespace
 */
(function (EditorExtensionRegistry) {
    /**
     * Dynamically configurable editor extension.
     */
    class ConfigurableExtension {
        /**
         * Create a dynamic editor extension.
         *
         * @param builder Extension builder
         */
        constructor(builder) {
            this._compartment = new _codemirror_state__WEBPACK_IMPORTED_MODULE_5__.Compartment();
            this._builder = builder;
        }
        /**
         * Create an editor extension for the provided value.
         *
         * @param value Editor extension parameter value
         * @returns The editor extension
         */
        instance(value) {
            return this._compartment.of(this._builder(value));
        }
        /**
         * Reconfigure an editor extension.
         *
         * @param value Editor extension value
         * @returns Editor state effect
         */
        reconfigure(value) {
            return this._compartment.reconfigure(this._builder(value));
        }
    }
    /**
     * Immutable editor extension class
     */
    class ImmutableExtension {
        /**
         * Create an immutable editor extension.
         *
         * @param extension Extension
         */
        constructor(extension) {
            this._extension = extension;
        }
        /**
         * Create an editor extension.
         *
         * @returns The editor extension
         */
        instance() {
            return this._extension;
        }
        /**
         * Reconfigure an editor extension.
         *
         * This is a no-op
         */
        reconfigure() {
            // This is a no-op
            return null;
        }
    }
    /**
     * Creates a dynamically configurable editor extension.
     *
     * @param builder Extension builder
     * @return The extension
     */
    function createConfigurableExtension(builder) {
        return new ConfigurableExtension(builder);
    }
    EditorExtensionRegistry.createConfigurableExtension = createConfigurableExtension;
    /**
     * Creates a configurable extension returning
     * one of two extensions depending on a boolean value.
     *
     * @param truthy Extension to apply when the parameter is true
     * @param falsy Extension to apply when the parameter is false
     * @return The extension
     */
    function createConditionalExtension(truthy, falsy = []) {
        return new ConfigurableExtension(value => value ? truthy : falsy);
    }
    EditorExtensionRegistry.createConditionalExtension = createConditionalExtension;
    /**
     * Creates an immutable extension.
     *
     * @param extension Immutable extension
     * @return The extension
     */
    function createImmutableExtension(extension) {
        return new ImmutableExtension(extension);
    }
    EditorExtensionRegistry.createImmutableExtension = createImmutableExtension;
    /**
     * Get the default editor extensions.
     *
     * @returns CodeMirror 6 extension factories
     */
    function getDefaultExtensions(options = {}) {
        const { themes, translator } = options;
        const trans = (translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');
        const extensions = [
            Object.freeze({
                name: 'autoClosingBrackets',
                default: false,
                factory: () => createConditionalExtension((0,_codemirror_autocomplete__WEBPACK_IMPORTED_MODULE_6__.closeBrackets)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Auto Closing Brackets')
                }
            }),
            Object.freeze({
                name: 'codeFolding',
                default: false,
                factory: () => createConditionalExtension((0,_codemirror_language__WEBPACK_IMPORTED_MODULE_7__.foldGutter)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Code Folding')
                }
            }),
            Object.freeze({
                name: 'cursorBlinkRate',
                default: 1200,
                factory: () => createConfigurableExtension((value) => (0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.drawSelection)({ cursorBlinkRate: value })),
                schema: {
                    type: 'number',
                    title: trans.__('Cursor blinking rate'),
                    description: trans.__('Half-period in milliseconds used for cursor blinking. The default blink rate is 1200ms. By setting this to zero, blinking can be disabled.')
                }
            }),
            Object.freeze({
                name: 'highlightActiveLine',
                default: false,
                factory: () => createConditionalExtension((0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.highlightActiveLine)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Highlight the active line')
                }
            }),
            Object.freeze({
                name: 'highlightTrailingWhitespace',
                default: false,
                factory: () => createConditionalExtension((0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.highlightTrailingWhitespace)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Highlight trailing white spaces')
                }
            }),
            Object.freeze({
                name: 'highlightWhitespace',
                default: false,
                factory: () => createConditionalExtension((0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.highlightWhitespace)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Highlight white spaces')
                }
            }),
            Object.freeze({
                name: 'indentUnit',
                default: '4',
                factory: () => createConfigurableExtension((value) => value == 'Tab'
                    ? _codemirror_language__WEBPACK_IMPORTED_MODULE_7__.indentUnit.of('\t')
                    : _codemirror_language__WEBPACK_IMPORTED_MODULE_7__.indentUnit.of(' '.repeat(parseInt(value, 10)))),
                schema: {
                    type: 'string',
                    title: trans.__('Indentation unit'),
                    description: trans.__('The indentation is a `Tab` or the number of spaces. This defaults to 4 spaces.'),
                    enum: ['Tab', '1', '2', '4', '8']
                }
            }),
            // Default keyboard shortcuts
            // TODO at some point we may want to get this configurable
            Object.freeze({
                name: 'keymap',
                default: [
                    ..._codemirror_commands__WEBPACK_IMPORTED_MODULE_9__.defaultKeymap,
                    {
                        key: 'Tab',
                        run: _commands__WEBPACK_IMPORTED_MODULE_3__.StateCommands.indentMoreOrInsertTab,
                        shift: _codemirror_commands__WEBPACK_IMPORTED_MODULE_9__.indentLess
                    }
                ],
                factory: () => createConfigurableExtension(value => _codemirror_view__WEBPACK_IMPORTED_MODULE_8__.keymap.of(value))
            }),
            Object.freeze({
                name: 'lineNumbers',
                default: true,
                factory: () => createConditionalExtension((0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.lineNumbers)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Line Numbers')
                }
            }),
            Object.freeze({
                name: 'lineWrap',
                factory: () => createConditionalExtension(_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.EditorView.lineWrapping),
                default: true,
                schema: {
                    type: 'boolean',
                    title: trans.__('Line Wrap')
                }
            }),
            Object.freeze({
                name: 'matchBrackets',
                default: true,
                factory: () => createConditionalExtension([
                    (0,_codemirror_language__WEBPACK_IMPORTED_MODULE_7__.bracketMatching)(),
                    // closeBracketsKeymap must have higher precedence over defaultKeymap
                    _codemirror_state__WEBPACK_IMPORTED_MODULE_5__.Prec.high(_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.keymap.of(_codemirror_autocomplete__WEBPACK_IMPORTED_MODULE_6__.closeBracketsKeymap))
                ]),
                schema: {
                    type: 'boolean',
                    title: trans.__('Match Brackets')
                }
            }),
            Object.freeze({
                name: 'rectangularSelection',
                default: true,
                factory: () => createConditionalExtension([
                    (0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.rectangularSelection)(),
                    (0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.crosshairCursor)()
                ]),
                schema: {
                    type: 'boolean',
                    title: trans.__('Rectangular selection'),
                    description: trans.__('Rectangular (block) selection can be created by dragging the mouse pointer while holding the left mouse button and the Alt key. When the Alt key is pressed, a crosshair cursor will appear, indicating that the rectangular selection mode is active.')
                }
            }),
            Object.freeze({
                name: 'readOnly',
                default: false,
                factory: () => createConfigurableExtension((value) => [
                    _codemirror_state__WEBPACK_IMPORTED_MODULE_5__.EditorState.readOnly.of(value),
                    value
                        ? _codemirror_view__WEBPACK_IMPORTED_MODULE_8__.EditorView.editorAttributes.of({ class: READ_ONLY_CLASS })
                        : []
                ])
            }),
            Object.freeze({
                name: 'rulers',
                default: [],
                factory: () => createConfigurableExtension((value) => value.length > 0 ? (0,_extensions__WEBPACK_IMPORTED_MODULE_4__.rulers)(value) : []),
                schema: {
                    type: 'array',
                    title: trans.__('Rulers'),
                    items: {
                        type: 'number',
                        minimum: 0
                    }
                }
            }),
            Object.freeze({
                name: 'scrollPastEnd',
                default: false,
                factory: (options) => options.inline ? null : createConditionalExtension((0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.scrollPastEnd)())
            }),
            Object.freeze({
                name: 'smartIndent',
                default: true,
                factory: () => createConditionalExtension((0,_codemirror_language__WEBPACK_IMPORTED_MODULE_7__.indentOnInput)()),
                schema: {
                    type: 'boolean',
                    title: trans.__('Smart Indentation')
                }
            }),
            Object.freeze({
                name: 'tabSize',
                default: 4,
                factory: () => createConfigurableExtension((value) => _codemirror_state__WEBPACK_IMPORTED_MODULE_5__.EditorState.tabSize.of(value)),
                schema: {
                    type: 'number',
                    title: trans.__('Tab size')
                }
            }),
            Object.freeze({
                name: 'tooltips',
                factory: () => 
                // we need `absolute` due to use of `contain: layout` in lumino;
                // we attach to body to ensure cursor collaboration tooltip is
                // visible in first line of the editor.
                createImmutableExtension((0,_codemirror_view__WEBPACK_IMPORTED_MODULE_8__.tooltips)({
                    position: 'absolute',
                    parent: document.body
                }))
            }),
            Object.freeze({
                name: 'allowMultipleSelections',
                default: true,
                factory: () => createConfigurableExtension((value) => _codemirror_state__WEBPACK_IMPORTED_MODULE_5__.EditorState.allowMultipleSelections.of(value)),
                schema: {
                    type: 'boolean',
                    title: trans.__('Multiple selections')
                }
            }),
            Object.freeze({
                name: 'customStyles',
                factory: () => createConfigurableExtension(config => (0,_extensions__WEBPACK_IMPORTED_MODULE_4__.customTheme)(config)),
                default: {
                    fontFamily: null,
                    fontSize: null,
                    lineHeight: null
                },
                schema: {
                    title: trans.__('Custom editor styles'),
                    type: 'object',
                    properties: {
                        fontFamily: {
                            type: ['string', 'null'],
                            title: trans.__('Font Family')
                        },
                        fontSize: {
                            type: ['number', 'null'],
                            minimum: 1,
                            maximum: 100,
                            title: trans.__('Font Size')
                        },
                        lineHeight: {
                            type: ['number', 'null'],
                            title: trans.__('Line Height')
                        }
                    },
                    additionalProperties: false
                }
            })
        ];
        if (themes) {
            extensions.push(Object.freeze({
                name: 'theme',
                default: 'jupyter',
                factory: () => createConfigurableExtension(value => themes.getTheme(value)),
                schema: {
                    type: 'string',
                    title: trans.__('Theme'),
                    description: trans.__('CodeMirror theme')
                }
            }));
        }
        if (translator) {
            extensions.push(Object.freeze({
                name: 'translation',
                // The list of internal strings is available at https://codemirror.net/examples/translate/
                default: {
                    // @codemirror/view
                    'Control character': trans.__('Control character'),
                    // @codemirror/commands
                    'Selection deleted': trans.__('Selection deleted'),
                    // @codemirror/language
                    'Folded lines': trans.__('Folded lines'),
                    'Unfolded lines': trans.__('Unfolded lines'),
                    to: trans.__('to'),
                    'folded code': trans.__('folded code'),
                    unfold: trans.__('unfold'),
                    'Fold line': trans.__('Fold line'),
                    'Unfold line': trans.__('Unfold line'),
                    // @codemirror/search
                    'Go to line': trans.__('Go to line'),
                    go: trans.__('go'),
                    Find: trans.__('Find'),
                    Replace: trans.__('Replace'),
                    next: trans.__('next'),
                    previous: trans.__('previous'),
                    all: trans.__('all'),
                    'match case': trans.__('match case'),
                    replace: trans.__('replace'),
                    'replace all': trans.__('replace all'),
                    close: trans.__('close'),
                    'current match': trans.__('current match'),
                    'replaced $ matches': trans.__('replaced $ matches'),
                    'replaced match on line $': trans.__('replaced match on line $'),
                    'on line': trans.__('on line'),
                    // @codemirror/autocomplete
                    Completions: trans.__('Completions'),
                    // @codemirror/lint
                    Diagnostics: trans.__('Diagnostics'),
                    'No diagnostics': trans.__('No diagnostics')
                },
                factory: () => createConfigurableExtension(value => _codemirror_state__WEBPACK_IMPORTED_MODULE_5__.EditorState.phrases.of(value))
            }));
        }
        return extensions;
    }
    EditorExtensionRegistry.getDefaultExtensions = getDefaultExtensions;
})(EditorExtensionRegistry || (EditorExtensionRegistry = {}));
//# sourceMappingURL=extension.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/extensions/customStyle.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/extensions/customStyle.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   customTheme: () => (/* binding */ customTheme)
/* harmony export */ });
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @codemirror/state */ "./node_modules/@codemirror/state/dist/index.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */


/**
 * Custom theme configuration
 *
 * The first non-null value takes precedence
 */
const customThemeConfig = _codemirror_state__WEBPACK_IMPORTED_MODULE_0__.Facet.define({
    combine(configs) {
        return (0,_codemirror_state__WEBPACK_IMPORTED_MODULE_0__.combineConfig)(configs, {
            fontFamily: null,
            fontSize: null,
            lineHeight: null
        }, {
            fontFamily: (a, b) => a !== null && a !== void 0 ? a : b,
            fontSize: (a, b) => a !== null && a !== void 0 ? a : b,
            lineHeight: (a, b) => a !== null && a !== void 0 ? a : b
        });
    }
});
function setEditorStyle(view) {
    const { fontFamily, fontSize, lineHeight } = view.state.facet(customThemeConfig);
    let style = '';
    if (fontSize) {
        style += `font-size: ${fontSize}px !important;`;
    }
    if (fontFamily) {
        style += `font-family: ${fontFamily} !important;`;
    }
    if (lineHeight) {
        style += `line-height: ${lineHeight.toString()} !important`;
    }
    return { style: style };
}
/**
 * Get the extension to customize an editor theme.
 *
 * @param config Theme customization
 * @returns Editor extension
 */
function customTheme(config) {
    return [
        customThemeConfig.of(config),
        _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.EditorView.editorAttributes.of(setEditorStyle)
    ];
}
//# sourceMappingURL=customStyle.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/extensions/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/extensions/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   YRange: () => (/* reexport safe */ _ybinding__WEBPACK_IMPORTED_MODULE_3__.YRange),
/* harmony export */   YSyncConfig: () => (/* reexport safe */ _ybinding__WEBPACK_IMPORTED_MODULE_3__.YSyncConfig),
/* harmony export */   customTheme: () => (/* reexport safe */ _customStyle__WEBPACK_IMPORTED_MODULE_0__.customTheme),
/* harmony export */   parseMathIPython: () => (/* reexport safe */ _ipython_md__WEBPACK_IMPORTED_MODULE_1__.parseMathIPython),
/* harmony export */   rulers: () => (/* reexport safe */ _rulers__WEBPACK_IMPORTED_MODULE_2__.rulers),
/* harmony export */   ySync: () => (/* reexport safe */ _ybinding__WEBPACK_IMPORTED_MODULE_3__.ySync),
/* harmony export */   ySyncAnnotation: () => (/* reexport safe */ _ybinding__WEBPACK_IMPORTED_MODULE_3__.ySyncAnnotation),
/* harmony export */   ySyncFacet: () => (/* reexport safe */ _ybinding__WEBPACK_IMPORTED_MODULE_3__.ySyncFacet),
/* harmony export */   ybinding: () => (/* reexport safe */ _ybinding__WEBPACK_IMPORTED_MODULE_3__.ybinding)
/* harmony export */ });
/* harmony import */ var _customStyle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./customStyle */ "./node_modules/@jupyterlab/codemirror/lib/extensions/customStyle.js");
/* harmony import */ var _ipython_md__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ipython-md */ "./node_modules/@jupyterlab/codemirror/lib/extensions/ipython-md.js");
/* harmony import */ var _rulers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./rulers */ "./node_modules/@jupyterlab/codemirror/lib/extensions/rulers.js");
/* harmony import */ var _ybinding__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ybinding */ "./node_modules/@jupyterlab/codemirror/lib/extensions/ybinding.js");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */




//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/extensions/ipython-md.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/extensions/ipython-md.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseMathIPython: () => (/* binding */ parseMathIPython)
/* harmony export */ });
/* harmony import */ var _lezer_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lezer/common */ "./node_modules/@lezer/common/dist/index.js");
/* harmony import */ var _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lezer/highlight */ "./node_modules/@lezer/highlight/dist/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


// Mathematical expression delimiters
const INLINE_MATH_DOLLAR = 'InlineMathDollar';
const INLINE_MATH_BRACKET = 'InlineMathBracket';
const BLOCK_MATH_DOLLAR = 'BlockMathDollar';
const BLOCK_MATH_BRACKET = 'BlockMathBracket';
/**
 * Lengh of the delimiter for a math expression
 */
const DELIMITER_LENGTH = {
    [INLINE_MATH_DOLLAR]: 1,
    [INLINE_MATH_BRACKET]: 3,
    [BLOCK_MATH_DOLLAR]: 2,
    [BLOCK_MATH_BRACKET]: 3
};
/**
 * Delimiters for math expressions
 */
// Delimiters must be defined as constant because they are used in object match tests
const DELIMITERS = Object.keys(DELIMITER_LENGTH).reduce((agg, name) => {
    agg[name] = { mark: `${name}Mark`, resolve: name };
    return agg;
}, {});
/**
 * Define an IPython mathematical expression parser for Markdown.
 *
 * @param latexParser CodeMirror {@link Parser} for LaTeX mathematical expression
 * @returns Markdown extension
 */
function parseMathIPython(latexParser) {
    const defineNodes = new Array();
    Object.keys(DELIMITER_LENGTH).forEach(name => {
        defineNodes.push({
            name,
            style: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.emphasis
        }, { name: `${name}Mark`, style: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.processingInstruction });
    });
    return {
        defineNodes,
        parseInline: [
            {
                name: BLOCK_MATH_DOLLAR,
                parse(cx, next, pos) {
                    if (next != 36 /* '$' */ || cx.char(pos + 1) != 36) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[BLOCK_MATH_DOLLAR], pos, pos + DELIMITER_LENGTH[BLOCK_MATH_DOLLAR], true, true);
                }
            },
            {
                name: INLINE_MATH_DOLLAR,
                parse(cx, next, pos) {
                    if (next != 36 /* '$' */ || cx.char(pos + 1) == 36) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[INLINE_MATH_DOLLAR], pos, pos + DELIMITER_LENGTH[INLINE_MATH_DOLLAR], true, true);
                }
            },
            // Inline expression wrapped in \\( ... \\)
            {
                name: INLINE_MATH_BRACKET,
                before: 'Escape',
                parse(cx, next, pos) {
                    if (next != 92 /* '\' */ ||
                        cx.char(pos + 1) != 92 ||
                        ![40 /* '(' */, 41 /* ')' */].includes(cx.char(pos + 2))) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[INLINE_MATH_BRACKET], pos, pos + DELIMITER_LENGTH[INLINE_MATH_BRACKET], cx.char(pos + 2) == 40, cx.char(pos + 2) == 41);
                }
            },
            // Block expression wrapped in \\[ ... \\]
            {
                name: BLOCK_MATH_BRACKET,
                before: 'Escape',
                parse(cx, next, pos) {
                    if (next != 92 /* '\' */ ||
                        cx.char(pos + 1) != 92 ||
                        ![91 /* '[' */, 93 /* ']' */].includes(cx.char(pos + 2))) {
                        return -1;
                    }
                    return cx.addDelimiter(DELIMITERS[BLOCK_MATH_BRACKET], pos, pos + DELIMITER_LENGTH[BLOCK_MATH_BRACKET], cx.char(pos + 2) == 91, cx.char(pos + 2) == 93);
                }
            }
        ],
        wrap: latexParser
            ? (0,_lezer_common__WEBPACK_IMPORTED_MODULE_0__.parseMixed)((node, input) => {
                // Test if the node type is one of the math expression
                const delimiterLength = DELIMITER_LENGTH[node.type.name];
                if (delimiterLength) {
                    return {
                        parser: latexParser,
                        // Remove delimiter from LaTeX parser otherwise it won't be highlighted
                        overlay: [
                            {
                                from: node.from + delimiterLength,
                                to: node.to - delimiterLength
                            }
                        ]
                    };
                }
                return null;
            })
            : undefined
    };
}
//# sourceMappingURL=ipython-md.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/extensions/rulers.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/extensions/rulers.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rulers: () => (/* binding */ rulers)
/* harmony export */ });
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @codemirror/state */ "./node_modules/@codemirror/state/dist/index.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/codemirror/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
// Inspired by https://discuss.codemirror.net/t/how-to-implement-ruler/4616/



const RULERS_CLASSNAME = 'cm-rulers';
/**
 * Rulers style
 */
const baseTheme = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.EditorView.baseTheme({
    [`.${RULERS_CLASSNAME}`]: { borderRight: '1px dotted gray', opacity: 0.7 }
});
/**
 * Rulers facet
 */
const rulerConfig = _codemirror_state__WEBPACK_IMPORTED_MODULE_2__.Facet.define({
    // Merge all unique values
    combine(value) {
        const final = value.reduce((agg, arr) => agg.concat(
        // Check value is not in aggregate nor multiple time in the array.
        arr.filter((v, idx) => !agg.includes(v) && idx == arr.lastIndexOf(v))), []);
        return final;
    }
});
/**
 * View plugin displaying the rulers
 */
const plugin = _codemirror_view__WEBPACK_IMPORTED_MODULE_1__.ViewPlugin.fromClass(class {
    constructor(view) {
        var _a, _b;
        this.rulersContainer = view.dom.appendChild(document.createElement('div'));
        this.rulersContainer.style.cssText = `
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                pointer-events: none;
                overflow: hidden;
            `;
        const defaultCharacterWidth = view.defaultCharacterWidth;
        const widths = view.state.facet(rulerConfig);
        const guttersWidths = (_b = (_a = view.scrollDOM.querySelector('.cm-gutters')) === null || _a === void 0 ? void 0 : _a.clientWidth) !== null && _b !== void 0 ? _b : 0;
        this.rulers = widths.map(width => {
            const ruler = this.rulersContainer.appendChild(document.createElement('div'));
            ruler.classList.add(RULERS_CLASSNAME);
            ruler.style.cssText = `
                position: absolute;
                left: ${guttersWidths + width * defaultCharacterWidth}px;
                height: 100%;
            `;
            // FIXME: This should be equal to the amount of padding on a line.
            // This value should be extracted from CodeMirror rather than hardcoded.
            ruler.style.width = '6px';
            return ruler;
        });
    }
    update(update) {
        var _a, _b;
        const widths = update.view.state.facet(rulerConfig);
        if (update.viewportChanged ||
            update.geometryChanged ||
            !_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.JSONExt.deepEqual(widths, update.startState.facet(rulerConfig))) {
            const guttersWidth = (_b = (_a = update.view.scrollDOM.querySelector('.cm-gutters')) === null || _a === void 0 ? void 0 : _a.clientWidth) !== null && _b !== void 0 ? _b : 0;
            const defaultCharacterWidth = update.view.defaultCharacterWidth;
            this.rulers.forEach((ruler, rulerIdx) => {
                ruler.style.left = `${guttersWidth + widths[rulerIdx] * defaultCharacterWidth}px`;
            });
        }
    }
    destroy() {
        this.rulers.forEach(ruler => {
            ruler.remove();
        });
        this.rulersContainer.remove();
    }
});
/**
 * Extension for CodeMirror 6 displaying rulers.
 *
 * @param value Rulers position
 * @returns CodeMirror 6 extension
 */
function rulers(value) {
    return [baseTheme, rulerConfig.of(value), plugin];
}
//# sourceMappingURL=rulers.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/extensions/ybinding.js":
/*!************************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/extensions/ybinding.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   YRange: () => (/* binding */ YRange),
/* harmony export */   YSyncConfig: () => (/* binding */ YSyncConfig),
/* harmony export */   ySync: () => (/* binding */ ySync),
/* harmony export */   ySyncAnnotation: () => (/* binding */ ySyncAnnotation),
/* harmony export */   ySyncFacet: () => (/* binding */ ySyncFacet),
/* harmony export */   ybinding: () => (/* binding */ ybinding)
/* harmony export */ });
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @codemirror/state */ "./node_modules/@codemirror/state/dist/index.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var yjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! yjs */ "./node_modules/yjs/dist/yjs.mjs");
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 *
 * Binding for yjs and codemirror
 *
 * It is a simplification of https://github.com/yjs/y-codemirror.next
 * licensed under MIT License by Kevin Jahns
 */



/**
 * Defines a range on text using relative positions that can be transformed back to
 * absolute positions. (https://docs.yjs.dev/api/relative-positions)
 */
class YRange {
    /**
     * @param yanchor
     * @param yhead
     */
    constructor(yanchor, yhead) {
        this.yanchor = yanchor;
        this.yhead = yhead;
    }
    /**
     * Convert the position to JSON
     */
    toJSON() {
        return {
            yanchor: (0,yjs__WEBPACK_IMPORTED_MODULE_0__.relativePositionToJSON)(this.yanchor),
            yhead: (0,yjs__WEBPACK_IMPORTED_MODULE_0__.relativePositionToJSON)(this.yhead)
        };
    }
    /**
     * Convert a JSON range to a YRange
     * @param json Range to convert
     * @return The range as YRange
     */
    static fromJSON(json) {
        return new YRange((0,yjs__WEBPACK_IMPORTED_MODULE_0__.createRelativePositionFromJSON)(json.yanchor), (0,yjs__WEBPACK_IMPORTED_MODULE_0__.createRelativePositionFromJSON)(json.yhead));
    }
}
/**
 * Yjs binding configuration
 */
class YSyncConfig {
    /**
     * Create a new binding configuration
     *
     * @param ytext Yjs text to synchronize
     */
    constructor(ytext) {
        this.ytext = ytext;
    }
    /**
     * Helper function to transform an absolute index position to a Yjs-based relative position
     * (https://docs.yjs.dev/api/relative-positions).
     *
     * A relative position can be transformed back to an absolute position even after the document has changed. The position is
     * automatically adapted. This does not require any position transformations. Relative positions are computed based on
     * the internal Yjs document model. Peers that share content through Yjs are guaranteed that their positions will always
     * synced up when using relative positions.
     *
     * ```js
     * import { ySyncFacet } from 'y-codemirror'
     *
     * ..
     * const ysync = view.state.facet(ySyncFacet)
     * // transform an absolute index position to a ypos
     * const ypos = ysync.getYPos(3)
     * // transform the ypos back to an absolute position
     * ysync.fromYPos(ypos) // => 3
     * ```
     *
     * It cannot be guaranteed that absolute index positions can be synced up between peers.
     * This might lead to undesired behavior when implementing features that require that all peers see the
     * same marked range (e.g. a comment plugin).
     *
     * @param pos
     * @param assoc
     */
    toYPos(pos, assoc = 0) {
        return (0,yjs__WEBPACK_IMPORTED_MODULE_0__.createRelativePositionFromTypeIndex)(this.ytext, pos, assoc);
    }
    /**
     * @param rpos
     */
    fromYPos(rpos) {
        const pos = (0,yjs__WEBPACK_IMPORTED_MODULE_0__.createAbsolutePositionFromRelativePosition)((0,yjs__WEBPACK_IMPORTED_MODULE_0__.createRelativePositionFromJSON)(rpos), this.ytext.doc);
        if (pos == null || pos.type !== this.ytext) {
            throw new Error('[y-codemirror] The position you want to retrieve was created by a different document');
        }
        return {
            pos: pos.index,
            assoc: pos.assoc
        };
    }
    /**
     * @param range
     * @return
     */
    toYRange(range) {
        const assoc = range.assoc;
        const yanchor = this.toYPos(range.anchor, assoc);
        const yhead = this.toYPos(range.head, assoc);
        return new YRange(yanchor, yhead);
    }
    /**
     * @param yrange
     */
    fromYRange(yrange) {
        const anchor = this.fromYPos(yrange.yanchor);
        const head = this.fromYPos(yrange.yhead);
        if (anchor.pos === head.pos) {
            return _codemirror_state__WEBPACK_IMPORTED_MODULE_1__.EditorSelection.cursor(head.pos, head.assoc);
        }
        return _codemirror_state__WEBPACK_IMPORTED_MODULE_1__.EditorSelection.range(anchor.pos, head.pos);
    }
}
/**
 * Yjs binding facet
 */
const ySyncFacet = _codemirror_state__WEBPACK_IMPORTED_MODULE_1__.Facet.define({
    combine(inputs) {
        return inputs[inputs.length - 1];
    }
});
/**
 * Yjs binding annotation
 *
 * It is used to track the origin of the document changes
 */
const ySyncAnnotation = _codemirror_state__WEBPACK_IMPORTED_MODULE_1__.Annotation.define();
/**
 * Yjs binding view plugin to synchronize the
 * editor state with the Yjs document.
 */
const ySync = _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.ViewPlugin.fromClass(class {
    constructor(view) {
        this.conf = view.state.facet(ySyncFacet);
        this._observer = (event, tr) => {
            var _a;
            if (tr.origin !== this.conf) {
                const delta = event.delta;
                const changes = [];
                let pos = 0;
                for (let i = 0; i < delta.length; i++) {
                    const d = delta[i];
                    if (d.insert != null) {
                        changes.push({ from: pos, to: pos, insert: d.insert });
                    }
                    else if (d.delete != null) {
                        changes.push({ from: pos, to: pos + d.delete, insert: '' });
                        pos += d.delete;
                    }
                    else {
                        pos += (_a = d.retain) !== null && _a !== void 0 ? _a : 0;
                    }
                }
                view.dispatch({
                    changes,
                    // Specified the changes origin to not loop when synchronizing
                    annotations: [ySyncAnnotation.of(this.conf)]
                });
            }
        };
        this._ytext = this.conf.ytext;
        this._ytext.observe(this._observer);
    }
    update(update) {
        if (!update.docChanged ||
            (update.transactions.length > 0 &&
                update.transactions[0].annotation(ySyncAnnotation) === this.conf)) {
            return;
        }
        const ytext = this.conf.ytext;
        ytext.doc.transact(() => {
            /**
             * This variable adjusts the fromA position to the current position in the Y.Text type.
             */
            let adj = 0;
            update.changes.iterChanges((fromA, toA, fromB, toB, insert) => {
                const insertText = insert.sliceString(0, insert.length, '\n');
                if (fromA !== toA) {
                    ytext.delete(fromA + adj, toA - fromA);
                }
                if (insertText.length > 0) {
                    ytext.insert(fromA + adj, insertText);
                }
                adj += insertText.length - (toA - fromA);
            });
            // Set the configuration as origin to not loop when synchronizing
        }, this.conf);
    }
    destroy() {
        this._ytext.unobserve(this._observer);
    }
});
/**
 * Extension for CodeMirror 6 binding the Yjs text (source of truth)
 * and the editor state.
 *
 * @param ytext Yjs text to bind
 * @param undoManager Yjs text undo manager
 * @returns CodeMirror 6 extension
 */
function ybinding({ ytext, undoManager }) {
    const ySyncConfig = new YSyncConfig(ytext);
    // We don't need the undo manager extension as in y-codemirror.next
    // because we deal with undo/redo with our own keyboard shortcut mechanism.
    return [
        ySyncFacet.of(ySyncConfig),
        ySync,
        // We need to add a new origin to the undo manager to ensure text updates
        // are tracked.
        undoManager
            ? _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.ViewPlugin.define(() => {
                undoManager.addTrackedOrigin(ySyncConfig);
                return {
                    destroy: () => {
                        undoManager.removeTrackedOrigin(ySyncConfig);
                    }
                };
            })
            : []
    ];
}
//# sourceMappingURL=ybinding.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/factory.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/factory.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeMirrorEditorFactory: () => (/* binding */ CodeMirrorEditorFactory)
/* harmony export */ });
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _extension__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./extension */ "./node_modules/@jupyterlab/codemirror/lib/extension.js");
/* harmony import */ var _editor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./editor */ "./node_modules/@jupyterlab/codemirror/lib/editor.js");
/* harmony import */ var _language__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./language */ "./node_modules/@jupyterlab/codemirror/lib/language.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var _codemirror_search__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @codemirror/search */ "./node_modules/@codemirror/search/dist/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * CodeMirror editor factory.
 */
class CodeMirrorEditorFactory {
    /**
     * Construct an IEditorFactoryService for CodeMirrorEditors.
     */
    constructor(options = {}) {
        var _a, _b, _c;
        /**
         * Create a new editor for inline code.
         */
        this.newInlineEditor = (options) => {
            var _a;
            options.host.dataset.type = 'inline';
            return this.newEditor({
                ...options,
                config: { ...this.inlineCodeMirrorConfig, ...(options.config || {}) },
                inline: true,
                // FIXME the search keymap should be added in the search plugin
                extensions: [_codemirror_view__WEBPACK_IMPORTED_MODULE_4__.keymap.of(_codemirror_search__WEBPACK_IMPORTED_MODULE_5__.searchKeymap)].concat((_a = options.extensions) !== null && _a !== void 0 ? _a : [])
            });
        };
        /**
         * Create a new editor for a full document.
         */
        this.newDocumentEditor = (options) => {
            var _a, _b;
            options.host.dataset.type = 'document';
            return this.newEditor({
                ...options,
                config: { ...this.documentCodeMirrorConfig, ...((_a = options.config) !== null && _a !== void 0 ? _a : {}) },
                inline: false,
                extensions: [
                    _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.keymap.of([
                        {
                            key: 'Shift-Enter',
                            run: (target) => {
                                return true;
                            }
                        }
                    ])
                ].concat((_b = options.extensions) !== null && _b !== void 0 ? _b : [])
            });
        };
        this.languages = (_a = options.languages) !== null && _a !== void 0 ? _a : new _language__WEBPACK_IMPORTED_MODULE_3__.EditorLanguageRegistry();
        this.extensions = (_b = options.extensions) !== null && _b !== void 0 ? _b : new _extension__WEBPACK_IMPORTED_MODULE_1__.EditorExtensionRegistry();
        this.translator = (_c = options.translator) !== null && _c !== void 0 ? _c : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        this.inlineCodeMirrorConfig = {};
        this.documentCodeMirrorConfig = {
            lineNumbers: true,
            scrollPastEnd: true
        };
    }
    /**
     * Create a new editor
     *
     * @param options Editor options
     * @returns The editor
     */
    newEditor(options) {
        const editor = new _editor__WEBPACK_IMPORTED_MODULE_2__.CodeMirrorEditor({
            extensionsRegistry: this.extensions,
            languages: this.languages,
            translator: this.translator,
            ...options
        });
        return editor;
    }
}
//# sourceMappingURL=factory.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeMirrorEditor: () => (/* reexport safe */ _editor__WEBPACK_IMPORTED_MODULE_1__.CodeMirrorEditor),
/* harmony export */   CodeMirrorEditorFactory: () => (/* reexport safe */ _factory__WEBPACK_IMPORTED_MODULE_4__.CodeMirrorEditorFactory),
/* harmony export */   CodeMirrorMimeTypeService: () => (/* reexport safe */ _mimetype__WEBPACK_IMPORTED_MODULE_6__.CodeMirrorMimeTypeService),
/* harmony export */   CodeMirrorSearchHighlighter: () => (/* reexport safe */ _searchprovider__WEBPACK_IMPORTED_MODULE_7__.CodeMirrorSearchHighlighter),
/* harmony export */   EditorExtensionRegistry: () => (/* reexport safe */ _extension__WEBPACK_IMPORTED_MODULE_2__.EditorExtensionRegistry),
/* harmony export */   EditorLanguageRegistry: () => (/* reexport safe */ _language__WEBPACK_IMPORTED_MODULE_5__.EditorLanguageRegistry),
/* harmony export */   EditorSearchProvider: () => (/* reexport safe */ _searchprovider__WEBPACK_IMPORTED_MODULE_7__.EditorSearchProvider),
/* harmony export */   EditorThemeRegistry: () => (/* reexport safe */ _theme__WEBPACK_IMPORTED_MODULE_8__.EditorThemeRegistry),
/* harmony export */   ExtensionsHandler: () => (/* reexport safe */ _extension__WEBPACK_IMPORTED_MODULE_2__.ExtensionsHandler),
/* harmony export */   IEditorExtensionRegistry: () => (/* reexport safe */ _token__WEBPACK_IMPORTED_MODULE_9__.IEditorExtensionRegistry),
/* harmony export */   IEditorLanguageRegistry: () => (/* reexport safe */ _token__WEBPACK_IMPORTED_MODULE_9__.IEditorLanguageRegistry),
/* harmony export */   IEditorThemeRegistry: () => (/* reexport safe */ _token__WEBPACK_IMPORTED_MODULE_9__.IEditorThemeRegistry),
/* harmony export */   StateCommands: () => (/* reexport safe */ _commands__WEBPACK_IMPORTED_MODULE_0__.StateCommands),
/* harmony export */   YRange: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.YRange),
/* harmony export */   YSyncConfig: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.YSyncConfig),
/* harmony export */   customTheme: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.customTheme),
/* harmony export */   jupyterEditorTheme: () => (/* reexport safe */ _theme__WEBPACK_IMPORTED_MODULE_8__.jupyterEditorTheme),
/* harmony export */   jupyterHighlightStyle: () => (/* reexport safe */ _theme__WEBPACK_IMPORTED_MODULE_8__.jupyterHighlightStyle),
/* harmony export */   jupyterTheme: () => (/* reexport safe */ _theme__WEBPACK_IMPORTED_MODULE_8__.jupyterTheme),
/* harmony export */   parseMathIPython: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.parseMathIPython),
/* harmony export */   rulers: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.rulers),
/* harmony export */   ySync: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.ySync),
/* harmony export */   ySyncAnnotation: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.ySyncAnnotation),
/* harmony export */   ySyncFacet: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.ySyncFacet),
/* harmony export */   ybinding: () => (/* reexport safe */ _extensions__WEBPACK_IMPORTED_MODULE_3__.ybinding)
/* harmony export */ });
/* harmony import */ var _commands__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./commands */ "./node_modules/@jupyterlab/codemirror/lib/commands.js");
/* harmony import */ var _editor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./editor */ "./node_modules/@jupyterlab/codemirror/lib/editor.js");
/* harmony import */ var _extension__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./extension */ "./node_modules/@jupyterlab/codemirror/lib/extension.js");
/* harmony import */ var _extensions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./extensions */ "./node_modules/@jupyterlab/codemirror/lib/extensions/index.js");
/* harmony import */ var _factory__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./factory */ "./node_modules/@jupyterlab/codemirror/lib/factory.js");
/* harmony import */ var _language__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./language */ "./node_modules/@jupyterlab/codemirror/lib/language.js");
/* harmony import */ var _mimetype__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./mimetype */ "./node_modules/@jupyterlab/codemirror/lib/mimetype.js");
/* harmony import */ var _searchprovider__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./searchprovider */ "./node_modules/@jupyterlab/codemirror/lib/searchprovider.js");
/* harmony import */ var _theme__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./theme */ "./node_modules/@jupyterlab/codemirror/lib/theme.js");
/* harmony import */ var _token__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./token */ "./node_modules/@jupyterlab/codemirror/lib/token.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module codemirror
 */










//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/language.js":
/*!*************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/language.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EditorLanguageRegistry: () => (/* binding */ EditorLanguageRegistry)
/* harmony export */ });
/* harmony import */ var _codemirror_language__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @codemirror/language */ "./node_modules/@codemirror/language/dist/index.js");
/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/codeeditor */ "./node_modules/@jupyterlab/codeeditor/lib/mimetype.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lezer_generator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lezer/generator */ "./node_modules/@lezer/generator/dist/index.js");
/* harmony import */ var _lezer_highlight__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lezer/highlight */ "./node_modules/@lezer/highlight/dist/index.js");
/* harmony import */ var _theme__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./theme */ "./node_modules/@jupyterlab/codemirror/lib/theme.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.







/**
 * CodeMirror language registry
 */
class EditorLanguageRegistry {
    constructor() {
        this._modeList = [];
        // Add default language text/plain -> No expressions to parse
        this.addLanguage({
            name: 'none',
            mime: 'text/plain',
            support: new _codemirror_language__WEBPACK_IMPORTED_MODULE_4__.LanguageSupport(
            // Create a dummy parser that as no expression to parse
            _codemirror_language__WEBPACK_IMPORTED_MODULE_4__.LRLanguage.define({ parser: (0,_lezer_generator__WEBPACK_IMPORTED_MODULE_1__.buildParser)('@top Program { }') }))
        });
    }
    /**
     * Register a new language for CodeMirror
     *
     * @param language Language to register
     */
    addLanguage(language) {
        var _a;
        const info = (_a = this.findByName(language.name)) !== null && _a !== void 0 ? _a : this.findByMIME(language.mime, true);
        if (info) {
            throw new Error(`${language.mime} already registered`);
        }
        this._modeList.push(this.makeSpec(language));
    }
    /**
     * Ensure a codemirror mode is available by name or Codemirror spec.
     *
     * @param language - The mode to ensure.  If it is a string, uses [findBest]
     *   to get the appropriate spec.
     *
     * @returns A promise that resolves when the mode is available.
     */
    async getLanguage(language) {
        const spec = this.findBest(language);
        if (spec && !spec.support) {
            spec.support = await spec.load();
        }
        return spec;
    }
    /**
     * Get the raw list of available modes specs.
     *
     * @returns The available modes
     */
    getLanguages() {
        return [...this._modeList];
    }
    /**
     * Find a codemirror mode by MIME.
     *
     * @param mime Mime type to look for
     * @param strict Whether xml and json should be assimilated to the generic mimetype
     * @returns The mode or null
     */
    findByMIME(mime, strict = false) {
        if (Array.isArray(mime)) {
            for (let i = 0; i < mime.length; i++) {
                const spec = this.findByMIME(mime[i]);
                if (spec)
                    return spec;
            }
            return null;
        }
        mime = mime.toLowerCase();
        for (let i = 0; i < this._modeList.length; i++) {
            let info = this._modeList[i];
            if (Array.isArray(info.mime)) {
                for (let j = 0; j < info.mime.length; j++) {
                    if (info.mime[j] == mime) {
                        return info;
                    }
                }
            }
            else if (info.mime == mime) {
                return info;
            }
        }
        if (!strict) {
            if (/\+xml$/.test(mime))
                return this.findByMIME('application/xml');
            if (/\+json$/.test(mime))
                return this.findByMIME('application/json');
        }
        return null;
    }
    /**
     * Find a codemirror mode by name.
     *
     * @param name The mode name
     * @returns The mode or null
     */
    findByName(name) {
        name = name.toLowerCase();
        for (let i = 0; i < this._modeList.length; i++) {
            let info = this._modeList[i];
            if (info.name.toLowerCase() == name)
                return info;
            if (info.alias) {
                for (let j = 0; j < info.alias.length; j++) {
                    if (info.alias[j].toLowerCase() == name) {
                        return info;
                    }
                }
            }
        }
        return null;
    }
    /**
     * Find a codemirror mode by extension.
     *
     * @param ext The extension name
     * @returns The mode or null
     */
    findByExtension(ext) {
        if (Array.isArray(ext)) {
            for (let i = 0; i < ext.length; i++) {
                const spec = this.findByExtension(ext[i]);
                if (spec)
                    return spec;
            }
            return null;
        }
        ext = ext.toLowerCase();
        for (let i = 0; i < this._modeList.length; i++) {
            let info = this._modeList[i];
            for (let j = 0; j < info.extensions.length; j++) {
                if (info.extensions[j].toLowerCase() == ext) {
                    return info;
                }
            }
        }
        return null;
    }
    /**
     * Find a codemirror mode by filename.
     *
     * @param name File name
     * @returns The mode or null
     */
    findByFileName(name) {
        const basename = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_5__.PathExt.basename(name);
        for (let i = 0; i < this._modeList.length; i++) {
            let info = this._modeList[i];
            if (info.filename && info.filename.test(basename)) {
                return info;
            }
        }
        let dot = basename.lastIndexOf('.');
        let ext = dot > -1 && basename.substring(dot + 1, basename.length);
        if (ext) {
            return this.findByExtension(ext);
        }
        return null;
    }
    /**
     * Find a codemirror mode by name or CodeMirror spec.
     *
     * @param language The CodeMirror mode
     * @param fallback Whether to fallback to default mimetype spec or not
     * @returns The mode or null
     */
    findBest(language, fallback = true) {
        var _a, _b, _c, _d;
        const modename = typeof language === 'string' ? language : language.name;
        const mimetype = typeof language !== 'string' ? language.mime : modename;
        const ext = typeof language !== 'string' ? (_a = language.extensions) !== null && _a !== void 0 ? _a : [] : [];
        return ((_d = (_c = (_b = (modename ? this.findByName(modename) : null)) !== null && _b !== void 0 ? _b : (mimetype ? this.findByMIME(mimetype) : null)) !== null && _c !== void 0 ? _c : this.findByExtension(ext)) !== null && _d !== void 0 ? _d : (fallback
            ? this.findByMIME(_jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_6__.IEditorMimeTypeService.defaultMimeType)
            : null));
    }
    /**
     * Parse and style a string.
     *
     * @param code Code to highlight
     * @param language Code language
     * @param el HTML element into which the highlighted code will be inserted
     */
    async highlight(code, language, el) {
        var _a;
        if (language) {
            await this.getLanguage(language);
        }
        const language_ = (_a = language === null || language === void 0 ? void 0 : language.support) === null || _a === void 0 ? void 0 : _a.language;
        if (!language_) {
            el.appendChild(document.createTextNode(code));
            return;
        }
        const tree = language_.parser.parse(code);
        // position state required because unstyled tokens are not emitted
        // in highlightTree
        let pos = 0;
        (0,_lezer_highlight__WEBPACK_IMPORTED_MODULE_2__.highlightTree)(tree, _theme__WEBPACK_IMPORTED_MODULE_3__.jupyterHighlightStyle, (from, to, classes) => {
            if (from > pos) {
                // No style applied to the token between pos and from
                el.appendChild(document.createTextNode(code.slice(pos, from)));
            }
            const sp = el.appendChild(document.createElement('span'));
            sp.className = classes;
            sp.appendChild(document.createTextNode(code.slice(from, to)));
            pos = to;
        });
        if (pos < tree.length - 1) {
            // No style applied on the trailing text
            el.appendChild(document.createTextNode(code.slice(pos, tree.length)));
        }
    }
    // Code mirror uses two similar structures, a plain object with optional fields,
    // and a class with the same fields but all mandatory. Maybe adopting the same
    // pattern would be less confusing (although far more verbose)
    makeSpec(spec) {
        let res = _codemirror_language__WEBPACK_IMPORTED_MODULE_4__.LanguageDescription.of(spec);
        // CodeMirror does not store/use mime type of a language
        res.mime = spec.mime;
        res.displayName = spec.displayName;
        return res;
    }
}
/**
 * EditorLanguageRegistry namespace
 */
(function (EditorLanguageRegistry) {
    /**
     * Convert an CodeMirror 5 language parser to CodeMirror 6
     *
     * @param parser Legacy parser
     * @returns Language object
     */
    function legacy(parser) {
        return new _codemirror_language__WEBPACK_IMPORTED_MODULE_4__.LanguageSupport(_codemirror_language__WEBPACK_IMPORTED_MODULE_4__.StreamLanguage.define(parser));
    }
    EditorLanguageRegistry.legacy = legacy;
    /**
     * Create a dialect of SQL
     *
     * @param dialectName SQL dialect
     * @returns Language object
     */
    async function sql(dialectName) {
        const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-sql_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-sql */ "./node_modules/@codemirror/lang-sql/dist/index.js"));
        return m.sql({ dialect: m[dialectName] });
    }
    /**
     * Get the default editor languages
     *
     * @param translator Application translator
     * @returns Default CodeMirror 6 languages
     */
    function getDefaultLanguages(translator) {
        const trans = (translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');
        return [
            {
                name: 'C',
                displayName: trans.__('C'),
                mime: 'text/x-csrc',
                extensions: ['c', 'h', 'ino'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-cpp_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-cpp */ "./node_modules/@codemirror/lang-cpp/dist/index.js"));
                    return m.cpp();
                }
            },
            {
                name: 'C++',
                displayName: trans.__('C++'),
                mime: 'text/x-c++src',
                extensions: ['cpp', 'c++', 'cc', 'cxx', 'hpp', 'h++', 'hh', 'hxx'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-cpp_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-cpp */ "./node_modules/@codemirror/lang-cpp/dist/index.js"));
                    return m.cpp();
                }
            },
            {
                name: 'CQL',
                displayName: trans.__('CQL'),
                mime: 'text/x-cassandra',
                extensions: ['cql'],
                load() {
                    return sql('Cassandra');
                }
            },
            {
                name: 'CSS',
                displayName: trans.__('CSS'),
                mime: 'text/css',
                extensions: ['css'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-css_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-css */ "./node_modules/@codemirror/lang-css/dist/index.js"));
                    return m.css();
                }
            },
            {
                name: 'HTML',
                displayName: trans.__('HTML'),
                alias: ['xhtml'],
                mime: 'text/html',
                extensions: ['html', 'htm', 'handlebars', 'hbs'],
                async load() {
                    const m = await Promise.all(/*! import() */[__webpack_require__.e("vendors-node_modules_codemirror_lang-javascript_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-css_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-html_dist_index_js")]).then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-html */ "./node_modules/@codemirror/lang-html/dist/index.js"));
                    return m.html();
                }
            },
            {
                name: 'Java',
                displayName: trans.__('Java'),
                mime: 'text/x-java',
                extensions: ['java'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-java_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-java */ "./node_modules/@codemirror/lang-java/dist/index.js"));
                    return m.java();
                }
            },
            {
                name: 'Javascript',
                displayName: trans.__('Javascript'),
                alias: ['ecmascript', 'js', 'node'],
                mime: [
                    'text/javascript',
                    'text/ecmascript',
                    'application/javascript',
                    'application/x-javascript',
                    'application/ecmascript'
                ],
                extensions: ['js', 'mjs', 'cjs'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-javascript_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-javascript */ "./node_modules/@codemirror/lang-javascript/dist/index.js"));
                    return m.javascript();
                }
            },
            {
                name: 'JSON',
                displayName: trans.__('JSON'),
                alias: ['json5'],
                mime: ['application/json', 'application/x-json'],
                extensions: ['json', 'map'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_lang-json_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-json */ "./node_modules/@codemirror/lang-json/dist/index.js"));
                    return m.json();
                }
            },
            {
                name: 'JSX',
                displayName: trans.__('JSX'),
                mime: 'text/jsx',
                extensions: ['jsx'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-javascript_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-javascript */ "./node_modules/@codemirror/lang-javascript/dist/index.js"));
                    return m.javascript({ jsx: true });
                }
            },
            {
                name: 'MariaDB SQL',
                displayName: trans.__('MariaDB SQL'),
                mime: 'text/x-mariadb',
                load() {
                    return sql('MariaSQL');
                }
            },
            {
                name: 'Markdown',
                displayName: trans.__('Markdown'),
                mime: 'text/x-markdown',
                extensions: ['md', 'markdown', 'mkd'],
                async load() {
                    const m = await Promise.all(/*! import() */[__webpack_require__.e("vendors-node_modules_codemirror_lang-javascript_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-css_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-html_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-markdown_dist_index_js")]).then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-markdown */ "./node_modules/@codemirror/lang-markdown/dist/index.js"));
                    return m.markdown({ codeLanguages: this._modeList });
                }
            },
            {
                name: 'MS SQL',
                displayName: trans.__('MS SQL'),
                mime: 'text/x-mssql',
                load() {
                    return sql('MSSQL');
                }
            },
            {
                name: 'MySQL',
                displayName: trans.__('MySQL'),
                mime: 'text/x-mysql',
                load() {
                    return sql('MySQL');
                }
            },
            {
                name: 'PHP',
                displayName: trans.__('PHP'),
                mime: [
                    'text/x-php',
                    'application/x-httpd-php',
                    'application/x-httpd-php-open'
                ],
                extensions: ['php', 'php3', 'php4', 'php5', 'php7', 'phtml'],
                async load() {
                    const m = await Promise.all(/*! import() */[__webpack_require__.e("vendors-node_modules_codemirror_lang-javascript_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-css_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-html_dist_index_js"), __webpack_require__.e("vendors-node_modules_codemirror_lang-php_dist_index_js")]).then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-php */ "./node_modules/@codemirror/lang-php/dist/index.js"));
                    return m.php();
                }
            },
            {
                name: 'PLSQL',
                displayName: trans.__('PLSQL'),
                mime: 'text/x-plsql',
                extensions: ['pls'],
                load() {
                    return sql('PLSQL');
                }
            },
            {
                name: 'PostgreSQL',
                displayName: trans.__('PostgreSQL'),
                mime: 'text/x-pgsql',
                load() {
                    return sql('PostgreSQL');
                }
            },
            {
                name: 'Python',
                displayName: trans.__('Python'),
                mime: 'text/x-python',
                extensions: ['BUILD', 'bzl', 'py', 'pyw'],
                filename: /^(BUCK|BUILD)$/,
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-python_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-python */ "./node_modules/@codemirror/lang-python/dist/index.js"));
                    return m.python();
                }
            },
            {
                name: 'ipython',
                displayName: trans.__('ipython'),
                mime: 'text/x-ipython',
                async load() {
                    // FIXME Restore '?' operator - using the default python LanguageSupport allows
                    // to activate feature such as code folding.
                    // return Promise.resolve(legacy(mkPython({ singleOperators: /\?/ })));
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-python_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-python */ "./node_modules/@codemirror/lang-python/dist/index.js"));
                    return m.python();
                }
            },
            {
                name: 'Rust',
                displayName: trans.__('Rust'),
                mime: 'text/x-rustsrc',
                extensions: ['rs'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-rust_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-rust */ "./node_modules/@codemirror/lang-rust/dist/index.js"));
                    return m.rust();
                }
            },
            {
                name: 'SQL',
                displayName: trans.__('SQL'),
                mime: ['application/sql', 'text/x-sql'],
                extensions: ['sql'],
                load() {
                    return sql('StandardSQL');
                }
            },
            {
                name: 'SQLite',
                displayName: trans.__('SQLite'),
                mime: 'text/x-sqlite',
                load() {
                    return sql('SQLite');
                }
            },
            {
                name: 'TSX',
                displayName: trans.__('TSX'),
                alias: ['TypeScript-JSX'],
                mime: 'text/typescript-jsx',
                extensions: ['tsx'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-javascript_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-javascript */ "./node_modules/@codemirror/lang-javascript/dist/index.js"));
                    return m.javascript({ jsx: true, typescript: true });
                }
            },
            {
                name: 'TypeScript',
                displayName: trans.__('TypeScript'),
                alias: ['ts'],
                mime: 'application/typescript',
                extensions: ['ts'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-javascript_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-javascript */ "./node_modules/@codemirror/lang-javascript/dist/index.js"));
                    return m.javascript({ typescript: true });
                }
            },
            {
                name: 'WebAssembly',
                displayName: trans.__('WebAssembly'),
                mime: 'text/webassembly',
                extensions: ['wat', 'wast'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_lang-wast_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-wast */ "./node_modules/@codemirror/lang-wast/dist/index.js"));
                    return m.wast();
                }
            },
            {
                name: 'XML',
                displayName: trans.__('XML'),
                alias: ['rss', 'wsdl', 'xsd'],
                mime: ['application/xml', 'text/xml'],
                extensions: ['xml', 'xsl', 'xsd', 'svg'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_lang-xml_dist_index_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/lang-xml */ "./node_modules/@codemirror/lang-xml/dist/index.js"));
                    return m.xml();
                }
            },
            // Legacy modes ported from CodeMirror 5
            {
                name: 'APL',
                displayName: trans.__('APL'),
                mime: 'text/apl',
                extensions: ['dyalog', 'apl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_apl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/apl */ "./node_modules/@codemirror/legacy-modes/mode/apl.js"));
                    return legacy(m.apl);
                }
            },
            {
                name: 'PGP',
                displayName: trans.__('PGP'),
                alias: ['asciiarmor'],
                mime: [
                    'application/pgp',
                    'application/pgp-encrypted',
                    'application/pgp-keys',
                    'application/pgp-signature'
                ],
                extensions: ['asc', 'pgp', 'sig'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_asciiarmor_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/asciiarmor */ "./node_modules/@codemirror/legacy-modes/mode/asciiarmor.js"));
                    return legacy(m.asciiArmor);
                }
            },
            {
                name: 'ASN.1',
                displayName: trans.__('ASN.1'),
                mime: 'text/x-ttcn-asn',
                extensions: ['asn', 'asn1'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_asn1_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/asn1 */ "./node_modules/@codemirror/legacy-modes/mode/asn1.js"));
                    return legacy(m.asn1({}));
                }
            },
            {
                name: 'Asterisk',
                displayName: trans.__('Asterisk'),
                mime: 'text/x-asterisk',
                filename: /^extensions\.conf$/i,
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_asterisk_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/asterisk */ "./node_modules/@codemirror/legacy-modes/mode/asterisk.js"));
                    return legacy(m.asterisk);
                }
            },
            {
                name: 'Brainfuck',
                displayName: trans.__('Brainfuck'),
                mime: 'text/x-brainfuck',
                extensions: ['b', 'bf'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_brainfuck_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/brainfuck */ "./node_modules/@codemirror/legacy-modes/mode/brainfuck.js"));
                    return legacy(m.brainfuck);
                }
            },
            {
                name: 'Cobol',
                displayName: trans.__('Cobol'),
                mime: 'text/x-cobol',
                extensions: ['cob', 'cpy'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_cobol_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/cobol */ "./node_modules/@codemirror/legacy-modes/mode/cobol.js"));
                    return legacy(m.cobol);
                }
            },
            {
                name: 'C#',
                displayName: trans.__('C#'),
                alias: ['csharp', 'cs'],
                mime: 'text/x-csharp',
                extensions: ['cs'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clike */ "./node_modules/@codemirror/legacy-modes/mode/clike.js"));
                    return legacy(m.csharp);
                }
            },
            {
                name: 'Clojure',
                displayName: trans.__('Clojure'),
                mime: 'text/x-clojure',
                extensions: ['clj', 'cljc', 'cljx'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clojure_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clojure */ "./node_modules/@codemirror/legacy-modes/mode/clojure.js"));
                    return legacy(m.clojure);
                }
            },
            {
                name: 'ClojureScript',
                displayName: trans.__('ClojureScript'),
                mime: 'text/x-clojurescript',
                extensions: ['cljs'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clojure_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clojure */ "./node_modules/@codemirror/legacy-modes/mode/clojure.js"));
                    return legacy(m.clojure);
                }
            },
            {
                name: 'Closure Stylesheets (GSS)',
                displayName: trans.__('Closure Stylesheets (GSS)'),
                mime: 'text/x-gss',
                extensions: ['gss'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_css_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/css */ "./node_modules/@codemirror/legacy-modes/mode/css.js"));
                    return legacy(m.gss);
                }
            },
            {
                name: 'CMake',
                displayName: trans.__('CMake'),
                mime: 'text/x-cmake',
                extensions: ['cmake', 'cmake.in'],
                filename: /^CMakeLists\.txt$/,
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_cmake_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/cmake */ "./node_modules/@codemirror/legacy-modes/mode/cmake.js"));
                    return legacy(m.cmake);
                }
            },
            {
                name: 'CoffeeScript',
                displayName: trans.__('CoffeeScript'),
                alias: ['coffee', 'coffee-script'],
                mime: [
                    'application/vnd.coffeescript',
                    'text/coffeescript',
                    'text/x-coffeescript'
                ],
                extensions: ['coffee'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_coffeescript_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/coffeescript */ "./node_modules/@codemirror/legacy-modes/mode/coffeescript.js"));
                    return legacy(m.coffeeScript);
                }
            },
            {
                name: 'Common Lisp',
                displayName: trans.__('Common Lisp'),
                alias: ['lisp'],
                mime: 'text/x-common-lisp',
                extensions: ['cl', 'lisp', 'el'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_commonlisp_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/commonlisp */ "./node_modules/@codemirror/legacy-modes/mode/commonlisp.js"));
                    return legacy(m.commonLisp);
                }
            },
            {
                name: 'Cypher',
                displayName: trans.__('Cypher'),
                mime: 'application/x-cypher-query',
                extensions: ['cyp', 'cypher'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_cypher_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/cypher */ "./node_modules/@codemirror/legacy-modes/mode/cypher.js"));
                    return legacy(m.cypher);
                }
            },
            {
                name: 'Cython',
                displayName: trans.__('Cython'),
                mime: 'text/x-cython',
                extensions: ['pyx', 'pxd', 'pxi'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_python_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/python */ "./node_modules/@codemirror/legacy-modes/mode/python.js"));
                    return legacy(m.cython);
                }
            },
            {
                name: 'Crystal',
                displayName: trans.__('Crystal'),
                mime: 'text/x-crystal',
                extensions: ['cr'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_crystal_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/crystal */ "./node_modules/@codemirror/legacy-modes/mode/crystal.js"));
                    return legacy(m.crystal);
                }
            },
            {
                name: 'D',
                displayName: trans.__('D'),
                mime: 'text/x-d',
                extensions: ['d'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_d_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/d */ "./node_modules/@codemirror/legacy-modes/mode/d.js"));
                    return legacy(m.d);
                }
            },
            {
                name: 'Dart',
                displayName: trans.__('Dart'),
                mime: ['application/dart', 'text/x-dart'],
                extensions: ['dart'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clike */ "./node_modules/@codemirror/legacy-modes/mode/clike.js"));
                    return legacy(m.dart);
                }
            },
            {
                name: 'diff',
                displayName: trans.__('diff'),
                mime: 'text/x-diff',
                extensions: ['diff', 'patch'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_diff_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/diff */ "./node_modules/@codemirror/legacy-modes/mode/diff.js"));
                    return legacy(m.diff);
                }
            },
            {
                name: 'Dockerfile',
                displayName: trans.__('Dockerfile'),
                mime: 'text/x-dockerfile',
                filename: /^Dockerfile$/,
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_dockerfile_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/dockerfile */ "./node_modules/@codemirror/legacy-modes/mode/dockerfile.js"));
                    return legacy(m.dockerFile);
                }
            },
            {
                name: 'DTD',
                displayName: trans.__('DTD'),
                mime: 'application/xml-dtd',
                extensions: ['dtd'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_dtd_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/dtd */ "./node_modules/@codemirror/legacy-modes/mode/dtd.js"));
                    return legacy(m.dtd);
                }
            },
            {
                name: 'Dylan',
                displayName: trans.__('Dylan'),
                mime: 'text/x-dylan',
                extensions: ['dylan', 'dyl', 'intr'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_dylan_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/dylan */ "./node_modules/@codemirror/legacy-modes/mode/dylan.js"));
                    return legacy(m.dylan);
                }
            },
            {
                name: 'EBNF',
                displayName: trans.__('EBNF'),
                mime: 'text/x-ebnf',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_ebnf_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/ebnf */ "./node_modules/@codemirror/legacy-modes/mode/ebnf.js"));
                    return legacy(m.ebnf);
                }
            },
            {
                name: 'ECL',
                displayName: trans.__('ECL'),
                mime: 'text/x-ecl',
                extensions: ['ecl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_ecl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/ecl */ "./node_modules/@codemirror/legacy-modes/mode/ecl.js"));
                    return legacy(m.ecl);
                }
            },
            {
                name: 'edn',
                displayName: trans.__('edn'),
                mime: 'application/edn',
                extensions: ['edn'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clojure_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clojure */ "./node_modules/@codemirror/legacy-modes/mode/clojure.js"));
                    return legacy(m.clojure);
                }
            },
            {
                name: 'Eiffel',
                displayName: trans.__('Eiffel'),
                mime: 'text/x-eiffel',
                extensions: ['e'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_eiffel_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/eiffel */ "./node_modules/@codemirror/legacy-modes/mode/eiffel.js"));
                    return legacy(m.eiffel);
                }
            },
            {
                name: 'Elm',
                displayName: trans.__('Elm'),
                mime: 'text/x-elm',
                extensions: ['elm'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_elm_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/elm */ "./node_modules/@codemirror/legacy-modes/mode/elm.js"));
                    return legacy(m.elm);
                }
            },
            {
                name: 'Erlang',
                displayName: trans.__('Erlang'),
                mime: 'text/x-erlang',
                extensions: ['erl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_erlang_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/erlang */ "./node_modules/@codemirror/legacy-modes/mode/erlang.js"));
                    return legacy(m.erlang);
                }
            },
            {
                name: 'Esper',
                displayName: trans.__('Esper'),
                mime: 'text/x-esper',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_sql_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/sql */ "./node_modules/@codemirror/legacy-modes/mode/sql.js"));
                    return legacy(m.esper);
                }
            },
            {
                name: 'Factor',
                displayName: trans.__('Factor'),
                mime: 'text/x-factor',
                extensions: ['factor'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_factor_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/factor */ "./node_modules/@codemirror/legacy-modes/mode/factor.js"));
                    return legacy(m.factor);
                }
            },
            {
                name: 'FCL',
                displayName: trans.__('FCL'),
                mime: 'text/x-fcl',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_fcl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/fcl */ "./node_modules/@codemirror/legacy-modes/mode/fcl.js"));
                    return legacy(m.fcl);
                }
            },
            {
                name: 'Forth',
                displayName: trans.__('Forth'),
                mime: 'text/x-forth',
                extensions: ['forth', 'fth', '4th'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_forth_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/forth */ "./node_modules/@codemirror/legacy-modes/mode/forth.js"));
                    return legacy(m.forth);
                }
            },
            {
                name: 'Fortran',
                displayName: trans.__('Fortran'),
                mime: 'text/x-fortran',
                extensions: ['f', 'for', 'f77', 'f90', 'f95'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_fortran_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/fortran */ "./node_modules/@codemirror/legacy-modes/mode/fortran.js"));
                    return legacy(m.fortran);
                }
            },
            {
                name: 'F#',
                displayName: trans.__('F#'),
                alias: ['fsharp'],
                mime: 'text/x-fsharp',
                extensions: ['fs'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mllike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mllike */ "./node_modules/@codemirror/legacy-modes/mode/mllike.js"));
                    return legacy(m.fSharp);
                }
            },
            {
                name: 'Gas',
                displayName: trans.__('Gas'),
                mime: 'text/x-gas',
                extensions: ['s'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_gas_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/gas */ "./node_modules/@codemirror/legacy-modes/mode/gas.js"));
                    return legacy(m.gas);
                }
            },
            {
                name: 'Gherkin',
                displayName: trans.__('Gherkin'),
                mime: 'text/x-feature',
                extensions: ['feature'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_gherkin_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/gherkin */ "./node_modules/@codemirror/legacy-modes/mode/gherkin.js"));
                    return legacy(m.gherkin);
                }
            },
            {
                name: 'Go',
                displayName: trans.__('Go'),
                mime: 'text/x-go',
                extensions: ['go'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_go_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/go */ "./node_modules/@codemirror/legacy-modes/mode/go.js"));
                    return legacy(m.go);
                }
            },
            {
                name: 'Groovy',
                displayName: trans.__('Groovy'),
                mime: 'text/x-groovy',
                extensions: ['groovy', 'gradle'],
                filename: /^Jenkinsfile$/,
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_groovy_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/groovy */ "./node_modules/@codemirror/legacy-modes/mode/groovy.js"));
                    return legacy(m.groovy);
                }
            },
            {
                name: 'Haskell',
                displayName: trans.__('Haskell'),
                mime: 'text/x-haskell',
                extensions: ['hs'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_haskell_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/haskell */ "./node_modules/@codemirror/legacy-modes/mode/haskell.js"));
                    return legacy(m.haskell);
                }
            },
            {
                name: 'Haxe',
                displayName: trans.__('Haxe'),
                mime: 'text/x-haxe',
                extensions: ['hx'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_haxe_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/haxe */ "./node_modules/@codemirror/legacy-modes/mode/haxe.js"));
                    return legacy(m.haxe);
                }
            },
            {
                name: 'HXML',
                displayName: trans.__('HXML'),
                mime: 'text/x-hxml',
                extensions: ['hxml'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_haxe_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/haxe */ "./node_modules/@codemirror/legacy-modes/mode/haxe.js"));
                    return legacy(m.hxml);
                }
            },
            {
                name: 'HTTP',
                displayName: trans.__('HTTP'),
                mime: 'message/http',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_http_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/http */ "./node_modules/@codemirror/legacy-modes/mode/http.js"));
                    return legacy(m.http);
                }
            },
            {
                name: 'IDL',
                displayName: trans.__('IDL'),
                mime: 'text/x-idl',
                extensions: ['pro'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_idl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/idl */ "./node_modules/@codemirror/legacy-modes/mode/idl.js"));
                    return legacy(m.idl);
                }
            },
            {
                name: 'JSON-LD',
                displayName: trans.__('JSON-LD'),
                alias: ['jsonld'],
                mime: 'application/ld+json',
                extensions: ['jsonld'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_javascript_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/javascript */ "./node_modules/@codemirror/legacy-modes/mode/javascript.js"));
                    return legacy(m.jsonld);
                }
            },
            {
                name: 'Jinja2',
                displayName: trans.__('Jinja2'),
                mime: 'text/jinja2',
                extensions: ['j2', 'jinja', 'jinja2'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_jinja2_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/jinja2 */ "./node_modules/@codemirror/legacy-modes/mode/jinja2.js"));
                    return legacy(m.jinja2);
                }
            },
            {
                name: 'Julia',
                displayName: trans.__('Julia'),
                mime: 'text/x-julia',
                extensions: ['jl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_julia_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/julia */ "./node_modules/@codemirror/legacy-modes/mode/julia.js"));
                    return legacy(m.julia);
                }
            },
            {
                name: 'Kotlin',
                displayName: trans.__('Kotlin'),
                mime: 'text/x-kotlin',
                extensions: ['kt'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clike */ "./node_modules/@codemirror/legacy-modes/mode/clike.js"));
                    return legacy(m.kotlin);
                }
            },
            {
                name: 'LESS',
                displayName: trans.__('LESS'),
                mime: 'text/x-less',
                extensions: ['less'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_css_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/css */ "./node_modules/@codemirror/legacy-modes/mode/css.js"));
                    return legacy(m.less);
                }
            },
            {
                name: 'LiveScript',
                displayName: trans.__('LiveScript'),
                alias: ['ls'],
                mime: 'text/x-livescript',
                extensions: ['ls'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_livescript_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/livescript */ "./node_modules/@codemirror/legacy-modes/mode/livescript.js"));
                    return legacy(m.liveScript);
                }
            },
            {
                name: 'Lua',
                displayName: trans.__('Lua'),
                mime: 'text/x-lua',
                extensions: ['lua'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_lua_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/lua */ "./node_modules/@codemirror/legacy-modes/mode/lua.js"));
                    return legacy(m.lua);
                }
            },
            {
                name: 'mIRC',
                displayName: trans.__('mIRC'),
                mime: 'text/mirc',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mirc_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mirc */ "./node_modules/@codemirror/legacy-modes/mode/mirc.js"));
                    return legacy(m.mirc);
                }
            },
            {
                name: 'Mathematica',
                displayName: trans.__('Mathematica'),
                mime: 'text/x-mathematica',
                extensions: ['m', 'nb', 'wl', 'wls'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mathematica_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mathematica */ "./node_modules/@codemirror/legacy-modes/mode/mathematica.js"));
                    return legacy(m.mathematica);
                }
            },
            {
                name: 'Modelica',
                displayName: trans.__('Modelica'),
                mime: 'text/x-modelica',
                extensions: ['mo'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_modelica_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/modelica */ "./node_modules/@codemirror/legacy-modes/mode/modelica.js"));
                    return legacy(m.modelica);
                }
            },
            {
                name: 'MUMPS',
                displayName: trans.__('MUMPS'),
                mime: 'text/x-mumps',
                extensions: ['mps'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mumps_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mumps */ "./node_modules/@codemirror/legacy-modes/mode/mumps.js"));
                    return legacy(m.mumps);
                }
            },
            {
                name: 'mbox',
                displayName: trans.__('mbox'),
                mime: 'application/mbox',
                extensions: ['mbox'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mbox_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mbox */ "./node_modules/@codemirror/legacy-modes/mode/mbox.js"));
                    return legacy(m.mbox);
                }
            },
            {
                name: 'Nginx',
                displayName: trans.__('Nginx'),
                mime: 'text/x-nginx-conf',
                filename: /nginx.*\.conf$/i,
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_nginx_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/nginx */ "./node_modules/@codemirror/legacy-modes/mode/nginx.js"));
                    return legacy(m.nginx);
                }
            },
            {
                name: 'NSIS',
                displayName: trans.__('NSIS'),
                mime: 'text/x-nsis',
                extensions: ['nsh', 'nsi'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_nsis_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/nsis */ "./node_modules/@codemirror/legacy-modes/mode/nsis.js"));
                    return legacy(m.nsis);
                }
            },
            {
                name: 'NTriples',
                displayName: trans.__('NTriples'),
                mime: [
                    'application/n-triples',
                    'application/n-quads',
                    'text/n-triples'
                ],
                extensions: ['nt', 'nq'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_ntriples_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/ntriples */ "./node_modules/@codemirror/legacy-modes/mode/ntriples.js"));
                    return legacy(m.ntriples);
                }
            },
            {
                name: 'Objective-C',
                displayName: trans.__('Objective-C'),
                alias: ['objective-c', 'objc'],
                mime: 'text/x-objectivec',
                extensions: ['m'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clike */ "./node_modules/@codemirror/legacy-modes/mode/clike.js"));
                    return legacy(m.objectiveC);
                }
            },
            {
                name: 'Objective-C++',
                displayName: trans.__('Objective-C++'),
                alias: ['objective-c++', 'objc++'],
                mime: 'text/x-objectivec++',
                extensions: ['mm'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clike */ "./node_modules/@codemirror/legacy-modes/mode/clike.js"));
                    return legacy(m.objectiveCpp);
                }
            },
            {
                name: 'OCaml',
                displayName: trans.__('OCaml'),
                mime: 'text/x-ocaml',
                extensions: ['ml', 'mli', 'mll', 'mly'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mllike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mllike */ "./node_modules/@codemirror/legacy-modes/mode/mllike.js"));
                    return legacy(m.oCaml);
                }
            },
            {
                name: 'Octave',
                displayName: trans.__('Octave'),
                mime: 'text/x-octave',
                extensions: ['m'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_octave_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/octave */ "./node_modules/@codemirror/legacy-modes/mode/octave.js"));
                    return legacy(m.octave);
                }
            },
            {
                name: 'Oz',
                displayName: trans.__('Oz'),
                mime: 'text/x-oz',
                extensions: ['oz'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_oz_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/oz */ "./node_modules/@codemirror/legacy-modes/mode/oz.js"));
                    return legacy(m.oz);
                }
            },
            {
                name: 'Pascal',
                displayName: trans.__('Pascal'),
                mime: 'text/x-pascal',
                extensions: ['p', 'pas'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_pascal_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/pascal */ "./node_modules/@codemirror/legacy-modes/mode/pascal.js"));
                    return legacy(m.pascal);
                }
            },
            {
                name: 'Perl',
                displayName: trans.__('Perl'),
                mime: 'text/x-perl',
                extensions: ['pl', 'pm'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_perl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/perl */ "./node_modules/@codemirror/legacy-modes/mode/perl.js"));
                    return legacy(m.perl);
                }
            },
            {
                name: 'Pig',
                displayName: trans.__('Pig'),
                mime: 'text/x-pig',
                extensions: ['pig'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_pig_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/pig */ "./node_modules/@codemirror/legacy-modes/mode/pig.js"));
                    return legacy(m.pig);
                }
            },
            {
                name: 'PowerShell',
                displayName: trans.__('PowerShell'),
                mime: 'application/x-powershell',
                extensions: ['ps1', 'psd1', 'psm1'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_powershell_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/powershell */ "./node_modules/@codemirror/legacy-modes/mode/powershell.js"));
                    return legacy(m.powerShell);
                }
            },
            {
                name: 'Properties files',
                displayName: trans.__('Properties files'),
                alias: ['ini', 'properties'],
                mime: 'text/x-properties',
                extensions: ['properties', 'ini', 'in'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_properties_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/properties */ "./node_modules/@codemirror/legacy-modes/mode/properties.js"));
                    return legacy(m.properties);
                }
            },
            {
                name: 'ProtoBuf',
                displayName: trans.__('ProtoBuf'),
                mime: 'text/x-protobuf',
                extensions: ['proto'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_protobuf_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/protobuf */ "./node_modules/@codemirror/legacy-modes/mode/protobuf.js"));
                    return legacy(m.protobuf);
                }
            },
            {
                name: 'Puppet',
                displayName: trans.__('Puppet'),
                mime: 'text/x-puppet',
                extensions: ['pp'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_puppet_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/puppet */ "./node_modules/@codemirror/legacy-modes/mode/puppet.js"));
                    return legacy(m.puppet);
                }
            },
            {
                name: 'Q',
                displayName: trans.__('Q'),
                mime: 'text/x-q',
                extensions: ['q'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_q_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/q */ "./node_modules/@codemirror/legacy-modes/mode/q.js"));
                    return legacy(m.q);
                }
            },
            {
                name: 'R',
                displayName: trans.__('R'),
                alias: ['rscript'],
                mime: 'text/x-rsrc',
                extensions: ['r', 'R'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_r_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/r */ "./node_modules/@codemirror/legacy-modes/mode/r.js"));
                    return legacy(m.r);
                }
            },
            {
                name: 'RPM Changes',
                displayName: trans.__('RPM Changes'),
                mime: 'text/x-rpm-changes',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_rpm_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/rpm */ "./node_modules/@codemirror/legacy-modes/mode/rpm.js"));
                    return legacy(m.rpmChanges);
                }
            },
            {
                name: 'RPM Spec',
                displayName: trans.__('RPM Spec'),
                mime: 'text/x-rpm-spec',
                extensions: ['spec'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_rpm_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/rpm */ "./node_modules/@codemirror/legacy-modes/mode/rpm.js"));
                    return legacy(m.rpmSpec);
                }
            },
            {
                name: 'Ruby',
                displayName: trans.__('Ruby'),
                alias: ['jruby', 'macruby', 'rake', 'rb', 'rbx'],
                mime: 'text/x-ruby',
                extensions: ['rb'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_ruby_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/ruby */ "./node_modules/@codemirror/legacy-modes/mode/ruby.js"));
                    return legacy(m.ruby);
                }
            },
            {
                name: 'SAS',
                displayName: trans.__('SAS'),
                mime: 'text/x-sas',
                extensions: ['sas'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_sas_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/sas */ "./node_modules/@codemirror/legacy-modes/mode/sas.js"));
                    return legacy(m.sas);
                }
            },
            {
                name: 'Scala',
                displayName: trans.__('Scala'),
                mime: 'text/x-scala',
                extensions: ['scala'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clike */ "./node_modules/@codemirror/legacy-modes/mode/clike.js"));
                    return legacy(m.scala);
                }
            },
            {
                name: 'Scheme',
                displayName: trans.__('Scheme'),
                mime: 'text/x-scheme',
                extensions: ['scm', 'ss'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_scheme_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/scheme */ "./node_modules/@codemirror/legacy-modes/mode/scheme.js"));
                    return legacy(m.scheme);
                }
            },
            {
                name: 'SCSS',
                displayName: trans.__('SCSS'),
                mime: 'text/x-scss',
                extensions: ['scss'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_css_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/css */ "./node_modules/@codemirror/legacy-modes/mode/css.js"));
                    return legacy(m.sCSS);
                }
            },
            {
                name: 'Shell',
                displayName: trans.__('Shell'),
                alias: ['bash', 'sh', 'zsh'],
                mime: ['text/x-sh', 'application/x-sh'],
                extensions: ['sh', 'ksh', 'bash'],
                filename: /^PKGBUILD$/,
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_shell_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/shell */ "./node_modules/@codemirror/legacy-modes/mode/shell.js"));
                    return legacy(m.shell);
                }
            },
            {
                name: 'Sieve',
                displayName: trans.__('Sieve'),
                mime: 'application/sieve',
                extensions: ['siv', 'sieve'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_sieve_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/sieve */ "./node_modules/@codemirror/legacy-modes/mode/sieve.js"));
                    return legacy(m.sieve);
                }
            },
            {
                name: 'Smalltalk',
                displayName: trans.__('Smalltalk'),
                mime: 'text/x-stsrc',
                extensions: ['st'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_smalltalk_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/smalltalk */ "./node_modules/@codemirror/legacy-modes/mode/smalltalk.js"));
                    return legacy(m.smalltalk);
                }
            },
            {
                name: 'Solr',
                displayName: trans.__('Solr'),
                mime: 'text/x-solr',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_solr_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/solr */ "./node_modules/@codemirror/legacy-modes/mode/solr.js"));
                    return legacy(m.solr);
                }
            },
            {
                name: 'SML',
                displayName: trans.__('SML'),
                mime: 'text/x-sml',
                extensions: ['sml', 'sig', 'fun', 'smackspec'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mllike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mllike */ "./node_modules/@codemirror/legacy-modes/mode/mllike.js"));
                    return legacy(m.sml);
                }
            },
            {
                name: 'SPARQL',
                displayName: trans.__('SPARQL'),
                alias: ['sparul'],
                mime: 'application/sparql-query',
                extensions: ['rq', 'sparql'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_sparql_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/sparql */ "./node_modules/@codemirror/legacy-modes/mode/sparql.js"));
                    return legacy(m.sparql);
                }
            },
            {
                name: 'Spreadsheet',
                displayName: trans.__('Spreadsheet'),
                alias: ['excel', 'formula'],
                mime: 'text/x-spreadsheet',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_spreadsheet_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/spreadsheet */ "./node_modules/@codemirror/legacy-modes/mode/spreadsheet.js"));
                    return legacy(m.spreadsheet);
                }
            },
            {
                name: 'Squirrel',
                displayName: trans.__('Squirrel'),
                mime: 'text/x-squirrel',
                extensions: ['nut'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_clike_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/clike */ "./node_modules/@codemirror/legacy-modes/mode/clike.js"));
                    return legacy(m.squirrel);
                }
            },
            {
                name: 'Stylus',
                displayName: trans.__('Stylus'),
                mime: 'text/x-styl',
                extensions: ['styl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_stylus_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/stylus */ "./node_modules/@codemirror/legacy-modes/mode/stylus.js"));
                    return legacy(m.stylus);
                }
            },
            {
                name: 'Swift',
                displayName: trans.__('Swift'),
                mime: 'text/x-swift',
                extensions: ['swift'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_swift_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/swift */ "./node_modules/@codemirror/legacy-modes/mode/swift.js"));
                    return legacy(m.swift);
                }
            },
            {
                name: 'sTeX',
                displayName: trans.__('sTeX'),
                mime: 'text/x-stex',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_stex_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/stex */ "./node_modules/@codemirror/legacy-modes/mode/stex.js"));
                    return legacy(m.stex);
                }
            },
            {
                name: 'LaTeX',
                displayName: trans.__('LaTeX'),
                alias: ['tex'],
                mime: 'text/x-latex',
                extensions: ['text', 'ltx', 'tex'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_stex_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/stex */ "./node_modules/@codemirror/legacy-modes/mode/stex.js"));
                    return legacy(m.stex);
                }
            },
            {
                name: 'SystemVerilog',
                displayName: trans.__('SystemVerilog'),
                mime: 'text/x-systemverilog',
                extensions: ['v', 'sv', 'svh'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_verilog_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/verilog */ "./node_modules/@codemirror/legacy-modes/mode/verilog.js"));
                    return legacy(m.verilog);
                }
            },
            {
                name: 'Tcl',
                displayName: trans.__('Tcl'),
                mime: 'text/x-tcl',
                extensions: ['tcl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_tcl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/tcl */ "./node_modules/@codemirror/legacy-modes/mode/tcl.js"));
                    return legacy(m.tcl);
                }
            },
            {
                name: 'Textile',
                displayName: trans.__('Textile'),
                mime: 'text/x-textile',
                extensions: ['textile'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_textile_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/textile */ "./node_modules/@codemirror/legacy-modes/mode/textile.js"));
                    return legacy(m.textile);
                }
            },
            {
                name: 'TiddlyWiki',
                displayName: trans.__('TiddlyWiki'),
                mime: 'text/x-tiddlywiki',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_tiddlywiki_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/tiddlywiki */ "./node_modules/@codemirror/legacy-modes/mode/tiddlywiki.js"));
                    return legacy(m.tiddlyWiki);
                }
            },
            {
                name: 'Tiki wiki',
                displayName: trans.__('Tiki wiki'),
                mime: 'text/tiki',
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_tiki_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/tiki */ "./node_modules/@codemirror/legacy-modes/mode/tiki.js"));
                    return legacy(m.tiki);
                }
            },
            {
                name: 'TOML',
                displayName: trans.__('TOML'),
                mime: 'text/x-toml',
                extensions: ['toml'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_toml_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/toml */ "./node_modules/@codemirror/legacy-modes/mode/toml.js"));
                    return legacy(m.toml);
                }
            },
            {
                name: 'troff',
                displayName: trans.__('troff'),
                mime: 'text/troff',
                extensions: ['1', '2', '3', '4', '5', '6', '7', '8', '9'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_troff_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/troff */ "./node_modules/@codemirror/legacy-modes/mode/troff.js"));
                    return legacy(m.troff);
                }
            },
            {
                name: 'TTCN',
                displayName: trans.__('TTCN'),
                mime: 'text/x-ttcn',
                extensions: ['ttcn', 'ttcn3', 'ttcnpp'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_ttcn_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/ttcn */ "./node_modules/@codemirror/legacy-modes/mode/ttcn.js"));
                    return legacy(m.ttcn);
                }
            },
            {
                name: 'TTCN_CFG',
                displayName: trans.__('TTCN_CFG'),
                mime: 'text/x-ttcn-cfg',
                extensions: ['cfg'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_ttcn-cfg_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/ttcn-cfg */ "./node_modules/@codemirror/legacy-modes/mode/ttcn-cfg.js"));
                    return legacy(m.ttcnCfg);
                }
            },
            {
                name: 'Turtle',
                displayName: trans.__('Turtle'),
                mime: 'text/turtle',
                extensions: ['ttl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_turtle_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/turtle */ "./node_modules/@codemirror/legacy-modes/mode/turtle.js"));
                    return legacy(m.turtle);
                }
            },
            {
                name: 'Web IDL',
                displayName: trans.__('Web IDL'),
                mime: 'text/x-webidl',
                extensions: ['webidl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_webidl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/webidl */ "./node_modules/@codemirror/legacy-modes/mode/webidl.js"));
                    return legacy(m.webIDL);
                }
            },
            {
                name: 'VB.NET',
                displayName: trans.__('VB.NET'),
                mime: 'text/x-vb',
                extensions: ['vb'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_vb_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/vb */ "./node_modules/@codemirror/legacy-modes/mode/vb.js"));
                    return legacy(m.vb);
                }
            },
            {
                name: 'VBScript',
                displayName: trans.__('VBScript'),
                mime: 'text/vbscript',
                extensions: ['vbs'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_vbscript_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/vbscript */ "./node_modules/@codemirror/legacy-modes/mode/vbscript.js"));
                    return legacy(m.vbScript);
                }
            },
            {
                name: 'Velocity',
                displayName: trans.__('Velocity'),
                mime: 'text/velocity',
                extensions: ['vtl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_velocity_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/velocity */ "./node_modules/@codemirror/legacy-modes/mode/velocity.js"));
                    return legacy(m.velocity);
                }
            },
            {
                name: 'Verilog',
                displayName: trans.__('Verilog'),
                mime: 'text/x-verilog',
                extensions: ['v'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_verilog_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/verilog */ "./node_modules/@codemirror/legacy-modes/mode/verilog.js"));
                    return legacy(m.verilog);
                }
            },
            {
                name: 'VHDL',
                displayName: trans.__('VHDL'),
                mime: 'text/x-vhdl',
                extensions: ['vhd', 'vhdl'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_vhdl_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/vhdl */ "./node_modules/@codemirror/legacy-modes/mode/vhdl.js"));
                    return legacy(m.vhdl);
                }
            },
            {
                name: 'XQuery',
                displayName: trans.__('XQuery'),
                mime: 'application/xquery',
                extensions: ['xy', 'xquery'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "vendors-node_modules_codemirror_legacy-modes_mode_xquery_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/xquery */ "./node_modules/@codemirror/legacy-modes/mode/xquery.js"));
                    return legacy(m.xQuery);
                }
            },
            {
                name: 'Yacas',
                displayName: trans.__('Yacas'),
                mime: 'text/x-yacas',
                extensions: ['ys'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_yacas_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/yacas */ "./node_modules/@codemirror/legacy-modes/mode/yacas.js"));
                    return legacy(m.yacas);
                }
            },
            {
                name: 'YAML',
                displayName: trans.__('YAML'),
                alias: ['yml'],
                mime: ['text/x-yaml', 'text/yaml'],
                extensions: ['yaml', 'yml'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_yaml_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/yaml */ "./node_modules/@codemirror/legacy-modes/mode/yaml.js"));
                    return legacy(m.yaml);
                }
            },
            {
                name: 'Z80',
                displayName: trans.__('Z80'),
                mime: 'text/x-z80',
                extensions: ['z80'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_z80_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/z80 */ "./node_modules/@codemirror/legacy-modes/mode/z80.js"));
                    return legacy(m.z80);
                }
            },
            {
                name: 'mscgen',
                displayName: trans.__('mscgen'),
                mime: 'text/x-mscgen',
                extensions: ['mscgen', 'mscin', 'msc'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mscgen_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mscgen */ "./node_modules/@codemirror/legacy-modes/mode/mscgen.js"));
                    return legacy(m.mscgen);
                }
            },
            {
                name: 'xu',
                displayName: trans.__('xu'),
                mime: 'text/x-xu',
                extensions: ['xu'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mscgen_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mscgen */ "./node_modules/@codemirror/legacy-modes/mode/mscgen.js"));
                    return legacy(m.xu);
                }
            },
            {
                name: 'msgenny',
                displayName: trans.__('msgenny'),
                mime: 'text/x-msgenny',
                extensions: ['msgenny'],
                async load() {
                    const m = await __webpack_require__.e(/*! import() */ "node_modules_codemirror_legacy-modes_mode_mscgen_js").then(__webpack_require__.bind(__webpack_require__, /*! @codemirror/legacy-modes/mode/mscgen */ "./node_modules/@codemirror/legacy-modes/mode/mscgen.js"));
                    return legacy(m.msgenny);
                }
            }
        ];
    }
    EditorLanguageRegistry.getDefaultLanguages = getDefaultLanguages;
})(EditorLanguageRegistry || (EditorLanguageRegistry = {}));
//# sourceMappingURL=language.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/mimetype.js":
/*!*************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/mimetype.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeMirrorMimeTypeService: () => (/* binding */ CodeMirrorMimeTypeService)
/* harmony export */ });
/* harmony import */ var _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/codeeditor */ "./node_modules/@jupyterlab/codeeditor/lib/mimetype.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.


/**
 * The mime type service for CodeMirror.
 */
class CodeMirrorMimeTypeService {
    constructor(languages) {
        this.languages = languages;
    }
    /**
     * Returns a mime type for the given language info.
     *
     * #### Notes
     * If a mime type cannot be found returns the default mime type `text/plain`, never `null`.
     * There may be more than one mime type, but only the first one will be returned.
     * To access all mime types, use `IEditorLanguageRegistry` instead.
     */
    getMimeTypeByLanguage(info) {
        var _a;
        const ext = info.file_extension || '';
        const mode = this.languages.findBest(info.codemirror_mode || {
            mimetype: info.mimetype,
            name: info.name,
            ext: [ext.split('.').slice(-1)[0]]
        });
        return mode
            ? Array.isArray(mode.mime)
                ? (_a = mode.mime[0]) !== null && _a !== void 0 ? _a : _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.IEditorMimeTypeService.defaultMimeType
                : mode.mime
            : _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.IEditorMimeTypeService.defaultMimeType;
    }
    /**
     * Returns a mime type for the given file path.
     *
     * #### Notes
     * If a mime type cannot be found returns the default mime type `text/plain`, never `null`.
     * There may be more than one mime type, but only the first one will be returned.
     * To access all mime types, use `IEditorLanguageRegistry` instead.
     */
    getMimeTypeByFilePath(path) {
        var _a;
        const ext = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.extname(path);
        if (ext === '.ipy') {
            return 'text/x-python';
        }
        else if (ext === '.md') {
            return 'text/x-ipythongfm';
        }
        const mode = this.languages.findByFileName(path);
        return mode
            ? Array.isArray(mode.mime)
                ? (_a = mode.mime[0]) !== null && _a !== void 0 ? _a : _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.IEditorMimeTypeService.defaultMimeType
                : mode.mime
            : _jupyterlab_codeeditor__WEBPACK_IMPORTED_MODULE_0__.IEditorMimeTypeService.defaultMimeType;
    }
}
//# sourceMappingURL=mimetype.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/searchprovider.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/searchprovider.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CodeMirrorSearchHighlighter: () => (/* binding */ CodeMirrorSearchHighlighter),
/* harmony export */   EditorSearchProvider: () => (/* binding */ EditorSearchProvider)
/* harmony export */ });
/* harmony import */ var _codemirror_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @codemirror/state */ "./node_modules/@codemirror/state/dist/index.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/documentsearch */ "./node_modules/@jupyterlab/documentsearch/lib/providers/genericsearchprovider.js");
/* harmony import */ var _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/documentsearch */ "./node_modules/@jupyterlab/documentsearch/lib/providers/textprovider.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * Search provider for editors.
 */
class EditorSearchProvider {
    /**
     * Constructor
     */
    constructor() {
        /**
         * Current match index
         */
        this.currentIndex = null;
        /**
         * Current search query
         */
        this.query = null;
        this._isActive = true;
        this._inSelection = null;
        this._isDisposed = false;
        this._cmHandler = null;
        this.currentIndex = null;
        this._stateChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal(this);
    }
    /**
     * CodeMirror search highlighter
     */
    get cmHandler() {
        if (!this._cmHandler) {
            this._cmHandler = new CodeMirrorSearchHighlighter(this.editor);
        }
        return this._cmHandler;
    }
    /**
     * Changed signal to be emitted when search matches change.
     */
    get stateChanged() {
        return this._stateChanged;
    }
    /**
     * Current match index
     */
    get currentMatchIndex() {
        return this.isActive ? this.currentIndex : null;
    }
    /**
     * Whether the cell search is active.
     *
     * This is used when applying search only on selected cells.
     */
    get isActive() {
        return this._isActive;
    }
    /**
     * Whether the search provider is disposed or not.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Number of matches in the cell.
     */
    get matchesCount() {
        return this.isActive ? this.cmHandler.matches.length : 0;
    }
    /**
     * Clear currently highlighted match
     */
    clearHighlight() {
        this.currentIndex = null;
        this.cmHandler.clearHighlight();
        return Promise.resolve();
    }
    /**
     * Dispose the search provider
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
        if (this.isActive) {
            this.endQuery().catch(reason => {
                console.error(`Failed to end search query on cells.`, reason);
            });
        }
    }
    /**
     * Set `isActive` status.
     *
     * #### Notes
     * It will start or end the search
     *
     * @param v New value
     */
    async setIsActive(v) {
        if (this._isActive === v) {
            return;
        }
        this._isActive = v;
        if (this._isActive) {
            if (this.query !== null) {
                await this.startQuery(this.query, this.filters);
            }
        }
        else {
            await this.endQuery();
        }
    }
    /**
     * Set whether search should be limitted to specified text selection.
     */
    async setSearchSelection(selection) {
        if (this._inSelection === selection) {
            return;
        }
        this._inSelection = selection;
        await this.updateCodeMirror(this.model.sharedModel.getSource());
        this._stateChanged.emit();
    }
    /**
     * Set whether user selection should be protected from modifications.
     *
     * If disabled, the selection will be updated on search and on editor focus
     * to cover the current match. We need to protect selection from modifications
     * for both: search in text and search in cells; since `setSearchSelection`
     * is only telling us about search in text, we need to have an additional
     * way to signal that either search in text or in cells is active, or for
     * any other reason selection range should be protected.
     */
    setProtectSelection(v) {
        this.cmHandler.protectSelection = v;
    }
    /**
     * Initialize the search using the provided options. Should update the UI
     * to highlight all matches and "select" the first match.
     *
     * @param query A RegExp to be use to perform the search
     * @param filters Filter parameters to pass to provider
     */
    async startQuery(query, filters) {
        this.query = query;
        this.filters = filters;
        // Search input
        const content = this.model.sharedModel.getSource();
        await this.updateCodeMirror(content);
        this.model.sharedModel.changed.connect(this.onSharedModelChanged, this);
    }
    /**
     * Stop the search and clean any UI elements.
     */
    async endQuery() {
        await this.clearHighlight();
        await this.cmHandler.endQuery();
        this.currentIndex = null;
    }
    /**
     * Highlight the next match.
     *
     * @returns The next match if there is one.
     */
    async highlightNext(loop = true, options) {
        if (this.matchesCount === 0 || !this.isActive) {
            this.currentIndex = null;
        }
        else {
            let match = await this.cmHandler.highlightNext(options);
            if (match) {
                this.currentIndex = this.cmHandler.currentIndex;
            }
            else {
                // Note: the loop logic is only used in single-editor (e.g. file editor)
                // provider sub-classes, notebook has it's own loop logic and ignores
                // `currentIndex` as set here.
                this.currentIndex = loop ? 0 : null;
            }
            return match;
        }
        return Promise.resolve(this.getCurrentMatch());
    }
    /**
     * Highlight the previous match.
     *
     * @returns The previous match if there is one.
     */
    async highlightPrevious(loop = true, options) {
        if (this.matchesCount === 0 || !this.isActive) {
            this.currentIndex = null;
        }
        else {
            let match = await this.cmHandler.highlightPrevious(options);
            if (match) {
                this.currentIndex = this.cmHandler.currentIndex;
            }
            else {
                this.currentIndex = loop ? this.matchesCount - 1 : null;
            }
            return match;
        }
        return Promise.resolve(this.getCurrentMatch());
    }
    /**
     * Replace the currently selected match with the provided text.
     *
     * If no match is selected, it won't do anything.
     *
     * The caller of this method is expected to call `highlightNext` if after
     * calling `replaceCurrentMatch()` attribute `this.currentIndex` is null.
     * It is necesary to let the caller handle highlighting because this
     * method is used in composition pattern (search engine of notebook cells)
     * and highligthing on the composer (notebook) level needs to switch to next
     * engine (cell) with matches.
     *
     * @param newText The replacement text.
     * @returns Whether a replace occurred.
     */
    replaceCurrentMatch(newText, loop, options) {
        if (!this.isActive) {
            return Promise.resolve(false);
        }
        let occurred = false;
        if (this.currentIndex !== null &&
            this.currentIndex < this.cmHandler.matches.length) {
            const match = this.getCurrentMatch();
            // If cursor there is no match selected, highlight the next match
            if (!match) {
                this.currentIndex = null;
            }
            else {
                this.cmHandler.matches.splice(this.currentIndex, 1);
                this.currentIndex =
                    this.currentIndex < this.cmHandler.matches.length
                        ? Math.max(this.currentIndex - 1, 0)
                        : null;
                const substitutedText = (options === null || options === void 0 ? void 0 : options.regularExpression)
                    ? match.text.replace(this.query, newText)
                    : newText;
                const insertText = (options === null || options === void 0 ? void 0 : options.preserveCase)
                    ? _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_1__.GenericSearchProvider.preserveCase(match.text, substitutedText)
                    : substitutedText;
                this.model.sharedModel.updateSource(match.position, match.position + match.text.length, insertText);
                occurred = true;
            }
        }
        return Promise.resolve(occurred);
    }
    /**
     * Replace all matches in the cell source with the provided text
     *
     * @param newText The replacement text.
     * @returns Whether a replace occurred.
     */
    replaceAllMatches(newText, options) {
        if (!this.isActive) {
            return Promise.resolve(false);
        }
        let occurred = this.cmHandler.matches.length > 0;
        let src = this.model.sharedModel.getSource();
        let lastEnd = 0;
        const finalSrc = this.cmHandler.matches.reduce((agg, match) => {
            const start = match.position;
            const end = start + match.text.length;
            const substitutedText = (options === null || options === void 0 ? void 0 : options.regularExpression)
                ? match.text.replace(this.query, newText)
                : newText;
            const insertText = (options === null || options === void 0 ? void 0 : options.preserveCase)
                ? _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_1__.GenericSearchProvider.preserveCase(match.text, substitutedText)
                : substitutedText;
            const newStep = `${agg}${src.slice(lastEnd, start)}${insertText}`;
            lastEnd = end;
            return newStep;
        }, '');
        if (occurred) {
            this.cmHandler.matches = [];
            this.currentIndex = null;
            this.model.sharedModel.setSource(`${finalSrc}${src.slice(lastEnd)}`);
        }
        return Promise.resolve(occurred);
    }
    /**
     * Get the current match if it exists.
     *
     * @returns The current match
     */
    getCurrentMatch() {
        if (this.currentIndex === null) {
            return undefined;
        }
        else {
            let match = undefined;
            if (this.currentIndex < this.cmHandler.matches.length) {
                match = this.cmHandler.matches[this.currentIndex];
            }
            return match;
        }
    }
    /**
     * Callback on source change
     *
     * @param emitter Source of the change
     * @param changes Source change
     */
    async onSharedModelChanged(emitter, changes) {
        if (changes.sourceChange) {
            await this.updateCodeMirror(emitter.getSource());
            this._stateChanged.emit();
        }
    }
    /**
     * Update matches
     */
    async updateCodeMirror(content) {
        if (this.query !== null && this.isActive) {
            const allMatches = await _jupyterlab_documentsearch__WEBPACK_IMPORTED_MODULE_2__.TextSearchEngine.search(this.query, content);
            if (this._inSelection) {
                const editor = this.editor;
                const start = editor.getOffsetAt(this._inSelection.start);
                const end = editor.getOffsetAt(this._inSelection.end);
                this.cmHandler.matches = allMatches.filter(match => match.position >= start && match.position <= end);
                // A special case to always have a current match when in line selection mode.
                if (this.cmHandler.currentIndex === null &&
                    this.cmHandler.matches.length > 0) {
                    await this.cmHandler.highlightNext({
                        from: 'selection',
                        select: false,
                        scroll: false
                    });
                }
                this.currentIndex = this.cmHandler.currentIndex;
            }
            else {
                this.cmHandler.matches = allMatches;
            }
        }
        else {
            this.cmHandler.matches = [];
        }
    }
}
/**
 * Helper class to highlight texts in a code mirror editor.
 *
 * Highlighted texts (aka `matches`) must be provided through
 * the `matches` attributes.
 *
 * **NOTES:**
 * - to retain the selection visibility `drawSelection` extension is needed.
 * - highlighting starts from the cursor (if editor is focused and `from` is set
 *   to `'auto'`, cursor moved, or `from` argument is set to `'selection'` or
 *   `'selection-start'`), or from last "current" match otherwise.
 * - `currentIndex` is the (readonly) source of truth for the current match.
 */
class CodeMirrorSearchHighlighter {
    /**
     * Constructor
     *
     * @param editor The CodeMirror editor
     */
    constructor(editor) {
        this._current = null;
        this._cm = editor;
        this._matches = new Array();
        this._currentIndex = null;
        this._highlightEffect = _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateEffect.define({
            map: (value, mapping) => {
                const transform = (v) => ({
                    text: v.text,
                    position: mapping.mapPos(v.position)
                });
                return {
                    matches: value.matches.map(transform),
                    currentMatch: value.currentMatch
                        ? transform(value.currentMatch)
                        : null
                };
            }
        });
        this._highlightMark = _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.Decoration.mark({ class: 'cm-searching' });
        this._currentMark = _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.Decoration.mark({ class: 'jp-current-match' });
        this._highlightField = _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateField.define({
            create: () => {
                return _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.Decoration.none;
            },
            update: (highlights, transaction) => {
                highlights = highlights.map(transaction.changes);
                for (let ef of transaction.effects) {
                    if (ef.is(this._highlightEffect)) {
                        const e = ef;
                        if (e.value.matches.length) {
                            // Note: nesting will vary; sometimes `.cm-searching` will be
                            // inside `.jp-current-match`, sometime the other way round.
                            highlights = highlights.update({
                                add: e.value.matches.map(m => this._highlightMark.range(m.position, m.position + m.text.length)),
                                // filter out old marks
                                filter: () => false
                            });
                            highlights = highlights.update({
                                add: e.value.currentMatch
                                    ? [
                                        this._currentMark.range(e.value.currentMatch.position, e.value.currentMatch.position +
                                            e.value.currentMatch.text.length)
                                    ]
                                    : []
                            });
                        }
                        else {
                            highlights = _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.Decoration.none;
                        }
                    }
                }
                return highlights;
            },
            provide: f => _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.EditorView.decorations.from(f)
        });
        this._domEventHandlers = _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.EditorView.domEventHandlers({
            focus: () => {
                // Set cursor on active match when editor gets focused.
                this._selectCurrentMatch();
            }
        });
    }
    /**
     * The current index of the selected match.
     */
    get currentIndex() {
        return this._currentIndex;
    }
    /**
     * The list of matches
     */
    get matches() {
        return this._matches;
    }
    set matches(v) {
        this._matches = v;
        if (this._currentIndex !== null &&
            this._currentIndex > this._matches.length) {
            this._currentIndex = this._matches.length > 0 ? 0 : null;
        }
        this._highlightCurrentMatch({ select: false });
    }
    /**
     * Whether the cursor/selection should not be modified.
     */
    get protectSelection() {
        return this._protectSelection;
    }
    set protectSelection(v) {
        this._protectSelection = v;
    }
    /**
     * Clear all highlighted matches
     */
    clearHighlight() {
        this._currentIndex = null;
        this._highlightCurrentMatch();
    }
    /**
     * Clear the highlighted matches.
     */
    endQuery() {
        this._currentIndex = null;
        this._matches = [];
        if (this._cm) {
            this._cm.editor.dispatch({
                effects: this._highlightEffect.of({ matches: [], currentMatch: null })
            });
        }
        return Promise.resolve();
    }
    /**
     * Highlight the next match
     *
     * @returns The next match if available
     */
    highlightNext(options) {
        var _a;
        this._currentIndex = this._findNext(false, (_a = options === null || options === void 0 ? void 0 : options.from) !== null && _a !== void 0 ? _a : 'auto');
        this._highlightCurrentMatch(options);
        return Promise.resolve(this._currentIndex !== null
            ? this._matches[this._currentIndex]
            : undefined);
    }
    /**
     * Highlight the previous match
     *
     * @returns The previous match if available
     */
    highlightPrevious(options) {
        var _a;
        this._currentIndex = this._findNext(true, (_a = options === null || options === void 0 ? void 0 : options.from) !== null && _a !== void 0 ? _a : 'auto');
        this._highlightCurrentMatch(options);
        return Promise.resolve(this._currentIndex !== null
            ? this._matches[this._currentIndex]
            : undefined);
    }
    /**
     * Set the editor
     *
     * @param editor Editor
     */
    setEditor(editor) {
        if (this._cm) {
            throw new Error('CodeMirrorEditor already set.');
        }
        else {
            this._cm = editor;
            if (this._currentIndex !== null) {
                this._highlightCurrentMatch();
            }
            this._cm.editor.dispatch({
                effects: _codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateEffect.appendConfig.of(this._domEventHandlers)
            });
            this._refresh();
        }
    }
    _selectCurrentMatch(scroll = true) {
        // This method has two responsibilities:
        // 1) Scroll the current match into the view - useful for long lines,
        //    and file editors with more lines that fit on the screen
        // 2) When user has focus on the editor (not search box) and presses
        //    ctrl + g/ctrl + shift + g to jump to next match they want their
        //    cursor to jump too.
        // We execute (1) and (2) together as CodeMirror has a special code path
        // to handle both in a single dispatch.
        // The (2) case is inapplicable to search in selection mode, as it would
        // invalidate the query selection, so in that case we only execute (1).
        const match = this._current;
        if (!match) {
            return;
        }
        if (!this._cm) {
            return;
        }
        const cursor = {
            anchor: match.position,
            head: match.position + match.text.length
        };
        const selection = this._cm.editor.state.selection.main;
        if ((selection.from === match.position &&
            selection.to === match.position + match.text.length) ||
            this._protectSelection) {
            // Correct selection is already set or search is restricted to selection:
            // scroll without changing the selection.
            if (scroll) {
                this._cm.editor.dispatch({
                    effects: _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.EditorView.scrollIntoView(_codemirror_state__WEBPACK_IMPORTED_MODULE_3__.EditorSelection.range(cursor.anchor, cursor.head))
                });
                return;
            }
        }
        else {
            this._cm.editor.dispatch({
                selection: cursor,
                scrollIntoView: scroll
            });
        }
    }
    _highlightCurrentMatch(options) {
        var _a, _b, _c;
        if (!this._cm) {
            // no-op
            return;
        }
        // Highlight the current index
        if (this._currentIndex !== null) {
            const match = this.matches[this._currentIndex];
            this._current = match;
            // We do not change selection nor scroll if:
            // - user is selecting text,
            // - document was modified
            if ((_a = options === null || options === void 0 ? void 0 : options.select) !== null && _a !== void 0 ? _a : true) {
                if (this._cm.hasFocus()) {
                    // If editor is focused we actually set the cursor on the match.
                    this._selectCurrentMatch((_b = options === null || options === void 0 ? void 0 : options.scroll) !== null && _b !== void 0 ? _b : true);
                }
                else if ((_c = options === null || options === void 0 ? void 0 : options.scroll) !== null && _c !== void 0 ? _c : true) {
                    // otherwise we just scroll to preserve the selection.
                    this._cm.editor.dispatch({
                        effects: _codemirror_view__WEBPACK_IMPORTED_MODULE_4__.EditorView.scrollIntoView(match.position)
                    });
                }
            }
        }
        else {
            this._current = null;
        }
        this._refresh();
    }
    _refresh() {
        if (!this._cm) {
            // no-op
            return;
        }
        let effects = [
            this._highlightEffect.of({
                matches: this.matches,
                currentMatch: this._current
            })
        ];
        if (!this._cm.state.field(this._highlightField, false)) {
            effects.push(_codemirror_state__WEBPACK_IMPORTED_MODULE_3__.StateEffect.appendConfig.of([this._highlightField]));
        }
        this._cm.editor.dispatch({ effects });
    }
    _findNext(reverse, from = 'auto') {
        var _a, _b, _c, _d;
        if (this._matches.length === 0) {
            // No-op
            return null;
        }
        // If the editor has not be instantiated yet (e.g. a cell that has not yet be seen in the viewport),
        // force the behavior
        if (!this._cm && !['previous-match', 'start'].includes(from)) {
            from = 'previous-match';
        }
        let lastPosition = 0;
        if ((from === 'auto' && ((_b = (_a = this._cm) === null || _a === void 0 ? void 0 : _a.hasFocus()) !== null && _b !== void 0 ? _b : false)) ||
            from === 'selection') {
            const cursor = this._cm.state.selection.main;
            lastPosition = reverse ? cursor.anchor : cursor.head;
        }
        else if (from === 'selection-start') {
            const cursor = this._cm.state.selection.main;
            lastPosition = Math.min(cursor.anchor, cursor.head);
        }
        else if (from === 'start') {
            lastPosition = 0;
        }
        else if (this._current) {
            lastPosition = reverse
                ? this._current.position
                : this._current.position + this._current.text.length;
        }
        if (lastPosition === 0 && reverse && this.currentIndex === null) {
            // The default position is (0, 0) but we want to start from the end in that case
            // Fallback to the end of the latest match if the editor is not instantiated
            lastPosition =
                (_d = (_c = this._cm) === null || _c === void 0 ? void 0 : _c.doc.length) !== null && _d !== void 0 ? _d : endLastMatch(this._matches[this._matches.length - 1]);
        }
        const position = lastPosition;
        let found = Utils.findNext(this._matches, position, 0, this._matches.length - 1);
        if (found === null) {
            // Don't loop
            return reverse ? this._matches.length - 1 : null;
        }
        if (reverse) {
            found -= 1;
            if (found < 0) {
                // Don't loop
                return null;
            }
        }
        return found;
        function endLastMatch(lastMatch) {
            return lastMatch ? lastMatch.position + lastMatch.text.length : 0;
        }
    }
}
/**
 * Helpers namespace
 */
var Utils;
(function (Utils) {
    /**
     * Find the closest match at `position` just after it.
     *
     * #### Notes
     * Search is done using a binary search algorithm
     *
     * @param matches List of matches
     * @param position Searched position
     * @param lowerBound Lower range index
     * @param higherBound High range index
     * @returns The next match or null if none exists
     */
    function findNext(matches, position, lowerBound = 0, higherBound = Infinity) {
        higherBound = Math.min(matches.length - 1, higherBound);
        while (lowerBound <= higherBound) {
            let middle = Math.floor(0.5 * (lowerBound + higherBound));
            const currentPosition = matches[middle].position;
            if (currentPosition < position) {
                lowerBound = middle + 1;
                if (lowerBound < matches.length &&
                    matches[lowerBound].position > position) {
                    return lowerBound;
                }
            }
            else if (currentPosition > position) {
                higherBound = middle - 1;
                if (higherBound > 0 && matches[higherBound].position < position) {
                    return middle;
                }
            }
            else {
                return middle;
            }
        }
        // Next could be the first item
        const first = lowerBound > 0 ? lowerBound - 1 : 0;
        const match = matches[first];
        return match.position >= position ? first : null;
    }
    Utils.findNext = findNext;
})(Utils || (Utils = {}));
//# sourceMappingURL=searchprovider.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/theme.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/theme.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EditorThemeRegistry: () => (/* binding */ EditorThemeRegistry),
/* harmony export */   jupyterEditorTheme: () => (/* binding */ jupyterEditorTheme),
/* harmony export */   jupyterHighlightStyle: () => (/* binding */ jupyterHighlightStyle),
/* harmony export */   jupyterTheme: () => (/* binding */ jupyterTheme)
/* harmony export */ });
/* harmony import */ var _codemirror_language__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @codemirror/language */ "./node_modules/@codemirror/language/dist/index.js");
/* harmony import */ var _codemirror_view__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @codemirror/view */ "./node_modules/@codemirror/view/dist/index.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lezer/highlight */ "./node_modules/@lezer/highlight/dist/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




const jupyterEditorTheme = _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.EditorView.theme({
    /**
     * CodeMirror themes are handling the background/color in this way. This works
     * fine for CodeMirror editors outside the notebook, but the notebook styles
     * these things differently.
     */
    '&': {
        background: 'var(--jp-layout-color0)',
        color: 'var(--jp-content-font-color1)'
    },
    /* In the notebook, we want this styling to be handled by its container */
    '.jp-CodeConsole &, .jp-Notebook &': {
        background: 'transparent'
    },
    '.cm-content': {
        caretColor: 'var(--jp-editor-cursor-color)'
    },
    /* Inherit font family from .cm-editor */
    '.cm-scroller': {
        fontFamily: 'inherit'
    },
    '.cm-cursor, .cm-dropCursor': {
        borderLeft: 'var(--jp-code-cursor-width0) solid var(--jp-editor-cursor-color)'
    },
    '.cm-selectionBackground, .cm-content ::selection': {
        backgroundColor: 'var(--jp-editor-selected-background)'
    },
    '&.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground': {
        backgroundColor: 'var(--jp-editor-selected-focused-background)'
    },
    '.cm-gutters': {
        borderRight: '1px solid var(--jp-border-color2)',
        backgroundColor: 'var(--jp-layout-color2)'
    },
    '.cm-gutter': {
        backgroundColor: 'var(--jp-layout-color2)'
    },
    '.cm-activeLine': {
        backgroundColor: 'color-mix(in srgb, var(--jp-layout-color3) 25%, transparent)'
    },
    '.cm-lineNumbers': {
        color: 'var(--jp-ui-font-color2)'
    },
    '.cm-searchMatch': {
        backgroundColor: 'var(--jp-search-unselected-match-background-color)',
        color: 'var(--jp-search-unselected-match-color)'
    },
    '.cm-searchMatch.cm-searchMatch-selected': {
        backgroundColor: 'var(--jp-search-selected-match-background-color) !important',
        color: 'var(--jp-search-selected-match-color) !important'
    },
    '.cm-tooltip': {
        backgroundColor: 'var(--jp-layout-color1)'
    }
});
// The list of available tags for syntax highlighting is available at
// https://lezer.codemirror.net/docs/ref/#highlight.tags
const jupyterHighlightStyle = _codemirror_language__WEBPACK_IMPORTED_MODULE_3__.HighlightStyle.define([
    // Order matters - a rule will override the previous ones; important for example for in headings styles.
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.meta, color: 'var(--jp-mirror-editor-meta-color)' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.heading, color: 'var(--jp-mirror-editor-header-color)' },
    {
        tag: [_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.heading1, _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.heading2, _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.heading3, _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.heading4],
        color: 'var(--jp-mirror-editor-header-color)',
        fontWeight: 'bold'
    },
    {
        tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.keyword,
        color: 'var(--jp-mirror-editor-keyword-color)',
        fontWeight: 'bold'
    },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.atom, color: 'var(--jp-mirror-editor-atom-color)' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.number, color: 'var(--jp-mirror-editor-number-color)' },
    {
        tag: [_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.definition(_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.name), _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.function(_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.definition(_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.variableName))],
        color: 'var(--jp-mirror-editor-def-color)'
    },
    {
        tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.standard(_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.variableName),
        color: 'var(--jp-mirror-editor-builtin-color)'
    },
    {
        tag: [_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.special(_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.variableName), _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.self],
        color: 'var(--jp-mirror-editor-variable-2-color)'
    },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.punctuation, color: 'var(--jp-mirror-editor-punctuation-color)' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.propertyName, color: 'var(--jp-mirror-editor-property-color)' },
    {
        tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.operator,
        color: 'var(--jp-mirror-editor-operator-color)',
        fontWeight: 'bold'
    },
    {
        tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.comment,
        color: 'var(--jp-mirror-editor-comment-color)',
        fontStyle: 'italic'
    },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.string, color: 'var(--jp-mirror-editor-string-color)' },
    {
        tag: [_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.labelName, _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.monospace, _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.special(_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.string)],
        color: 'var(--jp-mirror-editor-string-2-color)'
    },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.bracket, color: 'var(--jp-mirror-editor-bracket-color)' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.tagName, color: 'var(--jp-mirror-editor-tag-color)' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.attributeName, color: 'var(--jp-mirror-editor-attribute-color)' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.quote, color: 'var(--jp-mirror-editor-quote-color)' },
    {
        tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.link,
        color: 'var(--jp-mirror-editor-link-color)',
        textDecoration: 'underline'
    },
    { tag: [_lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.separator, _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.derefOperator, _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.paren], color: '' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.strong, fontWeight: 'bold' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.emphasis, fontStyle: 'italic' },
    { tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.strikethrough, textDecoration: 'line-through' },
    {
        tag: _lezer_highlight__WEBPACK_IMPORTED_MODULE_1__.tags.bool,
        color: 'var(--jp-mirror-editor-keyword-color)',
        fontWeight: 'bold'
    }
]);
/**
 * JupyterLab CodeMirror 6 theme
 */
const jupyterTheme = [
    jupyterEditorTheme,
    (0,_codemirror_language__WEBPACK_IMPORTED_MODULE_3__.syntaxHighlighting)(jupyterHighlightStyle)
];
/**
 * CodeMirror 6 theme registry
 */
class EditorThemeRegistry {
    constructor() {
        /**
         * CodeMirror 6 themes
         */
        this._themeMap = new Map([
            ['jupyter', Object.freeze({ name: 'jupyter', theme: jupyterTheme })]
        ]);
    }
    /**
     * Get all themes
     */
    get themes() {
        return Array.from(this._themeMap.values());
    }
    /**
     * Get the default CodeMirror 6 theme for JupyterLab
     *
     * @returns Default theme
     */
    defaultTheme() {
        return this._themeMap.get('jupyter').theme;
    }
    /**
     * Register a new theme.
     *
     * @param theme Codemirror 6 theme
     */
    addTheme(theme) {
        if (this._themeMap.has(theme.name)) {
            throw new Error(`A theme named '${theme.name}' is already registered.`);
        }
        this._themeMap.set(theme.name, { displayName: theme.name, ...theme });
    }
    /**
     * Get a theme.
     *
     * #### Notes
     * It falls back to the default theme
     *
     * @param name Theme name
     * @returns Theme extension
     */
    getTheme(name) {
        var _a;
        const ext = (_a = this._themeMap.get(name)) === null || _a === void 0 ? void 0 : _a.theme;
        return ext !== null && ext !== void 0 ? ext : this.defaultTheme();
    }
}
/**
 * EditorThemeRegistry namespace
 */
(function (EditorThemeRegistry) {
    /**
     * Get the default editor themes.
     *
     * @param translator Application translator
     * @returns Default CodeMirror 6 themes
     */
    function getDefaultThemes(translator) {
        const trans = (translator !== null && translator !== void 0 ? translator : _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator).load('jupyterlab');
        return [
            Object.freeze({
                name: 'codemirror',
                displayName: trans.__('codemirror'),
                theme: [
                    _codemirror_view__WEBPACK_IMPORTED_MODULE_2__.EditorView.baseTheme({}),
                    (0,_codemirror_language__WEBPACK_IMPORTED_MODULE_3__.syntaxHighlighting)(_codemirror_language__WEBPACK_IMPORTED_MODULE_3__.defaultHighlightStyle)
                ]
            })
        ];
    }
    EditorThemeRegistry.getDefaultThemes = getDefaultThemes;
})(EditorThemeRegistry || (EditorThemeRegistry = {}));
//# sourceMappingURL=theme.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/lib/token.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/lib/token.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IEditorExtensionRegistry: () => (/* binding */ IEditorExtensionRegistry),
/* harmony export */   IEditorLanguageRegistry: () => (/* binding */ IEditorLanguageRegistry),
/* harmony export */   IEditorThemeRegistry: () => (/* binding */ IEditorThemeRegistry)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/codemirror/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */

/**
 * Editor language token.
 */
const IEditorExtensionRegistry = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/codemirror:IEditorExtensionRegistry', `A registry for CodeMirror extension factories.`);
/**
 * Editor language token.
 */
const IEditorLanguageRegistry = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/codemirror:IEditorLanguageRegistry', 'A registry for CodeMirror languages.');
/**
 * Editor theme token.
 */
const IEditorThemeRegistry = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/codemirror:IEditorThemeRegistry', 'A registry for CodeMirror theme.');
//# sourceMappingURL=token.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/codemirror/node_modules/@lumino/coreutils/dist/index.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@jupyterlab/codemirror/node_modules/@lumino/coreutils/dist/index.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
     true ? factory(exports) :
    0;
})(this, (function (exports) { 'use strict';

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for JSON-specific functions.
     */
    exports.JSONExt = void 0;
    (function (JSONExt) {
        /**
         * A shared frozen empty JSONObject
         */
        JSONExt.emptyObject = Object.freeze({});
        /**
         * A shared frozen empty JSONArray
         */
        JSONExt.emptyArray = Object.freeze([]);
        /**
         * Test whether a JSON value is a primitive.
         *
         * @param value - The JSON value of interest.
         *
         * @returns `true` if the value is a primitive,`false` otherwise.
         */
        function isPrimitive(value) {
            return (value === null ||
                typeof value === 'boolean' ||
                typeof value === 'number' ||
                typeof value === 'string');
        }
        JSONExt.isPrimitive = isPrimitive;
        function isArray(value) {
            return Array.isArray(value);
        }
        JSONExt.isArray = isArray;
        function isObject(value) {
            return !isPrimitive(value) && !isArray(value);
        }
        JSONExt.isObject = isObject;
        /**
         * Compare two JSON values for deep equality.
         *
         * @param first - The first JSON value of interest.
         *
         * @param second - The second JSON value of interest.
         *
         * @returns `true` if the values are equivalent, `false` otherwise.
         */
        function deepEqual(first, second) {
            // Check referential and primitive equality first.
            if (first === second) {
                return true;
            }
            // If one is a primitive, the `===` check ruled out the other.
            if (isPrimitive(first) || isPrimitive(second)) {
                return false;
            }
            // Test whether they are arrays.
            let a1 = isArray(first);
            let a2 = isArray(second);
            // Bail if the types are different.
            if (a1 !== a2) {
                return false;
            }
            // If they are both arrays, compare them.
            if (a1 && a2) {
                return deepArrayEqual(first, second);
            }
            // At this point, they must both be objects.
            return deepObjectEqual(first, second);
        }
        JSONExt.deepEqual = deepEqual;
        /**
         * Create a deep copy of a JSON value.
         *
         * @param value - The JSON value to copy.
         *
         * @returns A deep copy of the given JSON value.
         */
        function deepCopy(value) {
            // Do nothing for primitive values.
            if (isPrimitive(value)) {
                return value;
            }
            // Deep copy an array.
            if (isArray(value)) {
                return deepArrayCopy(value);
            }
            // Deep copy an object.
            return deepObjectCopy(value);
        }
        JSONExt.deepCopy = deepCopy;
        /**
         * Compare two JSON arrays for deep equality.
         */
        function deepArrayEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Test the arrays for equal length.
            if (first.length !== second.length) {
                return false;
            }
            // Compare the values for equality.
            for (let i = 0, n = first.length; i < n; ++i) {
                if (!deepEqual(first[i], second[i])) {
                    return false;
                }
            }
            // At this point, the arrays are equal.
            return true;
        }
        /**
         * Compare two JSON objects for deep equality.
         */
        function deepObjectEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Check for the first object's keys in the second object.
            for (let key in first) {
                if (first[key] !== undefined && !(key in second)) {
                    return false;
                }
            }
            // Check for the second object's keys in the first object.
            for (let key in second) {
                if (second[key] !== undefined && !(key in first)) {
                    return false;
                }
            }
            // Compare the values for equality.
            for (let key in first) {
                // Get the values.
                let firstValue = first[key];
                let secondValue = second[key];
                // If both are undefined, ignore the key.
                if (firstValue === undefined && secondValue === undefined) {
                    continue;
                }
                // If only one value is undefined, the objects are not equal.
                if (firstValue === undefined || secondValue === undefined) {
                    return false;
                }
                // Compare the values.
                if (!deepEqual(firstValue, secondValue)) {
                    return false;
                }
            }
            // At this point, the objects are equal.
            return true;
        }
        /**
         * Create a deep copy of a JSON array.
         */
        function deepArrayCopy(value) {
            let result = new Array(value.length);
            for (let i = 0, n = value.length; i < n; ++i) {
                result[i] = deepCopy(value[i]);
            }
            return result;
        }
        /**
         * Create a deep copy of a JSON object.
         */
        function deepObjectCopy(value) {
            let result = {};
            for (let key in value) {
                // Ignore undefined values.
                let subvalue = value[key];
                if (subvalue === undefined) {
                    continue;
                }
                result[key] = deepCopy(subvalue);
            }
            return result;
        }
    })(exports.JSONExt || (exports.JSONExt = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * An object which stores MIME data for general application use.
     *
     * #### Notes
     * This class does not attempt to enforce "correctness" of MIME types
     * and their associated data. Since this class is designed to transfer
     * arbitrary data and objects within the same application, it assumes
     * that the user provides correct and accurate data.
     */
    class MimeData {
        constructor() {
            this._types = [];
            this._values = [];
        }
        /**
         * Get an array of the MIME types contained within the dataset.
         *
         * @returns A new array of the MIME types, in order of insertion.
         */
        types() {
            return this._types.slice();
        }
        /**
         * Test whether the dataset has an entry for the given type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns `true` if the dataset contains a value for the given
         *   MIME type, `false` otherwise.
         */
        hasData(mime) {
            return this._types.indexOf(mime) !== -1;
        }
        /**
         * Get the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns The value for the given MIME type, or `undefined` if
         *   the dataset does not contain a value for the type.
         */
        getData(mime) {
            let i = this._types.indexOf(mime);
            return i !== -1 ? this._values[i] : undefined;
        }
        /**
         * Set the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @param data - The data value for the given MIME type.
         *
         * #### Notes
         * This will overwrite any previous entry for the MIME type.
         */
        setData(mime, data) {
            this.clearData(mime);
            this._types.push(mime);
            this._values.push(data);
        }
        /**
         * Remove the data entry for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * #### Notes
         * This is a no-op if there is no entry for the given MIME type.
         */
        clearData(mime) {
            let i = this._types.indexOf(mime);
            if (i !== -1) {
                this._types.splice(i, 1);
                this._values.splice(i, 1);
            }
        }
        /**
         * Remove all data entries from the dataset.
         */
        clear() {
            this._types.length = 0;
            this._values.length = 0;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A class which wraps a promise into a delegate object.
     *
     * #### Notes
     * This class is useful when the logic to resolve or reject a promise
     * cannot be defined at the point where the promise is created.
     */
    class PromiseDelegate {
        /**
         * Construct a new promise delegate.
         */
        constructor() {
            this.promise = new Promise((resolve, reject) => {
                this._resolve = resolve;
                this._reject = reject;
            });
        }
        /**
         * Resolve the wrapped promise with the given value.
         *
         * @param value - The value to use for resolving the promise.
         */
        resolve(value) {
            let resolve = this._resolve;
            resolve(value);
        }
        /**
         * Reject the wrapped promise with the given value.
         *
         * @reason - The reason for rejecting the promise.
         */
        reject(reason) {
            let reject = this._reject;
            reject(reason);
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A runtime object which captures compile-time type information.
     *
     * #### Notes
     * A token captures the compile-time type of an interface or class in
     * an object which can be used at runtime in a type-safe fashion.
     */
    class Token {
        /**
         * Construct a new token.
         *
         * @param name - A human readable name for the token.
         * @param description - Token purpose description for documentation.
         */
        constructor(name, description) {
            this.name = name;
            this.description = description !== null && description !== void 0 ? description : '';
            this._tokenStructuralPropertyT = null;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    // Fallback
    function fallbackRandomValues(buffer) {
        let value = 0;
        for (let i = 0, n = buffer.length; i < n; ++i) {
            if (i % 4 === 0) {
                value = (Math.random() * 0xffffffff) >>> 0;
            }
            buffer[i] = value & 0xff;
            value >>>= 8;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for random number related functionality.
     */
    exports.Random = void 0;
    (function (Random) {
        /**
         * A function which generates random bytes.
         *
         * @param buffer - The `Uint8Array` to fill with random bytes.
         *
         * #### Notes
         * A cryptographically strong random number generator will be used if
         * available. Otherwise, `Math.random` will be used as a fallback for
         * randomness.
         *
         * The following RNGs are supported, listed in order of precedence:
         *   - `window.crypto.getRandomValues`
         *   - `window.msCrypto.getRandomValues`
         *   - `require('crypto').randomFillSync
         *   - `require('crypto').randomBytes
         *   - `Math.random`
         */
        Random.getRandomValues = (() => {
            // Look up the crypto module if available.
            const crypto = (typeof window !== 'undefined' && (window.crypto || window.msCrypto)) ||
                null;
            // Modern browsers and IE 11
            if (crypto && typeof crypto.getRandomValues === 'function') {
                return function getRandomValues(buffer) {
                    return crypto.getRandomValues(buffer);
                };
            }
            // Fallback
            return fallbackRandomValues;
        })();
    })(exports.Random || (exports.Random = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A function which creates a function that generates UUID v4 identifiers.
     *
     * @returns A new function that creates a UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    function uuid4Factory(getRandomValues) {
        // Create a 16 byte array to hold the random values.
        const bytes = new Uint8Array(16);
        // Create a look up table from bytes to hex strings.
        const lut = new Array(256);
        // Pad the single character hex digits with a leading zero.
        for (let i = 0; i < 16; ++i) {
            lut[i] = '0' + i.toString(16);
        }
        // Populate the rest of the hex digits.
        for (let i = 16; i < 256; ++i) {
            lut[i] = i.toString(16);
        }
        // Return a function which generates the UUID.
        return function uuid4() {
            // Get a new batch of random values.
            getRandomValues(bytes);
            // Set the UUID version number to 4.
            bytes[6] = 0x40 | (bytes[6] & 0x0f);
            // Set the clock sequence bit to the RFC spec.
            bytes[8] = 0x80 | (bytes[8] & 0x3f);
            // Assemble the UUID string.
            return (lut[bytes[0]] +
                lut[bytes[1]] +
                lut[bytes[2]] +
                lut[bytes[3]] +
                '-' +
                lut[bytes[4]] +
                lut[bytes[5]] +
                '-' +
                lut[bytes[6]] +
                lut[bytes[7]] +
                '-' +
                lut[bytes[8]] +
                lut[bytes[9]] +
                '-' +
                lut[bytes[10]] +
                lut[bytes[11]] +
                lut[bytes[12]] +
                lut[bytes[13]] +
                lut[bytes[14]] +
                lut[bytes[15]]);
        };
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for UUID related functionality.
     */
    exports.UUID = void 0;
    (function (UUID) {
        /**
         * A function which generates UUID v4 identifiers.
         *
         * @returns A new UUID v4 string.
         *
         * #### Notes
         * This implementation complies with RFC 4122.
         *
         * This uses `Random.getRandomValues()` for random bytes, which in
         * turn will use the underlying `crypto` module of the platform if
         * it is available. The fallback for randomness is `Math.random`.
         */
        UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
    })(exports.UUID || (exports.UUID = {}));

    exports.MimeData = MimeData;
    exports.PromiseDelegate = PromiseDelegate;
    exports.Token = Token;

}));
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@jupyterlab/completer/lib/default/kernelprovider.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@jupyterlab/completer/lib/default/kernelprovider.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KERNEL_PROVIDER_ID: () => (/* binding */ KERNEL_PROVIDER_ID),
/* harmony export */   KernelCompleterProvider: () => (/* binding */ KernelCompleterProvider)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

const KERNEL_PROVIDER_ID = 'CompletionProvider:kernel';
/**
 * A kernel connector for completion handlers.
 */
class KernelCompleterProvider {
    constructor() {
        this.identifier = KERNEL_PROVIDER_ID;
        this.rank = 550;
        this.renderer = null;
    }
    /**
     * The kernel completion provider is applicable only if the kernel is available.
     * @param context - additional information about context of completion request
     */
    async isApplicable(context) {
        var _a;
        const hasKernel = (_a = context.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (!hasKernel) {
            return false;
        }
        return true;
    }
    /**
     * Fetch completion requests.
     *
     * @param request - The completion request text and details.
     */
    async fetch(request, context) {
        var _a;
        const kernel = (_a = context.session) === null || _a === void 0 ? void 0 : _a.kernel;
        if (!kernel) {
            throw new Error('No kernel for completion request.');
        }
        const contents = {
            code: request.text,
            cursor_pos: request.offset
        };
        const msg = await kernel.requestComplete(contents);
        const response = msg.content;
        if (response.status !== 'ok') {
            throw new Error('Completion fetch failed to return successfully.');
        }
        const items = new Array();
        const metadata = response.metadata._jupyter_types_experimental;
        response.matches.forEach((label, index) => {
            if (metadata && metadata[index]) {
                items.push({
                    label,
                    type: metadata[index].type,
                    insertText: metadata[index].text
                });
            }
            else {
                items.push({ label });
            }
        });
        return {
            start: response.cursor_start,
            end: response.cursor_end,
            items
        };
    }
    /**
     * Kernel provider will use the inspect request to lazy-load the content
     * for document panel.
     */
    async resolve(item, context, patch) {
        const { editor, session } = context;
        if (session && editor) {
            let code = editor.model.sharedModel.getSource();
            const position = editor.getCursorPosition();
            let offset = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.Text.jsIndexToCharIndex(editor.getOffsetAt(position), code);
            const kernel = session.kernel;
            if (!code || !kernel) {
                return Promise.resolve(item);
            }
            if (patch) {
                const { start, value } = patch;
                code = code.substring(0, start) + value;
                offset = offset + value.length;
            }
            const contents = {
                code,
                cursor_pos: offset,
                detail_level: 0
            };
            const msg = await kernel.requestInspect(contents);
            const value = msg.content;
            if (value.status !== 'ok' || !value.found) {
                return item;
            }
            item.documentation = value.data['text/plain'];
            return item;
        }
        return item;
    }
    /**
     * Kernel provider will activate the completer in continuous mode after
     * the `.` character.
     */
    shouldShowContinuousHint(visible, changed) {
        const sourceChange = changed.sourceChange;
        if (sourceChange == null) {
            return true;
        }
        if (sourceChange.some(delta => delta.delete != null)) {
            return false;
        }
        return sourceChange.some(delta => delta.insert != null &&
            (delta.insert === '.' || (!visible && delta.insert.trim().length > 0)));
    }
}
//# sourceMappingURL=kernelprovider.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/completer/lib/handler.js":
/*!***********************************************************!*\
  !*** ./node_modules/@jupyterlab/completer/lib/handler.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CompletionHandler: () => (/* binding */ CompletionHandler)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/messaging */ "./node_modules/@lumino/messaging/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./tokens */ "./node_modules/@jupyterlab/completer/lib/tokens.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * A class added to editors that can host a completer.
 */
const COMPLETER_ENABLED_CLASS = 'jp-mod-completer-enabled';
/**
 * A class added to editors that have an active completer.
 */
const COMPLETER_ACTIVE_CLASS = 'jp-mod-completer-active';
/**
 * A completion handler for editors.
 */
class CompletionHandler {
    /**
     * Construct a new completion handler for a widget.
     */
    constructor(options) {
        this._editor = null;
        this._enabled = false;
        this._isDisposed = false;
        this._autoCompletion = false;
        this.completer = options.completer;
        this.completer.selected.connect(this.onCompletionSelected, this);
        this.completer.visibilityChanged.connect(this.onVisibilityChanged, this);
        this._reconciliator = options.reconciliator;
    }
    set reconciliator(reconciliator) {
        this._reconciliator = reconciliator;
    }
    /**
     * The editor used by the completion handler.
     */
    get editor() {
        return this._editor;
    }
    set editor(newValue) {
        if (newValue === this._editor) {
            return;
        }
        let editor = this._editor;
        // Clean up and disconnect from old editor.
        if (editor && !editor.isDisposed) {
            const model = editor.model;
            editor.host.classList.remove(COMPLETER_ENABLED_CLASS);
            editor.host.classList.remove(COMPLETER_ACTIVE_CLASS);
            model.selections.changed.disconnect(this.onSelectionsChanged, this);
            model.sharedModel.changed.disconnect(this.onTextChanged, this);
        }
        // Reset completer state.
        this.completer.reset();
        this.completer.editor = newValue;
        // Update the editor and signal connections.
        editor = this._editor = newValue;
        if (editor) {
            const model = editor.model;
            this._enabled = false;
            model.selections.changed.connect(this.onSelectionsChanged, this);
            model.sharedModel.changed.connect(this.onTextChanged, this);
            // On initial load, manually check the cursor position.
            this.onSelectionsChanged();
        }
    }
    /**
     * Get whether the completion handler is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Enable/disable continuous hinting mode.
     */
    set autoCompletion(value) {
        this._autoCompletion = value;
    }
    get autoCompletion() {
        return this._autoCompletion;
    }
    /**
     * Dispose of the resources used by the handler.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal.clearData(this);
    }
    /**
     * Invoke the handler and launch a completer.
     */
    invoke() {
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_0__.MessageLoop.sendMessage(this, CompletionHandler.Msg.InvokeRequest);
    }
    /**
     * Process a message sent to the completion handler.
     */
    processMessage(msg) {
        switch (msg.type) {
            case CompletionHandler.Msg.InvokeRequest.type:
                this.onInvokeRequest(msg);
                break;
            default:
                break;
        }
    }
    /**
     * Get the state of the text editor at the given position.
     */
    getState(editor, position) {
        return {
            text: editor.model.sharedModel.getSource(),
            line: position.line,
            column: position.column
        };
    }
    /**
     * Handle a completion selected signal from the completion widget.
     */
    onCompletionSelected(completer, val) {
        const model = completer.model;
        const editor = this._editor;
        if (!editor || !model) {
            return;
        }
        const patch = model.createPatch(val);
        if (!patch) {
            return;
        }
        const { start, end, value } = patch;
        const cursorBeforeChange = editor.getOffsetAt(editor.getCursorPosition());
        // we need to update the shared model in a single transaction so that the undo manager works as expected
        editor.model.sharedModel.updateSource(start, end, value);
        if (cursorBeforeChange <= end && cursorBeforeChange >= start) {
            editor.setCursorPosition(editor.getPositionAt(start + value.length));
        }
    }
    /**
     * Handle `invoke-request` messages.
     */
    onInvokeRequest(msg) {
        // If there is no completer model, bail.
        if (!this.completer.model) {
            return;
        }
        // If a completer session is already active, bail.
        if (this.completer.model.original) {
            return;
        }
        const editor = this._editor;
        if (editor) {
            this._makeRequest(editor.getCursorPosition(), _tokens__WEBPACK_IMPORTED_MODULE_2__.CompletionTriggerKind.Invoked).catch(reason => {
                console.warn('Invoke request bailed', reason);
            });
        }
    }
    /**
     * Handle selection changed signal from an editor.
     *
     * #### Notes
     * If a sub-class reimplements this method, then that class must either call
     * its super method or it must take responsibility for adding and removing
     * the completer completable class to the editor host node.
     *
     * Despite the fact that the editor widget adds a class whenever there is a
     * primary selection, this method checks independently for two reasons:
     *
     * 1. The editor widget connects to the same signal to add that class, so
     *    there is no guarantee that the class will be added before this method
     *    is invoked so simply checking for the CSS class's existence is not an
     *    option. Secondarily, checking the editor state should be faster than
     *    querying the DOM in either case.
     * 2. Because this method adds a class that indicates whether completer
     *    functionality ought to be enabled, relying on the behavior of the
     *    `jp-mod-has-primary-selection` to filter out any editors that have
     *    a selection means the semantic meaning of `jp-mod-completer-enabled`
     *    is obscured because there may be cases where the enabled class is added
     *    even though the completer is not available.
     */
    onSelectionsChanged() {
        const model = this.completer.model;
        const editor = this._editor;
        if (!editor) {
            return;
        }
        const host = editor.host;
        // If there is no model, return.
        if (!model) {
            this._enabled = false;
            host.classList.remove(COMPLETER_ENABLED_CLASS);
            return;
        }
        // If we are currently performing a subset match,
        // return without resetting the completer.
        if (model.subsetMatch) {
            return;
        }
        const position = editor.getCursorPosition();
        const line = editor.getLine(position.line);
        if (!line) {
            this._enabled = false;
            model.reset(true);
            host.classList.remove(COMPLETER_ENABLED_CLASS);
            return;
        }
        const { start, end } = editor.getSelection();
        // If there is a text selection, return.
        if (start.column !== end.column || start.line !== end.line) {
            this._enabled = false;
            model.reset(true);
            host.classList.remove(COMPLETER_ENABLED_CLASS);
            return;
        }
        // If the part of the line before the cursor is white space, return.
        if (line.slice(0, position.column).match(/^\s*$/)) {
            this._enabled = false;
            model.reset(true);
            host.classList.remove(COMPLETER_ENABLED_CLASS);
            return;
        }
        // Enable completion.
        if (!this._enabled) {
            this._enabled = true;
            host.classList.add(COMPLETER_ENABLED_CLASS);
        }
        // Dispatch the cursor change.
        model.handleCursorChange(this.getState(editor, editor.getCursorPosition()));
    }
    /**
     * Handle a text changed signal from an editor.
     */
    async onTextChanged(str, changed) {
        const model = this.completer.model;
        if (!model || !this._enabled) {
            return;
        }
        // If there is a text selection, no completion is allowed.
        const editor = this.editor;
        if (!editor) {
            return;
        }
        if (this._autoCompletion &&
            this._reconciliator.shouldShowContinuousHint &&
            (await this._reconciliator.shouldShowContinuousHint(this.completer.isVisible, changed))) {
            void this._makeRequest(editor.getCursorPosition(), _tokens__WEBPACK_IMPORTED_MODULE_2__.CompletionTriggerKind.TriggerCharacter);
        }
        const { start, end } = editor.getSelection();
        if (start.column !== end.column || start.line !== end.line) {
            return;
        }
        // Dispatch the text change.
        model.handleTextChange(this.getState(editor, editor.getCursorPosition()));
    }
    /**
     * Handle a visibility change signal from a completer widget.
     */
    onVisibilityChanged(completer) {
        // Completer is not active.
        if (completer.isDisposed || completer.isHidden) {
            if (this._editor) {
                this._editor.host.classList.remove(COMPLETER_ACTIVE_CLASS);
                this._editor.focus();
            }
            return;
        }
        // Completer is active.
        if (this._editor) {
            this._editor.host.classList.add(COMPLETER_ACTIVE_CLASS);
        }
    }
    /**
     * Make a completion request.
     */
    _makeRequest(position, trigger) {
        const editor = this.editor;
        if (!editor) {
            return Promise.reject(new Error('No active editor'));
        }
        const text = editor.model.sharedModel.getSource();
        const offset = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.Text.jsIndexToCharIndex(editor.getOffsetAt(position), text);
        const state = this.getState(editor, position);
        const request = { text, offset };
        return this._reconciliator
            .fetch(request, trigger)
            .then(reply => {
            if (!reply) {
                return;
            }
            const model = this._updateModel(state, reply.start, reply.end);
            if (!model) {
                return;
            }
            if (model.setCompletionItems) {
                model.setCompletionItems(reply.items);
            }
        })
            .catch(p => {
            /* Fails silently. */
        });
    }
    /**
     * Updates model with text state and current cursor position.
     */
    _updateModel(state, start, end) {
        const model = this.completer.model;
        const text = state.text;
        if (!model) {
            return null;
        }
        // Update the original request.
        model.original = state;
        // Update the cursor.
        model.cursor = {
            start: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.Text.charIndexToJsIndex(start, text),
            end: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.Text.charIndexToJsIndex(end, text)
        };
        return model;
    }
}
/**
 * A namespace for cell completion handler statics.
 */
(function (CompletionHandler) {
    /**
     * A namespace for completion handler messages.
     */
    let Msg;
    (function (Msg) {
        /**
         * A singleton `'invoke-request'` message.
         */
        Msg.InvokeRequest = new _lumino_messaging__WEBPACK_IMPORTED_MODULE_0__.Message('invoke-request');
    })(Msg = CompletionHandler.Msg || (CompletionHandler.Msg = {}));
})(CompletionHandler || (CompletionHandler = {}));
//# sourceMappingURL=handler.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/completer/lib/model.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/completer/lib/model.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CompleterModel: () => (/* binding */ CompleterModel)
/* harmony export */ });
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/completer/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.



/**
 * Escape HTML by native means of the browser.
 */
function escapeHTML(text) {
    const node = document.createElement('span');
    node.textContent = text;
    return node.innerHTML;
}
/**
 * An implementation of a completer model.
 */
class CompleterModel {
    constructor() {
        this.processedItemsCache = null;
        this._current = null;
        this._cursor = null;
        this._isDisposed = false;
        this._completionItems = [];
        this._original = null;
        this._query = '';
        this._subsetMatch = false;
        this._typeMap = {};
        this._orderedTypes = [];
        this._stateChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);
        this._queryChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal(this);
        /**
         * The weak map between a processed completion item with the original item.
         * It's used to keep track of original completion item in case of displaying
         * the completer with query.
         */
        this._processedToOriginalItem = null;
        /**
         * A counter to cancel ongoing `resolveItem` call.
         */
        this._resolvingItem = 0;
    }
    /**
     * A signal emitted when state of the completer menu changes.
     */
    get stateChanged() {
        return this._stateChanged;
    }
    /**
     * A signal emitted when query string changes (at invocation, or as user types).
     */
    get queryChanged() {
        return this._queryChanged;
    }
    /**
     * The original completion request details.
     */
    get original() {
        return this._original;
    }
    set original(newValue) {
        const unchanged = this._original === newValue ||
            (this._original &&
                newValue &&
                _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(newValue, this._original));
        if (unchanged) {
            return;
        }
        this._reset();
        // Set both the current and original to the same value when original is set.
        this._current = this._original = newValue;
        this._stateChanged.emit(undefined);
    }
    /**
     * The current text change details.
     */
    get current() {
        return this._current;
    }
    set current(newValue) {
        const unchanged = this._current === newValue ||
            (this._current && newValue && _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(newValue, this._current));
        if (unchanged) {
            return;
        }
        const original = this._original;
        // Original request must always be set before a text change. If it isn't
        // the model fails silently.
        if (!original) {
            return;
        }
        const cursor = this._cursor;
        // Cursor must always be set before a text change. This happens
        // automatically in the completer handler, but since `current` is a public
        // attribute, this defensive check is necessary.
        if (!cursor) {
            return;
        }
        const current = (this._current = newValue);
        if (!current) {
            this._stateChanged.emit(undefined);
            return;
        }
        const originalLine = original.text.split('\n')[original.line];
        const currentLine = current.text.split('\n')[current.line];
        // If the text change means that the original start point has been preceded,
        // then the completion is no longer valid and should be reset.
        if (!this._subsetMatch && currentLine.length < originalLine.length) {
            this.reset(true);
            return;
        }
        const { start, end } = cursor;
        // Clip the front of the current line.
        let query = current.text.substring(start);
        // Clip the back of the current line by calculating the end of the original.
        const ending = original.text.substring(end);
        query = query.substring(0, query.lastIndexOf(ending));
        this._query = query;
        this.processedItemsCache = null;
        this._processedToOriginalItem = null;
        this._queryChanged.emit({ newValue: this._query, origin: 'editorUpdate' });
        this._stateChanged.emit(undefined);
    }
    /**
     * The cursor details that the API has used to return matching options.
     */
    get cursor() {
        return this._cursor;
    }
    set cursor(newValue) {
        // Original request must always be set before a cursor change. If it isn't
        // the model fails silently.
        if (!this.original) {
            return;
        }
        this._cursor = newValue;
    }
    /**
     * The query against which items are filtered.
     */
    get query() {
        return this._query;
    }
    set query(newValue) {
        this._query = newValue;
        this.processedItemsCache = null;
        this._processedToOriginalItem = null;
        this._queryChanged.emit({ newValue: this._query, origin: 'setter' });
    }
    /**
     * A flag that is true when the model value was modified by a subset match.
     */
    get subsetMatch() {
        return this._subsetMatch;
    }
    set subsetMatch(newValue) {
        this._subsetMatch = newValue;
    }
    /**
     * Get whether the model is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the model.
     */
    dispose() {
        // Do nothing if already disposed.
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_2__.Signal.clearData(this);
    }
    /**
     * The list of visible items in the completer menu.
     *
     * #### Notes
     * This is a read-only property.
     * When overriding it is recommended to cache results in `processedItemsCache`
     * property which will be automatically nullified when needed.
     */
    completionItems() {
        if (!this.processedItemsCache) {
            let query = this._query;
            if (query) {
                const markedItems = this._markup(query);
                this.processedItemsCache = markedItems.map(it => it.processedItem);
                this._processedToOriginalItem = new WeakMap(markedItems.map(it => [it.processedItem, it.originalItem]));
            }
            else {
                this.processedItemsCache = this._completionItems.map(item => {
                    return this._escapeItemLabel(item);
                });
                this._processedToOriginalItem = null;
            }
        }
        return this.processedItemsCache;
    }
    /**
     * Set the list of visible items in the completer menu, and append any
     * new types to KNOWN_TYPES.
     */
    setCompletionItems(newValue) {
        if (_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.JSONExt.deepEqual(newValue, this._completionItems)) {
            return;
        }
        this._completionItems = newValue;
        this._orderedTypes = Private.findOrderedCompletionItemTypes(this._completionItems);
        this.processedItemsCache = null;
        this._processedToOriginalItem = null;
        this._stateChanged.emit(undefined);
    }
    /**
     * The map from identifiers (a.b) to types (function, module, class, instance,
     * etc.).
     *
     * #### Notes
     * A type map is currently only provided by the latest IPython kernel using
     * the completer reply metadata field `_jupyter_types_experimental`. The
     * values are completely up to the kernel.
     *
     */
    typeMap() {
        return this._typeMap;
    }
    /**
     * An ordered list of all the known types in the typeMap.
     *
     * #### Notes
     * To visually encode the types of the completer matches, we assemble an
     * ordered list. This list begins with:
     * ```
     * ['function', 'instance', 'class', 'module', 'keyword']
     * ```
     * and then has any remaining types listed alphabetically. This will give
     * reliable visual encoding for these known types, but allow kernels to
     * provide new types.
     */
    orderedTypes() {
        return this._orderedTypes;
    }
    /**
     * Handle a cursor change.
     */
    handleCursorChange(change) {
        // If there is no active completion, return.
        if (!this._original) {
            return;
        }
        const { column, line } = change;
        const { current, original } = this;
        if (!original) {
            return;
        }
        // If a cursor change results in a the cursor being on a different line
        // than the original request, cancel.
        if (line !== original.line) {
            this.reset(true);
            return;
        }
        // If a cursor change results in the cursor being set to a position that
        // precedes the original column, cancel.
        if (column < original.column) {
            this.reset(true);
            return;
        }
        const { cursor } = this;
        if (!cursor || !current) {
            return;
        }
        // If a cursor change results in the cursor being set to a position beyond
        // the end of the area that would be affected by completion, cancel.
        const cursorDelta = cursor.end - cursor.start;
        const originalLine = original.text.split('\n')[original.line];
        const currentLine = current.text.split('\n')[current.line];
        const inputDelta = currentLine.length - originalLine.length;
        if (column > original.column + cursorDelta + inputDelta) {
            this.reset(true);
            return;
        }
    }
    /**
     * Handle a text change.
     */
    handleTextChange(change) {
        const original = this._original;
        // If there is no active completion, return.
        if (!original) {
            return;
        }
        const { text, column, line } = change;
        const last = text.split('\n')[line][column - 1];
        // If last character entered is not whitespace or if the change column is
        // greater than or equal to the original column, update completion.
        if ((last && last.match(/\S/)) || change.column >= original.column) {
            this.current = change;
            return;
        }
        // If final character is whitespace, reset completion.
        this.reset(false);
    }
    /**
     * Create a resolved patch between the original state and a patch string.
     *
     * @param patch - The patch string to apply to the original value.
     *
     * @returns A patched text change or undefined if original value did not exist.
     */
    createPatch(patch) {
        const original = this._original;
        const cursor = this._cursor;
        const current = this._current;
        if (!original || !cursor || !current) {
            return undefined;
        }
        let { start, end } = cursor;
        // Also include any filtering/additional-typing that has occurred
        // since the completion request in the patched length.
        end = end + (current.text.length - original.text.length);
        return { start, end, value: patch };
    }
    /**
     * Reset the state of the model and emit a state change signal.
     *
     * @param hard - Reset even if a subset match is in progress.
     */
    reset(hard = false) {
        // When the completer detects a common subset prefix for all options,
        // it updates the model and sets the model source to that value, triggering
        // a reset. Unless explicitly a hard reset, this should be ignored.
        if (!hard && this._subsetMatch) {
            return;
        }
        this._reset();
        this._stateChanged.emit(undefined);
    }
    /**
     * Check if CompletionItem matches against query.
     * Highlight matching prefix by adding <mark> tags.
     */
    _markup(query) {
        var _a;
        const items = this._completionItems;
        let results = [];
        for (const originalItem of items) {
            // See if label matches query string
            // With ICompletionItems, the label may include parameters,
            // so we exclude them from the matcher.
            // e.g. Given label `foo(b, a, r)` and query `bar`,
            // don't count parameters, `b`, `a`, and `r` as matches.
            const index = originalItem.label.indexOf('(');
            const text = index > -1
                ? originalItem.label.substring(0, index)
                : originalItem.label;
            const match = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.StringExt.matchSumOfSquares(escapeHTML(text), query);
            // Filter non-matching items.
            if (match) {
                // Highlight label text if there's a match
                let marked = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.StringExt.highlight(escapeHTML(originalItem.label), match.indices, Private.mark);
                // Use `Object.assign` to evaluate getters.
                const highlightedItem = Object.assign({}, originalItem);
                highlightedItem.label = marked.join('');
                highlightedItem.insertText =
                    (_a = originalItem.insertText) !== null && _a !== void 0 ? _a : originalItem.label;
                results.push({
                    item: highlightedItem,
                    score: match.score,
                    originalItem
                });
            }
        }
        results.sort(Private.scoreCmp);
        // Extract only the item (dropping the extra score attribute to not leak
        // implementation details to JavaScript callers.
        return results.map(match => ({
            processedItem: match.item,
            originalItem: match.originalItem
        }));
    }
    /**
     * Lazy load missing data of an item.
     * @param indexOrValue - the item or its index
     * @remarks
     * Resolving item by index will be deprecated in
     * the JupyterLab 5.0 and removed in JupyterLab 6.0.
     *
     * @return Return `undefined` if the completion item with `activeIndex` index can not be found.
     *  Return a promise of `null` if another `resolveItem` is called. Otherwise return the
     * promise of resolved completion item.
     */
    resolveItem(indexOrValue) {
        let processedItem;
        if (typeof indexOrValue === 'number') {
            const completionItems = this.completionItems();
            if (!completionItems || !completionItems[indexOrValue]) {
                return undefined;
            }
            processedItem = completionItems[indexOrValue];
        }
        else {
            processedItem = indexOrValue;
        }
        if (!processedItem) {
            return undefined;
        }
        let originalItem;
        if (this._processedToOriginalItem) {
            originalItem = this._processedToOriginalItem.get(processedItem);
        }
        else {
            originalItem = processedItem;
        }
        if (!originalItem) {
            return undefined;
        }
        return this._resolveItemByValue(originalItem);
    }
    /**
     * Lazy load missing data of a completion item.
     *
     * @param  completionItem - the item to be resolved
     * @return See `resolveItem` method
     */
    _resolveItemByValue(completionItem) {
        const current = ++this._resolvingItem;
        let resolvedItem;
        if (completionItem.resolve) {
            let patch;
            if (completionItem.insertText) {
                patch = this.createPatch(completionItem.insertText);
            }
            resolvedItem = completionItem.resolve(patch);
        }
        else {
            resolvedItem = Promise.resolve(completionItem);
        }
        return resolvedItem
            .then(activeItem => {
            // Escape the label it in place
            this._escapeItemLabel(activeItem, true);
            Object.keys(activeItem).forEach((key) => {
                completionItem[key] = activeItem[key];
            });
            completionItem.resolve = undefined;
            if (current !== this._resolvingItem) {
                return Promise.resolve(null);
            }
            return activeItem;
        })
            .catch(e => {
            console.error(e);
            // Failed to resolve missing data, return the original item.
            return Promise.resolve(completionItem);
        });
    }
    /**
     * Escape item label, storing the original label and adding `insertText` if needed.
     * If escaping changes label creates a new item unless `inplace` is true.
     */
    _escapeItemLabel(item, inplace = false) {
        var _a;
        const escapedLabel = escapeHTML(item.label);
        // If there was no insert text, use the original (unescaped) label.
        if (escapedLabel !== item.label) {
            const newItem = inplace ? item : Object.assign({}, item);
            newItem.insertText = (_a = item.insertText) !== null && _a !== void 0 ? _a : item.label;
            newItem.label = escapedLabel;
            return newItem;
        }
        return item;
    }
    /**
     * Reset the state of the model.
     */
    _reset() {
        const hadQuery = this._query;
        this._current = null;
        this._cursor = null;
        this._completionItems = [];
        this._original = null;
        this._query = '';
        this.processedItemsCache = null;
        this._processedToOriginalItem = null;
        this._subsetMatch = false;
        this._typeMap = {};
        this._orderedTypes = [];
        if (hadQuery) {
            this._queryChanged.emit({ newValue: this._query, origin: 'reset' });
        }
    }
}
/**
 * A namespace for completer model private data.
 */
var Private;
(function (Private) {
    /**
     * The list of known type annotations of completer matches.
     */
    const KNOWN_TYPES = ['function', 'instance', 'class', 'module', 'keyword'];
    /**
     * The map of known type annotations of completer matches.
     */
    const KNOWN_MAP = KNOWN_TYPES.reduce((acc, type) => {
        acc[type] = null;
        return acc;
    }, {});
    /**
     * Mark a highlighted chunk of text.
     */
    function mark(value) {
        return `<mark>${value}</mark>`;
    }
    Private.mark = mark;
    /**
     * A sort comparison function for item match scores.
     *
     * #### Notes
     * This orders the items first based on score (lower is better), then
     * by locale order of the item text.
     */
    function scoreCmp(a, b) {
        var _a, _b, _c;
        const delta = a.score - b.score;
        if (delta !== 0) {
            return delta;
        }
        return (_c = (_a = a.item.insertText) === null || _a === void 0 ? void 0 : _a.localeCompare((_b = b.item.insertText) !== null && _b !== void 0 ? _b : '')) !== null && _c !== void 0 ? _c : 0;
    }
    Private.scoreCmp = scoreCmp;
    /**
     * Compute a reliably ordered list of types for ICompletionItems.
     *
     * #### Notes
     * The resulting list always begins with the known types:
     * ```
     * ['function', 'instance', 'class', 'module', 'keyword']
     * ```
     * followed by other types in alphabetical order.
     *
     */
    function findOrderedCompletionItemTypes(items) {
        const newTypeSet = new Set();
        items.forEach(item => {
            if (item.type &&
                !KNOWN_TYPES.includes(item.type) &&
                !newTypeSet.has(item.type)) {
                newTypeSet.add(item.type);
            }
        });
        const newTypes = Array.from(newTypeSet);
        newTypes.sort((a, b) => a.localeCompare(b));
        return KNOWN_TYPES.concat(newTypes);
    }
    Private.findOrderedCompletionItemTypes = findOrderedCompletionItemTypes;
    /**
     * Compute a reliably ordered list of types.
     *
     * #### Notes
     * The resulting list always begins with the known types:
     * ```
     * ['function', 'instance', 'class', 'module', 'keyword']
     * ```
     * followed by other types in alphabetical order.
     */
    function findOrderedTypes(typeMap) {
        const filtered = Object.keys(typeMap)
            .map(key => typeMap[key])
            .filter((value) => !!value && !(value in KNOWN_MAP))
            .sort((a, b) => a.localeCompare(b));
        return KNOWN_TYPES.concat(filtered);
    }
    Private.findOrderedTypes = findOrderedTypes;
})(Private || (Private = {}));
//# sourceMappingURL=model.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/completer/lib/reconciliator.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@jupyterlab/completer/lib/reconciliator.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ProviderReconciliator: () => (/* binding */ ProviderReconciliator)
/* harmony export */ });
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * The reconciliator which is used to fetch and merge responses from multiple completion providers.
 */
class ProviderReconciliator {
    /**
     * Creates an instance of ProviderReconciliator.
     */
    constructor(options) {
        this._resolveFactory = (provider, el) => provider.resolve
            ? (patch) => provider.resolve(el, this._context, patch)
            : undefined;
        /**
         * Counter to reject current provider response if a new fetch request is created.
         */
        this._fetching = 0;
        this._providers = options.providers;
        this._context = options.context;
        this._timeout = options.timeout;
    }
    /**
     * Check for the providers which are applicable with the current context
     *
     * @return  List of applicable providers
     */
    async applicableProviders() {
        const isApplicablePromises = this._providers.map(p => p.isApplicable(this._context));
        const applicableProviders = await Promise.all(isApplicablePromises);
        return this._providers.filter((_, idx) => applicableProviders[idx]);
    }
    /**
     * Fetch response from multiple providers, If a provider can not return
     * the response for a completer request before timeout,
     * the result of this provider will be ignored.
     *
     * @param {CompletionHandler.IRequest} request - The completion request.
     */
    async fetch(request, trigger) {
        const current = ++this._fetching;
        let promises = [];
        const applicableProviders = await this.applicableProviders();
        for (const provider of applicableProviders) {
            let promise;
            promise = provider.fetch(request, this._context, trigger).then(reply => {
                if (current !== this._fetching) {
                    return Promise.reject(void 0);
                }
                const items = reply.items.map(el => ({
                    ...el,
                    resolve: this._resolveFactory(provider, el)
                }));
                return { ...reply, items };
            });
            const timeoutPromise = new Promise(resolve => {
                return setTimeout(() => resolve(null), this._timeout);
            });
            promise = Promise.race([promise, timeoutPromise]);
            // Wrap promise and return error in case of failure.
            promises.push(promise.catch(p => p));
        }
        // TODO: maybe use `Promise.allSettled` once library is at es2020 instead of adding a catch.
        const combinedPromise = Promise.all(promises);
        return this._mergeCompletions(combinedPromise);
    }
    /**
     * Check if completer should make request to fetch completion responses
     * on user typing. If the provider with highest rank does not have
     * `shouldShowContinuousHint` method, a default one will be used.
     *
     * @param completerIsVisible - The visible status of completer widget.
     * @param changed - CodeMirror changed argument.
     */
    async shouldShowContinuousHint(completerIsVisible, changed) {
        const applicableProviders = await this.applicableProviders();
        if (applicableProviders.length === 0) {
            return false;
        }
        if (applicableProviders[0].shouldShowContinuousHint) {
            return applicableProviders[0].shouldShowContinuousHint(completerIsVisible, changed, this._context);
        }
        return this._defaultShouldShowContinuousHint(completerIsVisible, changed);
    }
    _alignPrefixes(replies, minStart, maxStart) {
        if (minStart != maxStart) {
            const editor = this._context.editor;
            if (!editor) {
                return replies;
            }
            const cursor = editor.getCursorPosition();
            const line = editor.getLine(cursor.line);
            if (!line) {
                return replies;
            }
            return replies.map(reply => {
                // No prefix to strip, return as-is.
                if (reply.start == maxStart) {
                    return reply;
                }
                let prefix = line.substring(reply.start, maxStart);
                return {
                    ...reply,
                    items: reply.items.map(item => {
                        let insertText = item.insertText || item.label;
                        item.insertText = insertText.startsWith(prefix)
                            ? insertText.slice(prefix.length)
                            : insertText;
                        return item;
                    })
                };
            });
        }
        return replies;
    }
    async _mergeCompletions(promises) {
        let replies = (await promises).filter(reply => {
            // Ignore it errors out.
            if (!reply || reply instanceof Error) {
                return false;
            }
            // Ignore if no matches.
            if (!reply.items.length) {
                return false;
            }
            // Otherwise keep.
            return true;
        });
        // Fast path for a single reply or no replies.
        if (replies.length == 0) {
            return null;
        }
        else if (replies.length == 1) {
            return replies[0];
        }
        const minEnd = Math.min(...replies.map(reply => reply.end));
        // If any of the replies uses a wider range, we need to align them
        // so that all responses use the same range.
        const starts = replies.map(reply => reply.start);
        const minStart = Math.min(...starts);
        const maxStart = Math.max(...starts);
        replies = this._alignPrefixes(replies, minStart, maxStart);
        const insertTextSet = new Set();
        const mergedItems = new Array();
        for (const reply of replies) {
            reply.items.forEach(item => {
                // IPython returns 'import' and 'import '; while the latter is more useful,
                // user should not see two suggestions with identical labels and nearly-identical
                // behaviour as they could not distinguish the two either way.
                let text = (item.insertText || item.label).trim();
                if (insertTextSet.has(text)) {
                    return;
                }
                insertTextSet.add(text);
                mergedItems.push(item);
            });
        }
        return {
            start: maxStart,
            end: minEnd,
            items: mergedItems
        };
    }
    _defaultShouldShowContinuousHint(completerIsVisible, changed) {
        return (!completerIsVisible &&
            (changed.sourceChange == null ||
                changed.sourceChange.some(delta => delta.insert != null && delta.insert.length > 0)));
    }
}
//# sourceMappingURL=reconciliator.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/completer/lib/tokens.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/completer/lib/tokens.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CompletionTriggerKind: () => (/* binding */ CompletionTriggerKind),
/* harmony export */   ICompletionProviderManager: () => (/* binding */ ICompletionProviderManager)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/completer/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * The type of completion request.
 */
var CompletionTriggerKind;
(function (CompletionTriggerKind) {
    CompletionTriggerKind[CompletionTriggerKind["Invoked"] = 1] = "Invoked";
    CompletionTriggerKind[CompletionTriggerKind["TriggerCharacter"] = 2] = "TriggerCharacter";
    CompletionTriggerKind[CompletionTriggerKind["TriggerForIncompleteCompletions"] = 3] = "TriggerForIncompleteCompletions";
})(CompletionTriggerKind || (CompletionTriggerKind = {}));
/**
 * The exported token used to register new provider.
 */
const ICompletionProviderManager = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/completer:ICompletionProviderManager', 'A service for the completion providers management.');
//# sourceMappingURL=tokens.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/completer/lib/widget.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/completer/lib/widget.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Completer: () => (/* binding */ Completer)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ "./node_modules/@jupyterlab/apputils/lib/sanitizer.js");
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/rendermime */ "./node_modules/@jupyterlab/rendermime/lib/renderers.js");
/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ "./node_modules/@jupyterlab/ui-components/lib/hoverbox.js");
/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/domutils */ "./node_modules/@lumino/domutils/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.






/**
 * The class name added to completer menu items.
 */
const ITEM_CLASS = 'jp-Completer-item';
/**
 * The class name added to an active completer menu item.
 */
const ACTIVE_CLASS = 'jp-mod-active';
/**
 * The class used by item listing which determines the height of the completer.
 */
const LIST_CLASS = 'jp-Completer-list';
/**
 * Class of the documentation panel.
 */
const DOC_PANEL_CLASS = 'jp-Completer-docpanel';
/**
 * A flag to indicate that event handlers are caught in the capture phase.
 */
const USE_CAPTURE = true;
/**
 * The number of colors defined for the completer type annotations.
 * These are listed in completer/style/index.css#102-152.
 */
const N_COLORS = 10;
/**
 * A widget that enables text completion.
 *
 * #### Notes
 * The completer is intended to be absolutely positioned on the
 * page and hover over any other content, so it should be attached directly
 * to `document.body`, or a node that is the full size of `document.body`.
 * Attaching it to other nodes may incorrectly locate the completer.
 */
class Completer extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {
    /**
     * Construct a text completer menu widget.
     */
    constructor(options) {
        var _a, _b, _c, _d;
        super({ node: document.createElement('div') });
        this._activeIndex = 0;
        this._editor = null;
        this._model = null;
        this._selected = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._visibilityChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._indexChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        this._lastSubsetMatch = '';
        this._geometryLock = false;
        /**
         * Increasing this counter invalidates previous request to save geometry cache in animation callback.
         */
        this._geometryCounter = 0;
        this._docPanelExpanded = false;
        this._renderCounter = 0;
        this.sanitizer = (_a = options.sanitizer) !== null && _a !== void 0 ? _a : new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Sanitizer();
        this._defaultRenderer = Completer.getDefaultRenderer(this.sanitizer);
        this._renderer = (_b = options.renderer) !== null && _b !== void 0 ? _b : this._defaultRenderer;
        this._docPanel = this._createDocPanelNode();
        this.model = (_c = options.model) !== null && _c !== void 0 ? _c : null;
        this.editor = (_d = options.editor) !== null && _d !== void 0 ? _d : null;
        this.addClass('jp-Completer');
        this._updateConstraints();
    }
    /**
     * Cache style constraints from CSS.
     */
    _updateConstraints() {
        const tempNode = document.createElement('div');
        tempNode.classList.add(LIST_CLASS);
        tempNode.style.visibility = 'hidden';
        tempNode.style.overflowY = 'scroll';
        document.body.appendChild(tempNode);
        const computedStyle = window.getComputedStyle(tempNode);
        this._maxHeight = parseInt(computedStyle.maxHeight, 10);
        this._minHeight = parseInt(computedStyle.minHeight, 10);
        this._scrollbarWidth = tempNode.offsetWidth - tempNode.clientWidth;
        document.body.removeChild(tempNode);
        const tempDocPanel = this._createDocPanelNode();
        this._docPanelWidth = Private.measureSize(tempDocPanel, 'inline-block').width;
    }
    /**
     * The active index.
     */
    get activeIndex() {
        return this._activeIndex;
    }
    /**
     * The editor used by the completion widget.
     */
    get editor() {
        return this._editor;
    }
    set editor(newValue) {
        this._editor = newValue;
    }
    /**
     * A signal emitted when a selection is made from the completer menu.
     */
    get selected() {
        return this._selected;
    }
    /**
     * A signal emitted when the completer widget's visibility changes.
     *
     * #### Notes
     * This signal is useful when there are multiple floating widgets that may
     * contend with the same space and ought to be mutually exclusive.
     */
    get visibilityChanged() {
        return this._visibilityChanged;
    }
    /**
     * A signal emitted when the active index changes.
     */
    get indexChanged() {
        return this._indexChanged;
    }
    /**
     * The model used by the completer widget.
     */
    get model() {
        return this._model;
    }
    set model(model) {
        if ((!model && !this._model) || model === this._model) {
            return;
        }
        if (this._model) {
            this._model.stateChanged.disconnect(this.onModelStateChanged, this);
            this._model.queryChanged.disconnect(this.onModelQueryChanged, this);
        }
        this._model = model;
        if (this._model) {
            this._model.stateChanged.connect(this.onModelStateChanged, this);
            this._model.queryChanged.connect(this.onModelQueryChanged, this);
        }
    }
    /**
     * The completer used by the completer widget.
     */
    get renderer() {
        return this._renderer;
    }
    set renderer(renderer) {
        this._renderer = renderer;
    }
    /**
     * Enable/disable the document panel.
     */
    set showDocsPanel(showDoc) {
        this._showDoc = showDoc;
    }
    get showDocsPanel() {
        return this._showDoc;
    }
    /**
     * Dispose of the resources held by the completer widget.
     */
    dispose() {
        this._sizeCache = undefined;
        this._model = null;
        super.dispose();
    }
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     * #### Notes
     * This method implements the DOM `EventListener` interface and is
     * called in response to events on the dock panel's node. It should
     * not be called directly by user code.
     */
    handleEvent(event) {
        if (this.isHidden || !this._editor) {
            return;
        }
        switch (event.type) {
            case 'keydown':
                this._evtKeydown(event);
                break;
            case 'pointerdown':
                this._evtPointerdown(event);
                break;
            case 'scroll':
                this._evtScroll(event);
                break;
            default:
                break;
        }
    }
    /**
     * Reset the widget.
     */
    reset() {
        this._activeIndex = 0;
        this._lastSubsetMatch = '';
        if (this._model) {
            this._model.reset(true);
        }
        this._docPanel.style.display = 'none';
        // Clear size cache.
        this._sizeCache = undefined;
        this.node.scrollTop = 0;
    }
    /**
     * Emit the selected signal for the current active item and reset.
     */
    selectActive() {
        const active = this.node.querySelector(`.${ACTIVE_CLASS}`);
        if (!active) {
            this.reset();
            return;
        }
        this._selected.emit(active.getAttribute('data-value'));
        this.reset();
    }
    /**
     * Handle `after-attach` messages for the widget.
     */
    onAfterAttach(msg) {
        document.addEventListener('keydown', this, USE_CAPTURE);
        document.addEventListener('pointerdown', this, USE_CAPTURE);
        document.addEventListener('scroll', this, USE_CAPTURE);
    }
    /**
     * Handle `before-detach` messages for the widget.
     */
    onBeforeDetach(msg) {
        document.removeEventListener('keydown', this, USE_CAPTURE);
        document.removeEventListener('pointerdown', this, USE_CAPTURE);
        document.removeEventListener('scroll', this, USE_CAPTURE);
    }
    /**
     * Handle model state changes.
     */
    onModelStateChanged() {
        if (this.isAttached) {
            this._activeIndex = 0;
            this._indexChanged.emit(this._activeIndex);
            this.update();
        }
    }
    /**
     * Handle model query changes.
     */
    onModelQueryChanged(model, queryChange) {
        // If query was changed by the user typing, the filtered down items
        // may no longer reach/exceed the maxHeight of the completer widget,
        // hence size needs to be recalculated.
        if (this._sizeCache && queryChange.origin === 'editorUpdate') {
            const newItems = model.completionItems();
            const oldItems = this._sizeCache.items;
            // Only reset size if the number of items changed, or the longest item changed.
            const oldWidest = oldItems[this._findWidestItemIndex(oldItems)];
            const newWidest = newItems[this._findWidestItemIndex(newItems)];
            const heuristic = this._getPreferredItemWidthHeuristic();
            if (newItems.length !== this._sizeCache.items.length ||
                heuristic(oldWidest) !== heuristic(newWidest)) {
                this._sizeCache = undefined;
            }
        }
    }
    /**
     * Handle `update-request` messages.
     */
    onUpdateRequest(msg) {
        var _a;
        const model = this._model;
        if (!model) {
            return;
        }
        // If this is the first time the current completer session has loaded,
        // populate any initial subset match. This is being done before node
        // gets rendered to avoid rendering it twice.
        if (!model.query) {
            this._populateSubset();
        }
        let items = model.completionItems();
        // If there are no items, reset and bail.
        if (!items.length) {
            if (!this.isHidden) {
                this.reset();
                this.hide();
                this._visibilityChanged.emit(undefined);
            }
            return;
        }
        // Update constraints before any DOM modifications
        this._updateConstraints();
        // Do not trigger any geometry updates from async code when in lock.
        this._geometryLock = true;
        const node = this._createCompleterNode(model, items);
        let active = node.querySelectorAll(`.${ITEM_CLASS}`)[this._activeIndex];
        active.classList.add(ACTIVE_CLASS);
        const resolvedItem = (_a = this.model) === null || _a === void 0 ? void 0 : _a.resolveItem(items[this._activeIndex]);
        // Add the documentation panel
        if (this._showDoc) {
            this._docPanel.innerText = '';
            node.appendChild(this._docPanel);
            this._docPanelExpanded = false;
            this._docPanel.style.display = 'none';
            this._updateDocPanel(resolvedItem, active);
        }
        if (this.isHidden) {
            this.show();
            this._setGeometry();
            this._visibilityChanged.emit(undefined);
        }
        else {
            this._setGeometry();
        }
        this._geometryLock = false;
    }
    /**
     * Get cached dimensions of the completer box.
     */
    get sizeCache() {
        if (!this._sizeCache) {
            return;
        }
        return {
            width: this._sizeCache.width + this._sizeCache.docPanelWidth,
            height: Math.max(this._sizeCache.height, this._sizeCache.docPanelHeight)
        };
    }
    _createDocPanelNode() {
        const docPanel = document.createElement('div');
        docPanel.className = DOC_PANEL_CLASS;
        return docPanel;
    }
    _createCompleterNode(model, items) {
        const current = ++this._renderCounter;
        // Clear the node.
        let node = this.node;
        node.textContent = '';
        // Compute an ordered list of all the types in the typeMap, this is computed
        // once by the model each time new data arrives for efficiency.
        let orderedTypes = model.orderedTypes();
        // Populate the completer items.
        let ul = document.createElement('ul');
        ul.className = LIST_CLASS;
        // Add first N items to fill the first "page" assuming that the completer
        // would reach its maximum allowed height.
        const first = this._renderer.createCompletionItemNode(items[0], orderedTypes);
        const renderedItems = [first];
        const firstItemSize = Private.measureSize(first, 'inline-grid');
        const pageSize = Math.max(Math.ceil(this._maxHeight / firstItemSize.height), 5);
        // We add one item in case if height heuristic is inaccurate.
        const toRenderImmediately = Math.min(pageSize + 1, items.length);
        const start = performance.now();
        for (let i = 1; i < toRenderImmediately; i++) {
            const li = this._renderer.createCompletionItemNode(items[i], orderedTypes);
            renderedItems.push(li);
        }
        for (const li of renderedItems) {
            ul.appendChild(li);
        }
        // Pre-calculate size:
        //  - height will equal first element height times number of items,
        //    or maximum allowed height if there are more items than fit on a page,
        //  - width will be estimated from the widest item.
        const widestItemIndex = this._findWidestItemIndex(items);
        const widestItem = widestItemIndex < renderedItems.length
            ? renderedItems[widestItemIndex]
            : this._renderer.createCompletionItemNode(items[widestItemIndex], orderedTypes);
        // The node needs to be cloned to avoid side-effect of detaching it.
        const widestItemSize = Private.measureSize(widestItem.cloneNode(true), 'inline-grid');
        this._sizeCache = {
            height: Math.min(this._maxHeight, firstItemSize.height * items.length),
            width: widestItemSize.width + this._scrollbarWidth,
            items: items,
            docPanelWidth: 0,
            docPanelHeight: 0
        };
        if (toRenderImmediately < items.length) {
            // Render remaining items on idle in subsequent animation frames,
            // in chunks of size such that each frame would take about 16ms
            // allowing for 4ms of overhead, but keep the chunks no smaller
            // than 5 items at a time.
            const timePerItem = (performance.now() - start) / toRenderImmediately;
            const chunkSize = Math.max(5, Math.floor(12 / timePerItem));
            let alreadyRendered = toRenderImmediately;
            let previousChunkFinal = renderedItems[renderedItems.length - 1];
            const renderChunk = () => {
                if (alreadyRendered >= items.length) {
                    return;
                }
                // Add a filler so that the list with partially rendered items has the total
                // height equal to the (predicted) final height to avoid scrollbar jitter.
                const predictedMissingHeight = firstItemSize.height * (items.length - alreadyRendered);
                previousChunkFinal.style.marginBottom = `${predictedMissingHeight}px`;
                requestAnimationFrame(() => {
                    if (current != this._renderCounter) {
                        // Bail if rendering afresh was requested in the meantime.
                        return;
                    }
                    previousChunkFinal.style.marginBottom = '';
                    const limit = Math.min(items.length, alreadyRendered + chunkSize);
                    for (let i = alreadyRendered; i < limit; i++) {
                        const li = this._renderer.createCompletionItemNode(items[i], orderedTypes);
                        ul.appendChild(li);
                        previousChunkFinal = li;
                    }
                    alreadyRendered = limit;
                    renderChunk();
                });
            };
            renderChunk();
        }
        node.appendChild(ul);
        return node;
    }
    /**
     * Use preferred heuristic to find the index of the widest item.
     */
    _findWidestItemIndex(items) {
        const widthHeuristic = this._getPreferredItemWidthHeuristic();
        const widthHeuristics = items.map(widthHeuristic);
        return widthHeuristics.indexOf(Math.max(...widthHeuristics));
    }
    /**
     * Get item width heuristic function from renderer if available,
     * or the default one otherwise.
     */
    _getPreferredItemWidthHeuristic() {
        return this._renderer.itemWidthHeuristic
            ? this._renderer.itemWidthHeuristic.bind(this._renderer)
            : this._defaultRenderer.itemWidthHeuristic.bind(this._defaultRenderer);
    }
    /**
     * Cycle through the available completer items.
     *
     * #### Notes
     * When the user cycles all the way `down` to the last index, subsequent
     * `down` cycles will cycle to the first index. When the user cycles `up` to
     * the first item, subsequent `up` cycles will cycle to the last index.
     */
    _cycle(direction) {
        var _a, _b;
        const items = this.node.querySelectorAll(`.${ITEM_CLASS}`);
        const index = this._activeIndex;
        const last = items.length - 1;
        let active = this.node.querySelector(`.${ACTIVE_CLASS}`);
        active.classList.remove(ACTIVE_CLASS);
        switch (direction) {
            case 'up':
                this._activeIndex = index === 0 ? last : index - 1;
                break;
            case 'down':
                this._activeIndex = index < last ? index + 1 : 0;
                break;
            case 'pageUp':
            case 'pageDown': {
                // Measure the number of items on a page and clamp to the list length.
                const container = this.node.getBoundingClientRect();
                const current = active.getBoundingClientRect();
                const page = Math.floor(container.height / current.height);
                const sign = direction === 'pageUp' ? -1 : 1;
                this._activeIndex = Math.min(Math.max(0, index + sign * page), last);
                break;
            }
        }
        active = items[this._activeIndex];
        active.classList.add(ACTIVE_CLASS);
        let completionList = this.node.querySelector(`.${LIST_CLASS}`);
        _lumino_domutils__WEBPACK_IMPORTED_MODULE_0__.ElementExt.scrollIntoViewIfNeeded(completionList, active);
        this._indexChanged.emit(this._activeIndex);
        const visibleCompletionItems = (_a = this.model) === null || _a === void 0 ? void 0 : _a.completionItems();
        const activeCompletionItem = visibleCompletionItems === null || visibleCompletionItems === void 0 ? void 0 : visibleCompletionItems[this._activeIndex];
        if (activeCompletionItem) {
            const resolvedItem = (_b = this.model) === null || _b === void 0 ? void 0 : _b.resolveItem(activeCompletionItem);
            if (this._showDoc) {
                this._updateDocPanel(resolvedItem, active);
            }
        }
    }
    /**
     * Handle keydown events for the widget.
     */
    _evtKeydown(event) {
        if (this.isHidden || !this._editor) {
            return;
        }
        if (!this._editor.host.contains(event.target)) {
            this.reset();
            return;
        }
        switch (event.keyCode) {
            case 9: {
                // Tab key
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
                const model = this._model;
                if (!model) {
                    return;
                }
                // Autoinsert single completions on manual request (tab)
                const items = model.completionItems();
                if (items && items.length === 1) {
                    this._selected.emit(items[0].insertText || items[0].label);
                    this.reset();
                    return;
                }
                const populated = this._populateSubset();
                // If the common subset was found and set on `query`,
                // or if there is a `query` in the initialization options,
                // then emit a completion signal with that `query` (=subset match),
                // but only if the query has actually changed.
                // See: https://github.com/jupyterlab/jupyterlab/issues/10439#issuecomment-875189540
                if (model.query && model.query !== this._lastSubsetMatch) {
                    model.subsetMatch = true;
                    this._selected.emit(model.query);
                    model.subsetMatch = false;
                    this._lastSubsetMatch = model.query;
                }
                // If the query changed, update rendering of the options.
                if (populated) {
                    this.update();
                }
                this._cycle(event.shiftKey ? 'up' : 'down');
                return;
            }
            case 27: // Esc key
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
                this.reset();
                return;
            case 33: // PageUp
            case 34: // PageDown
            case 38: // Up arrow key
            case 40: {
                // Down arrow key
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
                const cycle = Private.keyCodeMap[event.keyCode];
                this._cycle(cycle);
                return;
            }
            default:
                return;
        }
    }
    /**
     * Handle mousedown events for the widget.
     */
    _evtPointerdown(event) {
        if (this.isHidden || !this._editor) {
            return;
        }
        if (Private.nonstandardClick(event)) {
            this.reset();
            return;
        }
        let target = event.target;
        while (target !== document.documentElement) {
            // If the user has made a selection, emit its value and reset the widget.
            if (target.classList.contains(ITEM_CLASS)) {
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
                this._selected.emit(target.getAttribute('data-value'));
                this.reset();
                return;
            }
            // If the mouse event happened anywhere else in the widget, bail.
            if (target === this.node) {
                event.preventDefault();
                event.stopPropagation();
                event.stopImmediatePropagation();
                return;
            }
            target = target.parentElement;
        }
        this.reset();
    }
    /**
     * Handle scroll events for the widget
     */
    _evtScroll(event) {
        if (this.isHidden || !this._editor) {
            return;
        }
        const { node } = this;
        // All scrolls except scrolls in the actual hover box node may cause the
        // referent editor that anchors the node to move, so the only scroll events
        // that can safely be ignored are ones that happen inside the hovering node.
        if (node.contains(event.target)) {
            return;
        }
        // Set the geometry of the node asynchronously.
        requestAnimationFrame(() => {
            this._setGeometry();
        });
    }
    /**
     * Populate the completer up to the longest initial subset of items.
     *
     * @returns `true` if a subset match was found and populated.
     */
    _populateSubset() {
        const { model } = this;
        if (!model) {
            return false;
        }
        const items = model.completionItems();
        const subset = Private.commonSubset(items.map(item => item.insertText || item.label));
        const { query } = model;
        // If a common subset exists and it is not the current query, highlight it.
        if (subset && subset !== query && subset.indexOf(query) === 0) {
            model.query = subset;
            return true;
        }
        return false;
    }
    /**
     * Set the visible dimensions of the widget.
     */
    _setGeometry() {
        const { node } = this;
        const model = this._model;
        const editor = this._editor;
        // This is an overly defensive test: `cursor` will always exist if
        // `original` exists, except in contrived tests. But since it is possible
        // to generate a runtime error, the check occurs here.
        if (!editor || !model || !model.original || !model.cursor) {
            return;
        }
        const start = model.cursor.start;
        const position = editor.getPositionAt(start);
        const anchor = editor.getCoordinateForPosition(position);
        const style = window.getComputedStyle(node);
        const borderLeft = parseInt(style.borderLeftWidth, 10) || 0;
        const paddingLeft = parseInt(style.paddingLeft, 10) || 0;
        // When the editor is attached to the main area, contain the completer hover box
        // to the full area available (rather than to the editor itself); the available
        // area excludes the toolbar, hence the first Widget child between MainAreaWidget
        // and editor is preferred. The difference is negligible in File Editor, but
        // substantial for Notebooks.
        const host = editor.host.closest('.jp-MainAreaWidget > .lm-Widget') ||
            editor.host;
        const items = model.completionItems();
        // Fast cache invalidation (only checks for length rather than length + width)
        if (this._sizeCache && this._sizeCache.items.length !== items.length) {
            this._sizeCache = undefined;
        }
        // Calculate the geometry of the completer.
        _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.HoverBox.setGeometry({
            anchor,
            host: host,
            maxHeight: this._maxHeight,
            minHeight: this._minHeight,
            node: node,
            size: this.sizeCache,
            offset: { horizontal: borderLeft + paddingLeft },
            privilege: 'below',
            style: style,
            outOfViewDisplay: {
                top: 'stick-inside',
                bottom: 'stick-inside',
                left: 'stick-inside',
                right: 'stick-outside'
            }
        });
        const current = ++this._geometryCounter;
        if (!this._sizeCache) {
            // If size was not pre-calculated using heuristics, save the actual
            // size into cache once rendered.
            requestAnimationFrame(() => {
                if (current != this._geometryCounter) {
                    // Do not set size to cache if it may already be outdated.
                    return;
                }
                let rect = node.getBoundingClientRect();
                let panel = this._docPanel.getBoundingClientRect();
                this._sizeCache = {
                    width: rect.width - panel.width,
                    height: rect.height,
                    items: items,
                    docPanelWidth: panel.width,
                    docPanelHeight: panel.height
                };
            });
        }
    }
    /**
     * Update the display-state and contents of the documentation panel
     */
    _updateDocPanel(resolvedItem, activeNode) {
        var _a, _b, _c;
        let docPanel = this._docPanel;
        if (!resolvedItem) {
            this._toggleDocPanel(false);
            return;
        }
        const loadingIndicator = (_c = (_b = (_a = this._renderer).createLoadingDocsIndicator) === null || _b === void 0 ? void 0 : _b.call(_a)) !== null && _c !== void 0 ? _c : this._defaultRenderer.createLoadingDocsIndicator();
        activeNode.appendChild(loadingIndicator);
        resolvedItem
            .then(activeItem => {
            var _a, _b, _c;
            if (!activeItem) {
                return;
            }
            if (!docPanel) {
                return;
            }
            if (activeItem.documentation) {
                const node = (_c = (_b = (_a = this._renderer).createDocumentationNode) === null || _b === void 0 ? void 0 : _b.call(_a, activeItem)) !== null && _c !== void 0 ? _c : this._defaultRenderer.createDocumentationNode(activeItem);
                docPanel.textContent = '';
                docPanel.appendChild(node);
                this._toggleDocPanel(true);
            }
            else {
                this._toggleDocPanel(false);
            }
        })
            .catch(e => console.error(e))
            .finally(() => {
            activeNode.removeChild(loadingIndicator);
        });
    }
    _toggleDocPanel(show) {
        let docPanel = this._docPanel;
        if (show) {
            if (this._docPanelExpanded) {
                return;
            }
            docPanel.style.display = '';
            this._docPanelExpanded = true;
        }
        else {
            if (!this._docPanelExpanded) {
                return;
            }
            docPanel.style.display = 'none';
            this._docPanelExpanded = false;
        }
        const sizeCache = this._sizeCache;
        if (sizeCache) {
            sizeCache.docPanelHeight = show ? this._maxHeight : 0;
            sizeCache.docPanelWidth = show ? this._docPanelWidth : 0;
            if (!this._geometryLock) {
                this._setGeometry();
            }
        }
    }
}
(function (Completer) {
    /**
     * The default implementation of an `IRenderer`.
     */
    class Renderer {
        constructor(options) {
            this.sanitizer = (options === null || options === void 0 ? void 0 : options.sanitizer) || new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Sanitizer();
        }
        /**
         * Create an item node from an ICompletionItem for a text completer menu.
         */
        createCompletionItemNode(item, orderedTypes) {
            let wrapperNode = this._createWrapperNode(item.insertText || item.label);
            if (item.deprecated) {
                wrapperNode.classList.add('jp-Completer-deprecated');
            }
            return this._constructNode(wrapperNode, this._createLabelNode(item.label), !!item.type, item.type, orderedTypes, item.icon);
        }
        /**
         * Create a documentation node for documentation panel.
         */
        createDocumentationNode(activeItem) {
            const host = document.createElement('div');
            host.classList.add('jp-RenderedText');
            const sanitizer = this.sanitizer;
            const source = activeItem.documentation || '';
            (0,_jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_5__.renderText)({ host, sanitizer, source }).catch(console.error);
            return host;
        }
        /**
         * Get a heuristic for the width of an item.
         */
        itemWidthHeuristic(item) {
            var _a;
            // Get the label text without HTML markup (`<mark>` is the only markup
            // that is allowed in processed items, everything else gets escaped).
            const labelText = item.label.replace(/<(\/)?mark>/g, '');
            return labelText.length + (((_a = item.type) === null || _a === void 0 ? void 0 : _a.length) || 0);
        }
        /**
         * Create a loading bar for the documentation panel.
         */
        createLoadingDocsIndicator() {
            const loadingContainer = document.createElement('div');
            loadingContainer.classList.add('jp-Completer-loading-bar-container');
            const loadingBar = document.createElement('div');
            loadingBar.classList.add('jp-Completer-loading-bar');
            loadingContainer.append(loadingBar);
            return loadingContainer;
        }
        /**
         * Create base node with the value to be inserted.
         */
        _createWrapperNode(value) {
            const li = document.createElement('li');
            li.className = ITEM_CLASS;
            // Set the raw, un-marked up value as a data attribute.
            li.setAttribute('data-value', value);
            return li;
        }
        /**
         * Create match node to highlight potential prefix match within result.
         */
        _createLabelNode(result) {
            const matchNode = document.createElement('code');
            matchNode.className = 'jp-Completer-match';
            // Use innerHTML because search results include <mark> tags.
            matchNode.innerHTML = result;
            return matchNode;
        }
        /**
         * Attaches type and match nodes to base node.
         */
        _constructNode(li, matchNode, typesExist, type, orderedTypes, icon) {
            // Add the icon or type monogram
            if (icon) {
                const iconNode = icon.element({
                    className: 'jp-Completer-type jp-Completer-icon'
                });
                li.appendChild(iconNode);
            }
            else if (typesExist) {
                const typeNode = document.createElement('span');
                typeNode.textContent = (type[0] || '').toLowerCase();
                const colorIndex = (orderedTypes.indexOf(type) % N_COLORS) + 1;
                typeNode.className = 'jp-Completer-type jp-Completer-monogram';
                typeNode.setAttribute(`data-color-index`, colorIndex.toString());
                li.appendChild(typeNode);
            }
            else {
                // Create empty span to ensure consistent list styling.
                // Otherwise, in a list of two items,
                // if one item has an icon, but the other has type,
                // the icon grows out of its bounds.
                const dummyNode = document.createElement('span');
                dummyNode.className = 'jp-Completer-monogram';
                li.appendChild(dummyNode);
            }
            li.appendChild(matchNode);
            // If there is a type, add the type extension and title
            if (typesExist) {
                li.title = type;
                const typeExtendedNode = document.createElement('code');
                typeExtendedNode.className = 'jp-Completer-typeExtended';
                typeExtendedNode.textContent = type.toLocaleLowerCase();
                li.appendChild(typeExtendedNode);
            }
            else {
                // If no type is present on the right,
                // the highlighting of the completion item
                // doesn't cover the entire row.
                const dummyTypeExtendedNode = document.createElement('span');
                dummyTypeExtendedNode.className = 'jp-Completer-typeExtended';
                li.appendChild(dummyTypeExtendedNode);
            }
            return li;
        }
    }
    Completer.Renderer = Renderer;
    /**
     * Default renderer
     */
    let _defaultRenderer;
    /**
     * The default `IRenderer` instance.
     */
    function getDefaultRenderer(sanitizer) {
        if (!_defaultRenderer ||
            (sanitizer && _defaultRenderer.sanitizer !== sanitizer)) {
            _defaultRenderer = new Renderer({ sanitizer: sanitizer });
        }
        return _defaultRenderer;
    }
    Completer.getDefaultRenderer = getDefaultRenderer;
})(Completer || (Completer = {}));
/**
 * A namespace for completer widget private data.
 */
var Private;
(function (Private) {
    /**
     * Mapping from keyCodes to scrollTypes.
     */
    Private.keyCodeMap = {
        38: 'up',
        40: 'down',
        33: 'pageUp',
        34: 'pageDown'
    };
    /**
     * Returns the common subset string that a list of strings shares.
     */
    function commonSubset(values) {
        const len = values.length;
        let subset = '';
        if (len < 2) {
            return subset;
        }
        const strlen = values[0].length;
        for (let i = 0; i < strlen; i++) {
            const ch = values[0][i];
            for (let j = 1; j < len; j++) {
                if (values[j][i] !== ch) {
                    return subset;
                }
            }
            subset += ch;
        }
        return subset;
    }
    Private.commonSubset = commonSubset;
    /**
     * Returns true for any modified click event (i.e., not a left-click).
     */
    function nonstandardClick(event) {
        return (event.button !== 0 ||
            event.altKey ||
            event.ctrlKey ||
            event.shiftKey ||
            event.metaKey);
    }
    Private.nonstandardClick = nonstandardClick;
    /**
     * Measure size of provided HTML element without painting it.
     *
     * #### Notes
     * The provided element has to be detached (not connected to DOM),
     * or a side-effect of detaching it will occur.
     */
    function measureSize(element, display) {
        if (element.isConnected) {
            console.warn('Measuring connected elements with `measureSize` has side-effects');
        }
        element.style.visibility = 'hidden';
        element.style.display = display;
        document.body.appendChild(element);
        const size = element.getBoundingClientRect();
        document.body.removeChild(element);
        element.removeAttribute('style');
        return size;
    }
    Private.measureSize = measureSize;
})(Private || (Private = {}));
//# sourceMappingURL=widget.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/completer/node_modules/@lumino/coreutils/dist/index.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@jupyterlab/completer/node_modules/@lumino/coreutils/dist/index.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
     true ? factory(exports) :
    0;
})(this, (function (exports) { 'use strict';

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for JSON-specific functions.
     */
    exports.JSONExt = void 0;
    (function (JSONExt) {
        /**
         * A shared frozen empty JSONObject
         */
        JSONExt.emptyObject = Object.freeze({});
        /**
         * A shared frozen empty JSONArray
         */
        JSONExt.emptyArray = Object.freeze([]);
        /**
         * Test whether a JSON value is a primitive.
         *
         * @param value - The JSON value of interest.
         *
         * @returns `true` if the value is a primitive,`false` otherwise.
         */
        function isPrimitive(value) {
            return (value === null ||
                typeof value === 'boolean' ||
                typeof value === 'number' ||
                typeof value === 'string');
        }
        JSONExt.isPrimitive = isPrimitive;
        function isArray(value) {
            return Array.isArray(value);
        }
        JSONExt.isArray = isArray;
        function isObject(value) {
            return !isPrimitive(value) && !isArray(value);
        }
        JSONExt.isObject = isObject;
        /**
         * Compare two JSON values for deep equality.
         *
         * @param first - The first JSON value of interest.
         *
         * @param second - The second JSON value of interest.
         *
         * @returns `true` if the values are equivalent, `false` otherwise.
         */
        function deepEqual(first, second) {
            // Check referential and primitive equality first.
            if (first === second) {
                return true;
            }
            // If one is a primitive, the `===` check ruled out the other.
            if (isPrimitive(first) || isPrimitive(second)) {
                return false;
            }
            // Test whether they are arrays.
            let a1 = isArray(first);
            let a2 = isArray(second);
            // Bail if the types are different.
            if (a1 !== a2) {
                return false;
            }
            // If they are both arrays, compare them.
            if (a1 && a2) {
                return deepArrayEqual(first, second);
            }
            // At this point, they must both be objects.
            return deepObjectEqual(first, second);
        }
        JSONExt.deepEqual = deepEqual;
        /**
         * Create a deep copy of a JSON value.
         *
         * @param value - The JSON value to copy.
         *
         * @returns A deep copy of the given JSON value.
         */
        function deepCopy(value) {
            // Do nothing for primitive values.
            if (isPrimitive(value)) {
                return value;
            }
            // Deep copy an array.
            if (isArray(value)) {
                return deepArrayCopy(value);
            }
            // Deep copy an object.
            return deepObjectCopy(value);
        }
        JSONExt.deepCopy = deepCopy;
        /**
         * Compare two JSON arrays for deep equality.
         */
        function deepArrayEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Test the arrays for equal length.
            if (first.length !== second.length) {
                return false;
            }
            // Compare the values for equality.
            for (let i = 0, n = first.length; i < n; ++i) {
                if (!deepEqual(first[i], second[i])) {
                    return false;
                }
            }
            // At this point, the arrays are equal.
            return true;
        }
        /**
         * Compare two JSON objects for deep equality.
         */
        function deepObjectEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Check for the first object's keys in the second object.
            for (let key in first) {
                if (first[key] !== undefined && !(key in second)) {
                    return false;
                }
            }
            // Check for the second object's keys in the first object.
            for (let key in second) {
                if (second[key] !== undefined && !(key in first)) {
                    return false;
                }
            }
            // Compare the values for equality.
            for (let key in first) {
                // Get the values.
                let firstValue = first[key];
                let secondValue = second[key];
                // If both are undefined, ignore the key.
                if (firstValue === undefined && secondValue === undefined) {
                    continue;
                }
                // If only one value is undefined, the objects are not equal.
                if (firstValue === undefined || secondValue === undefined) {
                    return false;
                }
                // Compare the values.
                if (!deepEqual(firstValue, secondValue)) {
                    return false;
                }
            }
            // At this point, the objects are equal.
            return true;
        }
        /**
         * Create a deep copy of a JSON array.
         */
        function deepArrayCopy(value) {
            let result = new Array(value.length);
            for (let i = 0, n = value.length; i < n; ++i) {
                result[i] = deepCopy(value[i]);
            }
            return result;
        }
        /**
         * Create a deep copy of a JSON object.
         */
        function deepObjectCopy(value) {
            let result = {};
            for (let key in value) {
                // Ignore undefined values.
                let subvalue = value[key];
                if (subvalue === undefined) {
                    continue;
                }
                result[key] = deepCopy(subvalue);
            }
            return result;
        }
    })(exports.JSONExt || (exports.JSONExt = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * An object which stores MIME data for general application use.
     *
     * #### Notes
     * This class does not attempt to enforce "correctness" of MIME types
     * and their associated data. Since this class is designed to transfer
     * arbitrary data and objects within the same application, it assumes
     * that the user provides correct and accurate data.
     */
    class MimeData {
        constructor() {
            this._types = [];
            this._values = [];
        }
        /**
         * Get an array of the MIME types contained within the dataset.
         *
         * @returns A new array of the MIME types, in order of insertion.
         */
        types() {
            return this._types.slice();
        }
        /**
         * Test whether the dataset has an entry for the given type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns `true` if the dataset contains a value for the given
         *   MIME type, `false` otherwise.
         */
        hasData(mime) {
            return this._types.indexOf(mime) !== -1;
        }
        /**
         * Get the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns The value for the given MIME type, or `undefined` if
         *   the dataset does not contain a value for the type.
         */
        getData(mime) {
            let i = this._types.indexOf(mime);
            return i !== -1 ? this._values[i] : undefined;
        }
        /**
         * Set the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @param data - The data value for the given MIME type.
         *
         * #### Notes
         * This will overwrite any previous entry for the MIME type.
         */
        setData(mime, data) {
            this.clearData(mime);
            this._types.push(mime);
            this._values.push(data);
        }
        /**
         * Remove the data entry for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * #### Notes
         * This is a no-op if there is no entry for the given MIME type.
         */
        clearData(mime) {
            let i = this._types.indexOf(mime);
            if (i !== -1) {
                this._types.splice(i, 1);
                this._values.splice(i, 1);
            }
        }
        /**
         * Remove all data entries from the dataset.
         */
        clear() {
            this._types.length = 0;
            this._values.length = 0;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A class which wraps a promise into a delegate object.
     *
     * #### Notes
     * This class is useful when the logic to resolve or reject a promise
     * cannot be defined at the point where the promise is created.
     */
    class PromiseDelegate {
        /**
         * Construct a new promise delegate.
         */
        constructor() {
            this.promise = new Promise((resolve, reject) => {
                this._resolve = resolve;
                this._reject = reject;
            });
        }
        /**
         * Resolve the wrapped promise with the given value.
         *
         * @param value - The value to use for resolving the promise.
         */
        resolve(value) {
            let resolve = this._resolve;
            resolve(value);
        }
        /**
         * Reject the wrapped promise with the given value.
         *
         * @reason - The reason for rejecting the promise.
         */
        reject(reason) {
            let reject = this._reject;
            reject(reason);
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A runtime object which captures compile-time type information.
     *
     * #### Notes
     * A token captures the compile-time type of an interface or class in
     * an object which can be used at runtime in a type-safe fashion.
     */
    class Token {
        /**
         * Construct a new token.
         *
         * @param name - A human readable name for the token.
         * @param description - Token purpose description for documentation.
         */
        constructor(name, description) {
            this.name = name;
            this.description = description !== null && description !== void 0 ? description : '';
            this._tokenStructuralPropertyT = null;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    // Fallback
    function fallbackRandomValues(buffer) {
        let value = 0;
        for (let i = 0, n = buffer.length; i < n; ++i) {
            if (i % 4 === 0) {
                value = (Math.random() * 0xffffffff) >>> 0;
            }
            buffer[i] = value & 0xff;
            value >>>= 8;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for random number related functionality.
     */
    exports.Random = void 0;
    (function (Random) {
        /**
         * A function which generates random bytes.
         *
         * @param buffer - The `Uint8Array` to fill with random bytes.
         *
         * #### Notes
         * A cryptographically strong random number generator will be used if
         * available. Otherwise, `Math.random` will be used as a fallback for
         * randomness.
         *
         * The following RNGs are supported, listed in order of precedence:
         *   - `window.crypto.getRandomValues`
         *   - `window.msCrypto.getRandomValues`
         *   - `require('crypto').randomFillSync
         *   - `require('crypto').randomBytes
         *   - `Math.random`
         */
        Random.getRandomValues = (() => {
            // Look up the crypto module if available.
            const crypto = (typeof window !== 'undefined' && (window.crypto || window.msCrypto)) ||
                null;
            // Modern browsers and IE 11
            if (crypto && typeof crypto.getRandomValues === 'function') {
                return function getRandomValues(buffer) {
                    return crypto.getRandomValues(buffer);
                };
            }
            // Fallback
            return fallbackRandomValues;
        })();
    })(exports.Random || (exports.Random = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A function which creates a function that generates UUID v4 identifiers.
     *
     * @returns A new function that creates a UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    function uuid4Factory(getRandomValues) {
        // Create a 16 byte array to hold the random values.
        const bytes = new Uint8Array(16);
        // Create a look up table from bytes to hex strings.
        const lut = new Array(256);
        // Pad the single character hex digits with a leading zero.
        for (let i = 0; i < 16; ++i) {
            lut[i] = '0' + i.toString(16);
        }
        // Populate the rest of the hex digits.
        for (let i = 16; i < 256; ++i) {
            lut[i] = i.toString(16);
        }
        // Return a function which generates the UUID.
        return function uuid4() {
            // Get a new batch of random values.
            getRandomValues(bytes);
            // Set the UUID version number to 4.
            bytes[6] = 0x40 | (bytes[6] & 0x0f);
            // Set the clock sequence bit to the RFC spec.
            bytes[8] = 0x80 | (bytes[8] & 0x3f);
            // Assemble the UUID string.
            return (lut[bytes[0]] +
                lut[bytes[1]] +
                lut[bytes[2]] +
                lut[bytes[3]] +
                '-' +
                lut[bytes[4]] +
                lut[bytes[5]] +
                '-' +
                lut[bytes[6]] +
                lut[bytes[7]] +
                '-' +
                lut[bytes[8]] +
                lut[bytes[9]] +
                '-' +
                lut[bytes[10]] +
                lut[bytes[11]] +
                lut[bytes[12]] +
                lut[bytes[13]] +
                lut[bytes[14]] +
                lut[bytes[15]]);
        };
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for UUID related functionality.
     */
    exports.UUID = void 0;
    (function (UUID) {
        /**
         * A function which generates UUID v4 identifiers.
         *
         * @returns A new UUID v4 string.
         *
         * #### Notes
         * This implementation complies with RFC 4122.
         *
         * This uses `Random.getRandomValues()` for random bytes, which in
         * turn will use the underlying `crypto` module of the platform if
         * it is available. The fallback for randomness is `Math.random`.
         */
        UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
    })(exports.UUID || (exports.UUID = {}));

    exports.MimeData = MimeData;
    exports.PromiseDelegate = PromiseDelegate;
    exports.Token = Token;

}));
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/activitymonitor.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/activitymonitor.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ActivityMonitor = void 0;
const signaling_1 = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/**
 * A class that monitors activity on a signal.
 */
class ActivityMonitor {
    /**
     * Construct a new activity monitor.
     */
    constructor(options) {
        this._timer = -1;
        this._timeout = -1;
        this._isDisposed = false;
        this._activityStopped = new signaling_1.Signal(this);
        options.signal.connect(this._onSignalFired, this);
        this._timeout = options.timeout || 1000;
    }
    /**
     * A signal emitted when activity has ceased.
     */
    get activityStopped() {
        return this._activityStopped;
    }
    /**
     * The timeout associated with the monitor, in milliseconds.
     */
    get timeout() {
        return this._timeout;
    }
    set timeout(value) {
        this._timeout = value;
    }
    /**
     * Test whether the monitor has been disposed.
     *
     * #### Notes
     * This is a read-only property.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the activity monitor.
     */
    dispose() {
        if (this._isDisposed) {
            return;
        }
        this._isDisposed = true;
        signaling_1.Signal.clearData(this);
    }
    /**
     * A signal handler for the monitored signal.
     */
    _onSignalFired(sender, args) {
        clearTimeout(this._timer);
        this._sender = sender;
        this._args = args;
        this._timer = setTimeout(() => {
            this._activityStopped.emit({
                sender: this._sender,
                args: this._args
            });
        }, this._timeout);
    }
}
exports.ActivityMonitor = ActivityMonitor;
//# sourceMappingURL=activitymonitor.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/index.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
/**
 * @packageDocumentation
 * @module coreutils
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./activitymonitor */ "./node_modules/@jupyterlab/coreutils/lib/activitymonitor.js"), exports);
__exportStar(__webpack_require__(/*! ./interfaces */ "./node_modules/@jupyterlab/coreutils/lib/interfaces.js"), exports);
__exportStar(__webpack_require__(/*! ./markdowncodeblocks */ "./node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js"), exports);
__exportStar(__webpack_require__(/*! ./pageconfig */ "./node_modules/@jupyterlab/coreutils/lib/pageconfig.js"), exports);
__exportStar(__webpack_require__(/*! ./path */ "./node_modules/@jupyterlab/coreutils/lib/path.js"), exports);
__exportStar(__webpack_require__(/*! ./signal */ "./node_modules/@jupyterlab/coreutils/lib/signal.js"), exports);
__exportStar(__webpack_require__(/*! ./text */ "./node_modules/@jupyterlab/coreutils/lib/text.js"), exports);
__exportStar(__webpack_require__(/*! ./time */ "./node_modules/@jupyterlab/coreutils/lib/time.js"), exports);
__exportStar(__webpack_require__(/*! ./url */ "./node_modules/@jupyterlab/coreutils/lib/url.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/interfaces.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/interfaces.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=interfaces.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/markdowncodeblocks.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MarkdownCodeBlocks = void 0;
/**
 * The namespace for code block functions which help
 * in extract code from markdown text
 */
var MarkdownCodeBlocks;
(function (MarkdownCodeBlocks) {
    MarkdownCodeBlocks.CODE_BLOCK_MARKER = '```';
    const markdownExtensions = [
        '.markdown',
        '.mdown',
        '.mkdn',
        '.md',
        '.mkd',
        '.mdwn',
        '.mdtxt',
        '.mdtext',
        '.text',
        '.txt',
        '.Rmd'
    ];
    class MarkdownCodeBlock {
        constructor(startLine) {
            this.startLine = startLine;
            this.code = '';
            this.endLine = -1;
        }
    }
    MarkdownCodeBlocks.MarkdownCodeBlock = MarkdownCodeBlock;
    /**
     * Check whether the given file extension is a markdown extension
     * @param extension - A file extension
     *
     * @returns true/false depending on whether this is a supported markdown extension
     */
    function isMarkdown(extension) {
        return markdownExtensions.indexOf(extension) > -1;
    }
    MarkdownCodeBlocks.isMarkdown = isMarkdown;
    /**
     * Construct all code snippets from current text
     * (this could be potentially optimized if we can cache and detect differences)
     * @param text - A string to parse codeblocks from
     *
     * @returns An array of MarkdownCodeBlocks.
     */
    function findMarkdownCodeBlocks(text) {
        if (!text || text === '') {
            return [];
        }
        const lines = text.split('\n');
        const codeBlocks = [];
        let currentBlock = null;
        for (let lineIndex = 0; lineIndex < lines.length; lineIndex++) {
            const line = lines[lineIndex];
            const lineContainsMarker = line.indexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER) === 0;
            const constructingBlock = currentBlock != null;
            // Skip this line if it is not part of any code block and doesn't contain a marker.
            if (!lineContainsMarker && !constructingBlock) {
                continue;
            }
            // Check if we are already constructing a code block.
            if (!constructingBlock) {
                // Start constructing a new code block.
                currentBlock = new MarkdownCodeBlock(lineIndex);
                // Check whether this is a single line code block of the form ```a = 10```.
                const firstIndex = line.indexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER);
                const lastIndex = line.lastIndexOf(MarkdownCodeBlocks.CODE_BLOCK_MARKER);
                const isSingleLine = firstIndex !== lastIndex;
                if (isSingleLine) {
                    currentBlock.code = line.substring(firstIndex + MarkdownCodeBlocks.CODE_BLOCK_MARKER.length, lastIndex);
                    currentBlock.endLine = lineIndex;
                    codeBlocks.push(currentBlock);
                    currentBlock = null;
                }
            }
            else if (currentBlock) {
                if (lineContainsMarker) {
                    // End of block, finish it up.
                    currentBlock.endLine = lineIndex - 1;
                    codeBlocks.push(currentBlock);
                    currentBlock = null;
                }
                else {
                    // Append the current line.
                    currentBlock.code += line + '\n';
                }
            }
        }
        return codeBlocks;
    }
    MarkdownCodeBlocks.findMarkdownCodeBlocks = findMarkdownCodeBlocks;
})(MarkdownCodeBlocks = exports.MarkdownCodeBlocks || (exports.MarkdownCodeBlocks = {}));
//# sourceMappingURL=markdowncodeblocks.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/pageconfig.js":
/*!**************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/pageconfig.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PageConfig = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/coreutils/node_modules/@lumino/coreutils/dist/index.js");
const minimist_1 = __importDefault(__webpack_require__(/*! minimist */ "./node_modules/minimist/index.js"));
const url_1 = __webpack_require__(/*! ./url */ "./node_modules/@jupyterlab/coreutils/lib/url.js");
/**
 * The namespace for `PageConfig` functions.
 */
var PageConfig;
(function (PageConfig) {
    /**
     * Get global configuration data for the Jupyter application.
     *
     * @param name - The name of the configuration option.
     *
     * @returns The config value or an empty string if not found.
     *
     * #### Notes
     * All values are treated as strings.
     * For browser based applications, it is assumed that the page HTML
     * includes a script tag with the id `jupyter-config-data` containing the
     * configuration as valid JSON.  In order to support the classic Notebook,
     * we fall back on checking for `body` data of the given `name`.
     *
     * For node applications, it is assumed that the process was launched
     * with a `--jupyter-config-data` option pointing to a JSON settings
     * file.
     */
    function getOption(name) {
        if (configData) {
            return configData[name] || getBodyData(name);
        }
        configData = Object.create(null);
        let found = false;
        // Use script tag if available.
        if (typeof document !== 'undefined' && document) {
            const el = document.getElementById('jupyter-config-data');
            if (el) {
                configData = JSON.parse(el.textContent || '');
                found = true;
            }
        }
        // Otherwise use CLI if given.
        if (!found && "object" !== 'undefined' && ({"cwd":(() => '/')}).argv) {
            try {
                const cli = (0, minimist_1.default)(({"cwd":(() => '/')}).argv.slice(2));
                const path = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
                let fullPath = '';
                if ('jupyter-config-data' in cli) {
                    fullPath = path.resolve(cli['jupyter-config-data']);
                }
                else if ('JUPYTER_CONFIG_DATA' in {}) {
                    fullPath = path.resolve({}['JUPYTER_CONFIG_DATA']);
                }
                if (fullPath) {
                    // Force Webpack to ignore this require.
                    // eslint-disable-next-line
                    configData = eval('require')(fullPath);
                }
            }
            catch (e) {
                console.error(e);
            }
        }
        if (!coreutils_1.JSONExt.isObject(configData)) {
            configData = Object.create(null);
        }
        else {
            for (const key in configData) {
                // PageConfig expects strings
                if (typeof configData[key] !== 'string') {
                    configData[key] = JSON.stringify(configData[key]);
                }
            }
        }
        return configData[name] || getBodyData(name);
    }
    PageConfig.getOption = getOption;
    /**
     * Set global configuration data for the Jupyter application.
     *
     * @param name - The name of the configuration option.
     * @param value - The value to set the option to.
     *
     * @returns The last config value or an empty string if it doesn't exist.
     */
    function setOption(name, value) {
        const last = getOption(name);
        configData[name] = value;
        return last;
    }
    PageConfig.setOption = setOption;
    /**
     * Get the base url for a Jupyter application, or the base url of the page.
     */
    function getBaseUrl() {
        return url_1.URLExt.normalize(getOption('baseUrl') || '/');
    }
    PageConfig.getBaseUrl = getBaseUrl;
    /**
     * Get the tree url for a JupyterLab application.
     */
    function getTreeUrl() {
        return url_1.URLExt.join(getBaseUrl(), getOption('treeUrl'));
    }
    PageConfig.getTreeUrl = getTreeUrl;
    /**
     * Get the base url for sharing links (usually baseUrl)
     */
    function getShareUrl() {
        return url_1.URLExt.normalize(getOption('shareUrl') || getBaseUrl());
    }
    PageConfig.getShareUrl = getShareUrl;
    /**
     * Get the tree url for shareable links.
     * Usually the same as treeUrl,
     * but overrideable e.g. when sharing with JupyterHub.
     */
    function getTreeShareUrl() {
        return url_1.URLExt.normalize(url_1.URLExt.join(getShareUrl(), getOption('treeUrl')));
    }
    PageConfig.getTreeShareUrl = getTreeShareUrl;
    /**
     * Create a new URL given an optional mode and tree path.
     *
     * This is used to create URLS when the mode or tree path change as the user
     * changes mode or the current document in the main area. If fields in
     * options are omitted, the value in PageConfig will be used.
     *
     * @param options - IGetUrlOptions for the new path.
     */
    function getUrl(options) {
        var _a, _b, _c, _d;
        let path = options.toShare ? getShareUrl() : getBaseUrl();
        const mode = (_a = options.mode) !== null && _a !== void 0 ? _a : getOption('mode');
        const workspace = (_b = options.workspace) !== null && _b !== void 0 ? _b : getOption('workspace');
        const labOrDoc = mode === 'single-document' ? 'doc' : 'lab';
        path = url_1.URLExt.join(path, labOrDoc);
        if (workspace !== PageConfig.defaultWorkspace) {
            path = url_1.URLExt.join(path, 'workspaces', encodeURIComponent((_c = getOption('workspace')) !== null && _c !== void 0 ? _c : PageConfig.defaultWorkspace));
        }
        const treePath = (_d = options.treePath) !== null && _d !== void 0 ? _d : getOption('treePath');
        if (treePath) {
            path = url_1.URLExt.join(path, 'tree', url_1.URLExt.encodeParts(treePath));
        }
        return path;
    }
    PageConfig.getUrl = getUrl;
    PageConfig.defaultWorkspace = 'default';
    /**
     * Get the base websocket url for a Jupyter application, or an empty string.
     */
    function getWsUrl(baseUrl) {
        let wsUrl = getOption('wsUrl');
        if (!wsUrl) {
            baseUrl = baseUrl ? url_1.URLExt.normalize(baseUrl) : getBaseUrl();
            if (baseUrl.indexOf('http') !== 0) {
                return '';
            }
            wsUrl = 'ws' + baseUrl.slice(4);
        }
        return url_1.URLExt.normalize(wsUrl);
    }
    PageConfig.getWsUrl = getWsUrl;
    /**
     * Returns the URL converting this notebook to a certain
     * format with nbconvert.
     */
    function getNBConvertURL({ path, format, download }) {
        const notebookPath = url_1.URLExt.encodeParts(path);
        const url = url_1.URLExt.join(getBaseUrl(), 'nbconvert', format, notebookPath);
        if (download) {
            return url + '?download=true';
        }
        return url;
    }
    PageConfig.getNBConvertURL = getNBConvertURL;
    /**
     * Get the authorization token for a Jupyter application.
     */
    function getToken() {
        return getOption('token') || getBodyData('jupyterApiToken');
    }
    PageConfig.getToken = getToken;
    /**
     * Get the Notebook version info [major, minor, patch].
     */
    function getNotebookVersion() {
        const notebookVersion = getOption('notebookVersion');
        if (notebookVersion === '') {
            return [0, 0, 0];
        }
        return JSON.parse(notebookVersion);
    }
    PageConfig.getNotebookVersion = getNotebookVersion;
    /**
     * Private page config data for the Jupyter application.
     */
    let configData = null;
    /**
     * Get a url-encoded item from `body.data` and decode it
     * We should never have any encoded URLs anywhere else in code
     * until we are building an actual request.
     */
    function getBodyData(key) {
        if (typeof document === 'undefined' || !document.body) {
            return '';
        }
        const val = document.body.dataset[key];
        if (typeof val === 'undefined') {
            return '';
        }
        return decodeURIComponent(val);
    }
    /**
     * The namespace for page config `Extension` functions.
     */
    let Extension;
    (function (Extension) {
        /**
         * Populate an array from page config.
         *
         * @param key - The page config key (e.g., `deferredExtensions`).
         *
         * #### Notes
         * This is intended for `deferredExtensions` and `disabledExtensions`.
         */
        function populate(key) {
            try {
                const raw = getOption(key);
                if (raw) {
                    return JSON.parse(raw);
                }
            }
            catch (error) {
                console.warn(`Unable to parse ${key}.`, error);
            }
            return [];
        }
        /**
         * The collection of deferred extensions in page config.
         */
        Extension.deferred = populate('deferredExtensions');
        /**
         * The collection of disabled extensions in page config.
         */
        Extension.disabled = populate('disabledExtensions');
        /**
         * Returns whether a plugin is deferred.
         *
         * @param id - The plugin ID.
         */
        function isDeferred(id) {
            // Check for either a full plugin id match or an extension
            // name match.
            const separatorIndex = id.indexOf(':');
            let extName = '';
            if (separatorIndex !== -1) {
                extName = id.slice(0, separatorIndex);
            }
            return Extension.deferred.some(val => val === id || (extName && val === extName));
        }
        Extension.isDeferred = isDeferred;
        /**
         * Returns whether a plugin is disabled.
         *
         * @param id - The plugin ID.
         */
        function isDisabled(id) {
            // Check for either a full plugin id match or an extension
            // name match.
            const separatorIndex = id.indexOf(':');
            let extName = '';
            if (separatorIndex !== -1) {
                extName = id.slice(0, separatorIndex);
            }
            return Extension.disabled.some(val => val === id || (extName && val === extName));
        }
        Extension.isDisabled = isDisabled;
    })(Extension = PageConfig.Extension || (PageConfig.Extension = {}));
})(PageConfig = exports.PageConfig || (exports.PageConfig = {}));
//# sourceMappingURL=pageconfig.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/path.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/path.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PathExt = void 0;
const path_1 = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
/**
 * The namespace for path-related functions.
 *
 * Note that Jupyter server paths do not start with a leading slash.
 */
var PathExt;
(function (PathExt) {
    /**
     * Join all arguments together and normalize the resulting path.
     * Arguments must be strings. In v0.8, non-string arguments were silently ignored. In v0.10 and up, an exception is thrown.
     *
     * @param paths - The string paths to join.
     */
    function join(...paths) {
        const path = path_1.posix.join(...paths);
        return path === '.' ? '' : removeSlash(path);
    }
    PathExt.join = join;
    /**
     * Return the last portion of a path. Similar to the Unix basename command.
     * Often used to extract the file name from a fully qualified path.
     *
     * @param path - The path to evaluate.
     *
     * @param ext - An extension to remove from the result.
     */
    function basename(path, ext) {
        return path_1.posix.basename(path, ext);
    }
    PathExt.basename = basename;
    /**
     * Get the directory name of a path, similar to the Unix dirname command.
     * When an empty path is given, returns the root path.
     *
     * @param path - The file path.
     */
    function dirname(path) {
        const dir = removeSlash(path_1.posix.dirname(path));
        return dir === '.' ? '' : dir;
    }
    PathExt.dirname = dirname;
    /**
     * Get the extension of the path.
     *
     * @param path - The file path.
     *
     * @returns the extension of the file.
     *
     * #### Notes
     * The extension is the string from the last occurrence of the `.`
     * character to end of string in the last portion of the path, inclusive.
     * If there is no `.` in the last portion of the path, or if the first
     * character of the basename of path [[basename]] is `.`, then an
     * empty string is returned.
     */
    function extname(path) {
        return path_1.posix.extname(path);
    }
    PathExt.extname = extname;
    /**
     * Normalize a string path, reducing '..' and '.' parts.
     * When multiple slashes are found, they're replaced by a single one; when the path contains a trailing slash, it is preserved. On Windows backslashes are used.
     * When an empty path is given, returns the root path.
     *
     * @param path - The string path to normalize.
     */
    function normalize(path) {
        if (path === '') {
            return '';
        }
        return removeSlash(path_1.posix.normalize(path));
    }
    PathExt.normalize = normalize;
    /**
     * Resolve a sequence of paths or path segments into an absolute path.
     * The root path in the application has no leading slash, so it is removed.
     *
     * @param parts - The paths to join.
     *
     * #### Notes
     * The right-most parameter is considered \{to\}.  Other parameters are considered an array of \{from\}.
     *
     * Starting from leftmost \{from\} parameter, resolves \{to\} to an absolute path.
     *
     * If \{to\} isn't already absolute, \{from\} arguments are prepended in right to left order, until an absolute path is found. If after using all \{from\} paths still no absolute path is found, the current working directory is used as well. The resulting path is normalized, and trailing slashes are removed unless the path gets resolved to the root directory.
     */
    function resolve(...parts) {
        return removeSlash(path_1.posix.resolve(...parts));
    }
    PathExt.resolve = resolve;
    /**
     * Solve the relative path from \{from\} to \{to\}.
     *
     * @param from - The source path.
     *
     * @param to - The target path.
     *
     * #### Notes
     * If from and to each resolve to the same path (after calling
     * path.resolve() on each), a zero-length string is returned.
     * If a zero-length string is passed as from or to, `/`
     * will be used instead of the zero-length strings.
     */
    function relative(from, to) {
        return removeSlash(path_1.posix.relative(from, to));
    }
    PathExt.relative = relative;
    /**
     * Normalize a file extension to be of the type `'.foo'`.
     *
     * @param extension - the file extension.
     *
     * #### Notes
     * Adds a leading dot if not present and converts to lower case.
     */
    function normalizeExtension(extension) {
        if (extension.length > 0 && extension.indexOf('.') !== 0) {
            extension = `.${extension}`;
        }
        return extension;
    }
    PathExt.normalizeExtension = normalizeExtension;
    /**
     * Remove the leading slash from a path.
     *
     * @param path: the path from which to remove a leading slash.
     */
    function removeSlash(path) {
        if (path.indexOf('/') === 0) {
            path = path.slice(1);
        }
        return path;
    }
    PathExt.removeSlash = removeSlash;
})(PathExt = exports.PathExt || (exports.PathExt = {}));
//# sourceMappingURL=path.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/signal.js":
/*!**********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/signal.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*
 * Copyright (c) Jupyter Development Team.
 * Distributed under the terms of the Modified BSD License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.signalToPromise = void 0;
const coreutils_1 = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/coreutils/node_modules/@lumino/coreutils/dist/index.js");
/**
 * Convert a signal into a promise for the first emitted value.
 *
 * @param signal - The signal we are listening to.
 * @param timeout - Timeout to wait for signal in ms (not timeout if not defined or 0)
 *
 * @returns a Promise that resolves with a `(sender, args)` pair.
 */
function signalToPromise(signal, timeout) {
    const waitForSignal = new coreutils_1.PromiseDelegate();
    function cleanup() {
        signal.disconnect(slot);
    }
    function slot(sender, args) {
        cleanup();
        waitForSignal.resolve([sender, args]);
    }
    signal.connect(slot);
    if ((timeout !== null && timeout !== void 0 ? timeout : 0) > 0) {
        setTimeout(() => {
            cleanup();
            waitForSignal.reject(`Signal not emitted within ${timeout} ms.`);
        }, timeout);
    }
    return waitForSignal.promise;
}
exports.signalToPromise = signalToPromise;
//# sourceMappingURL=signal.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/text.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/text.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Text = void 0;
/**
 * The namespace for text-related functions.
 */
var Text;
(function (Text) {
    // javascript stores text as utf16 and string indices use "code units",
    // which stores high-codepoint characters as "surrogate pairs",
    // which occupy two indices in the javascript string.
    // We need to translate cursor_pos in the Jupyter protocol (in characters)
    // to js offset (with surrogate pairs taking two spots).
    const HAS_SURROGATES = '𝐚'.length > 1;
    /**
     * Convert a javascript string index into a unicode character offset
     *
     * @param jsIdx - The javascript string index (counting surrogate pairs)
     *
     * @param text - The text in which the offset is calculated
     *
     * @returns The unicode character offset
     */
    function jsIndexToCharIndex(jsIdx, text) {
        if (HAS_SURROGATES) {
            // not using surrogates, nothing to do
            return jsIdx;
        }
        let charIdx = jsIdx;
        for (let i = 0; i + 1 < text.length && i < jsIdx; i++) {
            const charCode = text.charCodeAt(i);
            // check for surrogate pair
            if (charCode >= 0xd800 && charCode <= 0xdbff) {
                const nextCharCode = text.charCodeAt(i + 1);
                if (nextCharCode >= 0xdc00 && nextCharCode <= 0xdfff) {
                    charIdx--;
                    i++;
                }
            }
        }
        return charIdx;
    }
    Text.jsIndexToCharIndex = jsIndexToCharIndex;
    /**
     * Convert a unicode character offset to a javascript string index.
     *
     * @param charIdx - The index in unicode characters
     *
     * @param text - The text in which the offset is calculated
     *
     * @returns The js-native index
     */
    function charIndexToJsIndex(charIdx, text) {
        if (HAS_SURROGATES) {
            // not using surrogates, nothing to do
            return charIdx;
        }
        let jsIdx = charIdx;
        for (let i = 0; i + 1 < text.length && i < jsIdx; i++) {
            const charCode = text.charCodeAt(i);
            // check for surrogate pair
            if (charCode >= 0xd800 && charCode <= 0xdbff) {
                const nextCharCode = text.charCodeAt(i + 1);
                if (nextCharCode >= 0xdc00 && nextCharCode <= 0xdfff) {
                    jsIdx++;
                    i++;
                }
            }
        }
        return jsIdx;
    }
    Text.charIndexToJsIndex = charIndexToJsIndex;
    /**
     * Given a 'snake-case', 'snake_case', 'snake:case', or
     * 'snake case' string, will return the camel case version: 'snakeCase'.
     *
     * @param str: the snake-case input string.
     *
     * @param upper: default = false. If true, the first letter of the
     * returned string will be capitalized.
     *
     * @returns the camel case version of the input string.
     */
    function camelCase(str, upper = false) {
        return str.replace(/^(\w)|[\s-_:]+(\w)/g, function (match, p1, p2) {
            if (p2) {
                return p2.toUpperCase();
            }
            else {
                return upper ? p1.toUpperCase() : p1.toLowerCase();
            }
        });
    }
    Text.camelCase = camelCase;
    /**
     * Given a string, title case the words in the string.
     *
     * @param str: the string to title case.
     *
     * @returns the same string, but with each word capitalized.
     */
    function titleCase(str) {
        return (str || '')
            .toLowerCase()
            .split(' ')
            .map(word => word.charAt(0).toUpperCase() + word.slice(1))
            .join(' ');
    }
    Text.titleCase = titleCase;
})(Text = exports.Text || (exports.Text = {}));
//# sourceMappingURL=text.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/time.js":
/*!********************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/time.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Time = void 0;
/**
 * A list of time units with their associated value in milliseconds.
 */
const UNITS = [
    { name: 'years', milliseconds: 365 * 24 * 60 * 60 * 1000 },
    { name: 'months', milliseconds: 30 * 24 * 60 * 60 * 1000 },
    { name: 'days', milliseconds: 24 * 60 * 60 * 1000 },
    { name: 'hours', milliseconds: 60 * 60 * 1000 },
    { name: 'minutes', milliseconds: 60 * 1000 },
    { name: 'seconds', milliseconds: 1000 }
];
/**
 * The namespace for date functions.
 */
var Time;
(function (Time) {
    /**
     * Convert a timestring to a human readable string (e.g. 'two minutes ago').
     *
     * @param value - The date timestring or date object.
     *
     * @returns A formatted date.
     */
    function formatHuman(value) {
        const lang = document.documentElement.lang || 'en';
        const formatter = new Intl.RelativeTimeFormat(lang, { numeric: 'auto' });
        const delta = new Date(value).getTime() - Date.now();
        for (let unit of UNITS) {
            const amount = Math.ceil(delta / unit.milliseconds);
            if (amount === 0) {
                continue;
            }
            return formatter.format(amount, unit.name);
        }
        return formatter.format(0, 'seconds');
    }
    Time.formatHuman = formatHuman;
    /**
     * Convenient helper to convert a timestring to a date format.
     *
     * @param value - The date timestring or date object.
     *
     * @returns A formatted date.
     */
    function format(value) {
        const lang = document.documentElement.lang || 'en';
        const formatter = new Intl.DateTimeFormat(lang, {
            dateStyle: 'short',
            timeStyle: 'short'
        });
        return formatter.format(new Date(value));
    }
    Time.format = format;
})(Time = exports.Time || (exports.Time = {}));
//# sourceMappingURL=time.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/lib/url.js":
/*!*******************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/lib/url.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.URLExt = void 0;
const path_1 = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js");
const url_parse_1 = __importDefault(__webpack_require__(/*! url-parse */ "./node_modules/url-parse/index.js"));
/**
 * The namespace for URL-related functions.
 */
var URLExt;
(function (URLExt) {
    /**
     * Parse a url into a URL object.
     *
     * @param urlString - The URL string to parse.
     *
     * @returns A URL object.
     */
    function parse(url) {
        if (typeof document !== 'undefined' && document) {
            const a = document.createElement('a');
            a.href = url;
            return a;
        }
        return (0, url_parse_1.default)(url);
    }
    URLExt.parse = parse;
    /**
     * Parse URL and retrieve hostname
     *
     * @param url - The URL string to parse
     *
     * @returns a hostname string value
     */
    function getHostName(url) {
        return (0, url_parse_1.default)(url).hostname;
    }
    URLExt.getHostName = getHostName;
    function normalize(url) {
        return url && parse(url).toString();
    }
    URLExt.normalize = normalize;
    /**
     * Join a sequence of url components and normalizes as in node `path.join`.
     *
     * @param parts - The url components.
     *
     * @returns the joined url.
     */
    function join(...parts) {
        let u = (0, url_parse_1.default)(parts[0], {});
        // Schema-less URL can be only parsed as relative to a base URL
        // see https://github.com/unshiftio/url-parse/issues/219#issuecomment-1002219326
        const isSchemaLess = u.protocol === '' && u.slashes;
        if (isSchemaLess) {
            u = (0, url_parse_1.default)(parts[0], 'https:' + parts[0]);
        }
        const prefix = `${isSchemaLess ? '' : u.protocol}${u.slashes ? '//' : ''}${u.auth}${u.auth ? '@' : ''}${u.host}`;
        // If there was a prefix, then the first path must start at the root.
        const path = path_1.posix.join(`${!!prefix && u.pathname[0] !== '/' ? '/' : ''}${u.pathname}`, ...parts.slice(1));
        return `${prefix}${path === '.' ? '' : path}`;
    }
    URLExt.join = join;
    /**
     * Encode the components of a multi-segment url.
     *
     * @param url - The url to encode.
     *
     * @returns the encoded url.
     *
     * #### Notes
     * Preserves the `'/'` separators.
     * Should not include the base url, since all parts are escaped.
     */
    function encodeParts(url) {
        return join(...url.split('/').map(encodeURIComponent));
    }
    URLExt.encodeParts = encodeParts;
    /**
     * Return a serialized object string suitable for a query.
     *
     * @param object - The source object.
     *
     * @returns an encoded url query.
     *
     * #### Notes
     * Modified version of [stackoverflow](http://stackoverflow.com/a/30707423).
     */
    function objectToQueryString(value) {
        const keys = Object.keys(value).filter(key => key.length > 0);
        if (!keys.length) {
            return '';
        }
        return ('?' +
            keys
                .map(key => {
                const content = encodeURIComponent(String(value[key]));
                return key + (content ? '=' + content : '');
            })
                .join('&'));
    }
    URLExt.objectToQueryString = objectToQueryString;
    /**
     * Return a parsed object that represents the values in a query string.
     */
    function queryStringToObject(value) {
        return value
            .replace(/^\?/, '')
            .split('&')
            .reduce((acc, val) => {
            const [key, value] = val.split('=');
            if (key.length > 0) {
                acc[key] = decodeURIComponent(value || '');
            }
            return acc;
        }, {});
    }
    URLExt.queryStringToObject = queryStringToObject;
    /**
     * Test whether the url is a local url.
     *
     * #### Notes
     * This function returns `false` for any fully qualified url, including
     * `data:`, `file:`, and `//` protocol URLs.
     */
    function isLocal(url) {
        const { protocol } = parse(url);
        return ((!protocol || url.toLowerCase().indexOf(protocol) !== 0) &&
            url.indexOf('/') !== 0);
    }
    URLExt.isLocal = isLocal;
})(URLExt = exports.URLExt || (exports.URLExt = {}));
//# sourceMappingURL=url.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/coreutils/node_modules/@lumino/coreutils/dist/index.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@jupyterlab/coreutils/node_modules/@lumino/coreutils/dist/index.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
     true ? factory(exports) :
    0;
})(this, (function (exports) { 'use strict';

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for JSON-specific functions.
     */
    exports.JSONExt = void 0;
    (function (JSONExt) {
        /**
         * A shared frozen empty JSONObject
         */
        JSONExt.emptyObject = Object.freeze({});
        /**
         * A shared frozen empty JSONArray
         */
        JSONExt.emptyArray = Object.freeze([]);
        /**
         * Test whether a JSON value is a primitive.
         *
         * @param value - The JSON value of interest.
         *
         * @returns `true` if the value is a primitive,`false` otherwise.
         */
        function isPrimitive(value) {
            return (value === null ||
                typeof value === 'boolean' ||
                typeof value === 'number' ||
                typeof value === 'string');
        }
        JSONExt.isPrimitive = isPrimitive;
        function isArray(value) {
            return Array.isArray(value);
        }
        JSONExt.isArray = isArray;
        function isObject(value) {
            return !isPrimitive(value) && !isArray(value);
        }
        JSONExt.isObject = isObject;
        /**
         * Compare two JSON values for deep equality.
         *
         * @param first - The first JSON value of interest.
         *
         * @param second - The second JSON value of interest.
         *
         * @returns `true` if the values are equivalent, `false` otherwise.
         */
        function deepEqual(first, second) {
            // Check referential and primitive equality first.
            if (first === second) {
                return true;
            }
            // If one is a primitive, the `===` check ruled out the other.
            if (isPrimitive(first) || isPrimitive(second)) {
                return false;
            }
            // Test whether they are arrays.
            let a1 = isArray(first);
            let a2 = isArray(second);
            // Bail if the types are different.
            if (a1 !== a2) {
                return false;
            }
            // If they are both arrays, compare them.
            if (a1 && a2) {
                return deepArrayEqual(first, second);
            }
            // At this point, they must both be objects.
            return deepObjectEqual(first, second);
        }
        JSONExt.deepEqual = deepEqual;
        /**
         * Create a deep copy of a JSON value.
         *
         * @param value - The JSON value to copy.
         *
         * @returns A deep copy of the given JSON value.
         */
        function deepCopy(value) {
            // Do nothing for primitive values.
            if (isPrimitive(value)) {
                return value;
            }
            // Deep copy an array.
            if (isArray(value)) {
                return deepArrayCopy(value);
            }
            // Deep copy an object.
            return deepObjectCopy(value);
        }
        JSONExt.deepCopy = deepCopy;
        /**
         * Compare two JSON arrays for deep equality.
         */
        function deepArrayEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Test the arrays for equal length.
            if (first.length !== second.length) {
                return false;
            }
            // Compare the values for equality.
            for (let i = 0, n = first.length; i < n; ++i) {
                if (!deepEqual(first[i], second[i])) {
                    return false;
                }
            }
            // At this point, the arrays are equal.
            return true;
        }
        /**
         * Compare two JSON objects for deep equality.
         */
        function deepObjectEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Check for the first object's keys in the second object.
            for (let key in first) {
                if (first[key] !== undefined && !(key in second)) {
                    return false;
                }
            }
            // Check for the second object's keys in the first object.
            for (let key in second) {
                if (second[key] !== undefined && !(key in first)) {
                    return false;
                }
            }
            // Compare the values for equality.
            for (let key in first) {
                // Get the values.
                let firstValue = first[key];
                let secondValue = second[key];
                // If both are undefined, ignore the key.
                if (firstValue === undefined && secondValue === undefined) {
                    continue;
                }
                // If only one value is undefined, the objects are not equal.
                if (firstValue === undefined || secondValue === undefined) {
                    return false;
                }
                // Compare the values.
                if (!deepEqual(firstValue, secondValue)) {
                    return false;
                }
            }
            // At this point, the objects are equal.
            return true;
        }
        /**
         * Create a deep copy of a JSON array.
         */
        function deepArrayCopy(value) {
            let result = new Array(value.length);
            for (let i = 0, n = value.length; i < n; ++i) {
                result[i] = deepCopy(value[i]);
            }
            return result;
        }
        /**
         * Create a deep copy of a JSON object.
         */
        function deepObjectCopy(value) {
            let result = {};
            for (let key in value) {
                // Ignore undefined values.
                let subvalue = value[key];
                if (subvalue === undefined) {
                    continue;
                }
                result[key] = deepCopy(subvalue);
            }
            return result;
        }
    })(exports.JSONExt || (exports.JSONExt = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * An object which stores MIME data for general application use.
     *
     * #### Notes
     * This class does not attempt to enforce "correctness" of MIME types
     * and their associated data. Since this class is designed to transfer
     * arbitrary data and objects within the same application, it assumes
     * that the user provides correct and accurate data.
     */
    class MimeData {
        constructor() {
            this._types = [];
            this._values = [];
        }
        /**
         * Get an array of the MIME types contained within the dataset.
         *
         * @returns A new array of the MIME types, in order of insertion.
         */
        types() {
            return this._types.slice();
        }
        /**
         * Test whether the dataset has an entry for the given type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns `true` if the dataset contains a value for the given
         *   MIME type, `false` otherwise.
         */
        hasData(mime) {
            return this._types.indexOf(mime) !== -1;
        }
        /**
         * Get the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns The value for the given MIME type, or `undefined` if
         *   the dataset does not contain a value for the type.
         */
        getData(mime) {
            let i = this._types.indexOf(mime);
            return i !== -1 ? this._values[i] : undefined;
        }
        /**
         * Set the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @param data - The data value for the given MIME type.
         *
         * #### Notes
         * This will overwrite any previous entry for the MIME type.
         */
        setData(mime, data) {
            this.clearData(mime);
            this._types.push(mime);
            this._values.push(data);
        }
        /**
         * Remove the data entry for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * #### Notes
         * This is a no-op if there is no entry for the given MIME type.
         */
        clearData(mime) {
            let i = this._types.indexOf(mime);
            if (i !== -1) {
                this._types.splice(i, 1);
                this._values.splice(i, 1);
            }
        }
        /**
         * Remove all data entries from the dataset.
         */
        clear() {
            this._types.length = 0;
            this._values.length = 0;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A class which wraps a promise into a delegate object.
     *
     * #### Notes
     * This class is useful when the logic to resolve or reject a promise
     * cannot be defined at the point where the promise is created.
     */
    class PromiseDelegate {
        /**
         * Construct a new promise delegate.
         */
        constructor() {
            this.promise = new Promise((resolve, reject) => {
                this._resolve = resolve;
                this._reject = reject;
            });
        }
        /**
         * Resolve the wrapped promise with the given value.
         *
         * @param value - The value to use for resolving the promise.
         */
        resolve(value) {
            let resolve = this._resolve;
            resolve(value);
        }
        /**
         * Reject the wrapped promise with the given value.
         *
         * @reason - The reason for rejecting the promise.
         */
        reject(reason) {
            let reject = this._reject;
            reject(reason);
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A runtime object which captures compile-time type information.
     *
     * #### Notes
     * A token captures the compile-time type of an interface or class in
     * an object which can be used at runtime in a type-safe fashion.
     */
    class Token {
        /**
         * Construct a new token.
         *
         * @param name - A human readable name for the token.
         * @param description - Token purpose description for documentation.
         */
        constructor(name, description) {
            this.name = name;
            this.description = description !== null && description !== void 0 ? description : '';
            this._tokenStructuralPropertyT = null;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    // Fallback
    function fallbackRandomValues(buffer) {
        let value = 0;
        for (let i = 0, n = buffer.length; i < n; ++i) {
            if (i % 4 === 0) {
                value = (Math.random() * 0xffffffff) >>> 0;
            }
            buffer[i] = value & 0xff;
            value >>>= 8;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for random number related functionality.
     */
    exports.Random = void 0;
    (function (Random) {
        /**
         * A function which generates random bytes.
         *
         * @param buffer - The `Uint8Array` to fill with random bytes.
         *
         * #### Notes
         * A cryptographically strong random number generator will be used if
         * available. Otherwise, `Math.random` will be used as a fallback for
         * randomness.
         *
         * The following RNGs are supported, listed in order of precedence:
         *   - `window.crypto.getRandomValues`
         *   - `window.msCrypto.getRandomValues`
         *   - `require('crypto').randomFillSync
         *   - `require('crypto').randomBytes
         *   - `Math.random`
         */
        Random.getRandomValues = (() => {
            // Look up the crypto module if available.
            const crypto = (typeof window !== 'undefined' && (window.crypto || window.msCrypto)) ||
                null;
            // Modern browsers and IE 11
            if (crypto && typeof crypto.getRandomValues === 'function') {
                return function getRandomValues(buffer) {
                    return crypto.getRandomValues(buffer);
                };
            }
            // Fallback
            return fallbackRandomValues;
        })();
    })(exports.Random || (exports.Random = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A function which creates a function that generates UUID v4 identifiers.
     *
     * @returns A new function that creates a UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    function uuid4Factory(getRandomValues) {
        // Create a 16 byte array to hold the random values.
        const bytes = new Uint8Array(16);
        // Create a look up table from bytes to hex strings.
        const lut = new Array(256);
        // Pad the single character hex digits with a leading zero.
        for (let i = 0; i < 16; ++i) {
            lut[i] = '0' + i.toString(16);
        }
        // Populate the rest of the hex digits.
        for (let i = 16; i < 256; ++i) {
            lut[i] = i.toString(16);
        }
        // Return a function which generates the UUID.
        return function uuid4() {
            // Get a new batch of random values.
            getRandomValues(bytes);
            // Set the UUID version number to 4.
            bytes[6] = 0x40 | (bytes[6] & 0x0f);
            // Set the clock sequence bit to the RFC spec.
            bytes[8] = 0x80 | (bytes[8] & 0x3f);
            // Assemble the UUID string.
            return (lut[bytes[0]] +
                lut[bytes[1]] +
                lut[bytes[2]] +
                lut[bytes[3]] +
                '-' +
                lut[bytes[4]] +
                lut[bytes[5]] +
                '-' +
                lut[bytes[6]] +
                lut[bytes[7]] +
                '-' +
                lut[bytes[8]] +
                lut[bytes[9]] +
                '-' +
                lut[bytes[10]] +
                lut[bytes[11]] +
                lut[bytes[12]] +
                lut[bytes[13]] +
                lut[bytes[14]] +
                lut[bytes[15]]);
        };
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for UUID related functionality.
     */
    exports.UUID = void 0;
    (function (UUID) {
        /**
         * A function which generates UUID v4 identifiers.
         *
         * @returns A new UUID v4 string.
         *
         * #### Notes
         * This implementation complies with RFC 4122.
         *
         * This uses `Random.getRandomValues()` for random bytes, which in
         * turn will use the underlying `crypto` module of the platform if
         * it is available. The fallback for randomness is `Math.random`.
         */
        UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
    })(exports.UUID || (exports.UUID = {}));

    exports.MimeData = MimeData;
    exports.PromiseDelegate = PromiseDelegate;
    exports.Token = Token;

}));
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@jupyterlab/docmanager/lib/dialogs.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/docmanager/lib/dialogs.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValidFileName: () => (/* binding */ isValidFileName),
/* harmony export */   renameDialog: () => (/* binding */ renameDialog),
/* harmony export */   renameFile: () => (/* binding */ renameFile),
/* harmony export */   shouldOverwrite: () => (/* binding */ shouldOverwrite)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/apputils */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.




/**
 * The class name added to file dialogs.
 */
const FILE_DIALOG_CLASS = 'jp-FileDialog';
/**
 * The class name added for the new name label in the rename dialog
 */
const RENAME_NEW_NAME_TITLE_CLASS = 'jp-new-name-title';
/**
 * Rename a file with a dialog.
 */
function renameDialog(manager, context, translator) {
    translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
    const trans = translator.load('jupyterlab');
    const localPath = context.localPath.split('/');
    const fileName = localPath.pop() || context.localPath;
    return (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.showDialog)({
        title: trans.__('Rename File'),
        body: new RenameHandler(fileName),
        focusNodeSelector: 'input',
        buttons: [
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.cancelButton(),
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.okButton({
                label: trans.__('Rename'),
                ariaLabel: trans.__('Rename File')
            })
        ]
    }).then(result => {
        if (!result.value) {
            return null;
        }
        if (!isValidFileName(result.value)) {
            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.showErrorMessage)(trans.__('Rename Error'), Error(trans.__('"%1" is not a valid name for a file. Names must have nonzero length, and cannot include "/", "\\", or ":"', result.value)));
            return null;
        }
        return context.rename(result.value);
    });
}
/**
 * Rename a file, asking for confirmation if it is overwriting another.
 */
function renameFile(manager, oldPath, newPath) {
    return manager.rename(oldPath, newPath).catch(error => {
        if (error.response.status !== 409) {
            // if it's not caused by an already existing file, rethrow
            throw error;
        }
        // otherwise, ask for confirmation
        return shouldOverwrite(newPath).then((value) => {
            if (value) {
                return manager.overwrite(oldPath, newPath);
            }
            return Promise.reject('File not renamed');
        });
    });
}
/**
 * Ask the user whether to overwrite a file.
 */
function shouldOverwrite(path, translator) {
    translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
    const trans = translator.load('jupyterlab');
    const options = {
        title: trans.__('Overwrite file?'),
        body: trans.__('"%1" already exists, overwrite?', path),
        buttons: [
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.cancelButton(),
            _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.Dialog.warnButton({
                label: trans.__('Overwrite'),
                ariaLabel: trans.__('Overwrite Existing File')
            })
        ]
    };
    return (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_2__.showDialog)(options).then(result => {
        return Promise.resolve(result.button.accept);
    });
}
/**
 * Test whether a name is a valid file name
 *
 * Disallows "/", "\", and ":" in file names, as well as names with zero length.
 */
function isValidFileName(name) {
    const validNameExp = /[\/\\:]/;
    return name.length > 0 && !validNameExp.test(name);
}
/**
 * A widget used to rename a file.
 */
class RenameHandler extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget {
    /**
     * Construct a new "rename" dialog.
     */
    constructor(oldPath) {
        super({ node: Private.createRenameNode(oldPath) });
        this.addClass(FILE_DIALOG_CLASS);
        const ext = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.PathExt.extname(oldPath);
        const value = (this.inputNode.value = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_3__.PathExt.basename(oldPath));
        this.inputNode.setSelectionRange(0, value.length - ext.length);
    }
    /**
     * Get the input text node.
     */
    get inputNode() {
        return this.node.getElementsByTagName('input')[0];
    }
    /**
     * Get the value of the widget.
     */
    getValue() {
        return this.inputNode.value;
    }
}
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * Create the node for a rename handler.
     */
    function createRenameNode(oldPath, translator) {
        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        const body = document.createElement('div');
        const existingLabel = document.createElement('label');
        existingLabel.textContent = trans.__('File Path');
        const existingPath = document.createElement('span');
        existingPath.textContent = oldPath;
        const nameTitle = document.createElement('label');
        nameTitle.textContent = trans.__('New Name');
        nameTitle.className = RENAME_NEW_NAME_TITLE_CLASS;
        const name = document.createElement('input');
        body.appendChild(existingLabel);
        body.appendChild(existingPath);
        body.appendChild(nameTitle);
        body.appendChild(name);
        return body;
    }
    Private.createRenameNode = createRenameNode;
})(Private || (Private = {}));
//# sourceMappingURL=dialogs.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/docmanager/lib/manager.js":
/*!************************************************************!*\
  !*** ./node_modules/@jupyterlab/docmanager/lib/manager.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DocumentManager: () => (/* binding */ DocumentManager)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/apputils */ "./node_modules/@jupyterlab/apputils/lib/sessioncontext.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @jupyterlab/docregistry */ "./node_modules/@jupyterlab/docregistry/lib/context.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/docmanager/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/properties */ "./node_modules/@lumino/properties/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _savehandler__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./savehandler */ "./node_modules/@jupyterlab/docmanager/lib/savehandler.js");
/* harmony import */ var _widgetmanager__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./widgetmanager */ "./node_modules/@jupyterlab/docmanager/lib/widgetmanager.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.










/**
 * The document manager.
 *
 * #### Notes
 * The document manager is used to register model and widget creators,
 * and the file browser uses the document manager to create widgets. The
 * document manager maintains a context for each path and model type that is
 * open, and a list of widgets for each context. The document manager is in
 * control of the proper closing and disposal of the widgets and contexts.
 */
class DocumentManager {
    /**
     * Construct a new document manager.
     */
    constructor(options) {
        var _a;
        this._activateRequested = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);
        this._contexts = [];
        this._isDisposed = false;
        this._autosave = true;
        this._autosaveInterval = 120;
        this._lastModifiedCheckMargin = 500;
        this._renameUntitledFileOnSave = true;
        this._stateChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal(this);
        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        this.registry = options.registry;
        this.services = options.manager;
        this._dialogs =
            (_a = options.sessionDialogs) !== null && _a !== void 0 ? _a : new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_5__.SessionContextDialogs({ translator: options.translator });
        this._isConnectedCallback = options.isConnectedCallback || (() => true);
        this._opener = options.opener;
        this._when = options.when || options.manager.ready;
        const widgetManager = new _widgetmanager__WEBPACK_IMPORTED_MODULE_6__.DocumentWidgetManager({
            registry: this.registry,
            translator: this.translator
        });
        widgetManager.activateRequested.connect(this._onActivateRequested, this);
        widgetManager.stateChanged.connect(this._onWidgetStateChanged, this);
        this._widgetManager = widgetManager;
        this._setBusy = options.setBusy;
    }
    /**
     * A signal emitted when one of the documents is activated.
     */
    get activateRequested() {
        return this._activateRequested;
    }
    /**
     * Whether to autosave documents.
     */
    get autosave() {
        return this._autosave;
    }
    set autosave(value) {
        if (this._autosave !== value) {
            const oldValue = this._autosave;
            this._autosave = value;
            // For each existing context, start/stop the autosave handler as needed.
            this._contexts.forEach(context => {
                const handler = Private.saveHandlerProperty.get(context);
                if (!handler) {
                    return;
                }
                if (value === true && !handler.isActive) {
                    handler.start();
                }
                else if (value === false && handler.isActive) {
                    handler.stop();
                }
            });
            this._stateChanged.emit({
                name: 'autosave',
                oldValue,
                newValue: value
            });
        }
    }
    /**
     * Determines the time interval for autosave in seconds.
     */
    get autosaveInterval() {
        return this._autosaveInterval;
    }
    set autosaveInterval(value) {
        if (this._autosaveInterval !== value) {
            const oldValue = this._autosaveInterval;
            this._autosaveInterval = value;
            // For each existing context, set the save interval as needed.
            this._contexts.forEach(context => {
                const handler = Private.saveHandlerProperty.get(context);
                if (!handler) {
                    return;
                }
                handler.saveInterval = value || 120;
            });
            this._stateChanged.emit({
                name: 'autosaveInterval',
                oldValue,
                newValue: value
            });
        }
    }
    /**
     * Whether to ask confirmation to close a tab or not.
     */
    get confirmClosingDocument() {
        return this._widgetManager.confirmClosingDocument;
    }
    set confirmClosingDocument(value) {
        if (this._widgetManager.confirmClosingDocument !== value) {
            const oldValue = this._widgetManager.confirmClosingDocument;
            this._widgetManager.confirmClosingDocument = value;
            this._stateChanged.emit({
                name: 'confirmClosingDocument',
                oldValue,
                newValue: value
            });
        }
    }
    /**
     * Defines max acceptable difference, in milliseconds, between last modified timestamps on disk and client
     */
    get lastModifiedCheckMargin() {
        return this._lastModifiedCheckMargin;
    }
    set lastModifiedCheckMargin(value) {
        if (this._lastModifiedCheckMargin !== value) {
            const oldValue = this._lastModifiedCheckMargin;
            this._lastModifiedCheckMargin = value;
            // For each existing context, update the margin value.
            this._contexts.forEach(context => {
                context.lastModifiedCheckMargin = value;
            });
            this._stateChanged.emit({
                name: 'lastModifiedCheckMargin',
                oldValue,
                newValue: value
            });
        }
    }
    /**
     * Whether to ask the user to rename untitled file on first manual save.
     */
    get renameUntitledFileOnSave() {
        return this._renameUntitledFileOnSave;
    }
    set renameUntitledFileOnSave(value) {
        if (this._renameUntitledFileOnSave !== value) {
            const oldValue = this._renameUntitledFileOnSave;
            this._renameUntitledFileOnSave = value;
            this._stateChanged.emit({
                name: 'renameUntitledFileOnSave',
                oldValue,
                newValue: value
            });
        }
    }
    /**
     * Signal triggered when an attribute changes.
     */
    get stateChanged() {
        return this._stateChanged;
    }
    /**
     * Get whether the document manager has been disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the document manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        // Clear any listeners for our signals.
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_4__.Signal.clearData(this);
        // Close all the widgets for our contexts and dispose the widget manager.
        this._contexts.forEach(context => {
            return this._widgetManager.closeWidgets(context);
        });
        this._widgetManager.dispose();
        // Clear the context list.
        this._contexts.length = 0;
    }
    /**
     * Clone a widget.
     *
     * @param widget - The source widget.
     *
     * @returns A new widget or `undefined`.
     *
     * #### Notes
     *  Uses the same widget factory and context as the source, or returns
     *  `undefined` if the source widget is not managed by this manager.
     */
    cloneWidget(widget) {
        return this._widgetManager.cloneWidget(widget);
    }
    /**
     * Close all of the open documents.
     *
     * @returns A promise resolving when the widgets are closed.
     */
    closeAll() {
        return Promise.all(this._contexts.map(context => this._widgetManager.closeWidgets(context))).then(() => undefined);
    }
    /**
     * Close the widgets associated with a given path.
     *
     * @param path - The target path.
     *
     * @returns A promise resolving when the widgets are closed.
     */
    closeFile(path) {
        const close = this._contextsForPath(path).map(c => this._widgetManager.closeWidgets(c));
        return Promise.all(close).then(x => undefined);
    }
    /**
     * Get the document context for a widget.
     *
     * @param widget - The widget of interest.
     *
     * @returns The context associated with the widget, or `undefined` if no such
     * context exists.
     */
    contextForWidget(widget) {
        return this._widgetManager.contextForWidget(widget);
    }
    /**
     * Copy a file.
     *
     * @param fromFile - The full path of the original file.
     *
     * @param toDir - The full path to the target directory.
     *
     * @returns A promise which resolves to the contents of the file.
     */
    copy(fromFile, toDir) {
        return this.services.contents.copy(fromFile, toDir);
    }
    /**
     * Create a new file and return the widget used to view it.
     *
     * @param path - The file path to create.
     *
     * @param widgetName - The name of the widget factory to use. 'default' will use the default widget.
     *
     * @param kernel - An optional kernel name/id to override the default.
     *
     * @returns The created widget, or `undefined`.
     *
     * #### Notes
     * This function will return `undefined` if a valid widget factory
     * cannot be found.
     */
    createNew(path, widgetName = 'default', kernel) {
        return this._createOrOpenDocument('create', path, widgetName, kernel);
    }
    /**
     * Delete a file.
     *
     * @param path - The full path to the file to be deleted.
     *
     * @returns A promise which resolves when the file is deleted.
     *
     * #### Notes
     * If there is a running session associated with the file and no other
     * sessions are using the kernel, the session will be shut down.
     */
    deleteFile(path) {
        return this.services.sessions
            .stopIfNeeded(path)
            .then(() => {
            return this.services.contents.delete(path);
        })
            .then(() => {
            this._contextsForPath(path).forEach(context => this._widgetManager.deleteWidgets(context));
            return Promise.resolve(void 0);
        });
    }
    /**
     * Duplicate a file.
     *
     * @param path - The full path to the file to be duplicated.
     *
     * @returns A promise which resolves when the file is duplicated.
     */
    duplicate(path) {
        const basePath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_7__.PathExt.dirname(path);
        return this.services.contents.copy(path, basePath);
    }
    /**
     * See if a widget already exists for the given path and widget name.
     *
     * @param path - The file path to use.
     *
     * @param widgetName - The name of the widget factory to use. 'default' will use the default widget.
     *
     * @returns The found widget, or `undefined`.
     *
     * #### Notes
     * This can be used to find an existing widget instead of opening
     * a new widget.
     */
    findWidget(path, widgetName = 'default') {
        const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_7__.PathExt.normalize(path);
        let widgetNames = [widgetName];
        if (widgetName === 'default') {
            const factory = this.registry.defaultWidgetFactory(newPath);
            if (!factory) {
                return undefined;
            }
            widgetNames = [factory.name];
        }
        else if (widgetName === null) {
            widgetNames = this.registry
                .preferredWidgetFactories(newPath)
                .map(f => f.name);
        }
        for (const context of this._contextsForPath(newPath)) {
            for (const widgetName of widgetNames) {
                if (widgetName !== null) {
                    const widget = this._widgetManager.findWidget(context, widgetName);
                    if (widget) {
                        return widget;
                    }
                }
            }
        }
        return undefined;
    }
    /**
     * Create a new untitled file.
     *
     * @param options - The file content creation options.
     */
    newUntitled(options) {
        if (options.type === 'file') {
            options.ext = options.ext || '.txt';
        }
        return this.services.contents.newUntitled(options);
    }
    /**
     * Open a file and return the widget used to view it.
     *
     * @param path - The file path to open.
     *
     * @param widgetName - The name of the widget factory to use. 'default' will use the default widget.
     *
     * @param kernel - An optional kernel name/id to override the default.
     *
     * @returns The created widget, or `undefined`.
     *
     * #### Notes
     * This function will return `undefined` if a valid widget factory
     * cannot be found.
     */
    open(path, widgetName = 'default', kernel, options) {
        return this._createOrOpenDocument('open', path, widgetName, kernel, options);
    }
    /**
     * Open a file and return the widget used to view it.
     * Reveals an already existing editor.
     *
     * @param path - The file path to open.
     *
     * @param widgetName - The name of the widget factory to use. 'default' will use the default widget.
     *
     * @param kernel - An optional kernel name/id to override the default.
     *
     * @returns The created widget, or `undefined`.
     *
     * #### Notes
     * This function will return `undefined` if a valid widget factory
     * cannot be found.
     */
    openOrReveal(path, widgetName = 'default', kernel, options) {
        const widget = this.findWidget(path, widgetName);
        if (widget) {
            this._opener.open(widget, {
                type: widgetName,
                ...options
            });
            return widget;
        }
        return this.open(path, widgetName, kernel, options !== null && options !== void 0 ? options : {});
    }
    /**
     * Overwrite a file.
     *
     * @param oldPath - The full path to the original file.
     *
     * @param newPath - The full path to the new file.
     *
     * @returns A promise containing the new file contents model.
     */
    overwrite(oldPath, newPath) {
        // Cleanly overwrite the file by moving it, making sure the original does
        // not exist, and then renaming to the new path.
        const tempPath = `${newPath}.${_lumino_coreutils__WEBPACK_IMPORTED_MODULE_2__.UUID.uuid4()}`;
        const cb = () => this.rename(tempPath, newPath);
        return this.rename(oldPath, tempPath)
            .then(() => {
            return this.deleteFile(newPath);
        })
            .then(cb, cb);
    }
    /**
     * Rename a file or directory.
     *
     * @param oldPath - The full path to the original file.
     *
     * @param newPath - The full path to the new file.
     *
     * @returns A promise containing the new file contents model.  The promise
     * will reject if the newPath already exists.  Use [[overwrite]] to overwrite
     * a file.
     */
    rename(oldPath, newPath) {
        return this.services.contents.rename(oldPath, newPath);
    }
    /**
     * Find a context for a given path and factory name.
     */
    _findContext(path, factoryName) {
        const normalizedPath = this.services.contents.normalize(path);
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.find)(this._contexts, context => {
            return (context.path === normalizedPath && context.factoryName === factoryName);
        });
    }
    /**
     * Get the contexts for a given path.
     *
     * #### Notes
     * There may be more than one context for a given path if the path is open
     * with multiple model factories (for example, a notebook can be open with a
     * notebook model factory and a text model factory).
     */
    _contextsForPath(path) {
        const normalizedPath = this.services.contents.normalize(path);
        return this._contexts.filter(context => context.path === normalizedPath);
    }
    /**
     * Create a context from a path and a model factory.
     */
    _createContext(path, factory, kernelPreference) {
        // TODO: Make it impossible to open two different contexts for the same
        // path. Or at least prompt the closing of all widgets associated with the
        // old context before opening the new context. This will make things much
        // more consistent for the users, at the cost of some confusion about what
        // models are and why sometimes they cannot open the same file in different
        // widgets that have different models.
        // Allow options to be passed when adding a sibling.
        const adopter = (widget, options) => {
            this._widgetManager.adoptWidget(context, widget);
            // TODO should we pass the type for layout customization
            this._opener.open(widget, options);
        };
        const context = new _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_8__.Context({
            opener: adopter,
            manager: this.services,
            factory,
            path,
            kernelPreference,
            setBusy: this._setBusy,
            sessionDialogs: this._dialogs,
            lastModifiedCheckMargin: this._lastModifiedCheckMargin,
            translator: this.translator
        });
        const handler = new _savehandler__WEBPACK_IMPORTED_MODULE_9__.SaveHandler({
            context,
            isConnectedCallback: this._isConnectedCallback,
            saveInterval: this.autosaveInterval
        });
        Private.saveHandlerProperty.set(context, handler);
        void context.ready.then(() => {
            if (this.autosave) {
                handler.start();
            }
        });
        context.disposed.connect(this._onContextDisposed, this);
        this._contexts.push(context);
        return context;
    }
    /**
     * Handle a context disposal.
     */
    _onContextDisposed(context) {
        _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.ArrayExt.removeFirstOf(this._contexts, context);
    }
    /**
     * Get the widget factory for a given widget name.
     */
    _widgetFactoryFor(path, widgetName) {
        const { registry } = this;
        if (widgetName === 'default') {
            const factory = registry.defaultWidgetFactory(path);
            if (!factory) {
                return undefined;
            }
            widgetName = factory.name;
        }
        return registry.getWidgetFactory(widgetName);
    }
    /**
     * Creates a new document, or loads one from disk, depending on the `which` argument.
     * If `which==='create'`, then it creates a new document. If `which==='open'`,
     * then it loads the document from disk.
     *
     * The two cases differ in how the document context is handled, but the creation
     * of the widget and launching of the kernel are identical.
     */
    _createOrOpenDocument(which, path, widgetName = 'default', kernel, options) {
        const widgetFactory = this._widgetFactoryFor(path, widgetName);
        if (!widgetFactory) {
            return undefined;
        }
        const modelName = widgetFactory.modelName || 'text';
        const factory = this.registry.getModelFactory(modelName);
        if (!factory) {
            return undefined;
        }
        // Handle the kernel preference.
        const preference = this.registry.getKernelPreference(path, widgetFactory.name, kernel);
        let context;
        let ready = Promise.resolve(undefined);
        // Handle the load-from-disk case
        if (which === 'open') {
            // Use an existing context if available.
            context = this._findContext(path, factory.name) || null;
            if (!context) {
                context = this._createContext(path, factory, preference);
                // Populate the model, either from disk or a
                // model backend.
                ready = this._when.then(() => context.initialize(false));
            }
        }
        else if (which === 'create') {
            context = this._createContext(path, factory, preference);
            // Immediately save the contents to disk.
            ready = this._when.then(() => context.initialize(true));
        }
        else {
            throw new Error(`Invalid argument 'which': ${which}`);
        }
        const widget = this._widgetManager.createWidget(widgetFactory, context);
        this._opener.open(widget, { type: widgetFactory.name, ...options });
        // If the initial opening of the context fails, dispose of the widget.
        ready.catch(err => {
            console.error(`Failed to initialize the context with '${factory.name}' for ${path}`, err);
            widget.close();
        });
        return widget;
    }
    /**
     * Handle an activateRequested signal from the widget manager.
     */
    _onActivateRequested(sender, args) {
        this._activateRequested.emit(args);
    }
    _onWidgetStateChanged(sender, args) {
        if (args.name === 'confirmClosingDocument') {
            this._stateChanged.emit(args);
        }
    }
}
/**
 * A namespace for private data.
 */
var Private;
(function (Private) {
    /**
     * An attached property for a context save handler.
     */
    Private.saveHandlerProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_3__.AttachedProperty({
        name: 'saveHandler',
        create: () => undefined
    });
})(Private || (Private = {}));
//# sourceMappingURL=manager.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/docmanager/lib/savehandler.js":
/*!****************************************************************!*\
  !*** ./node_modules/@jupyterlab/docmanager/lib/savehandler.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SaveHandler: () => (/* binding */ SaveHandler)
/* harmony export */ });
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * A class that manages the auto saving of a document.
 *
 * #### Notes
 * Implements https://github.com/ipython/ipython/wiki/IPEP-15:-Autosaving-the-IPython-Notebook.
 */
class SaveHandler {
    /**
     * Construct a new save handler.
     */
    constructor(options) {
        this._autosaveTimer = -1;
        this._minInterval = -1;
        this._interval = -1;
        this._isActive = false;
        this._inDialog = false;
        this._isDisposed = false;
        this._multiplier = 10;
        this._context = options.context;
        this._isConnectedCallback = options.isConnectedCallback || (() => true);
        const interval = options.saveInterval || 120;
        this._minInterval = interval * 1000;
        this._interval = this._minInterval;
        // Restart the timer when the contents model is updated.
        this._context.fileChanged.connect(this._setTimer, this);
        this._context.disposed.connect(this.dispose, this);
    }
    /**
     * The save interval used by the timer (in seconds).
     */
    get saveInterval() {
        return this._interval / 1000;
    }
    set saveInterval(value) {
        this._minInterval = this._interval = value * 1000;
        if (this._isActive) {
            this._setTimer();
        }
    }
    /**
     * Get whether the handler is active.
     */
    get isActive() {
        return this._isActive;
    }
    /**
     * Get whether the save handler is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the save handler.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        clearTimeout(this._autosaveTimer);
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_0__.Signal.clearData(this);
    }
    /**
     * Start the autosaver.
     */
    start() {
        this._isActive = true;
        this._setTimer();
    }
    /**
     * Stop the autosaver.
     */
    stop() {
        this._isActive = false;
        clearTimeout(this._autosaveTimer);
    }
    /**
     * Set the timer.
     */
    _setTimer() {
        clearTimeout(this._autosaveTimer);
        if (!this._isActive) {
            return;
        }
        this._autosaveTimer = window.setTimeout(() => {
            if (this._isConnectedCallback()) {
                this._save();
            }
        }, this._interval);
    }
    /**
     * Handle an autosave timeout.
     */
    _save() {
        const context = this._context;
        // Trigger the next update.
        this._setTimer();
        if (!context) {
            return;
        }
        // Bail if the model is not dirty or the file is not writable, or the dialog
        // is already showing.
        const writable = context.contentsModel && context.contentsModel.writable;
        if (!writable || !context.model.dirty || this._inDialog) {
            return;
        }
        const start = new Date().getTime();
        context
            .save()
            .then(() => {
            if (this.isDisposed) {
                return;
            }
            const duration = new Date().getTime() - start;
            // New save interval: higher of 10x save duration or min interval.
            this._interval = Math.max(this._multiplier * duration, this._minInterval);
            // Restart the update to pick up the new interval.
            this._setTimer();
        })
            .catch(err => {
            // If the user canceled the save, do nothing.
            const { name } = err;
            if (name === 'ModalCancelError' || name === 'ModalDuplicateError') {
                return;
            }
            // Otherwise, log the error.
            console.error('Error in Auto-Save', err.message);
        });
    }
}
//# sourceMappingURL=savehandler.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/docmanager/lib/widgetmanager.js":
/*!******************************************************************!*\
  !*** ./node_modules/@jupyterlab/docmanager/lib/widgetmanager.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DocumentWidgetManager: () => (/* binding */ DocumentWidgetManager)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/apputils */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/algorithm */ "./node_modules/@lumino/algorithm/dist/index.es6.js");
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/disposable */ "./node_modules/@lumino/disposable/dist/index.es6.js");
/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/messaging */ "./node_modules/@lumino/messaging/dist/index.es6.js");
/* harmony import */ var _lumino_properties__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/properties */ "./node_modules/@lumino/properties/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * The class name added to document widgets.
 */
const DOCUMENT_CLASS = 'jp-Document';
/**
 * A class that maintains the lifecycle of file-backed widgets.
 */
class DocumentWidgetManager {
    /**
     * Construct a new document widget manager.
     */
    constructor(options) {
        this._activateRequested = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__.Signal(this);
        this._confirmClosingTab = false;
        this._isDisposed = false;
        this._stateChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__.Signal(this);
        this._registry = options.registry;
        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
    }
    /**
     * A signal emitted when one of the documents is activated.
     */
    get activateRequested() {
        return this._activateRequested;
    }
    /**
     * Whether to ask confirmation to close a tab or not.
     */
    get confirmClosingDocument() {
        return this._confirmClosingTab;
    }
    set confirmClosingDocument(v) {
        if (this._confirmClosingTab !== v) {
            const oldValue = this._confirmClosingTab;
            this._confirmClosingTab = v;
            this._stateChanged.emit({
                name: 'confirmClosingDocument',
                oldValue,
                newValue: v
            });
        }
    }
    /**
     * Signal triggered when an attribute changes.
     */
    get stateChanged() {
        return this._stateChanged;
    }
    /**
     * Test whether the document widget manager is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources used by the widget manager.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_5__.Signal.disconnectReceiver(this);
    }
    /**
     * Create a widget for a document and handle its lifecycle.
     *
     * @param factory - The widget factory.
     *
     * @param context - The document context object.
     *
     * @returns A widget created by the factory.
     *
     * @throws If the factory is not registered.
     */
    createWidget(factory, context) {
        const widget = factory.createNew(context);
        this._initializeWidget(widget, factory, context);
        return widget;
    }
    /**
     * When a new widget is created, we need to hook it up
     * with some signals, update the widget extensions (for
     * this kind of widget) in the docregistry, among
     * other things.
     */
    _initializeWidget(widget, factory, context) {
        Private.factoryProperty.set(widget, factory);
        // Handle widget extensions.
        const disposables = new _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__.DisposableSet();
        for (const extender of this._registry.widgetExtensions(factory.name)) {
            const disposable = extender.createNew(widget, context);
            if (disposable) {
                disposables.add(disposable);
            }
        }
        Private.disposablesProperty.set(widget, disposables);
        widget.disposed.connect(this._onWidgetDisposed, this);
        this.adoptWidget(context, widget);
        context.fileChanged.connect(this._onFileChanged, this);
        context.pathChanged.connect(this._onPathChanged, this);
        void context.ready.then(() => {
            void this.setCaption(widget);
        });
    }
    /**
     * Install the message hook for the widget and add to list
     * of known widgets.
     *
     * @param context - The document context object.
     *
     * @param widget - The widget to adopt.
     */
    adoptWidget(context, widget) {
        const widgets = Private.widgetsProperty.get(context);
        widgets.push(widget);
        _lumino_messaging__WEBPACK_IMPORTED_MODULE_3__.MessageLoop.installMessageHook(widget, this);
        widget.addClass(DOCUMENT_CLASS);
        widget.title.closable = true;
        widget.disposed.connect(this._widgetDisposed, this);
        Private.contextProperty.set(widget, context);
    }
    /**
     * See if a widget already exists for the given context and widget name.
     *
     * @param context - The document context object.
     *
     * @returns The found widget, or `undefined`.
     *
     * #### Notes
     * This can be used to use an existing widget instead of opening
     * a new widget.
     */
    findWidget(context, widgetName) {
        const widgets = Private.widgetsProperty.get(context);
        if (!widgets) {
            return undefined;
        }
        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.find)(widgets, widget => {
            const factory = Private.factoryProperty.get(widget);
            if (!factory) {
                return false;
            }
            return factory.name === widgetName;
        });
    }
    /**
     * Get the document context for a widget.
     *
     * @param widget - The widget of interest.
     *
     * @returns The context associated with the widget, or `undefined`.
     */
    contextForWidget(widget) {
        return Private.contextProperty.get(widget);
    }
    /**
     * Clone a widget.
     *
     * @param widget - The source widget.
     *
     * @returns A new widget or `undefined`.
     *
     * #### Notes
     *  Uses the same widget factory and context as the source, or throws
     *  if the source widget is not managed by this manager.
     */
    cloneWidget(widget) {
        const context = Private.contextProperty.get(widget);
        if (!context) {
            return undefined;
        }
        const factory = Private.factoryProperty.get(widget);
        if (!factory) {
            return undefined;
        }
        const newWidget = factory.createNew(context, widget);
        this._initializeWidget(newWidget, factory, context);
        return newWidget;
    }
    /**
     * Close the widgets associated with a given context.
     *
     * @param context - The document context object.
     */
    closeWidgets(context) {
        const widgets = Private.widgetsProperty.get(context);
        return Promise.all(widgets.map(widget => this.onClose(widget))).then(() => undefined);
    }
    /**
     * Dispose of the widgets associated with a given context
     * regardless of the widget's dirty state.
     *
     * @param context - The document context object.
     */
    deleteWidgets(context) {
        const widgets = Private.widgetsProperty.get(context);
        return Promise.all(widgets.map(widget => this.onDelete(widget))).then(() => undefined);
    }
    /**
     * Filter a message sent to a message handler.
     *
     * @param handler - The target handler of the message.
     *
     * @param msg - The message dispatched to the handler.
     *
     * @returns `false` if the message should be filtered, of `true`
     *   if the message should be dispatched to the handler as normal.
     */
    messageHook(handler, msg) {
        switch (msg.type) {
            case 'close-request':
                void this.onClose(handler);
                return false;
            case 'activate-request': {
                const context = this.contextForWidget(handler);
                if (context) {
                    this._activateRequested.emit(context.path);
                }
                break;
            }
            default:
                break;
        }
        return true;
    }
    /**
     * Set the caption for widget title.
     *
     * @param widget - The target widget.
     */
    async setCaption(widget) {
        const trans = this.translator.load('jupyterlab');
        const context = Private.contextProperty.get(widget);
        if (!context) {
            return;
        }
        const model = context.contentsModel;
        if (!model) {
            widget.title.caption = '';
            return;
        }
        return context
            .listCheckpoints()
            .then((checkpoints) => {
            if (widget.isDisposed) {
                return;
            }
            const last = checkpoints[checkpoints.length - 1];
            const checkpoint = last ? _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.Time.format(last.last_modified) : 'None';
            let caption = trans.__('Name: %1\nPath: %2\n', model.name, model.path);
            if (context.model.readOnly) {
                caption += trans.__('Read-only');
            }
            else {
                caption +=
                    trans.__('Last Saved: %1\n', _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.Time.format(model.last_modified)) +
                        trans.__('Last Checkpoint: %1', checkpoint);
            }
            widget.title.caption = caption;
        });
    }
    /**
     * Handle `'close-request'` messages.
     *
     * @param widget - The target widget.
     *
     * @returns A promise that resolves with whether the widget was closed.
     */
    async onClose(widget) {
        var _a;
        // Handle dirty state.
        const [shouldClose, ignoreSave] = await this._maybeClose(widget, this.translator);
        if (widget.isDisposed) {
            return true;
        }
        if (shouldClose) {
            if (!ignoreSave) {
                const context = Private.contextProperty.get(widget);
                if (!context) {
                    return true;
                }
                if ((_a = context.contentsModel) === null || _a === void 0 ? void 0 : _a.writable) {
                    await context.save();
                }
                else {
                    await context.saveAs();
                }
            }
            if (widget.isDisposed) {
                return true;
            }
            widget.dispose();
        }
        return shouldClose;
    }
    /**
     * Dispose of widget regardless of widget's dirty state.
     *
     * @param widget - The target widget.
     */
    onDelete(widget) {
        widget.dispose();
        return Promise.resolve(void 0);
    }
    /**
     * Ask the user whether to close an unsaved file.
     */
    async _maybeClose(widget, translator) {
        var _a, _b;
        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        const trans = translator.load('jupyterlab');
        // Bail if the model is not dirty or other widgets are using the model.)
        const context = Private.contextProperty.get(widget);
        if (!context) {
            return Promise.resolve([true, true]);
        }
        let widgets = Private.widgetsProperty.get(context);
        if (!widgets) {
            return Promise.resolve([true, true]);
        }
        // Filter by whether the factories are read only.
        widgets = widgets.filter(widget => {
            const factory = Private.factoryProperty.get(widget);
            if (!factory) {
                return false;
            }
            return factory.readOnly === false;
        });
        const fileName = widget.title.label;
        const factory = Private.factoryProperty.get(widget);
        const isDirty = context.model.dirty &&
            widgets.length <= 1 &&
            !((_a = factory === null || factory === void 0 ? void 0 : factory.readOnly) !== null && _a !== void 0 ? _a : true);
        // Ask confirmation
        if (this.confirmClosingDocument) {
            const buttons = [
                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.Dialog.cancelButton(),
                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.Dialog.okButton({
                    label: isDirty ? trans.__('Close and save') : trans.__('Close'),
                    ariaLabel: isDirty
                        ? trans.__('Close and save Document')
                        : trans.__('Close Document')
                })
            ];
            if (isDirty) {
                buttons.splice(1, 0, _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.Dialog.warnButton({
                    label: trans.__('Close without saving'),
                    ariaLabel: trans.__('Close Document without saving')
                }));
            }
            const confirm = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.showDialog)({
                title: trans.__('Confirmation'),
                body: trans.__('Please confirm you want to close "%1".', fileName),
                checkbox: isDirty
                    ? null
                    : {
                        label: trans.__('Do not ask me again.'),
                        caption: trans.__('If checked, no confirmation to close a document will be asked in the future.')
                    },
                buttons
            });
            if (confirm.isChecked) {
                this.confirmClosingDocument = false;
            }
            return Promise.resolve([
                confirm.button.accept,
                isDirty ? confirm.button.displayType === 'warn' : true
            ]);
        }
        else {
            if (!isDirty) {
                return Promise.resolve([true, true]);
            }
            const saveLabel = ((_b = context.contentsModel) === null || _b === void 0 ? void 0 : _b.writable)
                ? trans.__('Save')
                : trans.__('Save as');
            const result = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.showDialog)({
                title: trans.__('Save your work'),
                body: trans.__('Save changes in "%1" before closing?', fileName),
                buttons: [
                    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.Dialog.cancelButton(),
                    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.Dialog.warnButton({
                        label: trans.__('Discard'),
                        ariaLabel: trans.__('Discard changes to file')
                    }),
                    _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_7__.Dialog.okButton({ label: saveLabel })
                ]
            });
            return [result.button.accept, result.button.displayType === 'warn'];
        }
    }
    /**
     * Handle the disposal of a widget.
     */
    _widgetDisposed(widget) {
        const context = Private.contextProperty.get(widget);
        if (!context) {
            return;
        }
        const widgets = Private.widgetsProperty.get(context);
        if (!widgets) {
            return;
        }
        // Remove the widget.
        _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.ArrayExt.removeFirstOf(widgets, widget);
        // Dispose of the context if this is the last widget using it.
        if (!widgets.length) {
            context.dispose();
        }
    }
    /**
     * Handle the disposal of a widget.
     */
    _onWidgetDisposed(widget) {
        const disposables = Private.disposablesProperty.get(widget);
        disposables.dispose();
    }
    /**
     * Handle a file changed signal for a context.
     */
    _onFileChanged(context) {
        const widgets = Private.widgetsProperty.get(context);
        for (const widget of widgets) {
            void this.setCaption(widget);
        }
    }
    /**
     * Handle a path changed signal for a context.
     */
    _onPathChanged(context) {
        const widgets = Private.widgetsProperty.get(context);
        for (const widget of widgets) {
            void this.setCaption(widget);
        }
    }
}
/**
 * A private namespace for DocumentManager data.
 */
var Private;
(function (Private) {
    /**
     * A private attached property for a widget context.
     */
    Private.contextProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_4__.AttachedProperty({
        name: 'context',
        create: () => undefined
    });
    /**
     * A private attached property for a widget factory.
     */
    Private.factoryProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_4__.AttachedProperty({
        name: 'factory',
        create: () => undefined
    });
    /**
     * A private attached property for the widgets associated with a context.
     */
    Private.widgetsProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_4__.AttachedProperty({
        name: 'widgets',
        create: () => []
    });
    /**
     * A private attached property for a widget's disposables.
     */
    Private.disposablesProperty = new _lumino_properties__WEBPACK_IMPORTED_MODULE_4__.AttachedProperty({
        name: 'disposables',
        create: () => new _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__.DisposableSet()
    });
})(Private || (Private = {}));
//# sourceMappingURL=widgetmanager.js.map

/***/ }),

/***/ "./node_modules/@jupyterlab/docmanager/node_modules/@lumino/coreutils/dist/index.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@jupyterlab/docmanager/node_modules/@lumino/coreutils/dist/index.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
     true ? factory(exports) :
    0;
})(this, (function (exports) { 'use strict';

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for JSON-specific functions.
     */
    exports.JSONExt = void 0;
    (function (JSONExt) {
        /**
         * A shared frozen empty JSONObject
         */
        JSONExt.emptyObject = Object.freeze({});
        /**
         * A shared frozen empty JSONArray
         */
        JSONExt.emptyArray = Object.freeze([]);
        /**
         * Test whether a JSON value is a primitive.
         *
         * @param value - The JSON value of interest.
         *
         * @returns `true` if the value is a primitive,`false` otherwise.
         */
        function isPrimitive(value) {
            return (value === null ||
                typeof value === 'boolean' ||
                typeof value === 'number' ||
                typeof value === 'string');
        }
        JSONExt.isPrimitive = isPrimitive;
        function isArray(value) {
            return Array.isArray(value);
        }
        JSONExt.isArray = isArray;
        function isObject(value) {
            return !isPrimitive(value) && !isArray(value);
        }
        JSONExt.isObject = isObject;
        /**
         * Compare two JSON values for deep equality.
         *
         * @param first - The first JSON value of interest.
         *
         * @param second - The second JSON value of interest.
         *
         * @returns `true` if the values are equivalent, `false` otherwise.
         */
        function deepEqual(first, second) {
            // Check referential and primitive equality first.
            if (first === second) {
                return true;
            }
            // If one is a primitive, the `===` check ruled out the other.
            if (isPrimitive(first) || isPrimitive(second)) {
                return false;
            }
            // Test whether they are arrays.
            let a1 = isArray(first);
            let a2 = isArray(second);
            // Bail if the types are different.
            if (a1 !== a2) {
                return false;
            }
            // If they are both arrays, compare them.
            if (a1 && a2) {
                return deepArrayEqual(first, second);
            }
            // At this point, they must both be objects.
            return deepObjectEqual(first, second);
        }
        JSONExt.deepEqual = deepEqual;
        /**
         * Create a deep copy of a JSON value.
         *
         * @param value - The JSON value to copy.
         *
         * @returns A deep copy of the given JSON value.
         */
        function deepCopy(value) {
            // Do nothing for primitive values.
            if (isPrimitive(value)) {
                return value;
            }
            // Deep copy an array.
            if (isArray(value)) {
                return deepArrayCopy(value);
            }
            // Deep copy an object.
            return deepObjectCopy(value);
        }
        JSONExt.deepCopy = deepCopy;
        /**
         * Compare two JSON arrays for deep equality.
         */
        function deepArrayEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Test the arrays for equal length.
            if (first.length !== second.length) {
                return false;
            }
            // Compare the values for equality.
            for (let i = 0, n = first.length; i < n; ++i) {
                if (!deepEqual(first[i], second[i])) {
                    return false;
                }
            }
            // At this point, the arrays are equal.
            return true;
        }
        /**
         * Compare two JSON objects for deep equality.
         */
        function deepObjectEqual(first, second) {
            // Check referential equality first.
            if (first === second) {
                return true;
            }
            // Check for the first object's keys in the second object.
            for (let key in first) {
                if (first[key] !== undefined && !(key in second)) {
                    return false;
                }
            }
            // Check for the second object's keys in the first object.
            for (let key in second) {
                if (second[key] !== undefined && !(key in first)) {
                    return false;
                }
            }
            // Compare the values for equality.
            for (let key in first) {
                // Get the values.
                let firstValue = first[key];
                let secondValue = second[key];
                // If both are undefined, ignore the key.
                if (firstValue === undefined && secondValue === undefined) {
                    continue;
                }
                // If only one value is undefined, the objects are not equal.
                if (firstValue === undefined || secondValue === undefined) {
                    return false;
                }
                // Compare the values.
                if (!deepEqual(firstValue, secondValue)) {
                    return false;
                }
            }
            // At this point, the objects are equal.
            return true;
        }
        /**
         * Create a deep copy of a JSON array.
         */
        function deepArrayCopy(value) {
            let result = new Array(value.length);
            for (let i = 0, n = value.length; i < n; ++i) {
                result[i] = deepCopy(value[i]);
            }
            return result;
        }
        /**
         * Create a deep copy of a JSON object.
         */
        function deepObjectCopy(value) {
            let result = {};
            for (let key in value) {
                // Ignore undefined values.
                let subvalue = value[key];
                if (subvalue === undefined) {
                    continue;
                }
                result[key] = deepCopy(subvalue);
            }
            return result;
        }
    })(exports.JSONExt || (exports.JSONExt = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * An object which stores MIME data for general application use.
     *
     * #### Notes
     * This class does not attempt to enforce "correctness" of MIME types
     * and their associated data. Since this class is designed to transfer
     * arbitrary data and objects within the same application, it assumes
     * that the user provides correct and accurate data.
     */
    class MimeData {
        constructor() {
            this._types = [];
            this._values = [];
        }
        /**
         * Get an array of the MIME types contained within the dataset.
         *
         * @returns A new array of the MIME types, in order of insertion.
         */
        types() {
            return this._types.slice();
        }
        /**
         * Test whether the dataset has an entry for the given type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns `true` if the dataset contains a value for the given
         *   MIME type, `false` otherwise.
         */
        hasData(mime) {
            return this._types.indexOf(mime) !== -1;
        }
        /**
         * Get the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @returns The value for the given MIME type, or `undefined` if
         *   the dataset does not contain a value for the type.
         */
        getData(mime) {
            let i = this._types.indexOf(mime);
            return i !== -1 ? this._values[i] : undefined;
        }
        /**
         * Set the data value for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * @param data - The data value for the given MIME type.
         *
         * #### Notes
         * This will overwrite any previous entry for the MIME type.
         */
        setData(mime, data) {
            this.clearData(mime);
            this._types.push(mime);
            this._values.push(data);
        }
        /**
         * Remove the data entry for the given MIME type.
         *
         * @param mime - The MIME type of interest.
         *
         * #### Notes
         * This is a no-op if there is no entry for the given MIME type.
         */
        clearData(mime) {
            let i = this._types.indexOf(mime);
            if (i !== -1) {
                this._types.splice(i, 1);
                this._values.splice(i, 1);
            }
        }
        /**
         * Remove all data entries from the dataset.
         */
        clear() {
            this._types.length = 0;
            this._values.length = 0;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A class which wraps a promise into a delegate object.
     *
     * #### Notes
     * This class is useful when the logic to resolve or reject a promise
     * cannot be defined at the point where the promise is created.
     */
    class PromiseDelegate {
        /**
         * Construct a new promise delegate.
         */
        constructor() {
            this.promise = new Promise((resolve, reject) => {
                this._resolve = resolve;
                this._reject = reject;
            });
        }
        /**
         * Resolve the wrapped promise with the given value.
         *
         * @param value - The value to use for resolving the promise.
         */
        resolve(value) {
            let resolve = this._resolve;
            resolve(value);
        }
        /**
         * Reject the wrapped promise with the given value.
         *
         * @reason - The reason for rejecting the promise.
         */
        reject(reason) {
            let reject = this._reject;
            reject(reason);
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A runtime object which captures compile-time type information.
     *
     * #### Notes
     * A token captures the compile-time type of an interface or class in
     * an object which can be used at runtime in a type-safe fashion.
     */
    class Token {
        /**
         * Construct a new token.
         *
         * @param name - A human readable name for the token.
         * @param description - Token purpose description for documentation.
         */
        constructor(name, description) {
            this.name = name;
            this.description = description !== null && description !== void 0 ? description : '';
            this._tokenStructuralPropertyT = null;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    // Fallback
    function fallbackRandomValues(buffer) {
        let value = 0;
        for (let i = 0, n = buffer.length; i < n; ++i) {
            if (i % 4 === 0) {
                value = (Math.random() * 0xffffffff) >>> 0;
            }
            buffer[i] = value & 0xff;
            value >>>= 8;
        }
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for random number related functionality.
     */
    exports.Random = void 0;
    (function (Random) {
        /**
         * A function which generates random bytes.
         *
         * @param buffer - The `Uint8Array` to fill with random bytes.
         *
         * #### Notes
         * A cryptographically strong random number generator will be used if
         * available. Otherwise, `Math.random` will be used as a fallback for
         * randomness.
         *
         * The following RNGs are supported, listed in order of precedence:
         *   - `window.crypto.getRandomValues`
         *   - `window.msCrypto.getRandomValues`
         *   - `require('crypto').randomFillSync
         *   - `require('crypto').randomBytes
         *   - `Math.random`
         */
        Random.getRandomValues = (() => {
            // Look up the crypto module if available.
            const crypto = (typeof window !== 'undefined' && (window.crypto || window.msCrypto)) ||
                null;
            // Modern browsers and IE 11
            if (crypto && typeof crypto.getRandomValues === 'function') {
                return function getRandomValues(buffer) {
                    return crypto.getRandomValues(buffer);
                };
            }
            // Fallback
            return fallbackRandomValues;
        })();
    })(exports.Random || (exports.Random = {}));

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * A function which creates a function that generates UUID v4 identifiers.
     *
     * @returns A new function that creates a UUID v4 string.
     *
     * #### Notes
     * This implementation complies with RFC 4122.
     *
     * This uses `Random.getRandomValues()` for random bytes, which in
     * turn will use the underlying `crypto` module of the platform if
     * it is available. The fallback for randomness is `Math.random`.
     */
    function uuid4Factory(getRandomValues) {
        // Create a 16 byte array to hold the random values.
        const bytes = new Uint8Array(16);
        // Create a look up table from bytes to hex strings.
        const lut = new Array(256);
        // Pad the single character hex digits with a leading zero.
        for (let i = 0; i < 16; ++i) {
            lut[i] = '0' + i.toString(16);
        }
        // Populate the rest of the hex digits.
        for (let i = 16; i < 256; ++i) {
            lut[i] = i.toString(16);
        }
        // Return a function which generates the UUID.
        return function uuid4() {
            // Get a new batch of random values.
            getRandomValues(bytes);
            // Set the UUID version number to 4.
            bytes[6] = 0x40 | (bytes[6] & 0x0f);
            // Set the clock sequence bit to the RFC spec.
            bytes[8] = 0x80 | (bytes[8] & 0x3f);
            // Assemble the UUID string.
            return (lut[bytes[0]] +
                lut[bytes[1]] +
                lut[bytes[2]] +
                lut[bytes[3]] +
                '-' +
                lut[bytes[4]] +
                lut[bytes[5]] +
                '-' +
                lut[bytes[6]] +
                lut[bytes[7]] +
                '-' +
                lut[bytes[8]] +
                lut[bytes[9]] +
                '-' +
                lut[bytes[10]] +
                lut[bytes[11]] +
                lut[bytes[12]] +
                lut[bytes[13]] +
                lut[bytes[14]] +
                lut[bytes[15]]);
        };
    }

    // Copyright (c) Jupyter Development Team.
    // Distributed under the terms of the Modified BSD License.
    /*-----------------------------------------------------------------------------
    | Copyright (c) 2014-2017, PhosphorJS Contributors
    |
    | Distributed under the terms of the BSD 3-Clause License.
    |
    | The full license is in the file LICENSE, distributed with this software.
    |----------------------------------------------------------------------------*/
    /**
     * The namespace for UUID related functionality.
     */
    exports.UUID = void 0;
    (function (UUID) {
        /**
         * A function which generates UUID v4 identifiers.
         *
         * @returns A new UUID v4 string.
         *
         * #### Notes
         * This implementation complies with RFC 4122.
         *
         * This uses `Random.getRandomValues()` for random bytes, which in
         * turn will use the underlying `crypto` module of the platform if
         * it is available. The fallback for randomness is `Math.random`.
         */
        UUID.uuid4 = uuid4Factory(exports.Random.getRandomValues);
    })(exports.UUID || (exports.UUID = {}));

    exports.MimeData = MimeData;
    exports.PromiseDelegate = PromiseDelegate;
    exports.Token = Token;

}));
//# sourceMappingURL=index.js.map


/***/ }),

/***/ "./node_modules/@jupyterlab/docregistry/lib/context.js":
/*!*************************************************************!*\
  !*** ./node_modules/@jupyterlab/docregistry/lib/context.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Context: () => (/* binding */ Context)
/* harmony export */ });
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/apputils */ "./node_modules/@jupyterlab/apputils/lib/sessioncontext.js");
/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @jupyterlab/apputils */ "./node_modules/@jupyterlab/apputils/lib/dialog.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/coreutils */ "./node_modules/@jupyterlab/coreutils/lib/index.js");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/rendermime */ "./node_modules/@jupyterlab/rendermime/lib/registry.js");
/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/translation */ "./node_modules/@jupyterlab/translation/lib/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/coreutils */ "./node_modules/@jupyterlab/docregistry/node_modules/@lumino/coreutils/dist/index.js");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _lumino_disposable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/disposable */ "./node_modules/@lumino/disposable/dist/index.es6.js");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/signaling */ "./node_modules/@lumino/signaling/dist/index.es6.js");
/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/widgets */ "./node_modules/@lumino/widgets/dist/index.es6.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.








/**
 * An implementation of a document context.
 *
 * This class is typically instantiated by the document manager.
 */
class Context {
    /**
     * Construct a new document context.
     */
    constructor(options) {
        var _a, _b;
        this._isReady = false;
        this._isDisposed = false;
        this._isPopulated = false;
        this._path = '';
        this._lineEnding = null;
        this._contentsModel = null;
        this._populatedPromise = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_1__.PromiseDelegate();
        this._pathChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._fileChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._saveState = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._disposed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal(this);
        this._lastModifiedCheckMargin = 500;
        this._timeConflictModalIsOpen = false;
        const manager = (this._manager = options.manager);
        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_0__.nullTranslator;
        this._trans = this.translator.load('jupyterlab');
        this._factory = options.factory;
        this._dialogs =
            (_a = options.sessionDialogs) !== null && _a !== void 0 ? _a : new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_5__.SessionContextDialogs({ translator: options.translator });
        this._opener = options.opener || Private.noOp;
        this._path = this._manager.contents.normalize(options.path);
        this._lastModifiedCheckMargin = options.lastModifiedCheckMargin || 500;
        const localPath = this._manager.contents.localPath(this._path);
        const lang = this._factory.preferredLanguage(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.PathExt.basename(localPath));
        const sharedFactory = this._manager.contents.getSharedModelFactory(this._path);
        const sharedModel = sharedFactory === null || sharedFactory === void 0 ? void 0 : sharedFactory.createNew({
            path: localPath,
            format: this._factory.fileFormat,
            contentType: this._factory.contentType,
            collaborative: this._factory.collaborative
        });
        this._model = this._factory.createNew({
            languagePreference: lang,
            sharedModel,
            collaborationEnabled: (_b = sharedFactory === null || sharedFactory === void 0 ? void 0 : sharedFactory.collaborative) !== null && _b !== void 0 ? _b : false
        });
        this._readyPromise = manager.ready.then(() => {
            return this._populatedPromise.promise;
        });
        const ext = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.PathExt.extname(this._path);
        this.sessionContext = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_5__.SessionContext({
            sessionManager: manager.sessions,
            specsManager: manager.kernelspecs,
            path: localPath,
            type: ext === '.ipynb' ? 'notebook' : 'file',
            name: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_6__.PathExt.basename(localPath),
            kernelPreference: options.kernelPreference || { shouldStart: false },
            setBusy: options.setBusy
        });
        this.sessionContext.propertyChanged.connect(this._onSessionChanged, this);
        manager.contents.fileChanged.connect(this._onFileChanged, this);
        this.urlResolver = new _jupyterlab_rendermime__WEBPACK_IMPORTED_MODULE_7__.RenderMimeRegistry.UrlResolver({
            path: this._path,
            contents: manager.contents
        });
    }
    /**
     * A signal emitted when the path changes.
     */
    get pathChanged() {
        return this._pathChanged;
    }
    /**
     * A signal emitted when the model is saved or reverted.
     */
    get fileChanged() {
        return this._fileChanged;
    }
    /**
     * A signal emitted on the start and end of a saving operation.
     */
    get saveState() {
        return this._saveState;
    }
    /**
     * A signal emitted when the context is disposed.
     */
    get disposed() {
        return this._disposed;
    }
    /**
     * Configurable margin used to detect document modification conflicts, in milliseconds
     */
    get lastModifiedCheckMargin() {
        return this._lastModifiedCheckMargin;
    }
    set lastModifiedCheckMargin(value) {
        this._lastModifiedCheckMargin = value;
    }
    /**
     * Get the model associated with the document.
     */
    get model() {
        return this._model;
    }
    /**
     * The current path associated with the document.
     */
    get path() {
        return this._path;
    }
    /**
     * The current local path associated with the document.
     * If the document is in the default notebook file browser,
     * this is the same as the path.
     */
    get localPath() {
        return this._manager.contents.localPath(this._path);
    }
    /**
     * The document metadata, stored as a services contents model.
     *
     * #### Notes
     * The contents model will be `null` until the context is populated.
     * It will not have a `content` field.
     */
    get contentsModel() {
        return this._contentsModel ? { ...this._contentsModel } : null;
    }
    /**
     * Get the model factory name.
     *
     * #### Notes
     * This is not part of the `IContext` API.
     */
    get factoryName() {
        return this.isDisposed ? '' : this._factory.name;
    }
    /**
     * Test whether the context is disposed.
     */
    get isDisposed() {
        return this._isDisposed;
    }
    /**
     * Dispose of the resources held by the context.
     */
    dispose() {
        if (this.isDisposed) {
            return;
        }
        this._isDisposed = true;
        this.sessionContext.dispose();
        this._model.dispose();
        // Ensure we dispose the `sharedModel` as it may have been generated in the context
        // through the shared model factory.
        this._model.sharedModel.dispose();
        this._disposed.emit(void 0);
        _lumino_signaling__WEBPACK_IMPORTED_MODULE_3__.Signal.clearData(this);
    }
    /**
     * Whether the context is ready.
     */
    get isReady() {
        return this._isReady;
    }
    /**
     * A promise that is fulfilled when the context is ready.
     */
    get ready() {
        return this._readyPromise;
    }
    /**
     * Whether the document can be saved via the Contents API.
     */
    get canSave() {
        var _a;
        return !!(((_a = this._contentsModel) === null || _a === void 0 ? void 0 : _a.writable) && !this._model.collaborative);
    }
    /**
     * Initialize the context.
     *
     * @param isNew - Whether it is a new file.
     *
     * @returns a promise that resolves upon initialization.
     */
    async initialize(isNew) {
        if (isNew) {
            await this._save();
        }
        else {
            await this._revert();
        }
        this.model.sharedModel.clearUndoHistory();
    }
    /**
     * Rename the document.
     *
     * @param newName - the new name for the document.
     */
    rename(newName) {
        return this.ready.then(() => {
            return this._manager.ready.then(() => {
                return this._rename(newName);
            });
        });
    }
    /**
     * Save the document contents to disk.
     */
    async save() {
        await this.ready;
        await this._save();
    }
    /**
     * Save the document to a different path chosen by the user.
     *
     * It will be rejected if the user abort providing a new path.
     */
    async saveAs() {
        await this.ready;
        const localPath = this._manager.contents.localPath(this.path);
        const newLocalPath = await Private.getSavePath(localPath);
        if (this.isDisposed || !newLocalPath) {
            return;
        }
        const drive = this._manager.contents.driveName(this.path);
        const newPath = drive == '' ? newLocalPath : `${drive}:${newLocalPath}`;
        if (newPath === this._path) {
            return this.save();
        }
        // Make sure the path does not exist.
        try {
            await this._manager.ready;
            await this._manager.contents.get(newPath);
            await this._maybeOverWrite(newPath);
        }
        catch (err) {
            if (!err.response || err.response.status !== 404) {
                throw err;
            }
            await this._finishSaveAs(