from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="BlaskAPIAgentManager",
    version="0.1.0",
    author="Blask RnD Team",
    author_email="elijah@blask.com",
    description="An agent for interacting with Blask API based on Swagger spec",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://gitlab.private.blask.com/blask/ml-ai/blaskapiagentmanager",
    packages=find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.9",
    install_requires=[
        "langchain",
        "langchain-openai",
        "langchain-core",
        "requests",
        "python-dotenv",
        "pydantic",
        "openai",
    ],
)
