/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.osalau;

import ee.ut.soras.osalau.OsalauSona;
import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;

public class ValjundiVormistaja {
    public static String vormistaTulemusT3OLPkujul(String sisendT3OLP, List<OsalauSona> margendusegaSonad, boolean skipIgnorePart) throws Exception {
        StringBuilder valjund = new StringBuilder(margendusegaSonad.size() * 20);
        HashMap<Integer, OsalauSona> tokenPosToMargendusMap = new HashMap<Integer, OsalauSona>();
        for (int i = 0; i < margendusegaSonad.size(); ++i) {
            int key;
            OsalauSona margendus = margendusegaSonad.get(i);
            if (margendus.getMorfSona().getTokenPosition() != -1) {
                key = margendus.getMorfSona().getTokenPosition();
                if (tokenPosToMargendusMap.containsKey(key)) {
                    throw new Exception(" Duplicate labels for position " + String.valueOf(key) + " " + margendus.getMorfSona().getAlgSona() + ": " + margendus + " " + tokenPosToMargendusMap.get(i));
                }
            } else {
                throw new Exception(" Unable to map MorfAnSona to tokenposition for " + margendus.getMorfSona().getAlgSona());
            }
            tokenPosToMargendusMap.put(key, margendus);
        }
        String rida = null;
        int tokenPosition = 1;
        BufferedReader input = new BufferedReader(new StringReader(sisendT3OLP));
        block1: while ((rida = input.readLine()) != null) {
            OsalauSona margend;
            if (rida.length() > 0 && rida.equals("<ignoreeri>")) {
                if (!skipIgnorePart) {
                    valjund.append(rida);
                    valjund.append("\n");
                }
                ++tokenPosition;
                while ((rida = input.readLine()) != null) {
                    if (!skipIgnorePart) {
                        valjund.append(rida);
                        valjund.append("\n");
                    }
                    ++tokenPosition;
                    if (rida.length() <= 0 || !rida.equals("</ignoreeri>")) continue;
                    continue block1;
                }
                continue;
            }
            if (rida.length() <= 0) continue;
            StringBuilder sonaStr = new StringBuilder(rida);
            sonaStr.append("\n");
            if (tokenPosToMargendusMap.containsKey(tokenPosition) && !(margend = (OsalauSona)tokenPosToMargendusMap.get(tokenPosition)).getKindladOLPMargendid().isEmpty()) {
                for (OsalauSona.MARGEND seotudMargend : margend.getKindladOLPMargendid()) {
                    if (seotudMargend == OsalauSona.MARGEND.KINDEL_PIIR) {
                        sonaStr.append("<kindel_piir/>");
                        sonaStr.append("\n");
                        continue;
                    }
                    if (seotudMargend == OsalauSona.MARGEND.KIILU_ALGUS) {
                        sonaStr.insert(0, "<kiil>\n");
                        continue;
                    }
                    if (seotudMargend != OsalauSona.MARGEND.KIILU_LOPP) continue;
                    sonaStr.append("</kiil>");
                    sonaStr.append("\n");
                }
            }
            valjund.append((CharSequence)sonaStr);
            ++tokenPosition;
        }
        return valjund.toString();
    }

    public static String vormistaTulemusVabaMorfiJSONkujul(String sisendJSON, List<OsalauSona> margendusegaSonad, boolean prettyPrint) throws Exception {
        StringWriter sw = new StringWriter();
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        if (prettyPrint) {
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", prettyPrint);
        }
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        JsonGenerator jsonGenerator = jgf.createGenerator(sw);
        BufferedReader inputReader = new BufferedReader(new StringReader(sisendJSON));
        JsonParser parser = Json.createParser(inputReader);
        Stack<String> jsonKeyPath = new Stack<String>();
        JsonParser.Event lastEvent = null;
        String lastString = "";
        String tokenText = null;
        HashMap<Integer, OsalauSona> tokenPosToMargendusMap = new HashMap<Integer, OsalauSona>();
        for (int i = 0; i < margendusegaSonad.size(); ++i) {
            int key;
            OsalauSona margendus = margendusegaSonad.get(i);
            if (margendus.getMorfSona().getTokenPosition() != -1) {
                key = margendus.getMorfSona().getTokenPosition();
                if (tokenPosToMargendusMap.containsKey(key)) {
                    throw new Exception(" Duplicate labels for position " + String.valueOf(key) + " " + margendus.getMorfSona().getAlgSona() + ": " + margendus + " " + tokenPosToMargendusMap.get(i));
                }
            } else {
                throw new Exception(" Unable to map MorfAnSona to tokenposition for " + margendus.getMorfSona().getAlgSona());
            }
            tokenPosToMargendusMap.put(key, margendus);
        }
        int currentTokenPosition = 1;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_ARRAY: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonKeyPath.push(lastString);
                        jsonGenerator.writeStartArray(lastString);
                    } else {
                        jsonGenerator.writeStartArray();
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case END_ARRAY: {
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("words")) {
                        // empty if block
                    }
                    lastEvent = event;
                    lastString = "";
                    jsonKeyPath.pop();
                    jsonGenerator.writeEnd();
                    break;
                }
                case START_OBJECT: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.writeStartObject(lastString);
                    } else {
                        jsonGenerator.writeStartObject();
                    }
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("words")) {
                        // empty if block
                    }
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("analysis")) {
                        // empty if block
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case END_OBJECT: {
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("words")) {
                        if (tokenText == null) {
                            throw new Exception(" Unable to find text form for a word ...");
                        }
                        Integer positionKey = currentTokenPosition;
                        if (tokenPosToMargendusMap.containsKey(positionKey)) {
                            OsalauSona margendus = (OsalauSona)tokenPosToMargendusMap.get(positionKey);
                            if (!margendus.getKindladOLPMargendid().isEmpty()) {
                                jsonGenerator.writeStartArray("clauseAnnotation");
                                for (OsalauSona.MARGEND margend : margendus.getKindladOLPMargendid()) {
                                    jsonGenerator.write(margend.toString());
                                }
                                jsonGenerator.writeEnd();
                            }
                        } else {
                            throw new Exception(" Unable to find MorfAnSona associated with the word " + tokenText + " at position " + currentTokenPosition + "...");
                        }
                        ++currentTokenPosition;
                        tokenText = null;
                    }
                    if (jsonKeyPath.empty() || ((String)jsonKeyPath.peek()).equals("analysis")) {
                        // empty if block
                    }
                    lastEvent = event;
                    lastString = "";
                    jsonGenerator.writeEnd();
                    break;
                }
                case VALUE_FALSE: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.write(lastString, false);
                    } else {
                        jsonGenerator.write(false);
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case VALUE_NULL: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.writeNull(lastString);
                    } else {
                        jsonGenerator.writeNull();
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case VALUE_TRUE: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.write(lastString, true);
                    } else {
                        jsonGenerator.write(true);
                    }
                    lastEvent = event;
                    lastString = "";
                    break;
                }
                case KEY_NAME: {
                    lastEvent = event;
                    lastString = parser.getString();
                    break;
                }
                case VALUE_STRING: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        jsonGenerator.write(lastString, parser.getString());
                    } else {
                        jsonGenerator.write(parser.getString());
                    }
                    if (!jsonKeyPath.empty() && ((String)jsonKeyPath.peek()).equals("words") && lastString != null && lastString.equals("text")) {
                        tokenText = parser.getString();
                    }
                    lastEvent = event;
                    lastString = parser.getString();
                    break;
                }
                case VALUE_NUMBER: {
                    if (lastEvent != null && lastEvent == JsonParser.Event.KEY_NAME) {
                        if (parser.isIntegralNumber()) {
                            jsonGenerator.write(lastString, parser.getLong());
                        } else {
                            jsonGenerator.write(lastString, parser.getBigDecimal());
                        }
                    } else if (parser.isIntegralNumber()) {
                        jsonGenerator.write(parser.getLong());
                    } else {
                        jsonGenerator.write(parser.getBigDecimal());
                    }
                    lastEvent = event;
                    lastString = "";
                }
            }
        }
        jsonGenerator.close();
        inputReader.close();
        return sw.toString();
    }
}

