window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "gitbetter", "modulename": "gitbetter", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "gitbetter.git", "modulename": "gitbetter.git", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "gitbetter.git.Git", "modulename": "gitbetter.git", "qualname": "Git", "kind": "class", "doc": "<p></p>\n", "bases": "morbin.morbin.Morbin"}, {"fullname": "gitbetter.git.Git.git", "modulename": "gitbetter.git", "qualname": "Git.git", "kind": "function", "doc": "<p>Base function for executing git commands.\nUse this if another function doesn't meet your needs.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"p\">{</span><span class=\"n\">command</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">command</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.add", "modulename": "gitbetter.git", "qualname": "Git.add", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.am", "modulename": "gitbetter.git", "qualname": "Git.am", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">am</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.annotate", "modulename": "gitbetter.git", "qualname": "Git.annotate", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">annotate</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.archive", "modulename": "gitbetter.git", "qualname": "Git.archive", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">archive</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.bisect", "modulename": "gitbetter.git", "qualname": "Git.bisect", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">bisect</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.blame", "modulename": "gitbetter.git", "qualname": "Git.blame", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">blame</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.branch", "modulename": "gitbetter.git", "qualname": "Git.branch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">branch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.bugreport", "modulename": "gitbetter.git", "qualname": "Git.bugreport", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">bugreport</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.bundle", "modulename": "gitbetter.git", "qualname": "Git.bundle", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">bundle</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.checkout", "modulename": "gitbetter.git", "qualname": "Git.checkout", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">checkout</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.cherry_pick", "modulename": "gitbetter.git", "qualname": "Git.cherry_pick", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">cherry</span><span class=\"o\">-</span><span class=\"n\">pick</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.citool", "modulename": "gitbetter.git", "qualname": "Git.citool", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">citool</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.clean", "modulename": "gitbetter.git", "qualname": "Git.clean", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">clean</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.clone", "modulename": "gitbetter.git", "qualname": "Git.clone", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">clone</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.commit", "modulename": "gitbetter.git", "qualname": "Git.commit", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">commit</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.config", "modulename": "gitbetter.git", "qualname": "Git.config", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">config</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.count_objects", "modulename": "gitbetter.git", "qualname": "Git.count_objects", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">count</span><span class=\"o\">-</span><span class=\"n\">objects</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.describe", "modulename": "gitbetter.git", "qualname": "Git.describe", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">describe</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.diagnose", "modulename": "gitbetter.git", "qualname": "Git.diagnose", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">diagnose</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.diff", "modulename": "gitbetter.git", "qualname": "Git.diff", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">diff</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.difftool", "modulename": "gitbetter.git", "qualname": "Git.difftool", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">difftool</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.fast_export", "modulename": "gitbetter.git", "qualname": "Git.fast_export", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fast</span><span class=\"o\">-</span><span class=\"n\">export</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.fast_import", "modulename": "gitbetter.git", "qualname": "Git.fast_import", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fast</span><span class=\"o\">-</span><span class=\"kn\">import</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.fetch", "modulename": "gitbetter.git", "qualname": "Git.fetch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fetch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.filter_branch", "modulename": "gitbetter.git", "qualname": "Git.filter_branch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"nb\">filter</span><span class=\"o\">-</span><span class=\"n\">branch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.format_patch", "modulename": "gitbetter.git", "qualname": "Git.format_patch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"nb\">format</span><span class=\"o\">-</span><span class=\"n\">patch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.fsck", "modulename": "gitbetter.git", "qualname": "Git.fsck", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fsck</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.gc", "modulename": "gitbetter.git", "qualname": "Git.gc", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gc</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.gitk", "modulename": "gitbetter.git", "qualname": "Git.gitk", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gitk</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.gitweb", "modulename": "gitbetter.git", "qualname": "Git.gitweb", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gitweb</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.grep", "modulename": "gitbetter.git", "qualname": "Git.grep", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">grep</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.gui", "modulename": "gitbetter.git", "qualname": "Git.gui", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gui</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.help", "modulename": "gitbetter.git", "qualname": "Git.help", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">help</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.init", "modulename": "gitbetter.git", "qualname": "Git.init", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">init</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.instaweb", "modulename": "gitbetter.git", "qualname": "Git.instaweb", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">instaweb</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.log", "modulename": "gitbetter.git", "qualname": "Git.log", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">log</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.maintenance", "modulename": "gitbetter.git", "qualname": "Git.maintenance", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">maintenance</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.merge", "modulename": "gitbetter.git", "qualname": "Git.merge", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">merge</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.merge_tree", "modulename": "gitbetter.git", "qualname": "Git.merge_tree", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">merge</span><span class=\"o\">-</span><span class=\"n\">tree</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.mergetool", "modulename": "gitbetter.git", "qualname": "Git.mergetool", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">mergetool</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.mv", "modulename": "gitbetter.git", "qualname": "Git.mv", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">mv</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.notes", "modulename": "gitbetter.git", "qualname": "Git.notes", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">notes</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.pack_refs", "modulename": "gitbetter.git", "qualname": "Git.pack_refs", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">pack</span><span class=\"o\">-</span><span class=\"n\">refs</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.prune", "modulename": "gitbetter.git", "qualname": "Git.prune", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">prune</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.pull", "modulename": "gitbetter.git", "qualname": "Git.pull", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">pull</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.push", "modulename": "gitbetter.git", "qualname": "Git.push", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">push</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.range_diff", "modulename": "gitbetter.git", "qualname": "Git.range_diff", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"nb\">range</span><span class=\"o\">-</span><span class=\"n\">diff</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.rebase", "modulename": "gitbetter.git", "qualname": "Git.rebase", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rebase</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.reflog", "modulename": "gitbetter.git", "qualname": "Git.reflog", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">reflog</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.remote", "modulename": "gitbetter.git", "qualname": "Git.remote", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">remote</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.repack", "modulename": "gitbetter.git", "qualname": "Git.repack", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">repack</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.replace", "modulename": "gitbetter.git", "qualname": "Git.replace", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">replace</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.request_pull", "modulename": "gitbetter.git", "qualname": "Git.request_pull", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">request</span><span class=\"o\">-</span><span class=\"n\">pull</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.rerere", "modulename": "gitbetter.git", "qualname": "Git.rerere", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rerere</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.reset", "modulename": "gitbetter.git", "qualname": "Git.reset", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">reset</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.restore", "modulename": "gitbetter.git", "qualname": "Git.restore", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">restore</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.revert", "modulename": "gitbetter.git", "qualname": "Git.revert", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">revert</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.rm", "modulename": "gitbetter.git", "qualname": "Git.rm", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rm</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.scalar", "modulename": "gitbetter.git", "qualname": "Git.scalar", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">scalar</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.shortlog", "modulename": "gitbetter.git", "qualname": "Git.shortlog", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">shortlog</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.show", "modulename": "gitbetter.git", "qualname": "Git.show", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">show</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.show_branch", "modulename": "gitbetter.git", "qualname": "Git.show_branch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">show</span><span class=\"o\">-</span><span class=\"n\">branch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.sparse_checkout", "modulename": "gitbetter.git", "qualname": "Git.sparse_checkout", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">sparse</span><span class=\"o\">-</span><span class=\"n\">checkout</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.stash", "modulename": "gitbetter.git", "qualname": "Git.stash", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">stash</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.status", "modulename": "gitbetter.git", "qualname": "Git.status", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">status</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.submodule", "modulename": "gitbetter.git", "qualname": "Git.submodule", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">submodule</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.switch", "modulename": "gitbetter.git", "qualname": "Git.switch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">switch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.tag", "modulename": "gitbetter.git", "qualname": "Git.tag", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">tag</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.verify_commit", "modulename": "gitbetter.git", "qualname": "Git.verify_commit", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">verify</span><span class=\"o\">-</span><span class=\"n\">commit</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.verify_tag", "modulename": "gitbetter.git", "qualname": "Git.verify_tag", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">verify</span><span class=\"o\">-</span><span class=\"n\">tag</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.version", "modulename": "gitbetter.git", "qualname": "Git.version", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">version</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.whatchanged", "modulename": "gitbetter.git", "qualname": "Git.whatchanged", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">whatchanged</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.worktree", "modulename": "gitbetter.git", "qualname": "Git.worktree", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">worktree</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.current_branch", "modulename": "gitbetter.git", "qualname": "Git.current_branch", "kind": "variable", "doc": "<p>Returns the name of the currently active branch.</p>\n", "annotation": ": str"}, {"fullname": "gitbetter.git.Git.dob", "modulename": "gitbetter.git", "qualname": "Git.dob", "kind": "variable", "doc": "<p>Date of this repo's first commit.</p>\n", "annotation": ": datetime.datetime"}, {"fullname": "gitbetter.git.Git.origin_url", "modulename": "gitbetter.git", "qualname": "Git.origin_url", "kind": "variable", "doc": "<p>The remote origin url for this repo</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">remote</span> <span class=\"n\">get</span><span class=\"o\">-</span><span class=\"n\">url</span> <span class=\"n\">origin</span>\n</code></pre>\n</div>\n", "annotation": ": morbin.morbin.Output"}, {"fullname": "gitbetter.git.Git.add_all", "modulename": "gitbetter.git", "qualname": "Git.add_all", "kind": "function", "doc": "<p>Stage all modified and untracked files.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"o\">.</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.add_files", "modulename": "gitbetter.git", "qualname": "Git.add_files", "kind": "function", "doc": "<p>Stage a list of files.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">files</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.add_remote_url", "modulename": "gitbetter.git", "qualname": "Git.add_remote_url", "kind": "function", "doc": "<p>Add remote url to repo.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">remote</span> <span class=\"n\">add</span> <span class=\"p\">{</span><span class=\"n\">name</span><span class=\"p\">}</span> <span class=\"p\">{</span><span class=\"n\">url</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">url</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;origin&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.amend", "modulename": "gitbetter.git", "qualname": "Git.amend", "kind": "function", "doc": "<p>Stage and commit changes to the previous commit.</p>\n\n<p>If <code>files</code> is <code>None</code>, all files will be staged.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"p\">{</span><span class=\"n\">files</span><span class=\"p\">}</span> <span class=\"ow\">or</span> <span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"o\">.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">commit</span> <span class=\"o\">--</span><span class=\"n\">amend</span> <span class=\"o\">--</span><span class=\"n\">no</span><span class=\"o\">-</span><span class=\"n\">edit</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">files</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.commit_all", "modulename": "gitbetter.git", "qualname": "Git.commit_all", "kind": "function", "doc": "<p>Stage and commit all files with <code>message</code>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"o\">.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">commit</span> <span class=\"o\">-</span><span class=\"n\">m</span> <span class=\"s2\">&quot;</span><span class=\"si\">{message}</span><span class=\"s2\">&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.commit_files", "modulename": "gitbetter.git", "qualname": "Git.commit_files", "kind": "function", "doc": "<p>Commit a list of files or file patterns with commit message <code>message</code>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">commit</span> <span class=\"p\">{</span><span class=\"n\">files</span><span class=\"p\">}</span> <span class=\"o\">-</span><span class=\"n\">m</span> <span class=\"s2\">&quot;</span><span class=\"si\">{message}</span><span class=\"s2\">&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">files</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.create_new_branch", "modulename": "gitbetter.git", "qualname": "Git.create_new_branch", "kind": "function", "doc": "<p>Create and switch to a new branch named with <code>branch_name</code>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">checkout</span> <span class=\"o\">-</span><span class=\"n\">b</span> <span class=\"p\">{</span><span class=\"n\">branch_name</span><span class=\"p\">}</span> <span class=\"o\">--</span><span class=\"n\">track</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">branch_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.delete_branch", "modulename": "gitbetter.git", "qualname": "Git.delete_branch", "kind": "function", "doc": "<p>Delete <code>branch_name</code> from repo.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>local_only</code>: Only delete the local copy of <code>branch</code>, otherwise also delete the remote branch on origin and remote-tracking branch.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">branch</span> <span class=\"o\">--</span><span class=\"n\">delete</span> <span class=\"p\">{</span><span class=\"n\">branch_name</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n\n<p>Then if not <code>local_only</code>:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">push</span> <span class=\"n\">origin</span> <span class=\"o\">--</span><span class=\"n\">delete</span> <span class=\"p\">{</span><span class=\"n\">branch_name</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">branch_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">local_only</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.ignore", "modulename": "gitbetter.git", "qualname": "Git.ignore", "kind": "function", "doc": "<p>Add <code>patterns</code> to <code>.gitignore</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">patterns</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.initcommit", "modulename": "gitbetter.git", "qualname": "Git.initcommit", "kind": "function", "doc": "<p>Stage and commit <code>files</code> with the message <code>Initial commit</code>.</p>\n\n<p>If <code>files</code> is not given, all files will be added and committed.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"p\">{</span><span class=\"n\">files</span><span class=\"p\">}</span> <span class=\"ow\">or</span> <span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"o\">.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">commit</span> <span class=\"o\">-</span><span class=\"n\">m</span> <span class=\"s2\">&quot;Initial commit&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">files</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.list_branches", "modulename": "gitbetter.git", "qualname": "Git.list_branches", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">branch</span> <span class=\"o\">-</span><span class=\"n\">vva</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.loggy", "modulename": "gitbetter.git", "qualname": "Git.loggy", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">log</span> <span class=\"o\">--</span><span class=\"n\">graph</span> <span class=\"o\">--</span><span class=\"n\">abbrev</span><span class=\"o\">-</span><span class=\"n\">commit</span> <span class=\"o\">--</span><span class=\"n\">name</span><span class=\"o\">-</span><span class=\"n\">only</span> <span class=\"o\">--</span><span class=\"n\">pretty</span><span class=\"o\">=</span><span class=\"n\">tformat</span><span class=\"p\">:</span><span class=\"s1\">&#39;%C(auto)%h %C(green)(</span><span class=\"si\">%c</span><span class=\"s1\">s|</span><span class=\"si\">%c</span><span class=\"s1\">r)%C(auto)</span><span class=\"si\">%d</span><span class=\"s1\"> %C(magenta)</span><span class=\"si\">%s</span><span class=\"s1\">&#39;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.merge_to", "modulename": "gitbetter.git", "qualname": "Git.merge_to", "kind": "function", "doc": "<p>Merge the current branch with <code>branch</code> after switching to <code>branch</code>.</p>\n\n<p>i.e. If on branch <code>my-feature</code>,</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span><span class=\"o\">.</span><span class=\"n\">merge_to</span><span class=\"p\">()</span>\n</code></pre>\n</div>\n\n<p>will switch to <code>main</code> and merge <code>my-feature</code> into <code>main</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">branch</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;main&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.new_repo", "modulename": "gitbetter.git", "qualname": "Git.new_repo", "kind": "function", "doc": "<p>Initialize a new repo in current directory.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">init</span> <span class=\"o\">-</span><span class=\"n\">b</span> <span class=\"n\">main</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.push_new_branch", "modulename": "gitbetter.git", "qualname": "Git.push_new_branch", "kind": "function", "doc": "<p>Push a new branch to origin with tracking.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">push</span> <span class=\"o\">-</span><span class=\"n\">u</span> <span class=\"n\">origin</span> <span class=\"p\">{</span><span class=\"n\">branch</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">branch</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.switch_branch", "modulename": "gitbetter.git", "qualname": "Git.switch_branch", "kind": "function", "doc": "<p>Switch to the branch specified by <code>branch_name</code>.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">checkout</span> <span class=\"p\">{</span><span class=\"n\">branch_name</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">branch_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.undo", "modulename": "gitbetter.git", "qualname": "Git.undo", "kind": "function", "doc": "<p>Undo uncommitted changes.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">checkout</span> <span class=\"o\">.</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.untrack", "modulename": "gitbetter.git", "qualname": "Git.untrack", "kind": "function", "doc": "<p>Remove any number of <code>paths</code> from the index.</p>\n\n<p>Equivalent to</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rm</span> <span class=\"o\">--</span><span class=\"n\">cached</span> <span class=\"p\">{</span><span class=\"n\">path</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n\n<p>for each path in <code>paths</code>.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"o\">*</span><span class=\"n\">paths</span><span class=\"p\">:</span> <span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.rename_file", "modulename": "gitbetter.git", "qualname": "Git.rename_file", "kind": "function", "doc": "<p>Rename <code>file</code> to <code>new_name</code> and add renaming to staging index.</p>\n\n<p><code>new_name</code> should include the file suffix.</p>\n\n<p>Equivalent to renaming <code>old_file.py</code> to <code>new_file.py</code> then executing</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"n\">new_file</span><span class=\"o\">.</span><span class=\"n\">py</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rm</span> <span class=\"n\">old_file</span><span class=\"o\">.</span><span class=\"n\">py</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">new_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.create_remote", "modulename": "gitbetter.git", "qualname": "Git.create_remote", "kind": "function", "doc": "<p>Uses GitHub CLI (must be installed and configured) to create a remote GitHub repo.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>name</code>: The name for the repo.</p>\n\n<p><code>public</code>: Set to <code>True</code> to create the repo as public, otherwise it'll be created as private.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">public</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.create_remote_from_cwd", "modulename": "gitbetter.git", "qualname": "Git.create_remote_from_cwd", "kind": "function", "doc": "<p>Use GitHub CLI (must be installed and configured) to create a remote GitHub repo from\nthe current working directory repo and add its url as this repo's remote origin.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>public</code>: Create the GitHub repo as a public repo, default is to create it as private.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">public</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.delete_remote", "modulename": "gitbetter.git", "qualname": "Git.delete_remote", "kind": "function", "doc": "<p>Uses GitHub CLI (must be isntalled and configured) to delete the remote for this repo.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.make_private", "modulename": "gitbetter.git", "qualname": "Git.make_private", "kind": "function", "doc": "<p>Uses GitHub CLI (must be installed and configured) to set the repo's visibility to private.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.git.Git.make_public", "modulename": "gitbetter.git", "qualname": "Git.make_public", "kind": "function", "doc": "<p>Uses GitHub CLI (must be installed and configured) to set the repo's visibility to public.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">morbin</span><span class=\"o\">.</span><span class=\"n\">Output</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter", "modulename": "gitbetter.gitbetter", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "gitbetter.gitbetter.GitArgShell", "modulename": "gitbetter.gitbetter", "qualname": "GitArgShell", "kind": "class", "doc": "<p>Subclass this to create custom ArgShells.</p>\n", "bases": "argshell.argshell.ArgShell"}, {"fullname": "gitbetter.gitbetter.GitArgShell.do_help", "modulename": "gitbetter.gitbetter", "qualname": "GitArgShell.do_help", "kind": "function", "doc": "<p>List available commands with \"help\" or detailed help with \"help cmd\".\nIf using 'help cmd' and the cmd is decorated with a parser, the parser help will also be printed.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">arg</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter", "kind": "class", "doc": "<p>GitBetter Shell.</p>\n", "bases": "GitArgShell"}, {"fullname": "gitbetter.gitbetter.GitBetter.default", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.default", "kind": "function", "doc": "<p>Called on an input line when the command prefix is not recognized.</p>\n\n<p>If this method is not overridden, it prints an error message and\nreturns.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_cd", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_cd", "kind": "function", "doc": "<p>Change current working directory to <code>path</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_help", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_help", "kind": "function", "doc": "<p>List available commands with \"help\" or detailed help with \"help cmd\".</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">arg</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_toggle_unrecognized_command_behavior", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_toggle_unrecognized_command_behavior", "kind": "function", "doc": "<p>Toggle whether the shell will attempt to execute unrecognized commands as system commands in the terminal.\nWhen on (the default), <code>GitBetter</code> will treat unrecognized commands as if you added the <code>sys</code> command in front of the input, i.e. <code>os.system(your_input)</code>.\nWhen off, an <code>unknown syntax</code> message will be printed and no commands will be executed.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">arg</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_git", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_git", "kind": "function", "doc": "<p>Directly execute <code>git {args}</code>.</p>\n\n<p>i.e. You can still do everything directly invoking git can do.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_add", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_add", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_am", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_am", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">am</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_annotate", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_annotate", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">annotate</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_archive", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_archive", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">archive</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_bisect", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_bisect", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">bisect</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_blame", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_blame", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">blame</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_branch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_branch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">branch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_bugreport", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_bugreport", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">bugreport</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_bundle", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_bundle", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">bundle</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_checkout", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_checkout", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">checkout</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_cherry_pick", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_cherry_pick", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">cherry_pick</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_citool", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_citool", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">citool</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_clean", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_clean", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">clean</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_clone", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_clone", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">clone</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_commit", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_commit", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">commit</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_config", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_config", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">config</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_count_objects", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_count_objects", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">count_objects</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_describe", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_describe", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">describe</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_diagnose", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_diagnose", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">diagnose</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_diff", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_diff", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">diff</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_difftool", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_difftool", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">difftool</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_fast_export", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_fast_export", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fast_export</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_fast_import", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_fast_import", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fast_import</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_fetch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_fetch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fetch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_filter_branch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_filter_branch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">filter_branch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_format_patch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_format_patch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">format_patch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_fsck", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_fsck", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">fsck</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_gc", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_gc", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gc</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_gitk", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_gitk", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gitk</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_gitweb", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_gitweb", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gitweb</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_grep", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_grep", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">grep</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_gui", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_gui", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">gui</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_init", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_init", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">init</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_instaweb", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_instaweb", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">instaweb</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_log", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_log", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">log</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_maintenance", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_maintenance", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">maintenance</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_merge", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_merge", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">merge</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_merge_tree", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_merge_tree", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">merge_tree</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_mergetool", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_mergetool", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">mergetool</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_mv", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_mv", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">mv</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_notes", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_notes", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">notes</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_pack_refs", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_pack_refs", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">pack_refs</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_prune", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_prune", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">prune</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_pull", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_pull", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">pull</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_push", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_push", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">push</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_range_diff", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_range_diff", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">range_diff</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_rebase", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_rebase", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rebase</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_reflog", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_reflog", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">reflog</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_remote", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_remote", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">remote</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_repack", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_repack", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">repack</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_replace", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_replace", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">replace</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_request_pull", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_request_pull", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">request_pull</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_rerere", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_rerere", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rerere</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_reset", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_reset", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">reset</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_restore", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_restore", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">restore</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_revert", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_revert", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">revert</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_rm", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_rm", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rm</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_scalar", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_scalar", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">scalar</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_shortlog", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_shortlog", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">shortlog</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_show", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_show", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">show</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_show_branch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_show_branch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">show_branch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_sparse_checkout", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_sparse_checkout", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">sparse_checkout</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_stash", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_stash", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">stash</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_status", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_status", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">status</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_submodule", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_submodule", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">submodule</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_switch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_switch", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">switch</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_tag", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_tag", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">tag</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_verify_commit", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_verify_commit", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">verify_commit</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_verify_tag", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_verify_tag", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">verify_tag</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_version", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_version", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">version</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_whatchanged", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_whatchanged", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">whatchanged</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_worktree", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_worktree", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">worktree</span> <span class=\"p\">{</span><span class=\"n\">args</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_add_url", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_add_url", "kind": "function", "doc": "<p>Add remote origin url for repo and push repo.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">remote</span> <span class=\"n\">add</span> <span class=\"n\">origin</span> <span class=\"p\">{</span><span class=\"n\">url</span><span class=\"p\">}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">push</span> <span class=\"o\">-</span><span class=\"n\">u</span> <span class=\"n\">origin</span> <span class=\"n\">main</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">url</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_amend", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_amend", "kind": "function", "doc": "<p>Stage files and add to previous commit.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_branches", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_branches", "kind": "function", "doc": "<p>Show local and remote branches.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">branch</span> <span class=\"o\">-</span><span class=\"n\">vva</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_commitall", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_commitall", "kind": "function", "doc": "<p>Stage and commit all modified and untracked files with this message.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">add</span> <span class=\"o\">.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">commit</span> <span class=\"o\">-</span><span class=\"n\">m</span> <span class=\"s2\">&quot;</span><span class=\"si\">{message}</span><span class=\"s2\">&quot;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">message</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_delete_branch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_delete_branch", "kind": "function", "doc": "<p>Delete branch.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_delete_gh_repo", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_delete_gh_repo", "kind": "function", "doc": "<p>Delete this repo from GitHub.</p>\n\n<p>GitHub CLI must be installed and configured.</p>\n\n<p>May require you to reauthorize and rerun command.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_dob", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_dob", "kind": "function", "doc": "<p>Date of this repo's first commit.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_ignore", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_ignore", "kind": "function", "doc": "<p>Add the list of patterns/file names to <code>.gitignore</code> and commit with the message <code>chore: add to gitignore</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">patterns</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_initcommit", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_initcommit", "kind": "function", "doc": "<p>Stage and commit all files with message \"Initial Commit\".</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_loggy", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_loggy", "kind": "function", "doc": "<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"o\">--</span><span class=\"n\">oneline</span> <span class=\"o\">--</span><span class=\"n\">name</span><span class=\"o\">-</span><span class=\"n\">only</span> <span class=\"o\">--</span><span class=\"n\">abbrev</span><span class=\"o\">-</span><span class=\"n\">commit</span> <span class=\"o\">--</span><span class=\"n\">graph</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_make_private", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_make_private", "kind": "function", "doc": "<p>Make the GitHub remote for this repo private.</p>\n\n<p>This repo must exist and GitHub CLI must be installed and configured.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_make_public", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_make_public", "kind": "function", "doc": "<p>Make the GitHub remote for this repo public.</p>\n\n<p>This repo must exist and GitHub CLI must be installed and configured.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_merge_to", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_merge_to", "kind": "function", "doc": "<p>Merge the current branch into the provided branch after switching to the provided branch.</p>\n\n<p>If no branch name is given, \"main\" will be used.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">branch</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_new_branch", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_new_branch", "kind": "function", "doc": "<p>Create and switch to a new branch with this <code>name</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_new_gh_remote", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_new_gh_remote", "kind": "function", "doc": "<p>Create a remote GitHub repository for this repo.</p>\n\n<p>GitHub CLI must be installed and configured for this to work.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_new_repo", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_new_repo", "kind": "function", "doc": "<p>Create a new git repo in this directory.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_push_new", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_push_new", "kind": "function", "doc": "<p>Push current branch to origin with <code>-u</code> flag.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">push</span> <span class=\"o\">-</span><span class=\"n\">u</span> <span class=\"n\">origin</span> <span class=\"p\">{</span><span class=\"n\">this_branch</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_undo", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_undo", "kind": "function", "doc": "<p>Undo all uncommitted changes.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">checkout</span> <span class=\"o\">.</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_untrack", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_untrack", "kind": "function", "doc": "<p>Untrack files matching provided path/pattern list.</p>\n\n<p>For each path/pattern, equivalent to:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">git</span> <span class=\"n\">rm</span> <span class=\"o\">--</span><span class=\"n\">cached</span> <span class=\"p\">{</span><span class=\"n\">path</span><span class=\"p\">}</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.GitBetter.do_rename_file", "modulename": "gitbetter.gitbetter", "qualname": "GitBetter.do_rename_file", "kind": "function", "doc": "<p>Renames a file.\nAfter renaming the file, the renaming change is staged for commit.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.gitbetter.main", "modulename": "gitbetter.gitbetter", "qualname": "main", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.parsers", "modulename": "gitbetter.parsers", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "gitbetter.parsers.new_remote_parser", "modulename": "gitbetter.parsers", "qualname": "new_remote_parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.parsers.add_files_parser", "modulename": "gitbetter.parsers", "qualname": "add_files_parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.parsers.delete_branch_parser", "modulename": "gitbetter.parsers", "qualname": "delete_branch_parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "gitbetter.parsers.rename_file_parser", "modulename": "gitbetter.parsers", "qualname": "rename_file_parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();