/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.render.MultiValueRenderer;
import com.github.fge.uritemplate.vars.values.VariableValue;
import io.ray.shaded.com.google.common.collect.ImmutableList;
import io.ray.shaded.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class MapRenderer
extends MultiValueRenderer {
    public MapRenderer(ExpressionType type) {
        super(type);
    }

    @Override
    protected List<String> renderNamedExploded(String varname, VariableValue value) {
        ArrayList<String> ret = Lists.newArrayList();
        Map<String, String> map = value.getMapValue();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            StringBuilder element = new StringBuilder(this.pctEncode(entry.getKey()));
            String val = entry.getValue();
            if (val.isEmpty()) {
                element.append(this.ifEmpty);
            } else {
                element.append('=').append(this.pctEncode(val));
            }
            ret.add(element.toString());
        }
        return ret;
    }

    @Override
    protected List<String> renderUnnamedExploded(VariableValue value) {
        ArrayList<String> ret = Lists.newArrayList();
        Map<String, String> map = value.getMapValue();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ret.add(this.pctEncode(entry.getKey()) + '=' + this.pctEncode(entry.getValue()));
        }
        return ret;
    }

    @Override
    protected List<String> renderNamedNormal(String varname, VariableValue value) {
        StringBuilder sb = new StringBuilder(varname);
        if (value.isEmpty()) {
            return ImmutableList.of(sb.append(this.ifEmpty).toString());
        }
        sb.append('=');
        ArrayList<String> elements = Lists.newArrayList();
        for (String element : MapRenderer.mapAsList(value)) {
            elements.add(this.pctEncode(element));
        }
        COMMA.appendTo(sb, (Iterable<? extends Object>)elements);
        return ImmutableList.of(sb.toString());
    }

    @Override
    protected List<String> renderUnnamedNormal(VariableValue value) {
        if (value.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<String> ret = Lists.newArrayList();
        for (String element : MapRenderer.mapAsList(value)) {
            ret.add(this.pctEncode(element));
        }
        return ImmutableList.of(COMMA.join(ret));
    }

    private static List<String> mapAsList(VariableValue value) {
        ArrayList<String> ret = Lists.newArrayList();
        Map<String, String> map = value.getMapValue();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ret.add(entry.getKey());
            ret.add(entry.getValue());
        }
        return ret;
    }
}

