"""First commit.

Revision ID: 0bf7066b6d6c
Revises:
Create Date: 2023-06-12 06:03:35.453664

"""
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '0bf7066b6d6c'
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('HomeMeasurement',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(), nullable=False),
    sa.Column('consumed_energy', sa.FLOAT(), nullable=False),
    sa.Column('solar_consumed_energy', sa.FLOAT(), nullable=False),
    sa.Column('solar_produced_energy', sa.FLOAT(), nullable=False),
    sa.Column('grid_imported_energy', sa.FLOAT(), nullable=False),
    sa.Column('grid_exported_energy', sa.FLOAT(), nullable=False),
    sa.Column('date', sa.DATE(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('DeviceMeasurement',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('name', sa.VARCHAR(), nullable=False),
    sa.Column('consumed_energy', sa.FLOAT(), nullable=False),
    sa.Column('solar_consumed_energy', sa.FLOAT(), nullable=False),
    sa.Column('date', sa.DATE(), nullable=False),
    sa.Column('home_measurement_id', sa.INTEGER(), nullable=False),
    sa.ForeignKeyConstraint(['home_measurement_id'], ['HomeMeasurement.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('id', name='uq_DeviceMeasurement_id')
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('DeviceMeasurement')
    op.drop_table('HomeMeasurement')
    # ### end Alembic commands ###
