"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Defines a Lambda EventSourceMapping resource.
 *
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 *
 *    import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 *    lambda.addEventSource(new SqsEventSource(sqs));
 *
 * The `SqsEventSource` class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 */
class EventSourceMapping extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new lambda_generated_1.CfnEventSourceMapping(this, 'Resource', {
            batchSize: props.batchSize,
            enabled: props.enabled,
            eventSourceArn: props.eventSourceArn,
            functionName: props.target.functionName,
            startingPosition: props.startingPosition,
        });
    }
}
exports.EventSourceMapping = EventSourceMapping;
/**
 * The position in the DynamoDB or Kinesis stream where AWS Lambda should start
 * reading.
 */
var StartingPosition;
(function (StartingPosition) {
    /**
     * Start reading at the last untrimmed record in the shard in the system,
     * which is the oldest data record in the shard.
     */
    StartingPosition["TRIM_HORIZON"] = "TRIM_HORIZON";
    /**
     * Start reading just after the most recent record in the shard, so that you
     * always read the most recent data in the shard
     */
    StartingPosition["LATEST"] = "LATEST";
})(StartingPosition = exports.StartingPosition || (exports.StartingPosition = {}));
//# sourceMappingURL=data:application/json;base64,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