import iam = require('@aws-cdk/aws-iam');
import cdk = require('@aws-cdk/core');
import { FunctionProps } from './function';
import { FunctionBase } from './function-base';
import { Permission } from './permission';
/**
 * Properties for a newly created singleton Lambda
 */
export interface SingletonFunctionProps extends FunctionProps {
    /**
     * A unique identifier to identify this lambda
     *
     * The identifier should be unique across all custom resource providers.
     * We recommend generating a UUID per provider.
     */
    readonly uuid: string;
    /**
     * A descriptive name for the purpose of this Lambda.
     *
     * If the Lambda does not have a physical name, this string will be
     * reflected its generated name. The combination of lambdaPurpose
     * and uuid must be unique.
     *
     * @default SingletonLambda
     */
    readonly lambdaPurpose?: string;
}
/**
 * A Lambda that will only ever be added to a stack once.
 *
 * The lambda is identified using the value of 'uuid'. Run 'uuidgen'
 * for every SingletonLambda you create.
 *
 * @resource AWS::Lambda::Function
 */
export declare class SingletonFunction extends FunctionBase {
    readonly grantPrincipal: iam.IPrincipal;
    readonly functionName: string;
    readonly functionArn: string;
    readonly role?: iam.IRole;
    protected readonly canCreatePermissions: boolean;
    private lambdaFunction;
    constructor(scope: cdk.Construct, id: string, props: SingletonFunctionProps);
    addPermission(name: string, permission: Permission): void;
    private ensureLambda;
}
