"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const path = require("path");
const lambda = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-layer-version-1');
// Just for the example - granting to the current account is not necessary.
const awsAccountId = stack.account;
/// !show
const layer = new lambda.LayerVersion(stack, 'MyLayer', {
    code: lambda.Code.asset(path.join(__dirname, 'layer-code')),
    compatibleRuntimes: [lambda.Runtime.NODEJS_8_10],
    license: 'Apache-2.0',
    description: 'A layer to test the L2 construct',
});
// To grant usage by other AWS accounts
layer.addPermission('remote-account-grant', { accountId: awsAccountId });
// To grant usage to all accounts in some AWS Ogranization
// layer.grantUsage({ accountId: '*', organizationId });
new lambda.Function(stack, 'MyLayeredLambda', {
    code: new lambda.InlineCode('foo'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_8_10,
    layers: [layer],
});
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,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