"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lambda = require("../lib");
module.exports = {
    'can add same singleton Lambda multiple times, only instantiated once in template'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        for (let i = 0; i < 5; i++) {
            new lambda.SingletonFunction(stack, `Singleton${i}`, {
                uuid: '84c0de93-353f-4217-9b0b-45b6c993251a',
                code: new lambda.InlineCode('def hello(): pass'),
                runtime: lambda.Runtime.PYTHON_2_7,
                handler: 'index.hello',
                timeout: cdk.Duration.minutes(5),
            });
        }
        // THEN
        assert_1.expect(stack).to(assert_1.matchTemplate({
            Resources: {
                SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235: {
                    Type: "AWS::IAM::Role",
                    Properties: {
                        AssumeRolePolicyDocument: {
                            Statement: [
                                {
                                    Action: "sts:AssumeRole",
                                    Effect: "Allow",
                                    Principal: { Service: { "Fn::Join": ["", ["lambda.", { Ref: "AWS::URLSuffix" }]] } }
                                }
                            ],
                            Version: "2012-10-17"
                        },
                        ManagedPolicyArns: [
                            {
                                "Fn::Join": ["", ["arn:", { Ref: "AWS::Partition" }, ":iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"]]
                            }
                        ]
                    }
                },
                SingletonLambda84c0de93353f42179b0b45b6c993251a840BCC38: {
                    Type: "AWS::Lambda::Function",
                    Properties: {
                        Code: {
                            ZipFile: "def hello(): pass"
                        },
                        Handler: "index.hello",
                        Role: { "Fn::GetAtt": ["SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235", "Arn"] },
                        Runtime: "python2.7",
                        Timeout: 300
                    },
                    DependsOn: ["SingletonLambda84c0de93353f42179b0b45b6c993251aServiceRole26D59235"]
                }
            }
        }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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