# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from revengai.models.app_api_rest_v2_collections_enums_order_by import AppApiRestV2CollectionsEnumsOrderBy
from revengai.models.base_response_binary_search_response import BaseResponseBinarySearchResponse
from revengai.models.base_response_collection_search_response import BaseResponseCollectionSearchResponse
from revengai.models.base_response_function_search_response import BaseResponseFunctionSearchResponse
from revengai.models.base_response_tag_search_response import BaseResponseTagSearchResponse
from revengai.models.filters import Filters
from revengai.models.order import Order

from revengai.api_client import ApiClient, RequestSerialized
from revengai.api_response import ApiResponse
from revengai.rest import RESTResponseType


class SearchApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def search_binaries(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the binary being searched")] = None,
        partial_sha256: Annotated[Optional[StrictStr], Field(description="The partial or full sha256 of the binary being searched")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="The tags to be searched for")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        user_files_only: Annotated[Optional[StrictBool], Field(description="Whether to only search user's uploaded files")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseResponseBinarySearchResponse:
        """Binaries search

        Searches for a specific binary

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_name: The partial or full name of the binary being searched
        :type partial_name: str
        :param partial_sha256: The partial or full sha256 of the binary being searched
        :type partial_sha256: str
        :param tags: The tags to be searched for
        :type tags: List[str]
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param user_files_only: Whether to only search user's uploaded files
        :type user_files_only: bool
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_binaries_serialize(
            page=page,
            page_size=page_size,
            partial_name=partial_name,
            partial_sha256=partial_sha256,
            tags=tags,
            model_name=model_name,
            user_files_only=user_files_only,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseBinarySearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_binaries_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the binary being searched")] = None,
        partial_sha256: Annotated[Optional[StrictStr], Field(description="The partial or full sha256 of the binary being searched")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="The tags to be searched for")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        user_files_only: Annotated[Optional[StrictBool], Field(description="Whether to only search user's uploaded files")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseResponseBinarySearchResponse]:
        """Binaries search

        Searches for a specific binary

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_name: The partial or full name of the binary being searched
        :type partial_name: str
        :param partial_sha256: The partial or full sha256 of the binary being searched
        :type partial_sha256: str
        :param tags: The tags to be searched for
        :type tags: List[str]
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param user_files_only: Whether to only search user's uploaded files
        :type user_files_only: bool
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_binaries_serialize(
            page=page,
            page_size=page_size,
            partial_name=partial_name,
            partial_sha256=partial_sha256,
            tags=tags,
            model_name=model_name,
            user_files_only=user_files_only,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseBinarySearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_binaries_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the binary being searched")] = None,
        partial_sha256: Annotated[Optional[StrictStr], Field(description="The partial or full sha256 of the binary being searched")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="The tags to be searched for")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        user_files_only: Annotated[Optional[StrictBool], Field(description="Whether to only search user's uploaded files")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Binaries search

        Searches for a specific binary

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_name: The partial or full name of the binary being searched
        :type partial_name: str
        :param partial_sha256: The partial or full sha256 of the binary being searched
        :type partial_sha256: str
        :param tags: The tags to be searched for
        :type tags: List[str]
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param user_files_only: Whether to only search user's uploaded files
        :type user_files_only: bool
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_binaries_serialize(
            page=page,
            page_size=page_size,
            partial_name=partial_name,
            partial_sha256=partial_sha256,
            tags=tags,
            model_name=model_name,
            user_files_only=user_files_only,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseBinarySearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_binaries_serialize(
        self,
        page,
        page_size,
        partial_name,
        partial_sha256,
        tags,
        model_name,
        user_files_only,
        authorization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if partial_name is not None:
            
            _query_params.append(('partial_name', partial_name))
            
        if partial_sha256 is not None:
            
            _query_params.append(('partial_sha256', partial_sha256))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if model_name is not None:
            
            _query_params.append(('model_name', model_name))
            
        if user_files_only is not None:
            
            _query_params.append(('user_files_only', user_files_only))
            
        # process the header parameters
        if authorization is not None:
            _header_params['authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/search/binaries',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_collections(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_collection_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the collection being searched")] = None,
        partial_binary_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the binary belonging to the collection")] = None,
        partial_binary_sha256: Annotated[Optional[StrictStr], Field(description="The partial or full sha256 of the binary belonging to the collection")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="The tags to be searched for")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        filters: Annotated[Optional[List[Filters]], Field(description="The filters to be used for the search")] = None,
        order_by: Annotated[Optional[AppApiRestV2CollectionsEnumsOrderBy], Field(description="The field to sort the order by in the results")] = None,
        order_by_direction: Annotated[Optional[Order], Field(description="The order direction in which to return results")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseResponseCollectionSearchResponse:
        """Collections search

        Searches for a specific collection

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_collection_name: The partial or full name of the collection being searched
        :type partial_collection_name: str
        :param partial_binary_name: The partial or full name of the binary belonging to the collection
        :type partial_binary_name: str
        :param partial_binary_sha256: The partial or full sha256 of the binary belonging to the collection
        :type partial_binary_sha256: str
        :param tags: The tags to be searched for
        :type tags: List[str]
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param filters: The filters to be used for the search
        :type filters: List[Filters]
        :param order_by: The field to sort the order by in the results
        :type order_by: AppApiRestV2CollectionsEnumsOrderBy
        :param order_by_direction: The order direction in which to return results
        :type order_by_direction: Order
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_collections_serialize(
            page=page,
            page_size=page_size,
            partial_collection_name=partial_collection_name,
            partial_binary_name=partial_binary_name,
            partial_binary_sha256=partial_binary_sha256,
            tags=tags,
            model_name=model_name,
            filters=filters,
            order_by=order_by,
            order_by_direction=order_by_direction,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseCollectionSearchResponse",
            '422': "BaseResponse",
            '404': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_collections_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_collection_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the collection being searched")] = None,
        partial_binary_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the binary belonging to the collection")] = None,
        partial_binary_sha256: Annotated[Optional[StrictStr], Field(description="The partial or full sha256 of the binary belonging to the collection")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="The tags to be searched for")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        filters: Annotated[Optional[List[Filters]], Field(description="The filters to be used for the search")] = None,
        order_by: Annotated[Optional[AppApiRestV2CollectionsEnumsOrderBy], Field(description="The field to sort the order by in the results")] = None,
        order_by_direction: Annotated[Optional[Order], Field(description="The order direction in which to return results")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseResponseCollectionSearchResponse]:
        """Collections search

        Searches for a specific collection

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_collection_name: The partial or full name of the collection being searched
        :type partial_collection_name: str
        :param partial_binary_name: The partial or full name of the binary belonging to the collection
        :type partial_binary_name: str
        :param partial_binary_sha256: The partial or full sha256 of the binary belonging to the collection
        :type partial_binary_sha256: str
        :param tags: The tags to be searched for
        :type tags: List[str]
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param filters: The filters to be used for the search
        :type filters: List[Filters]
        :param order_by: The field to sort the order by in the results
        :type order_by: AppApiRestV2CollectionsEnumsOrderBy
        :param order_by_direction: The order direction in which to return results
        :type order_by_direction: Order
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_collections_serialize(
            page=page,
            page_size=page_size,
            partial_collection_name=partial_collection_name,
            partial_binary_name=partial_binary_name,
            partial_binary_sha256=partial_binary_sha256,
            tags=tags,
            model_name=model_name,
            filters=filters,
            order_by=order_by,
            order_by_direction=order_by_direction,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseCollectionSearchResponse",
            '422': "BaseResponse",
            '404': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_collections_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_collection_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the collection being searched")] = None,
        partial_binary_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the binary belonging to the collection")] = None,
        partial_binary_sha256: Annotated[Optional[StrictStr], Field(description="The partial or full sha256 of the binary belonging to the collection")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="The tags to be searched for")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        filters: Annotated[Optional[List[Filters]], Field(description="The filters to be used for the search")] = None,
        order_by: Annotated[Optional[AppApiRestV2CollectionsEnumsOrderBy], Field(description="The field to sort the order by in the results")] = None,
        order_by_direction: Annotated[Optional[Order], Field(description="The order direction in which to return results")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Collections search

        Searches for a specific collection

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_collection_name: The partial or full name of the collection being searched
        :type partial_collection_name: str
        :param partial_binary_name: The partial or full name of the binary belonging to the collection
        :type partial_binary_name: str
        :param partial_binary_sha256: The partial or full sha256 of the binary belonging to the collection
        :type partial_binary_sha256: str
        :param tags: The tags to be searched for
        :type tags: List[str]
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param filters: The filters to be used for the search
        :type filters: List[Filters]
        :param order_by: The field to sort the order by in the results
        :type order_by: AppApiRestV2CollectionsEnumsOrderBy
        :param order_by_direction: The order direction in which to return results
        :type order_by_direction: Order
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_collections_serialize(
            page=page,
            page_size=page_size,
            partial_collection_name=partial_collection_name,
            partial_binary_name=partial_binary_name,
            partial_binary_sha256=partial_binary_sha256,
            tags=tags,
            model_name=model_name,
            filters=filters,
            order_by=order_by,
            order_by_direction=order_by_direction,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseCollectionSearchResponse",
            '422': "BaseResponse",
            '404': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_collections_serialize(
        self,
        page,
        page_size,
        partial_collection_name,
        partial_binary_name,
        partial_binary_sha256,
        tags,
        model_name,
        filters,
        order_by,
        order_by_direction,
        authorization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'tags': 'multi',
            'filters': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if partial_collection_name is not None:
            
            _query_params.append(('partial_collection_name', partial_collection_name))
            
        if partial_binary_name is not None:
            
            _query_params.append(('partial_binary_name', partial_binary_name))
            
        if partial_binary_sha256 is not None:
            
            _query_params.append(('partial_binary_sha256', partial_binary_sha256))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if model_name is not None:
            
            _query_params.append(('model_name', model_name))
            
        if filters is not None:
            
            _query_params.append(('filters', filters))
            
        if order_by is not None:
            
            _query_params.append(('order_by', order_by.value))
            
        if order_by_direction is not None:
            
            _query_params.append(('order_by_direction', order_by_direction.value))
            
        # process the header parameters
        if authorization is not None:
            _header_params['authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/search/collections',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_functions(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the function being searched")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseResponseFunctionSearchResponse:
        """Functions search

        Searches for a specific function

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_name: The partial or full name of the function being searched
        :type partial_name: str
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_functions_serialize(
            page=page,
            page_size=page_size,
            partial_name=partial_name,
            model_name=model_name,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseFunctionSearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_functions_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the function being searched")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseResponseFunctionSearchResponse]:
        """Functions search

        Searches for a specific function

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_name: The partial or full name of the function being searched
        :type partial_name: str
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_functions_serialize(
            page=page,
            page_size=page_size,
            partial_name=partial_name,
            model_name=model_name,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseFunctionSearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_functions_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        partial_name: Annotated[Optional[StrictStr], Field(description="The partial or full name of the function being searched")] = None,
        model_name: Annotated[Optional[StrictStr], Field(description="The name of the model used to analyze the binary the function belongs to")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="API Key bearer token")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Functions search

        Searches for a specific function

        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param partial_name: The partial or full name of the function being searched
        :type partial_name: str
        :param model_name: The name of the model used to analyze the binary the function belongs to
        :type model_name: str
        :param authorization: API Key bearer token
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_functions_serialize(
            page=page,
            page_size=page_size,
            partial_name=partial_name,
            model_name=model_name,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseFunctionSearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_functions_serialize(
        self,
        page,
        page_size,
        partial_name,
        model_name,
        authorization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if partial_name is not None:
            
            _query_params.append(('partial_name', partial_name))
            
        if model_name is not None:
            
            _query_params.append(('model_name', model_name))
            
        # process the header parameters
        if authorization is not None:
            _header_params['authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/search/functions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_tags(
        self,
        partial_name: Annotated[StrictStr, Field(description="The partial or full name of the tag to search for")],
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BaseResponseTagSearchResponse:
        """Tags search

        Searches for tags by there name

        :param partial_name: The partial or full name of the tag to search for (required)
        :type partial_name: str
        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_tags_serialize(
            partial_name=partial_name,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseTagSearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_tags_with_http_info(
        self,
        partial_name: Annotated[StrictStr, Field(description="The partial or full name of the tag to search for")],
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BaseResponseTagSearchResponse]:
        """Tags search

        Searches for tags by there name

        :param partial_name: The partial or full name of the tag to search for (required)
        :type partial_name: str
        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_tags_serialize(
            partial_name=partial_name,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseTagSearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_tags_without_preload_content(
        self,
        partial_name: Annotated[StrictStr, Field(description="The partial or full name of the tag to search for")],
        page: Annotated[Optional[Annotated[int, Field(le=100000, strict=True, ge=1)]], Field(description="The page number to retrieve.")] = None,
        page_size: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Tags search

        Searches for tags by there name

        :param partial_name: The partial or full name of the tag to search for (required)
        :type partial_name: str
        :param page: The page number to retrieve.
        :type page: int
        :param page_size: Number of items per page.
        :type page_size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_tags_serialize(
            partial_name=partial_name,
            page=page,
            page_size=page_size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BaseResponseTagSearchResponse",
            '422': "BaseResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_tags_serialize(
        self,
        partial_name,
        page,
        page_size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if page_size is not None:
            
            _query_params.append(('page_size', page_size))
            
        if partial_name is not None:
            
            _query_params.append(('partial_name', partial_name))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKey'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v2/search/tags',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


