# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CallerFunctionInfo(BaseModel):
    """
    CallerFunctionInfo
    """ # noqa: E501
    function_id: StrictInt
    matched_function_id: Optional[StrictInt]
    dashboard_url: Optional[StrictStr]
    is_external: Optional[StrictBool] = Field(default=False, description="Indicates if the function is external")
    caller_name: StrictStr = Field(description="Name of the calling function")
    caller_vaddr: StrictStr = Field(description="Virtual address of the calling function")
    __properties: ClassVar[List[str]] = ["function_id", "matched_function_id", "dashboard_url", "is_external", "caller_name", "caller_vaddr"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallerFunctionInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if matched_function_id (nullable) is None
        # and model_fields_set contains the field
        if self.matched_function_id is None and "matched_function_id" in self.model_fields_set:
            _dict['matched_function_id'] = None

        # set to None if dashboard_url (nullable) is None
        # and model_fields_set contains the field
        if self.dashboard_url is None and "dashboard_url" in self.model_fields_set:
            _dict['dashboard_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallerFunctionInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "function_id": obj.get("function_id"),
            "matched_function_id": obj.get("matched_function_id"),
            "dashboard_url": obj.get("dashboard_url"),
            "is_external": obj.get("is_external") if obj.get("is_external") is not None else False,
            "caller_name": obj.get("caller_name"),
            "caller_vaddr": obj.get("caller_vaddr")
        })
        return _obj


