# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Vulnerability(BaseModel):
    """
    Vulnerability
    """ # noqa: E501
    vendor: StrictStr
    product: StrictStr
    version: StrictStr
    cve_number: StrictStr
    severity: StrictStr
    source: StrictStr
    cvss_version: StrictStr
    cvss_vector: StrictStr
    remarks: StrictStr
    score: Union[StrictFloat, StrictInt]
    is_unknown: Optional[StrictBool] = False
    __properties: ClassVar[List[str]] = ["vendor", "product", "version", "cve_number", "severity", "source", "cvss_version", "cvss_vector", "remarks", "score", "is_unknown"]

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CRITICAL', 'HIGH', 'MEDIUM', 'LOW', 'UNKNOWN']):
            raise ValueError("must be one of enum values ('CRITICAL', 'HIGH', 'MEDIUM', 'LOW', 'UNKNOWN')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Vulnerability from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Vulnerability from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "vendor": obj.get("vendor"),
            "product": obj.get("product"),
            "version": obj.get("version"),
            "cve_number": obj.get("cve_number"),
            "severity": obj.get("severity"),
            "source": obj.get("source"),
            "cvss_version": obj.get("cvss_version"),
            "cvss_vector": obj.get("cvss_vector"),
            "remarks": obj.get("remarks"),
            "score": obj.get("score"),
            "is_unknown": obj.get("is_unknown") if obj.get("is_unknown") is not None else False
        })
        return _obj


