# Generated by the protoc compiler with a custom plugin. DO NOT EDIT!
# sources: opentelemetry/proto/collector/metrics/v1/metrics_service.proto
#
# Copyright (c) 2012-2024 Snowflake Inc. All rights reserved.
#
# Copyright 2019, OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# This file has been generated from the original proto schema at
#
#     https://github.com/open-telemetry/opentelemetry-proto
#
# using a custom protoc compiler plugin by Snowflake Inc.

from __future__ import annotations

import struct
from typing import List

from snowflake.telemetry._internal.opentelemetry.proto.metrics.v1.metrics_marshaler import *
from snowflake.telemetry._internal.serialize import (
    Enum,
    MessageMarshaler,
    Varint,
)


class ExportMetricsServiceRequest(MessageMarshaler):
    @property
    def resource_metrics(self) -> List[ResourceMetrics]:
        if self._resource_metrics is None:
            self._resource_metrics = list()
        return self._resource_metrics

    def __init__(
        self,
        resource_metrics: List[ResourceMetrics] = None,
    ):
        self._resource_metrics: List[ResourceMetrics] = resource_metrics

    def calculate_size(self) -> int:
        size = 0
        if self._resource_metrics:
            size += sum(
                message._get_size()
                + len(b"\n")
                + Varint.size_varint_u32(message._get_size())
                for message in self._resource_metrics
            )
        return size

    def write_to(self, out: bytearray) -> None:
        if self._resource_metrics:
            for v in self._resource_metrics:
                out += b"\n"
                Varint.write_varint_u32(out, v._get_size())
                v.write_to(out)


class ExportMetricsServiceResponse(MessageMarshaler):
    @property
    def partial_success(self) -> ExportMetricsPartialSuccess:
        if self._partial_success is None:
            self._partial_success = ExportMetricsPartialSuccess()
        return self._partial_success

    def __init__(
        self,
        partial_success: ExportMetricsPartialSuccess = None,
    ):
        self._partial_success: ExportMetricsPartialSuccess = partial_success

    def calculate_size(self) -> int:
        size = 0
        if self._partial_success is not None:
            size += (
                len(b"\n")
                + Varint.size_varint_u32(self._partial_success._get_size())
                + self._partial_success._get_size()
            )
        return size

    def write_to(self, out: bytearray) -> None:
        if self._partial_success is not None:
            out += b"\n"
            Varint.write_varint_u32(out, self._partial_success._get_size())
            self._partial_success.write_to(out)


class ExportMetricsPartialSuccess(MessageMarshaler):
    rejected_data_points: int
    error_message: str

    def __init__(
        self,
        rejected_data_points: int = 0,
        error_message: str = "",
    ):
        self.rejected_data_points: int = rejected_data_points
        self.error_message: str = error_message

    def calculate_size(self) -> int:
        size = 0
        if self.rejected_data_points:
            size += len(b"\x08") + Varint.size_varint_i64(self.rejected_data_points)
        if self.error_message:
            v = self.error_message.encode("utf-8")
            size += len(b"\x12") + Varint.size_varint_u32(len(v)) + len(v)
        return size

    def write_to(self, out: bytearray) -> None:
        if self.rejected_data_points:
            out += b"\x08"
            Varint.write_varint_i64(out, self.rejected_data_points)
        if self.error_message:
            v = self.error_message.encode("utf-8")
            out += b"\x12"
            Varint.write_varint_u32(out, len(v))
            out += v
