import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Kinesis::Stream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 * @external
 */
export interface CfnStreamProps {
    /**
     * `AWS::Kinesis::Stream.ShardCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     * @external
     */
    readonly shardCount: number;
    /**
     * `AWS::Kinesis::Stream.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Kinesis::Stream.RetentionPeriodHours`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     * @external
     */
    readonly retentionPeriodHours?: number;
    /**
     * `AWS::Kinesis::Stream.StreamEncryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     * @external
     */
    readonly streamEncryption?: CfnStream.StreamEncryptionProperty | cdk.IResolvable;
    /**
     * `AWS::Kinesis::Stream.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Kinesis::Stream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 * @external
 * @cloudformationResource AWS::Kinesis::Stream
 */
export declare class CfnStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kinesis::Stream";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Kinesis::Stream.ShardCount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-shardcount
     * @external
     */
    shardCount: number;
    /**
     * `AWS::Kinesis::Stream.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Kinesis::Stream.RetentionPeriodHours`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-retentionperiodhours
     * @external
     */
    retentionPeriodHours: number | undefined;
    /**
     * `AWS::Kinesis::Stream.StreamEncryption`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-streamencryption
     * @external
     */
    streamEncryption: CfnStream.StreamEncryptionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Kinesis::Stream.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html#cfn-kinesis-stream-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Kinesis::Stream`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStreamProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kinesis::Stream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-stream.html
 * @external
 * @cloudformationResource AWS::Kinesis::Stream
 */
export declare namespace CfnStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html
     * @external
     */
    interface StreamEncryptionProperty {
        /**
         * `CfnStream.StreamEncryptionProperty.EncryptionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-encryptiontype
         * @external
         */
        readonly encryptionType: string;
        /**
         * `CfnStream.StreamEncryptionProperty.KeyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesis-stream-streamencryption.html#cfn-kinesis-stream-streamencryption-keyid
         * @external
         */
        readonly keyId: string;
    }
}
/**
 * Properties for defining a `AWS::Kinesis::StreamConsumer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html
 * @external
 */
export interface CfnStreamConsumerProps {
    /**
     * `AWS::Kinesis::StreamConsumer.ConsumerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-consumername
     * @external
     */
    readonly consumerName: string;
    /**
     * `AWS::Kinesis::StreamConsumer.StreamARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-streamarn
     * @external
     */
    readonly streamArn: string;
}
/**
 * A CloudFormation `AWS::Kinesis::StreamConsumer`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html
 * @external
 * @cloudformationResource AWS::Kinesis::StreamConsumer
 */
export declare class CfnStreamConsumer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kinesis::StreamConsumer";
    /**
     * @external
     * @cloudformationAttribute ConsumerARN
     */
    readonly attrConsumerArn: string;
    /**
     * @external
     * @cloudformationAttribute ConsumerCreationTimestamp
     */
    readonly attrConsumerCreationTimestamp: string;
    /**
     * @external
     * @cloudformationAttribute ConsumerName
     */
    readonly attrConsumerName: string;
    /**
     * @external
     * @cloudformationAttribute ConsumerStatus
     */
    readonly attrConsumerStatus: string;
    /**
     * @external
     * @cloudformationAttribute StreamARN
     */
    readonly attrStreamArn: string;
    /**
     * `AWS::Kinesis::StreamConsumer.ConsumerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-consumername
     * @external
     */
    consumerName: string;
    /**
     * `AWS::Kinesis::StreamConsumer.StreamARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesis-streamconsumer.html#cfn-kinesis-streamconsumer-streamarn
     * @external
     */
    streamArn: string;
    /**
     * Create a new `AWS::Kinesis::StreamConsumer`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStreamConsumerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
