import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * The Spot Elastigroup Resource allows you to create, update, manage, and delete Spot Elastigroups easily with CloudFormation
 *
 * @schema CfnGroupProps
 */
export interface CfnGroupProps {
    /**
     * @schema CfnGroupProps#credentials
     */
    readonly credentials: CfnGroupPropsCredentials;
    /**
     * @schema CfnGroupProps#group
     */
    readonly group?: CfnGroupPropsGroup;
}
/**
 * Converts an object of type 'CfnGroupProps' to JSON representation.
 */
export declare function toJson_CfnGroupProps(obj: CfnGroupProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsCredentials
 */
export interface CfnGroupPropsCredentials {
    /**
     * @schema CfnGroupPropsCredentials#accountId
     */
    readonly accountId?: string;
    /**
     * @schema CfnGroupPropsCredentials#accessToken
     */
    readonly accessToken?: string;
}
/**
 * Converts an object of type 'CfnGroupPropsCredentials' to JSON representation.
 */
export declare function toJson_CfnGroupPropsCredentials(obj: CfnGroupPropsCredentials | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroup
 */
export interface CfnGroupPropsGroup {
    /**
     * @schema CfnGroupPropsGroup#groupId
     */
    readonly groupId?: string;
    /**
     * The name of the elastigroup
     *
     * @schema CfnGroupPropsGroup#name
     */
    readonly name?: string;
    /**
     * The description of the elastigroup
     *
     * @schema CfnGroupPropsGroup#description
     */
    readonly description?: string;
    /**
     * @schema CfnGroupPropsGroup#region
     */
    readonly region?: string;
    /**
     * @schema CfnGroupPropsGroup#strategy
     */
    readonly strategy?: CfnGroupPropsGroupStrategy;
    /**
     * @schema CfnGroupPropsGroup#compute
     */
    readonly compute?: CfnGroupPropsGroupCompute;
    /**
     * @schema CfnGroupPropsGroup#capacity
     */
    readonly capacity?: CfnGroupPropsGroupCapacity;
    /**
     * @schema CfnGroupPropsGroup#scaling
     */
    readonly scaling?: CfnGroupPropsGroupScaling;
    /**
     * @schema CfnGroupPropsGroup#thirdPartiesIntegration
     */
    readonly thirdPartiesIntegration?: CfnGroupPropsGroupThirdPartiesIntegration;
    /**
     * @schema CfnGroupPropsGroup#scheduling
     */
    readonly scheduling?: CfnGroupPropsGroupScheduling;
}
/**
 * Converts an object of type 'CfnGroupPropsGroup' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroup(obj: CfnGroupPropsGroup | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupStrategy
 */
export interface CfnGroupPropsGroupStrategy {
    /**
     * @schema CfnGroupPropsGroupStrategy#risk
     */
    readonly risk?: number;
    /**
     * @schema CfnGroupPropsGroupStrategy#onDemandCount
     */
    readonly onDemandCount?: number;
    /**
     * @schema CfnGroupPropsGroupStrategy#availabilityVsCost
     */
    readonly availabilityVsCost?: string;
    /**
     * @schema CfnGroupPropsGroupStrategy#drainingTimeout
     */
    readonly drainingTimeout?: number;
    /**
     * @schema CfnGroupPropsGroupStrategy#fallbackToOd
     */
    readonly fallbackToOd?: boolean;
    /**
     * @schema CfnGroupPropsGroupStrategy#lifetimePeriod
     */
    readonly lifetimePeriod?: string;
    /**
     * @schema CfnGroupPropsGroupStrategy#revertToSpot
     */
    readonly revertToSpot?: CfnGroupPropsGroupStrategyRevertToSpot;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupStrategy' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupStrategy(obj: CfnGroupPropsGroupStrategy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupCompute
 */
export interface CfnGroupPropsGroupCompute {
    /**
     * @schema CfnGroupPropsGroupCompute#instanceTypes
     */
    readonly instanceTypes?: CfnGroupPropsGroupComputeInstanceTypes;
    /**
     * @schema CfnGroupPropsGroupCompute#availabilityZones
     */
    readonly availabilityZones?: CfnGroupPropsGroupComputeAvailabilityZones[];
    /**
     * @schema CfnGroupPropsGroupCompute#product
     */
    readonly product?: string;
    /**
     * @schema CfnGroupPropsGroupCompute#launchSpecification
     */
    readonly launchSpecification?: CfnGroupPropsGroupComputeLaunchSpecification;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupCompute' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupCompute(obj: CfnGroupPropsGroupCompute | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupCapacity
 */
export interface CfnGroupPropsGroupCapacity {
    /**
     * @schema CfnGroupPropsGroupCapacity#minimum
     */
    readonly minimum?: number;
    /**
     * @schema CfnGroupPropsGroupCapacity#maximum
     */
    readonly maximum?: number;
    /**
     * @schema CfnGroupPropsGroupCapacity#target
     */
    readonly target?: number;
    /**
     * @schema CfnGroupPropsGroupCapacity#unit
     */
    readonly unit?: string;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupCapacity' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupCapacity(obj: CfnGroupPropsGroupCapacity | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupScaling
 */
export interface CfnGroupPropsGroupScaling {
    /**
     * @schema CfnGroupPropsGroupScaling#up
     */
    readonly up?: ScalingPolicy[];
    /**
     * @schema CfnGroupPropsGroupScaling#down
     */
    readonly down?: ScalingPolicy[];
}
/**
 * Converts an object of type 'CfnGroupPropsGroupScaling' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupScaling(obj: CfnGroupPropsGroupScaling | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupThirdPartiesIntegration
 */
export interface CfnGroupPropsGroupThirdPartiesIntegration {
    /**
     * @schema CfnGroupPropsGroupThirdPartiesIntegration#ecs
     */
    readonly ecs?: Ecs;
    /**
     * @schema CfnGroupPropsGroupThirdPartiesIntegration#codeDeploy
     */
    readonly codeDeploy?: CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupThirdPartiesIntegration' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupThirdPartiesIntegration(obj: CfnGroupPropsGroupThirdPartiesIntegration | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupScheduling
 */
export interface CfnGroupPropsGroupScheduling {
    /**
     * @schema CfnGroupPropsGroupScheduling#tasks
     */
    readonly tasks?: Task[];
}
/**
 * Converts an object of type 'CfnGroupPropsGroupScheduling' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupScheduling(obj: CfnGroupPropsGroupScheduling | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupStrategyRevertToSpot
 */
export interface CfnGroupPropsGroupStrategyRevertToSpot {
    /**
     * @schema CfnGroupPropsGroupStrategyRevertToSpot#performAt
     */
    readonly performAt?: string;
    /**
     * @schema CfnGroupPropsGroupStrategyRevertToSpot#timeWindows
     */
    readonly timeWindows?: string[];
}
/**
 * Converts an object of type 'CfnGroupPropsGroupStrategyRevertToSpot' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupStrategyRevertToSpot(obj: CfnGroupPropsGroupStrategyRevertToSpot | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupComputeInstanceTypes
 */
export interface CfnGroupPropsGroupComputeInstanceTypes {
    /**
     * @schema CfnGroupPropsGroupComputeInstanceTypes#onDemand
     */
    readonly onDemand?: string;
    /**
     * @schema CfnGroupPropsGroupComputeInstanceTypes#spot
     */
    readonly spot?: string[];
}
/**
 * Converts an object of type 'CfnGroupPropsGroupComputeInstanceTypes' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupComputeInstanceTypes(obj: CfnGroupPropsGroupComputeInstanceTypes | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupComputeAvailabilityZones
 */
export interface CfnGroupPropsGroupComputeAvailabilityZones {
    /**
     * @schema CfnGroupPropsGroupComputeAvailabilityZones#name
     */
    readonly name?: string;
    /**
     * @schema CfnGroupPropsGroupComputeAvailabilityZones#subnetIds
     */
    readonly subnetIds?: string[];
}
/**
 * Converts an object of type 'CfnGroupPropsGroupComputeAvailabilityZones' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupComputeAvailabilityZones(obj: CfnGroupPropsGroupComputeAvailabilityZones | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupComputeLaunchSpecification
 */
export interface CfnGroupPropsGroupComputeLaunchSpecification {
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#securityGroupIds
     */
    readonly securityGroupIds?: string[];
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#loadBalancersConfig
     */
    readonly loadBalancersConfig?: CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfig;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#healthCheckUnhealthyDurationBeforeReplacement
     */
    readonly healthCheckUnhealthyDurationBeforeReplacement?: number;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#monitoring
     */
    readonly monitoring?: boolean;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#ebsOptimized
     */
    readonly ebsOptimized?: boolean;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#imageId
     */
    readonly imageId?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#keyPair
     */
    readonly keyPair?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#userData
     */
    readonly userData?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#shutdownScript
     */
    readonly shutdownScript?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#tags
     */
    readonly tags?: Tag[];
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#healthCheckType
     */
    readonly healthCheckType?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#healthCheckGracePeriod
     */
    readonly healthCheckGracePeriod?: number;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#tenancy
     */
    readonly tenancy?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#blockDeviceMappings
     */
    readonly blockDeviceMappings?: BlockDeviceMapping[];
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecification#iamRole
     */
    readonly iamRole?: CfnGroupPropsGroupComputeLaunchSpecificationIamRole;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupComputeLaunchSpecification' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupComputeLaunchSpecification(obj: CfnGroupPropsGroupComputeLaunchSpecification | undefined): Record<string, any> | undefined;
/**
 * @schema ScalingPolicy
 */
export interface ScalingPolicy {
    /**
     * @schema ScalingPolicy#policyName
     */
    readonly policyName?: string;
    /**
     * @schema ScalingPolicy#metricName
     */
    readonly metricName?: string;
    /**
     * @schema ScalingPolicy#statistic
     */
    readonly statistic?: string;
    /**
     * @schema ScalingPolicy#unit
     */
    readonly unit?: string;
    /**
     * @schema ScalingPolicy#threshold
     */
    readonly threshold?: number;
    /**
     * @schema ScalingPolicy#namespace
     */
    readonly namespace?: string;
    /**
     * @schema ScalingPolicy#period
     */
    readonly period?: number;
    /**
     * @schema ScalingPolicy#evaluationPeriods
     */
    readonly evaluationPeriods?: number;
    /**
     * @schema ScalingPolicy#cooldown
     */
    readonly cooldown?: number;
    /**
     * @schema ScalingPolicy#dimension
     */
    readonly dimension?: ScalingPolicyDimension[];
    /**
     * @schema ScalingPolicy#action
     */
    readonly action?: ScalingPolicyAction;
}
/**
 * Converts an object of type 'ScalingPolicy' to JSON representation.
 */
export declare function toJson_ScalingPolicy(obj: ScalingPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema ecs
 */
export interface Ecs {
    /**
     * @schema ecs#clusterName
     */
    readonly clusterName?: string;
    /**
     * @schema ecs#autoScale
     */
    readonly autoScale?: EcsAutoScale;
    /**
     * @schema ecs#batch
     */
    readonly batch?: EcsBatch;
    /**
     * @schema ecs#optimizeImages
     */
    readonly optimizeImages?: EcsOptimizeImages;
}
/**
 * Converts an object of type 'Ecs' to JSON representation.
 */
export declare function toJson_Ecs(obj: Ecs | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy
 */
export interface CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy {
    /**
     * @schema CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy#cleanUpOnFailure
     */
    readonly cleanUpOnFailure?: boolean;
    /**
     * @schema CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy#terminateInstanceOnFailure
     */
    readonly terminateInstanceOnFailure?: boolean;
    /**
     * @schema CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy#deploymentGroups
     */
    readonly deploymentGroups?: CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups[];
}
/**
 * Converts an object of type 'CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy(obj: CfnGroupPropsGroupThirdPartiesIntegrationCodeDeploy | undefined): Record<string, any> | undefined;
/**
 * @schema Task
 */
export interface Task {
    /**
     * @schema Task#isEnabled
     */
    readonly isEnabled?: boolean;
    /**
     * @schema Task#taskType
     */
    readonly taskType?: string;
    /**
     * @schema Task#cronExpression
     */
    readonly cronExpression?: string;
    /**
     * @schema Task#scaleTargetCapacity
     */
    readonly scaleTargetCapacity?: number;
    /**
     * @schema Task#scaleMinCapacity
     */
    readonly scaleMinCapacity?: number;
    /**
     * @schema Task#scaleMaxCapacity
     */
    readonly scaleMaxCapacity?: number;
    /**
     * @schema Task#batchSizePercentage
     */
    readonly batchSizePercentage?: number;
    /**
     * @schema Task#gracePeriod
     */
    readonly gracePeriod?: number;
    /**
     * @schema Task#frequency
     */
    readonly frequency?: string;
    /**
     * @schema Task#startTime
     */
    readonly startTime?: string;
    /**
     * @schema Task#adjustment
     */
    readonly adjustment?: number;
}
/**
 * Converts an object of type 'Task' to JSON representation.
 */
export declare function toJson_Task(obj: Task | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfig
 */
export interface CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfig {
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfig#loadBalancers
     */
    readonly loadBalancers?: CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers[];
}
/**
 * Converts an object of type 'CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfig' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfig(obj: CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfig | undefined): Record<string, any> | undefined;
/**
 * @schema Tag
 */
export interface Tag {
    /**
     * @schema Tag#tagKey
     */
    readonly tagKey?: string;
    /**
     * @schema Tag#tagValue
     */
    readonly tagValue?: string;
}
/**
 * Converts an object of type 'Tag' to JSON representation.
 */
export declare function toJson_Tag(obj: Tag | undefined): Record<string, any> | undefined;
/**
 * @schema BlockDeviceMapping
 */
export interface BlockDeviceMapping {
    /**
     * @schema BlockDeviceMapping#deviceName
     */
    readonly deviceName?: string;
    /**
     * @schema BlockDeviceMapping#noDevice
     */
    readonly noDevice?: string;
    /**
     * @schema BlockDeviceMapping#virtualName
     */
    readonly virtualName?: string;
    /**
     * @schema BlockDeviceMapping#ebs
     */
    readonly ebs?: BlockDeviceMappingEbs;
}
/**
 * Converts an object of type 'BlockDeviceMapping' to JSON representation.
 */
export declare function toJson_BlockDeviceMapping(obj: BlockDeviceMapping | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupComputeLaunchSpecificationIamRole
 */
export interface CfnGroupPropsGroupComputeLaunchSpecificationIamRole {
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationIamRole#name
     */
    readonly name?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationIamRole#arn
     */
    readonly arn?: string;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupComputeLaunchSpecificationIamRole' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupComputeLaunchSpecificationIamRole(obj: CfnGroupPropsGroupComputeLaunchSpecificationIamRole | undefined): Record<string, any> | undefined;
/**
 * @schema ScalingPolicyDimension
 */
export interface ScalingPolicyDimension {
    /**
     * @schema ScalingPolicyDimension#name
     */
    readonly name?: string;
    /**
     * @schema ScalingPolicyDimension#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'ScalingPolicyDimension' to JSON representation.
 */
export declare function toJson_ScalingPolicyDimension(obj: ScalingPolicyDimension | undefined): Record<string, any> | undefined;
/**
 * @schema ScalingPolicyAction
 */
export interface ScalingPolicyAction {
    /**
     * @schema ScalingPolicyAction#type
     */
    readonly type?: string;
    /**
     * @schema ScalingPolicyAction#adjustment
     */
    readonly adjustment?: string;
    /**
     * @schema ScalingPolicyAction#minTargetCapacity
     */
    readonly minTargetCapacity?: string;
    /**
     * @schema ScalingPolicyAction#target
     */
    readonly target?: string;
    /**
     * @schema ScalingPolicyAction#minimum
     */
    readonly minimum?: string;
    /**
     * @schema ScalingPolicyAction#maximum
     */
    readonly maximum?: string;
}
/**
 * Converts an object of type 'ScalingPolicyAction' to JSON representation.
 */
export declare function toJson_ScalingPolicyAction(obj: ScalingPolicyAction | undefined): Record<string, any> | undefined;
/**
 * @schema EcsAutoScale
 */
export interface EcsAutoScale {
    /**
     * @schema EcsAutoScale#isEnabled
     */
    readonly isEnabled?: boolean;
    /**
     * @schema EcsAutoScale#cooldown
     */
    readonly cooldown?: number;
    /**
     * @schema EcsAutoScale#isAutoConfig
     */
    readonly isAutoConfig?: boolean;
    /**
     * @schema EcsAutoScale#shouldScaleDownNonServiceTasks
     */
    readonly shouldScaleDownNonServiceTasks?: boolean;
    /**
     * @schema EcsAutoScale#headroom
     */
    readonly headroom?: EcsAutoScaleHeadroom;
    /**
     * @schema EcsAutoScale#down
     */
    readonly down?: EcsAutoScaleDown;
    /**
     * @schema EcsAutoScale#attributes
     */
    readonly attributes?: Attribute[];
}
/**
 * Converts an object of type 'EcsAutoScale' to JSON representation.
 */
export declare function toJson_EcsAutoScale(obj: EcsAutoScale | undefined): Record<string, any> | undefined;
/**
 * @schema EcsBatch
 */
export interface EcsBatch {
    /**
     * @schema EcsBatch#jobQueueNames
     */
    readonly jobQueueNames?: string[];
}
/**
 * Converts an object of type 'EcsBatch' to JSON representation.
 */
export declare function toJson_EcsBatch(obj: EcsBatch | undefined): Record<string, any> | undefined;
/**
 * @schema EcsOptimizeImages
 */
export interface EcsOptimizeImages {
    /**
     * @schema EcsOptimizeImages#shouldOptimizeEcsAmi
     */
    readonly shouldOptimizeEcsAmi?: boolean;
    /**
     * @schema EcsOptimizeImages#performAt
     */
    readonly performAt?: string;
    /**
     * @schema EcsOptimizeImages#timeWindows
     */
    readonly timeWindows?: string[];
}
/**
 * Converts an object of type 'EcsOptimizeImages' to JSON representation.
 */
export declare function toJson_EcsOptimizeImages(obj: EcsOptimizeImages | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups
 */
export interface CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups {
    /**
     * @schema CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups#applicationName
     */
    readonly applicationName?: string;
    /**
     * @schema CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups#deploymentGroupName
     */
    readonly deploymentGroupName?: string;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups(obj: CfnGroupPropsGroupThirdPartiesIntegrationCodeDeployDeploymentGroups | undefined): Record<string, any> | undefined;
/**
 * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers
 */
export interface CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers {
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers#name
     */
    readonly name?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers#arn
     */
    readonly arn?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers#type
     */
    readonly type?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers#balancerId
     */
    readonly balancerId?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers#targetSetId
     */
    readonly targetSetId?: string;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers#azAwareness
     */
    readonly azAwareness?: boolean;
    /**
     * @schema CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers#autoWeight
     */
    readonly autoWeight?: boolean;
}
/**
 * Converts an object of type 'CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers' to JSON representation.
 */
export declare function toJson_CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers(obj: CfnGroupPropsGroupComputeLaunchSpecificationLoadBalancersConfigLoadBalancers | undefined): Record<string, any> | undefined;
/**
 * @schema BlockDeviceMappingEbs
 */
export interface BlockDeviceMappingEbs {
    /**
     * @schema BlockDeviceMappingEbs#deleteOnTermination
     */
    readonly deleteOnTermination?: boolean;
    /**
     * @schema BlockDeviceMappingEbs#encrypted
     */
    readonly encrypted?: boolean;
    /**
     * @schema BlockDeviceMappingEbs#iops
     */
    readonly iops?: number;
    /**
     * @schema BlockDeviceMappingEbs#snapshotId
     */
    readonly snapshotId?: string;
    /**
     * @schema BlockDeviceMappingEbs#volumeSize
     */
    readonly volumeSize?: number;
    /**
     * @schema BlockDeviceMappingEbs#volumeType
     */
    readonly volumeType?: BlockDeviceMappingEbsVolumeType;
}
/**
 * Converts an object of type 'BlockDeviceMappingEbs' to JSON representation.
 */
export declare function toJson_BlockDeviceMappingEbs(obj: BlockDeviceMappingEbs | undefined): Record<string, any> | undefined;
/**
 * @schema EcsAutoScaleHeadroom
 */
export interface EcsAutoScaleHeadroom {
    /**
     * @schema EcsAutoScaleHeadroom#cpuPerUnit
     */
    readonly cpuPerUnit?: number;
    /**
     * @schema EcsAutoScaleHeadroom#memoryPerUnit
     */
    readonly memoryPerUnit?: number;
    /**
     * @schema EcsAutoScaleHeadroom#numOfUnits
     */
    readonly numOfUnits?: number;
}
/**
 * Converts an object of type 'EcsAutoScaleHeadroom' to JSON representation.
 */
export declare function toJson_EcsAutoScaleHeadroom(obj: EcsAutoScaleHeadroom | undefined): Record<string, any> | undefined;
/**
 * @schema EcsAutoScaleDown
 */
export interface EcsAutoScaleDown {
    /**
     * @schema EcsAutoScaleDown#evaluationPeriods
     */
    readonly evaluationPeriods?: number;
    /**
     * @schema EcsAutoScaleDown#maxScaleDownPercentage
     */
    readonly maxScaleDownPercentage?: number;
}
/**
 * Converts an object of type 'EcsAutoScaleDown' to JSON representation.
 */
export declare function toJson_EcsAutoScaleDown(obj: EcsAutoScaleDown | undefined): Record<string, any> | undefined;
/**
 * @schema Attribute
 */
export interface Attribute {
    /**
     * @schema Attribute#key
     */
    readonly key?: string;
    /**
     * @schema Attribute#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'Attribute' to JSON representation.
 */
export declare function toJson_Attribute(obj: Attribute | undefined): Record<string, any> | undefined;
/**
 * @schema BlockDeviceMappingEbsVolumeType
 */
export declare enum BlockDeviceMappingEbsVolumeType {
    /** standard */
    STANDARD = "standard",
    /** io1 */
    IO1 = "io1",
    /** gp2 */
    GP2 = "gp2"
}
/**
 * A CloudFormation `Spot::Elastigroup::Group`
 *
 * @cloudformationResource Spot::Elastigroup::Group
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnGroup extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Spot::Elastigroup::Group";
    /**
     * Resource props.
     */
    readonly props: CfnGroupProps;
    /**
     * Create a new `Spot::Elastigroup::Group`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnGroupProps);
}
