#  FileName    : pinyin.py 
#  Author      : Feather.et.ELF <andelf@139.com> 
#  Created     : Fri Oct  8 22:13:27 2010 by Feather.et.ELF 
#  Copyright   : Feather Workshop (c) 2010 
#  Description : Chinese Pinyin unicode mapping
#  Time-stamp: <2010-10-08 23:48:20 andelf> 

"""
NOTE: this file is last modified by andelf <andelf@gmail.com>
      * remove multiple pronunciation (I choose mostly used pronunciation here)
      * add some punctuate
      * generate unicode numbers
"""
PinYinDict = { 12289:'-', 12290:'-', 12296:'', 12297:'', 12298:'', 12299:'',
    19968:'yi', 19969:'ding', 19971:'qi', 19975:'wan', 19976:'zhang',
    19977:'san', 19978:'shang', 19979:'xia', 19980:'ji', 19981:'bu', 19982:'yu',
    19984:'gai', 19985:'chou', 19987:'zhuan', 19988:'qie', 19989:'pi',
    19990:'shi', 19992:'qiu', 19993:'bing', 19994:'ye', 19995:'cong',
    19996:'dong', 19997:'si', 19998:'cheng', 20002:'diu', 20004:'liang',
    20005:'yan', 20007:'sang', 20008:'shu', 20010:'ge', 20011:'ya', 20012:'pan',
    20013:'zhong', 20016:'feng', 20018:'chuan', 20020:'lin', 20022:'zhu',
    20024:'wan', 20025:'dan', 20026:'wei', 20027:'zhu', 20029:'li', 20030:'ju',
    20031:'pie', 20035:'nai', 20037:'jiu', 20039:'tuo', 20040:'me', 20041:'yi',
    20043:'zhi', 20044:'wu', 20045:'zha', 20046:'hu', 20047:'fa', 20048:'yue',
    20050:'ping', 20051:'pang', 20052:'qiao', 20054:'guai', 20056:'cheng',
    20057:'yi', 20060:'mie', 20061:'jiu', 20062:'qi', 20063:'ye', 20064:'xi',
    20065:'xiang', 20070:'shu', 20073:'ji', 20080:'mai', 20081:'luan',
    20083:'ru', 20094:'qian', 20102:'le', 20104:'yu', 20105:'zheng',
    20107:'shi', 20108:'er', 20109:'chu', 20110:'yu', 20111:'kui', 20113:'yun',
    20114:'hu', 20115:'qi', 20116:'wu', 20117:'jing', 20120:'gen', 20122:'ya',
    20123:'xie', 20127:'ji', 20128:'tou', 20129:'wang', 20130:'kang',
    20132:'jiao', 20133:'hai', 20134:'yi', 20135:'chan', 20136:'heng',
    20137:'mu', 20139:'xiang', 20140:'jing', 20141:'ting', 20142:'liang',
    20146:'qin', 20147:'bo', 20149:'xie', 20154:'ren', 20155:'ren', 20159:'yi',
    20160:'shen', 20161:'ren', 20162:'le', 20163:'ding', 20164:'ze',
    20165:'jin', 20166:'pu', 20167:'chou', 20169:'zhang', 20170:'jin',
    20171:'jie', 20173:'reng', 20174:'cong', 20177:'lun', 20179:'cang',
    20180:'zi', 20181:'shi', 20182:'ta', 20183:'zhang', 20184:'fu',
    20185:'xian', 20189:'tong', 20190:'ren', 20191:'qian', 20193:'ge',
    20195:'dai', 20196:'ling', 20197:'yi', 20200:'sa', 20202:'yi', 20203:'mu',
    20204:'men', 20208:'yang', 20210:'zhong', 20211:'pi', 20213:'wu',
    20214:'jian', 20215:'jia', 20219:'ren', 20221:'fen', 20223:'fang',
    20225:'qi', 20233:'kang', 20234:'yi', 20237:'wu', 20238:'ji', 20239:'fu',
    20240:'fa', 20241:'xiu', 20247:'zhong', 20248:'you', 20249:'huo',
    20250:'hui', 20251:'yu', 20254:'san', 20255:'wei', 20256:'chuan',
    20258:'ya', 20260:'shang', 20261:'chang', 20262:'lun', 20263:'cang',
    20266:'wei', 20267:'zhu', 20271:'bo', 20272:'gu', 20274:'ni', 20276:'ban',
    20278:'ling', 20280:'shen', 20282:'ci', 20284:'si', 20285:'ga',
    20291:'dian', 20294:'dan', 20301:'wei', 20302:'di', 20303:'zhu',
    20304:'zuo', 20305:'you', 20307:'ti', 20309:'he', 20311:'tuo', 20312:'she',
    20313:'yu', 20314:'yi', 20315:'fo', 20316:'zuo', 20317:'gou', 20318:'ning',
    20319:'tong', 20320:'ni', 20323:'yong', 20324:'wa', 20325:'qian',
    20327:'ka', 20329:'pei', 20332:'lao', 20335:'yang', 20336:'bai',
    20339:'jia', 20340:'nai', 20342:'ji', 20347:'tiao', 20348:'jiao',
    20350:'yi', 20351:'shi', 20355:'kan', 20356:'zhi', 20360:'chi', 20361:'kua',
    20363:'li', 20365:'shi', 20367:'zhu', 20369:'you', 20372:'mou',
    20375:'dong', 20379:'gong', 20381:'yi', 20384:'xia', 20387:'lv',
    20389:'jiao', 20390:'zhen', 20391:'ce', 20392:'qiao', 20393:'kuai',
    20394:'chai', 20396:'nong', 20398:'wu', 20399:'hou', 20405:'qin',
    20415:'bian', 20419:'cu', 20420:'e', 20421:'qiu', 20426:'jun', 20430:'zu',
    20431:'qiao', 20432:'li', 20433:'yong', 20439:'su', 20440:'fu', 20442:'li',
    20444:'ping', 20445:'bao', 20446:'yu', 20447:'si', 20449:'xin', 20451:'yu',
    20454:'chou', 20456:'yan', 20457:'liang', 20458:'li', 20461:'jian',
    20462:'xiu', 20463:'fu', 20465:'ju', 20467:'pai', 20472:'feng', 20474:'an',
    20478:'bi', 20492:'guan', 20493:'bei', 20495:'shu', 20498:'dao',
    20500:'jue', 20504:'tang', 20505:'hou', 20506:'yi', 20508:'ti', 20511:'jie',
    20513:'chang', 20517:'kong', 20518:'juan', 20520:'ju', 20521:'qian',
    20522:'ni', 20524:'zhuo', 20525:'wo', 20526:'luo', 20538:'zhai',
    20540:'zhi', 20542:'qing', 20547:'yan', 20551:'jia', 20552:'jie',
    20556:'ruo', 20558:'wei', 20559:'pian', 20565:'xie', 20570:'zuo',
    20572:'ting', 20581:'jian', 20588:'zong', 20598:'ou', 20599:'tou',
    20603:'lv', 20606:'fen', 20607:'chang', 20608:'kui', 20613:'fu', 20616:'li',
    20621:'bang', 20643:'dai', 20645:'tang', 20647:'bin', 20648:'chu',
    20649:'nuo', 20652:'cui', 20658:'ao', 20666:'chi', 20667:'sha',
    20687:'xiang', 20694:'xi', 20698:'liao', 20710:'jiu', 20711:'seng',
    20716:'jiao', 20717:'jian', 20718:'tong', 20723:'su', 20725:'jiang',
    20731:'pi', 20742:'jing', 20743:'xuan', 20747:'dan', 20754:'ru',
    20769:'lei', 20799:'er', 20800:'wu', 20801:'yun', 20803:'yuan',
    20804:'xiong', 20805:'chong', 20806:'zhao', 20808:'xian', 20809:'guang',
    20811:'ke', 20813:'mian', 20817:'dui', 20820:'tu', 20821:'si', 20822:'yan',
    20826:'dang', 20828:'dou', 20834:'jing', 20837:'ru', 20840:'quan',
    20843:'ba', 20844:'gong', 20845:'liu', 20846:'xi', 20848:'lan',
    20849:'gong', 20851:'guan', 20852:'xing', 20853:'bing', 20854:'qi',
    20855:'ju', 20856:'dian', 20857:'zi', 20859:'yang', 20860:'jian',
    20861:'shou', 20864:'ji', 20865:'chan', 20866:'jiong', 20869:'nei',
    20872:'gang', 20873:'ran', 20876:'ce', 20877:'zai', 20882:'mao',
    20885:'mian', 20886:'mi', 20887:'rong', 20889:'xie', 20891:'jun',
    20892:'nong', 20896:'guan', 20898:'zhong', 20900:'yuan', 20901:'ming',
    20907:'bing', 20908:'dong', 20911:'feng', 20912:'bing', 20913:'hu',
    20914:'chong', 20915:'jue', 20917:'kuang', 20918:'ye', 20919:'leng',
    20923:'dong', 20924:'xian', 20925:'lie', 20928:'jing', 20932:'qi',
    20934:'zhun', 20935:'song', 20937:'liang', 20939:'diao', 20940:'ling',
    20943:'jian', 20945:'cou', 20955:'lin', 20957:'ning', 20960:'ji',
    20961:'fan', 20964:'feng', 20971:'fu', 20973:'ping', 20975:'kai',
    20976:'huang', 20979:'deng', 20981:'kan', 20982:'xiong', 20984:'tu',
    20985:'ao', 20986:'chu', 20987:'ji', 20988:'dang', 20989:'han', 20991:'zao',
    20992:'dao', 20993:'diao', 20994:'dao', 20995:'ren', 20998:'fen',
    20999:'qie', 21000:'yi', 21002:'kan', 21005:'chu', 21006:'wen',
    21009:'xing', 21010:'hua', 21014:'yue', 21015:'lie', 21016:'liu',
    21017:'ze', 21018:'gang', 21019:'chuang', 21021:'chu', 21024:'shan',
    21028:'pan', 21032:'pao', 21033:'li', 21035:'bie', 21037:'jing',
    21038:'gua', 21040:'dao', 21043:'ku', 21046:'zhi', 21047:'shua',
    21048:'quan', 21049:'sha', 21050:'ci', 21051:'ke', 21053:'gui', 21055:'gui',
    21056:'kai', 21057:'duo', 21058:'ji', 21059:'ti', 21066:'xiao', 21068:'la',
    21069:'qian', 21072:'gua', 21073:'jian', 21076:'ti', 21078:'pou',
    21084:'wan', 21086:'ji', 21089:'yan', 21093:'bo', 21095:'ju', 21097:'sheng',
    21098:'jian', 21103:'fu', 21106:'ge', 21117:'piao', 21119:'jiao',
    21121:'qiao', 21122:'jue', 21128:'pi', 21136:'huo', 21139:'yi', 21147:'li',
    21149:'quan', 21150:'ban', 21151:'gong', 21152:'jia', 21153:'wu',
    21154:'mai', 21155:'lie', 21160:'dong', 21161:'zhu', 21162:'nu',
    21163:'jie', 21164:'qu', 21165:'shao', 21169:'li', 21170:'jin', 21171:'lao',
    21182:'he', 21183:'shi', 21187:'bo', 21191:'yong', 21193:'mian',
    21195:'xun', 21200:'meng', 21202:'le', 21206:'xu', 21208:'kan', 21215:'mu',
    21220:'qin', 21232:'xie', 21241:'bao', 21242:'shao', 21246:'gou',
    21247:'wu', 21248:'yun', 21253:'bao', 21254:'cong', 21256:'xiong',
    21261:'pu', 21263:'pao', 21264:'fu', 21269:'bi', 21270:'hua', 21271:'bei',
    21273:'shi', 21274:'fang', 21277:'za', 21280:'jiang', 21281:'kuang',
    21283:'xia', 21286:'gui', 21290:'fei', 21294:'kui', 21305:'pi', 21306:'qu',
    21307:'yi', 21310:'bian', 21311:'ni', 21313:'shi', 21315:'qian', 21317:'sa',
    21319:'sheng', 21320:'wu', 21321:'hui', 21322:'ban', 21326:'hua',
    21327:'xie', 21329:'bei', 21330:'zu', 21331:'zhuo', 21333:'dan',
    21334:'mai', 21335:'nan', 21338:'bo', 21340:'bo', 21342:'bian', 21343:'bu',
    21344:'zhan', 21345:'ka', 21346:'lu', 21347:'you', 21348:'lu', 21350:'gua',
    21351:'wo', 21353:'jie', 21355:'wei', 21358:'zhi', 21359:'mao', 21360:'yin',
    21361:'wei', 21363:'ji', 21364:'que', 21365:'luan', 21367:'juan',
    21368:'xie', 21370:'jin', 21375:'qing', 21378:'chang', 21380:'e',
    21381:'ting', 21382:'li', 21385:'li', 21387:'ya', 21388:'yan', 21389:'she',
    21397:'ce', 21400:'li', 21402:'hou', 21405:'cuo', 21407:'yuan',
    21410:'xiang', 21411:'yan', 21413:'jue', 21414:'xia', 21416:'chu',
    21417:'jiu', 21422:'si', 21430:'si', 21435:'qu', 21439:'xian', 21441:'san',
    21442:'can', 21448:'you', 21449:'cha', 21450:'ji', 21451:'you',
    21452:'shuang', 21453:'fan', 21457:'fa', 21460:'shu', 21462:'qu',
    21463:'shou', 21464:'bian', 21465:'xu', 21467:'pan', 21471:'sou',
    21472:'die', 21475:'kou', 21476:'gu', 21477:'ju', 21478:'ling', 21480:'dao',
    21481:'kou', 21482:'zhi', 21483:'jiao', 21484:'zhao', 21485:'ba',
    21486:'ding', 21487:'ke', 21488:'tai', 21489:'chi', 21490:'shi',
    21491:'you', 21493:'po', 21494:'ye', 21495:'hao', 21496:'si', 21497:'tan',
    21499:'le', 21500:'diao', 21501:'ji', 21505:'xu', 21507:'chi', 21508:'ge',
    21510:'yao', 21512:'he', 21513:'ji', 21514:'diao', 21516:'tong',
    21517:'ming', 21518:'hou', 21519:'li', 21520:'tu', 21521:'xiang',
    21522:'zha', 21523:'xia', 21525:'lv', 21526:'a', 21527:'ma', 21531:'jun',
    21533:'lin', 21534:'tun', 21535:'yin', 21536:'fei', 21537:'bi', 21539:'qin',
    21542:'fou', 21543:'ba', 21544:'dun', 21545:'fen', 21547:'han',
    21548:'ting', 21549:'keng', 21550:'shun', 21551:'qi', 21553:'zhi',
    21554:'yin', 21556:'wu', 21557:'chao', 21560:'xi', 21561:'chui',
    21563:'wen', 21564:'hou', 21566:'wu', 21568:'ya', 21571:'e', 21574:'dai',
    21576:'cheng', 21578:'gao', 21579:'fu', 21584:'na', 21586:'fu', 21587:'yi',
    21588:'dai', 21589:'ou', 21590:'li', 21591:'bei', 21592:'yuan', 21593:'guo',
    21595:'qiang', 21596:'wu', 21602:'ne', 21604:'ling', 21606:'you',
    21608:'zhou', 21617:'gua', 21618:'ci', 21619:'wei', 21621:'he', 21622:'nao',
    21623:'xia', 21624:'pei', 21627:'shen', 21628:'hu', 21629:'ming',
    21632:'ju', 21634:'za', 21636:'duo', 21638:'pao', 21643:'za', 21644:'he',
    21646:'jiu', 21647:'yong', 21648:'fu', 21650:'zhou', 21652:'ka', 21653:'gu',
    21654:'ka', 21657:'long', 21658:'dong', 21659:'ning', 21661:'si',
    21667:'guang', 21668:'zha', 21670:'yi', 21671:'lie', 21672:'zi',
    21673:'mie', 21674:'mi', 21675:'zhi', 21676:'yao', 21677:'ji', 21679:'lo',
    21681:'zan', 21683:'ke', 21684:'hui', 21688:'xian', 21691:'xiu',
    21693:'yan', 21695:'yi', 21696:'ai', 21697:'pin', 21698:'shen',
    21700:'hong', 21702:'duo', 21703:'wa', 21704:'ha', 21705:'zai', 21708:'pai',
    21709:'xiang', 21710:'ai', 21711:'gen', 21712:'kuang', 21713:'ya',
    21714:'da', 21715:'xiao', 21716:'bi', 21717:'yue', 21719:'hua',
    21721:'kuai', 21722:'duo', 21724:'ji', 21725:'nong', 21726:'mou',
    21727:'yo', 21733:'ge', 21734:'o', 21735:'chi', 21736:'shao', 21737:'li',
    21738:'na', 21741:'ku', 21742:'xiao', 21746:'zhe', 21747:'zha', 21754:'bu',
    21756:'heng', 21757:'geng', 21759:'ge', 21761:'yan', 21766:'suo',
    21767:'chun', 21769:'ai', 21775:'xi', 21776:'tang', 21777:'zuo', 21780:'wu',
    21787:'ma', 21792:'lao', 21794:'suo', 21795:'zao', 21796:'huan', 21799:'ji',
    21802:'feng', 21804:'hu', 21806:'shou', 21807:'wei', 21808:'shua',
    21809:'chang', 21811:'li', 21815:'yo', 21820:'sha', 21822:'tuo', 21823:'hu',
    21825:'zhou', 21827:'ken', 21828:'zhuo', 21830:'shang', 21833:'lin',
    21834:'a', 21840:'cui', 21845:'tao', 21846:'dan', 21852:'chuo', 21857:'fei',
    21860:'pi', 21861:'sha', 21862:'la', 21863:'ze', 21866:'pa', 21868:'se',
    21869:'zhuan', 21870:'nie', 21877:'bo', 21878:'ding', 21879:'lang',
    21880:'xiao', 21883:'chi', 21884:'ti', 21886:'jiu', 21888:'ka',
    21889:'yong', 21890:'wei', 21891:'nan', 21892:'shan', 21895:'la',
    21896:'jie', 21897:'hou', 21898:'han', 21899:'die', 21903:'nuo',
    21905:'yin', 21908:'wo', 21912:'chuan', 21913:'hui', 21916:'xi', 21917:'he',
    21919:'kui', 21927:'xuan', 21937:'li', 21939:'zha', 21941:'miao',
    21943:'pen', 21945:'kui', 21947:'yu', 21949:'lou', 21950:'ku', 21956:'a',
    21957:'xiu', 21961:'su', 21964:'ai', 21965:'suo', 21969:'ke', 21970:'da',
    21971:'sang', 21972:'chen', 21974:'sou', 21980:'shi', 21981:'ge',
    21983:'jie', 21985:'weng', 21987:'si', 21988:'chi', 21989:'hao',
    21990:'suo', 21992:'hai', 21994:'qin', 21995:'nie', 21996:'he', 21999:'ng',
    22002:'dia', 22003:'ai', 22005:'tong', 22007:'ao', 22013:'sou', 22014:'sou',
    22016:'di', 22017:'qi', 22024:'cao', 22025:'jia', 22028:'piao', 22030:'ga',
    22031:'gu', 22040:'xu', 22043:'ma', 22046:'lei', 22047:'du', 22051:'beng',
    22052:'ying', 22055:'mi', 22060:'zuo', 22061:'peng', 22065:'zhu',
    22066:'chao', 22068:'zui', 22070:'si', 22073:'liao', 22075:'xi',
    22079:'hei', 22092:'ceng', 22093:'jiao', 22094:'ye', 22100:'deng',
    22103:'pu', 22104:'jue', 22105:'qin', 22108:'lu', 22114:'o', 22116:'jin',
    22120:'qi', 22121:'e', 22122:'zao', 22123:'yi', 22124:'shi', 22129:'xue',
    22134:'ga', 22139:'sai', 22140:'pi', 22149:'ru', 22150:'hao', 22158:'hao',
    22159:'ti', 22163:'ca', 22179:'xiao', 22191:'huo', 22199:'rang',
    22204:'jiao', 22218:'nang', 22228:'nang', 22231:'wei', 22234:'qiu',
    22235:'si', 22237:'jian', 22238:'hui', 22239:'xin', 22240:'yin',
    22241:'nan', 22242:'tuan', 22244:'tun', 22251:'hu', 22253:'yuan',
    22256:'kun', 22257:'cong', 22260:'wei', 22261:'lun', 22265:'ling',
    22266:'gu', 22269:'guo', 22270:'tu', 22271:'you', 22275:'pu', 22276:'yu',
    22278:'yuan', 22280:'quan', 22281:'yu', 22282:'qing', 22300:'huan',
    22303:'tu', 22307:'sheng', 22312:'zai', 22313:'wei', 22314:'ge', 22316:'wu',
    22317:'gui', 22318:'pi', 22319:'yi', 22320:'di', 22323:'zhen',
    22329:'kuang', 22330:'chang', 22331:'qi', 22334:'ji', 22336:'zhi',
    22338:'ban', 22343:'jun', 22346:'fang', 22348:'ben', 22349:'tan',
    22350:'kan', 22351:'huai', 22352:'zuo', 22353:'keng', 22359:'kuai',
    22362:'jian', 22363:'tan', 22364:'li', 22365:'ba', 22366:'wu', 22367:'fen',
    22368:'zhui', 22369:'po', 22372:'kun', 22374:'tan', 22376:'tuo',
    22377:'gan', 22378:'ping', 22379:'dian', 22381:'ni', 22383:'pi', 22387:'ao',
    22390:'mu', 22391:'ke', 22395:'di', 22396:'che', 22402:'chui', 22403:'la',
    22404:'long', 22405:'long', 22406:'lu', 22411:'xing', 22412:'tong',
    22418:'lei', 22419:'gai', 22427:'duo', 22432:'yin', 22433:'fa', 22434:'gou',
    22435:'yuan', 22436:'die', 22438:'ken', 22439:'shang', 22441:'e',
    22443:'dian', 22445:'ya', 22446:'kua', 22450:'kai', 22452:'nao',
    22456:'huan', 22466:'geng', 22467:'ai', 22475:'mai', 22478:'cheng',
    22479:'shan', 22482:'lie', 22484:'pu', 22485:'cheng', 22488:'shi',
    22489:'xun', 22490:'guo', 22493:'nian', 22495:'yu', 22496:'bu', 22500:'bi',
    22509:'dai', 22511:'an', 22516:'zhi', 22520:'yi', 22521:'pei', 22522:'ji',
    22525:'sao', 22528:'jue', 22530:'tang', 22534:'dui', 22535:'jin',
    22539:'beng', 22541:'tu', 22545:'qian', 22549:'duo', 22553:'yin',
    22558:'die', 22560:'hou', 22561:'bao', 22564:'di', 22570:'kan', 22576:'yan',
    22581:'du', 22596:'leng', 22604:'ta', 22605:'cheng', 22609:'su', 22612:'ta',
    22616:'tang', 22622:'sai', 22629:'ge', 22635:'tian', 22636:'yuan',
    22654:'shu', 22656:'chi', 22657:'man', 22659:'jing', 22661:'shu',
    22665:'yong', 22674:'shang', 22675:'mu', 22681:'qiang', 22682:'liang',
    22686:'zeng', 22687:'xu', 22696:'mo', 22697:'dun', 22716:'ji', 22721:'bi',
    22725:'yong', 22737:'he', 22741:'hao', 22756:'rang', 22763:'shi',
    22764:'ren', 22766:'zhuang', 22768:'sheng', 22771:'ke', 22774:'hu',
    22777:'yi', 22786:'zhi', 22788:'chu', 22791:'bei', 22797:'fu', 22799:'xia',
    22804:'kui', 22805:'xi', 22806:'wai', 22809:'su', 22810:'duo', 22812:'ye',
    22815:'gou', 22820:'yin', 22821:'huo', 22823:'da', 22825:'tian',
    22826:'tai', 22827:'fu', 22829:'yao', 22830:'yang', 22831:'hang',
    22833:'shi', 22836:'tou', 22839:'yi', 22840:'kua', 22841:'jia', 22842:'duo',
    22844:'kuang', 22849:'lian', 22850:'huan', 22852:'yan', 22855:'qi',
    22856:'nai', 22857:'feng', 22859:'fen', 22862:'kui', 22863:'zou',
    22865:'qi', 22868:'ben', 22869:'yi', 22870:'jiang', 22871:'tao',
    22872:'zhuang', 22874:'xi', 22880:'dian', 22882:'she', 22885:'ao',
    22899:'nv', 22900:'nu', 22902:'nai', 22904:'jian', 22905:'ta', 22909:'hao',
    22913:'shuo', 22914:'ru', 22915:'fei', 22916:'wang', 22918:'zhuang',
    22919:'fu', 22920:'ma', 22922:'ren', 22925:'yan', 22930:'du', 22931:'ji',
    22934:'yao', 22935:'jin', 22937:'miao', 22942:'niu', 22947:'bi', 22948:'yu',
    22949:'tuo', 22952:'fang', 22953:'wu', 22954:'yu', 22955:'gui', 22958:'ni',
    22959:'zhou', 22962:'da', 22969:'mei', 22971:'qi', 22974:'qie', 22982:'mu',
    22986:'zi', 22987:'shi', 22992:'jie', 22993:'gu', 22994:'si', 22995:'xing',
    22996:'wei', 22999:'shan', 23000:'pin', 23002:'yao', 23004:'jiang',
    23005:'shu', 23011:'jiao', 23013:'lao', 23016:'yi', 23020:'ji', 23033:'cha',
    23035:'yin', 23039:'zi', 23041:'wei', 23043:'wa', 23044:'lou', 23045:'ya',
    23046:'rao', 23047:'jiao', 23048:'luan', 23049:'ping', 23052:'li',
    23057:'suo', 23059:'wei', 23064:'niang', 23068:'na', 23071:'juan',
    23072:'shen', 23075:'di', 23077:'e', 23081:'mian', 23089:'yu', 23090:'wa',
    23092:'xian', 23094:'qu', 23100:'chang', 23104:'e', 23110:'po', 23113:'wan',
    23114:'biao', 23125:'jie', 23130:'hun', 23138:'bi', 23143:'jing',
    23146:'lan', 23156:'ying', 23157:'chan', 23158:'shen', 23159:'ting',
    23162:'wu', 23167:'xu', 23186:'mei', 23194:'mei', 23195:'yuan', 23210:'ao',
    23218:'pi', 23219:'xi', 23221:'ying', 23224:'chi', 23230:'gou', 23233:'jia',
    23234:'sao', 23241:'ji', 23244:'xian', 23250:'ai', 23252:'pin',
    23254:'piao', 23256:'lei', 23260:'zhang', 23264:'li', 23265:'di',
    23267:'yan', 23270:'chang', 23273:'nen', 23275:'mo', 23281:'qiang',
    23305:'xi', 23318:'bi', 23319:'shan', 23346:'niao', 23348:'ying',
    23351:'ma', 23360:'shuang', 23376:'zi', 23377:'jie', 23379:'jue',
    23380:'kong', 23381:'yun', 23383:'zi', 23384:'cun', 23385:'sun', 23386:'fu',
    23387:'bei', 23388:'zi', 23389:'xiao', 23391:'meng', 23394:'bao',
    23395:'ji', 23396:'gu', 23397:'nu', 23398:'xue', 23401:'hai', 23402:'luan',
    23404:'nao', 23408:'shu', 23409:'chan', 23411:'zi', 23413:'fu', 23418:'ru',
    23421:'nie', 23424:'mian', 23425:'ning', 23427:'ta', 23428:'gui',
    23429:'zhai', 23431:'yu', 23432:'shou', 23433:'an', 23435:'song',
    23436:'wan', 23439:'hong', 23443:'mi', 23445:'dang', 23447:'zong',
    23448:'guan', 23449:'zhou', 23450:'ding', 23451:'wan', 23452:'yi',
    23453:'bao', 23454:'shi', 23456:'chong', 23457:'shen', 23458:'ke',
    23459:'xuan', 23460:'shi', 23461:'you', 23462:'huan', 23466:'xian',
    23467:'gong', 23472:'zai', 23475:'hai', 23476:'yan', 23477:'xiao',
    23478:'jia', 23480:'chen', 23481:'rong', 23485:'kuan', 23486:'bin',
    23487:'su', 23490:'ji', 23492:'ji', 23493:'yin', 23494:'mi', 23495:'kou',
    23500:'fu', 23504:'mei', 23506:'han', 23507:'yu', 23517:'qin', 23518:'mo',
    23519:'cha', 23521:'gua', 23524:'wu', 23525:'liao', 23528:'zhai',
    23534:'liao', 23536:'huan', 23544:'cun', 23545:'dui', 23546:'si',
    23547:'xun', 23548:'dao', 23551:'shou', 23553:'feng', 23556:'she',
    23558:'jiang', 23561:'wei', 23562:'zun', 23567:'xiao', 23569:'shao',
    23572:'er', 23573:'ga', 23574:'jian', 23576:'chen', 23578:'shang',
    23580:'ga', 23581:'chang', 23586:'you', 23588:'you', 23589:'liao',
    23591:'yao', 23596:'ga', 23601:'jiu', 23604:'gan', 23608:'shi', 23609:'yin',
    23610:'chi', 23611:'kao', 23612:'ni', 23613:'jin', 23614:'wei',
    23615:'niao', 23616:'ju', 23617:'pi', 23618:'ceng', 23621:'ju', 23624:'qu',
    23625:'ti', 23626:'jie', 23627:'wu', 23630:'shi', 23631:'ping', 23632:'ji',
    23633:'xie', 23637:'zhan', 23641:'e', 23646:'shu', 23648:'tu', 23649:'lv',
    23651:'xi', 23653:'lv', 23654:'ju', 23662:'che', 23663:'tun', 23665:'shan',
    23673:'yi', 23674:'qi', 23679:'yu', 23681:'sui', 23682:'qi', 23688:'ya',
    23692:'ji', 23693:'qian', 23696:'qi', 23697:'cen', 23700:'cha', 23702:'qu',
    23703:'gang', 23704:'xian', 23705:'ao', 23706:'lan', 23707:'dao',
    23708:'ba', 23714:'ke', 23715:'gou', 23721:'yan', 23723:'xiu', 23724:'jia',
    23725:'ling', 23729:'dai', 23731:'yue', 23733:'hu', 23735:'min', 23736:'an',
    23741:'dong', 23743:'kui', 23745:'mao', 23748:'yi', 23755:'xun',
    23762:'tong', 23769:'zhi', 23777:'xia', 23780:'qiao', 23781:'zheng',
    23782:'luan', 23784:'e', 23786:'yu', 23789:'qiao', 23792:'feng',
    23803:'jun', 23810:'lao', 23811:'lai', 23814:'kong', 23815:'chong',
    23822:'qi', 23828:'cui', 23830:'ya', 23835:'jue', 23838:'guo', 23844:'yao',
    23846:'yan', 23847:'song', 23849:'beng', 23853:'zhan', 23854:'gu',
    23860:'wai', 23869:'zai', 23870:'yao', 23879:'ji', 23882:'sheng',
    23883:'mei', 23884:'qian', 23896:'rong', 23899:'yu', 23901:'lou',
    23913:'song', 23915:'zi', 23916:'wei', 23919:'cuo', 23924:'ji',
    23938:'zhang', 23961:'lin', 23965:'deng', 23991:'yi', 24005:'dian',
    24013:'wei', 24027:'chuan', 24029:'chuan', 24030:'zhou', 24033:'xun',
    24034:'chao', 24037:'gong', 24038:'zuo', 24039:'qiao', 24040:'ju',
    24041:'gong', 24043:'wu', 24046:'cha', 24047:'qiu', 24049:'ji', 24050:'yi',
    24051:'si', 24052:'ba', 24055:'xiang', 24061:'xun', 24062:'jin', 24065:'bi',
    24066:'shi', 24067:'bu', 24069:'shuai', 24070:'fan', 24072:'shi',
    24076:'xi', 24079:'wei', 24080:'zhang', 24081:'tang', 24084:'pei',
    24085:'pa', 24086:'tie', 24088:'lian', 24089:'zhi', 24090:'zhou',
    24091:'bo', 24092:'zhi', 24093:'di', 24102:'dai', 24103:'zhen', 24109:'xi',
    24110:'bang', 24113:'chou', 24119:'wei', 24120:'chang', 24123:'ze',
    24124:'guo', 24125:'mao', 24130:'mi', 24132:'wo', 24133:'fu', 24140:'huang',
    24148:'man', 24149:'mu', 24155:'zhang', 24158:'fu', 24161:'fan',
    24162:'zhuang', 24178:'gan', 24179:'ping', 24180:'nian', 24182:'bing',
    24184:'xing', 24186:'yao', 24187:'huan', 24188:'you', 24189:'you',
    24191:'guang', 24192:'pi', 24196:'zhuang', 24198:'qing', 24199:'bi',
    24202:'chuang', 24203:'gui', 24207:'xu', 24208:'lu', 24209:'wu', 24211:'ku',
    24212:'ying', 24213:'di', 24214:'pao', 24215:'dian', 24217:'miao',
    24218:'geng', 24220:'fu', 24222:'pang', 24223:'fei', 24224:'xiang',
    24229:'xiu', 24230:'du', 24231:'zuo', 24237:'ting', 24243:'bi', 24245:'an',
    24246:'shu', 24247:'kang', 24248:'yong', 24249:'tuo', 24254:'yu',
    24265:'lian', 24266:'lang', 24273:'qin', 24274:'ao', 24275:'kuo',
    24278:'liao', 24283:'chan', 24296:'xie', 24298:'lin', 24308:'yin',
    24310:'yan', 24311:'ting', 24314:'jian', 24318:'gong', 24319:'nian',
    24320:'kai', 24321:'bian', 24322:'yi', 24323:'qi', 24324:'nong', 24328:'yi',
    24330:'bi', 24331:'yi', 24335:'shi', 24337:'shi', 24339:'gong', 24341:'yin',
    24343:'fu', 24344:'hong', 24347:'chi', 24351:'di', 24352:'zhang',
    24357:'mi', 24358:'xian', 24359:'hu', 24361:'nu', 24362:'jing', 24365:'mi',
    24367:'wan', 24369:'ruo', 24377:'dan', 24378:'qiang', 24380:'bi',
    24384:'gou', 24400:'ji', 24402:'gui', 24403:'dang', 24405:'lu',
    24406:'tuan', 24407:'hui', 24408:'zhi', 24413:'yi', 24417:'shan',
    24418:'xing', 24420:'tong', 24422:'yan', 24425:'cai', 24426:'biao',
    24428:'bin', 24429:'peng', 24432:'zhang', 24433:'ying', 24435:'chi',
    24439:'pang', 24441:'yi', 24443:'che', 24444:'bi', 24448:'wang',
    24449:'zheng', 24450:'cu', 24452:'jing', 24453:'dai', 24455:'xun',
    24456:'hen', 24457:'yang', 24458:'huai', 24459:'lv', 24460:'hou',
    24464:'xu', 24466:'tu', 24469:'lai', 24471:'de', 24472:'pai', 24473:'xi',
    24476:'chang', 24481:'yu', 24488:'huang', 24490:'xun', 24493:'yao',
    24494:'wei', 24501:'zhi', 24503:'de', 24508:'jiao', 24509:'hui',
    24515:'xin', 24516:'xin', 24517:'bi', 24518:'yi', 24521:'dao', 24524:'ji',
    24525:'ren', 24527:'chan', 24528:'tan', 24529:'te', 24530:'te', 24534:'cun',
    24535:'zhi', 24536:'wang', 24537:'mang', 24541:'tian', 24544:'zhong',
    24545:'chong', 24548:'wu', 24551:'you', 24554:'song', 24555:'kuai',
    24557:'bian', 24558:'zhi', 24561:'chen', 24565:'nian', 24568:'niu',
    24571:'xin', 24573:'hu', 24574:'kai', 24575:'fen', 24576:'huai',
    24577:'tai', 24578:'song', 24579:'wu', 24580:'ou', 24581:'chang',
    24582:'chuang', 24586:'chao', 24589:'zuo', 24590:'zen', 24591:'yang',
    24594:'nu', 24596:'zheng', 24597:'pa', 24598:'bu', 24601:'hu', 24603:'da',
    24604:'lian', 24605:'si', 24608:'dai', 24609:'yi', 24613:'ji', 24614:'peng',
    24615:'xing', 24616:'yuan', 24617:'ni', 24618:'guai', 24619:'fu',
    24623:'qie', 24629:'chu', 24635:'zong', 24636:'dui', 24639:'yi',
    24641:'nen', 24642:'xun', 24643:'shi', 24651:'lian', 24653:'huang',
    24656:'kong', 24658:'heng', 24661:'shu', 24665:'yang', 24666:'hui',
    24669:'jia', 24674:'hui', 24675:'zi', 24676:'xu', 24679:'nv', 24680:'hen',
    24681:'en', 24682:'ke', 24683:'dong', 24684:'tian', 24685:'gong',
    24687:'xi', 24688:'qia', 24691:'ken', 24694:'e', 24696:'tong', 24697:'yan',
    24698:'kai', 24699:'ce', 24700:'nao', 24701:'yun', 24703:'yong',
    24707:'kun', 24708:'qiao', 24713:'xi', 24716:'ti', 24717:'han', 24722:'yi',
    24724:'hui', 24726:'bei', 24730:'song', 24731:'quan', 24733:'kui',
    24735:'wu', 24736:'you', 24739:'huan', 24742:'yue', 24744:'nin',
    24747:'que', 24748:'xuan', 24749:'qian', 24751:'min', 24753:'fei',
    24754:'bei', 24756:'cui', 24760:'ji', 24763:'xing', 24764:'dao',
    24773:'qing', 24774:'chou', 24778:'jing', 24779:'wan', 24785:'huo',
    24789:'ti', 24792:'wang', 24794:'hu', 24796:'xi', 24797:'chang',
    24799:'wei', 24800:'hui', 24806:'dian', 24807:'ju', 24808:'can',
    24809:'cheng', 24811:'bei', 24812:'qie', 24813:'can', 24814:'dan',
    24815:'guan', 24816:'duo', 24819:'xiang', 24820:'zhui', 24822:'huang',
    24825:'re', 24826:'xing', 24832:'qiao', 24833:'chou', 24838:'qian',
    24840:'yu', 24841:'yu', 24845:'min', 24846:'bi', 24847:'yi', 24853:'e',
    24858:'yu', 24863:'gan', 24864:'yun', 24867:'leng', 24868:'fen',
    24870:'kui', 24871:'kui', 24875:'su', 24895:'yuan', 24904:'ci',
    24906:'qian', 24908:'huang', 24910:'shen', 24913:'she', 24917:'mu',
    24925:'ni', 24930:'man', 24935:'hui', 24936:'kai', 24944:'wei',
    24949:'yong', 24951:'kang', 24971:'bie', 24974:'zeng', 24980:'qiao',
    24989:'dui', 24999:'chong', 25000:'han', 25001:'qi', 25004:'jing',
    25015:'chu', 25022:'han', 25026:'dong', 25032:'xie', 25034:'ao',
    25035:'mao', 25041:'men', 25042:'lan', 25044:'lin', 25062:'nuo',
    25077:'meng', 25087:'yi', 25094:'gang', 25096:'ge', 25098:'wu',
    25099:'jian', 25100:'xu', 25101:'shu', 25102:'rong', 25103:'xi',
    25104:'cheng', 25105:'wo', 25106:'jie', 25109:'qiang', 25110:'huo',
    25111:'qiang', 25112:'zhan', 25114:'qi', 25115:'jia', 25119:'ji',
    25121:'kan', 25122:'ji', 25124:'gai', 25125:'deng', 25130:'jie',
    25132:'jian', 25134:'lu', 25139:'chuo', 25140:'dai', 25143:'hu', 25149:'hu',
    25150:'li', 25151:'fang', 25152:'suo', 25153:'bian', 25155:'jiong',
    25159:'shan', 25160:'hu', 25161:'fei', 25163:'shou', 25164:'shou',
    25165:'cai', 25166:'zha', 25169:'pu', 25170:'ba', 25171:'da', 25172:'reng',
    25176:'tuo', 25179:'kang', 25187:'kou', 25190:'qian', 25191:'zhi',
    25193:'kuo', 25194:'men', 25195:'sao', 25196:'yang', 25197:'niu',
    25198:'ban', 25199:'che', 25200:'rao', 25203:'ban', 25206:'fu', 25209:'pi',
    25212:'e', 25214:'zhao', 25215:'cheng', 25216:'ji', 25220:'chao',
    25225:'jue', 25226:'ba', 25233:'yi', 25234:'shu', 25235:'zhua', 25237:'tou',
    25238:'dou', 25239:'kang', 25240:'zhe', 25242:'fu', 25243:'pao',
    25247:'tuan', 25248:'kou', 25249:'lun', 25250:'qiang', 25252:'hu',
    25253:'bao', 25256:'peng', 25259:'pi', 25260:'tai', 25265:'bao', 25269:'di',
    25273:'mo', 25275:'chen', 25276:'ya', 25277:'chou', 25279:'min', 25282:'fu',
    25284:'zhu', 25285:'dan', 25286:'chai', 25287:'mu', 25288:'nian',
    25289:'la', 25290:'fu', 25292:'ban', 25293:'pai', 25294:'lin', 25296:'guai',
    25298:'ju', 25299:'tuo', 25300:'ba', 25302:'tuo', 25303:'ao', 25304:'ju',
    25305:'zhuo', 25306:'pan', 25307:'zhao', 25308:'bai', 25311:'ni',
    25314:'long', 25315:'jian', 25317:'yong', 25318:'lan', 25319:'ning',
    25320:'bo', 25321:'ze', 25324:'kuo', 25325:'shi', 25326:'jie',
    25327:'zheng', 25329:'gong', 25331:'quan', 25332:'shuan', 25334:'za',
    25335:'kao', 25340:'pin', 25341:'zhuai', 25342:'shi', 25343:'na',
    25345:'chi', 25346:'gua', 25351:'zhi', 25352:'qie', 25353:'an', 25358:'kua',
    25361:'tiao', 25366:'wa', 25370:'zhi', 25371:'luan', 25373:'wo', 25374:'ta',
    25375:'xie', 25376:'nao', 25377:'dang', 25378:'jiao', 25379:'zheng',
    25380:'ji', 25381:'hui', 25384:'ai', 25386:'nuo', 25387:'cuo', 25391:'zhen',
    25394:'suo', 25401:'yi', 25402:'ting', 25405:'wan', 25410:'wu', 25411:'jun',
    25413:'tong', 25414:'kun', 25417:'zhuo', 25419:'lv', 25420:'ba',
    25421:'han', 25422:'shao', 25423:'nie', 25424:'juan', 25429:'bu',
    25438:'lao', 25439:'sun', 25441:'jian', 25442:'huan', 25443:'dao',
    25447:'peng', 25449:'lie', 25453:'bai', 25454:'ju', 25457:'ai',
    25462:'chui', 25463:'jie', 25466:'na', 25467:'nian', 25472:'xian',
    25474:'dian', 25479:'duo', 25480:'shou', 25481:'diao', 25482:'pou',
    25484:'zhang', 25486:'ji', 25487:'tao', 25488:'qia', 25490:'pai',
    25494:'ye', 25496:'jue', 25504:'lve', 25506:'tan', 25507:'che', 25509:'jie',
    25511:'kong', 25512:'tui', 25513:'yan', 25514:'cuo', 25516:'ju',
    25517:'tian', 25518:'qian', 25520:'bai', 25523:'lu', 25524:'guo',
    25527:'zhi', 25528:'dan', 25530:'chan', 25532:'guan', 25534:'yuan',
    25540:'yu', 25542:'kui', 25545:'rou', 25549:'zou', 25550:'xuan',
    25551:'miao', 25552:'di', 25554:'cha', 25558:'yi', 25566:'an', 25568:'ya',
    25569:'wo', 25571:'chuai', 25577:'kai', 25578:'jiu', 25581:'jie',
    25586:'die', 25588:'yuan', 25590:'ye', 25592:'zha', 25597:'lan',
    25599:'qin', 25600:'chan', 25601:'ge', 25602:'lou', 25605:'jiao',
    25611:'chuai', 25612:'zhan', 25615:'bo', 25616:'chu', 25619:'cuo',
    25620:'sao', 25627:'jian', 25628:'sou', 25630:'gao', 25632:'shuo',
    25633:'sang', 25638:'nuo', 25642:'tang', 25644:'ban', 25645:'da',
    25652:'qian', 25658:'xie', 25661:'cha', 25663:'ge', 25665:'en', 25668:'she',
    25669:'shu', 25670:'bai', 25671:'yao', 25672:'bin', 25674:'tan',
    25682:'bing', 25684:'shuai', 25688:'zhai', 25694:'luo', 25703:'cui',
    25705:'mo', 25709:'zhi', 25720:'mo', 25721:'mo', 25722:'zhe', 25730:'liao',
    25732:'ying', 25733:'jue', 25735:'pie', 25745:'cheng', 25746:'sa',
    25749:'si', 25750:'han', 25753:'zun', 25758:'zhuang', 25764:'che',
    25769:'liao', 25772:'qiao', 25773:'bo', 25774:'cuo', 25776:'zhuan',
    25781:'nian', 25783:'xie', 25784:'lu', 25786:'cuan', 25788:'han',
    25792:'gan', 25794:'lei', 25797:'shan', 25805:'cao', 25806:'qing',
    25808:'huan', 25810:'qin', 25815:'pi', 25816:'bo', 25822:'sou',
    25826:'zhuo', 25828:'xing', 25830:'ca', 25856:'pan', 25865:'huo',
    25874:'zan', 25880:'rang', 25893:'zuan', 25899:'jue', 25902:'nang',
    25903:'zhi', 25908:'po', 25909:'po', 25910:'shou', 25912:'you', 25913:'gai',
    25915:'gong', 25918:'fang', 25919:'zheng', 25925:'gu', 25928:'xiao',
    25929:'mi', 25932:'di', 25935:'min', 25937:'jiu', 25941:'chi', 25942:'ao',
    25945:'jiao', 25947:'lian', 25949:'bi', 25950:'chang', 25954:'gan',
    25955:'san', 25958:'dun', 25963:'jiao', 25964:'jing', 25968:'shu',
    25970:'qiao', 25972:'zheng', 25975:'fu', 25991:'wen', 25995:'zhai',
    25996:'bin', 26000:'fei', 26001:'ban', 26003:'lan', 26007:'dou',
    26009:'liao', 26011:'hu', 26012:'xie', 26015:'zhen', 26017:'wo',
    26020:'jin', 26021:'chi', 26023:'fu', 26025:'zhan', 26027:'zhuo',
    26029:'duan', 26031:'si', 26032:'xin', 26041:'fang', 26044:'yu',
    26045:'shi', 26049:'pang', 26051:'zhan', 26052:'mao', 26053:'lv',
    26054:'pei', 26059:'xuan', 26060:'jing', 26062:'ni', 26063:'zu',
    26066:'liu', 26070:'yi', 26071:'qi', 26080:'wu', 26082:'ji', 26085:'ri',
    26086:'dan', 26087:'jiu', 26088:'zhi', 26089:'zao', 26092:'xun', 26093:'xu',
    26094:'ga', 26095:'la', 26096:'gan', 26097:'han', 26102:'shi',
    26103:'kuang', 26106:'wang', 26112:'yun', 26114:'ang', 26115:'ze',
    26118:'kun', 26122:'hao', 26124:'chang', 26126:'ming', 26127:'hun',
    26131:'yi', 26132:'xi', 26133:'xin', 26137:'tan', 26141:'zan', 26143:'xing',
    26144:'ying', 26149:'chun', 26151:'mei', 26152:'zuo', 26157:'zhao',
    26159:'shi', 26161:'yu', 26164:'mao', 26165:'ni', 26166:'chang',
    26172:'zhou', 26174:'xian', 26177:'chao', 26179:'huang', 26187:'jin',
    26188:'shang', 26191:'yan', 26194:'shai', 26195:'xiao', 26196:'ye',
    26197:'yun', 26198:'hui', 26199:'han', 26202:'wan', 26207:'sheng',
    26209:'bu', 26212:'wu', 26214:'hui', 26216:'chen', 26222:'pu', 26223:'jing',
    26224:'xi', 26228:'qing', 26230:'jing', 26231:'gui', 26234:'zhi',
    26238:'liang', 26242:'zan', 26244:'xuan', 26247:'xia', 26252:'kui',
    26257:'shu', 26262:'nuan', 26263:'an', 26269:'ming', 26279:'ai', 26280:'ji',
    26286:'mu', 26292:'bao', 26297:'xian', 26302:'tun', 26329:'shu',
    26331:'xun', 26332:'yao', 26333:'pu', 26342:'xi', 26345:'nang', 26352:'yue',
    26354:'qu', 26355:'ye', 26356:'geng', 26359:'he', 26361:'cao', 26364:'man',
    26366:'ceng', 26367:'ti', 26368:'zui', 26376:'yue', 26377:'you',
    26378:'ruan', 26379:'peng', 26381:'fu', 26384:'qu', 26388:'shuo',
    26389:'zhen', 26391:'lang', 26395:'wang', 26397:'zhao', 26399:'qi',
    26406:'meng', 26408:'mu', 26410:'wei', 26411:'mo', 26412:'ben', 26413:'zha',
    26415:'shu', 26417:'zhu', 26420:'pu', 26421:'duo', 26426:'ji', 26429:'xiu',
    26432:'sha', 26434:'za', 26435:'quan', 26438:'gan', 26440:'cha',
    26441:'shan', 26444:'wu', 26446:'li', 26447:'xing', 26448:'cai',
    26449:'cun', 26451:'biao', 26454:'zhang', 26460:'du', 26462:'qi',
    26463:'shu', 26464:'gang', 26465:'tiao', 26469:'lai', 26472:'yang',
    26473:'ma', 26474:'miao', 26477:'hang', 26479:'bei', 26480:'jie',
    26482:'gao', 26483:'yao', 26485:'chu', 26487:'pa', 26492:'zhu',
    26494:'song', 26495:'ban', 26497:'ji', 26500:'gou', 26503:'pi',
    26505:'wang', 26507:'fang', 26512:'xi', 26517:'zhen', 26519:'lin',
    26520:'rui', 26522:'mei', 26524:'guo', 26525:'zhi', 26526:'cong',
    26530:'shu', 26531:'zao', 26533:'li', 26535:'jian', 26536:'cheng',
    26538:'qiang', 26539:'feng', 26541:'xiao', 26543:'ku', 26544:'ping',
    26547:'zhi', 26549:'xiao', 26550:'jia', 26551:'jia', 26552:'gou',
    26561:'tuo', 26563:'ling', 26564:'bing', 26575:'bai', 26576:'mou',
    26577:'gan', 26578:'qi', 26579:'ran', 26580:'rou', 26584:'zhe', 26585:'xia',
    26586:'you', 26588:'gui', 26589:'tuo', 26590:'zuo', 26592:'ning',
    26594:'di', 26597:'cha', 26601:'jiu', 26604:'jian', 26607:'ke', 26608:'nai',
    26609:'zhu', 26611:'liu', 26612:'chai', 26621:'cheng', 26623:'shi',
    26624:'zhi', 26629:'shan', 26631:'biao', 26632:'zhan', 26633:'zhi',
    26634:'long', 26635:'dong', 26636:'lu', 26638:'li', 26639:'lan',
    26641:'shu', 26643:'shuan', 26646:'qi', 26647:'li', 26653:'gua',
    26657:'xiao', 26665:'xu', 26666:'zhu', 26674:'kao', 26675:'lao',
    26679:'yang', 26680:'he', 26681:'gen', 26684:'ge', 26685:'zai',
    26686:'luan', 26688:'jie', 26689:'heng', 26690:'gui', 26691:'tao',
    26692:'guang', 26693:'wei', 26694:'kuang', 26696:'an', 26697:'an',
    26698:'juan', 26700:'zhuo', 26702:'zhi', 26704:'tong', 26705:'sang',
    26707:'huan', 26708:'jie', 26709:'jiu', 26720:'ya', 26721:'rao',
    26722:'zhen', 26723:'dang', 26724:'qi', 26725:'qiao', 26726:'hua',
    26727:'hui', 26728:'jiang', 26729:'zhuang', 26731:'suo', 26740:'fu',
    26742:'tong', 26743:'jue', 26753:'liang', 26755:'ting', 26757:'mei',
    26758:'bang', 26767:'gu', 26771:'zi', 26775:'geng', 26786:'shao',
    26790:'meng', 26791:'wu', 26792:'li', 26797:'suo', 26799:'ti', 26800:'xie',
    26803:'shu', 26805:'fan', 26816:'jian', 26818:'ling', 26825:'mian',
    26827:'qi', 26829:'gun', 26834:'bang', 26837:'zong', 26840:'ji',
    26842:'peng', 26848:'tang', 26851:'di', 26862:'sen', 26864:'chui',
    26865:'leng', 26869:'ke', 26873:'zhao', 26874:'guan', 26876:'fen',
    26881:'guo', 26885:'yi', 26891:'liang', 26893:'zhi', 26894:'zhui',
    26896:'ju', 26898:'jiao', 26911:'du', 26912:'qian', 26916:'luo',
    26925:'tuo', 26928:'ye', 26932:'duan', 26937:'shen', 26941:'chuan',
    26943:'chun', 26946:'zha', 26964:'xie', 26967:'jian', 26970:'chu',
    26973:'lian', 26974:'leng', 26976:'nan', 26979:'mei', 26982:'xuan',
    26987:'ji', 26990:'chu', 26993:'cou', 26999:'kai', 27000:'qiu',
    27001:'ying', 27004:'lou', 27008:'pin', 27010:'gai', 27012:'lan',
    27014:'yu', 27015:'chen', 27016:'lv', 27017:'ju', 27021:'xie', 27028:'lang',
    27029:'rong', 27032:'ju', 27035:'zhen', 27036:'bang', 27047:'fei',
    27048:'zha', 27051:'sun', 27053:'xie', 27057:'cui', 27060:'liu',
    27063:'que', 27067:'ta', 27073:'gao', 27082:'shuo', 27084:'chui',
    27086:'cha', 27088:'huai', 27092:'gao', 27099:'kan', 27103:'bing',
    27104:'zhu', 27117:'qi', 27122:'hu', 27133:'cao', 27135:'jin', 27146:'fan',
    27159:'chu', 27160:'tang', 27167:'zhang', 27169:'mo', 27176:'xi',
    27178:'heng', 27183:'qiang', 27185:'ying', 27189:'qiao', 27197:'zun',
    27198:'yue', 27204:'gan', 27207:'qiao', 27216:'tuo', 27224:'ju',
    27225:'cheng', 27227:'jue', 27233:'xiang', 27237:'zhu', 27249:'chu',
    27257:'lu', 27260:'yuan', 27264:'tan', 27268:'xi', 27278:'qin', 27280:'yan',
    27281:'lei', 27287:'bo', 27296:'qing', 27305:'lin', 27307:'cha',
    27308:'meng', 27424:'qian', 27425:'ci', 27426:'huan', 27427:'xin',
    27428:'yu', 27431:'ou', 27442:'yu', 27447:'xi', 27449:'qi', 27450:'qi',
    27454:'kuan', 27459:'sha', 27462:'xin', 27463:'xie', 27465:'qian',
    27468:'ge', 27481:'xi', 27490:'zhi', 27491:'zheng', 27492:'ci', 27493:'bu',
    27494:'wu', 27495:'qi', 27498:'wai', 27513:'dai', 27515:'si', 27516:'jian',
    27521:'mo', 27522:'cu', 27523:'yang', 27524:'tian', 27526:'dai',
    27527:'shang', 27529:'xun', 27530:'shu', 27531:'can', 27533:'piao',
    27538:'yun', 27539:'lian', 27542:'zhi', 27546:'dan', 27547:'ji',
    27553:'bin', 27562:'yi', 27571:'shu', 27572:'ou', 27573:'duan', 27575:'yin',
    27583:'dian', 27585:'hui', 27586:'gu', 27589:'yi', 27595:'wu', 27597:'mu',
    27599:'mei', 27602:'du', 27603:'yu', 27604:'bi', 27605:'bi', 27606:'bi',
    27607:'pi', 27609:'bi', 27611:'mao', 27617:'zhan', 27626:'mu', 27627:'hao',
    27631:'tan', 27635:'cui', 27637:'san', 27641:'shu', 27645:'jian',
    27653:'chang', 27654:'pu', 27655:'lu', 27661:'qu', 27663:'shi', 27664:'di',
    27665:'min', 27667:'mang', 27668:'qi', 27669:'pie', 27670:'nai',
    27672:'dao', 27673:'xian', 27674:'chuan', 27675:'fen', 27679:'fu',
    27681:'dong', 27682:'qing', 27684:'yin', 27686:'hai', 27687:'yang',
    27688:'an', 27689:'ya', 27690:'ke', 27694:'dan', 27695:'lv', 27696:'qing',
    27698:'yun', 27700:'shui', 27701:'shui', 27704:'yong', 27709:'tun',
    27712:'ting', 27713:'zhi', 27714:'qiu', 27718:'cuan', 27719:'hui',
    27721:'han', 27722:'cha', 27728:'xi', 27732:'qi', 27733:'shan', 27735:'han',
    27739:'xun', 27740:'si', 27741:'ru', 27742:'gong', 27743:'jiang',
    27744:'chi', 27745:'wu', 27748:'tang', 27752:'mi', 27753:'gu', 27754:'wang',
    27760:'tai', 27762:'ji', 27764:'bian', 27766:'wen', 27769:'xiong',
    27773:'qi', 27774:'fen', 27777:'qin', 27778:'yi', 27779:'wo', 27781:'yuan',
    27782:'hang', 27784:'shen', 27785:'chen', 27788:'dun', 27791:'qi',
    27792:'mu', 27795:'ta', 27796:'mian', 27801:'sha', 27803:'pei', 27807:'gou',
    27809:'mei', 27811:'feng', 27812:'ou', 27813:'li', 27814:'lun',
    27815:'cang', 27817:'wei', 27818:'hu', 27819:'mo', 27821:'shu', 27822:'ju',
    27825:'tuo', 27826:'duo', 27827:'he', 27832:'fei', 27833:'you', 27835:'zhi',
    27836:'zhao', 27837:'gu', 27838:'zhan', 27839:'yan', 27844:'xie',
    27845:'qiu', 27849:'quan', 27850:'po', 27852:'mi', 27856:'le', 27859:'hong',
    27860:'gan', 27861:'fa', 27862:'mao', 27863:'si', 27867:'fan', 27870:'ning',
    27872:'ling', 27873:'pao', 27874:'bo', 27875:'qi', 27877:'ni', 27880:'zhu',
    27882:'lei', 27883:'xuan', 27886:'pan', 27887:'min', 27888:'tai',
    27889:'yang', 27891:'yong', 27893:'beng', 27894:'xue', 27895:'long',
    27896:'lu', 27898:'luo', 27899:'xie', 27900:'po', 27901:'ze', 27902:'jing',
    27905:'jie', 27908:'hui', 27911:'yin', 27915:'yang', 27916:'lie',
    27918:'ji', 27922:'sa', 27927:'xi', 27929:'zhu', 27930:'jiang', 27931:'luo',
    27934:'dong', 27941:'jin', 27943:'wei', 27946:'hong', 27947:'xu',
    27950:'tao', 27953:'er', 27954:'zhou', 27955:'ru', 27957:'xun',
    27961:'huan', 27963:'huo', 27964:'wa', 27965:'qia', 27966:'pai',
    27969:'liu', 27971:'jia', 27973:'qian', 27974:'jiang', 27975:'jiao',
    27976:'zhen', 27978:'zhuo', 27979:'ce', 27981:'hui', 27982:'ji',
    27983:'liu', 27985:'hun', 27986:'hu', 27987:'nong', 27988:'xun',
    27993:'zhe', 27994:'jun', 27996:'bang', 27998:'zhuo', 28000:'xi',
    28003:'huan', 28006:'pu', 28009:'hao', 28010:'lang', 28014:'fu', 28015:'wu',
    28020:'yu', 28023:'hai', 28024:'jin', 28028:'mei', 28034:'tu', 28037:'nie',
    28040:'xiao', 28041:'she', 28044:'yong', 28046:'xian', 28049:'su',
    28051:'juan', 28052:'cen', 28053:'ti', 28059:'tao', 28061:'lao',
    28062:'lai', 28063:'lian', 28064:'wei', 28065:'wo', 28067:'huan',
    28068:'di', 28070:'run', 28071:'jian', 28072:'zhang', 28073:'se',
    28074:'fu', 28075:'guan', 28078:'shuan', 28079:'ya', 28082:'ye',
    28085:'han', 28088:'he', 28095:'zhuo', 28096:'dian', 28100:'zi', 28101:'xi',
    28102:'xiao', 28103:'qi', 28107:'lin', 28108:'tang', 28113:'shu',
    28118:'nao', 28120:'tao', 28121:'cong', 28125:'fei', 28126:'song',
    28128:'pi', 28129:'dan', 28132:'yu', 28134:'gan', 28139:'yin', 28140:'cui',
    28142:'huai', 28145:'shen', 28147:'chun', 28151:'hun', 28153:'yan',
    28155:'tian', 28156:'miao', 28165:'qing', 28170:'yuan', 28172:'lu',
    28173:'zi', 28174:'du', 28176:'jian', 28177:'mian', 28180:'yu',
    28182:'shen', 28183:'shen', 28186:'zhu', 28189:'yu', 28192:'qu', 28193:'du',
    28195:'zha', 28196:'bo', 28197:'wo', 28201:'wen', 28203:'xie', 28205:'wei',
    28207:'gang', 28210:'xuan', 28212:'ke', 28216:'you', 28218:'miao',
    28227:'pai', 28228:'mei', 28237:'tuan', 28238:'mian', 28243:'pen',
    28244:'jian', 28246:'hu', 28248:'xiang', 28251:'zhan', 28255:'huang',
    28267:'qiu', 28270:'yan', 28286:'wan', 28287:'shi', 28291:'kui',
    28293:'jian', 28294:'xu', 28297:'gai', 28303:'tang', 28304:'yuan',
    28312:'ke', 28316:'liu', 28319:'ming', 28322:'yi', 28325:'pu', 28327:'li',
    28330:'xi', 28335:'su', 28337:'zhen', 28338:'sou', 28340:'xiu',
    28342:'rong', 28343:'hun', 28346:'ni', 28347:'ta', 28349:'ru', 28353:'chu',
    28354:'pang', 28359:'dian', 28363:'zi', 28367:'fu', 28369:'hua', 28371:'zi',
    28372:'tao', 28373:'teng', 28375:'bi', 28378:'gun', 28382:'zhi',
    28383:'yan', 28384:'she', 28385:'man', 28386:'ying', 28388:'lv',
    28389:'lan', 28390:'luan', 28392:'bin', 28393:'tan', 28404:'di', 28409:'hu',
    28418:'piao', 28422:'qi', 28425:'lu', 28431:'lou', 28435:'li', 28436:'yan',
    28437:'cao', 28448:'mo', 28452:'lan', 28457:'xuan', 28458:'yi', 28459:'man',
    28461:'mang', 28463:'luo', 28465:'shu', 28467:'zhang', 28470:'huan',
    28478:'yang', 28486:'ying', 28487:'xiao', 28491:'lian', 28493:'wei',
    28504:'pan', 28508:'qian', 28510:'lu', 28514:'huang', 28518:'liao',
    28525:'tan', 28526:'chao', 28530:'shao', 28532:'zhu', 28536:'shan',
    28538:'chan', 28540:'tong', 28548:'cheng', 28552:'che', 28553:'gan',
    28556:'si', 28557:'shu', 28558:'peng', 28572:'lan', 28577:'zao', 28583:'li',
    28595:'ao', 28598:'chan', 28601:'dan', 28608:'ji', 28610:'lian',
    28617:'sui', 28625:'lai', 28626:'bin', 28638:'bi', 28640:'hao', 28641:'ru',
    28654:'pu', 28655:'zhuo', 28689:'pu', 28698:'han', 28699:'ying',
    28707:'xie', 28725:'fen', 28729:'yue', 28748:'guan', 28751:'hao',
    28766:'ba', 28779:'huo', 28780:'biao', 28781:'mie', 28783:'deng',
    28784:'hui', 28789:'ling', 28790:'zao', 28792:'jiu', 28796:'zhuo',
    28798:'zai', 28799:'can', 28800:'yang', 28805:'gui', 28809:'lu',
    28810:'chui', 28814:'yan', 28818:'chao', 28820:'que', 28821:'kang',
    28822:'dun', 28825:'zhi', 28828:'wei', 28829:'qiang', 28843:'xuan',
    28844:'ju', 28845:'tan', 28846:'pao', 28847:'jiong', 28849:'tai',
    28851:'bing', 28855:'zhu', 28856:'zha', 28857:'dian', 28859:'shi',
    28860:'lian', 28861:'chi', 28864:'hu', 28865:'shuo', 28866:'lan',
    28867:'ting', 28872:'lie', 28874:'yang', 28888:'hong', 28889:'lao',
    28891:'zhu', 28895:'yan', 28900:'kao', 28902:'fan', 28903:'shao',
    28904:'ye', 28905:'hui', 28907:'tang', 28908:'jin', 28909:'re', 28911:'xi',
    28919:'wan', 28921:'peng', 28925:'feng', 28937:'yan', 28938:'han',
    28944:'wu', 28947:'han', 28949:'huan', 28950:'men', 28952:'tao',
    28953:'bei', 28954:'fen', 28966:'jiao', 28975:'zhuo', 28976:'yan',
    28977:'yan', 28982:'ran', 28997:'duan', 29002:'xuan', 29004:'huang',
    29006:'jian', 29020:'yu', 29022:'sha', 29028:'mei', 29030:'xu',
    29031:'zhao', 29032:'wei', 29038:'zhu', 29042:'bao', 29043:'hu',
    29048:'bian', 29050:'tui', 29053:'shan', 29060:'xi', 29066:'xiong',
    29071:'xun', 29076:'rong', 29080:'liu', 29081:'xi', 29087:'shu', 29088:'yi',
    29096:'yun', 29100:'ao', 29107:'man', 29109:'shang', 29113:'xi',
    29123:'ran', 29134:'liao', 29140:'fan', 29141:'yan', 29152:'yu',
    29157:'zao', 29159:'sui', 29166:'xie', 29177:'xian', 29190:'bao',
    29213:'jue', 29224:'cuan', 29226:'zhua', 29228:'pa', 29232:'yuan',
    29233:'ai', 29237:'jue', 29238:'fu', 29239:'ye', 29240:'ba', 29241:'die',
    29243:'yao', 29245:'shuang', 29247:'pan', 29255:'pian', 29256:'ban',
    29260:'pai', 29261:'du', 29266:'die', 29270:'you', 29273:'ya', 29275:'niu',
    29277:'pin', 29279:'mou', 29281:'mu', 29282:'lao', 29286:'mao', 29287:'mu',
    29289:'wu', 29294:'jian', 29295:'gu', 29298:'sheng', 29301:'qian',
    29305:'te', 29306:'xi', 29310:'wu', 29311:'gu', 29312:'xi', 29313:'li',
    29316:'ji', 29322:'du', 29323:'ju', 29325:'jian', 29327:'pian', 29330:'kao',
    29343:'jiang', 29356:'quan', 29357:'quan', 29359:'fan', 29360:'qiu',
    29364:'an', 29366:'zhuang', 29367:'guang', 29368:'ma', 29369:'you',
    29377:'yun', 29378:'kuang', 29379:'niu', 29380:'di', 29384:'bei',
    29389:'pao', 29390:'xia', 29392:'hu', 29394:'fei', 29399:'gou', 29401:'ju',
    29406:'ning', 29408:'hen', 29409:'jiao', 29416:'rong', 29417:'shou',
    29420:'du', 29421:'xia', 29422:'shi', 29423:'kuai', 29424:'zheng',
    29425:'yu', 29426:'sun', 29427:'yu', 29428:'bi', 29431:'juan', 29432:'li',
    29434:'yin', 29435:'suan', 29436:'lang', 29441:'li', 29443:'xian',
    29450:'ni', 29454:'lie', 29459:'guo', 29461:'mi', 29462:'chang', 29463:'yi',
    29467:'meng', 29468:'cai', 29469:'cu', 29470:'she', 29473:'luo', 29474:'hu',
    29477:'wei', 29481:'xing', 29482:'zhu', 29483:'mao', 29484:'wei',
    29486:'xian', 29489:'nao', 29492:'hou', 29495:'you', 29496:'mei',
    29497:'cha', 29502:'hua', 29503:'yuan', 29517:'jing', 29520:'zhang',
    29522:'ao', 29527:'jue', 29536:'liao', 29548:'xie', 29549:'ta', 29551:'xun',
    29566:'huan', 29572:'xuan', 29575:'shuai', 29577:'yu', 29579:'wang',
    29582:'ding', 29585:'ji', 29590:'jiu', 29595:'ma', 29599:'wen', 29602:'bin',
    29609:'wan', 29611:'mei', 29614:'wei', 29615:'huan', 29616:'xian',
    29618:'ling', 29619:'dai', 29623:'dian', 29626:'xi', 29627:'bo', 29632:'po',
    29634:'ke', 29640:'jia', 29641:'min', 29642:'shan', 29645:'zhen',
    29647:'jue', 29648:'fa', 29649:'long', 29657:'gong', 29662:'luo',
    29664:'zhu', 29669:'er', 29671:'yao', 29673:'heng', 29677:'ban',
    29682:'hun', 29699:'qiu', 29701:'lang', 29702:'li', 29705:'liu', 29706:'ya',
    29711:'lian', 29712:'suo', 29722:'ju', 29723:'chen', 29730:'zhuo',
    29733:'hu', 29734:'qi', 29736:'kun', 29738:'qi', 29740:'wan', 29742:'cong',
    29744:'yan', 29747:'lin', 29748:'qin', 29749:'pi', 29750:'pa',
    29756:'qiong', 29761:'mao', 29781:'xia', 29783:'yuan', 29785:'nao',
    29786:'hu', 29787:'ying', 29788:'yu', 29790:'rui', 29791:'se', 29805:'tang',
    29808:'gui', 29814:'yao', 29815:'ai', 29822:'jin', 29824:'cui',
    29825:'cong', 29827:'li', 29831:'xuan', 29835:'zhang', 29838:'ying',
    29840:'lu', 29852:'huang', 29854:'pu', 29863:'bi', 29864:'can', 29865:'qu',
    29882:'wen', 29906:'zan', 29916:'gua', 29918:'die', 29920:'hu',
    29922:'piao', 29923:'ban', 29924:'rang', 29926:'wa', 29934:'weng',
    29935:'ou', 29940:'ling', 29942:'ping', 29943:'ci', 29951:'bu',
    29956:'zhen', 29965:'meng', 29967:'beng', 29969:'zeng', 29971:'pi',
    29976:'gan', 29977:'dai', 29978:'shen', 29980:'tian', 29983:'sheng',
    29989:'sheng', 29992:'yong', 29993:'shuai', 29995:'fu', 29996:'yong',
    29997:'beng', 29999:'ning', 30000:'tian', 30001:'you', 30002:'jia',
    30003:'shen', 30005:'dian', 30007:'nan', 30008:'dian', 30010:'ding',
    30011:'hua', 30014:'zai', 30016:'bi', 30021:'chang', 30024:'fan',
    30027:'tian', 30028:'jie', 30030:'quan', 30031:'wei', 30036:'pan',
    30041:'liu', 30042:'ben', 30043:'zhen', 30044:'xu', 30053:'lve', 30054:'qi',
    30058:'fan', 30066:'she', 30068:'chou', 30072:'ji', 30073:'wan', 30079:'ji',
    30083:'tuan', 30086:'jiang', 30091:'shu', 30095:'shu', 30097:'yi',
    30098:'chuang', 30100:'ding', 30102:'jie', 30103:'liao', 30105:'ge',
    30106:'jiu', 30109:'shan', 30111:'nve', 30112:'li', 30113:'yang',
    30115:'you', 30116:'ba', 30117:'jie', 30123:'yi', 30124:'li',
    30126:'chuang', 30127:'feng', 30128:'zhu', 30129:'pao', 30130:'pi',
    30131:'gan', 30132:'ke', 30133:'ci', 30136:'dan', 30137:'zhen',
    30140:'teng', 30141:'ju', 30142:'ji', 30146:'jia', 30147:'xian',
    30148:'zha', 30149:'bing', 30151:'zheng', 30152:'yong', 30153:'jing',
    30154:'quan', 30157:'yi', 30162:'yang', 30164:'zhi', 30165:'hen',
    30166:'ya', 30168:'dou', 30171:'tong', 30174:'pi', 30178:'li', 30179:'zhi',
    30180:'cuo', 30182:'wu', 30183:'sha', 30184:'lao', 30186:'huan',
    30187:'xian', 30192:'tan', 30193:'fei', 30196:'chi', 30201:'bi', 30204:'gu',
    30207:'wei', 30208:'yu', 30209:'cui', 30211:'zhu', 30213:'dan', 30218:'hou',
    30220:'la', 30224:'yu', 30229:'jia', 30231:'yi', 30232:'lou', 30233:'sao',
    30235:'chi', 30239:'wen', 30240:'ji', 30242:'ban', 30244:'liu',
    30245:'chai', 30246:'shou', 30249:'da', 30250:'bie', 30251:'tan',
    30253:'biao', 30256:'luo', 30259:'chou', 30260:'zhang', 30261:'zhai',
    30264:'que', 30268:'mo', 30270:'yin', 30271:'ying', 30272:'huang',
    30275:'long', 30284:'ai', 30285:'ban', 30292:'yi', 30294:'pi', 30300:'dian',
    30302:'lai', 30307:'xuan', 30315:'dian', 30319:'qu', 30328:'gui',
    30331:'deng', 30333:'bai', 30334:'bai', 30338:'zao', 30340:'de',
    30342:'jie', 30343:'huang', 30344:'gui', 30347:'gao', 30350:'jiao',
    30353:'ai', 30355:'hao', 30358:'wan', 30361:'xi', 30372:'po', 30382:'pi',
    30385:'zhou', 30386:'jun', 30388:'cun', 30399:'min', 30402:'yu',
    30405:'zhong', 30406:'pen', 30408:'ying', 30410:'yi', 30413:'he',
    30414:'ang', 30415:'zhan', 30416:'yan', 30417:'jian', 30418:'he',
    30420:'kui', 30422:'gai', 30423:'dao', 30424:'pan', 30427:'sheng',
    30431:'meng', 30437:'guan', 30446:'mu', 30447:'ding', 30449:'xu',
    30450:'mang', 30452:'zhi', 30456:'xiang', 30457:'dun', 30460:'pan',
    30462:'dun', 30465:'sheng', 30468:'mian', 30471:'miao', 30472:'dan',
    30473:'mei', 30475:'kan', 30477:'kou', 30489:'yi', 30490:'sheng',
    30495:'zhen', 30496:'mian', 30498:'yuan', 30502:'zi', 30504:'zha',
    30505:'xuan', 30509:'sui', 30511:'mi', 30517:'chi', 30518:'kuang',
    30519:'juan', 30520:'mou', 30522:'tiao', 30524:'yan', 30528:'zhe',
    30529:'zheng', 30531:'suo', 30535:'di', 30544:'lai', 30545:'jian',
    30554:'ya', 30555:'jing', 30561:'shui', 30562:'sui', 30563:'du', 30565:'pi',
    30566:'mu', 30568:'ni', 30571:'jie', 30572:'cai', 30585:'du', 30589:'kui',
    30590:'gao', 30591:'rui', 30592:'mao', 30596:'miao', 30597:'chou',
    30604:'ke', 30605:'sou', 30606:'xia', 30609:'ming', 30610:'man',
    30623:'piao', 30624:'cheng', 30626:'meng', 30629:'pie', 30631:'qiao',
    30633:'zhu', 30634:'deng', 30636:'shun', 30640:'kan', 30643:'tong',
    30645:'lin', 30651:'zhan', 30653:'gu', 30655:'qu', 30669:'jue', 30679:'chu',
    30683:'mao', 30684:'jin', 30690:'shi', 30691:'yi', 30693:'zhi',
    30695:'shen', 30697:'ju', 30699:'jiao', 30700:'cuo', 30701:'duan',
    30702:'ai', 30707:'shi', 30710:'ji', 30712:'gan', 30717:'xi', 30718:'fan',
    30719:'kuang', 30720:'dang', 30721:'ma', 30722:'sha', 30729:'hua',
    30732:'qi', 30733:'kan', 30737:'ya', 30738:'pi', 30740:'yan', 30742:'zhuan',
    30743:'che', 30744:'dun', 30746:'yan', 30748:'feng', 30749:'fa',
    30751:'zha', 30755:'tuo', 30757:'di', 30758:'zhai', 30759:'zhen',
    30761:'fu', 30764:'li', 30765:'bian', 30768:'peng', 30772:'po',
    30775:'shen', 30776:'za', 30777:'ai', 30778:'li', 30779:'long',
    30780:'tong', 30782:'li', 30784:'chu', 30789:'gui', 30791:'nao',
    30796:'luo', 30798:'xing', 30800:'dong', 30802:'xi', 30805:'shuo',
    30806:'xia', 30807:'qiao', 30813:'xiao', 30826:'wo', 30827:'liu',
    30828:'ying', 30829:'mang', 30830:'que', 30839:'jian', 30844:'peng',
    30855:'ding', 30857:'diao', 30860:'lu', 30861:'ai', 30862:'sui',
    30865:'bei', 30867:'dui', 30871:'wan', 30872:'dian', 30874:'bei',
    30875:'qi', 30876:'chen', 30879:'die', 30881:'zhou', 30883:'jie',
    30885:'bian', 30887:'bi', 30896:'peng', 30897:'jian', 30898:'di',
    30899:'tan', 30900:'cha', 30905:'xuan', 30910:'nian', 30913:'ci',
    30917:'pang', 30921:'sang', 30922:'lei', 30923:'cuo', 30928:'pan',
    30932:'zhe', 30933:'ke', 30937:'gun', 30952:'mo', 30956:'qing', 30962:'qu',
    30964:'deng', 30967:'lin', 30970:'huang', 30977:'jiao', 30981:'dun',
    30995:'jiang', 31006:'meng', 31012:'ca', 31028:'bo', 31034:'shi',
    31035:'shi', 31036:'li', 31038:'she', 31040:'si', 31041:'qi', 31046:'xian',
    31048:'qi', 31049:'zhi', 31059:'fu', 31062:'zu', 31063:'zhi', 31066:'zuo',
    31067:'qu', 31068:'hu', 31069:'zhu', 31070:'shen', 31071:'sui', 31072:'ci',
    31074:'mi', 31077:'xiang', 31079:'tiao', 31080:'piao', 31085:'ji',
    31087:'zhen', 31095:'dao', 31096:'huo', 31098:'qi', 31104:'bing',
    31105:'jin', 31108:'lu', 31109:'chan', 31114:'xi', 31119:'fu', 31130:'zhuo',
    31143:'xi', 31155:'rang', 31161:'yu', 31162:'yu', 31163:'li', 31165:'qin',
    31166:'he', 31168:'xiu', 31169:'si', 31171:'tu', 31174:'gan', 31177:'bing',
    31179:'qiu', 31181:'zhong', 31185:'ke', 31186:'miao', 31189:'bi',
    31192:'mi', 31199:'zu', 31203:'mo', 31204:'cheng', 31206:'qin',
    31207:'yang', 31209:'zhi', 31211:'shu', 31213:'zi', 31215:'ji',
    31216:'cheng', 31224:'jie', 31227:'yi', 31229:'hui', 31232:'xi',
    31234:'lang', 31235:'fu', 31238:'lv', 31243:'cheng', 31245:'shao',
    31246:'shui', 31252:'ren', 31255:'bai', 31258:'zhi', 31262:'ke',
    31264:'chou', 31267:'su', 31283:'wen', 31287:'ji', 31289:'zhen',
    31291:'dao', 31292:'jia', 31293:'ji', 31295:'gao', 31302:'mu', 31313:'se',
    31319:'sui', 31344:'rang', 31348:'xue', 31350:'jiu', 31351:'qiong',
    31352:'xi', 31353:'qiong', 31354:'kong', 31359:'chuan', 31360:'zhun',
    31361:'tu', 31363:'qie', 31364:'zhai', 31366:'bian', 31368:'yao',
    31373:'qiao', 31377:'yao', 31378:'zhi', 31381:'tiao', 31382:'jiao',
    31383:'chuang', 31384:'jiong', 31388:'cuan', 31389:'wo', 31391:'ku',
    31392:'ke', 31397:'kui', 31398:'dou', 31400:'yin', 31404:'yu', 31405:'ju',
    31411:'yu', 31423:'long', 31435:'li', 31446:'shu', 31449:'zhan',
    31454:'jing', 31455:'jing', 31456:'zhang', 31459:'jun', 31461:'tong',
    31462:'song', 31469:'jie', 31471:'duan', 31481:'zhu', 31482:'zhu',
    31485:'yu', 31487:'gan', 31491:'du', 31492:'ji', 31494:'ba', 31496:'ji',
    31498:'zhao', 31499:'sun', 31503:'hu', 31505:'xiao', 31508:'bi',
    31509:'jian', 31513:'sheng', 31515:'di', 31518:'chi', 31520:'li',
    31524:'tiao', 31525:'si', 31526:'fu', 31528:'ben', 31530:'da', 31531:'zi',
    31532:'di', 31534:'ze', 31537:'gou', 31539:'jia', 31544:'po', 31546:'jian',
    31548:'long', 31550:'bian', 31557:'xian', 31559:'qiong', 31561:'deng',
    31563:'jin', 31564:'quan', 31567:'fa', 31568:'kuang', 31569:'zhu',
    31570:'tong', 31572:'da', 31574:'ce', 31576:'kou', 31578:'bi', 31579:'shai',
    31581:'zheng', 31584:'yun', 31586:'pa', 31598:'shi', 31601:'xiao',
    31602:'shao', 31605:'yan', 31607:'kuai', 31609:'chou', 31611:'gang',
    31614:'qian', 31616:'jian', 31621:'bi', 31629:'gu', 31632:'qing',
    31636:'bo', 31637:'ji', 31639:'suan', 31644:'kong', 31645:'qian',
    31649:'guan', 31650:'yuan', 31654:'ze', 31655:'qie', 31656:'tuo',
    31657:'luo', 31658:'dan', 31659:'xiao', 31660:'ruo', 31661:'jian',
    31665:'xiang', 31668:'zhen', 31672:'zhu', 31681:'huang', 31686:'zhuan',
    31687:'pian', 31692:'hou', 31697:'kui', 31699:'lou', 31705:'gao',
    31706:'fei', 31709:'gou', 31713:'cuan', 31717:'li', 31718:'bi', 31722:'chi',
    31726:'lan', 31729:'li', 31735:'peng', 31740:'dou', 31742:'mie', 31751:'cu',
    31755:'gui', 31756:'su', 31759:'lu', 31766:'duan', 31775:'dian',
    31782:'deng', 31783:'huang', 31786:'zan', 31800:'bo', 31807:'bu',
    31808:'zhou', 31809:'lai', 31821:'ji', 31859:'mi', 31860:'di', 31867:'lei',
    31868:'xian', 31869:'zi', 31881:'fen', 31889:'ba', 31890:'li', 31893:'po',
    31895:'cu', 31896:'zhan', 31900:'tiao', 31901:'li', 31902:'xi', 31903:'su',
    31906:'zi', 31908:'yue', 31909:'zhou', 31914:'fen', 31918:'liang',
    31921:'liang', 31922:'can', 31923:'jing', 31929:'cui', 31932:'lin',
    31933:'zong', 31934:'jing', 31937:'san', 31941:'rou', 31943:'hou',
    31944:'xu', 31946:'hu', 31948:'zan', 31949:'ci', 31957:'gao', 31958:'tang',
    31959:'qiu', 31961:'cao', 31964:'mi', 31967:'zao', 31968:'kang',
    31976:'jiang', 31983:'nuo', 31992:'mi', 31995:'xi', 32010:'wen', 32032:'su',
    32034:'suo', 32039:'jin', 32043:'zi', 32047:'lei', 32110:'xu', 32119:'zhi',
    32166:'qi', 32174:'qi', 32315:'mi', 32321:'fan', 32327:'yao', 32386:'zuan',
    32411:'dao', 32415:'mi', 32416:'jiu', 32417:'yu', 32418:'hong',
    32419:'zhou', 32420:'xian', 32421:'he', 32422:'yue', 32423:'ji',
    32424:'wan', 32425:'kuang', 32426:'ji', 32427:'ren', 32428:'wei',
    32429:'yun', 32431:'chun', 32432:'pi', 32433:'sha', 32434:'gang',
    32435:'na', 32437:'zong', 32438:'guan', 32439:'fen', 32440:'zhi',
    32441:'wen', 32442:'fang', 32445:'niu', 32446:'shu', 32447:'xian',
    32448:'gan', 32449:'xie', 32450:'fu', 32451:'lian', 32452:'zu',
    32453:'shen', 32454:'xi', 32455:'zhi', 32456:'zhong', 32457:'zhou',
    32458:'ban', 32459:'fu', 32460:'chu', 32461:'shao', 32462:'yi',
    32463:'jing', 32464:'dai', 32465:'bang', 32466:'rong', 32467:'jie',
    32468:'ku', 32469:'rao', 32471:'hang', 32472:'hui', 32473:'gei',
    32474:'xuan', 32475:'jiang', 32476:'luo', 32477:'jue', 32478:'jiao',
    32479:'tong', 32480:'geng', 32481:'xiao', 32482:'juan', 32483:'xiu',
    32485:'sui', 32486:'tao', 32487:'ji', 32488:'ti', 32489:'ji', 32490:'xu',
    32491:'ling', 32493:'xu', 32494:'qi', 32495:'fei', 32496:'chuo',
    32497:'shang', 32498:'gun', 32499:'sheng', 32500:'wei', 32501:'mian',
    32502:'shou', 32503:'beng', 32504:'chou', 32506:'liu', 32507:'quan',
    32508:'zong', 32509:'zhan', 32510:'wan', 32511:'lv', 32512:'zhui',
    32513:'zi', 32514:'ke', 32515:'xiang', 32516:'jian', 32517:'mian',
    32518:'lan', 32519:'ti', 32520:'miao', 32521:'ji', 32523:'hui', 32524:'si',
    32525:'duo', 32526:'duan', 32527:'bian', 32529:'gou', 32530:'zhui',
    32531:'huan', 32532:'di', 32533:'lv', 32534:'bian', 32535:'min',
    32536:'yuan', 32537:'jin', 32538:'fu', 32539:'ru', 32540:'zhen',
    32541:'feng', 32543:'gao', 32544:'chan', 32545:'li', 32546:'yi',
    32547:'jian', 32548:'bin', 32549:'piao', 32550:'man', 32551:'lei',
    32552:'ying', 32553:'suo', 32554:'miu', 32555:'sao', 32556:'xie',
    32557:'liao', 32558:'shan', 32559:'zeng', 32560:'jiang', 32561:'qian',
    32562:'qiao', 32563:'huan', 32564:'jiao', 32565:'zuan', 32566:'fou',
    32568:'gang', 32570:'que', 32578:'ying', 32580:'qing', 32581:'xia',
    32592:'guan', 32593:'wang', 32596:'wang', 32597:'han', 32599:'luo',
    32600:'fu', 32602:'fa', 32607:'gu', 32609:'gang', 32610:'ba', 32616:'yan',
    32617:'zhao', 32618:'zui', 32622:'zhi', 32625:'lan', 32626:'shu',
    32628:'pi', 32633:'li', 32638:'zeng', 32641:'ji', 32650:'yang',
    32652:'qiang', 32654:'mei', 32660:'gao', 32666:'ling', 32669:'di',
    32670:'xiu', 32671:'qiang', 32673:'xian', 32676:'qun', 32679:'suo',
    32687:'jie', 32688:'tang', 32690:'xi', 32696:'lei', 32697:'geng',
    32700:'chan', 32701:'yu', 32703:'yi', 32705:'weng', 32709:'chi', 32714:'yi',
    32716:'yi', 32718:'ling', 32724:'xiang', 32725:'xi', 32728:'qiao',
    32735:'zhai', 32736:'cui', 32737:'fei', 32741:'zhu', 32742:'jian',
    32745:'pian', 32750:'he', 32752:'han', 32753:'ao', 32755:'yi', 32763:'fan',
    32764:'yi', 32768:'yao', 32769:'lao', 32771:'kao', 32772:'mao', 32773:'zhe',
    32774:'qi', 32779:'die', 32780:'er', 32781:'shua', 32784:'nai', 32786:'lei',
    32788:'zi', 32789:'geng', 32790:'chao', 32791:'hao', 32792:'yun',
    32793:'pa', 32796:'si', 32800:'huo', 32802:'lao', 32805:'tang', 32806:'ou',
    32807:'lou', 32808:'nou', 32809:'jiang', 32810:'pang', 32817:'mo',
    32819:'er', 32821:'ding', 32822:'ye', 32823:'da', 32824:'song', 32827:'chi',
    32829:'dan', 32831:'geng', 32834:'nie', 32835:'dan', 32838:'ling',
    32842:'liao', 32843:'long', 32844:'zhi', 32845:'ning', 32850:'guo',
    32852:'lian', 32856:'pin', 32858:'ju', 32873:'kui', 32874:'cong',
    32881:'ao', 32895:'yu', 32896:'yu', 32899:'su', 32900:'yi', 32902:'si',
    32903:'zhao', 32905:'rou', 32907:'lei', 32908:'ji', 32915:'huang',
    32918:'xiao', 32920:'zhou', 32922:'du', 32923:'gang', 32924:'rong',
    32925:'gan', 32927:'wo', 32928:'chang', 32929:'gu', 32930:'zhi', 32932:'fu',
    32933:'fei', 32937:'jian', 32938:'fang', 32939:'zhun', 32941:'na',
    32942:'ang', 32943:'ken', 32945:'gong', 32946:'yu', 32948:'yao',
    32951:'qian', 32954:'fei', 32956:'jing', 32957:'tai', 32958:'shen',
    32959:'zhong', 32960:'zhang', 32961:'xie', 32962:'shen', 32963:'wei',
    32964:'zhou', 32966:'dan', 32972:'bei', 32973:'gua', 32974:'tai',
    32982:'pang', 32983:'zhen', 32985:'zuo', 32986:'pei', 32987:'jia',
    32988:'sheng', 32989:'zhi', 32990:'bao', 32993:'hu', 32996:'yin',
    32997:'xu', 32999:'long', 33000:'dong', 33001:'ka', 33002:'lu',
    33003:'jing', 33004:'nu', 33005:'yan', 33007:'kua', 33008:'yi',
    33009:'guang', 33010:'hai', 33011:'ge', 33012:'dong', 33014:'jiao',
    33016:'xiong', 33018:'an', 33020:'pian', 33021:'neng', 33026:'zhi',
    33030:'cui', 33033:'mai', 33034:'ji', 33037:'kuai', 33038:'sa',
    33039:'zang', 33040:'qi', 33041:'nao', 33042:'mi', 33043:'nong',
    33044:'luan', 33046:'bo', 33048:'wan', 33050:'jiao', 33054:'cuo',
    33068:'pao', 33071:'pu', 33073:'tuo', 33074:'niao', 33078:'luo',
    33080:'lian', 33086:'pi', 33094:'tian', 33096:'jing', 33098:'la',
    33099:'ye', 33100:'yan', 33104:'fu', 33105:'fu', 33107:'fei', 33108:'qiang',
    33109:'wan', 33113:'zong', 33114:'ding', 33120:'cou', 33125:'xing',
    33127:'shu', 33129:'nan', 33133:'e', 33134:'sai', 33136:'yao', 33137:'jian',
    33140:'yu', 33145:'fu', 33146:'xian', 33147:'ni', 33148:'mian', 33149:'wa',
    33150:'teng', 33151:'tui', 33152:'bang', 33154:'lv', 33160:'ge', 33162:'bo',
    33167:'gao', 33169:'bin', 33176:'biao', 33179:'tang', 33180:'mo',
    33181:'xi', 33187:'zhi', 33190:'lin', 33192:'peng', 33194:'chuai',
    33203:'shan', 33210:'ying', 33211:'shan', 33216:'tun', 33217:'lian',
    33218:'bi', 33219:'yong', 33222:'yi', 33226:'sao', 33228:'gu', 33251:'chen',
    33255:'zang', 33258:'zi', 33260:'nie', 33261:'chou', 33267:'zhi',
    33268:'zhi', 33275:'zhen', 33276:'jiu', 33278:'yu', 33280:'yao', 33281:'yu',
    33282:'chong', 33284:'xi', 33285:'jiu', 33286:'yu', 33292:'she',
    33293:'she', 33296:'shi', 33298:'shu', 33300:'tian', 33307:'chuan',
    33308:'shun', 33310:'wu', 33311:'zhou', 33313:'chuan', 33314:'shan',
    33315:'yi', 33320:'ban', 33322:'hang', 33323:'fang', 33324:'ban',
    33325:'bi', 33327:'zhong', 33328:'jian', 33329:'cang', 33331:'zhu',
    33332:'ze', 33333:'duo', 33334:'bo', 33335:'xian', 33336:'ge',
    33337:'chuan', 33339:'lu', 33342:'xi', 33348:'shao', 33351:'ting',
    33353:'wei', 33355:'meng', 33359:'shou', 33368:'sou', 33370:'cao',
    33375:'chong', 33384:'meng', 33390:'gen', 33391:'liang', 33392:'jian',
    33394:'se', 33395:'yan', 33396:'fu', 33401:'cao', 33402:'yi', 33405:'jiao',
    33406:'ai', 33407:'nai', 33410:'jie', 33412:'wan', 33416:'mi', 33418:'qian',
    33419:'yu', 33421:'shao', 33422:'xiong', 33423:'du', 33425:'qi',
    33426:'mang', 33431:'xiang', 33432:'pi', 33433:'fu', 33436:'wu',
    33437:'zhi', 33439:'shan', 33441:'qian', 33444:'kou', 33445:'jie',
    33446:'lu', 33448:'ji', 33449:'qin', 33450:'qi', 33451:'yuan', 33452:'fen',
    33453:'ba', 33454:'rui', 33455:'xin', 33456:'ji', 33457:'hua', 33459:'fang',
    33460:'wu', 33463:'zhi', 33464:'yun', 33465:'qin', 33469:'ya', 33470:'fei',
    33473:'cong', 33476:'bian', 33479:'wei', 33480:'li', 33482:'e',
    33483:'xian', 33484:'chang', 33485:'cang', 33486:'zhu', 33487:'su',
    33489:'yuan', 33490:'ran', 33491:'ling', 33492:'tai', 33493:'tiao',
    33495:'miao', 33496:'qing', 33499:'ke', 33500:'mu', 33502:'bao',
    33503:'gou', 33504:'min', 33505:'yi', 33507:'ju', 33508:'pie', 33509:'ruo',
    33510:'ku', 33515:'shan', 33519:'ben', 33521:'ying', 33524:'ju',
    33527:'gan', 33529:'ping', 33531:'fu', 33537:'zhuo', 33538:'mao',
    33539:'fan', 33540:'qie', 33541:'mao', 33542:'mao', 33543:'ba', 33544:'zi',
    33545:'mo', 33548:'chi', 33550:'jing', 33551:'long', 33553:'niao',
    33556:'ying', 33557:'qiong', 33559:'ming', 33562:'yin', 33563:'gen',
    33564:'qian', 33575:'jian', 33576:'ci', 33579:'mang', 33580:'cha',
    33581:'jiao', 33583:'fu', 33585:'zhu', 33587:'jiang', 33588:'hui',
    33589:'yin', 33590:'cha', 33592:'rong', 33593:'ru', 33594:'chong',
    33596:'tong', 33600:'xun', 33603:'quan', 33606:'jing', 33607:'xing',
    33609:'cao', 33615:'ren', 33616:'jian', 33617:'yi', 33618:'huang',
    33620:'li', 33626:'jia', 33627:'rao', 33628:'bi', 33630:'qiao', 33631:'hui',
    33632:'ji', 33633:'dang', 33635:'rong', 33636:'hun', 33637:'xing',
    33638:'luo', 33639:'ying', 33640:'xun', 33641:'jin', 33642:'sun',
    33643:'yin', 33644:'mai', 33645:'hong', 33646:'zhou', 33647:'yao',
    33655:'he', 33656:'bi', 33659:'di', 33660:'tu', 33661:'sui', 33669:'li',
    33670:'pu', 33673:'li', 33678:'sha', 33682:'ju', 33683:'mei', 33688:'shen',
    33691:'ting', 33692:'you', 33694:'guan', 33696:'you', 33704:'liang',
    33705:'fu', 33706:'e', 33707:'mo', 33712:'kan', 33713:'lai', 33714:'lian',
    33715:'shi', 33716:'wo', 33718:'xian', 33719:'huo', 33720:'you',
    33721:'ying', 33722:'ying', 33724:'chun', 33725:'mang', 33728:'wan',
    33729:'jing', 33733:'jian', 33735:'gu', 33738:'ju', 33740:'jun', 33743:'he',
    33748:'fu', 33750:'chang', 33752:'song', 33756:'cai', 33757:'ba',
    33759:'tu', 33760:'bo', 33761:'han', 33765:'xi', 33769:'pu', 33770:'dang',
    33776:'gu', 33777:'ling', 33778:'fei', 33784:'yan', 33785:'zu', 33789:'shu',
    33793:'ji', 33795:'cui', 33796:'tao', 33798:'bi', 33803:'qi', 33804:'meng',
    33805:'ping', 33806:'wei', 33807:'dan', 33809:'huan', 33816:'nai',
    33820:'tie', 33821:'luo', 33828:'ying', 33829:'ying', 33830:'ying',
    33831:'xiao', 33832:'sa', 33841:'xuan', 33848:'yu', 33852:'e', 33853:'luo',
    33862:'bao', 33873:'feng', 33879:'zhu', 33881:'xiang', 33882:'shen',
    33883:'ge', 33884:'qia', 33889:'pu', 33891:'dong', 33897:'pa', 33899:'hu',
    33900:'zang', 33901:'jia', 33905:'cong', 33907:'wei', 33909:'kui',
    33910:'ting', 33912:'xi', 33914:'qi', 33922:'di', 33927:'chan', 33928:'kai',
    33929:'kui', 33931:'jiang', 33932:'lou', 33934:'pai', 33943:'lang',
    33945:'meng', 33948:'suan', 33953:'bang', 33967:'kuai', 33970:'pu',
    33972:'shuo', 33976:'zheng', 33977:'jian', 33978:'ji', 33981:'en',
    33983:'hao', 33985:'zhen', 33988:'xu', 33993:'rong', 33994:'weng',
    33997:'shi', 34000:'ru', 34001:'suo', 34003:'bei', 34006:'bi', 34013:'lan',
    34015:'ji', 34016:'li', 34019:'yu', 34021:'ying', 34022:'mo', 34028:'peng',
    34032:'xi', 34044:'liao', 34047:'xu', 34060:'su', 34065:'mie', 34067:'man',
    34071:'zhe', 34074:'wei', 34079:'cu', 34081:'cai', 34091:'nian',
    34092:'shu', 34103:'qiang', 34104:'dou', 34105:'lian', 34106:'lin',
    34107:'kou', 34108:'ai', 34109:'bi', 34115:'fan', 34120:'xun', 34121:'jiao',
    34122:'rui', 34134:'qu', 34137:'hui', 34142:'zui', 34148:'rui', 34152:'jue',
    34162:'qi', 34164:'yun', 34169:'weng', 34170:'ji', 34171:'hong',
    34174:'lei', 34180:'bao', 34181:'hao', 34183:'wei', 34191:'yi', 34203:'xue',
    34204:'bi', 34212:'xie', 34216:'hong', 34218:'xin', 34222:'sou',
    34223:'shu', 34224:'xun', 34231:'ru', 34233:'tai', 34241:'gao', 34249:'ji',
    34255:'zang', 34256:'miao', 34259:'xian', 34261:'ou', 34268:'li',
    34276:'teng', 34281:'fan', 34299:'zao', 34303:'huo', 34309:'heng',
    34321:'mo', 34326:'nie', 34343:'qu', 34345:'fan', 34360:'zhan', 34364:'mi',
    34381:'hu', 34382:'hu', 34383:'lu', 34384:'nve', 34385:'lv', 34388:'qian',
    34394:'xu', 34398:'yu', 34402:'guo', 34411:'chong', 34412:'qiu', 34414:'ji',
    34417:'shi', 34425:'hong', 34426:'hui', 34427:'meng', 34428:'ge',
    34429:'sui', 34430:'xia', 34431:'chai', 34432:'shi', 34433:'yi', 34434:'ma',
    34442:'wen', 34443:'rui', 34444:'bang', 34445:'pi', 34451:'yin',
    34453:'can', 34460:'ya', 34461:'hao', 34467:'gong', 34468:'zao',
    34471:'jie', 34472:'fu', 34473:'chi', 34474:'dou', 34476:'xian',
    34479:'qiu', 34480:'you', 34481:'zha', 34484:'you', 34485:'ke', 34486:'han',
    34490:'ran', 34496:'zhu', 34500:'gu', 34502:'qu', 34503:'she', 34505:'ling',
    34506:'gu', 34507:'dan', 34510:'li', 34511:'cheng', 34512:'qu', 34513:'mou',
    34516:'hui', 34520:'yang', 34521:'wa', 34523:'zhu', 34526:'kuo',
    34527:'jiao', 34532:'ha', 34537:'qiong', 34541:'zhi', 34542:'man',
    34544:'zhe', 34545:'jia', 34546:'nao', 34547:'si', 34548:'qi', 34552:'xiao',
    34553:'yong', 34558:'e', 34560:'shu', 34562:'feng', 34563:'shen',
    34567:'zhe', 34568:'wu', 34569:'fu', 34570:'li', 34573:'chu', 34578:'yan',
    34579:'ting', 34581:'tui', 34583:'wo', 34584:'zhi', 34586:'fei', 34588:'mi',
    34590:'qi', 34593:'la', 34594:'meng', 34595:'qiang', 34597:'xi',
    34601:'tiao', 34606:'yu', 34609:'pi', 34612:'yi', 34615:'quan',
    34619:'qing', 34622:'guo', 34623:'wan', 34631:'ying', 34632:'guo',
    34633:'chan', 34636:'ke', 34638:'xie', 34643:'yu', 34647:'huang',
    34649:'bian', 34656:'fu', 34659:'you', 34660:'qiu', 34661:'mao', 34670:'fu',
    34672:'kui', 34676:'hu', 34678:'die', 34683:'nan', 34684:'lou',
    34685:'chun', 34686:'rong', 34690:'lang', 34691:'pang', 34693:'xi',
    34696:'yuan', 34699:'sou', 34701:'rong', 34707:'qin', 34711:'tang',
    34719:'ming', 34728:'man', 34731:'shi', 34732:'cao', 34733:'chi',
    34735:'ao', 34739:'tang', 34741:'piao', 34746:'luo', 34749:'zhong',
    34752:'shuai', 34758:'ma', 34762:'mao', 34763:'xi', 34769:'zhang',
    34770:'mang', 34771:'xiang', 34779:'peng', 34784:'pan', 34789:'huang',
    34794:'hui', 34798:'shan', 34809:'xie', 34814:'chan', 34819:'luo',
    34826:'lian', 34835:'meng', 34837:'ru', 34838:'huo', 34843:'mie',
    34849:'li', 34850:'chun', 34866:'juan', 34873:'du', 34876:'qu', 34880:'xue',
    34884:'nv', 34885:'xin', 34892:'xing', 34893:'yan', 34900:'xian',
    34903:'jie', 34905:'ya', 34913:'heng', 34914:'qu', 34915:'yi', 34916:'yi',
    34917:'bu', 34920:'biao', 34921:'cha', 34923:'shan', 34924:'chen',
    34926:'gun', 34928:'shuai', 34930:'na', 34935:'zhong', 34941:'ren',
    34942:'qin', 34943:'jin', 34945:'yuan', 34946:'mei', 34948:'ao',
    34949:'niao', 34952:'jia', 34955:'dai', 34957:'pao', 34962:'tan',
    34966:'xiu', 34972:'wa', 34978:'pan', 34980:'mao', 34987:'bei', 34989:'xi',
    34993:'fu', 34999:'jia', 35004:'ge', 35009:'cai', 35010:'lie',
    35013:'zhuang', 35014:'dang', 35017:'ken', 35022:'cheng', 35026:'pou',
    35028:'yi', 35029:'yu', 35032:'qiu', 35033:'qun', 35039:'sha', 35042:'lian',
    35043:'lian', 35044:'ku', 35045:'jian', 35048:'bi', 35056:'duo',
    35057:'biao', 35059:'shang', 35060:'pei', 35064:'luo', 35065:'guo',
    35068:'xi', 35070:'ju', 35074:'gua', 35082:'bian', 35088:'he', 35090:'bao',
    35091:'bao', 35097:'bei', 35098:'zhu', 35099:'lv', 35105:'da', 35109:'ru',
    35114:'tui', 35115:'chi', 35120:'qian', 35124:'lan', 35126:'zhe',
    35137:'qiang', 35140:'xiang', 35166:'bi', 35167:'jin', 35174:'ru',
    35195:'pan', 35199:'xi', 35201:'yao', 35203:'tan', 35206:'fu', 35265:'jian',
    35266:'guan', 35268:'gui', 35269:'mi', 35270:'shi', 35271:'chan',
    35272:'lan', 35273:'jue', 35274:'ji', 35275:'xi', 35276:'di', 35278:'yu',
    35279:'gou', 35280:'jin', 35281:'qu', 35282:'jiao', 35286:'jue', 35290:'gu',
    35292:'zi', 35294:'shang', 35299:'jie', 35301:'gong', 35302:'chu',
    35307:'su', 35311:'zhi', 35315:'hu', 35328:'yan', 35335:'hong', 35390:'zi',
    35400:'li', 35449:'zhan', 35465:'yu', 35466:'teng', 35475:'shi',
    35591:'jian', 35622:'qing', 35686:'jing', 35692:'pi', 35744:'yan',
    35745:'ji', 35746:'ding', 35747:'fu', 35748:'ren', 35749:'ji', 35750:'jie',
    35751:'hong', 35752:'tao', 35753:'rang', 35754:'shan', 35755:'qi',
    35757:'xun', 35758:'yi', 35759:'xun', 35760:'ji', 35762:'jiang',
    35763:'hui', 35764:'ou', 35765:'ju', 35766:'ya', 35767:'ne', 35768:'xu',
    35769:'e', 35770:'lun', 35772:'song', 35773:'feng', 35774:'she',
    35775:'fang', 35776:'jue', 35777:'zheng', 35778:'gu', 35779:'he',
    35780:'ping', 35781:'zu', 35782:'shi', 35784:'zha', 35785:'su',
    35786:'zhen', 35787:'di', 35788:'zhou', 35789:'ci', 35790:'qu',
    35791:'zhao', 35793:'yi', 35794:'yi', 35795:'kuang', 35796:'lei',
    35797:'shi', 35798:'gua', 35799:'shi', 35800:'jie', 35801:'hui',
    35802:'cheng', 35803:'zhu', 35804:'shen', 35805:'hua', 35806:'dan',
    35807:'gou', 35808:'quan', 35809:'gui', 35810:'xun', 35811:'yi',
    35812:'zheng', 35813:'gai', 35814:'xiang', 35815:'cha', 35816:'hun',
    35817:'xu', 35819:'jie', 35820:'wu', 35821:'yu', 35822:'qiao', 35823:'wu',
    35824:'gao', 35825:'you', 35826:'hui', 35827:'kuang', 35828:'shuo',
    35829:'song', 35830:'ei', 35831:'qing', 35832:'zhu', 35833:'zou',
    35834:'nuo', 35835:'du', 35836:'zhuo', 35837:'fei', 35838:'ke', 35839:'wei',
    35840:'yu', 35841:'shei', 35842:'shen', 35843:'tiao', 35844:'chan',
    35845:'liang', 35846:'zhun', 35847:'sui', 35848:'tan', 35850:'yi',
    35851:'mou', 35852:'chen', 35853:'die', 35854:'huang', 35855:'jian',
    35856:'xie', 35857:'xue', 35858:'ye', 35859:'wei', 35860:'e', 35861:'yu',
    35862:'xuan', 35863:'chan', 35864:'zi', 35865:'an', 35866:'yan', 35867:'di',
    35868:'mi', 35869:'pian', 35871:'mo', 35872:'dang', 35873:'su', 35874:'xie',
    35875:'yao', 35876:'bang', 35877:'shi', 35878:'qian', 35879:'mi',
    35880:'jin', 35881:'man', 35882:'zhe', 35883:'jian', 35884:'miu',
    35885:'tan', 35886:'zen', 35887:'qiao', 35888:'lan', 35889:'pu',
    35890:'jue', 35891:'yan', 35892:'qian', 35893:'zhan', 35894:'chen',
    35895:'gu', 35905:'huo', 35910:'dou', 35911:'jiang', 35913:'chi',
    35916:'wan', 35925:'shi', 35930:'tun', 35937:'xiang', 35938:'huan',
    35946:'hao', 35947:'yu', 35955:'bin', 35960:'zhi', 35961:'bao',
    35962:'chai', 35970:'diao', 35973:'xiu', 35977:'he', 35978:'mo',
    35980:'mao', 35988:'pi', 35992:'mo', 36125:'bei', 36126:'zhen', 36127:'fu',
    36129:'gong', 36130:'cai', 36131:'ze', 36132:'xian', 36133:'bai',
    36134:'zhang', 36135:'huo', 36136:'zhi', 36137:'fan', 36138:'tan',
    36139:'pin', 36140:'bian', 36141:'gou', 36142:'zhu', 36143:'guan',
    36144:'er', 36145:'jian', 36146:'bi', 36147:'shi', 36148:'tie', 36149:'gui',
    36150:'kuang', 36151:'dai', 36152:'mao', 36153:'fei', 36154:'he',
    36155:'yi', 36156:'zei', 36157:'zhi', 36158:'jia', 36159:'hui', 36160:'zi',
    36161:'lin', 36162:'lu', 36163:'zang', 36164:'zi', 36165:'gai', 36166:'jin',
    36167:'qiu', 36168:'zhen', 36169:'lai', 36170:'she', 36171:'fu', 36172:'du',
    36173:'ji', 36174:'shu', 36175:'shang', 36176:'ci', 36179:'geng',
    36180:'pei', 36181:'dan', 36182:'lai', 36184:'zhui', 36185:'fu',
    36186:'zhuan', 36187:'sai', 36188:'ze', 36189:'yan', 36190:'zan',
    36192:'zeng', 36193:'shan', 36194:'ying', 36195:'gan', 36196:'chi',
    36198:'she', 36199:'nan', 36203:'he', 36205:'zhe', 36208:'zou', 36211:'jiu',
    36212:'fu', 36213:'zhao', 36214:'gan', 36215:'qi', 36225:'chen',
    36228:'qie', 36229:'chao', 36234:'yue', 36235:'qu', 36241:'zi', 36244:'lie',
    36255:'tang', 36259:'qu', 36273:'zan', 36275:'zu', 36276:'pa', 36277:'bao',
    36280:'dun', 36282:'fu', 36284:'jian', 36286:'zhi', 36287:'ta', 36291:'yue',
    36292:'qiang', 36294:'tai', 36299:'ba', 36300:'die', 36302:'tuo',
    36303:'jia', 36305:'pao', 36310:'zhi', 36311:'fu', 36314:'shan', 36315:'bo',
    36317:'ju', 36318:'li', 36319:'gen', 36323:'xian', 36324:'jiao',
    36328:'kua', 36330:'gui', 36331:'qiong', 36332:'kui', 36335:'lu',
    36339:'tiao', 36341:'jian', 36343:'qiao', 36344:'bi', 36345:'xian',
    36346:'duo', 36347:'ji', 36349:'ji', 36357:'xue', 36361:'liang',
    36362:'yong', 36364:'chou', 36367:'ta', 36372:'chuo', 36381:'huai',
    36382:'ju', 36383:'chi', 36386:'ti', 36387:'bo', 36393:'cai', 36394:'zong',
    36396:'zhi', 36398:'dian', 36399:'zhi', 36401:'duo', 36405:'zhong',
    36409:'chuai', 36410:'jian', 36413:'ju', 36416:'die', 36417:'pian',
    36418:'rou', 36420:'ti', 36423:'jian', 36424:'dao', 36425:'cuo', 36426:'xi',
    36427:'ta', 36433:'nie', 36434:'pan', 36441:'cu', 36454:'beng', 36457:'bie',
    36460:'deng', 36461:'ceng', 36463:'fan', 36464:'chu', 36466:'dun',
    36468:'cu', 36470:'jue', 36476:'pu', 36479:'cuan', 36481:'zao', 36485:'zhu',
    36487:'chu', 36495:'lin', 36496:'lie', 36500:'chan', 36508:'zuan',
    36510:'xie', 36523:'shen', 36524:'gong', 36527:'qu', 36530:'duo',
    36538:'tang', 36558:'wei', 36710:'che', 36711:'zha', 36712:'gui',
    36713:'xuan', 36715:'ren', 36716:'zhuan', 36717:'e', 36718:'lun',
    36719:'ruan', 36720:'hong', 36721:'gu', 36722:'ke', 36723:'lu',
    36724:'zhou', 36725:'zhi', 36726:'yi', 36727:'hu', 36728:'zhen', 36729:'li',
    36730:'yao', 36731:'qing', 36732:'shi', 36733:'zai', 36734:'zhi',
    36735:'jiao', 36737:'quan', 36738:'lu', 36739:'jiao', 36740:'zhe',
    36741:'fu', 36742:'liang', 36743:'nian', 36744:'bei', 36745:'hui',
    36746:'gun', 36747:'wang', 36749:'chuo', 36750:'zi', 36751:'cou',
    36752:'fu', 36753:'ji', 36755:'shu', 36756:'pei', 36757:'yuan', 36758:'xia',
    36759:'zhan', 36760:'lu', 36761:'zhe', 36762:'lin', 36763:'xin', 36764:'gu',
    36766:'ci', 36767:'pi', 36771:'la', 36776:'bian', 36777:'bian',
    36779:'bian', 36784:'chen', 36785:'ru', 36790:'chuo', 36793:'bian',
    36797:'liao', 36798:'da', 36801:'qian', 36802:'yu', 36804:'qi', 36805:'xun',
    36807:'guo', 36808:'mai', 36814:'ying', 36816:'yun', 36817:'jin',
    36819:'ya', 36820:'fan', 36821:'wu', 36824:'hai', 36825:'zhe', 36827:'jin',
    36828:'yuan', 36829:'wei', 36830:'lian', 36831:'chi', 36834:'tiao',
    36836:'yi', 36837:'jiong', 36838:'jia', 36840:'dai', 36841:'er', 36842:'di',
    36843:'po', 36845:'die', 36846:'ze', 36848:'shu', 36851:'jing', 36855:'mi',
    36856:'beng', 36857:'ji', 36861:'zhui', 36864:'tui', 36865:'song',
    36866:'shi', 36867:'tao', 36868:'pang', 36869:'hou', 36870:'ni',
    36873:'xuan', 36874:'xun', 36875:'bu', 36877:'xiao', 36879:'tou',
    36880:'zhu', 36881:'qiu', 36882:'di', 36884:'tu', 36886:'ti', 36887:'dou',
    36890:'tong', 36891:'guang', 36893:'shi', 36894:'cheng', 36895:'su',
    36896:'zao', 36897:'qun', 36898:'feng', 36902:'li', 36909:'huan',
    36910:'dai', 36911:'lu', 36917:'kui', 36918:'wei', 36920:'yi', 36923:'luo',
    36924:'bi', 36926:'yu', 36929:'dun', 36930:'sui', 36932:'chuan', 36935:'yu',
    36941:'bian', 36943:'e', 36944:'xia', 36945:'huang', 36946:'qiu',
    36947:'dao', 36951:'yi', 36952:'gou', 36955:'liu', 36962:'ta', 36963:'qian',
    36965:'yao', 36968:'ao', 36973:'zao', 36974:'zhe', 36980:'lin', 36981:'zun',
    36989:'ju', 36991:'bi', 36992:'yao', 36994:'xie', 36995:'sui', 37000:'miao',
    37003:'la', 37009:'yi', 37011:'deng', 37013:'yong', 37015:'han',
    37017:'mang', 37019:'qiong', 37021:'kuang', 37025:'fang', 37026:'xing',
    37027:'na', 37030:'bang', 37034:'xie', 37036:'wu', 37038:'you', 37039:'han',
    37040:'tai', 37041:'qiu', 37043:'pi', 37044:'bing', 37045:'shao',
    37046:'bei', 37048:'di', 37049:'zou', 37050:'ye', 37051:'lin', 37054:'zhu',
    37057:'yu', 37060:'qie', 37061:'zhi', 37063:'xun', 37066:'jiao',
    37070:'lang', 37071:'jia', 37072:'kuai', 37073:'zheng', 37075:'yun',
    37079:'xi', 37083:'fu', 37084:'gao', 37085:'hao', 37089:'jun', 37090:'ying',
    37094:'li', 37095:'yun', 37096:'bu', 37099:'pi', 37101:'guo', 37103:'tan',
    37108:'chen', 37112:'dan', 37117:'dou', 37118:'yan', 37122:'e',
    37124:'juan', 37145:'bi', 37150:'yin', 37154:'yan', 37155:'zhang',
    37167:'shan', 37169:'po', 37177:'zou', 37187:'ling', 37190:'feng',
    37193:'you', 37194:'ding', 37195:'qiu', 37196:'zhuo', 37197:'pei',
    37198:'zhou', 37199:'yi', 37200:'gan', 37202:'jiu', 37207:'xu', 37210:'fen',
    37213:'yun', 37214:'tai', 37217:'tuo', 37218:'zuo', 37219:'han', 37220:'gu',
    37221:'su', 37225:'ming', 37226:'lao', 37228:'chou', 37230:'tong',
    37231:'zhi', 37232:'xian', 37233:'jiang', 37234:'cheng', 37236:'tu',
    37237:'jiao', 37238:'mei', 37239:'ku', 37240:'suan', 37241:'lei',
    37245:'yan', 37246:'shi', 37247:'niang', 37253:'pei', 37255:'chun',
    37257:'zui', 37259:'cu', 37260:'kun', 37261:'ti', 37264:'hu', 37265:'xu',
    37266:'xing', 37274:'mi', 37275:'quan', 37282:'hai', 37283:'tang',
    37290:'lao', 37293:'bu', 37294:'jiao', 37295:'xi', 37300:'li', 37301:'ju',
    37306:'xun', 37319:'cai', 37321:'you', 37322:'shi', 37324:'li',
    37325:'chong', 37326:'ye', 37327:'liang', 37329:'jin', 37340:'fu',
    37492:'jian', 37518:'qiong', 37550:'luan', 37576:'wu', 37694:'zan',
    37738:'mou', 37775:'liu', 37834:'ao', 37846:'ao', 37950:'bei', 37995:'xin',
    38021:'jin', 38022:'ga', 38023:'yi', 38024:'zhen', 38025:'ding',
    38026:'zhao', 38027:'po', 38028:'liao', 38029:'tu', 38030:'qian',
    38031:'chuan', 38032:'shan', 38034:'fan', 38035:'diao', 38036:'men',
    38037:'nv', 38039:'chai', 38041:'gai', 38042:'bu', 38043:'tai', 38044:'ju',
    38045:'dun', 38046:'chao', 38047:'zhong', 38048:'na', 38049:'bei',
    38050:'gang', 38051:'ban', 38052:'qian', 38053:'yao', 38054:'qin',
    38055:'jun', 38056:'wu', 38057:'gou', 38058:'kang', 38059:'fang',
    38060:'huo', 38061:'tou', 38062:'niu', 38063:'ba', 38064:'yu', 38065:'qian',
    38066:'zheng', 38067:'qian', 38068:'gu', 38069:'bo', 38070:'ke', 38071:'po',
    38072:'bu', 38073:'bo', 38074:'yue', 38075:'zuan', 38076:'mu', 38077:'tan',
    38078:'jia', 38079:'dian', 38080:'you', 38081:'tie', 38082:'bo',
    38083:'ling', 38084:'shuo', 38085:'qian', 38086:'mao', 38088:'shi',
    38089:'xuan', 38090:'ta', 38091:'bi', 38092:'ni', 38093:'pi', 38094:'duo',
    38096:'kao', 38097:'lao', 38098:'er', 38101:'you', 38102:'cheng',
    38103:'jia', 38104:'ye', 38105:'nao', 38107:'dang', 38108:'tong',
    38109:'lv', 38110:'diao', 38111:'yin', 38112:'kai', 38113:'zha',
    38114:'zhu', 38115:'xi', 38116:'ting', 38117:'diu', 38119:'hua',
    38120:'quan', 38121:'sha', 38122:'ha', 38123:'diao', 38124:'ge',
    38125:'ming', 38126:'zheng', 38127:'se', 38128:'jiao', 38129:'yi',
    38130:'chan', 38131:'chong', 38132:'tang', 38133:'an', 38134:'yin',
    38135:'ru', 38136:'zhu', 38137:'lao', 38138:'pu', 38140:'lai', 38141:'te',
    38142:'lian', 38143:'keng', 38144:'xiao', 38145:'suo', 38146:'li',
    38147:'zeng', 38148:'chu', 38149:'guo', 38150:'gao', 38151:'e', 38152:'xiu',
    38153:'cuo', 38154:'lve', 38155:'feng', 38156:'xin', 38157:'liu',
    38158:'kai', 38159:'jian', 38160:'rui', 38161:'ti', 38162:'lang',
    38163:'qin', 38164:'ju', 38165:'a', 38166:'qing', 38167:'zhe', 38168:'nuo',
    38169:'cuo', 38170:'mao', 38171:'ben', 38173:'de', 38174:'ke', 38175:'kun',
    38177:'xi', 38178:'gu', 38179:'luo', 38180:'chui', 38181:'zhui',
    38182:'jin', 38184:'xian', 38185:'juan', 38186:'huo', 38187:'pei',
    38188:'tan', 38189:'ding', 38190:'jian', 38191:'ju', 38192:'meng',
    38193:'zi', 38194:'qie', 38196:'kai', 38197:'qiang', 38198:'si', 38199:'e',
    38200:'cha', 38201:'qiao', 38202:'zhong', 38203:'duan', 38204:'sou',
    38206:'huan', 38207:'ai', 38208:'du', 38209:'mei', 38210:'lou', 38212:'fei',
    38213:'mei', 38214:'mo', 38215:'zhen', 38217:'ge', 38218:'nie',
    38220:'juan', 38221:'nie', 38222:'na', 38223:'liu', 38224:'gao',
    38225:'pang', 38226:'yi', 38227:'jia', 38228:'bin', 38230:'biao',
    38231:'tang', 38232:'man', 38233:'luo', 38235:'yong', 38236:'jing',
    38237:'di', 38238:'zu', 38239:'xuan', 38241:'xin', 38242:'jue',
    38243:'liao', 38244:'pu', 38245:'lu', 38246:'dun', 38247:'lan', 38248:'pu',
    38249:'cuan', 38250:'qiang', 38251:'deng', 38252:'huo', 38253:'lei',
    38255:'zhuo', 38256:'lian', 38257:'yi', 38258:'cha', 38259:'biao',
    38262:'xiang', 38271:'zhang', 38376:'men', 38377:'shuan', 38378:'shan',
    38379:'yan', 38381:'bi', 38382:'wen', 38383:'chuang', 38384:'run',
    38385:'wei', 38386:'xian', 38387:'hong', 38388:'jian', 38389:'min',
    38390:'kang', 38391:'men', 38392:'zha', 38393:'nao', 38394:'gui',
    38395:'wen', 38396:'ta', 38397:'min', 38398:'lv', 38400:'fa', 38401:'ge',
    38402:'he', 38403:'kun', 38404:'jiu', 38405:'yue', 38406:'lang', 38408:'yu',
    38409:'yan', 38410:'chang', 38411:'xi', 38412:'wen', 38413:'hun',
    38414:'yan', 38415:'yan', 38416:'chan', 38417:'lan', 38418:'qu',
    38420:'kuo', 38421:'que', 38422:'he', 38423:'tian', 38425:'que',
    38426:'kan', 38428:'fu', 38429:'fu', 38431:'dui', 38433:'qian', 38434:'wu',
    38442:'ban', 38446:'ruan', 38449:'jing', 38450:'fang', 38451:'yang',
    38452:'yin', 38453:'zhen', 38454:'jie', 38459:'zu', 38460:'zuo',
    38461:'dian', 38463:'e', 38464:'tuo', 38466:'bei', 38468:'fu', 38469:'ji',
    38470:'lu', 38471:'long', 38472:'chen', 38473:'xing', 38475:'lou',
    38476:'mo', 38477:'jiang', 38480:'xian', 38484:'gai', 38485:'shan',
    38491:'bi', 38495:'zhi', 38497:'dou', 38498:'yuan', 38500:'chu',
    38503:'nie', 38504:'yun', 38505:'xian', 38506:'pei', 38508:'zou',
    38514:'chui', 38516:'pi', 38517:'ling', 38518:'tao', 38519:'xian',
    38533:'yu', 38534:'long', 38536:'wei', 38539:'sui', 38541:'huang',
    38543:'sui', 38544:'yin', 38548:'ge', 38551:'wei', 38552:'ai', 38553:'xi',
    38556:'zhang', 38567:'sui', 38576:'xi', 38579:'hui', 38582:'li',
    38585:'zhui', 38588:'sun', 38589:'juan', 38590:'nan', 38592:'que',
    38593:'yan', 38596:'xiong', 38597:'ya', 38598:'ji', 38599:'gu', 38601:'zhi',
    38604:'ci', 38605:'yong', 38606:'ju', 38607:'chu', 38610:'luo',
    38613:'diao', 38624:'chou', 38632:'yu', 38633:'yu', 38634:'xue',
    38639:'wen', 38643:'li', 38646:'ling', 38647:'lei', 38649:'bao', 38654:'wu',
    38656:'xu', 38657:'ji', 38660:'xiao', 38662:'ting', 38663:'zhen',
    38664:'pei', 38665:'mei', 38669:'huo', 38670:'sha', 38671:'fei', 38675:'ni',
    38678:'lin', 38684:'shuang', 38686:'xia', 38698:'yin', 38701:'ai',
    38704:'xian', 38706:'lu', 38712:'ba', 38713:'pi', 38718:'mai', 38738:'qing',
    38739:'jing', 38742:'jing', 38745:'jing', 38747:'dian', 38750:'fei',
    38752:'kao', 38753:'mi', 38754:'mian', 38757:'ye', 38761:'ge', 38771:'jin',
    38772:'xue', 38774:'ba', 38780:'da', 38789:'yang', 38795:'xie', 38797:'an',
    38801:'da', 38802:'qiao', 38804:'man', 38808:'qiao', 38816:'ju',
    38819:'rou', 38827:'ju', 38829:'bian', 38831:'jian', 38834:'gou',
    38836:'bei', 38886:'wei', 38887:'ren', 38889:'han', 38890:'wei',
    38891:'yun', 38892:'tao', 38893:'jiu', 38899:'yin', 38901:'yun',
    38902:'shao', 39029:'ye', 39030:'ding', 39031:'qing', 39032:'han',
    39033:'xiang', 39034:'shun', 39035:'xu', 39036:'xu', 39037:'wan',
    39038:'gu', 39039:'dun', 39040:'qi', 39041:'ban', 39042:'song',
    39043:'hang', 39044:'yu', 39045:'lu', 39046:'ling', 39047:'po',
    39048:'jing', 39049:'jie', 39050:'jia', 39052:'he', 39053:'ying',
    39055:'ke', 39056:'yi', 39057:'pin', 39059:'tui', 39060:'han', 39062:'ying',
    39063:'ke', 39064:'ti', 39066:'e', 39067:'zhuan', 39068:'yan', 39069:'e',
    39070:'nie', 39071:'man', 39072:'dian', 39073:'sang', 39074:'hao',
    39076:'chan', 39077:'ru', 39078:'pin', 39079:'quan', 39118:'feng',
    39121:'biao', 39122:'sa', 39123:'ju', 39125:'sou', 39128:'piao',
    39129:'biao', 39130:'biao', 39134:'fei', 39135:'shi', 39143:'sun',
    39144:'xiang', 39181:'yan', 39184:'can', 39214:'tie', 39252:'yong',
    39253:'tao', 39267:'shi', 39269:'ji', 39271:'xing', 39272:'tun', 39273:'xi',
    39274:'ren', 39275:'yu', 39276:'chi', 39277:'fan', 39278:'yin',
    39279:'jian', 39280:'shi', 39281:'bao', 39282:'si', 39284:'yi', 39285:'er',
    39286:'rao', 39287:'xiang', 39290:'jiao', 39292:'bing', 39293:'bo',
    39295:'e', 39296:'yu', 39297:'nei', 39300:'hun', 39301:'xian', 39302:'guan',
    39303:'cha', 39304:'kui', 39306:'sou', 39307:'chan', 39309:'mo',
    39311:'liu', 39312:'xiu', 39313:'jin', 39314:'man', 39315:'san',
    39316:'zhuan', 39317:'nang', 39318:'shou', 39319:'kui', 39320:'guo',
    39321:'xiang', 39333:'fu', 39336:'xin', 39532:'ma', 39533:'yu', 39534:'tuo',
    39535:'xun', 39536:'chi', 39537:'qu', 39539:'bo', 39540:'lv', 39541:'zang',
    39542:'shi', 39543:'si', 39544:'fu', 39545:'ju', 39546:'zou', 39547:'zhu',
    39548:'tuo', 39549:'nu', 39550:'jia', 39551:'yi', 39552:'tai', 39553:'xiao',
    39554:'ma', 39556:'jiao', 39557:'hua', 39558:'luo', 39559:'hai',
    39560:'pian', 39562:'li', 39563:'cheng', 39564:'yan', 39567:'jun',
    39568:'qi', 39569:'qi', 39570:'ke', 39571:'zhui', 39574:'can', 39575:'pian',
    39576:'zhi', 39578:'sao', 39579:'wu', 39580:'ao', 39581:'liu', 39582:'qian',
    39583:'shan', 39584:'piao', 39585:'luo', 39586:'cong', 39587:'zhan',
    39588:'zhou', 39589:'ji', 39591:'xiang', 39592:'gu', 39600:'tou',
    39601:'jie', 39606:'di', 39607:'ku', 39608:'hai', 39610:'hou', 39612:'ge',
    39616:'bi', 39617:'ke', 39618:'qia', 39621:'lou', 39627:'kuan', 39628:'bin',
    39633:'du', 39635:'sui', 39640:'gao', 39647:'biao', 39649:'kun',
    39654:'mao', 39659:'tiao', 39661:'zi', 39663:'ran', 39673:'xiu', 39675:'ji',
    39683:'zong', 39688:'quan', 39695:'jiu', 39699:'bin', 39711:'huan',
    39715:'lie', 39727:'chang', 39730:'ge', 39739:'yu', 39740:'gui',
    39745:'kui', 39746:'hun', 39747:'ba', 39748:'po', 39749:'mei', 39751:'yan',
    39752:'xiao', 39753:'liang', 39757:'wang', 39759:'wei', 39761:'chi',
    39764:'mo', 40060:'yu', 40063:'you', 40065:'lu', 40066:'fang', 40069:'ba',
    40070:'ping', 40071:'nian', 40072:'lu', 40075:'fu', 40077:'bao',
    40078:'hou', 40080:'tai', 40081:'gui', 40082:'jie', 40084:'wei', 40085:'er',
    40090:'ji', 40091:'jiao', 40092:'xian', 40094:'xiang', 40095:'xun',
    40096:'geng', 40097:'li', 40098:'lian', 40099:'jian', 40100:'li',
    40101:'shi', 40102:'tiao', 40103:'gun', 40104:'sha', 40105:'huan',
    40107:'ji', 40109:'qing', 40110:'ling', 40112:'zou', 40113:'fei',
    40114:'kun', 40115:'chang', 40116:'gu', 40117:'ni', 40118:'nian',
    40119:'diao', 40120:'jing', 40122:'shi', 40123:'zi', 40124:'fen',
    40125:'die', 40131:'sai', 40132:'e', 40133:'qiu', 40134:'fu', 40135:'huang',
    40138:'bian', 40139:'sao', 40140:'ao', 40141:'qi', 40142:'ta', 40143:'guan',
    40144:'yao', 40147:'le', 40148:'biao', 40149:'xue', 40150:'bie',
    40151:'man', 40152:'min', 40153:'yong', 40156:'gui', 40157:'shan',
    40158:'lin', 40159:'zun', 40162:'li', 40479:'niao', 40480:'jiu', 40481:'ji',
    40482:'yuan', 40483:'ming', 40485:'ou', 40486:'ya', 40488:'bao',
    40489:'zhen', 40490:'gu', 40491:'dong', 40492:'lu', 40493:'ya',
    40495:'yang', 40497:'chi', 40498:'qu', 40499:'yuan', 40501:'tuo',
    40502:'si', 40503:'zhi', 40504:'er', 40505:'gua', 40506:'xiu', 40509:'ge',
    40510:'luan', 40511:'hong', 40513:'bo', 40514:'li', 40515:'juan',
    40516:'hu', 40517:'e', 40518:'yu', 40519:'xian', 40520:'ti', 40521:'wu',
    40522:'que', 40523:'miao', 40524:'an', 40526:'bei', 40527:'peng',
    40529:'chun', 40533:'hu', 40535:'e', 40536:'gu', 40538:'ci', 40539:'mei',
    40540:'wu', 40542:'yao', 40547:'jian', 40548:'he', 40550:'ying',
    40551:'zhe', 40552:'liu', 40553:'liao', 40554:'jiao', 40555:'jiu',
    40556:'yu', 40557:'lu', 40560:'ying', 40561:'hu', 40563:'guan', 40574:'cuo',
    40575:'lu', 40578:'ji', 40583:'qun', 40584:'zhu', 40587:'mi', 40594:'qi',
    40595:'lu', 40605:'she', 40607:'lin', 40614:'mai', 40628:'qu', 40632:'fu',
    40635:'ma', 40637:'mo', 40638:'hui', 40644:'huang', 40649:'hong',
    40653:'shu', 40654:'li', 40655:'nian', 40657:'hei', 40660:'qian',
    40664:'mo', 40667:'dai', 40668:'chu', 40669:'you', 40671:'yi', 40672:'xia',
    40674:'qu', 40677:'qing', 40679:'li', 40681:'du', 40682:'can', 40687:'an',
    40697:'zhi', 40699:'fu', 40700:'fu', 40702:'min', 40715:'yuan', 40717:'tuo',
    40718:'ding', 40720:'nai', 40723:'gu', 40727:'tao', 40729:'pi', 40736:'shu',
    40738:'fen', 40748:'you', 40751:'wu', 40759:'xi', 40761:'yan', 40763:'bi',
    40765:'qiu', 40766:'han', 40772:'zha', 40784:'qi', 40785:'ji', 40831:'chi',
    40832:'chen', 40835:'ju', 40836:'ling', 40837:'bao', 40838:'tiao',
    40839:'zi', 40840:'yin', 40841:'yu', 40842:'chuo', 40843:'qu', 40844:'wo',
    40857:'long', 40858:'gong', 40859:'kan', 40863:'gui', 40864:'yue',
    65292:'-', 65311:''}
