"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * This is a basic example of how to create an FSxOntap construct.
 * You can test it out by running the following commands from the root of this repository:
 *
 * ```bash
 * # build project
 * npx projen build
 * # synthesize
 * cdk synth --app lib/examples/basic.js
 * # diff
 * cdk diff --app lib/examples/basic.js
 * # deploy
 * cdk deploy --app lib/examples/basic.js
 * # destroy
 * cdk destroy --app lib/examples/basic.js
 * ```
 */
const cdk = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
// change the below line to `import { FsxOntap } from 'cdk-fsx-ontap';`,
// when testing from outside of this repository.
const index_1 = require("../index");
// create a CDK app
const app = new cdk.App();
// create a CDK stack through which the FSxOntap construct will be created,
// together with a VPC and a Security Group.
const stack = new cdk.Stack(app, 'FsxOntapStack', {
    env: {
        region: process.env.CDK_DEFAULT_REGION,
        account: process.env.CDK_DEFAULT_ACCOUNT,
    },
});
// create a vpc with two private subnets
const vpc = new aws_ec2_1.Vpc(stack, 'VPC', {
    maxAzs: 2,
});
// create a security group from which the connection to FSx ONTAP will be allowed
const ec2SecurityGroup = new aws_ec2_1.SecurityGroup(stack, 'ec2SecurityGroup', {
    vpc,
    description: 'It can connect to FSx ONTAP',
    allowAllOutbound: true,
});
// create an FSxOntap construct
new index_1.FsxOntap(stack, 'FsxOntap', {
    vpc,
    securityGroupSource: ec2SecurityGroup,
});
//# sourceMappingURL=data:application/json;base64,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