import { SecurityGroup, Vpc } from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
export interface FsxOntapProps {
    /**
     * Name of the FSx for NetApp ONTAP Storage Virtual Machine (SVM).
     * Also used in resource ID creation, e.g. `${name}-resource-type`.
     * @default 'fsx-ontap'
     */
    readonly name?: string;
    /**
     * Path to mount the FSx for NetApp ONTAP instance.
     * @default '/mnt/fsx'
     */
    readonly mountPath?: string;
    /**
     * Name of the mount point.
     * @default '/datavol'
     */
    readonly mountName?: string;
    /**
     * VPC in which the FSx for NetApp ONTAP instance will be created.
     */
    readonly vpc: Vpc;
    readonly securityGroupSource: SecurityGroup;
}
export declare class FsxOntap extends Construct {
    readonly dnsName: string | undefined;
    readonly mountPath: string;
    readonly mountName: string;
    constructor(scope: Construct, id: string, props: FsxOntapProps);
    private replaceDashesWithUnderscores;
    private removeNonAlphanumericOrUnderscores;
    private trimStringAt203rdCharacter;
    /**
    * Configure Security Group for FsX
    * @see https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/limit-access-security-groups.html
    */
    private addIngressToFsxFromSourceSg;
}
