"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from billing import utils
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from typing import Optional


@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class AutoCollection:
    r"""Information about payment auto-collection for this invoice."""
    enabled: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('enabled'), 'exclude': lambda f: f is None }})
    r"""True only if auto-collection is enabled for this invoice."""
    next_attempt_at: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('next_attempt_at'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse }})
    r"""If the invoice is scheduled for auto-collection, this field will reflect when the next attempt will occur. If dunning has been exhausted, or auto-collection is not enabled for this invoice, this field will be `null`."""
    previously_attempted_at: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('previously_attempted_at'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse }})
    r"""If Orb has ever attempted payment auto-collection for this invoice, this field will reflect when that attempt occurred. In conjunction with `next_attempt_at`, this can be used to tell whether the invoice is currently in dunning (that is, `previously_attempted_at` is non-null, and `next_attempt_time` is non-null), or if dunning has been exhausted (`previously_attempted_at` is non-null, but `next_attempt_time` is null)."""
    

