"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from ..shared import bpspriceoverride as shared_bpspriceoverride
from ..shared import bulkbpspriceoverride as shared_bulkbpspriceoverride
from ..shared import bulkpriceoverride as shared_bulkpriceoverride
from ..shared import changeoption as shared_changeoption
from ..shared import packagepriceoverride as shared_packagepriceoverride
from ..shared import tieredbpspriceoverride as shared_tieredbpspriceoverride
from ..shared import tieredpriceoverride as shared_tieredpriceoverride
from ..shared import unitpriceoverride as shared_unitpriceoverride
from billing import utils
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from enum import Enum
from typing import Optional, Union

class SubscriptionPlanChangeBillingCycleAlignment(str, Enum):
    r"""Reset billing periods to be aligned with the plan change’s effective date or start of the month. Defaults to `unchanged` which keeps subscription's existing billing cycle alignment."""
    UNCHANGED = 'unchanged'
    PLAN_CHANGE_DATE = 'plan_change_date'
    START_OF_MONTH = 'start_of_month'


@dataclass_json(undefined=Undefined.EXCLUDE)

@dataclasses.dataclass
class SubscriptionPlanChange:
    change_option: shared_changeoption.ChangeOption = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('change_option') }})
    r"""Determines the timing of the plan change"""
    align_billing_with_plan_change_date: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('align_billing_with_plan_change_date'), 'exclude': lambda f: f is None }})
    r"""[DEPRECATED] Use billing_cycle_alignment instead. Reset billing periods to be aligned with the plan change’s effective date.

    Deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
    """
    billing_cycle_alignment: Optional[SubscriptionPlanChangeBillingCycleAlignment] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('billing_cycle_alignment'), 'exclude': lambda f: f is None }})
    r"""Reset billing periods to be aligned with the plan change’s effective date or start of the month. Defaults to `unchanged` which keeps subscription's existing billing cycle alignment."""
    change_date: Optional[datetime] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('change_date'), 'encoder': utils.datetimeisoformat(True), 'decoder': dateutil.parser.isoparse, 'exclude': lambda f: f is None }})
    r"""The date that the plan change should take effect. This parameter can only be passed if the `change_option` is `requested_date`."""
    coupon_redemption_code: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('coupon_redemption_code'), 'exclude': lambda f: f is None }})
    r"""Redemption code to be used for this subscription. If the coupon cannot be found by its redemption code, or cannot be redeemed, an error response will be returned and the plan change will not be scheduled."""
    external_plan_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('external_plan_id'), 'exclude': lambda f: f is None }})
    r"""The external_plan_id of the plan that the given subscription should be switched to. Note that either this property or `plan_id` must be specified."""
    maximum_amount: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('maximum_amount'), 'exclude': lambda f: f is None }})
    r"""The subscription's override maximum amount for the plan."""
    minimum_amount: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('minimum_amount'), 'exclude': lambda f: f is None }})
    r"""The subscription's override minimum amount for the plan."""
    plan_id: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('plan_id'), 'exclude': lambda f: f is None }})
    r"""The plan that the given subscription should be switched to. Note that either this property or `external_plan_id` must be specified."""
    price_overrides: Optional[list[Union[shared_tieredpriceoverride.TieredPriceOverride, shared_unitpriceoverride.UnitPriceOverride, shared_bulkpriceoverride.BulkPriceOverride, shared_packagepriceoverride.PackagePriceOverride, shared_bpspriceoverride.BPSPriceOverride, shared_bulkbpspriceoverride.BulkBPSPriceOverride, shared_tieredbpspriceoverride.TieredBPSPriceOverride]]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('price_overrides'), 'exclude': lambda f: f is None }})
    r"""Optionally provide a list of overrides for prices on the plan"""
    

