import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeFileFormatsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats#database DataSnowflakeFileFormats#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the file formats from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats#schema DataSnowflakeFileFormats#schema}
    */
    readonly schema: string;
}
export interface DataSnowflakeFileFormatsFileFormats {
}
export declare function dataSnowflakeFileFormatsFileFormatsToTerraform(struct?: DataSnowflakeFileFormatsFileFormats): any;
export declare class DataSnowflakeFileFormatsFileFormatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeFileFormatsFileFormats | undefined;
    set internalValue(value: DataSnowflakeFileFormatsFileFormats | undefined);
    get comment(): string;
    get database(): string;
    get formatType(): string;
    get name(): string;
    get schema(): string;
}
export declare class DataSnowflakeFileFormatsFileFormatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeFileFormatsFileFormatsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats snowflake_file_formats}
*/
export declare class DataSnowflakeFileFormats extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_file_formats";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/file_formats snowflake_file_formats} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeFileFormatsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeFileFormatsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _fileFormats;
    get fileFormats(): DataSnowflakeFileFormatsFileFormatsList;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-snowflake-file-formats.d.ts.map