import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeSchemasConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/schemas#database DataSnowflakeSchemas#database}
    */
    readonly database: string;
}
export interface DataSnowflakeSchemasSchemas {
}
export declare function dataSnowflakeSchemasSchemasToTerraform(struct?: DataSnowflakeSchemasSchemas): any;
export declare class DataSnowflakeSchemasSchemasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeSchemasSchemas | undefined;
    set internalValue(value: DataSnowflakeSchemasSchemas | undefined);
    get comment(): string;
    get database(): string;
    get name(): string;
}
export declare class DataSnowflakeSchemasSchemasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeSchemasSchemasOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/schemas snowflake_schemas}
*/
export declare class DataSnowflakeSchemas extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_schemas";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/schemas snowflake_schemas} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeSchemasConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeSchemasConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schemas;
    get schemas(): DataSnowflakeSchemasSchemasList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-snowflake-schemas.d.ts.map