import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MaskingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the masking policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#comment MaskingPolicy#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the masking policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#database MaskingPolicy#database}
    */
    readonly database: string;
    /**
    * Specifies the SQL expression that transforms the data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#masking_expression MaskingPolicy#masking_expression}
    */
    readonly maskingExpression: string;
    /**
    * Specifies the identifier for the masking policy; must be unique for the database and schema in which the masking policy is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#name MaskingPolicy#name}
    */
    readonly name: string;
    /**
    * Specifies the data type to return.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#return_data_type MaskingPolicy#return_data_type}
    */
    readonly returnDataType: string;
    /**
    * The schema in which to create the masking policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#schema MaskingPolicy#schema}
    */
    readonly schema: string;
    /**
    * Specifies the data type to mask.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy#value_data_type MaskingPolicy#value_data_type}
    */
    readonly valueDataType: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy snowflake_masking_policy}
*/
export declare class MaskingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_masking_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/masking_policy snowflake_masking_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MaskingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MaskingPolicyConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _maskingExpression?;
    get maskingExpression(): string;
    set maskingExpression(value: string);
    get maskingExpressionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _returnDataType?;
    get returnDataType(): string;
    set returnDataType(value: string);
    get returnDataTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _valueDataType?;
    get valueDataType(): string;
    set valueDataType(value: string);
    get valueDataTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=masking-policy.d.ts.map