import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotificationIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS IAM role ARN for notification integration to assume
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sns_role_arn NotificationIntegration#aws_sns_role_arn}
    */
    readonly awsSnsRoleArn?: string;
    /**
    * AWS SNS Topic ARN for notification integration to connect to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sns_topic_arn NotificationIntegration#aws_sns_topic_arn}
    */
    readonly awsSnsTopicArn?: string;
    /**
    * AWS SQS queue ARN for notification integration to connect to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sqs_arn NotificationIntegration#aws_sqs_arn}
    */
    readonly awsSqsArn?: string;
    /**
    * AWS IAM role ARN for notification integration to assume
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#aws_sqs_role_arn NotificationIntegration#aws_sqs_role_arn}
    */
    readonly awsSqsRoleArn?: string;
    /**
    * The queue ID for the Azure Queue Storage queue created for Event Grid notifications
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#azure_storage_queue_primary_uri NotificationIntegration#azure_storage_queue_primary_uri}
    */
    readonly azureStorageQueuePrimaryUri?: string;
    /**
    * The ID of the Azure Active Directory tenant used for identity management
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#azure_tenant_id NotificationIntegration#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * A comment for the integration
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#comment NotificationIntegration#comment}
    */
    readonly comment?: string;
    /**
    * Direction of the cloud messaging with respect to Snowflake (required only for error notifications)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#direction NotificationIntegration#direction}
    */
    readonly direction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#enabled NotificationIntegration#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The subscription id that Snowflake will listen to when using the GCP_PUBSUB provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#gcp_pubsub_subscription_name NotificationIntegration#gcp_pubsub_subscription_name}
    */
    readonly gcpPubsubSubscriptionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#name NotificationIntegration#name}
    */
    readonly name: string;
    /**
    * The third-party cloud message queuing service (e.g. AZURE_STORAGE_QUEUE, AWS_SQS, AWS_SNS)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#notification_provider NotificationIntegration#notification_provider}
    */
    readonly notificationProvider?: string;
    /**
    * A type of integration
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration#type NotificationIntegration#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration snowflake_notification_integration}
*/
export declare class NotificationIntegration extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_notification_integration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/notification_integration snowflake_notification_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotificationIntegrationConfig
    */
    constructor(scope: Construct, id: string, config: NotificationIntegrationConfig);
    get awsSnsExternalId(): string;
    get awsSnsIamUserArn(): string;
    private _awsSnsRoleArn?;
    get awsSnsRoleArn(): string;
    set awsSnsRoleArn(value: string);
    resetAwsSnsRoleArn(): void;
    get awsSnsRoleArnInput(): string | undefined;
    private _awsSnsTopicArn?;
    get awsSnsTopicArn(): string;
    set awsSnsTopicArn(value: string);
    resetAwsSnsTopicArn(): void;
    get awsSnsTopicArnInput(): string | undefined;
    private _awsSqsArn?;
    get awsSqsArn(): string;
    set awsSqsArn(value: string);
    resetAwsSqsArn(): void;
    get awsSqsArnInput(): string | undefined;
    get awsSqsExternalId(): string;
    get awsSqsIamUserArn(): string;
    private _awsSqsRoleArn?;
    get awsSqsRoleArn(): string;
    set awsSqsRoleArn(value: string);
    resetAwsSqsRoleArn(): void;
    get awsSqsRoleArnInput(): string | undefined;
    private _azureStorageQueuePrimaryUri?;
    get azureStorageQueuePrimaryUri(): string;
    set azureStorageQueuePrimaryUri(value: string);
    resetAzureStorageQueuePrimaryUri(): void;
    get azureStorageQueuePrimaryUriInput(): string | undefined;
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get gcpPubsubServiceAccount(): string;
    private _gcpPubsubSubscriptionName?;
    get gcpPubsubSubscriptionName(): string;
    set gcpPubsubSubscriptionName(value: string);
    resetGcpPubsubSubscriptionName(): void;
    get gcpPubsubSubscriptionNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notificationProvider?;
    get notificationProvider(): string;
    set notificationProvider(value: string);
    resetNotificationProvider(): void;
    get notificationProviderInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=notification-integration.d.ts.map