import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleOwnershipGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to remove or transfer all existing outbound privileges on the object when ownership is transferred to a new role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_ownership_grant#current_grants RoleOwnershipGrant#current_grants}
    */
    readonly currentGrants?: string;
    /**
    * The name of the role ownership is granted on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_ownership_grant#on_role_name RoleOwnershipGrant#on_role_name}
    */
    readonly onRoleName: string;
    /**
    * The name of the role to grant ownership. Please ensure that the role that terraform is using is granted access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/role_ownership_grant#to_role_name RoleOwnershipGrant#to_role_name}
    */
    readonly toRoleName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/role_ownership_grant snowflake_role_ownership_grant}
*/
export declare class RoleOwnershipGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_role_ownership_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/role_ownership_grant snowflake_role_ownership_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleOwnershipGrantConfig
    */
    constructor(scope: Construct, id: string, config: RoleOwnershipGrantConfig);
    private _currentGrants?;
    get currentGrants(): string;
    set currentGrants(value: string);
    resetCurrentGrants(): void;
    get currentGrantsInput(): string | undefined;
    get id(): string;
    private _onRoleName?;
    get onRoleName(): string;
    set onRoleName(value: string);
    get onRoleNameInput(): string | undefined;
    private _toRoleName?;
    get toRoleName(): string;
    set toRoleName(value: string);
    get toRoleNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=role-ownership-grant.d.ts.map