import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RowAccessPolicyGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the database containing the row access policy on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#database_name RowAccessPolicyGrant#database_name}
    */
    readonly databaseName: string;
    /**
    * When this is set to true, multiple grants of the same type can be created. This will cause Terraform to not revoke grants applied to roles and objects outside Terraform.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#enable_multiple_grants RowAccessPolicyGrant#enable_multiple_grants}
    */
    readonly enableMultipleGrants?: boolean | cdktf.IResolvable;
    /**
    * The privilege to grant on the row access policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#privilege RowAccessPolicyGrant#privilege}
    */
    readonly privilege?: string;
    /**
    * Grants privilege to these roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#roles RowAccessPolicyGrant#roles}
    */
    readonly roles?: string[];
    /**
    * The name of the row access policy on which to grant privileges immediately.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#row_access_policy_name RowAccessPolicyGrant#row_access_policy_name}
    */
    readonly rowAccessPolicyName: string;
    /**
    * The name of the schema containing the row access policy on which to grant privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#schema_name RowAccessPolicyGrant#schema_name}
    */
    readonly schemaName: string;
    /**
    * When this is set to true, allows the recipient role to grant the privileges to other roles.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant#with_grant_option RowAccessPolicyGrant#with_grant_option}
    */
    readonly withGrantOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant snowflake_row_access_policy_grant}
*/
export declare class RowAccessPolicyGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_row_access_policy_grant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/row_access_policy_grant snowflake_row_access_policy_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RowAccessPolicyGrantConfig
    */
    constructor(scope: Construct, id: string, config: RowAccessPolicyGrantConfig);
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _enableMultipleGrants?;
    get enableMultipleGrants(): boolean | cdktf.IResolvable;
    set enableMultipleGrants(value: boolean | cdktf.IResolvable);
    resetEnableMultipleGrants(): void;
    get enableMultipleGrantsInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _privilege?;
    get privilege(): string;
    set privilege(value: string);
    resetPrivilege(): void;
    get privilegeInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    resetRoles(): void;
    get rolesInput(): string[] | undefined;
    private _rowAccessPolicyName?;
    get rowAccessPolicyName(): string;
    set rowAccessPolicyName(value: string);
    get rowAccessPolicyNameInput(): string | undefined;
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _withGrantOption?;
    get withGrantOption(): boolean | cdktf.IResolvable;
    set withGrantOption(value: boolean | cdktf.IResolvable);
    resetWithGrantOption(): void;
    get withGrantOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=row-access-policy-grant.d.ts.map