import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Type of the stream that will be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#append_only Stream#append_only}
    */
    readonly appendOnly?: boolean | cdktf.IResolvable;
    /**
    * Specifies a comment for the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#comment Stream#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#database Stream#database}
    */
    readonly database: string;
    /**
    * Create an insert only stream type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#insert_only Stream#insert_only}
    */
    readonly insertOnly?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#name Stream#name}
    */
    readonly name: string;
    /**
    * Name of the table the stream will monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#on_table Stream#on_table}
    */
    readonly onTable?: string;
    /**
    * The schema in which to create the stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#schema Stream#schema}
    */
    readonly schema: string;
    /**
    * Specifies whether to return all existing rows in the source table as row inserts the first time the stream is consumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#show_initial_rows Stream#show_initial_rows}
    */
    readonly showInitialRows?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/stream snowflake_stream}
*/
export declare class Stream extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_stream";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/stream snowflake_stream} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamConfig
    */
    constructor(scope: Construct, id: string, config: StreamConfig);
    private _appendOnly?;
    get appendOnly(): boolean | cdktf.IResolvable;
    set appendOnly(value: boolean | cdktf.IResolvable);
    resetAppendOnly(): void;
    get appendOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _insertOnly?;
    get insertOnly(): boolean | cdktf.IResolvable;
    set insertOnly(value: boolean | cdktf.IResolvable);
    resetInsertOnly(): void;
    get insertOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _onTable?;
    get onTable(): string;
    set onTable(value: string);
    resetOnTable(): void;
    get onTableInput(): string | undefined;
    get owner(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showInitialRows?;
    get showInitialRows(): boolean | cdktf.IResolvable;
    set showInitialRows(value: boolean | cdktf.IResolvable);
    resetShowInitialRows(): void;
    get showInitialRowsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=stream.d.ts.map