import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeRowAccessPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies#database DataSnowflakeRowAccessPolicies#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the row access policyfrom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies#schema DataSnowflakeRowAccessPolicies#schema}
    */
    readonly schema: string;
}
export interface DataSnowflakeRowAccessPoliciesRowAccessPolicies {
}
export declare function dataSnowflakeRowAccessPoliciesRowAccessPoliciesToTerraform(struct?: DataSnowflakeRowAccessPoliciesRowAccessPolicies): any;
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeRowAccessPoliciesRowAccessPolicies | undefined;
    set internalValue(value: DataSnowflakeRowAccessPoliciesRowAccessPolicies | undefined);
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
}
export declare class DataSnowflakeRowAccessPoliciesRowAccessPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeRowAccessPoliciesRowAccessPoliciesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies snowflake_row_access_policies}
*/
export declare class DataSnowflakeRowAccessPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_row_access_policies";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/row_access_policies snowflake_row_access_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeRowAccessPoliciesConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeRowAccessPoliciesConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _rowAccessPolicies;
    get rowAccessPolicies(): DataSnowflakeRowAccessPoliciesRowAccessPoliciesList;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
