# mypy-boto3-lambda

[![PyPI - mypy-boto3-lambda](https://img.shields.io/pypi/v/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-lambda.svg?color=blue)](https://pypi.org/project/mypy-boto3-lambda)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Lambda 1.15.3](https://boto3.amazonaws.com/v1/documentation/api/1.15.3/reference/services/lambda.html#Lambda) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-lambda](#mypy-boto3-lambda)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Lambda` service.

```bash
python -m pip install boto3-stubs[lambda]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[lambda]` in your environment: `python -m pip install 'boto3-stubs[lambda]'`

Both type checking and auto-complete should work for `Lambda` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[lambda]` in your environment: `python -m pip install 'boto3-stubs[lambda]'`

Both type checking and auto-complete should work for `Lambda` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[lambda]` in your environment: `python -m pip install 'boto3-stubs[lambda]'`
- Run `mypy` as usual

Type checking should work for `Lambda` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[lambda]` in your environment: `python -m pip install 'boto3-stubs[lambda]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Lambda` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`LambdaClient` provides annotations for `boto3.client("lambda")`.

```python
import boto3

from mypy_boto3_lambda import LambdaClient

client: LambdaClient = boto3.client("lambda")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LambdaClient = session.client("lambda")
```

### Paginators annotations

`mypy_boto3_lambda.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_lambda import LambdaClient
from mypy_boto3_lambda.paginator import (
    ListAliasesPaginator,
    ListEventSourceMappingsPaginator,
    ListFunctionEventInvokeConfigsPaginator,
    ListFunctionsPaginator,
    ListLayersPaginator,
    ListLayerVersionsPaginator,
    ListProvisionedConcurrencyConfigsPaginator,
    ListVersionsByFunctionPaginator,
)

client: LambdaClient = boto3.client("lambda")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_event_source_mappings_paginator: ListEventSourceMappingsPaginator = client.get_paginator("list_event_source_mappings")
list_function_event_invoke_configs_paginator: ListFunctionEventInvokeConfigsPaginator = client.get_paginator("list_function_event_invoke_configs")
list_functions_paginator: ListFunctionsPaginator = client.get_paginator("list_functions")
list_layer_versions_paginator: ListLayerVersionsPaginator = client.get_paginator("list_layer_versions")
list_layers_paginator: ListLayersPaginator = client.get_paginator("list_layers")
list_provisioned_concurrency_configs_paginator: ListProvisionedConcurrencyConfigsPaginator = client.get_paginator("list_provisioned_concurrency_configs")
list_versions_by_function_paginator: ListVersionsByFunctionPaginator = client.get_paginator("list_versions_by_function")
```


### Waiters annotations

`mypy_boto3_lambda.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_lambda import LambdaClient
from mypy_boto3_lambda.waiter import (
    FunctionActiveWaiter,
    FunctionExistsWaiter,
    FunctionUpdatedWaiter,
)

client: LambdaClient = boto3.client("lambda")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
function_active_waiter: FunctionActiveWaiter = client.get_waiter("function_active")
function_exists_waiter: FunctionExistsWaiter = client.get_waiter("function_exists")
function_updated_waiter: FunctionUpdatedWaiter = client.get_waiter("function_updated")
```





### Typed dictionations

`mypy_boto3_lambda.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_lambda.type_defs import (
    AccountLimitTypeDef,
    AccountUsageTypeDef,
    AddLayerVersionPermissionResponseTypeDef,
    AddPermissionResponseTypeDef,
    AliasConfigurationTypeDef,
    AliasRoutingConfigurationTypeDef,
    ConcurrencyTypeDef,
    DeadLetterConfigTypeDef,
    DestinationConfigTypeDef,
    EnvironmentErrorTypeDef,
    EnvironmentResponseTypeDef,
    EnvironmentTypeDef,
    EventSourceMappingConfigurationTypeDef,
    FileSystemConfigTypeDef,
    FunctionCodeLocationTypeDef,
    FunctionCodeTypeDef,
    FunctionConfigurationTypeDef,
    FunctionEventInvokeConfigTypeDef,
    GetAccountSettingsResponseTypeDef,
    GetFunctionConcurrencyResponseTypeDef,
    GetFunctionResponseTypeDef,
    GetLayerVersionPolicyResponseTypeDef,
    GetLayerVersionResponseTypeDef,
    GetPolicyResponseTypeDef,
    GetProvisionedConcurrencyConfigResponseTypeDef,
    InvocationResponseTypeDef,
    InvokeAsyncResponseTypeDef,
    LayersListItemTypeDef,
    LayerTypeDef,
    LayerVersionContentInputTypeDef,
    LayerVersionContentOutputTypeDef,
    LayerVersionsListItemTypeDef,
    ListAliasesResponseTypeDef,
    ListEventSourceMappingsResponseTypeDef,
    ListFunctionEventInvokeConfigsResponseTypeDef,
    ListFunctionsResponseTypeDef,
    ListLayersResponseTypeDef,
    ListLayerVersionsResponseTypeDef,
    ListProvisionedConcurrencyConfigsResponseTypeDef,
    ListTagsResponseTypeDef,
    ListVersionsByFunctionResponseTypeDef,
    OnFailureTypeDef,
    OnSuccessTypeDef,
    PaginatorConfigTypeDef,
    ProvisionedConcurrencyConfigListItemTypeDef,
    PublishLayerVersionResponseTypeDef,
    PutProvisionedConcurrencyConfigResponseTypeDef,
    TracingConfigResponseTypeDef,
    TracingConfigTypeDef,
    VpcConfigResponseTypeDef,
    VpcConfigTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccountLimitTypeDef:
    return {
      ...
    }
```
