/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.CommandResultHolder;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.log.LoggingManager;
import org.openqa.selenium.server.log.StdOutHandler;
import org.openqa.selenium.server.log.TerseFormatter;
import org.openqa.selenium.testworker.TrackableRunnable;
import org.openqa.selenium.testworker.TrackableThread;

public class CommandResultHolderUnitTest
extends TestCase {
    private static Log log = LogFactory.getLog(CommandResultHolderUnitTest.class);
    private static final String sessionId = "1";
    private static final String testResult = "OK";
    private static final int cmdTimeout = 3;
    private CommandResultHolder holder;

    public void setUp() throws Exception {
        this.configureLogging();
        this.holder = new CommandResultHolder(sessionId, 3);
        log.info((Object)("Start test: " + this.getName()));
    }

    private void configureLogging() throws Exception {
        SeleniumServer.setDebugMode((boolean)true);
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)true);
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof StdOutHandler)) continue;
            handler.setFormatter((Formatter)new TerseFormatter(true));
            break;
        }
    }

    public void tearDown() throws Exception {
        SeleniumServer.setDebugMode((boolean)false);
        LoggingManager.configureLogging((RemoteControlConfiguration)new RemoteControlConfiguration(), (boolean)true);
    }

    public void testGetCommandGeneratesTimeoutStringWhenNoResult() {
        long now = System.currentTimeMillis();
        String result = this.holder.getResult();
        long after = System.currentTimeMillis();
        CommandResultHolderUnitTest.assertNotNull((Object)result);
        CommandResultHolderUnitTest.assertEquals((String)"ERROR: Command timed out", (String)result);
        CommandResultHolderUnitTest.assertTrue((after - now >= 2997L ? 1 : 0) != 0);
    }

    public void testGetCommandGeneratesNullMsgWhenPoisoned() throws Throwable {
        TrackableRunnable internalGetter = new TrackableRunnable(){

            public Object go() throws Throwable {
                String result = CommandResultHolderUnitTest.this.holder.getResult();
                log.debug((Object)(Thread.currentThread().getName() + " got result: " + result));
                return result;
            }
        };
        String name = "launching getter";
        TrackableThread t = new TrackableThread(internalGetter, name);
        t.start();
        this.holder.poisonPollers();
        CommandResultHolderUnitTest.assertEquals((Object)"ERROR: Got a null result", (Object)t.getResult());
    }

    public void testSimpleSingleThreaded() throws Throwable {
        this.injectContent(testResult, true);
        this.expectContent(testResult);
        CommandResultHolderUnitTest.assertTrue((boolean)this.holder.isEmpty());
    }

    private void injectContent(String content, boolean expected) throws Throwable {
        boolean actual = this.holder.putResult(content);
        CommandResultHolderUnitTest.assertEquals((String)(content + "result got sent"), (boolean)expected, (boolean)actual);
    }

    private void expectContent(String expected) throws Throwable {
        String actual = this.holder.getResult();
        CommandResultHolderUnitTest.assertEquals((String)(expected + " result retrieved"), (String)expected, (String)actual);
    }
}

