/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public class MakeProxyPacUnitTest
extends TestCase {
    private File parentDir;
    private File pacFile;
    private boolean proxySeleniumTrafficOnly = true;
    private boolean avoidProxy = false;
    private String httpProxyHost = null;
    private String httpProxyPort = null;
    private String httpNonProxyHosts = null;

    public MakeProxyPacUnitTest(String name) {
        super(name);
    }

    public void setUp() {
        this.parentDir = LauncherUtils.createCustomProfileDir((String)"LauncherUtilsUnitTest");
        this.pacFile = new File(this.parentDir, "proxy.pac");
    }

    public void tearDown() {
        LauncherUtils.recursivelyDeleteDir((File)this.parentDir);
    }

    private String makeProxyPAC() throws FileNotFoundException, IOException {
        LauncherUtils.makeProxyPAC((File)this.parentDir, (int)4444, (boolean)this.proxySeleniumTrafficOnly, (String)this.httpProxyHost, (String)this.httpProxyPort, (String)this.httpNonProxyHosts, (boolean)this.avoidProxy);
        String pac = this.readEntirePacFile();
        return pac;
    }

    private String readEntirePacFile() throws IOException {
        String line;
        FileReader fileReader = new FileReader(this.pacFile);
        BufferedReader reader = new BufferedReader(fileReader);
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append('\n');
        }
        String pac = sb.toString();
        return pac.replaceAll("\\s+", " ");
    }

    public void testBasic() throws IOException {
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { return 'PROXY localhost:4444; DIRECT'; } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testNeverProxySeleniumTrafficOnly() throws IOException {
        this.proxySeleniumTrafficOnly = false;
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { return 'PROXY localhost:4444; DIRECT'; } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testAvoidProxyNeverProxySeleniumTrafficOnly() throws IOException {
        this.proxySeleniumTrafficOnly = false;
        this.avoidProxy = true;
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { return 'PROXY localhost:4444; DIRECT'; } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testAvoidProxy() throws IOException {
        this.avoidProxy = true;
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { if(shExpMatch(url, '*/selenium-server/*')) { return 'PROXY localhost:4444; DIRECT'; } } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testConfiguredProxy() throws IOException {
        this.httpProxyHost = "foo";
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { return 'PROXY localhost:4444; PROXY foo'; } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testConfiguredProxyAvoidProxy() throws IOException {
        this.httpProxyHost = "foo";
        this.avoidProxy = true;
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { if(shExpMatch(url, '*/selenium-server/*')) { return 'PROXY localhost:4444; PROXY foo'; } else { return 'PROXY foo'; } } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testAvoidProxyNonProxyHost() throws IOException {
        this.avoidProxy = true;
        this.httpNonProxyHosts = "www.google.com";
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { if(shExpMatch(url, '*/selenium-server/*')) { return 'PROXY localhost:4444; DIRECT'; } else if (shExpMatch(host, 'www.google.com')) { return 'DIRECT'; } } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testConfiguredProxyAvoidProxyNonProxyHost() throws IOException {
        this.avoidProxy = true;
        this.httpProxyHost = "foo";
        this.httpNonProxyHosts = "www.google.com";
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { if(shExpMatch(url, '*/selenium-server/*')) { return 'PROXY localhost:4444; PROXY foo'; } else if (shExpMatch(host, 'www.google.com')) { return 'DIRECT'; } else { return 'PROXY foo'; } } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testAvoidProxyNonProxyHosts() throws IOException {
        this.avoidProxy = true;
        this.httpNonProxyHosts = "www.google.com|*.yahoo.com";
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { if(shExpMatch(url, '*/selenium-server/*')) { return 'PROXY localhost:4444; DIRECT'; } else if (shExpMatch(host, 'www.google.com')) { return 'DIRECT'; } else if (shExpMatch(host, '*.yahoo.com')) { return 'DIRECT'; } } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }

    public void testConfiguredProxyAvoidProxyNonProxyHosts() throws IOException {
        this.avoidProxy = true;
        this.httpProxyHost = "foo";
        this.httpNonProxyHosts = "www.google.com|*.yahoo.com";
        String pac = this.makeProxyPAC();
        String expected = "function FindProxyForURL(url, host) { if(shExpMatch(url, '*/selenium-server/*')) { return 'PROXY localhost:4444; PROXY foo'; } else if (shExpMatch(host, 'www.google.com')) { return 'DIRECT'; } else if (shExpMatch(host, '*.yahoo.com')) { return 'DIRECT'; } else { return 'PROXY foo'; } } ";
        MakeProxyPacUnitTest.assertEquals((String)expected, (String)pac);
    }
}

