#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.abq_automation_interfaces.abq_mass_scaling import ABQMassScaling
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class ABQMassScalings(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     ABQMassScalings
                | 
                | Represents a collection of
                | ABQMassScaling entries.
                | Role:
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=ABQMassScaling)
        self.abq_mass_scalings = com_object

    def add(self) -> ABQMassScaling:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Add() As ABQMassScaling
                | 
                |     Adds a new ABQMassScaling to the collection.
                | 
                |     Returns:
                |         The created ABQMassScaling entry.

        :rtype: ABQMassScaling
        """
        return ABQMassScaling(self.abq_mass_scalings.Add())

    def item(self, i_index: cat_variant) -> ABQMassScaling:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex) As ABQMassScaling
                | 
                |     Returns the ABQMassScaling entry for the specified index.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the ABQMassScaling to retrieve. If the
                |             index is a number, it specifies the element offset within the collection. The
                |             offset starts at 1. If the index is a string, it specifies the name
                |             (MassScaling.Name property) of the desired
                |             element.

        :param cat_variant i_index:
        :rtype: ABQMassScaling
        """
        return ABQMassScaling(self.abq_mass_scalings.Item(i_index))

    def remove(self, i_index: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(CATVariant iIndex)
                | 
                |     Removes the specified entry.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index or the name of the ABQMassScaling to remove. If the index
                |             is a number, it specifies the element offset within the collection. The offset
                |             starts at 1. If the index is a string, it specifies the name (MassScaling.Name
                |             property) of the desired element.

        :param cat_variant i_index:
        :rtype: None
        """
        return self.abq_mass_scalings.Remove(i_index)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove'
        # # vba_code = """
        # # Public Function remove(abq_mass_scalings)
        # #     Dim iIndex (2)
        # #     abq_mass_scalings.Remove iIndex
        # #     remove = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ABQMassScalings(name="{self.name}")'
