#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.abq_automation_interfaces.abq_property import ABQProperty
from pycatia.in_interfaces.reference import Reference
from pycatia.product_structure_interfaces.product import Product
from pycatia.product_structure_interfaces.publication import Publication


class ABQPretensionProperty(ABQProperty):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     ABQAutomationItf.ABQProperty
                |                         ABQPretensionProperty
                | 
                | Represents a pretension property (ABQPretensionProperty)
                | object.
                | Role: Access an Abaqus pretension property.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.abq_pretension_property = com_object

    def add_support_from_product(self, i_product: Product, i_support: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromProduct(Product iProduct,
                | Reference iSupport)
                | 
                |     Creates a new support and adds it to the description of the bolt pretension
                |     property.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIA Product specifying the object to which the bolt
                |             pretension property is applied.
                |         iSupport
                |             The CATIA Reference specifying the region to which the bolt
                |             pretension property is applied.
                | 
                |             Refer: CATIAReference, CATIAProduct

        :param Product i_product:
        :param Reference i_support:
        :rtype: None
        """
        return self.abq_pretension_property.AddSupportFromProduct(i_product.com_object, i_support.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_product'
        # # vba_code = """
        # # Public Function add_support_from_product(abq_pretension_property)
        # #     Dim iProduct (2)
        # #     abq_pretension_property.AddSupportFromProduct iProduct
        # #     add_support_from_product = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_support_from_publication(self, i_product: Product, i_publication: Publication) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromPublication(Product iProduct,
                | Publication iPublication)
                | 
                |     Creates a new support and adds it to the description of the bolt pretension
                |     property.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The CATIA Product specifying the object to which the bolt
                |             pretension property is applied.
                |         iPublication
                |             The CATIA Publication specifying the region to which the bolt
                |             pretension property is applied.
                | 
                |             Refer: CATIAPublication

        :param Product i_product:
        :param Publication i_publication:
        :rtype: None
        """
        return self.abq_pretension_property.AddSupportFromPublication(i_product.com_object, i_publication.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_publication'
        # # vba_code = """
        # # Public Function add_support_from_publication(abq_pretension_property)
        # #     Dim iProduct (2)
        # #     abq_pretension_property.AddSupportFromPublication iProduct
        # #     add_support_from_publication = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_support_from_reference(self, i_reference: Reference, i_support: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromReference(Reference iReference,
                | Reference iSupport)
                | 
                |     Creates a new support and adds it to the description of the bolt pretension
                |     property.
                | 
                |     Parameters:
                | 
                |         iReference
                |             The CATIA Reference specifying the object to which the bolt
                |             pretension property is applied.
                |         iSupport
                |             The CATIA Reference specifying the region to which the bolt
                |             pretension property is applied.
                | 
                |             Refer: CATIAReference

        :param Reference i_reference:
        :param Reference i_support:
        :rtype: None
        """
        return self.abq_pretension_property.AddSupportFromReference(i_reference.com_object, i_support.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_reference'
        # # vba_code = """
        # # Public Function add_support_from_reference(abq_pretension_property)
        # #     Dim iReference (2)
        # #     abq_pretension_property.AddSupportFromReference iReference
        # #     add_support_from_reference = iReference
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def clear_cutting_plane(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ClearCuttingPlane()
                | 
                |     Clears the cutting plane.

        :rtype: None
        """
        return self.abq_pretension_property.ClearCuttingPlane()

    def set_cutting_plane(self, i_product: Reference, i_ref: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetCuttingPlane(Reference iProduct,
                | Reference iRef)
                | 
                |     Sets the cutting plane for the bolt pretension property. Cutting plane will
                |     be needed in case user wants to model pretension in 3D bolt. Any previously set
                |     plane will be replaced with this new value.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             The product for the plane. 
                |         iRef
                |             The reference to the plane.

        :param Reference i_product:
        :param Reference i_ref:
        :rtype: None
        """
        return self.abq_pretension_property.SetCuttingPlane(i_product.com_object, i_ref.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_cutting_plane'
        # # vba_code = """
        # # Public Function set_cutting_plane(abq_pretension_property)
        # #     Dim iProduct (2)
        # #     abq_pretension_property.SetCuttingPlane iProduct
        # #     set_cutting_plane = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'ABQPretensionProperty(name="{self.name}")'
