#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.analysis_interfaces.analysis_mesh_local_specifications import AnalysisMeshLocalSpecifications
from pycatia.analysis_interfaces.analysis_set import AnalysisSet
from pycatia.in_interfaces.reference import Reference
from pycatia.product_structure_interfaces.product import Product
from pycatia.product_structure_interfaces.publication import Publication
from pycatia.types.general import cat_variant


class AnalysisMeshPart(AnalysisSet):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     CATAnalysisInterfaces.AnalysisSet
                |                         AnalysisMeshPart
                | 
                | The interface to access a CATIAAnalysisMeshPart.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.analysis_mesh_part = com_object

    @property
    def activity(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Activity() As boolean
                | 
                |     Returns the activity of an meshpart.
                | 
                |     Parameters:
                | 
                |         oActivity
                | 
                |             Legal values:
                | 
                |             FALSE
                |                 Mesh Part is not active. 
                |             TRUE
                |                 Mesh Part is active.

        :rtype: bool
        """

        return self.analysis_mesh_part.Activity

    @activity.setter
    def activity(self, value: bool):
        """
        :param bool value:
        """

        self.analysis_mesh_part.Activity = value

    @property
    def analysis_mesh_local_specifications(self) -> AnalysisMeshLocalSpecifications:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property AnalysisMeshLocalSpecifications() As
                | AnalysisMeshLocalSpecifications (Read Only)
                | 
                |     Returns the local specification collection from the meshpart analysis.

        :rtype: AnalysisMeshLocalSpecifications
        """

        return AnalysisMeshLocalSpecifications(self.analysis_mesh_part.AnalysisMeshLocalSpecifications)

    def add_support_from_publication(self, i_product: Product, i_support: Publication) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromPublication(Product iProduct,
                | Publication iSupport)
                | 
                |     Creates a new support and add it to the support description of the mesh
                |     part.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             the CATIA Product that represent the object to
                |             linked.
                |         iPublication
                |             the CATIA Publication that represent the the geometry to
                |             meshed.
                | 
                |     See also:
                |         Publication, Product

        :param Product i_product:
        :param Publication i_support:
        :rtype: None
        """
        return self.analysis_mesh_part.AddSupportFromPublication(i_product.com_object, i_support.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_publication'
        # # vba_code = """
        # # Public Function add_support_from_publication(analysis_mesh_part)
        # #     Dim iProduct (2)
        # #     analysis_mesh_part.AddSupportFromPublication iProduct
        # #     add_support_from_publication = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def add_support_from_reference(self, i_product: Product, i_support: Reference) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddSupportFromReference(Product iProduct,
                | Reference iSupport)
                | 
                |     Creates a new support and add it to the support description of the mesh
                |     part.
                | 
                |     Parameters:
                | 
                |         iProduct
                |             the CATIA Product that represent the object to
                |             linked.
                |         iSupport
                |             the CATIA Reference that represent the geometry to
                |             meshed.
                | 
                |     See also:
                |         Reference, Product

        :param Product i_product:
        :param Reference i_support:
        :rtype: None
        """
        return self.analysis_mesh_part.AddSupportFromReference(i_product.com_object, i_support.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_support_from_reference'
        # # vba_code = """
        # # Public Function add_support_from_reference(analysis_mesh_part)
        # #     Dim iProduct (2)
        # #     analysis_mesh_part.AddSupportFromReference iProduct
        # #     add_support_from_reference = iProduct
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_global_specification(self, i_name: str, i_value: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetGlobalSpecification(CATBSTR iName,
                | CATVariant iValue)
                | 
                |     Sets the value corresponding to the given global
                |     specification.
                | 
                |     Parameters:
                | 
                |         iName
                |             The identifier if the global specification.
                |         iValue
                |             The value of the global specification.

        :param str i_name:
        :param cat_variant i_value:
        :rtype: None
        """
        return self.analysis_mesh_part.SetGlobalSpecification(i_name, i_value)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_global_specification'
        # # vba_code = """
        # # Public Function set_global_specification(analysis_mesh_part)
        # #     Dim iName (2)
        # #     analysis_mesh_part.SetGlobalSpecification iName
        # #     set_global_specification = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_mesh_parts_to_capture(self, i_mesh_parts: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetMeshPartsToCapture(CATSafeArrayVariant iMeshParts)
                | 
                |     Set the list of candidate Mesh Parts for capture.
                | 
                |     Parameters:
                | 
                |         iMeshParts
                |             Safe array of mesh parts. 
                | 
                |     Returns:
                |         An HRESULT.
                |         Legal values:
                | 
                |         S_OK
                |             Operation successfull. 
                |         E_FAIL
                |             Operation failed.

        :param tuple i_mesh_parts:
        :rtype: None
        """
        return self.analysis_mesh_part.SetMeshPartsToCapture(i_mesh_parts)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_mesh_parts_to_capture'
        # # vba_code = """
        # # Public Function set_mesh_parts_to_capture(analysis_mesh_part)
        # #     Dim iMeshParts (2)
        # #     analysis_mesh_part.SetMeshPartsToCapture iMeshParts
        # #     set_mesh_parts_to_capture = iMeshParts
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_specification_from_publication(
            self,
            i_name: str,
            i_product: Product,
            i_support: Publication,
            i_mode: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetSpecificationFromPublication(CATBSTR iName,
                | Product iProduct,
                | Publication iSupport,
                | long iMode)
                | 
                |     Adds the geometric value corresponding to the given global
                |     specification.
                | 
                |     Parameters:
                | 
                |         iName
                |             The identifier if the global specification.
                |         iProduct
                |             the CATIA Product that represent the object to
                |             linked.
                |         iPublication
                |             the CATIA Publication that represent the the geometry to
                |             meshed.
                | 
                |     See also:
                |         Publication, Product 
                |     iMode
                |         The mode used to valuate the publication global
                |         specification.
                |         Legal values:
                | 
                |         0
                |             the global specification is defined as a single reference.
                |             
                |         1
                |             the global specification is added to exising
                |             references.

        :param str i_name:
        :param Product i_product:
        :param Publication i_support:
        :param int i_mode:
        :rtype: None
        """
        return self.analysis_mesh_part.SetSpecificationFromPublication(
            i_name,
            i_product.com_object,
            i_support.com_object,
            i_mode
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_specification_from_publication'
        # # vba_code = """
        # # Public Function set_specification_from_publication(analysis_mesh_part)
        # #     Dim iName (2)
        # #     analysis_mesh_part.SetSpecificationFromPublication iName
        # #     set_specification_from_publication = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def set_specification_from_reference(
            self,
            i_name: str,
            i_product: Product,
            i_support: Reference,
            i_mode: int) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetSpecificationFromReference(CATBSTR iName,
                | Product iProduct,
                | Reference iSupport,
                | long iMode)
                | 
                |     Set the geometric value corresponding to the given global
                |     specification.
                | 
                |     Parameters:
                | 
                |         iName
                |             The identifier if the global specification.
                |         iProduct
                |             the CATIA Product that represent the object to
                |             linked.
                |         iSupport
                |             the CATIA Reference that represent the geometry to
                |             meshed.
                | 
                |     See also:
                |         Reference, Product 
                |     iMode
                |         The mode used to valuate the reference global
                |         specification.
                |         Legal values:
                | 
                |         0
                |             the global specification is defined as a single reference.
                |             
                |         1
                |             the global specification is added to exising
                |             references.

        :param str i_name:
        :param Product i_product:
        :param Reference i_support:
        :param int i_mode:
        :rtype: None
        """
        return self.analysis_mesh_part.SetSpecificationFromReference(
            i_name,
            i_product.com_object,
            i_support.com_object,
            i_mode
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_specification_from_reference'
        # # vba_code = """
        # # Public Function set_specification_from_reference(analysis_mesh_part)
        # #     Dim iName (2)
        # #     analysis_mesh_part.SetSpecificationFromReference iName
        # #     set_specification_from_reference = iName
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AnalysisMeshPart(name="{self.name}")'
