#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class AssemblyFeature(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     AssemblyFeature
                | 
                | Represents the AssemblyFeature object.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.assembly_feature = com_object

    def add_affected_component(self, i_component: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AddAffectedComponent(Product iComponent)
                | 
                |     Adds a component to the affected component list. An update of the
                |     aggregating Product is necessary to apply the Assembly Feature to this
                |     component.
                | 
                |     Parameters:
                | 
                |         iComponent
                |             The component to affect 
                | 
                |     Example:
                |         The following example adds the component ProdToAffect to the affected
                |         component list of the AssemblyFeature assemblyFeat.
                | 
                |          assemblyFeat.AddAffectedComponent( ProdToAffect )

        :param Product i_component:
        :rtype: None
        """
        return self.assembly_feature.AddAffectedComponent(i_component.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'add_affected_component'
        # # vba_code = """
        # # Public Function add_affected_component(assembly_feature)
        # #     Dim iComponent (2)
        # #     assembly_feature.AddAffectedComponent iComponent
        # #     add_affected_component = iComponent
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def affected_components_count(self) -> int:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func AffectedComponentsCount() As long
                | 
                |     Returns the affected component list count.
                | 
                |     Example:
                |         The following example retrieves the affected component list count of
                |         the AssemblyFeature assemblyFeat in affectedListSize.
                | 
                |          affectedListSize = assemblyFeat.AffectedComponentsCount

        :rtype: int
        """
        return self.assembly_feature.AffectedComponentsCount()

    def list_affected_components(self, o_list_of_components: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ListAffectedComponents(CATSafeArrayVariant
                | oListOfComponents)
                | 
                |     Retrieves the affected component list.
                | 
                |     Parameters:
                | 
                |         oListOfComponents
                |             The retrieved list.
                |             The array must be previously initialized using the
                |             
                | 
                |         AffectedComponentsCount method. 
                | 
                | Example:
                |     The following example retrieves the affected component list of the
                |     AssemblyFeature assemblyFeat in affectedList.
                | 
                |      affectedListSize = assemblyFeat.AffectedComponentsCount
                |      Dim affectedList(affectedListSize-1) 
                |      assemblyFeat.ListAffectedComponents(affectedList)

        :param tuple o_list_of_components:
        :rtype: None
        """
        return self.assembly_feature.ListAffectedComponents(o_list_of_components)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'list_affected_components'
        # # vba_code = """
        # # Public Function list_affected_components(assembly_feature)
        # #     Dim oListOfComponents (2)
        # #     assembly_feature.ListAffectedComponents oListOfComponents
        # #     list_affected_components = oListOfComponents
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_affected_component(self, i_component: Product) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAffectedComponent(Product iComponent)
                | 
                |     Removes a component from the affected component list. An update of the
                |     aggregating Product is necessary to remove the generated feature from this
                |     component.
                | 
                |     Parameters:
                | 
                |         iComponent
                |             The affected component to remove 
                | 
                |     Example:
                |         The following example removes the component ProdToRemove from the
                |         affected component list of the AssemblyFeature
                |         assemblyFeat.
                | 
                |          assemblyFeat.RemoveAffectedComponent( ProdToRemove )

        :param Product i_component:
        :rtype: None
        """
        return self.assembly_feature.RemoveAffectedComponent(i_component.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove_affected_component'
        # # vba_code = """
        # # Public Function remove_affected_component(assembly_feature)
        # #     Dim iComponent (2)
        # #     assembly_feature.RemoveAffectedComponent iComponent
        # #     remove_affected_component = iComponent
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'AssemblyFeature(name="{self.name}")'
