#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from typing import TYPE_CHECKING

from pycatia.cat_plant_ship_interfaces.psp_list_of_bstrs import PSPListOfBSTRs
from pycatia.system_interfaces.any_object import AnyObject

if TYPE_CHECKING:
    from pycatia.cat_plant_ship_interfaces.psp_connectable import PSPConnectable


class PSPConnector(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspConnector
                | 
                | Represents connector object.
                | Role: To specify connector behaviors such as connect and
                | disconnect.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_connector = com_object

    @property
    def attr_names(self) -> PSPListOfBSTRs:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property AttrNames() As PspListOfBSTRs
                | 
                |     Returns or Sets Attribute names of the connector.
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspConnector
                |          Dim ojArg1 As CATIAPspListOfBSTRs
                |           ...
                |          Set ojArg1 = objThisIntf.AttrNames

        :rtype: PSPListOfBSTRs
        """

        return PSPListOfBSTRs(self.psp_connector.AttrNames)

    @attr_names.setter
    def attr_names(self, value: PSPListOfBSTRs):
        """
        :param PSPListOfBSTRs value:
        """

        self.psp_connector.AttrNames = value

    @property
    def connector_name(self) -> str:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property ConnectorName() As CATBSTR
                | 
                |     Returns or sets name of the connector.
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspConnector
                |          Dim strVar1 As CATBSTR
                |           ...
                |          Set strVar1 = objThisIntf.Name
                |          Dim strVar1 As CATBSTR
                |           ...
                |          objThisIntf.ConnectorName = strVar2

        :rtype: str
        """

        return self.psp_connector.ConnectorName

    @connector_name.setter
    def connector_name(self, value: str):
        """
        :param str value:
        """

        self.psp_connector.ConnectorName = value

    def connect(self, i_cntr_to_connect: 'PSPConnector') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Connect(PspConnector iCntrToConnect)
                | 
                |     Connect the connector to another connector.
                | 
                |     Parameters:
                | 
                |         iCntrToConnect
                |             the connector to be connected to 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspConnector
                |          Dim objArg1 As PspConnector
                |           ...
                |          objThisIntf.Connect objArg1

        :param PSPConnector i_cntr_to_connect:
        :rtype: None
        """
        return self.psp_connector.Connect(i_cntr_to_connect.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'connect'
        # # vba_code = """
        # # Public Function connect(psp_connector)
        # #     Dim iCntrToConnect (2)
        # #     psp_connector.Connect iCntrToConnect
        # #     connect = iCntrToConnect
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def disconnect(self, i_cntr_to_disconnect: 'PSPConnector') -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Disconnect(PspConnector iCntrToDisconnect)
                | 
                |     DisConnect the connector from another connector.
                | 
                |     Parameters:
                | 
                |         iCntrToDisconnect
                |             The connector to be disconnected from 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspConnector
                |          Dim objArg1 As PspConnector
                |           ...
                |          objThisIntf.Disconnect objArg1

        :param PSPConnector i_cntr_to_disconnect:
        :rtype: None
        """
        return self.psp_connector.Disconnect(i_cntr_to_disconnect.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'disconnect'
        # # vba_code = """
        # # Public Function disconnect(psp_connector)
        # #     Dim iCntrToDisconnect (2)
        # #     psp_connector.Disconnect iCntrToDisconnect
        # #     disconnect = iCntrToDisconnect
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_associated_connectable(self) -> 'PSPConnectable':
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetAssociatedConnectable() As PspConnectable
                | 
                |     Get the connectable-owner of this connector.
                | 
                |     Parameters:
                | 
                |         oConnectable
                |             Connectable owner of this connector 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspConnector
                |          Dim objArg1 As CATIAPspConnectable
                |           ...
                |          Set objArg1 = objThisIntf.GetAssociatedConnectable

        :rtype: PSPConnectable
        """
        
        from pycatia.cat_plant_ship_interfaces.psp_connectable import PSPConnectable
        return PSPConnectable(self.psp_connector.GetAssociatedConnectable())

    def is_cntr_connected(self) -> bool:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func IsCntrConnected() As boolean
                | 
                |     Query whether the connector has been connected.
                | 
                |     Returns:
                |         TRUE if this connector is connected.
                |
                |     Example:
                |
                |          Dim objThisIntf As PspConnector  
                |          Dim bArg1 As boolean  
                |           ...
                |          bArg1 = objThisIntf.IsCntrConnected

        :rtype: bool
        """
        return self.psp_connector.IsCntrConnected()

    def __repr__(self):
        return f'PSPConnector(name="{self.name}")'
