#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_list_of_doubles import PSPListOfDoubles
from pycatia.system_interfaces.any_object import AnyObject


class PSPLightBend(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspLightBend
                | 
                | Represents the Light bendable object.
                | Role: It is used access light bendable data.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_light_bend = com_object

    def get_bend_data(self) -> PSPListOfDoubles:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetBendData() As PspListOfDoubles
                | 
                |     Returns the list of bend radii.
                | 
                |     Returns:
                |         List of bend radius (PspListOfDoubles).
                |
                |     Example:
                |
                |          Dim objThisIntf As PspLightBend
                |          Dim objArg1 As PspListOfDoubles
                |           ...
                |          Set objArg1 = objThisIntf.GetBendData

        :rtype: PSPListOfDoubles
        """
        return PSPListOfDoubles(self.psp_light_bend.GetBendData())

    def set_bend_data(self, i_list_of_bend_radius: tuple) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetBendData(CATSafeArrayVariant iListOfBendRadius)
                | 
                |     Sets a list of bend radii.
                | 
                |     Parameters:
                | 
                |         iListOfBendRadius
                |             List of bend radius. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspLightBend
                |          Dim objArg1 As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetBendData objArg1

        :param tuple i_list_of_bend_radius:
        :rtype: None
        """
        return self.psp_light_bend.SetBendData(i_list_of_bend_radius)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_bend_data'
        # # vba_code = """
        # # Public Function set_bend_data(psp_light_bend)
        # #     Dim iListOfBendRadius (2)
        # #     psp_light_bend.SetBendData iListOfBendRadius
        # #     set_bend_data = iListOfBendRadius
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PSPLightBend(name="{self.name}")'
