#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_list_of_doubles import PSPListOfDoubles
from pycatia.product_structure_interfaces.product import Product
from pycatia.system_interfaces.any_object import AnyObject


class PSPLightPart(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspLightPart
                | 
                | Represents the light part.
                | Role: To access light object data.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_light_part = com_object

    def get_definition(self, i_rel_axis: Product) -> PSPListOfDoubles:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetDefinition(Product iRelAxis) As PspListOfDoubles
                | 
                |     Retrieves the points defining the object.
                | 
                |     Parameters:
                | 
                |         iRelAxis
                |             The relative axis object (Nothing means relative to parent).
                |             
                | 
                |     Returns:
                |         List of points defining object. A list of X-Y-Z coordinates of the
                |         points. 3 doubles per point.
                |
                |     Example:
                |
                |          Dim objThisIntf As PspLightPart
                |          Dim objArg1 As Product
                |          Dim objArg2 As PspListOfDoubles
                |          Set objArg1 = Nothing
                |           ...
                |          Set objArg2 = objThisIntf.GetDefinition (objArg1)

        :param Product i_rel_axis:
        :rtype: PSPListOfDoubles
        """
        return PSPListOfDoubles(self.psp_light_part.GetDefinition(i_rel_axis.com_object))

    def set_definition(self, i_rel_axis: Product, i_list_points: tuple) -> tuple:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub SetDefinition(Product iRelAxis,
                | CATSafeArrayVariant iListPoints)
                | 
                |     Set the points defining the light object.
                | 
                |     Parameters:
                | 
                |         iRelAxis
                |             The relative axis object (Nothing means relative to parent).
                |             
                |         oListPoints
                |             List of points defining object. A list of X-Y-Z coordinates of the
                |             points. 3 doubles per point. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspLightPart
                |          Dim objArg1 As CATSafeArrayVariant
                |          Dim dbVar2(3) As CATSafeArrayVariant
                |           ...
                |          objThisIntf.SetDefinition objArg1, dbVar2

        :param Product i_rel_axis:
        :param tuple i_list_points:
        :rtype: tuple
        """
        return self.psp_light_part.SetDefinition(i_rel_axis.com_object, i_list_points)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'set_definition'
        # # vba_code = """
        # # Public Function set_definition(psp_light_part)
        # #     Dim iRelAxis (2)
        # #     psp_light_part.SetDefinition iRelAxis
        # #     set_definition = iRelAxis
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PSPLightPart(name="{self.name}")'
