#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_list_of_objects import PSPListOfObjects
from pycatia.system_interfaces.any_object import AnyObject


class PSPSpatial(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspSpatial
                | 
                | Represents the Psp Spatial object.
                | Role: To access Plant Ship spatial object information.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_spatial = com_object

    @property
    def physicals(self) -> PSPListOfObjects:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)
                | o Property Physicals() As PspListOfObjects (Read Only)
                | 
                |     Returns all physical objects associated to this spatial
                |     object.
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspSpatial
                |          Dim objArg1 As CATIAPspListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf.Physicals

        :rtype: PSPListOfObjects
        """

        return PSPListOfObjects(self.psp_spatial.Physicals)

    def get_connected_physicals(
            self,
            isp_node: AnyObject,
            o_l_psp_connectors: PSPListOfObjects,
            o_l_psp_physicals: PSPListOfObjects
    ) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetConnectedPhysicals(AnyObject ispNode,
                | PspListOfObjects oLPspConnectors,
                | PspListOfObjects oLPspPhysicals)
                | 
                |     Return all physical objects associated to this extremity
                |     nodes
                | 
                |     Example:
                |
                |          Dim objThisIntf As PspSpatial
                |          Dim objArg1 As CATIABase
                |          Dim objArg2 As CATIAPspListOfObjects
                |          Dim objArg3 As CATIAPspListOfObjects
                |           ...
                |          Set objArg1 = objThisIntf
                |          Set objArg1 = oLPspConnectors
                |          Set objArg1 = oLPspPhysicals GetConnectedPhysicals

        :param AnyObject isp_node:
        :param PSPListOfObjects o_l_psp_connectors:
        :param PSPListOfObjects o_l_psp_physicals:
        :rtype: None
        """
        return self.psp_spatial.GetConnectedPhysicals(
            isp_node.com_object,
            o_l_psp_connectors.com_object,
            o_l_psp_physicals.com_object
        )
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_connected_physicals'
        # # vba_code = """
        # # Public Function get_connected_physicals(psp_spatial)
        # #     Dim ispNode (2)
        # #     psp_spatial.GetConnectedPhysicals ispNode
        # #     get_connected_physicals = ispNode
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'PSPSpatial(name="{self.name}")'
