#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_plant_ship_interfaces.psp_application import PSPApplication
from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class PSPWorkbench(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     PspWorkbench
                | 
                | Represents the PspWorkbench.
                | Role: To manage application and Psp interface handlers. From this object all
                | the queries for lists of Distributive system (PSP) objects can be made.
                | Furthermore, all the interface handles can be obtained through this
                | interface.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.psp_workbench = com_object

    def export_properties(self, i_document_to_export_from: Document, i_xml_output_file_name: str) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub ExportProperties(Document iDocumentToExportFrom,
                | CATBSTR iXMLOutputFileName)
                | 
                |     This method extracts property values of the current document to an output
                |     XML file. The format is determined by CATIA PlantShip XML-DTD
                |     file.
                | 
                |     Parameters:
                | 
                |         iDocumentToExportFrom
                |             Documennt to export from 
                |         iXMLOutputFileName
                |             The file name to output the data to.
                |
                |     Example:
                |
                |          Dim objPspWorkbench As PspWorkbench  
                |          Dim objCATIAV5CurDocument As Document
                |          Dim iXMLOutputFileName As String
                |          Set objCATIAV5CurDocument = CATIA.ActiveDocument  
                |          Set objProductRoot = objCATIAV5CurDocument.Product
                |          Set objPspWorkbench = objProductRoot.GetTechnologicalObject ("PspWorkbench")
                |          ..
                |          objThisIntf.ExportProperties objCATIAV5CurDocument,
                |          iXMLOutputFileName

        :param Document i_document_to_export_from:
        :param str i_xml_output_file_name:
        :rtype: None
        """
        return self.psp_workbench.ExportProperties(i_document_to_export_from.com_object, i_xml_output_file_name)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'export_properties'
        # # vba_code = """
        # # Public Function export_properties(psp_workbench)
        # #     Dim iDocumentToExportFrom (2)
        # #     psp_workbench.ExportProperties iDocumentToExportFrom
        # #     export_properties = iDocumentToExportFrom
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def get_application(self, i_application_id: int) -> PSPApplication:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetApplication(CatPspIDLApplicationID iApplicationID) As
                | PspApplication
                | 
                |     Returns the PspApplication associated with the input
                |     ApplicationID.
                | 
                |     Parameters:
                | 
                |         CatPspIDLApplicationID
                |             Application ID to get. 
                |         oApplication
                |             PspApplication handle found. 
                | 
                |     Example:
                |
                |          Dim objPspWorkbench As PspWorkbench
                |          Dim objArg1 As CatPspIDLApplicationID
                |          Dim objArg2 As PspApplication
                |          objArg1 = catPspIDLCATPiping
                |          Set objArg2 = objPspWorkbench.GetApplication (objArg1)

        :param int i_application_id: enum cat_psp_idl_application_id
        :rtype: PSPApplication
        """
        return PSPApplication(self.psp_workbench.GetApplication(i_application_id))

    def get_interface(self, i_interface_name: str, i_object: AnyObject) -> AnyObject:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func GetInterface(CATBSTR iInterfaceName,
                | AnyObject iObject) As AnyObject
                | 
                |     Returns specific interface handle on a given object.
                | 
                |     Parameters:
                | 
                |         iInterfaceName
                |             interface name to search for ("CATIAxxxx") 
                |         iObject
                |             The object to search for the required interface. 
                | 
                |     Returns:
                |         Interface handle found
                |
                |     Example:
                | 
                |           This example illustrates how to get a specific interface handle from
                |           a given object. 
                |
                |          Dim objPspWorkbench As PspWorkbench
                |          Dim objPspApplication As PspApplication
                |          Dim objPspAppFactory As PspAppFactory
                |          Dim objProductRoot As Product
                |          Set objProductRoot = CATIA.ActiveDocument.Product
                |          Set objPspWorkbench = objProductRoot.GetTechnologicalObject ("PspWorkbench")
                |          Set objPspPipApplication = objPspWorkbench.GetApplication(catPspIDLCATPiping)
                | 
                |          Set objPspPipAppFactory = objPspWorkbench.GetInterface ("CATIAPspAppFactory",objPspPipApplication)

        :param str i_interface_name:
        :param AnyObject i_object:
        :rtype: AnyObject
        """
        return AnyObject(self.psp_workbench.GetInterface(i_interface_name, i_object.com_object))

    def __repr__(self):
        return f'PSPWorkbench(name="{self.name}")'
