#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_rsc_interfaces.rendering_shooting import RenderingShooting
from pycatia.system_interfaces.collection import Collection
from pycatia.types.general import cat_variant


class RenderingShootings(Collection):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.Collection
                |                     RenderingShootings
                | 
                | A collection of all the Rendering Shootings objects.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object, child_object=RenderingShooting)
        self.rendering_shootings = com_object

    def add(self) -> RenderingShooting:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Add() As RenderingShooting
                | 
                |     Adds a new shooting to the shootings collection.

        :rtype: RenderingShooting
        """
        return RenderingShooting(self.rendering_shootings.Add())

    def item(self, i_index: cat_variant) -> RenderingShooting:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Func Item(CATVariant iIndex) As RenderingShooting
                | 
                |     Returns a renderingshooting index in the renderingshootings
                |     collection.
                | 
                |     Parameters:
                | 
                |         iIndex
                |             The index of the shooting to retrieve in the collection of
                |             shootings. Compared with other collections, you cannot use the name of the
                |             shooting as argument. 
                | 
                |     Returns:
                |         The retrieved shooting 
                | 
                | Example:
                |
                |     The following example returns in MyShooting the sixth shooting in a
                |     shootings collection.
                | 
                |      Dim MyShooting As RenderingShooting
                |      Set MyShooting = RenderingShootings.Item(6)

        :param cat_variant i_index:
        :rtype: RenderingShooting
        """
        return RenderingShooting(self.rendering_shootings.Item(i_index))

    def remove(self, i_index: cat_variant) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub Remove(CATVariant iIndex)
                | 
                |     Removes a shooting from the shootings collection.

        :param cat_variant i_index:
        :rtype: None
        """
        return self.rendering_shootings.Remove(i_index)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'remove'
        # # vba_code = """
        # # Public Function remove(rendering_shootings)
        # #     Dim iIndex (2)
        # #     rendering_shootings.Remove iIndex
        # #     remove = iIndex
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def remove_all(self) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub RemoveAll()
                | 
                |     Removes all shootings from the collection.

        :rtype: None
        """
        return self.rendering_shootings.RemoveAll()

    def __repr__(self):
        return f'RenderingShootings(name="{self.name}")'
