#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_list_of_bst_rs import SchListOfBSTRs
from pycatia.system_interfaces.any_object import AnyObject


class SchAppCntrData(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppCntrData
                | 
                | Manage a schematic connector data.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_cntr_data = com_object

    def app_get_application_data(self, i_l_app_data: SchListOfBSTRs, i_l_app_nls_data: SchListOfBSTRs) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppGetApplicationData(SchListOfBSTRs iLAppData,
                | SchListOfBSTRs iLAppNlsData)
                | 
                |     Get application data.
                | 
                |     Parameters:
                | 
                |         iLAppData
                |             A list of character string data. 
                |         iLAppNlsData
                |             A list of character string data. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrData
                |          Dim objArg1 As SchListOfBSTRs
                |          Dim objArg2 As SchListOfBSTRs
                |           ...
                |          objThisIntf.AppGetApplicationDataobjArg1,objArg2

        :param SchListOfBSTRs i_l_app_data:
        :param SchListOfBSTRs i_l_app_nls_data:
        :rtype: None
        """
        return self.sch_app_cntr_data.AppGetApplicationData(i_l_app_data.com_object, i_l_app_nls_data.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_get_application_data'
        # # vba_code = """
        # # Public Function app_get_application_data(sch_app_cntr_data)
        # #     Dim iLAppData (2)
        # #     sch_app_cntr_data.AppGetApplicationData iLAppData
        # #     app_get_application_data = iLAppData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_list_potential_data(self, i_l_app_data: SchListOfBSTRs, i_l_app_nls_data: SchListOfBSTRs) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppListPotentialData(SchListOfBSTRs iLAppData,
                | SchListOfBSTRs iLAppNlsData)
                | 
                |     Get a list valid potential application data that can be
                |     set.
                | 
                |     Parameters:
                | 
                |         iLAppData
                |             A list of character string data. 
                |         iLAppNlsData
                |             A list of character string data. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrData
                |          Dim objArg1 As SchListOfBSTRs
                |          Dim objArg2 As SchListOfBSTRs
                |           ...
                |          objThisIntf.AppListPotentialDataobjArg1,objArg2

        :param SchListOfBSTRs i_l_app_data:
        :param SchListOfBSTRs i_l_app_nls_data:
        :rtype: None
        """
        return self.sch_app_cntr_data.AppListPotentialData(i_l_app_data.com_object, i_l_app_nls_data.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_list_potential_data'
        # # vba_code = """
        # # Public Function app_list_potential_data(sch_app_cntr_data)
        # #     Dim iLAppData (2)
        # #     sch_app_cntr_data.AppListPotentialData iLAppData
        # #     app_list_potential_data = iLAppData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def app_set_application_data(self, i_l_app_data: SchListOfBSTRs) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppSetApplicationData(SchListOfBSTRs iLAppData)
                | 
                |     Set application data.
                | 
                |     Parameters:
                | 
                |         iLAppData
                |             A list of character string data. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrData
                |          Dim objArg1 As SchListOfBSTRs
                |           ...
                |          objThisIntf.AppSetApplicationDataobjArg1

        :param SchListOfBSTRs i_l_app_data:
        :rtype: None
        """
        return self.sch_app_cntr_data.AppSetApplicationData(i_l_app_data.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_set_application_data'
        # # vba_code = """
        # # Public Function app_set_application_data(sch_app_cntr_data)
        # #     Dim iLAppData (2)
        # #     sch_app_cntr_data.AppSetApplicationData iLAppData
        # #     app_set_application_data = iLAppData
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppCntrData(name="{self.name}")'
