#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""

from pycatia.system_interfaces.any_object import AnyObject


class SchAppCntrShow(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppCntrShow
                | 
                | Manage graphical representation of schematic connector.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_cntr_show = com_object

    def app_show_cntr(self, o_b_show: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppShowCntr(boolean oBShow)
                | 
                |     Defines show status of the applicaton connector.
                | 
                |     Parameters:
                | 
                |         oBShow
                |             True if the connector show status is Show. False if the connector
                |             show status is NoShow. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppCntrShow
                |          Dim bVar1 As boolean
                |           ...
                |          objThisIntf.AppShowCntrbVar1

        :param bool o_b_show:
        :rtype: None
        """
        return self.sch_app_cntr_show.AppShowCntr(o_b_show)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_show_cntr'
        # # vba_code = """
        # # Public Function app_show_cntr(sch_app_cntr_show)
        # #     Dim oBShow (2)
        # #     sch_app_cntr_show.AppShowCntr oBShow
        # #     app_show_cntr = oBShow
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppCntrShow(name="{self.name}")'
