#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.in_interfaces.document import Document
from pycatia.system_interfaces.any_object import AnyObject


class SchAppModelInit(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchAppModelInit
                | 
                | Manage the initialization of application model.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_app_model_init = com_object

    def app_init(self, i_doc: Document) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub AppInit(Document iDoc)
                | 
                |     Initialize application model.
                | 
                |     Parameters:
                | 
                |         iDoc
                |             Pointer to the document concerned. 
                | 
                |     Example:
                | 
                |           
                | 
                |          Dim objThisIntf As SchAppModelInit
                |          Dim objArg1 As Document
                |           ...
                |          objThisIntf.AppInitobjArg1

        :param Document i_doc:
        :rtype: None
        """
        return self.sch_app_model_init.AppInit(i_doc.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'app_init'
        # # vba_code = """
        # # Public Function app_init(sch_app_model_init)
        # #     Dim iDoc (2)
        # #     sch_app_model_init.AppInit iDoc
        # #     app_init = iDoc
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchAppModelInit(name="{self.name}")'
