#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_grr import SchGRR
from pycatia.cat_sch_platform_interfaces.sch_route import SchRoute
from pycatia.system_interfaces.any_object import AnyObject


class SchCatalogRoute(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchCatalogRoute
                | 
                | Manage a schematic route catalog.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_catalog_route = com_object

    def query_drop_ability(self, o_b_yes: bool, o_route_ref: SchRoute, o_pointed_to_grr: SchGRR) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub QueryDropAbility(boolean oBYes,
                | SchRoute oRouteRef,
                | SchGRR oPointedToGRR)
                | 
                |     Check to see if it is OK to be dropped to the current
                |     document.
                | 
                |     Parameters:
                | 
                |         oBYes
                |             If TRUE, then it is OK to be dropped. 
                |         oRouteRef
                |             Route reference. 
                |         oPointedToGRR
                |             Graphical representation of a route pointed-to by the catalog
                |             component 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCatalogRoute
                |          Dim bVar1 As boolean
                |          Dim objArg2 As SchRoute
                |          Dim objArg3 As SchGRR
                |           ...
                |          objThisIntf.QueryDropAbilitybVar1,objArg2,objArg3

        :param bool o_b_yes:
        :param SchRoute o_route_ref:
        :param SchGRR o_pointed_to_grr:
        :rtype: None
        """
        return self.sch_catalog_route.QueryDropAbility(o_b_yes, o_route_ref.com_object, o_pointed_to_grr.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'query_drop_ability'
        # # vba_code = """
        # # Public Function query_drop_ability(sch_catalog_route)
        # #     Dim oBYes (2)
        # #     sch_catalog_route.QueryDropAbility oBYes
        # #     query_drop_ability = oBYes
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchCatalogRoute(name="{self.name}")'
