#! usr/bin/python3.9
"""
    Module initially auto generated using V5Automation files from CATIA V5 R28 on 2020-09-25 14:34:21.593357

    .. warning::
        The notes denoted "CAA V5 Visual Basic Help" are to be used as reference only.
        They are there as a guide as to how the visual basic / catscript functions work
        and thus help debugging in pycatia.
        
"""
from pycatia.cat_sch_platform_interfaces.sch_grr_cntr import SchGRRCntr
from pycatia.cat_sch_platform_interfaces.sch_list_of_doubles import SchListOfDoubles
from pycatia.system_interfaces.any_object import AnyObject


class SchCntrConnect(AnyObject):
    """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357)

                | System.IUnknown
                |     System.IDispatch
                |         System.CATBaseUnknown
                |             System.CATBaseDispatch
                |                 System.AnyObject
                |                     SchCntrConnect
                | 
                | Manage the a schematic connector.
    
    """

    def __init__(self, com_object):
        super().__init__(com_object)
        self.sch_cntr_connect = com_object

    def get_transform_matrix(self, i_grr_cntr: SchGRRCntr, o_db6_matrix: SchListOfDoubles) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub GetTransformMatrix(SchGRRCntr iGRRCntr,
                | SchListOfDoubles oDb6Matrix)
                | 
                |     Get the transformation matrix needed to transform 'this' connector to be
                |     coincident and aligned with the 'connect to' connector. NOTE: "alignment" in
                |     this context means that the connectors' alignment vectors are facing opposite
                |     directions.
                | 
                |     Parameters:
                | 
                |         iGRRCntr
                |             Pointer to the image of the 'connect to' connector.
                |             
                |         oDb6Matrix
                |             Transformation matrix. for explanation of this argument.
                |             
                |     Example:
                |
                |          Dim objThisIntf As SchCntrConnect
                |          Dim objArg1 As SchGRRCntr
                |          Dim objArg2 As SchListOfDoubles
                |           ...
                |          objThisIntf.GetTransformMatrixobjArg1,objArg2

        :param SchGRRCntr i_grr_cntr:
        :param SchListOfDoubles o_db6_matrix:
        :rtype: None
        """
        return self.sch_cntr_connect.GetTransformMatrix(i_grr_cntr.com_object, o_db6_matrix.com_object)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'get_transform_matrix'
        # # vba_code = """
        # # Public Function get_transform_matrix(sch_cntr_connect)
        # #     Dim iGRRCntr (2)
        # #     sch_cntr_connect.GetTransformMatrix iGRRCntr
        # #     get_transform_matrix = iGRRCntr
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def ok_to_connect(self, i_grr_cntr: SchGRRCntr, o_b_yes: bool) -> None:
        """
        .. note::
            :class: toggle

            CAA V5 Visual Basic Help (2020-09-25 14:34:21.593357))
                | o Sub OKToConnect(SchGRRCntr iGRRCntr,
                | boolean oBYes)
                | 
                |     Query whether 'this' connector can be connected to the specified connector,
                |     that is, whether their positions are coincident.
                | 
                |     Parameters:
                | 
                |         iGRRCntr
                |             Pointer to the image of the 'connect to' connector.
                |             
                |         oBYes
                |             If TRUE, then it is OK to connect. 
                | 
                |     Example:
                |
                |          Dim objThisIntf As SchCntrConnect
                |          Dim objArg1 As SchGRRCntr
                |          Dim bVar2 As boolean
                |           ...
                |          objThisIntf.OKToConnectobjArg1,bVar2

        :param SchGRRCntr i_grr_cntr:
        :param bool o_b_yes:
        :rtype: None
        """
        return self.sch_cntr_connect.OKToConnect(i_grr_cntr.com_object, o_b_yes)
        # # # # Autogenerated comment: 
        # # some methods require a system service call as the methods expects a vb array object
        # # passed to it and there is no way to do this directly with python. In those cases the following code
        # # should be uncommented and edited accordingly. Otherwise completely remove all this.
        # # vba_function_name = 'ok_to_connect'
        # # vba_code = """
        # # Public Function ok_to_connect(sch_cntr_connect)
        # #     Dim iGRRCntr (2)
        # #     sch_cntr_connect.OKToConnect iGRRCntr
        # #     ok_to_connect = iGRRCntr
        # # End Function
        # # """

        # # system_service = SystemService(self.application.SystemService)
        # # return system_service.evaluate(vba_code, 0, vba_function_name, [self.com_object])

    def __repr__(self):
        return f'SchCntrConnect(name="{self.name}")'
